"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(originId, props) {
        this.props = props;
        this.originId = originId;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c, _d;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.originId,
            allowedMethods: (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods,
            cachedMethods: (_b = this.props.cachedMethods) === null || _b === void 0 ? void 0 : _b.methods,
            compress: this.props.compress,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            smoothStreaming: this.props.smoothStreaming,
            viewerProtocolPolicy: (_d = this.props.viewerProtocolPolicy) !== null && _d !== void 0 ? _d : distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
            lambdaFunctionAssociations: this.props.edgeLambdas
                ? this.props.edgeLambdas.map(edgeLambda => ({
                    lambdaFunctionArn: edgeLambda.functionVersion.edgeArn,
                    eventType: edgeLambda.eventType.toString(),
                }))
                : undefined,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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