import { Construct, Resource } from "../../core";
import { IAutoScalingGroup } from './auto-scaling-group';
import { Schedule } from './schedule';
/**
 * Properties for a scheduled scaling action
 */
export interface BasicScheduledActionProps {
    /**
     * When to perform this action.
     *
     * Supports cron expressions.
     *
     * For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
     *
     * @example 0 8 * * ?
     */
    readonly schedule: Schedule;
    /**
     * When this scheduled action becomes active.
     *
     * @default - The rule is activate immediately.
     */
    readonly startTime?: Date;
    /**
     * When this scheduled action expires.
     *
     * @default - The rule never expires.
     */
    readonly endTime?: Date;
    /**
     * The new minimum capacity.
     *
     * At the scheduled time, set the minimum capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new minimum capacity.
     */
    readonly minCapacity?: number;
    /**
     * The new maximum capacity.
     *
     * At the scheduled time, set the maximum capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new maximum capacity.
     */
    readonly maxCapacity?: number;
    /**
     * The new desired capacity.
     *
     * At the scheduled time, set the desired capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new desired capacity.
     */
    readonly desiredCapacity?: number;
}
/**
 * Properties for a scheduled action on an AutoScalingGroup
 */
export interface ScheduledActionProps extends BasicScheduledActionProps {
    /**
     * The AutoScalingGroup to apply the scheduled actions to
     */
    readonly autoScalingGroup: IAutoScalingGroup;
}
/**
 * Define a scheduled scaling action
 */
export declare class ScheduledAction extends Resource {
    constructor(scope: Construct, id: string, props: ScheduledActionProps);
}
