"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
    }
    bind(scope, lifecycleHook) {
        var _a;
        const topic = new sns.Topic(scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        (_a = this.encryptionKey) === null || _a === void 0 ? void 0 : _a.grant(lifecycleHook.role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(scope, lifecycleHook);
    }
}
exports.FunctionHook = FunctionHook;
//# sourceMappingURL=data:application/json;base64,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