"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Type = exports.Directive = void 0;
/**
 * Directives for types
 *
 * i.e. @aws_iam or @aws_subscribe
 *
 * @experimental
 */
class Directive {
    constructor(statement) { this.statement = statement; }
    /**
     * Add the @aws_iam directive
     */
    static iam() {
        return new Directive('@aws_iam');
    }
    /**
     * Add a custom directive
     *
     * @param statement - the directive statement to append
     */
    static custom(statement) {
        return new Directive(statement);
    }
}
exports.Directive = Directive;
/**
 * Enum containing the Types that can be used to define ObjectTypes
 */
var Type;
(function (Type) {
    /**
     * `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     */
    Type["ID"] = "ID";
    /**
     * `String` scalar type is a free-form human-readable text.
     */
    Type["STRING"] = "String";
    /**
     * `Int` scalar type is a signed non-fractional numerical value.
     */
    Type["INT"] = "Int";
    /**
     * `Float` scalar type is a signed double-precision fractional value.
     */
    Type["FLOAT"] = "Float";
    /**
     * `Boolean` scalar type is a boolean value: true or false.
     */
    Type["BOOLEAN"] = "Boolean";
    /**
     * `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Calendar_dates
     */
    Type["AWS_DATE"] = "AWSDate";
    /**
     * `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     */
    Type["AWS_TIME"] = "AWSTime";
    /**
     * `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Combined_date_and_time_representations
     */
    Type["AWS_DATE_TIME"] = "AWSDateTime";
    /**
     * `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     */
    Type["AWS_TIMESTAMP"] = "AWSTimestamp";
    /**
     * `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`)
     */
    Type["AWS_EMAIL"] = "AWSEmail";
    /**
     * `AWSJson` scalar type represents a JSON string.
     */
    Type["AWS_JSON"] = "AWSJSON";
    /**
     * `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     */
    Type["AWS_URL"] = "AWSURL";
    /**
     * `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     */
    Type["AWS_PHONE"] = "AWSPhone";
    /**
     * `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     */
    Type["AWS_IP_ADDRESS"] = "AWSIPAddress";
    /**
     * Type used for Intermediate Types
     * (i.e. an interface or an object type)
     */
    Type["INTERMEDIATE"] = "INTERMEDIATE";
})(Type = exports.Type || (exports.Type = {}));
//# sourceMappingURL=data:application/json;base64,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