"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphqlApiBase = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const data_source_1 = require("./data-source");
/**
 * Base Class for GraphQL API
 */
class GraphqlApiBase extends core_1.Resource {
    /**
     * add a new dummy data source to this API. Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id
     * @param options The optional configuration for this data source
     */
    addNoneDataSource(id, options) {
        return new data_source_1.NoneDataSource(this, id, {
            api: this,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * add a new DynamoDB data source to this API
     *
     * @param id The data source's id
     * @param table The DynamoDB table backing this data source
     * @param options The optional configuration for this data source
     */
    addDynamoDbDataSource(id, table, options) {
        return new data_source_1.DynamoDbDataSource(this, id, {
            api: this,
            table,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * add a new http data source to this API
     *
     * @param id The data source's id
     * @param endpoint The http endpoint
     * @param options The optional configuration for this data source
     */
    addHttpDataSource(id, endpoint, options) {
        return new data_source_1.HttpDataSource(this, id, {
            api: this,
            endpoint,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * add a new Lambda data source to this API
     *
     * @param id The data source's id
     * @param lambdaFunction The Lambda function to call to interact with this data source
     * @param options The optional configuration for this data source
     */
    addLambdaDataSource(id, lambdaFunction, options) {
        return new data_source_1.LambdaDataSource(this, id, {
            api: this,
            lambdaFunction,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * Add schema dependency if not imported
     *
     * @param construct the dependee
     */
    addSchemaDependency(construct) {
        construct;
        return false;
    }
}
exports.GraphqlApiBase = GraphqlApiBase;
//# sourceMappingURL=data:application/json;base64,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