"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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