"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUuid = exports.toJson_KeepersDefinition = exports.toJson_CfnUuidProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUuidProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUuidProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Keepers': obj.keepers?.map(y => toJson_KeepersDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUuidProps = toJson_CfnUuidProps;
/**
 * Converts an object of type 'KeepersDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_KeepersDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_KeepersDefinition = toJson_KeepersDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::Random::Uuid`
 *
 * @cloudformationResource TF::Random::Uuid
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnUuid extends cdk.CfnResource {
    /**
     * Create a new `TF::Random::Uuid`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUuid.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUuidProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrResult = cdk.Token.asString(this.getAtt('Result'));
    }
}
exports.CfnUuid = CfnUuid;
_a = JSII_RTTI_SYMBOL_1;
CfnUuid[_a] = { fqn: "@cdk-cloudformation/tf-random-uuid.CfnUuid", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUuid.CFN_RESOURCE_TYPE_NAME = "TF::Random::Uuid";
//# sourceMappingURL=data:application/json;base64,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