import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CloudFormation equivalent of random_uuid
 *
 * @schema CfnUuidProps
 */
export interface CfnUuidProps {
    /**
     * @schema CfnUuidProps#Keepers
     */
    readonly keepers?: KeepersDefinition[];
}
/**
 * Converts an object of type 'CfnUuidProps' to JSON representation.
 */
export declare function toJson_CfnUuidProps(obj: CfnUuidProps | undefined): Record<string, any> | undefined;
/**
 * @schema KeepersDefinition
 */
export interface KeepersDefinition {
    /**
     * @schema KeepersDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema KeepersDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'KeepersDefinition' to JSON representation.
 */
export declare function toJson_KeepersDefinition(obj: KeepersDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::Random::Uuid`
 *
 * @cloudformationResource TF::Random::Uuid
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnUuid extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::Random::Uuid";
    /**
     * Resource props.
     */
    readonly props: CfnUuidProps;
    /**
     * Attribute `TF::Random::Uuid.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::Random::Uuid.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::Random::Uuid.Result`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrResult: string;
    /**
     * Create a new `TF::Random::Uuid`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUuidProps);
}
