# QT4i 
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)
[![Build Status](https://travis-ci.org/Tencent/QT4i.svg?branch=master)](https://travis-ci.org/Tencent/QT4i)
[![PyPi version](https://img.shields.io/pypi/v/qt4i.svg)](https://pypi.python.org/pypi/qt4i/) 
[![Documentation Status](https://readthedocs.org/projects/qt4i/badge/?version=latest)](https://qt4i.readthedocs.io/zh_CN/latest/?badge=latest)
[![GitHub tag](https://img.shields.io/github/tag/Tencent/QT4i.svg)](https://GitHub.com/Tencent/QT4i/tags/)

 
QT4i (Quick Test for iOS) is a QTA test automation driver for iOS application.
 
### Features
 * Easy to use, only Apple developer certificate is needed, no jailbreak or test stub is required
 * Support native, web and custom controls with Accessibility
 * Support iOS device and simulator, and multiple devices can be used simultaneously in a test
 * Low maintenance costs with QTA UI test automation framework
 
QT4i should be used with [QTAF](https://github.com/Tencent/QTAF), please check it first.

### Get Started
Check out our [Usage Document](https://qt4i.readthedocs.io/zh_CN/latest/) to get going with QT4i. There is also [sample code](https://github.com/qtacore/QT4iDemoProj) that shows how to run testcase with QT4i.

### Anatomy
If you are interested in anatomy of QT4i, the [Design Document](https://github.com/Tencent/QT4i/blob/master/design.md) may be useful to you.
 
------------------------------
 
QT4i(Quick Test for iOS)，基于QTA提供面向iOS应用的UI测试自动化测试解决方案。
 
### 主要特性
 * 轻松易用——无需越狱，无需插桩，只要是开发者证书编译的版本即可进行测试
 * 强大引擎——支持iOS Native控件、webview控件和自定义控件
 * 平台支持——全面兼容iOS真机和模拟器，基于分布式技术，高效并发执行测试
 * 高效维护——基于QPath技术和[QTAF](https://github.com/Tencent/QTAF)UI框架，降低产品变化的脚本维护投入
   
QT4i需要和[QTAF](https://github.com/Tencent/QTAF)一起使用，请先参考QTAF的使用

### 入门指南
请查看我们的[使用文档](https://qt4i.readthedocs.io/zh_CN/latest/)以便您快速上手QT4i，同时可以参考我们的[示例代码](https://github.com/qtacore/QT4iDemoProj)。

### 框架原理
如果你对QT4i的实现原理感兴趣，可以参考我们的[设计文档](https://github.com/Tencent/QT4i/blob/master/design.md)。

------------------------------

欢迎加入QQ群（432699528）交流使用和反馈

![image](https://github.com/Tencent/QTAF/blob/master/docs/misc/qq_group.png)
