# pulp_ansible-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.2.0b14
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import pulpcore.client.pulp_ansible
from pulpcore.client.pulp_ansible.rest import ApiException
from pprint import pprint

configuration = pulpcore.client.pulp_ansible.Configuration()
# Configure HTTP basic authorization: Basic
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://pulp
configuration.host = "http://pulp"
# Enter a context with an instance of the API client
with pulpcore.client.pulp_ansible.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_ansible.AnsibleCollectionsApi(api_client)
    ordering = 'ordering_example' # str | Which field to use when ordering the results. (optional)
namespace = 'namespace_example' # str |  (optional)
name = 'name_example' # str |  (optional)
limit = 56 # int | Number of results to return per page. (optional)
offset = 56 # int | The initial index from which to return the results. (optional)
fields = 'fields_example' # str | A list of fields to include in the response. (optional)
exclude_fields = 'exclude_fields_example' # str | A list of fields to exclude from the response. (optional)

    try:
        # List collections
        api_response = api_instance.list(ordering=ordering, namespace=namespace, name=name, limit=limit, offset=offset, fields=fields, exclude_fields=exclude_fields)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnsibleCollectionsApi->list: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnsibleCollectionsApi* | [**list**](docs/AnsibleCollectionsApi.md#list) | **GET** /pulp/api/v3/ansible/collections/ | List collections
*AnsibleCollectionsApi* | [**upload_collection**](docs/AnsibleCollectionsApi.md#upload_collection) | **POST** /ansible/collections/ | Upload a collection
*ContentCollectionVersionsApi* | [**create**](docs/ContentCollectionVersionsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_versions/ | Create a collection version
*ContentCollectionVersionsApi* | [**list**](docs/ContentCollectionVersionsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_versions/ | List collection versions
*ContentCollectionVersionsApi* | [**read**](docs/ContentCollectionVersionsApi.md#read) | **GET** {collection_version_href} | Inspect a collection version
*ContentRolesApi* | [**create**](docs/ContentRolesApi.md#create) | **POST** /pulp/api/v3/content/ansible/roles/ | Create a role
*ContentRolesApi* | [**list**](docs/ContentRolesApi.md#list) | **GET** /pulp/api/v3/content/ansible/roles/ | List roles
*ContentRolesApi* | [**read**](docs/ContentRolesApi.md#read) | **GET** {role_href} | Inspect a role
*DistributionsAnsibleApi* | [**create**](docs/DistributionsAnsibleApi.md#create) | **POST** /pulp/api/v3/distributions/ansible/ansible/ | Create an ansible distribution
*DistributionsAnsibleApi* | [**delete**](docs/DistributionsAnsibleApi.md#delete) | **DELETE** {ansible_distribution_href} | Delete an ansible distribution
*DistributionsAnsibleApi* | [**list**](docs/DistributionsAnsibleApi.md#list) | **GET** /pulp/api/v3/distributions/ansible/ansible/ | List ansible distributions
*DistributionsAnsibleApi* | [**partial_update**](docs/DistributionsAnsibleApi.md#partial_update) | **PATCH** {ansible_distribution_href} | Partially update an ansible distribution
*DistributionsAnsibleApi* | [**read**](docs/DistributionsAnsibleApi.md#read) | **GET** {ansible_distribution_href} | Inspect an ansible distribution
*DistributionsAnsibleApi* | [**update**](docs/DistributionsAnsibleApi.md#update) | **PUT** {ansible_distribution_href} | Update an ansible distribution
*PulpAnsibleApiApi* | [**list**](docs/PulpAnsibleApiApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**create**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v2/collections/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**list**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v2/collections/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**list_0**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#list_0) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**read**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#read) | **GET** {collection_href} | 
*PulpAnsibleGalaxyApiRolesApi* | [**list**](docs/PulpAnsibleGalaxyApiRolesApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v1/roles/ | 
*PulpAnsibleGalaxyApiV1VersionsApi* | [**list**](docs/PulpAnsibleGalaxyApiV1VersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v1/roles/{role_pk}/versions/ | 
*PulpAnsibleGalaxyApiV2VersionsApi* | [**list**](docs/PulpAnsibleGalaxyApiV2VersionsApi.md#list) | **GET** {collection_href}versions/ | 
*PulpAnsibleGalaxyApiV3CollectionsApi* | [**create**](docs/PulpAnsibleGalaxyApiV3CollectionsApi.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleGalaxyApiV3CollectionsApi* | [**read**](docs/PulpAnsibleGalaxyApiV3CollectionsApi.md#read) | **GET** {collection_import_href} | Inspect a collection import
*PulpAnsibleTagsApi* | [**list**](docs/PulpAnsibleTagsApi.md#list) | **GET** /pulp/api/v3/pulp_ansible/tags/ | List tags
*RemotesAnsibleApi* | [**create**](docs/RemotesAnsibleApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/ansible/ | Create an ansible remote
*RemotesAnsibleApi* | [**delete**](docs/RemotesAnsibleApi.md#delete) | **DELETE** {ansible_remote_href} | Delete an ansible remote
*RemotesAnsibleApi* | [**list**](docs/RemotesAnsibleApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/ansible/ | List ansible remotes
*RemotesAnsibleApi* | [**partial_update**](docs/RemotesAnsibleApi.md#partial_update) | **PATCH** {ansible_remote_href} | Partially update an ansible remote
*RemotesAnsibleApi* | [**read**](docs/RemotesAnsibleApi.md#read) | **GET** {ansible_remote_href} | Inspect an ansible remote
*RemotesAnsibleApi* | [**update**](docs/RemotesAnsibleApi.md#update) | **PUT** {ansible_remote_href} | Update an ansible remote
*RemotesCollectionApi* | [**create**](docs/RemotesCollectionApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/collection/ | Create a collection remote
*RemotesCollectionApi* | [**delete**](docs/RemotesCollectionApi.md#delete) | **DELETE** {collection_remote_href} | Delete a collection remote
*RemotesCollectionApi* | [**list**](docs/RemotesCollectionApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/collection/ | List collection remotes
*RemotesCollectionApi* | [**partial_update**](docs/RemotesCollectionApi.md#partial_update) | **PATCH** {collection_remote_href} | Partially update a collection remote
*RemotesCollectionApi* | [**read**](docs/RemotesCollectionApi.md#read) | **GET** {collection_remote_href} | Inspect a collection remote
*RemotesCollectionApi* | [**update**](docs/RemotesCollectionApi.md#update) | **PUT** {collection_remote_href} | Update a collection remote
*RepositoriesAnsibleApi* | [**create**](docs/RepositoriesAnsibleApi.md#create) | **POST** /pulp/api/v3/repositories/ansible/ansible/ | Create an ansible repository
*RepositoriesAnsibleApi* | [**delete**](docs/RepositoriesAnsibleApi.md#delete) | **DELETE** {ansible_repository_href} | Delete an ansible repository
*RepositoriesAnsibleApi* | [**list**](docs/RepositoriesAnsibleApi.md#list) | **GET** /pulp/api/v3/repositories/ansible/ansible/ | List ansible repositorys
*RepositoriesAnsibleApi* | [**modify**](docs/RepositoriesAnsibleApi.md#modify) | **POST** {ansible_repository_href}modify/ | Modify Repository Content
*RepositoriesAnsibleApi* | [**partial_update**](docs/RepositoriesAnsibleApi.md#partial_update) | **PATCH** {ansible_repository_href} | Partially update an ansible repository
*RepositoriesAnsibleApi* | [**read**](docs/RepositoriesAnsibleApi.md#read) | **GET** {ansible_repository_href} | Inspect an ansible repository
*RepositoriesAnsibleApi* | [**sync**](docs/RepositoriesAnsibleApi.md#sync) | **POST** {ansible_repository_href}sync/ | 
*RepositoriesAnsibleApi* | [**update**](docs/RepositoriesAnsibleApi.md#update) | **PUT** {ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleVersionsApi* | [**delete**](docs/RepositoriesAnsibleVersionsApi.md#delete) | **DELETE** {ansible_repository_version_href} | Delete a repository version
*RepositoriesAnsibleVersionsApi* | [**list**](docs/RepositoriesAnsibleVersionsApi.md#list) | **GET** {ansible_repository_href}versions/ | List repository versions
*RepositoriesAnsibleVersionsApi* | [**read**](docs/RepositoriesAnsibleVersionsApi.md#read) | **GET** {ansible_repository_version_href} | Inspect a repository version
*RepositoriesAnsibleVersionsApi* | [**repair**](docs/RepositoriesAnsibleVersionsApi.md#repair) | **POST** {ansible_repository_version_href}repair/ | 


## Documentation For Models

 - [AnsibleAnsibleDistribution](docs/AnsibleAnsibleDistribution.md)
 - [AnsibleAnsibleDistributionRead](docs/AnsibleAnsibleDistributionRead.md)
 - [AnsibleAnsibleRemote](docs/AnsibleAnsibleRemote.md)
 - [AnsibleAnsibleRemoteRead](docs/AnsibleAnsibleRemoteRead.md)
 - [AnsibleAnsibleRepository](docs/AnsibleAnsibleRepository.md)
 - [AnsibleAnsibleRepositoryRead](docs/AnsibleAnsibleRepositoryRead.md)
 - [AnsibleCollectionRead](docs/AnsibleCollectionRead.md)
 - [AnsibleCollectionRemote](docs/AnsibleCollectionRemote.md)
 - [AnsibleCollectionRemoteRead](docs/AnsibleCollectionRemoteRead.md)
 - [AnsibleCollectionVersion](docs/AnsibleCollectionVersion.md)
 - [AnsibleCollectionVersionRead](docs/AnsibleCollectionVersionRead.md)
 - [AnsibleRole](docs/AnsibleRole.md)
 - [AnsibleRoleRead](docs/AnsibleRoleRead.md)
 - [AnsibleTag](docs/AnsibleTag.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [Collection](docs/Collection.md)
 - [CollectionImportDetailRead](docs/CollectionImportDetailRead.md)
 - [CollectionMetadata](docs/CollectionMetadata.md)
 - [CollectionNamespace](docs/CollectionNamespace.md)
 - [CollectionRead](docs/CollectionRead.md)
 - [CollectionRef](docs/CollectionRef.md)
 - [CollectionVersion](docs/CollectionVersion.md)
 - [CollectionVersionRead](docs/CollectionVersionRead.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [GalaxyCollection](docs/GalaxyCollection.md)
 - [GalaxyCollectionRead](docs/GalaxyCollectionRead.md)
 - [GalaxyCollectionVersionRead](docs/GalaxyCollectionVersionRead.md)
 - [GalaxyRoleRead](docs/GalaxyRoleRead.md)
 - [GalaxyRoleVersionRead](docs/GalaxyRoleVersionRead.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RepositoryVersionRead](docs/RepositoryVersionRead.md)
 - [TagRead](docs/TagRead.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Author




