# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import lilt
from lilt.models.segment_with_comments import SegmentWithComments  # noqa: E501
from lilt.rest import ApiException

class TestSegmentWithComments(unittest.TestCase):
    """SegmentWithComments unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test SegmentWithComments
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = lilt.models.segment_with_comments.SegmentWithComments()  # noqa: E501
        if include_optional :
            return SegmentWithComments(
                id = 84480010, 
                created_at = 1489147692, 
                updated_at = 1489147692, 
                document_id = 1234, 
                memory_id = 5678, 
                source = 'The red bus.', 
                srclang = 'en', 
                target = 'Le bus rouge.', 
                trglang = 'fr', 
                is_confirmed = True, 
                is_reviewed = True, 
                comments = [
                    lilt.models.comment.Comment(
                        id = 84480010, 
                        text = 'This is incorrect.', 
                        user_id = 5678, 
                        is_resolved = True, 
                        annotations = [
                            lilt.models.annotation.Annotation(
                                text = 'minor', )
                            ], 
                        created_at = 1489147692, )
                    ]
            )
        else :
            return SegmentWithComments(
        )

    def testSegmentWithComments(self):
        """Test SegmentWithComments"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
