# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class LexiconEntryExamples(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source': 'str',
        'source_delimiters': 'list[str]',
        'target': 'str',
        'target_delimiters': 'list[str]',
        'source_span': 'LexiconEntrySourceSpan',
        'target_span': 'LexiconEntryTargetSpan',
        'similarity': 'float',
        'memory_id': 'float'
    }

    attribute_map = {
        'source': 'source',
        'source_delimiters': 'sourceDelimiters',
        'target': 'target',
        'target_delimiters': 'targetDelimiters',
        'source_span': 'sourceSpan',
        'target_span': 'targetSpan',
        'similarity': 'similarity',
        'memory_id': 'memory_id'
    }

    def __init__(self, source=None, source_delimiters=None, target=None, target_delimiters=None, source_span=None, target_span=None, similarity=None, memory_id=None, local_vars_configuration=None):  # noqa: E501
        """LexiconEntryExamples - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source = None
        self._source_delimiters = None
        self._target = None
        self._target_delimiters = None
        self._source_span = None
        self._target_span = None
        self._similarity = None
        self._memory_id = None
        self.discriminator = None

        if source is not None:
            self.source = source
        if source_delimiters is not None:
            self.source_delimiters = source_delimiters
        if target is not None:
            self.target = target
        if target_delimiters is not None:
            self.target_delimiters = target_delimiters
        if source_span is not None:
            self.source_span = source_span
        if target_span is not None:
            self.target_span = target_span
        if similarity is not None:
            self.similarity = similarity
        if memory_id is not None:
            self.memory_id = memory_id

    @property
    def source(self):
        """Gets the source of this LexiconEntryExamples.  # noqa: E501

        The source string.  # noqa: E501

        :return: The source of this LexiconEntryExamples.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this LexiconEntryExamples.

        The source string.  # noqa: E501

        :param source: The source of this LexiconEntryExamples.  # noqa: E501
        :type: str
        """

        self._source = source

    @property
    def source_delimiters(self):
        """Gets the source_delimiters of this LexiconEntryExamples.  # noqa: E501

        A format string that indicates, for each word, if the source word should be preceded by a space.   # noqa: E501

        :return: The source_delimiters of this LexiconEntryExamples.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_delimiters

    @source_delimiters.setter
    def source_delimiters(self, source_delimiters):
        """Sets the source_delimiters of this LexiconEntryExamples.

        A format string that indicates, for each word, if the source word should be preceded by a space.   # noqa: E501

        :param source_delimiters: The source_delimiters of this LexiconEntryExamples.  # noqa: E501
        :type: list[str]
        """

        self._source_delimiters = source_delimiters

    @property
    def target(self):
        """Gets the target of this LexiconEntryExamples.  # noqa: E501

        The target string  # noqa: E501

        :return: The target of this LexiconEntryExamples.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this LexiconEntryExamples.

        The target string  # noqa: E501

        :param target: The target of this LexiconEntryExamples.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def target_delimiters(self):
        """Gets the target_delimiters of this LexiconEntryExamples.  # noqa: E501

        A format string that indicates, for each word, if the target word should be preceded by a space.   # noqa: E501

        :return: The target_delimiters of this LexiconEntryExamples.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_delimiters

    @target_delimiters.setter
    def target_delimiters(self, target_delimiters):
        """Sets the target_delimiters of this LexiconEntryExamples.

        A format string that indicates, for each word, if the target word should be preceded by a space.   # noqa: E501

        :param target_delimiters: The target_delimiters of this LexiconEntryExamples.  # noqa: E501
        :type: list[str]
        """

        self._target_delimiters = target_delimiters

    @property
    def source_span(self):
        """Gets the source_span of this LexiconEntryExamples.  # noqa: E501


        :return: The source_span of this LexiconEntryExamples.  # noqa: E501
        :rtype: LexiconEntrySourceSpan
        """
        return self._source_span

    @source_span.setter
    def source_span(self, source_span):
        """Sets the source_span of this LexiconEntryExamples.


        :param source_span: The source_span of this LexiconEntryExamples.  # noqa: E501
        :type: LexiconEntrySourceSpan
        """

        self._source_span = source_span

    @property
    def target_span(self):
        """Gets the target_span of this LexiconEntryExamples.  # noqa: E501


        :return: The target_span of this LexiconEntryExamples.  # noqa: E501
        :rtype: LexiconEntryTargetSpan
        """
        return self._target_span

    @target_span.setter
    def target_span(self, target_span):
        """Sets the target_span of this LexiconEntryExamples.


        :param target_span: The target_span of this LexiconEntryExamples.  # noqa: E501
        :type: LexiconEntryTargetSpan
        """

        self._target_span = target_span

    @property
    def similarity(self):
        """Gets the similarity of this LexiconEntryExamples.  # noqa: E501


        :return: The similarity of this LexiconEntryExamples.  # noqa: E501
        :rtype: float
        """
        return self._similarity

    @similarity.setter
    def similarity(self, similarity):
        """Sets the similarity of this LexiconEntryExamples.


        :param similarity: The similarity of this LexiconEntryExamples.  # noqa: E501
        :type: float
        """

        self._similarity = similarity

    @property
    def memory_id(self):
        """Gets the memory_id of this LexiconEntryExamples.  # noqa: E501

        A unique Memory identifier. If this identifier is missing, then the term comes from the generic concordance.   # noqa: E501

        :return: The memory_id of this LexiconEntryExamples.  # noqa: E501
        :rtype: float
        """
        return self._memory_id

    @memory_id.setter
    def memory_id(self, memory_id):
        """Sets the memory_id of this LexiconEntryExamples.

        A unique Memory identifier. If this identifier is missing, then the term comes from the generic concordance.   # noqa: E501

        :param memory_id: The memory_id of this LexiconEntryExamples.  # noqa: E501
        :type: float
        """

        self._memory_id = memory_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LexiconEntryExamples):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LexiconEntryExamples):
            return True

        return self.to_dict() != other.to_dict()
