# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class DocumentAssignmentParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'email': 'str',
        'is_translator': 'bool',
        'is_reviewer': 'bool',
        'due_date': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'email': 'email',
        'is_translator': 'is_translator',
        'is_reviewer': 'is_reviewer',
        'due_date': 'due_date'
    }

    def __init__(self, id=None, email=None, is_translator=None, is_reviewer=None, due_date=None, local_vars_configuration=None):  # noqa: E501
        """DocumentAssignmentParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._email = None
        self._is_translator = None
        self._is_reviewer = None
        self._due_date = None
        self.discriminator = None

        self.id = id
        self.email = email
        if is_translator is not None:
            self.is_translator = is_translator
        if is_reviewer is not None:
            self.is_reviewer = is_reviewer
        if due_date is not None:
            self.due_date = due_date

    @property
    def id(self):
        """Gets the id of this DocumentAssignmentParameters.  # noqa: E501

        A unique Document identifier.  # noqa: E501

        :return: The id of this DocumentAssignmentParameters.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DocumentAssignmentParameters.

        A unique Document identifier.  # noqa: E501

        :param id: The id of this DocumentAssignmentParameters.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def email(self):
        """Gets the email of this DocumentAssignmentParameters.  # noqa: E501

        An email address.  # noqa: E501

        :return: The email of this DocumentAssignmentParameters.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this DocumentAssignmentParameters.

        An email address.  # noqa: E501

        :param email: The email of this DocumentAssignmentParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def is_translator(self):
        """Gets the is_translator of this DocumentAssignmentParameters.  # noqa: E501

        If true, assign for translating. If false, then unassign.  # noqa: E501

        :return: The is_translator of this DocumentAssignmentParameters.  # noqa: E501
        :rtype: bool
        """
        return self._is_translator

    @is_translator.setter
    def is_translator(self, is_translator):
        """Sets the is_translator of this DocumentAssignmentParameters.

        If true, assign for translating. If false, then unassign.  # noqa: E501

        :param is_translator: The is_translator of this DocumentAssignmentParameters.  # noqa: E501
        :type: bool
        """

        self._is_translator = is_translator

    @property
    def is_reviewer(self):
        """Gets the is_reviewer of this DocumentAssignmentParameters.  # noqa: E501

        If true, assign for reviewing. If false, then unassign.  # noqa: E501

        :return: The is_reviewer of this DocumentAssignmentParameters.  # noqa: E501
        :rtype: bool
        """
        return self._is_reviewer

    @is_reviewer.setter
    def is_reviewer(self, is_reviewer):
        """Sets the is_reviewer of this DocumentAssignmentParameters.

        If true, assign for reviewing. If false, then unassign.  # noqa: E501

        :param is_reviewer: The is_reviewer of this DocumentAssignmentParameters.  # noqa: E501
        :type: bool
        """

        self._is_reviewer = is_reviewer

    @property
    def due_date(self):
        """Gets the due_date of this DocumentAssignmentParameters.  # noqa: E501

        Due date for translation or review (set based on `is_translator` and `is_reviewer` flags).  # noqa: E501

        :return: The due_date of this DocumentAssignmentParameters.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this DocumentAssignmentParameters.

        Due date for translation or review (set based on `is_translator` and `is_reviewer` flags).  # noqa: E501

        :param due_date: The due_date of this DocumentAssignmentParameters.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentAssignmentParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DocumentAssignmentParameters):
            return True

        return self.to_dict() != other.to_dict()
