def ListOfAllExcelFunction():

    fun = {'AND' : { 'Summary' : 'The Excel AND function is a logical function used to require more than one condition at the same time. AND returns either TRUE or FALSE. To test if a number in A1 is greater than zero and less than 10, use =AND(A1>0,A1<10). The AND function can be used as the logical test inside the IF function to avoid extra nested IFs, and can be combined with the OR function.', 'Purpose' : 'Test multiple conditions with AND', 'Return value' : 'TRUE if all arguments evaluate TRUE; FALSE if not', 'Arguments' : 'logical1 - The first condition or logical value to evaluate.logical2 - [optional] The second condition or logical value to evaluate.', 'Syntax' : '=AND(logical1, [logical2], ...)' },
    'FALSE' : { 'Summary' : 'The Excel FALSE function returns the Boolean value FALSE. The FALSE function is classified as a "compatibility function", needed only for compatibility with other spreadsheet applications. There is no need to use FALSE() if you are creating a spreadsheet in Excel.', 'Purpose' : 'Generate the logical value FALSE', 'Return value' : 'The logical value FALSE', 'Arguments' : '', 'Syntax' : '=FALSE()' },
    'IF' : { 'Summary' : 'The Excel IF function runs a logical test and returns one value for a TRUE result, and another for a FALSE result. For example, to "pass" scores above 70: =IF(A1>70,"Pass","Fail"). More than one condition can be tested by nesting IF functions. The IF function can be combined with logical functions like AND and OR to extend the logical test.', 'Purpose' : 'Test for a specific condition', 'Return value' : 'The values you supply for TRUE or FALSE', 'Arguments' : 'logical_test - A value or logical expression that can be evaluated as TRUE or FALSE.value_if_true - [optional] The value to return when logical_test evaluates to TRUE.value_if_false - [optional] The value to return when logical_test evaluates to FALSE.', 'Syntax' : '=IF(logical_test, [value_if_true], [value_if_false])' },
    'IFERROR' : { 'Summary' : 'The Excel IFERROR function returns a custom result when a formula generates an error, and a standard result when no error is detected. IFERROR is an elegant way to trap and manage errors without using more complicated nested IF statements.', 'Purpose' : 'Trap and handle errors', 'Return value' : 'The value you specify for error conditions.', 'Arguments' : 'value - The value, reference, or formula to check for an error.value_if_error - The value to return if an error is found.', 'Syntax' : '=IFERROR(value, value_if_error)' },
    'IFNA' : { 'Summary' : 'The Excel IFNA function is a simple way to trap and handle #N/A errors specifically without catching other errors. The IFNA function returns a custom result when a formula generates the #N/A error, and a normal result when no error is detected.', 'Purpose' : 'Trap and handle #N/A errors', 'Return value' : 'The value supplied for #N/A errors', 'Arguments' : 'value - The value, reference, or formula to check for an error.value_if_na - The value to return if #N/A error is found.', 'Syntax' : '=IFNA(value, value_if_na)' },
    'IFS' : { 'Summary' : 'The Excel IFS function can run multiple tests and return a value corresponding to the first TRUE result. Use the IFS function to evaluate multiple conditions without multiple nested IF statements. IFS allows shorter, easier to read formulas.', 'Purpose' : 'Test multiple conditions, return first true', 'Return value' : 'Value corresponding with first TRUE result', 'Arguments' : 'test1 - First logical test.value1 - Result when test1 is TRUE.test2, value2 - [optional] Second test/value pair.', 'Syntax' : '=IFS(test1, value1, [test2, value2], ...)' },
    'NOT' : { 'Summary' : 'The Excel NOT function returns the opposite of a given logical or Boolean value. When given TRUE, NOT returns FALSE. When given FALSE, NOT returns TRUE. Use the NOT function to reverse a logical value.', 'Purpose' : 'Reverse arguments or results', 'Return value' : 'A reversed logical value', 'Arguments' : 'logical - A value or logical expression that can be evaluated as TRUE or FALSE.', 'Syntax' : '=NOT(logical)' },
    'OR' : { 'Summary' : 'The Excel OR function returns TRUE if any given argument evaluates to TRUE, and returns FALSE if all supplied arguments evaluate to FALSE. For example, to test A1 for either "x" or "y", use =OR(A1="x",A1="y"). The OR function can be used as the logical test inside the IF function to avoid nested IFs, and can be combined with the AND function.', 'Purpose' : 'Test multiple conditions with OR', 'Return value' : 'TRUE if any arguments evaluate TRUE; FALSE if not.', 'Arguments' : 'logical1 - The first condition or logical value to evaluate.logical2 - [optional] The second condition or logical value to evaluate.', 'Syntax' : '=OR(logical1, [logical2], ...)' },
    'SWITCH' : { 'Summary' : 'The Excel SWITCH function compares one value against a list of values, and returns a result corresponding to the first match found. When no match is found, SWITCH can return an optional default value.', 'Purpose' : 'Match multiple values, return first match', 'Return value' : 'Result corresponding with first match', 'Arguments' : 'expression - The value or expression to match against.val1/result1 - The first value and result pair.val2/result2 - [optional] The second value and result pair.default - [optional] The default value to use when no match is found.', 'Syntax' : '=SWITCH(expression, val1/result1, [val2/result2], ..., [default])' },
    'TRUE' : { 'Summary' : 'The Excel TRUE function returns the Boolean value TRUE. The TRUE function is classified as a "compatibility function", needed only for compatibility with other spreadsheet applications. There is no need to use TRUE() if you are creating a spreadsheet in Excel.', 'Purpose' : 'Generate the logical value TRUE', 'Return value' : 'The logical value TRUE', 'Arguments' : '', 'Syntax' : '=TRUE()' },
    'XOR' : { 'Summary' : 'The XOR function performs what is called "exclusive OR". With two logical statements, XOR returns TRUE if either statement is TRUE, but returns FALSE if both statements are TRUE. If neither is TRUE, XOR also returns FALSE.', 'Purpose' : 'Perform exclusive OR', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'logical1 - An expression, constant, or reference that evaluates to TRUE or FALSE.logical2 - [optional] An expression, constant, or reference that evaluates to TRUE or FALSE.', 'Syntax' : '=XOR(logical1, [logical2], ...)' },
    'DATE' : { 'Summary' : 'The Excel DATE function creates a valid date from individual year, month, and day components. The DATE function is useful for assembling dates that need to change dynamically based on other values in a worksheet.', 'Purpose' : 'Create a date with year, month, and day', 'Return value' : 'A valid Excel date', 'Arguments' : 'year - Number for year.month - Number for month.day - Number for day.', 'Syntax' : '=DATE(year, month, day)' },
    'DATEDIF' : { 'Summary' : 'The Excel DATEDIF function returns the difference between two date values in years, months, or days. The DATEDIF (Date + Dif) function is a "compatibility" function that comes from Lotus 1-2-3. For reasons unknown, it is only documented in Excel 2000, but you can use it in your formulas in all Excel versions since that time.', 'Purpose' : 'Get days, months, or years between two dates', 'Return value' : 'A number representing time between two dates', 'Arguments' : 'start_date - Start date in Excel date serial number format.end_date - End date in Excel date serial number format.unit - The time unit to use (years, months, or days).', 'Syntax' : '=DATEDIF(start_date, end_date, unit)' },
    'DATEVALUE' : { 'Summary' : 'The Excel DATEVALUE function converts a date represented as a text string into a valid Excel date. For example, the formula =DATEVALUE("3/10/1975") returns a serial number (27463) in the Excel date system that represents March 10, 1975. Proper Excel dates are more useful than text dates since they can be directly manipulated with formulas and pivot tables .', 'Purpose' : 'Convert a date in text format to a valid date', 'Return value' : 'A valid Excel time as a serial number', 'Arguments' : 'date_text - A valid date in text format.', 'Syntax' : '=DATEVALUE(date_text)' },
    'DAY' : { 'Summary' : 'The Excel DAY function returns the day of the month as a number between 1 to 31 from a given date. You can use the DAY function to extract a day number from a date into a cell. You can also use the DAY function to extract and feed a day value into another function, like the DATE function.', 'Purpose' : 'Get the day as a number (1-31) from a date', 'Return value' : 'A number (1-31) representing the day component in a date.', 'Arguments' : 'date - A valid Excel date.', 'Syntax' : '=DAY(date)' },
    'DAYS' : { 'Summary' : 'The Excel DAYS function returns the number of days between two dates. With a start date in A1 and end date in B1, =DAYS(B1,A1) will return the days between the two dates.', 'Purpose' : 'Count days between dates', 'Return value' : 'A number representing days.', 'Arguments' : 'end_date - The end date.start_date - The start date.', 'Syntax' : '=DAYS(end_date, start_date)' },
    'DAYS360' : { 'Summary' : 'The Excel DAYS360 function returns the number of days between two dates based on a 360-day year, where all months are assumed to have 30 days. For example, the formula =DAYS360("1-Jan-2021","31-Dec-2021") returns 360 days.', 'Purpose' : 'Get days between 2 dates in a 360-day year', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.method - [optional] Day count method. FALSE (default) = US method, TRUE = European method.', 'Syntax' : '=DAYS360(start_date, end_date, [method])' },
    'EDATE' : { 'Summary' : 'The Excel EDATE function returns a date on the same day of the month, n months in the past or future. You can use EDATE to calculate expiration dates, maturity dates, and other due dates. Use a positive value for months to get a date in the future, and a negative value for dates in the past.', 'Purpose' : 'Shift date n months in future or past', 'Return value' : 'New date as Excel serial number', 'Arguments' : 'start_date - Start date as a valid Excel date.months - Number of months before or after start_date.', 'Syntax' : '=EDATE(start_date, months)' },
    'EOMONTH' : { 'Summary' : 'The Excel EOMONTH function returns the last day of the month, n months in the past or future. You can use EOMONTH to calculate expiration dates, due dates, and other dates that need to land on the last day of a month. Use a positive value for months to move forward in time, and a negative number to move back in time.', 'Purpose' : 'Get last day of month n months in future or past', 'Return value' : 'Last day of month date', 'Arguments' : 'start_date - A date that represents the start date in a valid Excel serial number format.months - The number of months before or after start_date.', 'Syntax' : '=EOMONTH(start_date, months)' },
    'HOUR' : { 'Summary' : 'The Excel HOUR function returns the hour component of a time as a number between 0-23. For example, with a time of 9:30 AM, HOUR will return 9. You can use the HOUR function to extract the hour into a cell, or feed the result into another formula, like the TIME function.', 'Purpose' : 'Get the hour as a number (0-23) from a Time', 'Return value' : 'A number between 0 and 23.', 'Arguments' : 'serial_number - A valid Excel time.', 'Syntax' : '=HOUR(serial_number)' },
    'ISOWEEKNUM' : { 'Summary' : 'The Excel ISOWEEKNUM function takes a date and returns a week number (1-54) that follows ISO standards, where weeks begin on Monday and week number 1 is assigned to the first week in a year that contains a Thursday.', 'Purpose' : 'Get ISO week number for a given date', 'Return value' : 'A number between 1 and 54.', 'Arguments' : 'date - A valid Excel date in serial number format.', 'Syntax' : '=ISOWEEKNUM(date)' },
    'MINUTE' : { 'Summary' : 'The Excel MINUTE function extracts the minute component of a time as a number between 0-59. For example, with a time of 9:45 AM, minute will return 45. You can use the MINUTE function to extract the minute into a cell, or feed the result into another function like the TIME function.', 'Purpose' : 'Get minute as a number (0-59) from time', 'Return value' : 'Number between 0 and 59.', 'Arguments' : 'serial_number - A valid date or time.', 'Syntax' : '=MINUTE(serial_number)' },
    'MONTH' : { 'Summary' : 'The Excel MONTH function extracts the month from a given date as number between 1 to 12. You can use the MONTH function to extract a month number from a date into a cell, or to feed a month number into another function like the DATE function.', 'Purpose' : 'Get month as a number (1-12) from a date', 'Return value' : 'A number between 1 and 12.', 'Arguments' : 'serial_number - A valid Excel date.', 'Syntax' : '=MONTH(serial_number)' },
    'NETWORKDAYS' : { 'Summary' : 'The Excel NETWORKDAYS function calculates the number of working days between two dates. NETWORKDAYS automatically excludes weekends (Saturday and Sunday) and can optionally exclude a list of holidays supplied as dates. ', 'Purpose' : 'Get the number of working days between two dates', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.holidays - [optional] A list of non-work days as dates.', 'Syntax' : '=NETWORKDAYS(start_date, end_date, [holidays])' },
    'NETWORKDAYS.INTL' : { 'Summary' : 'The Excel NETWORKDAYS.INTL function calculates the number of working days between two dates. NETWORKDAYS.INTL can optionally exclude a list of holidays and provides a way to specify which days of the week are considered weekends.', 'Purpose' : 'Get work days between two dates', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.weekend - [optional] Setting for which days of the week should be considered weekends.holidays - [optional] A reference to dates that should be considered non-work days.', 'Syntax' : '=NETWORKDAYS.INTL(start_date, end_date, [weekend], [holidays])' },
    'NOW' : { 'Summary' : 'The Excel NOW function returns the current date and time, updated continuously when a worksheet is changed or opened. The NOW function takes no arguments. You can format the value returned by NOW as a date, or as a date with time by applying a number format.', 'Purpose' : 'Get the current date and time', 'Return value' : 'A number representing the current date and time in Excel.', 'Arguments' : '', 'Syntax' : '=NOW()' },
    'SECOND' : { 'Summary' : 'The Excel SECOND function returns the second component of a time as a number between 0-59. For example, with a time of 9:10:15 AM, second will return 15. You can use the SECOND function to extract the second into a cell, or feed the result into another formula, like the TIME function.', 'Purpose' : 'Get the Second as a number (0-59) from a Time', 'Return value' : 'A number between 0 and 59', 'Arguments' : 'serial_number - A valid time in a format Excel recognizes.', 'Syntax' : '=SECOND(serial_number)' },
    'TIME' : { 'Summary' : 'The Excel TIME function is a built-in function that allows you to create a time with individual hour, minute, and second components. The TIME function is useful when you want to assemble a proper time inside another formula.', 'Purpose' : 'Create a time with hours, minutes, and seconds', 'Return value' : 'A decimal number representing a particular time in Excel.', 'Arguments' : 'hour - The hour for the time you wish to create.minute - The minute for the time you wish to create.second - The second for the time you wish to create.', 'Syntax' : '=TIME(hour, minute, second)' },
    'TIMEVALUE' : { 'Summary' : 'The Excel TIMEVALUE function converts a time represented as text into a proper Excel time. For example, the formula =TIMEVALUE("9:00 AM") returns 0.375, the numeric representation of 9:00 AM in Excel\'s time system. Numeric time values are more useful than text since they can be directly manipulated with formulas and pivot tables.', 'Purpose' : 'Get a valid time from a text string', 'Return value' : 'A valid Excel time as a decimal number', 'Arguments' : 'time_text - A date and/or time in a text format recognized by Excel.', 'Syntax' : '=TIMEVALUE(time_text)' },
    'TODAY' : { 'Summary' : 'The Excel TODAY function returns the current date, updated continuously when a worksheet is changed or opened. The TODAY function takes no arguments. You can format the value returned by TODAY with a date number format. If you need current date and time, use the NOW function.', 'Purpose' : 'Get the current date', 'Return value' : 'Excel date as a serial number', 'Arguments' : '', 'Syntax' : '=TODAY()' },
    'WEEKDAY' : { 'Summary' : 'The Excel WEEKDAY function takes a date and returns a number between 1-7 representing the day of week. By default, WEEKDAY returns 1 for Sunday and 7 for Saturday, but this is configurable. You can use the WEEKDAY function inside other formulas to check the day of week.', 'Purpose' : 'Get the day of the week as a number', 'Return value' : 'A number between 0 and 7.', 'Arguments' : 'serial_number - The date for which you want to get the day of week.return_type - [optional] A number representing day of week mapping scheme. Default is 1.', 'Syntax' : '=WEEKDAY(serial_number, [return_type])' },
    'WEEKNUM' : { 'Summary' : 'The Excel WEEKNUM function takes a date and returns a week number (1-54) that corresponds to the week of year. The WEEKNUM function starts counting on the week that contains January 1. By default, weeks begin on Sunday, but this can be changed.', 'Purpose' : 'Get the week number for a given date', 'Return value' : 'A number between 1 and 54.', 'Arguments' : 'serial_num - A valid Excel date in serial number format.return_type - [optional] The day the week begins. Default is 1.', 'Syntax' : '=WEEKNUM(serial_num, [return_type])' },
    'WORKDAY' : { 'Summary' : 'The Excel WORKDAY function takes a date and returns the nearest working day n days in the future or past. You can use the WORKDAY function to calculate things like ship dates, delivery dates, and completion dates that need to take into account working and non-working days.', 'Purpose' : 'Get a date n working days in the future or past', 'Return value' : 'A serial number representing a particular date in Excel.', 'Arguments' : 'start_date - The date from which to start.days - The working days before or after start_date.holidays - [optional] A list dates that should be considered non-work days.', 'Syntax' : '=WORKDAY(start_date, days, [holidays])' },
    'WORKDAY.INTL' : { 'Summary' : 'The Excel WORKDAY.INTL function takes a date and returns the nearest working n days in the future or past, based on an offset value you provide. Unlike the WORKDAY function, WORKDAY.INTL allows you to customize which days are considered weekends (non-working days). You can use WORKDAY.INTL function to calculate completion dates, ship dates, etc. that take into account non-working days.', 'Purpose' : 'Get date n working days in future or past', 'Return value' : 'Next or previous working date based on inputs', 'Arguments' : 'start_date - The start date.days - The end date.weekend - [optional] Setting for which days of the week should be considered weekends.holidays - [optional] A list of one or more dates that should be considered non-work days.', 'Syntax' : '=WORKDAY.INTL(start_date, days, [weekend], [holidays])' },
    'YEAR' : { 'Summary' : 'The Excel YEAR function returns the year component of a date as a 4-digit number. You can use the YEAR function to extract a year number from a date into a cell or to extract and feed a year value into another formula, like the DATE function.', 'Purpose' : 'Get the year from a date', 'Return value' : 'Year as 4-digit number', 'Arguments' : 'date - A valid Excel date.', 'Syntax' : '=YEAR(date)' },
    'YEARFRAC' : { 'Summary' : 'The Excel YEARFRAC function returns a decimal value that represents fractional years between two dates. You can use YEARFRAC to do things like calculate age with a birthdate.', 'Purpose' : 'Get the fraction of a year between two dates', 'Return value' : 'A decimal number', 'Arguments' : 'start_date - The start date.end_date - The end date.basis - [optional] The type of day count basis to use (see below).', 'Syntax' : '=YEARFRAC(start_date, end_date, [basis])' },
    'ADDRESS' : { 'Summary' : 'The Excel ADDRESS function returns the address for a cell based on a given row and column number. For example, =ADDRESS(1,1) returns $A$1. ADDRESS can return an address in relative, mixed, or absolute format, and can be used to construct a cell reference inside a formula.', 'Purpose' : 'Create a cell address from a row and column number', 'Return value' : 'A cell address in the current or given worksheet.', 'Arguments' : 'row_num - The row number to use in the cell address.col_num - The column number to use in the cell address.abs_num - [optional] The address type (i.e. absolute, relative). Defaults to absolute.a1 - [optional] The reference style, A1 vs R1C1. Defaults to A1 style.sheet - [optional] The name of the worksheet to use. Defaults to current sheet.', 'Syntax' : '=ADDRESS(row_num, col_num, [abs_num], [a1], [sheet])' },
    'AREAS' : { 'Summary' : 'The Excel AREAS function returns the number of areas in a given reference. For example, =AREAS((A1:C1,A2:C2)) returns 2. Multiple references must be enclosed in an extra set of parentheses.', 'Purpose' : 'Get the number of areas in a reference.', 'Return value' : 'A number representing number of areas.', 'Arguments' : 'reference - Reference(s) to a cell or range of cells.', 'Syntax' : '=AREAS(reference)' },
    'CHOOSE' : { 'Summary' : 'The Excel CHOOSE function returns a value from a list using a given position or index. For example, =CHOOSE(2,"red","blue","green") returns "blue", since blue is the 2nd value listed after the index number. The values provided to CHOOSE can include references.', 'Purpose' : 'Get a value from a list based on position', 'Return value' : 'The value at the given position.', 'Arguments' : 'index_num - The value to choose. A number between 1 and 254.value1 - The first value from which to choose.value2 - [optional] The second value from which to choose.', 'Syntax' : '=CHOOSE(index_num, value1, [value2], ...)' },
    'COLUMN' : { 'Summary' : 'The Excel COLUMN function returns the column number for a reference. For example, COLUMN(C5) returns 3, since C is the third column in the spreadsheet. When no reference is provided, COLUMN returns the column number of the cell which contains the formula.', 'Purpose' : 'Get the column number of a reference.', 'Return value' : 'A number representing the column.', 'Arguments' : 'reference - [optional] A reference to a cell or range of cells.', 'Syntax' : '=COLUMN([reference])' },
    'COLUMNS' : { 'Summary' : 'The Excel COLUMNS function returns the count of columns in a given reference. For example, COLUMNS(A1:C3) returns 3, since the range A1:C3 contains 3 columns.', 'Purpose' : 'Get the number of columns in an array or reference.', 'Return value' : 'Number of columns', 'Arguments' : 'array - A reference to a range of cells.', 'Syntax' : '=COLUMNS(array)' },
    'FIELDVALUE' : { 'Summary' : 'The Excel FIELDVALUE function extracts a given field value from a data type. The field is specified by name and provided as a text value.', 'Purpose' : 'Extract field value from a data type', 'Return value' : 'Field value for given data type', 'Arguments' : 'value - The data type with field values.field_name - The field name provided as a text value.', 'Syntax' : '=FIELDVALUE(value, field_name)' },
    'FORMULATEXT' : { 'Summary' : 'The Excel FORMULATEXT function returns a formula as a text string from a given reference. You can use FORMULATEXT to extract the formula as text from a cell. If you use FORMULATEXT on a cell that doesn\'t contain a formula, it returns #N/A.', 'Purpose' : 'Get the formula in a cell', 'Return value' : 'The formula as text', 'Arguments' : 'reference - Reference to cell or cell range.', 'Syntax' : '=FORMULATEXT(reference)' },
    'GETPIVOTDATA' : { 'Summary' : 'The Excel GETPIVOTDATA function can retrieve specific data from a pivot table by name based on the structure, instead of cell references.', 'Purpose' : 'Retrieve data from a pivot table in a formula', 'Return value' : 'The data requested', 'Arguments' : 'data_field - The name of the value field to query.pivot_table - A reference to any cell in the pivot table to query.field1, item1 - [optional] A field/item pair.', 'Syntax' : '=GETPIVOTDATA(data_field, pivot_table, [field1, item1], ...)' },
    'HLOOKUP' : { 'Summary' : 'The Excel HLOOKUP function finds and retrieve a value from data in a horizontal table. The "H" in HLOOKUP stands for "horizontal", and lookup values must appear in the first row of the table, moving horizontally to the right. HLOOKUP supports approximate and exact matching, and wildcards (* ?) for finding partial matches.', 'Purpose' : ' Look up a value in a table arranged horizontally', 'Return value' : 'The matched value from a table.', 'Arguments' : 'lookup_value - The value to look up.table_array - The table from which to retrieve data.row_index - The row number from which to retrieve data.range_lookup - [optional] A Boolean to indicate exact match or approximate match. Default = TRUE = approximate match.', 'Syntax' : '=HLOOKUP(lookup_value, table_array, row_index, [range_lookup])' },
    'HYPERLINK' : { 'Summary' : 'The Excel HYPERLINK function returns a hyperlink from a given destination and link text. You can use HYPERLINK to create a clickable hyperlink with a formula. The HYPERLINK function can build links to workbook locations, pages on the internet, or to files on network servers.', 'Purpose' : 'Create a clickable link.', 'Return value' : 'A clickable hyperlink', 'Arguments' : 'link_location - The path to the file or page to be opened.friendly_name - [optional] The link text to display in a cell.', 'Syntax' : '=HYPERLINK(link_location, [friendly_name])' },
    'INDEX' : { 'Summary' : 'The Excel INDEX function returns the value at a given location in a range or array. You can use INDEX to retrieve individual values, or entire rows and columns. The MATCH function is often used together with INDEX to provide row and column numbers.', 'Purpose' : 'Get a value in a list or table based on location', 'Return value' : 'The value at a given location.', 'Arguments' : 'array - A range of cells, or an array constant.row_num - The row position in the reference or array.col_num - [optional] The column position in the reference or array.area_num - [optional] The range in reference that should be used.', 'Syntax' : '=INDEX(array, row_num, [col_num], [area_num])' },
    'INDIRECT' : { 'Summary' : 'The Excel INDIRECT function returns a valid cell reference from a given text string. INDIRECT is useful when you want to assemble a text value that can be used as a valid reference.', 'Purpose' : 'Create a reference from text', 'Return value' : 'A valid worksheet reference.', 'Arguments' : 'ref_text - A reference supplied as text.a1 - [optional] A boolean to indicate A1 or R1C1-style reference. Default is TRUE = A1 style.', 'Syntax' : '=INDIRECT(ref_text, [a1])' },
    'LOOKUP' : { 'Summary' : 'The Excel LOOKUP function performs an approximate match lookup in a one-column or one-row range, and returns the corresponding value from another one-column or one-row range. LOOKUP\'s default behavior makes it useful for solving certain problems in Excel.', 'Purpose' : 'Look up a value in a one-column range', 'Return value' : 'A value in the result vector.', 'Arguments' : 'lookup_value - The value to search for.lookup_vector - The one-row, or one-column range to search.result_vector - [optional] The one-row, or one-column range of results.', 'Syntax' : '=LOOKUP(lookup_value, lookup_vector, [result_vector])' },
    'MATCH' : { 'Summary' : 'MATCH is an Excel function used to locate the position of a lookup value in a row, column, or table. MATCH supports approximate and exact matching, and wildcards (* ?) for partial matches. Often, MATCH is combined with the INDEX function to retrieve a value at a matched position.', 'Purpose' : 'Get the position of an item in an array', 'Return value' : 'A number representing a position in lookup_array.', 'Arguments' : 'lookup_value - The value to match in lookup_array.lookup_array - A range of cells or an array reference.match_type - [optional] 1 = exact or next smallest (default), 0 = exact match, -1 = exact or next largest.', 'Syntax' : '=MATCH(lookup_value, lookup_array, [match_type])' },
    'OFFSET' : { 'Summary' : 'The Excel OFFSET function returns a reference to a range constructed with five inputs: (1) a starting point, (2) a row offset, (3) a column offset, (4) a height in rows, (5) a width in columns. OFFSET is handy in formulas that require a dynamic range.', 'Purpose' : 'Create a reference offset from given starting point', 'Return value' : 'A cell reference.', 'Arguments' : 'reference - The starting point, supplied as a cell reference or range.rows - The number of rows to offset below the starting reference.cols - The number of columns to offset to the right of the starting reference.height - [optional] The height in rows of the returned reference.width - [optional] The width in columns of the returned reference.', 'Syntax' : '=OFFSET(reference, rows, cols, [height], [width])' },
    'ROW' : { 'Summary' : 'The Excel ROW function returns the row number for a reference. For example, ROW(C5) returns 5, since C5 is the fifth row in the spreadsheet. When no reference is provided, ROW returns the row number of the cell which contains the formula.', 'Purpose' : 'Get the row number of a reference', 'Return value' : 'A number representing the row.', 'Arguments' : 'reference - [optional] A reference to a cell or range of cells.', 'Syntax' : '=ROW([reference])' },
    'ROWS' : { 'Summary' : 'The Excel ROWS function returns the count of rows in a given reference. For example, ROWS(A1:A3) returns 3, since the range A1:A3 contains 3 rows.', 'Purpose' : 'Get the number of rows in an array or reference.', 'Return value' : 'Number of rows', 'Arguments' : 'array - A reference to a cell or range of cells.', 'Syntax' : '=ROWS(array)' },
    'TRANSPOSE' : { 'Summary' : 'The Excel TRANSPOSE function "flips" the orientation of a given range or array: TRANSPOSE flips a vertical range to a horizontal range, and flips a horizontal range to a vertical range.', 'Purpose' : 'Flip the orientation of a range of cells', 'Return value' : 'An array in a new orientation.', 'Arguments' : 'array - The array or range of cells to transpose.', 'Syntax' : '=TRANSPOSE(array)' },
    'VLOOKUP' : { 'Summary' : 'VLOOKUP is an Excel function to look up data in a table organized vertically. VLOOKUP supports approximate and exact matching, and wildcards (* ?) for partial matches. Lookup values must appear in the first column of the table passed into VLOOKUP.', 'Purpose' : 'Lookup a value in a table by matching on the first column', 'Return value' : 'The matched value from a table.', 'Arguments' : 'lookup_value - The value to look for in the first column of a table.table_array - The table from which to retrieve a value.column_index_num - The column in the table from which to retrieve a value.range_lookup - [optional] TRUE = approximate match (default). FALSE = exact match.', 'Syntax' : '=VLOOKUP(lookup_value, table_array, column_index_num, [range_lookup])' },
    'CHAR' : { 'Summary' : 'The Excel CHAR function returns a character when given a valid character code. CHAR can be used to specify characters that are hard to enter in a formula. For example, CHAR(10) returns a line break, and can be used to add a line break to text in a formula.', 'Purpose' : 'Get a character from a number', 'Return value' : 'A single character specified by a number.', 'Arguments' : 'number - A number between 1 and 255.', 'Syntax' : '=CHAR(number)' },
    'CLEAN' : { 'Summary' : 'The Excel CLEAN function takes a text string and returns text that has been "cleaned" of line breaks and other non-printable characters.', 'Purpose' : 'Strip non-printable characters from text', 'Return value' : 'Text with non-printable characters removed.', 'Arguments' : 'text - The text to clean.', 'Syntax' : '=CLEAN(text)' },
    'CODE' : { 'Summary' : 'The Excel CODE function returns a numeric code for a given character. For example, CODE("a") returns the code 97.', 'Purpose' : 'Get the code for a character', 'Return value' : 'A numeric code representing a character.', 'Arguments' : 'text - The text for which you want a numeric code.', 'Syntax' : '=CODE(text)' },
    'CONCAT' : { 'Summary' : 'The Excel CONCAT function concatenates (joins) values supplied as references or constants. Unlike the CONCATENATE function (which CONCAT replaces), CONCAT will accept a range of cells to join, in addition to individual cell references.', 'Purpose' : 'Join text values without delimiter', 'Return value' : 'Result of concatenated text', 'Arguments' : 'text1 - First text value, cell reference, or range.text2 - [optional] Second text value, cell reference, or range.', 'Syntax' : '=CONCAT(text1, [text2], ...)' },
    'CONCATENATE' : { 'Summary' : 'The Excel CONCATENATE function concatenates (joins) join up to 30 values together and returns the result as text. In Excel 2019 and later, the CONCAT and TEXTJOIN functions are better, more flexible alternatives.', 'Purpose' : 'Join text together', 'Return value' : 'Text joined together.', 'Arguments' : 'text1 - The first text value to join together.text2 - The second text value to join together.text3 - [optional] The third text value to join together.', 'Syntax' : '=CONCATENATE(text1, text2, [text3], ...)' },
    'DOLLAR' : { 'Summary' : 'The Excel DOLLAR function converts a number to text using the Currency number format. The TEXT function can do the same thing, and is much more versatile.', 'Purpose' : 'Convert a number to text in currency format', 'Return value' : 'A number as text in currency format.', 'Arguments' : 'number - The number to convert.decimals - The number of digits to the right of the decimal point. Default is 2.', 'Syntax' : '=DOLLAR(number, decimals)' },
    'EXACT' : { 'Summary' : 'The Excel EXACT function compares two text strings, taking into account upper and lower case characters, and returns TRUE if they are the same, and FALSE if not. EXACT is case-sensitive.', 'Purpose' : 'Compare two text strings', 'Return value' : 'A boolean value (TRUE or FALSE)', 'Arguments' : 'text1 - The first text string to compare.text2 - The second text string to compare.', 'Syntax' : '=EXACT(text1, text2)' },
    'FIND' : { 'Summary' : 'The Excel FIND function returns the position (as a number) of one text string inside another. When the text is not found, FIND returns a #VALUE error.', 'Purpose' : 'Get location substring in a string', 'Return value' : 'A number representing the location of substring', 'Arguments' : 'find_text - The substring to find.within_text - The text to search within.start_num - [optional] The starting position in the text to search. Optional, defaults to 1.', 'Syntax' : '=FIND(find_text, within_text, [start_num])' },
    'FIXED' : { 'Summary' : 'The Excel FIXED function converts a number to text with fixed number of decimals, rounding as needed with the given number of decimals. The FIXED function can be useful when concatenating a formatted number text.', 'Purpose' : 'Format number as text with fixed decimals', 'Return value' : 'Number formatted as text', 'Arguments' : 'number - The number to round and format.decimals - [optional] Number of decimals to use. Default is 2.no_commas - [optional] Suppress commas. TRUE = no commas, FALSE = commas. Default is FALSE.', 'Syntax' : '=FIXED(number, [decimals], [no_commas])' },
    'LEFT' : { 'Summary' : 'The Excel LEFT function extracts a given number of characters from the left side of a supplied text string. For example, LEFT("apple",3) returns "app".', 'Purpose' : 'Extract text from the left of a string', 'Return value' : 'One or more characters.', 'Arguments' : 'text - The text from which to extract characters.num_chars - [optional] The number of characters to extract, starting on the left side of text. Default = 1.', 'Syntax' : '=LEFT(text, [num_chars])' },
    'LEN' : { 'Summary' : 'The Excel LEN function returns the length of a given text string as the number of characters. LEN will also count characters in numbers, but number formatting is not included.', 'Purpose' : 'Get the length of text.', 'Return value' : 'Number of characters', 'Arguments' : 'text - The text for which to calculate length.', 'Syntax' : '=LEN(text)' },
    'LOWER' : { 'Summary' : 'The Excel LOWER function converts a text string to all lowercase letters. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Convert text to lower case', 'Return value' : 'Text in lower case.', 'Arguments' : 'text - The text that should be converted to lower case.', 'Syntax' : '=LOWER(text)' },
    'MID' : { 'Summary' : 'The Excel MID function extracts a given number of characters from the middle of a supplied text string. For example, =MID("apple",2,3) returns "ppl".', 'Purpose' : 'Extract text from inside a string', 'Return value' : 'The characters extracted.', 'Arguments' : 'text - The text to extract from.start_num - The location of the first character to extract.num_chars - The number of characters to extract.', 'Syntax' : '=MID(text, start_num, num_chars)' },
    'NUMBERVALUE' : { 'Summary' : 'The Excel NUMBERVALUE function converts a number in text format to numeric value, using specified decimal and group separators. This function can be used to convert locale-specific values into locale-independent values.', 'Purpose' : 'Convert text to number with custom separators', 'Return value' : 'Numeric value', 'Arguments' : 'text - The text to convert to a number.decimal_separator - [optional] The character for decimal values.group_separator - [optional] The character for grouping by thousands.', 'Syntax' : '=NUMBERVALUE(text, [decimal_separator], [group_separator])' },
    'PROPER' : { 'Summary' : 'The Excel PROPER function capitalizes each word in a given text string. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Capitalize the first letter in each word', 'Return value' : 'Text in proper case.', 'Arguments' : 'text - The text that should be converted to proper case.', 'Syntax' : '=PROPER(text)' },
    'REPLACE' : { 'Summary' : 'The Excel REPLACE function replaces characters specified by location in a given text string with another text string. For example =REPLACE("XYZ123",4,3,"456") returns "XYZ456".', 'Purpose' : 'Replace text based on location', 'Return value' : 'The altered text.', 'Arguments' : 'old_text - The text to replace.start_num - The starting location in the text to search.num_chars - The number of characters to replace.new_text - The text to replace old_text with.', 'Syntax' : '=REPLACE(old_text, start_num, num_chars, new_text)' },
    'REPT' : { 'Summary' : 'The Excel REPT function repeats characters a given number of times. For example, =REPT("x",5) returns "xxxxx".', 'Purpose' : 'Repeat text as specified', 'Return value' : 'The repeated text.', 'Arguments' : 'text - The text to repeat.number_times - The number of times to repeat text.', 'Syntax' : '=REPT(text, number_times)' },
    'RIGHT' : { 'Summary' : 'The Excel RIGHT function extracts a given number of characters from the right side of a supplied text string. For example, RIGHT("apple",3) returns "ple".', 'Purpose' : 'Extract text from the right of a string', 'Return value' : 'One or more characters.', 'Arguments' : 'text - The text from which to extract characters on the right.num_chars - [optional] The number of characters to extract, starting on the right. Optional, default = 1.', 'Syntax' : '=RIGHT(text, [num_chars])' },
    'SEARCH' : { 'Summary' : 'The Excel SEARCH function returns the location of one text string inside another. SEARCH returns the position of find_text inside within_text as a number. SEARCH supports wildcards, and is not case-sensitive.', 'Purpose' : 'Get the location of substring in a string', 'Return value' : 'A number representing the location of substring', 'Arguments' : 'find_text - The substring to find.within_text - The text to search within.start_num - [optional] Starting position. Optional, defaults to 1.', 'Syntax' : '=SEARCH(find_text, within_text, [start_num])' },
    'SUBSTITUTE' : { 'Summary' : 'The Excel SUBSTITUTE function replaces text in a given string by matching. For example =SUBSTITUTE("952-455-7865","-","") returns "9524557865"; the dash is stripped. SUBSTITUTE is case-sensitive and does not support wildcards.', 'Purpose' : 'Replace text based on content', 'Return value' : 'The processed text', 'Arguments' : 'text - The text to change.old_text - The text to replace.new_text - The text to replace with.instance - [optional] The instance to replace. If not supplied, all instances are replaced.', 'Syntax' : '=SUBSTITUTE(text, old_text, new_text, [instance])' },
    'TEXT' : { 'Summary' : 'The Excel TEXT function returns a number in a given number format, as text. You can use the TEXT function to embed formatted numbers inside text.', 'Purpose' : 'Convert a number to text in a number format', 'Return value' : 'A number as text in the given format.', 'Arguments' : 'value - The number to convert.format_text - The number format to use.', 'Syntax' : '=TEXT(value, format_text)' },
    'TEXTJOIN' : { 'Summary' : 'The Excel TEXTJOIN function concatenates multiple values together with or without a delimiter. TEXTJOIN can concatenate values provided as cell references, ranges, or constants, and can optionally ignore empty cells', 'Purpose' : 'Join text values with a delimiter', 'Return value' : 'Concatenated text', 'Arguments' : 'delimiter - Separator between each text.ignore_empty - Whether to ignore empty cells or not.text1 - First text value or range.text2 - [optional] Second text value or range.', 'Syntax' : '=TEXTJOIN(delimiter, ignore_empty, text1, [text2], ...)' },
    'TRIM' : { 'Summary' : 'The Excel TRIM function strips extra spaces from text, leaving only a single space between words and no space characters at the start or end of the text.', 'Purpose' : 'Remove extra spaces from text', 'Return value' : 'Text with extra spaces removed.', 'Arguments' : 'text - The text from which to remove extra space.', 'Syntax' : '=TRIM(text)' },
    'UNICHAR' : { 'Summary' : 'The Excel UNICHAR function returns a Unicode character based on a given number.', 'Purpose' : 'Get Unicode character by number', 'Return value' : 'Unicode character', 'Arguments' : 'number - Code point for a Unicode character in decimal.', 'Syntax' : '=UNICHAR(number)' },
    'UNICODE' : { 'Summary' : 'The Excel UNICODE function returns a number (code point) corresponding to a Unicode character. Unicode is computing standard for the unified encoding, representation, and handling of text in most of the world\'s writing systems. ', 'Purpose' : 'Get number from Unicode character', 'Return value' : 'Unicode code point in decimal notation', 'Arguments' : 'text - Unicode character to convert to number.', 'Syntax' : '=UNICODE(text)' },
    'UPPER' : { 'Summary' : 'The Excel UPPER function converts a text string to all uppercase letters. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Convert text to upper case', 'Return value' : 'Uppercase text.', 'Arguments' : 'text - The text thatto convert to upper case.', 'Syntax' : '=UPPER(text)' },
    'VALUE' : { 'Summary' : 'The Excel VALUE function converts text that appears in a recognized format (i.e. a number, date, or time format) into a numeric value. Normally, the VALUE function is not needed in Excel, because Excel automatically converts text to numeric values.', 'Purpose' : 'Convert text to a number', 'Return value' : 'A numeric value.', 'Arguments' : 'text - The text value to convert to a number.', 'Syntax' : '=VALUE(text)' },
    'ARRAYTOTEXT' : { 'Summary' : 'The Excel ARRAYTOTEXT function converts an array or range to a text string. The result can optionally include or omit curly braces.', 'Purpose' : 'Converts array or range to a text string', 'Return value' : 'A text string showing values', 'Arguments' : 'array - The array or range to convert to text.format - [optional] Output format. 0 = concise (default), and 1 = strict.', 'Syntax' : '=ARRAYTOTEXT(array, [format])' },
    'BYCOL' : { 'Summary' : 'The Excel BYCOL function applies a LAMBDA function to each column in a given array and returns one result per column as a single array. In the example shown, data is the named range C5:H9.', 'Purpose' : 'Apply function to column', 'Return value' : 'One result per column', 'Arguments' : 'array - The array or array to process.lambda - The lambda function to apply to each column.', 'Syntax' : '=BYCOL(array, lambda)' },
    'BYROW' : { 'Summary' : 'The Excel BYROW function applies a LAMBDA function to each row of a given array and returns one result per row in a single array. In the example shown, data is the named range C5:H9. ', 'Purpose' : 'Apply function to row', 'Return value' : 'One result per row', 'Arguments' : 'array - The array or array to process.lambda - The lambda function to apply to each row.', 'Syntax' : '=BYROW(array, lambda)' },
    'CHOOSECOLS' : { 'Summary' : 'The Excel CHOOSECOLS function returns specific columns from an array or range. The columns to return are provided as numbers in separate arguments. Each number corresponds to the numeric index of a column in the given array.', 'Purpose' : 'Return specific columns from an array', 'Return value' : 'Extracted columns in a single array', 'Arguments' : 'array - The array to extract columns from.col_num1 - The numeric index of the first column to return.col_num2 - [optional] The numeric index of the second column to return.', 'Syntax' : '=CHOOSECOLS(array, col_num1, [col_num2], ...)' },
    'CHOOSEROWS' : { 'Summary' : 'The Excel CHOOSEROWS function returns specific rows from an array or range. The rows to return are provided as numbers in separate arguments. Each number corresponds to the numeric index of a row in the given array.', 'Purpose' : 'Return specific rows from an array', 'Return value' : 'Extracted rows in a single array', 'Arguments' : 'array - The array to extract rows from.row_num1 - The numeric index of the first row to return.row_num2 - [optional] The numeric index of the second row to return.', 'Syntax' : '=CHOOSEROWS(array, row_num1, [row_num2], ...)' },
    'DROP' : { 'Summary' : 'The Excel DROP function returns a subset of a given array by "dropping" rows and columns. The number of rows and columns to remove is provided by separate rows and columns arguments. Rows and columns can be dropped from the start or end of the given array.', 'Purpose' : 'Remove portion of an array', 'Return value' : 'The remaining array', 'Arguments' : 'array - The source array or range.rows - [optional] Number of rows to drop.col - [optional] Number of columns to drop.', 'Syntax' : '=DROP(array, [rows], [col])' },
    'EXPAND' : { 'Summary' : 'The EXPAND function expands an array by adding rows and columns, which are supplied as separate arguments. The numbers given for rows and columns represent the dimensions of the final array.', 'Purpose' : 'Expand array by adding rows or columns', 'Return value' : 'Expanded array', 'Arguments' : 'array - The array to expand.rows - [optional] The final number of rows. Default is total rows.columns - [optional] The final number of columns. Default is total columns.pad_with - [optional] Value to use for new cells. Default is #N/A.', 'Syntax' : '=EXPAND(array, [rows], [columns], [pad_with])' },
    'FILTER' : { 'Summary' : 'The Excel FILTER function filters a range of data based on supplied criteria, and extracts matching records.', 'Purpose' : 'Filters range with given criteria', 'Return value' : 'Array of filtered values', 'Arguments' : 'array - Range or array to filter.include - Boolean array, supplied as criteria.if_empty - [optional] Value to return when no results are returned.', 'Syntax' : '=FILTER(array, include, [if_empty])' },
    'HSTACK' : { 'Summary' : 'The Excel HSTACK function combines arrays horizontally into a single array. Each subsequent array is appended to the right of of the previous array.', 'Purpose' : 'Combine ranges or arrays horizontally', 'Return value' : 'A single combined range or array', 'Arguments' : 'array1 - The first array or range to combine.array2 - [optional] The second array or range to combine.', 'Syntax' : '=HSTACK(array1, [array2], ...)' },
    'ISOMITTED' : { 'Summary' : 'The Excel ISOMITTED function is a helper function for LAMBDA functions to allow optional arguments. Inside a LAMBDA function, ISOMITTED will return TRUE when an argument has not been provided.', 'Purpose' : 'Check for optional arguments in LAMBDAs', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'argument - The argument to test for.', 'Syntax' : '=ISOMITTED(argument)' },
    'LAMBDA' : { 'Summary' : 'The Excel LAMBDA function provides a way create custom functions that can be reused throughout a workbook, without VBA or macros.', 'Purpose' : 'Create custom function', 'Return value' : 'As defined by formula', 'Arguments' : 'parameter - An input value for the function.calculation - The calculation to perform as the result of the function. Must be last argument.', 'Syntax' : '=LAMBDA(parameter, ..., calculation)' },
    'LET' : { 'Summary' : 'The Excel LET function lets you define named variables in a formula. There are two primary reasons you might want to do this: (1) to improve performance by eliminating redundant calculations and (2) to make more complex formulas easier to read and write.', 'Purpose' : 'Assign variables inside formula', 'Return value' : 'Normal formula result', 'Arguments' : 'name1 - First name to assign. Must begin with a letter.value1 - The value or calculation to assign to name 1.name2/value2 - [optional] Second name and value. Entered as a pair of arguments.result - A calculation or a variable previously calculated.', 'Syntax' : '=LET(name1, value1, [name2/value2], ..., result)' },
    'MAKEARRAY' : { 'Summary' : 'The Excel MAKEARRAY function returns a array with specified rows and columns, based on a custom LAMBDA calculation. MAKEARRAY can be used to create arrays with variable dimensions where values are the result of a calculation.', 'Purpose' : 'Create array with calculated values', 'Return value' : 'An array of calculated values', 'Arguments' : 'rows - The number of rows to create.columns - The number of columns to create.lambda - The custom LAMBDA calculation to apply.', 'Syntax' : '=MAKEARRAY(rows, columns, lambda)' },
    'MAP' : { 'Summary' : 'The Excel MAP function "maps" a custom LAMBDA function to each value in a supplied array. The LAMBDA is applied to each value, and the result from MAP is an array of results with the same dimensions as the original array.', 'Purpose' : 'Map array to custom function', 'Return value' : 'Array of results', 'Arguments' : 'array1 - The array to be mapped.array2 - [optional] Additional arrays required by the LAMBDA.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=MAP(array1, [array2], ..., lambda)' },
    'RANDARRAY' : { 'Summary' : 'The Excel RANDARRAY function generates an array of random numbers between two values. The size or the array is is specified by rows and columns arguments. The generated values can be either decimals or whole numbers.', 'Purpose' : 'Get array of random numbers', 'Return value' : 'Array of random values', 'Arguments' : 'rows - [optional] Row count. Default = 1.columns - [optional] Column count. Default = 1.min - [optional] Minimum value. Default = 0.max - [optional] Maximum value. Default = 1.integer - [optional] Whole numbers. Boolean, TRUE or FALSE. Default = FALSE.', 'Syntax' : '=RANDARRAY([rows], [columns], [min], [max], [integer])' },
    'REDUCE' : { 'Summary' : 'The Excel REDUCE function applies a custom LAMBDA function to each element in a given array and accumulates results to a single value.', 'Purpose' : 'Reduce an array', 'Return value' : 'A single value', 'Arguments' : 'initial_value - [optional] The initial value of the accumulator.array - The array to be reduced.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=REDUCE([initial_value], array, lambda)' },
    'SCAN' : { 'Summary' : 'The SCAN function applies a custom LAMBDA function to each element in a given array and returns an array that contains the intermediate values created during the scan. SCAN can be used to generate running totals and other calculations that show intermediate results. ', 'Purpose' : 'Scan array and return intermediate results', 'Return value' : 'An array of results', 'Arguments' : 'initial_value - [optional] The initial value of the accumulator.array - The array to be scanned.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=SCAN([initial_value], array, lambda)' },
    'SEQUENCE' : { 'Summary' : 'The Excel SEQUENCE function generates a list of sequential numbers in an array. The array can be one dimensional, or two-dimensional, determined by rows and columns arguments. ', 'Purpose' : 'Get array of list of sequential numbers', 'Return value' : 'Array of sequential values', 'Arguments' : 'rows - Number of rows to return.columns - [optional] Number of columns to return.start - [optional] Starting value (defaults to 1).step - [optional] Increment between each value (defaults to 1).', 'Syntax' : '=SEQUENCE(rows, [columns], [start], [step])' },
    'SORT' : { 'Summary' : 'The Excel SORT function sorts the contents of a range or array in ascending or descending order. Values can be sorted by one or more columns. SORT returns a dynamic array of results.', 'Purpose' : 'Sorts range or array', 'Return value' : 'Sorted array', 'Arguments' : 'array - Range or array to sort.sort_index - [optional] Column index to use for sorting. Default is 1.sort_order - [optional] 1 = Ascending, -1 = Descending. Default is ascending order.by_col - [optional] TRUE = sort by column. FALSE = sort by row. Default is FALSE.', 'Syntax' : '=SORT(array, [sort_index], [sort_order], [by_col])' },
    'SORTBY' : { 'Summary' : 'The Excel SORTBY function sorts the contents of a range or array based on the values from another range or array. The range or array used to sort does not need to appear in results.', 'Purpose' : 'Sorts range or array by column', 'Return value' : 'Sorted array', 'Arguments' : 'array - Range or array to sort.by_array - Range or array to sort by.sort_order - [optional] Sort order. 1 = ascending (default), -1 = descending.array/order - [optional] Additional array and sort order pairs.', 'Syntax' : '=SORTBY(array, by_array, [sort_order], [array/order], ...)' },
    'STOCKHISTORY' : { 'Summary' : 'The Excel STOCKHISTORY function retrieves historical stock price information based on a given symbol and date range. The primary purpose of STOCKHISTORY is to get the history of a financial instrument over time. The result is an array of values that spill onto the worksheet into multiple cells.', 'Purpose' : 'Retrieve stock price information', 'Return value' : 'Array of stock price information', 'Arguments' : 'stock - A ticker symbol in double quotes ("MSFT", "AAPL", "GOOG", etc.).start_date - The start date for data to be retrieved.end_date - [optional] The end date for data to be retrieved. Default is start_date.interval - [optional] Time interval. Daily = 0, weekly = 1, monthly = 2. Default is 0.headers - [optional] No header = 0, basic header = 1, instrument + header = 2. Default is 1.properties - [optional] Additional data to retrieve. Default is Date and Close. See below.', 'Syntax' : '=STOCKHISTORY(stock, start_date, [end_date], [interval], [headers], [properties], ...)' },
    'TAKE' : { 'Summary' : 'The Excel TAKE function returns a subset of a given array. The number of rows and columns to return is provided by separate rows and columns arguments. Rows and columns can be extracted from the start or end of the given array.', 'Purpose' : 'Get a subset of an array', 'Return value' : 'A subset of a given array', 'Arguments' : 'array - The source array or range.rows - [optional] Number of rows to return as an integer.col - [optional] Number of columns to return as an integer.', 'Syntax' : '=TAKE(array, [rows], [col])' },
    'TEXTAFTER' : { 'Summary' : 'The Excel TEXTAFTER function returns the text that occurs after a given substring or delimiter. In cases where multiple delimiters appear in the text, TEXTAFTER can return text after the nth occurrence of a delimiter.', 'Purpose' : 'Extract text after delimiter', 'Return value' : 'Extracted text', 'Arguments' : 'text - The text string to extract from.delimiter - The character(s) that delimit the text.instance_num - [optional] The instance of the delimiter in text. Default is 1.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.match_end - [optional] Treat end of text as delimiter. 0 = disabled, 1 = enabled. Default is 0.if_not_found - [optional] Value to return when no match is found. #N/A is default.', 'Syntax' : '=TEXTAFTER(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found])' },
    'TEXTBEFORE' : { 'Summary' : 'The Excel TEXTBEFORE function returns the text that occurs before a given substring or delimiter. In cases where multiple delimiters appear in the text, TEXTBEFORE can return text before the nth occurrence of the delimiter.', 'Purpose' : 'Extract text before delimiter', 'Return value' : 'Extracted text', 'Arguments' : 'text - The text string to extract from.delimiter - The character(s) that delimit the text.instance_num - [optional] The instance of the delimiter in text. Default is 1.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.match_end - [optional] Treat end of text as delimiter. 0 = disabled, 1 = enabled. Default is 0.if_not_found - [optional] Value to return when no match is found. #N/A is default.', 'Syntax' : '=TEXTBEFORE(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found])' },
    'TEXTSPLIT' : { 'Summary' : 'The Excel TEXTSPLIT function splits text by a given delimiter to an array that spills into multiple cells. TEXTSPLIT can split text into rows or columns.', 'Purpose' : 'Split a text string with a delimiter', 'Return value' : 'Text in multiple cells ', 'Arguments' : 'text - The text string to split.col_delimiter - The character(s) to delimit columns.row_delimiter - [optional] The character(s) to delimit rows.ignore_empty - [optional] Ignore empty values. TRUE = ignore, FALSE = preserve. Default is FALSE.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.pad_with - [optional] Value to pad missing values in 2d arrays.', 'Syntax' : '=TEXTSPLIT(text, col_delimiter, [row_delimiter], [ignore_empty], [match_mode], [pad_with])' },
    'TOCOL' : { 'Summary' : 'The Excel TOCOL function transforms an array into a single column. By default, TOCOL will scan values by row, but TOCOL can also scan values by column.', 'Purpose' : 'Transform array to single column', 'Return value' : 'A single column of values', 'Arguments' : 'array - The array to transform.ignore - Setting to ignore blanks and errors.scan_by_column - Scan array by column. TRUE=column, FALSE=row (default=TRUE).', 'Syntax' : '=TOCOL(array, ignore, scan_by_column)' },
    'TOROW' : { 'Summary' : 'The Excel TOROW function transforms an array into a single row. By default, TOROW will scan values by row, but TOROW can also scan values by column.', 'Purpose' : 'Transform array to single row', 'Return value' : 'A single row of values', 'Arguments' : 'array - The array to transform.ignore - Control to ignore blanks and errors.scan_by_column - Scan array by column. TRUE = column, FALSE = row (default = TRUE).', 'Syntax' : '=TOROW(array, ignore, scan_by_column)' },
    'UNIQUE' : { 'Summary' : 'The Excel UNIQUE function returns a list of unique values in a list or range. Values can be text, numbers, dates, times, etc.', 'Purpose' : 'Extract unique values from range', 'Return value' : 'Array of unique values', 'Arguments' : 'array - Range or array from which to extract unique values.by_col - [optional] How to compare and extract. By row = FALSE (default); by column = TRUE.exactly_once - [optional] TRUE = values that occur once, FALSE= all unique values (default).', 'Syntax' : '=UNIQUE(array, [by_col], [exactly_once])' },
    'VALUETOTEXT' : { 'Summary' : 'The Excel VALUETOTEXT function converts a value to text. By default, text values pass though unaffected. However, in strict mode, text values are enclosed in double quotes (""). Numeric values are converted to text in all cases and number formatting is lost.', 'Purpose' : 'Converts a value to a text string', 'Return value' : 'Value as a text string', 'Arguments' : 'value - The value to convert to text.format - [optional] Output format. 0 = concise (default), and 1 = strict.', 'Syntax' : '=VALUETOTEXT(value, [format])' },
    'VSTACK' : { 'Summary' : 'The Excel VSTACK function combines arrays vertically into a single array. Each subsequent array is appended to the bottom of the previous array.', 'Purpose' : 'Combine ranges or arrays vertically', 'Return value' : 'A single combined range or array', 'Arguments' : 'array1 - The first array or range to combine.array2 - [optional] The second array or range to combine.', 'Syntax' : '=VSTACK(array1, [array2], ...)' },
    'WRAPCOLS' : { 'Summary' : 'The Excel WRAPCOLS function converts a one-dimensional array into a two-dimensional array by wrapping values into separate columns. The length of each column is given as the wrap_count argument: when the count is reached, WRAPCOLS starts a new column.', 'Purpose' : 'Wrap array into columns', 'Return value' : 'Array wrapped by column', 'Arguments' : 'vector - The array or range to wrap.wrap_count - Max values in each column.pad_with - [optional] Value to use for unfilled places.', 'Syntax' : '=WRAPCOLS(vector, wrap_count, [pad_with])' },
    'WRAPROWS' : { 'Summary' : 'The Excel WRAPROWS function converts a one-dimensional array into a two-dimensional array by wrapping values into separate rows. The length of each row is given as the wrap_count argument: when the count is reached, WRAPROWS starts a new row.', 'Purpose' : 'Wrap array into rows', 'Return value' : 'Array wrapped by row', 'Arguments' : 'vector - The array or range to wrap.wrap_count - Max values in each row.pad_with - [optional] Value to use for unfilled places.', 'Syntax' : '=WRAPROWS(vector, wrap_count, [pad_with])' },
    'XLOOKUP' : { 'Summary' : 'The Excel XLOOKUP function is a modern and flexible replacement for older functions like VLOOKUP, HLOOKUP, and LOOKUP. XLOOKUP supports approximate and exact matching, wildcards (* ?) for partial matches, and lookups in vertical or horizontal ranges.', 'Purpose' : 'Lookup values in range or array', 'Return value' : 'Matching value(s) from return array', 'Arguments' : 'lookup - The lookup value.lookup_array - The array or range to search.return_array - The array or range to return.not_found - [optional] Value to return if no match found.match_mode - [optional] 0 = exact match (default), -1 = exact match or next smallest, 1 = exact match or next larger, 2 = wildcard match.search_mode - [optional] 1 = search from first (default), -1 = search from last, 2 = binary search ascending, -2 = binary search descending.', 'Syntax' : '=XLOOKUP(lookup, lookup_array, return_array, [not_found], [match_mode], [search_mode])' },
    'XMATCH' : { 'Summary' : 'The Excel XMATCH function performs a lookup and returns a position in vertical or horizontal ranges. It is a more robust and flexible successor to the MATCH function. XMATCH supports approximate and exact matching, reverse search, and wildcards (* ?) for partial matches. ', 'Purpose' : 'Get the position of an item in a list or table', 'Return value' : 'Numeric position in lookup array', 'Arguments' : 'lookup_value - The lookup value.lookup_array - The array or range to search.match_mode - [optional] 0 = exact match (default), -1 = exact match or next smallest, 1 = exact match or next larger, 2 = wildcard match.search_mode - [optional] 1 = search from first (default), -1 = search from last, 2 = binary search ascending, -2 = binary search descending.', 'Syntax' : '=XMATCH(lookup_value, lookup_array, [match_mode], [search_mode])' },
    'BIN2DEC' : { 'Summary' : 'The Excel BIN2DEC function converts a binary number to the decimal equivalent. The input number must contain only zeros and ones and be less than 10 characters long, otherwise the function returns the #NUM! error value.', 'Purpose' : 'Converts a binary number to decimal', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The binary number you want to convert to decimal.', 'Syntax' : '=BIN2DEC(number)' },
    'BIN2HEX' : { 'Summary' : 'The Excel BIN2HEX function converts a binary number to its hexadecimal equivalent.', 'Purpose' : 'Converts a binary number to hexadecimal', 'Return value' : 'Hexadecimal number', 'Arguments' : 'number - The binary number you want to convert to hexadecimal.places - [optional] If omitted uses the least number of characters required to represent the number, otherwise pads the result with zeros up to the specified number of places.', 'Syntax' : '=BIN2HEX(number, [places])' },
    'BIN2OCT' : { 'Summary' : 'The Excel BIN2OCT function converts a binary number to its octal equivalent.', 'Purpose' : 'Converts a binary number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The binary number you want to convert to octal.places - [optional] If omitted uses the least number of characters required to represent the number, otherwise pads the result with zeros up to the specified number of places.', 'Syntax' : '=BIN2OCT(number, [places])' },
    'BITAND' : { 'Summary' : 'The Excel BITAND function returns a decimal number representing the bitwise AND of two numbers.', 'Purpose' : 'Returns a \'Bitwise And\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITAND(number1, number2)' },
    'BITLSHIFT' : { 'Summary' : 'The Excel BITLSHIFT function shifts a number by the specified number of bits, effectively doubling or halving the number a specified number of times.', 'Purpose' : 'Returns a number shifted left by some number of bits', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The number to be bit shifted.shift_amount - The amount of bits to shift, if negative shifts bits to the right instead.', 'Syntax' : '=BITLSHIFT(number, shift_amount)' },
    'BITOR' : { 'Summary' : 'The Excel BITOR function returns a decimal number representing the bitwise OR of two numbers. For each corresponding bit in the binary representation of the numbers a logical OR operation is performed, and the resulting number returned.', 'Purpose' : 'Returns a \'Bitwise Or\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITOR(number1, number2)' },
    'BITRSHIFT' : { 'Summary' : 'The Excel BITRSHIFT function shifts a number by the specified number of bits, effectively halving or doubling the number a specified number of times.', 'Purpose' : 'Returns a number shifted right by some number of bits', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The number to be bit shifted.shift_amount - The amount of bits to shift to the right, if negative shifts bits to the left instead.', 'Syntax' : '=BITRSHIFT(number, shift_amount)' },
    'BITXOR' : { 'Summary' : 'The Excel BITXOR function returns a decimal number representing the bitwise XOR of two numbers. For each corresponding bit in the binary representation of the numbers a logical XOR operation is performed and the resulting number returned.', 'Purpose' : 'Returns a \'Bitwise Xor\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITXOR(number1, number2)' },
    'COMPLEX' : { 'Summary' : 'The Excel COMPLEX function creates a complex number with given real and imaginary coefficients. COMPLEX returns a text result in the form x + yi or x + yj.', 'Purpose' : 'Convert coefficients to complex number', 'Return value' : 'Complex number as text', 'Arguments' : 'real_num - The real number.i_num - The imaginary number.suffix - [optional] The suffix, either "i" or "j".', 'Syntax' : '=COMPLEX(real_num, i_num, [suffix])' },
    'CONVERT' : { 'Summary' : 'The Excel CONVERT function converts a number in one measurement system to another. For example, you can use CONVERT to convert feet into meters, pounds into kilograms, Fahrenheit to Celsius, gallons into liters, and for many other unit conversions.', 'Purpose' : 'Convert measurement units', 'Return value' : 'A number in the new measurement system', 'Arguments' : 'number - The numeric value to convert.from_unit - The starting units for number.to_unit - The ending units for the result.', 'Syntax' : '=CONVERT(number, from_unit, to_unit)' },
    'DEC2BIN' : { 'Summary' : 'The Excel DEC2BIN function converts a decimal number to its binary equivalent.', 'Purpose' : 'Converts a decimal number to binary', 'Return value' : 'Binary number', 'Arguments' : 'number - The decimal number you want to convert to binary.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2BIN(number, [places])' },
    'DEC2HEX' : { 'Summary' : 'The Excel DEC2HEX function converts a decimal number to its hexadecimal equivalent.', 'Purpose' : 'Converts a decimal number to hexadecimal', 'Return value' : 'Hexadecimal number', 'Arguments' : 'number - The decimal number you want to convert to hexadecimal.places - [optional] Pads the resulting number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2HEX(number, [places])' },
    'DEC2OCT' : { 'Summary' : 'The Excel DEC2OCT function converts a decimal number to its octal equivalent.', 'Purpose' : 'Converts a decimal number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The decimal number you want to convert to octal.places - [optional] Pads the resulting octal number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2OCT(number, [places])' },
    'DELTA' : { 'Summary' : 'The Excel DELTA function will test if two numeric values are equal. When values are equal, DELTA returns 1, otherwise, DELTA returns zero.', 'Purpose' : 'Test two values are equal', 'Return value' : 'The number one or zero', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=DELTA(number1, [number2])' },
    'HEX2BIN' : { 'Summary' : 'The Excel HEX2BIN function converts a hexadecimal number to its binary equivalent.', 'Purpose' : 'Converts a hexadecimal number to binary', 'Return value' : 'Binary number', 'Arguments' : 'number - The hexadecimal number you want to convert to binary.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=HEX2BIN(number, [places])' },
    'HEX2DEC' : { 'Summary' : 'The Excel HEX2DEC function converts a hexadecimal number to its decimal equivalent.', 'Purpose' : 'Converts a hexadecimal number to decimal', 'Return value' : 'Decimal number', 'Arguments' : 'number - The hexadecimal number you want to convert to decimal.', 'Syntax' : '=HEX2DEC(number)' },
    'HEX2OCT' : { 'Summary' : 'The Excel HEX2OCT function converts a hexadecimal number to its octal equivalent.', 'Purpose' : 'Converts a hexadecimal number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The hexadecimal number you want to convert to octal.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=HEX2OCT(number, [places])' },
    'IMABS' : { 'Summary' : 'The Excel IMABS function returns the absolute value of a complex number in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get absolute value of complex number', 'Return value' : 'Absolute value as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMABS(inumber)' },
    'IMAGINARY' : { 'Summary' : 'The Excel IMAGINARY function returns the imaginary coefficient of a complex number given in the form x + yi or x + yj.', 'Purpose' : 'Get imaginary coefficient of complex number', 'Return value' : 'Imaginary coefficient as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMAGINARY(inumber)' },
    'IMPOWER' : { 'Summary' : 'The Excel IMPOWER function returns a complex number raised to a given power. The complex number must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Raise complex number to given power', 'Return value' : 'Complex number as text', 'Arguments' : 'inumber - A complex number.number - Power to raise number.', 'Syntax' : '=IMPOWER(inumber, number)' },
    'IMPRODUCT' : { 'Summary' : 'The Excel IMPRODUCT function returns the product of one or more complex numbers. The complex number must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get product of complex numbers', 'Return value' : 'Product as complex number', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - [optional] Complex number 2.', 'Syntax' : '=IMPRODUCT(inumber1, [inumber2], ...)' },
    'IMREAL' : { 'Summary' : 'The Excel IMREAL function returns the real coefficient of a complex number in the form x + yi or x + yj. ', 'Purpose' : 'Get real coefficient of complex number', 'Return value' : 'Real coefficient as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMREAL(inumber)' },
    'IMSUB' : { 'Summary' : 'The Excel IMSUB function returns the difference between two complex numbers. Complex numbers must be in the form x + yi or x + yj. Use the COMPLEX function to create complex numbers', 'Purpose' : 'Get difference between two complex numbers', 'Return value' : 'Difference between complex numbers as text', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - Complex number 2.', 'Syntax' : '=IMSUB(inumber1, inumber2)' },
    'IMSUM' : { 'Summary' : 'The Excel IMSUM function returns the sum of two or more complex numbers. The complex numbers must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get sum of complex numbers', 'Return value' : 'Sum of complex numbers as text', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - [optional] Complex number 2.', 'Syntax' : '=IMSUM(inumber1, [inumber2], ...)' },
    'ACCRINT' : { 'Summary' : 'The Excel ACCRINT function returns the accrued interest for a security that pays periodic interest', 'Purpose' : 'Get accrued interest periodic', 'Return value' : 'Accrued interest', 'Arguments' : 'id - Issue date of the security.fd - First interest date of security.sd - Settlement date of security.rate - Interest rate of security.par - Par value of security.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).calc - [optional] Calculation method (see below, default = TRUE).', 'Syntax' : '=ACCRINT(id, fd, sd, rate, par, freq, [basis], [calc])' },
    'ACCRINTM' : { 'Summary' : 'The Excel ACCRINTM function returns the accrued interest for a security that pays interest at maturity (i.e. pays interest one time only).', 'Purpose' : 'Get accrued interest at maturity', 'Return value' : 'Accrued interest', 'Arguments' : 'id - Issue date of the security.sd - Settlement date of the security.rate - Annual coupon rate.par - Par value of security.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ACCRINTM(id, sd, rate, par, [basis])' },
    'AMORDEGRC' : { 'Summary' : 'The Excel AMORDEGRC function returns the depreciation for a given accounting using a depreciation coefficient determined by asset life.', 'Purpose' : 'Depreciation for accounting period coefficient', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Asset cost.purchase - Asset purchase date.first - First period end date.salvage - Asset salvage value.period - Period for which to calculate depreciation.rate - Rate of depreciation.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=AMORDEGRC(cost, purchase, first, salvage, period, rate, [basis])' },
    'AMORLINC' : { 'Summary' : 'The Excel AMORLINC function returns the depreciation for each accounting period', 'Purpose' : 'Depreciation for accounting period', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Asset cost.purchase - Asset purchase date.first - End date of first period.salvage - Asset salvage value.period - The period for which to calculate depreciation.rate - Rate of depreciation.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=AMORLINC(cost, purchase, first, salvage, period, rate, [basis])' },
    'COUPDAYBS' : { 'Summary' : 'The Excel COUPDAYBS function returns the number of days from the beginning of the coupon period to the settlement date.', 'Purpose' : 'Get days from coupon period to settlement date', 'Return value' : 'Days as a number', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYBS(settlement, maturity, frequency, [basis])' },
    'COUPDAYS' : { 'Summary' : 'The Excel COUPDAYS function returns the number of days in a coupon period that includes the settlement date.', 'Purpose' : 'Get days in coupon period incl settlement date', 'Return value' : 'Calculated days', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYS(settlement, maturity, frequency, [basis])' },
    'COUPDAYSNC' : { 'Summary' : 'The Excel COUPDAYSNC function returns the number of days from the settlement date to the next coupon date.', 'Purpose' : 'Get days from settlement date to next coupon date', 'Return value' : 'Days to next coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYSNC(settlement, maturity, frequency, [basis])' },
    'COUPNCD' : { 'Summary' : 'The Excel COUPNCD function returns the next coupon date after the settlement date.', 'Purpose' : 'Get next coupon date after settlement date', 'Return value' : 'Next coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPNCD(settlement, maturity, frequency, [basis])' },
    'COUPNUM' : { 'Summary' : 'The Excel COUPNUM function returns the number of coupons, or interest payments, payable between the settlement date and maturity date.', 'Purpose' : 'Get number of coupons payable', 'Return value' : 'Number of coupons payable', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPNUM(settlement, maturity, frequency, [basis])' },
    'COUPPCD' : { 'Summary' : 'The Excel COUPPCD function returns the previous coupon date before the settlement date for a coupon bond.', 'Purpose' : 'Get previous coupon date before settlement date', 'Return value' : 'Previous coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPPCD(settlement, maturity, frequency, [basis])' },
    'CUMIPMT' : { 'Summary' : 'The Excel CUMIPMT function is a financial function that returns the cumulative interest paid on a loan between a start period and an end period. You can use CUMIPMT to calculate and verify the total interest paid on a loan, or the interest paid between any two payment periods.', 'Purpose' : 'Get cumulative interest paid on a loan', 'Return value' : 'The interest amount', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.start_period - First payment in calculation.end_period - Last payment in calculation.type - When payments are due. 0 = end of period. 1 = beginning of period.', 'Syntax' : '=CUMIPMT(rate, nper, pv, start_period, end_period, type)' },
    'CUMPRINC' : { 'Summary' : 'The Excel CUMPRINC function is a financial function that returns the cumulative principal paid on a loan between a start period and an end period. You can use CUMPRINC to calculate and verify the total principal paid on a loan, or the principal paid between any two payment periods.', 'Purpose' : 'Get cumulative principal paid on a loan', 'Return value' : 'The principal amount', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.start_period - First payment in calculation.end_period - Last payment in calculation.type - When payments are due. 0 = end of period. 1 = beginning of period.', 'Syntax' : '=CUMPRINC(rate, nper, pv, start_period, end_period, type)' },
    'DB' : { 'Summary' : 'The Excel DB function returns the depreciation of an asset for a specified period using the fixed-declining balance method. The calculation is based on initial asset cost, salvage value, the number of periods over which the asset is depreciated and, optionally, the number of months in the first year.', 'Purpose' : 'Depreciation - fixed-declining balance', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.month - [optional] Number of months in the first year. Defaults to 12.', 'Syntax' : '=DB(cost, salvage, life, period, [month])' },
    'DDB' : { 'Summary' : 'The Excel DDB function returns the depreciation of an asset for a given period using the double-declining balance method or another method you specify by changing the factor argument.', 'Purpose' : 'Depreciation - double-declining', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.factor - [optional] Rate at which the balance declines. If omitted, defaults to 2.', 'Syntax' : '=DDB(cost, salvage, life, period, [factor])' },
    'DISC' : { 'Summary' : 'The Excel DISC function returns the discount rate for a security.', 'Purpose' : 'Get discount rate for a security', 'Return value' : 'Discount rate as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.pr - Security price per $100 face value.redemption - Security redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=DISC(settlement, maturity, pr, redemption, [basis])' },
    'DOLLARDE' : { 'Summary' : 'The Excel DOLLARDE function converts a dollar price entered with a special notation to a dollar price displayed as a decimal number. The DOLLARFR function does the opposite conversion.', 'Purpose' : 'Convert dollar price as fraction to decimal', 'Return value' : 'Equivalent decimal number', 'Arguments' : 'fractional_dollar - Dollar component in special fractional notation.fraction - The denominator in the fractional unit. 8 = 1/8, 16 = 1/16, 32 = 1/32, etc.', 'Syntax' : '=DOLLARDE(fractional_dollar, fraction)' },
    'DOLLARFR' : { 'Summary' : 'The Excel DOLLARFR function converts a dollar price in a regular decimal number format to a dollar price in a particular fractional notation used for securities where pricing is given to the nearest 1/8, 1/16, 1/32, etc. The DOLLARDE function does the opposite conversion.', 'Purpose' : 'Convert price to fractional notation', 'Return value' : 'Dollar value in fractional notation', 'Arguments' : 'decimal_dollar - Pricing as a normal decimal number.fraction - The denominator in the fractional unit. 8 = 1/8, 16 = 1/16, 32 = 1/32, etc.', 'Syntax' : '=DOLLARFR(decimal_dollar, fraction)' },
    'DURATION' : { 'Summary' : 'The Excel DURATION function returns the annual duration of a security with periodic interest payments, calculated with the Macauley duration formula.', 'Purpose' : 'Get annual duration with periodic interest', 'Return value' : 'Duration in years', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.coupon - The security\'s annual coupon rate.yld - The security\'s annual yield.freq - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=DURATION(settlement, maturity, coupon, yld, freq, [basis])' },
    'EFFECT' : { 'Summary' : 'The Excel EFFECT function returns the effective annual interest rate, given a nominal interest rate and the number of compounding periods per year. Effective annual interest rate is the interest rate actually earned due to compounding. ', 'Purpose' : 'Get effective annual interest rate', 'Return value' : 'Effective annual interest rate', 'Arguments' : 'nominal_rate - The nominal or stated interest rate.npery - Number of compounding periods per year.', 'Syntax' : '=EFFECT(nominal_rate, npery)' },
    'FV' : { 'Summary' : 'The Excel FV function is a financial function that returns the future value of an investment. You can use the FV function to get the future value of an investment assuming periodic, constant payments with a constant interest rate.', 'Purpose' : 'Get the future value of an investment', 'Return value' : 'future value', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payment periods.pmt - The payment made each period. Must be entered as a negative number.pv - [optional] The present value of future payments. If omitted, assumed to be zero. Must be entered as a negative number.type - [optional] When payments are due. 0 = end of period, 1 = beginning of period. Default is 0.', 'Syntax' : '=FV(rate, nper, pmt, [pv], [type])' },
    'FVSCHEDULE' : { 'Summary' : 'The Excel FVSCHEDULE function returns the future value of a single sum based on a schedule of given interest rates. FVSCHEDULE can be used to find the future value of an investment with a variable or adjustable rate.', 'Purpose' : 'Get future value of principal compound interest', 'Return value' : 'Future value', 'Arguments' : 'principal - The initial investment sum.schedule - Schedule of interest rates, provided as range or array.', 'Syntax' : '=FVSCHEDULE(principal, schedule)' },
    'INTRATE' : { 'Summary' : 'The Excel INTRATE function returns the interest rate for a fully invested security.', 'Purpose' : 'Get interest rate for fully invested security', 'Return value' : 'Interest rate as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.investment - The amount originally invested.redemption - The amount received at maturity.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=INTRATE(settlement, maturity, investment, redemption, [basis])' },
    'IPMT' : { 'Summary' : 'The Excel IPMT function can be used to calculate the interest portion of a given loan payment in a given payment period. For example, you can use IPMT to get the interest amount of a payment for the first period, the last period, or any period in between.', 'Purpose' : 'Get interest in given period', 'Return value' : 'The interest amount', 'Arguments' : 'rate - The interest rate per period.per - The payment period of interest.nper - The total number of payment periods.pv - The present value, or total value of all payments now.fv - [optional] The cash balance desired after last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=IPMT(rate, per, nper, pv, [fv], [type])' },
    'IRR' : { 'Summary' : 'The Excel IRR function is a financial function that returns the internal rate of return (IRR) for a series of cash flows that occur at regular intervals.', 'Purpose' : 'Calculate internal rate of return', 'Return value' : 'Calculated return as percentage', 'Arguments' : 'values - Array or reference to cells that contain values.guess - [optional] An estimate for expected IRR. Default is .1 (10%).', 'Syntax' : '=IRR(values, [guess])' },
    'ISPMT' : { 'Summary' : 'The Excel ISPMT function calculates the interest paid during a given period of an investment where principal payments are equal. The given period is specified as a zero-based number instead of a 1-based number.', 'Purpose' : 'Get interest paid for specific period', 'Return value' : 'Interest amount in given period', 'Arguments' : 'rate - Interest rate.per - Period (starts with zero, not 1).nper - Number of periods.pv - Present value.', 'Syntax' : '=ISPMT(rate, per, nper, pv)' },
    'MDURATION' : { 'Summary' : 'The Excel MDURATION function returns the Macauley modified duration for a security with an assumed par value of $100', 'Purpose' : 'Get Macauley modified duration par value of $100', 'Return value' : 'Modified duration in years', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.coupon - The security\'s annual coupon rate.yld - The security\'s annual yield.freq - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=MDURATION(settlement, maturity, coupon, yld, freq, [basis])' },
    'MIRR' : { 'Summary' : 'The Excel MIRR function is a financial function that returns the modified internal rate of return (MIRR) for a series of cash flows, taking into account both discount rate and reinvestment rate for future cash flows.', 'Purpose' : 'Calculate modified internal rate of return', 'Return value' : 'Calculated return as percentage', 'Arguments' : 'values - Array or reference to cells that contain cash flows.finance_rate - Required rate of return (discount rate) as percentage.reinvest_rate - Interest rate received on cash flows reinvested as percentage.', 'Syntax' : '=MIRR(values, finance_rate, reinvest_rate)' },
    'NOMINAL' : { 'Summary' : 'The Excel NOMINAL function returns the nominal interest rate when given an effective annual interest rate and the number of compounding periods per year. The effective rate is the actual rate due to compounding. The nominal rate is typically the stated rate.', 'Purpose' : 'Get annual nominal interest rate', 'Return value' : 'Nominal interest rate', 'Arguments' : 'effect_rate - The effective annual interest rate.npery - Number of compounding periods per year.', 'Syntax' : '=NOMINAL(effect_rate, npery)' },
    'NPER' : { 'Summary' : 'The Excel NPER function is a financial function that returns the number of periods for a loan or investment. You can use the NPER function to get the number of payment periods for a loan, given the amount, the interest rate, and periodic payment amount.', 'Purpose' : 'Get number of periods for loan or investment', 'Return value' : 'The number of periods', 'Arguments' : 'rate - The interest rate per period.pmt - The payment made each period.pv - The present value, or total value of all payments now.fv - [optional] The future value, or a cash balance you want after the last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=NPER(rate, pmt, pv, [fv], [type])' },
    'NPV' : { 'Summary' : 'The Excel NPV function is a financial function that calculates the net present value (NPV) of an investment using a discount rate and a series of future cash flows.', 'Purpose' : 'Calculate net present value', 'Return value' : 'Net present value', 'Arguments' : 'rate - Discount rate over one period.value1 - First value(s) representing cash flows.value2 - [optional] Second value(s) representing cash flows.', 'Syntax' : '=NPV(rate, value1, [value2], ...)' },
    'ODDFPRICE' : { 'Summary' : 'The Excel ODDFPRICE function returns the price per $100 face value of a security with an odd (irregular) first period.', 'Purpose' : 'Get price per $100 odd first period', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.fd - First coupon date.rate - Annual coupon rate of security.yld - Annual required rate of return.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDFPRICE(sd, md, id, fd, rate, yld, redem, freq, [basis])' },
    'ODDFYIELD' : { 'Summary' : 'The Excel ODDFYIELD function returns the yield of a security with an odd (irregular) first period.', 'Purpose' : 'Get yield security with odd first period', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.fd - First coupon date.rate - Annual coupon rate of security.pr - Price of security.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDFYIELD(sd, md, id, fd, rate, pr, redem, freq, [basis])' },
    'ODDLPRICE' : { 'Summary' : 'The Excel ODDLPRICE function returns the price per $100 face value of a security with an odd (irregular) last period.', 'Purpose' : 'Get price per $100 face value with odd last period', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Last interest date of security.rate - Interest rate of security.yld - Annual required rate of return.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDLPRICE(sd, md, id, rate, yld, redem, freq, [basis])' },
    'ODDLYIELD' : { 'Summary' : 'The Excel ODDLYIELD function returns the yield of a security with an odd (irregular) last period.', 'Purpose' : 'Get yield of security with odd last period', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.ld - Last interest date of security.rate - Interest rate of security.pr - Price per $100 face value.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDLYIELD(sd, md, ld, rate, pr, redem, freq, [basis])' },
    'PDURATION' : { 'Summary' : 'The Excel PDURATION function returns the number of periods required for an investment to reach a desired value.', 'Purpose' : 'Get periods required to reach given value', 'Return value' : 'Required time in periods', 'Arguments' : 'rate - Interest rate per period.pv - Present value of the investment.fv - Future value of the investment.', 'Syntax' : '=PDURATION(rate, pv, fv)' },
    'PMT' : { 'Summary' : 'The Excel PMT function is a financial function that returns the periodic payment for a loan. You can use the PMT function to figure out payments for a loan, given the loan amount, number of periods, and interest rate.', 'Purpose' : 'Get the periodic payment for a loan', 'Return value' : 'loan payment as a number', 'Arguments' : 'rate - The interest rate for the loan.nper - The total number of payments for the loan.pv - The present value, or total value of all loan payments now.fv - [optional] The future value, or a cash balance you want after the last payment is made. Defaults to 0 (zero).type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=PMT(rate, nper, pv, [fv], [type])' },
    'PPMT' : { 'Summary' : 'The Excel PPMT function can be used to calculate the principal portion of a given loan payment. For example, you can use PPMT to get the principal amount of a payment for the first period, the last period, or any period in between.', 'Purpose' : 'Get principal payment in given period', 'Return value' : 'The principal payment', 'Arguments' : 'rate - The interest rate per period.per - The payment period of interest.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.fv - [optional] The cash balance desired after last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=PPMT(rate, per, nper, pv, [fv], [type])' },
    'PRICE' : { 'Summary' : 'The Excel PRICE function returns the price per $100 face value of a security that pays periodic interest.', 'Purpose' : 'Get price per $100 face value - periodic interest', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.rate - Annual coupon rate.yld - Annual required rate of return.redemption - Redemption value per $100 face value.frequency - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICE(sd, md, rate, yld, redemption, frequency, [basis])' },
    'PRICEDISC' : { 'Summary' : 'The Excel PRICEDISC function returns the price per $100 face value of a discounted security.', 'Purpose' : 'Get price per $100 discounted security', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.discount - Discount rate of the security.redemption - Redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICEDISC(sd, md, discount, redemption, [basis])' },
    'PRICEMAT' : { 'Summary' : 'The Excel PRICEMAT function returns the price per $100 face value of a security that pays interest at maturity.', 'Purpose' : 'Get price per $100 interest at maturity', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.rate - Security interest rate at date of issue.yld - Annual yield of the security.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICEMAT(sd, md, id, rate, yld, [basis])' },
    'PV' : { 'Summary' : 'The Excel PV function is a financial function that returns the present value of an investment. You can use the PV function to get the value in today\'s dollars of a series of future payments, assuming periodic, constant payments and a constant interest rate.', 'Purpose' : 'Get the present value of an investment', 'Return value' : 'Present value', 'Arguments' : 'rate - The interest rate per period.nper - The number of payment periods.pmt - The payment made each period.fv - [optional] Future value. If omitted, defaults to zero.type - [optional] Payment type, 0 = end of period, 1 = beginning of period. Default is 0.', 'Syntax' : '=PV(rate, nper, pmt, [fv], [type])' },
    'RATE' : { 'Summary' : 'The Excel RATE function is a financial function that returns the interest rate per period of an annuity. You can use RATE to calculate the periodic interest rate, then multiply as required to derive the annual interest rate. The RATE function calculates by iteration.', 'Purpose' : 'Get the interest rate per period of an annuity', 'Return value' : 'The interest rate per period', 'Arguments' : 'nper - The total number of payment periods.pmt - The payment made each period.pv - The present value, or total value of all loan payments now.fv - [optional] The future value, or desired cash balance after last payment. Default is 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.guess - [optional] Your guess on the rate. Default is 10%.', 'Syntax' : '=RATE(nper, pmt, pv, [fv], [type], [guess])' },
    'RECEIVED' : { 'Summary' : 'The Excel RECEIVED function returns the amount received at maturity for a fully invested security.', 'Purpose' : 'Get amount received at maturity', 'Return value' : 'Amount received', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.investment - Amount investment in the security.discount - The security\'s discount rate.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=RECEIVED(settlement, maturity, investment, discount, [basis])' },
    'RRI' : { 'Summary' : 'The Excel RRI function returns an equivalent interest rate for the growth of an investment. You can use RRI to calculate Compound Annual Growth Rate (CAGR) in Excel.', 'Purpose' : 'Get equivalent interest rate for growth', 'Return value' : 'Calculated interest rate', 'Arguments' : 'nper - Number of periods.pv - Present value of investment.fv - Future value of investment.', 'Syntax' : '=RRI(nper, pv, fv)' },
    'SLN' : { 'Summary' : 'The Excel SLN function returns the depreciation of an asset for one period, calculated with a straight-line method. The calculated depreciation is based on initial asset cost, salvage value, and the number of periods over which the asset is depreciated.', 'Purpose' : 'Depreciation - straight-line', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.', 'Syntax' : '=SLN(cost, salvage, life)' },
    'SYD' : { 'Summary' : 'The Excel SYD function returns the "sum-of-years" depreciation for an asset in a given period. The calculated depreciation is based on initial asset cost, salvage value, and the number of periods over which the asset is depreciated.', 'Purpose' : 'Depreciation - sum-of-years', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.', 'Syntax' : '=SYD(cost, salvage, life, period)' },
    'TBILLEQ' : { 'Summary' : 'The Excel TBILLEQ function returns the bond-equivalent yield for a Treasury bill.', 'Purpose' : 'Get bond-equivalent yield for a Treasury bill', 'Return value' : 'Yield as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.discount - Discount rate of the security.', 'Syntax' : '=TBILLEQ(settlement, maturity, discount)' },
    'TBILLPRICE' : { 'Summary' : 'The Excel TBILLPRICE function returns the price per $100 face value for a Treasury bill.', 'Purpose' : 'Get price per $100 Treasury bill', 'Return value' : 'Price per $100', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.discount - The discount rate for the security.', 'Syntax' : '=TBILLPRICE(settlement, maturity, discount)' },
    'TBILLYIELD' : { 'Summary' : 'The Excel TBILLYIELD function returns the yield for a Treasury bill.', 'Purpose' : 'Get yield for a Treasury bill', 'Return value' : 'Yield as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.price - Price per $100.', 'Syntax' : '=TBILLYIELD(settlement, maturity, price)' },
    'VDB' : { 'Summary' : 'The Excel VDB function returns the depreciation of an asset for given period, using the double-declining balance method or another method specified by changing the factor argument. By default, the VDB function will switch to straight line calculation. VDB stands for variable declining balance.', 'Purpose' : 'Depreciation - double-declining variable', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.start - Start period.end - End period.factor - [optional] Rate at which the balance declines. If omitted, defaults to 2.no_switch - [optional] Don\'t switch to straight line. Default is FALSE.', 'Syntax' : '=VDB(cost, salvage, life, start, end, [factor], [no_switch])' },
    'XIRR' : { 'Summary' : 'The Excel XIRR function is a financial function that returns the internal rate of return (IRR) for a series of cash flows that occur at irregular intervals. The XIRR function uses iteration to arrive at a result.', 'Purpose' : 'Calculate internal rate of return for irregular cash flows', 'Return value' : 'Calculated internal rate of return', 'Arguments' : 'values - Array or reference to cells that contain cash flows.dates - Dates that correspond to cash flows, in any order.guess - [optional] An estimate for expected IRR. Default is 0.1 (10%).', 'Syntax' : '=XIRR(values, dates, [guess])' },
    'XNPV' : { 'Summary' : 'The Excel XNPV function is a financial function that calculates the net present value (NPV) of an investment using a discount rate and a series of cash flows that occur at irregular intervals.', 'Purpose' : 'Calculate net present value for irregular cash flows', 'Return value' : 'Net present value', 'Arguments' : 'rate - Discount rate to apply to the cash flows.values - Values representing cash flows.dates - Dates that correspond to cash flows, in any order.', 'Syntax' : '=XNPV(rate, values, dates)' },
    'YIELD' : { 'Summary' : 'The Excel YIELD function returns the yield on a security that pays periodic interest.', 'Purpose' : 'Get yield for security that pays periodic interest', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.rate - Annual coupon rate.pr - Security\'s price per $100 face value.redemption - Redemption value per $100 face value.frequency - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=YIELD(sd, md, rate, pr, redemption, frequency, [basis])' },
    'YIELDDISC' : { 'Summary' : 'The Excel YIELDDISC function returns the annual yield for a discounted security, such as a Treasury bill, that is issued at a discount but that matures at face value.', 'Purpose' : 'Get annual yield for discounted security', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.pr - Price of security.redemption - Redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=YIELDDISC(sd, md, pr, redemption, [basis])' },
    'YIELDMAT' : { 'Summary' : 'The Excel YIELDMAT function returns the annual yield of a security that pays interest at maturity.', 'Purpose' : 'Get annual yield of security interest at maturity', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.rate - Interest rate of security.pr - Price per $100 face value.basis - [optional] Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).', 'Syntax' : '=YIELDMAT(sd, md, id, rate, pr, [basis])' },
    'CELL' : { 'Summary' : 'The Excel CELL function returns information about a cell in a worksheet. The type of information to be returned is specified as info_type. CELL can get things like address and filename, as well as detailed info about the formatting used in the cell. See below for a full list of information available.', 'Purpose' : 'Get information about a cell', 'Return value' : 'A text value', 'Arguments' : 'info_type - The type of information to return about the reference.reference - [optional] The reference from which to extract information.', 'Syntax' : '=CELL(info_type, [reference])' },
    'INFO' : { 'Summary' : 'The Excel INFO function returns information about the current environment, including platform, Excel version, number of worksheets in a workbook, and so on. To use the INFO function, supply the type of information you want as text. There are seven types of information available, summarized in the table below.', 'Purpose' : 'Get information about current environment', 'Return value' : 'The information requested', 'Arguments' : 'type_text - The information type to return as text.', 'Syntax' : '=INFO(type_text)' },
    'ISBLANK' : { 'Summary' : 'The Excel ISBLANK function returns TRUE when a cell is empty, and FALSE when a cell is not empty. For example, if A1 contains "apple", ISBLANK(A1) returns FALSE.', 'Purpose' : 'Test if a cell is empty', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISBLANK(value)' },
    'ISERR' : { 'Summary' : 'The Excel ISERR function returns TRUE for any error type except the #N/A error. You can use the ISERR function together with the IF function to test for an error and display a custom message, or perform a different calculation if found.', 'Purpose' : 'Test for any error but #N/A', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check for any error but #N/A.', 'Syntax' : '=ISERR(value)' },
    'ISERROR' : { 'Summary' : 'The Excel ISERROR function returns TRUE for any error type excel generates, including #N/A, #VALUE!, #REF!, #DIV/0!, #NUM!, #NAME?, or #NULL! You can use ISERROR together with the IF function to test for errors and display a custom message, or run a different calculation when an error occurs.', 'Purpose' : 'Test for any error', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check for any error.', 'Syntax' : '=ISERROR(value)' },
    'ISEVEN' : { 'Summary' : 'The Excel ISEVEN function returns TRUE when a value is an even number, and FALSE when a value is an odd number. ISEVEN will return the #VALUE error if a value is not numeric.', 'Purpose' : 'Test if a value is even', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The numeric value to check.', 'Syntax' : '=ISEVEN(value)' },
    'ISFORMULA' : { 'Summary' : 'The Excel ISFORMULA function returns TRUE if a cell contains a formula, and FALSE if not. When a cell contains a formula ISFORMULA will return TRUE regardless of the formula\'s output or error conditions.', 'Purpose' : 'Test if cell contains a formula', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'reference - Reference to cell or cell range.', 'Syntax' : '=ISFORMULA(reference)' },
    'ISLOGICAL' : { 'Summary' : 'The Excel ISLOGICAL function returns TRUE when a cell contains the logical values TRUE or FALSE, and returns FALSE for cells that contain any other value, including empty cells. ', 'Purpose' : 'Test if a value is logical', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to test as logical.', 'Syntax' : '=ISLOGICAL(value)' },
    'ISNA' : { 'Summary' : 'The Excel ISNA function returns TRUE when a cell contains the #N/A error and FALSE for any other value, or any other error type. You can use the ISNA function with the IF function test for #N/A and display a friendly message if the error occurs.', 'Purpose' : 'Test for the #N/A error', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check if #N/A.', 'Syntax' : '=ISNA(value)' },
    'ISNONTEXT' : { 'Summary' : 'The Excel ISNONTEXT function returns TRUE when a cell contains any value except text. This includes numbers, dates, times, errors, and formulas that do not return text. ISNONTEXT also returns TRUE when a cell is empty.', 'Purpose' : 'Test for a non-text value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISNONTEXT(value)' },
    'ISNUMBER' : { 'Summary' : 'The Excel ISNUMBER function returns TRUE when a cell contains a number, and FALSE if not. You can use ISNUMBER to check that a cell contains a numeric value, or that the result of another function is a number.', 'Purpose' : 'Test for numeric value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISNUMBER(value)' },
    'ISODD' : { 'Summary' : 'The Excel ISODD function returns TRUE when a value is an odd number, and FALSE when a value is an even number. ISODD will return the #VALUE error if a value is not numeric.', 'Purpose' : 'Test if a value is odd', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The numeric value to check.', 'Syntax' : '=ISODD(value)' },
    'ISREF' : { 'Summary' : 'The Excel ISREF returns TRUE when a cell contains a reference and FALSE if not. You can use the ISREF function to check for a reference in a formula.', 'Purpose' : 'Test for a reference', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISREF(value)' },
    'ISTEXT' : { 'Summary' : 'The Excel ISTEXT function returns TRUE when a cell contains a text value, and FALSE if the cell contains any other value. You can use the ISTEXT function to check if a cell contains a text value, or a numeric value entered as text.', 'Purpose' : 'Test for a text value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISTEXT(value)' },
    'N' : { 'Summary' : 'The Excel N function returns a number when given a value. The N function can be used to convert TRUE and FALSE to 1 and 0 respectively. When given a text value, the N function returns zero.', 'Purpose' : 'Convert a value to a number', 'Return value' : 'A number or error code', 'Arguments' : 'value - The value to convert to a number.', 'Syntax' : '=N(value)' },
    'NA' : { 'Summary' : 'The Excel NA function returns the #N/A error. #N/A means "not available" or "no value available". You can use the NA function to display the #N/A error when information is missing.', 'Purpose' : 'Create an #N/A error', 'Return value' : 'The #N/A error', 'Arguments' : '', 'Syntax' : '=NA()' },
    'SHEET' : { 'Summary' : 'The Excel SHEET function returns the index number of a sheet in Excel. SHEET will report the sheet number for a cell reference, named range, or Excel Table.', 'Purpose' : 'Get sheet index number', 'Return value' : 'The index number of a given sheet', 'Arguments' : 'value - [optional] The value to check.', 'Syntax' : '=SHEET([value])' },
    'SHEETS' : { 'Summary' : 'The Excel SHEETS function returns the total number of sheets in a given reference. When no arguments are supplied SHEETS returns the total number of sheets in the workbook.', 'Purpose' : 'Get number of sheets in a reference', 'Return value' : 'Sheet count', 'Arguments' : 'reference - [optional] A valid Excel reference.', 'Syntax' : '=SHEETS([reference])' },
    'T' : { 'Summary' : 'The Excel T function returns text when given a text value and an empty string ("") for numbers, dates, and the logical values TRUE and FALSE. You can use the T function to remove values that are not text.', 'Purpose' : 'Filter text values only', 'Return value' : 'Value as text when text', 'Arguments' : 'value - The value to return as text.', 'Syntax' : '=T(value)' },
    'TYPE' : { 'Summary' : 'The Excel TYPE function returns a numeric code representing "type" in 5 categories: number = 1, text = 2, logical = 4, error = 16, and array = 64. Use TYPE when the operation of a formula depends on the type of value in a particular cell.', 'Purpose' : 'Get the type of value in a cell', 'Return value' : 'A numeric code representing type', 'Arguments' : 'value - The value to check the type of.', 'Syntax' : '=TYPE(value)' },
    'ABS' : { 'Summary' : 'The Excel ABS function returns the absolute value of a number. ABS converts negative numbers to positive numbers, and positive numbers are unaffected.', 'Purpose' : 'Find the absolute value of a number', 'Return value' : 'A positive number.', 'Arguments' : 'number - The number to get the absolute value of.', 'Syntax' : '=ABS(number)' },
    'AGGREGATE' : { 'Summary' : 'The Excel AGGREGATE function returns a aggregate calculation like AVERAGE, COUNT, MAX, etc., optionally ignoring hidden rows and errors. A total of 19 operations are available, specified by function number in the first argument (see table for options).', 'Purpose' : 'Return aggregate calculation', 'Return value' : 'Depends on function specified', 'Arguments' : 'function_num - Operation to perform (1-19).options - Values to ignore (0-7).ref1 - First argument.ref2 - [optional] Second argument (k).', 'Syntax' : '=AGGREGATE(function_num, options, ref1, [ref2], ...)' },
    'ARABIC' : { 'Summary' : 'The Excel ARABIC function converts a Roman numeral as text to an Arabic numeral. For example, the formula =ARABIC("VII") returns 7.', 'Purpose' : 'Converts a Roman numerals to an Arabic numerals', 'Return value' : 'A number (in Arabic numeral)', 'Arguments' : 'roman_text - The Roman numeral in text that you want to convert.', 'Syntax' : '=ARABIC(roman_text)' },
    'BASE' : { 'Summary' : 'The Excel BASE function converts a number to the text representation of the same number in a given base, where base is provided as the radix argument.', 'Purpose' : 'Convert number to another base.', 'Return value' : 'The text representation of the converted number.', 'Arguments' : 'number - The number to convert to a given base.radix - The base to convert to.min_length - [optional] The minimum string length to return, achieved by padding with zeros.', 'Syntax' : '=BASE(number, radix, [min_length])' },
    'CEILING' : { 'Summary' : 'The Excel CEILING function rounds a given number up to the nearest specified multiple. CEILING works like the MROUND function, but CEILING always rounds up.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=CEILING(number, significance)' },
    'CEILING.MATH' : { 'Summary' : 'The Excel CEILING.MATH function rounds a number up to a specified multiple. Unlike the CEILING function, CEILING.MATH defaults to a multiple of 1, and provides explicit control over rounding direction for negative numbers.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.mode - [optional] Round negative numbers toward or away from zero. Default is 0.', 'Syntax' : '=CEILING.MATH(number, [significance], [mode])' },
    'CEILING.PRECISE' : { 'Summary' : 'The Excel CEILING.PRECISE function rounds a number up to a given multiple. CEILING.PRECISE defaults to a multiple of 1, and always rounds negative numbers toward zero.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.', 'Syntax' : '=CEILING.PRECISE(number, [significance])' },
    'COMBIN' : { 'Summary' : 'The Excel COMBIN function returns the number of combinations for a given number of items. The COMBIN function does not allow repetitions. To count combinations that allow repetitions, use the COMBINA function.', 'Purpose' : 'Get number of combinations without repetitions', 'Return value' : 'Number of combinations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=COMBIN(number, number_chosen)' },
    'COMBINA' : { 'Summary' : 'The Excel COMBINA function returns the number of combinations with repetitions allowed. To count combinations that do not allow repetitions, use the COMBIN function.', 'Purpose' : 'Get number of combinations with repetitions', 'Return value' : 'Number of combinations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=COMBINA(number, number_chosen)' },
    'DECIMAL' : { 'Summary' : 'The Excel DECIMAL function converts a number in a given base into its decimal number equivalent. For example, the DECIMAL function can convert the binary number 1101 into the decimal number 13.', 'Purpose' : 'Convert a number in a different base to a decimal number', 'Return value' : 'Decimal number', 'Arguments' : 'number - A text string representing a number.radix - The base of the number to be converted, an integer between 2-36.', 'Syntax' : '=DECIMAL(number, radix)' },
    'EVEN' : { 'Summary' : 'The Excel EVEN function rounds numbers up to the next even integer. The EVEN function always rounds numbers away from zero, so positive numbers become larger and negative numbers become smaller (i.e. more negative).', 'Purpose' : 'Round a number up to the next even integer', 'Return value' : 'An even integer.', 'Arguments' : 'number - The number to round up to an even integer.', 'Syntax' : '=EVEN(number)' },
    'FACT' : { 'Summary' : 'The Excel FACT function returns the factorial of a given number. For example, =FACT(3) returns 6, equivalent to 3 x 2 x 1.', 'Purpose' : 'Find the factorial of a number', 'Return value' : 'The factorial of a number', 'Arguments' : 'number - The number to get the factorial of.', 'Syntax' : '=FACT(number)' },
    'FACTDOUBLE' : { 'Summary' : 'The Excel FACTDOUBLE function returns the double factorial of a number. A double factorial is symbolized by two exclamation marks (!!).', 'Purpose' : 'Get double factorial of a number', 'Return value' : 'Calculated doublefactorial', 'Arguments' : 'number - A number greater than or equal to -1.', 'Syntax' : '=FACTDOUBLE(number)' },
    'FLOOR' : { 'Summary' : 'The Excel FLOOR function rounds a given number down to the nearest specified multiple. FLOOR works like the MROUND function, but FLOOR always rounds down.', 'Purpose' : 'Round a number down to the nearest specified multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=FLOOR(number, significance)' },
    'FLOOR.MATH' : { 'Summary' : 'The Excel FLOOR.MATH function rounds a number down to a specified multiple. Unlike the FLOOR function, FLOOR.MATH defaults to a multiple of 1, and provides explicit support for rounding negative numbers.', 'Purpose' : 'Round number down to nearest multiple', 'Return value' : 'A rounded number', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.mode - [optional] For rounding negative numbers toward or away from zero. Default is 0.', 'Syntax' : '=FLOOR.MATH(number, [significance], [mode])' },
    'FLOOR.PRECISE' : { 'Summary' : 'The Excel FLOOR.PRECISE function rounds a number down to a given multiple. FLOOR.PRECISE defaults to a multiple of 1, and always rounds negative numbers away from zero.', 'Purpose' : 'Round number down to nearest multiple', 'Return value' : 'A rounded number', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.', 'Syntax' : '=FLOOR.PRECISE(number, [significance])' },
    'GCD' : { 'Summary' : 'The Excel GCD function returns the greatest common divisor of two or more integers. The greatest common divisor is the largest integer that goes into all supplied numbers without a remainder. For example, =GCD(60,36) returns 12.', 'Purpose' : 'Get the greatest common divisor of numbers', 'Return value' : 'The largest positive integer that divides the numbers evenly', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=GCD(number1, [number2], ...)' },
    'INT' : { 'Summary' : 'The Excel INT function returns the integer part of a decimal number by rounding down to the integer. Note that negative numbers become more negative. For example, while INT(10.8) returns 10, INT(-10.8) returns -11.', 'Purpose' : 'Get the integer part of a number by rounding down', 'Return value' : 'The integer part of the number after rounding down', 'Arguments' : 'number - The number from which you want an integer.', 'Syntax' : '=INT(number)' },
    'LCM' : { 'Summary' : 'The Excel LCM function returns the least common multiple of integers. The least common multiple is the smallest positive integer that is a multiple of all supplied numbers. For example, =LCM(25,40) returns 200.', 'Purpose' : 'Get the least common multiple of numbers', 'Return value' : 'The least common multiple of all numbers', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=LCM(number1, [number2], ...)' },
    'LOG' : { 'Summary' : 'The Excel LOG function returns the logarithm of a given number, using a supplied base. The base argument defaults to 10 if not supplied.', 'Purpose' : 'Get the logarithm of a number', 'Return value' : 'The logarithm', 'Arguments' : 'number - Number for which you want the logarithm.base - [optional] Base of the logarithm. Defaults to 10.', 'Syntax' : '=LOG(number, [base])' },
    'LOG10' : { 'Summary' : 'The Excel LOG10 function returns the base 10 logarithm of a number. For example, LOG10(100) returns 2, and LOG10(1000) returns 3.', 'Purpose' : 'Get the base-10 logarithm of a number', 'Return value' : 'The logarithm', 'Arguments' : 'number - Number for which you want the logarithm.', 'Syntax' : '=LOG10(number)' },
    'MDETERM' : { 'Summary' : 'The Excel MDETERM function returns the matrix determinant of a given array. The input array must contain numbers only and be a square matrix, with equal rows and columns. The result is a number representing the matrix determinant.', 'Purpose' : 'Get matrix determinant of given array', 'Return value' : 'A number representing the matrix determinant', 'Arguments' : 'array - A square array of numbers only.', 'Syntax' : '=MDETERM(array)' },
    'MINVERSE' : { 'Summary' : 'The Excel MINVERSE function returns the inverse matrix of a given array. The input array must contain numbers only and be a square matrix, with equal rows and columns. The result is an inverse matrix with the same dimensions as the array provided.', 'Purpose' : 'Get inverse matrix of array', 'Return value' : 'Inverse matrix of array with same dimensions', 'Arguments' : 'array - A square array of numbers only.', 'Syntax' : '=MINVERSE(array)' },
    'MMULT' : { 'Summary' : 'The Excel MMULT function returns the matrix product of two arrays. The result from MMULT is an array that contains the same number of rows as array1 and the same number of columns as array2. ', 'Purpose' : 'Perform matrix multiplication', 'Return value' : 'The matrix product of two arrays', 'Arguments' : 'array1 - The first array to multiply.array2 - The second array to multiply.', 'Syntax' : '=MMULT(array1, array2)' },
    'MOD' : { 'Summary' : 'The Excel MOD function returns the remainder of two numbers after division. For example, MOD(10,3) = 1. The result of MOD carries the same sign as the divisor.', 'Purpose' : 'Get the remainder from division', 'Return value' : 'The remainder', 'Arguments' : 'number - The number to be divided.divisor - The number to divide with.', 'Syntax' : '=MOD(number, divisor)' },
    'MROUND' : { 'Summary' : 'The Excel MROUND function returns a number rounded to a given multiple. MROUND will round a number up or down, depending on the nearest multiple.', 'Purpose' : 'Round a number to the nearest specified multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=MROUND(number, significance)' },
    'MUNIT' : { 'Summary' : 'The Excel MUNIT function returns a unit matrix for a given dimension, n, with a size of n x n. This resulting matrix contains ones on the main diagonal and zeros in every other position.', 'Purpose' : 'Return unit matrix for a given dimension', 'Return value' : 'Unix matrix of size n x n', 'Arguments' : 'dimension - An integer for the size of the unit matrix.', 'Syntax' : '=MUNIT(dimension)' },
    'ODD' : { 'Summary' : 'The Excel ODD function returns the next odd integer after rounding a given number up. The ODD function always rounds numbers away from zero, so positive numbers become larger and negative numbers become smaller (i.e. more negative).', 'Purpose' : 'Round a number up to the next odd integer', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round up to an odd integer.', 'Syntax' : '=ODD(number)' },
    'POWER' : { 'Summary' : 'The Excel POWER function returns a number raised to a given power. The POWER function is an alternative to the exponent operator (^).', 'Purpose' : 'Raise a number to a power', 'Return value' : 'Number raised to power', 'Arguments' : 'number - Number to raise to a power.power - Power to raise number to (the exponent).', 'Syntax' : '=POWER(number, power)' },
    'PRODUCT' : { 'Summary' : 'The Excel PRODUCT function returns the product of numbers provided as arguments. The PRODUCT function is helpful when multiplying many cells together. The formula =PRODUCT(A1:A3) is the same as =A1*A2*A3.', 'Purpose' : 'Get the product of supplied numbers', 'Return value' : 'Product of supplied numbers', 'Arguments' : 'number1 - The first number or range to multiply.number2 - [optional] The second number or range to multiply.', 'Syntax' : '=PRODUCT(number1, [number2], ...)' },
    'QUOTIENT' : { 'Summary' : 'The Excel QUOTIENT function returns the integer portion of division without the remainder. Use QUOTIENT to discard the remainder after division.', 'Purpose' : 'Returns the quotient without a remainder.', 'Return value' : 'Integer Number', 'Arguments' : 'numerator - The number to be divided.denominator - The number to divide by.', 'Syntax' : '=QUOTIENT(numerator, denominator)' },
    'RAND' : { 'Summary' : 'The Excel RAND function returns a random number between 0 and 1. For example, =RAND() will generate a number like 0.422245717. RAND recalculates when a worksheet is opened or changed.', 'Purpose' : 'Get a random number between 0 and 1', 'Return value' : 'A number between 1 and 0', 'Arguments' : '', 'Syntax' : '=RAND()' },
    'RANDBETWEEN' : { 'Summary' : 'The Excel RANDBETWEEN function returns a random integer between two given numbers. RANDBETWEEN recalculates each time a worksheet is opened or changed.', 'Purpose' : 'Get a random integer between two values', 'Return value' : 'An integer', 'Arguments' : 'bottom - An integer representing the lower value of the range.top - An integer representing the upper value of the range.', 'Syntax' : '=RANDBETWEEN(bottom, top)' },
    'ROMAN' : { 'Summary' : 'The Excel ROMAN function converts a number to a Roman numeral as text. For example, the formula =ROMAN(4) returns IV.', 'Purpose' : 'Converts numbers to Roman numerals', 'Return value' : 'A Roman numeral in text', 'Arguments' : 'number - Number (in Arabic numeral) you want to convert to Roman numeral.form - [optional] The type of Roman numeral you want.', 'Syntax' : '=ROMAN(number, [form])' },
    'ROUND' : { 'Summary' : 'The Excel ROUND function returns a number rounded to a given number of digits. The ROUND function can round to the right or left of the decimal point.', 'Purpose' : 'Round a number to a given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUND(number, num_digits)' },
    'ROUNDDOWN' : { 'Summary' : 'The Excel ROUNDDOWN function returns a number rounded down to a given number of places. Unlike standard rounding, where only numbers less than 5 are rounded down, ROUNDDOWN rounds all numbers down.', 'Purpose' : 'Round down to given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round down.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUNDDOWN(number, num_digits)' },
    'ROUNDUP' : { 'Summary' : 'The Excel ROUNDUP function returns a number rounded up to a given number of decimal places. Unlike standard rounding, where only numbers less than 5 are rounded down, ROUNDUP rounds all numbers up.', 'Purpose' : 'Round a number up to a given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round up.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUNDUP(number, num_digits)' },
    'SQRT' : { 'Summary' : 'The Excel SQRT function returns the square root of a positive number. SQRT returns an error if number is negative.', 'Purpose' : 'Find the positive square root of a number', 'Return value' : 'Positive square root', 'Arguments' : 'number - The number to get the square root of.', 'Syntax' : '=SQRT(number)' },
    'SUBTOTAL' : { 'Summary' : 'The Excel SUBTOTAL function is designed to run a given calculation on a range of cells while ignoring cells that should not be included. SUBTOTAL can return a SUM, AVERAGE, COUNT, MAX, and others (see complete list below), and SUBTOTAL function can either include or exclude values in hidden rows.', 'Purpose' : 'Get a subtotal in a list or database', 'Return value' : 'A number representing a specific kind of subtotal', 'Arguments' : 'function_num - A number that specifies which function to use in calculating subtotals within a list. See table below for full list.ref1 - A named range or reference to subtotal.ref2 - [optional] A named range or reference to subtotal.', 'Syntax' : '=SUBTOTAL(function_num, ref1, [ref2], ...)' },
    'SUM' : { 'Summary' : 'The Excel SUM function returns the sum of values supplied. These values can be numbers, cell references, ranges, arrays, and constants, in any combination. SUM can handle up to 255 individual arguments.', 'Purpose' : 'Add numbers together', 'Return value' : 'The sum of values supplied.', 'Arguments' : 'number1 - The first value to sum.number2 - [optional] The second value to sum.number3 - [optional] The third value to sum.', 'Syntax' : '=SUM(number1, [number2], [number3], ...)' },
    'SUMIF' : { 'Summary' : 'The Excel SUMIF function returns the sum of cells that meet a single condition. Criteria can be applied to dates, numbers, and text. The SUMIF function supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Sum cells in a range that meet criteria', 'Return value' : 'The sum of matching cells', 'Arguments' : 'range - Range to apply criteria to.criteria - Criteria to apply.sum_range - [optional] Range to sum. If omitted, cells in range are summed.', 'Syntax' : '=SUMIF(range, criteria, [sum_range])' },
    'SUMIFS' : { 'Summary' : 'The SUMIFS function sums cells in a range that meet one or more conditions, referred to as criteria. SUMIFS can apply conditions based on dates, numbers, and text. SUMIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Sum cells in a range that meet criteria', 'Return value' : 'The sum of cells that meet all criteria', 'Arguments' : 'sum_range - The range to be summed.range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=SUMIFS(sum_range, range1, criteria1, [range2], [criteria2], ...)' },
    'SUMPRODUCT' : { 'Summary' : 'The Excel SUMPRODUCT function multiplies ranges or arrays together and returns the sum of products. This sounds boring, but SUMPRODUCT is an incredibly versatile function that can be used to count and sum like COUNTIFS or SUMIFS, but with more flexibility. Other functions can easily be used inside SUMPRODUCT to extend functionality even further.', 'Purpose' : 'Multiply, then sum arrays', 'Return value' : 'The result of multipled and summed arrays', 'Arguments' : 'array1 - The first array or range to multiply, then add.array2 - [optional] The second array or range to multiply, then add.', 'Syntax' : '=SUMPRODUCT(array1, [array2], ...)' },
    'SUMSQ' : { 'Summary' : 'The Excel SUMSQ function returns the sum of the squares of the values provided. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Get sum of squares of supplied values', 'Return value' : 'Calculated sum of squares', 'Arguments' : 'number1 - The first argument containing numeric values.number2 - [optional] The first argument containing numeric values.', 'Syntax' : '=SUMSQ(number1, [number2], ...)' },
    'SUMX2MY2' : { 'Summary' : 'The Excel SUMX2PY2 function returns the sum of the difference of squares of corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Sum of difference of squares in two arrays', 'Return value' : 'Calculated sum of difference of squares', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMX2MY2(array_x, array_y)' },
    'SUMX2PY2' : { 'Summary' : 'The Excel SUMX2PY2 function returns the sum of the sum of squares of corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Get sum of squares in two arrays', 'Return value' : 'Calculated sum of sum of squares', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMX2PY2(array_x, array_y)' },
    'SUMXMY2' : { 'Summary' : 'The Excel SUMXMY2 function returns the sum of squares of differences between corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Sum of squares of differences in two arrays', 'Return value' : 'Calculated sum of squares of differences', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMXMY2(array_x, array_y)' },
    'TRUNC' : { 'Summary' : 'The Excel TRUNC function returns a truncated number based on an (optional) number of digits. For example, TRUNC(4.9) will return 4, and TRUNC(-3.5) will return -3. The TRUNC function does no rounding, it simply truncates as specified.', 'Purpose' : 'Truncate a number to a given precision', 'Return value' : 'A truncated number', 'Arguments' : 'number - The number to truncate.num_digits - [optional] The precision of the truncation (default is 0).', 'Syntax' : '=TRUNC(number, [num_digits])' },
    'ATAN2' : { 'Summary' : 'The Excel ATAN2 function returns the arctangent from x- and y-coordinates. In geometric terms, the function returns the radian angle corresponding to the input point.', 'Purpose' : 'Get arctangent from x- and y-coordinates', 'Return value' : 'The angle in radians of the point.', 'Arguments' : 'x_num - The x coordinate of the input point.y_num - The y coordinate of the input point.', 'Syntax' : '=ATAN2(x_num, y_num)' },
    'COS' : { 'Summary' : 'The Excel COS function returns the cosine of an angle given in radians. To supply an angle to COS in degrees, use the RADIANS function to convert to radians.', 'Purpose' : 'Get the cosine of an angle provided in radians.', 'Return value' : 'The cosine value', 'Arguments' : 'number - The angle in radians for which you want the cosine.', 'Syntax' : '=COS(number)' },
    'COSH' : { 'Summary' : 'The Excel COSH function returns the hyperbolic cosine of a number.', 'Purpose' : 'Get hyperbolic cosine of a number', 'Return value' : 'The x-component of the hyperbolic angle.', 'Arguments' : 'number - The hyperbolic angle.', 'Syntax' : '=COSH(number)' },
    'DEGREES' : { 'Summary' : 'The Excel DEGREES function converts angles (expressed in radians) to degrees. For example, the formula =DEGREES(PI()) returns 180.', 'Purpose' : 'Converts radians to degrees', 'Return value' : 'Degrees', 'Arguments' : 'angle - Angle in radians that you want to convert to degrees.', 'Syntax' : '=DEGREES(angle)' },
    'SIN' : { 'Summary' : 'The Excel SIN function returns the sine of an angle given in radians. To supply an angle to SIN in degrees, multiply the angle by PI()/180 or use the RADIANS function to convert to radians.', 'Purpose' : 'Get the sine of an angle provided in radians.', 'Return value' : 'Sine value', 'Arguments' : 'number - The angle in radians for which you want the sine.', 'Syntax' : '=SIN(number)' },
    'SINH' : { 'Summary' : 'The Excel SINH function returns the hyperbolic sine of a number.', 'Purpose' : 'Get hyperbolic sine of a number.', 'Return value' : 'The hyperbolic sine of a number.', 'Arguments' : 'number - The hyperbolic angle.', 'Syntax' : '=SINH(number)' },
    'AVEDEV' : { 'Summary' : 'The Excel AVEDEV function returns the average of the absolute value of deviations from the mean for a given set of data. Average deviation is a measure of variability.', 'Purpose' : 'Get sum of squared deviations', 'Return value' : 'Calculated sum', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=AVEDEV(number1, [number2], ...)' },
    'AVERAGE' : { 'Summary' : 'The Excel AVERAGE function calculates the average (arithmetic mean) of supplied numbers. AVERAGE can handle up to 255 individual arguments, which can include numbers, cell references, ranges, arrays, and constants.', 'Purpose' : 'Get the average of a group of numbers', 'Return value' : 'A number representing the average.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=AVERAGE(number1, [number2], ...)' },
    'AVERAGEA' : { 'Summary' : 'The Excel AVERAGEA function returns the average of a set of supplied values. Unlike AVERAGE, AVERAGEA will also evaluate the logical values TRUE and FALSE, and numbers represented as text, whereas AVERAGE ignores these values during calculation', 'Purpose' : 'Get the average of a group of numbers and text', 'Return value' : 'A number representing the average.', 'Arguments' : 'value1 - A value or reference to a value that can be evaluated as a number.value2 - [optional] A value or reference to a value that can be evaluated as a number.', 'Syntax' : '=AVERAGEA(value1, [value2], ...)' },
    'AVERAGEIF' : { 'Summary' : 'The Excel AVERAGEIF function calculates the average of numbers in a range that meet supplied criteria. AVERAGEIF criteria can include logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get the average of numbers that meet criteria.', 'Return value' : 'A number representing the average.', 'Arguments' : 'range - One or more cells, including numbers or names, arrays, or references.criteria - A number, expression, cell reference, or text.average_range - [optional] The cells to average. When omitted, range is used.', 'Syntax' : '=AVERAGEIF(range, criteria, [average_range])' },
    'AVERAGEIFS' : { 'Summary' : 'The Excel AVERAGEIFS function calculates the average of numbers in a range that meet one or more criteria. The criteria used for AVERAGEIFS can include logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Average cells that match multiple criteria', 'Return value' : 'The average of the cells that meet all criteria', 'Arguments' : 'avg_rng - The range to average.range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=AVERAGEIFS(avg_rng, range1, criteria1, [range2], [criteria2], ...)' },
    'BINOM.DIST' : { 'Summary' : 'The Excel BINOM.DIST function returns the individual term binomial distribution probability. You can use BINOM.DIST to calculate probabilities that an event will occur a certain number of times in a given number of trials.', 'Purpose' : 'Get binomial distribution probability', 'Return value' : 'Calculated probability', 'Arguments' : 'number_s - The number of successes.trials - The number of independent trials.probability_s - The probability of success on each trial.cumulative - TRUE = cumulative distribution function, FALSE=probability mass function.', 'Syntax' : '=BINOM.DIST(number_s, trials, probability_s, cumulative)' },
    'BINOMDIST' : { 'Summary' : 'The Excel BINOMDIST function returns the individual term binomial distribution probability. You can use BINOMDIST to calculate probabilities that an event will occur a certain number of times in a given number of trials.', 'Purpose' : 'Get binomial distribution probability', 'Return value' : 'Calculated probability', 'Arguments' : 'number_s - The number of successes.trials - The number of independent trials.probability_s - The probability of success on each trial.cumulative - TRUE = cumulative distribution function, FALSE=probability mass function.', 'Syntax' : '=BINOMDIST(number_s, trials, probability_s, cumulative)' },
    'COUNT' : { 'Summary' : 'The Excel COUNT function returns a count of values that are numbers. Numbers include negative numbers, percentages, dates, times, fractions, and formulas that return numbers. Empty cells and text values are ignored.', 'Purpose' : 'Count numbers', 'Return value' : 'Count of numeric values', 'Arguments' : 'value1 - An item, cell reference, or range.value2 - [optional] An item, cell reference, or range.', 'Syntax' : '=COUNT(value1, [value2], ...)' },
    'COUNTA' : { 'Summary' : 'The Excel COUNTA function returns the count of cells that contain numbers, text, logical values, error values, and empty text (""). COUNTA does not count empty cells.', 'Purpose' : 'Count the number of non-blank cells', 'Return value' : 'A number representing non-blank cells.', 'Arguments' : 'value1 - An item, cell reference, or range.value2 - [optional] An item, cell reference, or range.', 'Syntax' : '=COUNTA(value1, [value2], ...)' },
    'COUNTBLANK' : { 'Summary' : 'The Excel COUNTBLANK function returns a count of empty cells in a range. Cells that contain text, numbers, errors, spaces, etc. are not counted. Formulas that return empty strings ("") are counted as blank.', 'Purpose' : 'Count cells that are blank', 'Return value' : 'A number representing blank cells', 'Arguments' : 'range - The range in which to count blank cells.', 'Syntax' : '=COUNTBLANK(range)' },
    'COUNTIF' : { 'Summary' : 'COUNTIF is an Excel function to count cells in a range that meet a single condition. COUNTIF can be used to count cells that contain dates, numbers, and text. The criteria used in COUNTIF supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Count cells that match criteria', 'Return value' : 'A number representing cells counted.', 'Arguments' : 'range - The range of cells to count.criteria - The criteria that controls which cells should be counted.', 'Syntax' : '=COUNTIF(range, criteria)' },
    'COUNTIFS' : { 'Summary' : 'The Excel COUNTIFS function returns the count of cells that meet one or more criteria. COUNTIFS can be used to count cells that contain dates, numbers, and text, with logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : ' Count cells that match multiple criteria', 'Return value' : 'The number of times criteria are met', 'Arguments' : 'range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=COUNTIFS(range1, criteria1, [range2], [criteria2], ...)' },
    'DEVSQ' : { 'Summary' : 'The Excel DEVSQ function returns the sum of the squared deviations from the mean for a given set of data. ', 'Purpose' : 'Get sum of squared deviations', 'Return value' : 'Calculated sum', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=DEVSQ(number1, [number2], ...)' },
    'FORECAST' : { 'Summary' : 'The Excel FORECAST function predicts a value based on existing values along a linear trend. FORECAST calculates future value predictions using linear regression, and can be used to predict numeric values like sales, inventory, expenses, measurements, etc.', 'Purpose' : 'Predict value along a linear trend', 'Return value' : 'Predicted value', 'Arguments' : 'x - The x value data point to use to calculate a prediction.known_ys - The dependent array or range of data (y values).kown_xs - The independent array or range of data (x values).', 'Syntax' : '=FORECAST(x, known_ys, kown_xs)' },
    'FORECAST.ETS' : { 'Summary' : 'The Excel FORECAST.ETS function predicts a value based on existing values that follow a seasonal trend. FORECAST.ETS can be used to predict numeric values like sales, inventory, expenses, etc. with a seasonal pattern.', 'Purpose' : 'Predict value with a seasonal trend', 'Return value' : 'Predicted value', 'Arguments' : 'target_date - The time or period for the prediction (x value).values - Existing or historical values (y values).timeline - Numeric timeline values (x values).seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS(target_date, values, timeline, [seasonality], [data_completion], [aggregation])' },
    'FORECAST.ETS.CONFINT' : { 'Summary' : 'The Excel FORECAST.ETS.CONFINT function returns a confidence interval for a forecast value at a specific point on a timeline. It is designed to be used along with the FORECAST.ETS function as a way to show forecast accuracy.', 'Purpose' : 'Get confidence interval for forecast value at given date', 'Return value' : 'Confidence interval value', 'Arguments' : 'target_date - The time or period for the prediction (x value).values - Existing or historical values (y values).timeline - Numeric timeline values (x values).confidence_level - [optional] A number between 0 and 1 (exclusive). Default = 0.95.seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.CONFINT(target_date, values, timeline, [confidence_level], [seasonality], [data_completion], [aggregation])' },
    'FORECAST.ETS.SEASONALITY' : { 'Summary' : 'The Excel FORECAST.ETS.SEASONALITY function returns the length in time of a seasonal pattern based on existing values and a timeline.', 'Purpose' : 'Get length of the seasonal pattern', 'Return value' : 'Season length in timeline units', 'Arguments' : 'values - Existing or historical values (y values).timeline - Numeric timeline values (x values).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.SEASONALITY(values, timeline, [data_completion], [aggregation])' },
    'FORECAST.ETS.STAT' : { 'Summary' : 'The Excel FORECAST.ETS.STAT function returns a particular statistical value relating related to time series forecasting with the FORECAST.ETS function. The statistic_type argument determines which statistic is returned by FORECAST.ETS.STAT.', 'Purpose' : 'Get statistical value related to forecasting', 'Return value' : 'Requested statistic', 'Arguments' : 'values - Existing or historical values (y values).timeline - Numeric timeline values (x values).statistic_type - The statistic to return, a numeric value between 1 and 8 (see table below).seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.STAT(values, timeline, statistic_type, [seasonality], [data_completion], [aggregation])' },
    'FORECAST.LINEAR' : { 'Summary' : 'The Excel FORECAST function predicts a value based on existing values along a linear trend. FORECAST calculates future value predictions using linear regression, and can be used to predict numeric values like sales, inventory, expenses, measurements, etc.', 'Purpose' : 'Predict value along a linear trend', 'Return value' : 'Predicted value', 'Arguments' : 'x - The x value data point to use to calculate a prediction.known_ys - The dependent array or range of data (y values).kown_xs - The independent array or range of data (x values).', 'Syntax' : '=FORECAST.LINEAR(x, known_ys, kown_xs)' },
    'FREQUENCY' : { 'Summary' : 'The Excel FREQUENCY function returns a frequency distribution, which is a list that shows the frequency of values at given intervals. FREQUENCY returns multiple values and must be entered as an array formula with control-shift-enter, except in Excel 365.', 'Purpose' : 'Get the frequency of values in a data set', 'Return value' : 'A vertical array of frequencies', 'Arguments' : 'data_array - An array of values for which you want to get frequencies.bins_array - An array of intervals ("bins") for grouping values.', 'Syntax' : '=FREQUENCY(data_array, bins_array)' },
    'GEOMEAN' : { 'Summary' : 'The Excel GEOMEAN function returns the geometric mean for a set of numeric values. Geometric mean can be used to calculate average rate of return with variable rates.', 'Purpose' : 'Calculate geometric mean', 'Return value' : 'Calculated mean', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=GEOMEAN(number1, [number2], ...)' },
    'HARMEAN' : { 'Summary' : 'The Excel HARMEAN function returns the harmonic mean for a set of numeric values. The harmonic mean is the reciprocal of the arithmetic mean of reciprocals. Harmonic mean can be used to calculate a mean that reduces the impact of large outliers.', 'Purpose' : 'Calculate harmonic mean', 'Return value' : 'Calculated mean', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=HARMEAN(number1, [number2], ...)' },
    'INTERCEPT' : { 'Summary' : 'The Excel INTERCEPT function returns the point at which a regression line will intersect the y-axis based on known x and y values.', 'Purpose' : 'Get intercept of linear regression line', 'Return value' : 'y-axis intercept value', 'Arguments' : 'known_ys - An array or range of numeric data points (dependent values).known_xs - An array or range of numeric data points (independent values).', 'Syntax' : '=INTERCEPT(known_ys, known_xs)' },
    'LARGE' : { 'Summary' : 'The Excel LARGE function returns a numeric value based on its position in a list when sorted by value in descending order. In other words, LARGE can retrieve the "nth largest" value  1st largest value, 2nd largest value, 3rd largest value, etc.', 'Purpose' : 'Get nth largest value', 'Return value' : 'The nth largest value in an array.', 'Arguments' : 'array - An array or range of numeric values.k - Position as an integer, where 1 corresponds to the largest value.', 'Syntax' : '=LARGE(array, k)' },
    'LINEST' : { 'Summary' : 'The Excel LINEST function returns statistics for a best fit straight line through supplied x and y values. The values returned by LINEST include slope, intercept, standard error values, and more. To find the best fit of a line to the data, LINEST uses the "least squares" method.', 'Purpose' : 'Get parameters of linear trend', 'Return value' : 'Array of values', 'Arguments' : 'known_ys - An array or range of dependent y values values.known_xs - [optional] An array or range of independent x values.const - [optional] Boolean - normal or force the constant b to equal 0. Default is TRUE = normal calculation.stats - [optional] Boolean - return additional statistics. Default is FALSE = slope and intercept only.', 'Syntax' : '=LINEST(known_ys, [known_xs], [const], [stats])' },
    'MAX' : { 'Summary' : 'The Excel MAX function returns the largest numeric value in the data provided. MAX ignores empty cells, the logical values TRUE and FALSE, and text values.', 'Purpose' : 'Get the largest value', 'Return value' : 'The largest value in supplied data', 'Arguments' : 'number1 - Number, reference to numeric value, or range that contains numeric values.number2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MAX(number1, [number2], ...)' },
    'MAXA' : { 'Summary' : 'The Excel MAXA function returns the largest numeric value in a range of values. The MAXA function ignores empty cells, but evaluates the logical values TRUE and FALSE as 1 and 0, and evaluates text as zero.', 'Purpose' : 'Return largest value.', 'Return value' : 'Largest numeric value', 'Arguments' : 'value1 - Number, reference to numeric value, or range that contains numeric values.value2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MAXA(value1, [value2], ...)' },
    'MAXIFS' : { 'Summary' : 'The Excel MAXIFS function returns the largest numeric value that meets one or more criteria in a range of values. MAXIFS can be used with criteria based on dates, numbers, text, and other conditions. MAXIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get maximum value with criteria', 'Return value' : 'Maximum value', 'Arguments' : 'max_range - Range of values used to determine maximum.range1 - The first range to evaluate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=MAXIFS(max_range, range1, criteria1, [range2], [criteria2], ...)' },
    'MEDIAN' : { 'Summary' : 'The Excel MEDIAN function returns the median (middle number) in the supplied set of data. For example, =MEDIAN(1,2,3,4,5) returns 3.', 'Purpose' : 'Get the median of a group of numbers', 'Return value' : 'A number representing the median.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MEDIAN(number1, [number2], ...)' },
    'MIN' : { 'Summary' : 'The Excel MIN function returns the smallest numeric value in the data provided. The MIN function ignores empty cells, the logical values TRUE and FALSE, and text values.', 'Purpose' : 'Get the smallest value.', 'Return value' : 'The smallest value in supplied data', 'Arguments' : 'number1 - Number, reference to numeric value, or range that contains numeric values.number2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MIN(number1, [number2], ...)' },
    'MINA' : { 'Summary' : 'The Excel MINA function returns the smallest numeric value in a range of values. The MINA function ignores empty cells, but evaluates the logical values TRUE and FALSE as 1 and 0, and evaluates text as zero when these values appear in a range or cell reference.', 'Purpose' : 'Return smallest value.', 'Return value' : 'Smallest numeric value', 'Arguments' : 'value1 - Number, reference to numeric value, or range that contains numeric values.value2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MINA(value1, [value2], ...)' },
    'MINIFS' : { 'Summary' : 'The Excel MINIFS function returns the smallest numeric value that meets one or more criteria in a range of values. MINIFS can be used with criteria based on dates, numbers, text, and other conditions. MINIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get minimum value with criteria', 'Return value' : 'Minimim value', 'Arguments' : 'min_range - Range of values used to determine minimum.range1 - The first range to evaluate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=MINIFS(min_range, range1, criteria1, [range2], [criteria2], ...)' },
    'MODE' : { 'Summary' : 'The Excel MODE function returns the most frequently occurring number in a numeric data set. For example, =MODE(1,2,4,4,5,5,5,6) returns 5.', 'Purpose' : 'Get most frequently occurring number', 'Return value' : 'A number representing the mode.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE(number1, [number2], ...)' },
    'MODE.MULT' : { 'Summary' : 'The Excel MODE.MULT function returns an array of the most frequently occurring numbers in a numeric data set. For example, =MODE.MULT(1,2,3,3,4,5,5) returns {3;5}, because there are two modes, 3 and 5.', 'Purpose' : 'Get most frequently occurring numbers', 'Return value' : 'Numbers representing mode(s)', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE.MULT(number1, [number2], ...)' },
    'MODE.SNGL' : { 'Summary' : 'The Excel MODE.SNGL function returns the most frequently occurring number in a numeric data set. For example, =MODE.SNGL(1,2,4,4,5,5,5,6) returns 5.', 'Purpose' : 'Get most frequently occurring number', 'Return value' : 'A number representing the mode.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE.SNGL(number1, [number2], ...)' },
    'NORM.INV' : { 'Summary' : 'The Excel NORM.INV function returns the inverse of the normal cumulative distribution for the specified mean and standard deviation. Given the probability of an event occurring below a threshold value, the function returns the threshold value associated with the probability.', 'Purpose' : 'Get the inverse of normal cumulative distribution', 'Return value' : 'The threshold value associated with a probability', 'Arguments' : 'probability - The probability of an event occurring below a threshold.mean - The mean of the distribution.standard_dev - The standard deviation of the distribution.', 'Syntax' : '=NORM.INV(probability, mean, standard_dev)' },
    'NORM.S.DIST' : { 'Summary' : 'The Excel NORM.S.DIST function returns output for the standard normal cumulative distribution (CDF) and the standard normal probability density function (PDF).', 'Purpose' : 'Get the standard normal CDF and PDF.', 'Return value' : 'The standard normal cumulative distribution function', 'Arguments' : 'z - Numeric z-score value.cumulative - Logical value that determines the form of the function.', 'Syntax' : '=NORM.S.DIST(z, cumulative)' },
    'NORM.S.INV' : { 'Summary' : 'The Excel NORM.S.INV function returns the inverse of the standard normal cumulative distribution.', 'Purpose' : 'Get inverse of the standard normal cumulative distribution', 'Return value' : 'Returns the threshold value of a probability.', 'Arguments' : 'probability - A probability corresponding to the standard normal distribution.', 'Syntax' : '=NORM.S.INV(probability)' },
    'PERCENTILE' : { 'Summary' : 'The Excel PERCENTILE function calculates the "kth percentile" for a set of data. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - Number representing kth percentile.', 'Syntax' : '=PERCENTILE(array, k)' },
    'PERCENTILE.EXC' : { 'Summary' : 'The Excel PERCENTILE.EXC function calculates the "kth percentile" for a set of data where k is 0 to 1. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE.EXC to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - A value between 0 and 1 that represents the k:th percentile.', 'Syntax' : '=PERCENTILE.EXC(array, k)' },
    'PERCENTILE.INC' : { 'Summary' : 'The Excel PERCENTILE.INC function calculates the "kth percentile" for a set of data where k is 0 to 1, inclusive. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE.INC to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - Number representing kth percentile.', 'Syntax' : '=PERCENTILE.INC(array, k)' },
    'PERCENTRANK' : { 'Summary' : 'The Excel PERCENTRANK function returns the rank of a value in a data set as a percentage of the data set. You can use PERCENTRANK to find the relative standing of a value within a data set. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, inclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK(array, x, [significance])' },
    'PERCENTRANK.EXC' : { 'Summary' : 'The Excel PERCENTRANK.EXC function returns the relative rank of a value in a data set as a percentage representing how many values are less than or equal to the value. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, exclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK.EXC(array, x, [significance])' },
    'PERCENTRANK.INC' : { 'Summary' : 'The Excel PERCENTRANK.INC function returns the relative rank of a value in a data set as a percentage representing the number of values less than or equal to the value. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, inclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK.INC(array, x, [significance])' },
    'PERMUT' : { 'Summary' : 'The Excel PERMUT function returns the number of permutations (combinations where order is significant) for a given number of items. The PERMUT function does not allow repetitions. To allow permutations with repetitions, use the PERMUTATIONA function.', 'Purpose' : 'Get number of permutations without repetitions', 'Return value' : 'Number of permutations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=PERMUT(number, number_chosen)' },
    'PERMUTATIONA' : { 'Summary' : 'The Excel PERMUTATIONA function returns the number of permutations (combinations where order is significant) for a given number of items. The PERMUTATIONA function allows repetitions. To calculate the number of permutations without repetitions, use the PERMUT function.', 'Purpose' : 'Get number of permutations with repetitions', 'Return value' : 'Number of permutations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=PERMUTATIONA(number, number_chosen)' },
    'QUARTILE' : { 'Summary' : 'The Excel QUARTILE function returns the quartile (each of four equal groups) for a given set of data. QUARTILE can return minimum value, first quartile, second quartile, third quartile, and max value.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return.', 'Syntax' : '=QUARTILE(array, quart)' },
    'QUARTILE.EXC' : { 'Summary' : 'The Excel QUARTILE.EXC function returns the quartile for a given set of data. QUARTILE.EXC can return, first quartile, second quartile, and third quartile.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return, 1-3.', 'Syntax' : '=QUARTILE.EXC(array, quart)' },
    'QUARTILE.INC' : { 'Summary' : 'The Excel QUARTILE.INC function returns the quartile (each of four equal groups) for a given set of data. QUARTILE.INC can return minimum value, first quartile, second quartile, third quartile, and max value. Starting with Excel 2010, the QUARTILE.INC function replaces the QUARTILE function with the same behavior.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return.', 'Syntax' : '=QUARTILE.INC(array, quart)' },
    'RANK' : { 'Summary' : 'The Excel RANK function returns the rank of a numeric value when compared to a list of other numeric values. RANK can rank values from largest to smallest (i.e. top sales) as well as smallest to largest (i.e. fastest time).', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - The range that contains numbers to rank against.order - [optional] Whether to rank in ascending or descending order.', 'Syntax' : '=RANK(number, ref, [order])' },
    'RANK.AVG' : { 'Summary' : 'The Excel RANK.AVG function returns the rank of a number against a list of other other numeric values. When values contain duplicates, the RANK.AVG function will assign an average rank to each set of duplicates.', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - An array that contains the numbers to rank against.order - [optional] Rank ascending or descending. Default is zero.', 'Syntax' : '=RANK.AVG(number, ref, [order])' },
    'RANK.EQ' : { 'Summary' : 'The Excel RANK.EQ function returns the rank of a number against a list of other other numeric values. When values contain duplicates, RANK.EQ will assign the higher rank to each set of duplicates.', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - An array that contains the numbers to rank against.order - [optional] Rank ascending or descending. Default is zero.', 'Syntax' : '=RANK.EQ(number, ref, [order])' },
    'SKEW' : { 'Summary' : 'The Excel SKEW function returns the skewness of a distribution, which is a measure of symmetry. A positive result indicates a distribution that tails off to the right. A negative result indicates a distribution that tails off to the left. ', 'Purpose' : 'Get skewness of a distribution', 'Return value' : 'A positive or negative value', 'Arguments' : 'number1 - A range or reference that contains numeric values.number2 - [optional] A range or reference that contains numeric values.', 'Syntax' : '=SKEW(number1, [number2], ...)' },
    'SKEW.P' : { 'Summary' : 'The Excel SKEW.P function returns the skewness of a distribution, which is a measure of symmetry. A positive result indicates a distribution that tails off to the right. A negative result indicates a distribution that tails off to the left. ', 'Purpose' : 'Get skewness of a distribution based on population', 'Return value' : 'A positive or negative value', 'Arguments' : 'number1 - A range or reference that contains numeric values.number2 - [optional] A range or reference that contains numeric values.', 'Syntax' : '=SKEW.P(number1, [number2], ...)' },
    'SLOPE' : { 'Summary' : 'The Excel SLOPE function returns the slope of a regression line based on known y values and known x values. A regression line is a "best fit" line based on known data points.', 'Purpose' : 'Get slope of linear regression line', 'Return value' : 'Calculated slope as a number', 'Arguments' : 'known_ys - An array or range of numeric data points (dependent values).known_xs - An array or range of numeric data points (independent values).', 'Syntax' : '=SLOPE(known_ys, known_xs)' },
    'SMALL' : { 'Summary' : 'The Excel SMALL function returns a numeric value based on its position in a list when sorted by value in ascending order. In other words, SMALL can return the "nth smallest" value (1st smallest value, 2nd smallest value, 3rd smallest value, etc.) from a set of numeric data.', 'Purpose' : 'Get nth smallest value', 'Return value' : 'The nth smallest value in the array.', 'Arguments' : 'array - An array or range of numeric values.k - Position as an integer, where 1 corresponds to the smallest value.', 'Syntax' : '=SMALL(array, k)' },
    'STANDARDIZE' : { 'Summary' : 'The Excel STANDARDIZE function returns a normalized value (z-score) based on the mean and standard deviation.', 'Purpose' : 'Calculate a normalized value (z-score)', 'Return value' : 'Normalized value', 'Arguments' : 'x - The value to normalize.mean - The arithmetic mean of the distribution.standard_dev - The standard deviation of the distribution.', 'Syntax' : '=STANDARDIZE(x, mean, standard_dev)' },
    'STDEV' : { 'Summary' : 'The Excel STDEV function returns the standard deviation for data that represents a sample. To calculate the standard deviation for an entire population, use STDEVP or STDEV.P.', 'Purpose' : 'Get the standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV(number1, [number2], ...)' },
    'STDEV.P' : { 'Summary' : 'The Excel STDEV.P function calculates the standard deviation for a sample set of data. STDEV.P calculates standard deviation using the "n" method, ignoring logical values and text.', 'Purpose' : 'Get standard deviation of population', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV.P(number1, [number2], ...)' },
    'STDEV.S' : { 'Summary' : 'The Excel STDEV.S function calculates the standard deviation for a sample set of data. STDEV.S replaces the older STDEV function, with the same behavior.', 'Purpose' : 'Get the standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV.S(number1, [number2], ...)' },
    'STDEVA' : { 'Summary' : 'The Excel STDEVA function calculates standard deviation for a sample of data. Unlike the STDEV function, STDEVA will evaluate text and logicals that appear in references. To calculate standard deviation for an entire population, use STDEVPA or STDEV.P.', 'Purpose' : 'Get standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVA(number1, [number2], ...)' },
    'STDEVP' : { 'Summary' : 'The STDEVP function calculates the standard deviation for data that represents a population. STDEVP has been replaced with a newer function called STDEV.P, which has the same behavior.', 'Purpose' : 'Get standard deviation of population', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVP(number1, [number2], ...)' },
    'STDEVPA' : { 'Summary' : 'The Excel STDEVPA function calculates the standard deviation for an entire population. Unlike the STDEVP function, STDEVPA evaluates text and logicals that appear in references. To calculate standard deviation for a sample, use STDEVA or STDEV.S.', 'Purpose' : 'Get standard deviation for a population', 'Return value' : 'Calculated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVPA(number1, [number2], ...)' },
    'TRIMMEAN' : { 'Summary' : 'The Excel TRIMMEAN function calculates mean (average) while excluding outliers. The number of data points to exclude is provided as a percentage.', 'Purpose' : 'Calculate mean excluding outliers', 'Return value' : 'Calculated mean', 'Arguments' : 'array - Values to trim and average.percent - The number of data points to exclude from the calculation.', 'Syntax' : '=TRIMMEAN(array, percent)' },
    'VAR' : { 'Summary' : 'The Excel VAR function estimates the variance of a sample of data. If data represents the entire population, use the VARP function or the newer VAR.P function. VAR ignores text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR(number1, [number2], ...)' },
    'VAR.P' : { 'Summary' : 'The Excel VAR.P function returns the variance in an entire population. If data represents a sample of the population, use the VAR.S function.', 'Purpose' : 'Get variation of population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR.P(number1, [number2], ...)' },
    'VAR.S' : { 'Summary' : 'The Excel VAR.S function returns the variance of a sample. If data represents the entire population, use the VAR.P function. VAR.S ignores text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR.S(number1, [number2], ...)' },
    'VARA' : { 'Summary' : 'The Excel VARA function estimates the variance of a sample of data. Unlike the VAR function, the VARA function evaluates text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARA(number1, [number2], ...)' },
    'VARP' : { 'Summary' : 'The Excel VARP function calculates the variance of an entire population of data. If data represents a sample, use the VAR function or the newer VAR.S function. VARP ignores text values and logicals in references.', 'Purpose' : 'Get variation of a population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARP(number1, [number2], ...)' },
    'VARPA' : { 'Summary' : 'The Excel VARPA function computes the variance of a population of data. Unlike the VARP function, the VARPA function evaluates text values and logicals in references.', 'Purpose' : 'Get variation of a population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARPA(number1, [number2], ...)' },
    'ENCODEURL' : { 'Summary' : 'The Excel ENCODEURL function returns a URL-encoded string composed of US-ASCII characters. ENCODEURL is only available in Excel 2013 and later on Windows.', 'Purpose' : 'Get URL-encoded string', 'Return value' : 'Encoded text', 'Arguments' : 'text - The text to be encoded.', 'Syntax' : '=ENCODEURL(text)' },
    'FILTERXML' : { 'Summary' : 'The Excel FILTERXML function returns specific data from XML text using the specified XPath expression.', 'Purpose' : 'Get data from XML with Xpath', 'Return value' : 'Matching data as text', 'Arguments' : 'xml - Valid XML as a text string.xpath - A valid Xpath expression as a text string.', 'Syntax' : '=FILTERXML(xml, xpath)' },
    'DAVERAGE' : { 'Summary' : 'The Excel DAVERAGE function returns the average in a given field for records that match criteria. ', 'Purpose' : 'Get average from matching records', 'Return value' : 'The average value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DAVERAGE(database, field, criteria)' },
    'DCOUNT' : { 'Summary' : 'The Excel DCOUNT function counts matching records in a database using criteria and an optional field. When a field is provided DCOUNT will only count numeric values in the field. Use DCOUNTA to count numbers or text values in a given field.', 'Purpose' : 'Count matching records in a database', 'Return value' : 'Numeric count of matching records', 'Arguments' : 'database - Database range including headers.field - [optional] Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DCOUNT(database, [field], criteria)' },
    'DCOUNTA' : { 'Summary' : 'The Excel DCOUNTA function counts matching records in a database using criteria and an optional field. When a field is provided, DCOUNTA counts both numeric and text values when the field value is not empty. Use DCOUNT to count only numeric values in a given field.', 'Purpose' : 'Count matching records in a database', 'Return value' : 'Numeric count of matching records', 'Arguments' : 'database - Database range including headers.field - [optional] Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DCOUNTA(database, [field], criteria)' },
    'DGET' : { 'Summary' : 'The Excel DGET function gets a single value in a given field from a record that matches criteria. DGET will throw the #NUM error if more than one record matches criteria.', 'Purpose' : 'Get value from matching record', 'Return value' : 'The value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DGET(database, field, criteria)' },
    'DMAX' : { 'Summary' : 'The Excel DMAX function returns the maximum value in a field, from a set of records that match criteria. Use the DMIN function to get the minimum value.', 'Purpose' : 'Get max from matching records', 'Return value' : 'The maximum value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DMAX(database, field, criteria)' },
    'DMIN' : { 'Summary' : 'The Excel DMIN function returns the minimum value in a field, from a set of records that match criteria. Use the MAX function to get the maximum value.', 'Purpose' : 'Get min from matching records', 'Return value' : 'The minimum value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DMIN(database, field, criteria)' },
    'DPRODUCT' : { 'Summary' : 'The Excel DPRODUCT function returns the product of values from a set of records that match criteria. The values to multiply are extracted from a given field in the database, specified as an argument.', 'Purpose' : 'Get product from matching records', 'Return value' : 'The calculated product', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DPRODUCT(database, field, criteria)' },
    'DSTDEV' : { 'Summary' : 'The Excel DSTDEV function returns the standard deviation of sample data extracted from records that match the given criteria. If data represents the entire population, use the DSTDEVP function.', 'Purpose' : 'Get standard deviation of sample in matching records', 'Return value' : 'The calculated standard deviation', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSTDEV(database, field, criteria)' },
    'DSTDEVP' : { 'Summary' : 'The Excel DSTDEVP function returns the standard deviation for an entire population of data extracted from records that match the given criteria. If data represents the entire population, use the DSTDEVP function.', 'Purpose' : 'Get standard deviation of population in matching records', 'Return value' : 'The calculated standard deviation', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSTDEVP(database, field, criteria)' },
    'DSUM' : { 'Summary' : 'The Excel DSUM function returns the sum of values from a set of records that match criteria. The values to sum are extracted from a given field in the database.', 'Purpose' : 'Get sum from matching records', 'Return value' : 'The calculated sum', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSUM(database, field, criteria)' },
    'DVAR' : { 'Summary' : 'The Excel DVAR function returns the variance of a sample extracted from records that match the given criteria. If data represents the entire population, use the DVARP function.', 'Purpose' : 'Get sample variance for matching records', 'Return value' : 'The calculated variance', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DVAR(database, field, criteria)' },
    'DVARP' : { 'Summary' : 'The Excel DVARP function returns the variance of an entire population extracted from records that match given criteria. If data represents the a sample only, use the DVAR function.', 'Purpose' : 'Get population variance for matching records', 'Return value' : 'The calculated variance', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DVARP(database, field, criteria)' },
    }


    
    list = []
    for i in fun:
        list.append(i)
    return list

def LearnExcelFormula(funcName,detail="['Summary','Purpose','Return value','Arguments','Syntax']"):
    import json
    
    fun = {'AND' : { 'Summary' : 'The Excel AND function is a logical function used to require more than one condition at the same time. AND returns either TRUE or FALSE. To test if a number in A1 is greater than zero and less than 10, use =AND(A1>0,A1<10). The AND function can be used as the logical test inside the IF function to avoid extra nested IFs, and can be combined with the OR function.', 'Purpose' : 'Test multiple conditions with AND', 'Return value' : 'TRUE if all arguments evaluate TRUE; FALSE if not', 'Arguments' : 'logical1 - The first condition or logical value to evaluate.logical2 - [optional] The second condition or logical value to evaluate.', 'Syntax' : '=AND(logical1, [logical2], ...)' },
    'FALSE' : { 'Summary' : 'The Excel FALSE function returns the Boolean value FALSE. The FALSE function is classified as a "compatibility function", needed only for compatibility with other spreadsheet applications. There is no need to use FALSE() if you are creating a spreadsheet in Excel.', 'Purpose' : 'Generate the logical value FALSE', 'Return value' : 'The logical value FALSE', 'Arguments' : '', 'Syntax' : '=FALSE()' },
    'IF' : { 'Summary' : 'The Excel IF function runs a logical test and returns one value for a TRUE result, and another for a FALSE result. For example, to "pass" scores above 70: =IF(A1>70,"Pass","Fail"). More than one condition can be tested by nesting IF functions. The IF function can be combined with logical functions like AND and OR to extend the logical test.', 'Purpose' : 'Test for a specific condition', 'Return value' : 'The values you supply for TRUE or FALSE', 'Arguments' : 'logical_test - A value or logical expression that can be evaluated as TRUE or FALSE.value_if_true - [optional] The value to return when logical_test evaluates to TRUE.value_if_false - [optional] The value to return when logical_test evaluates to FALSE.', 'Syntax' : '=IF(logical_test, [value_if_true], [value_if_false])' },
    'IFERROR' : { 'Summary' : 'The Excel IFERROR function returns a custom result when a formula generates an error, and a standard result when no error is detected. IFERROR is an elegant way to trap and manage errors without using more complicated nested IF statements.', 'Purpose' : 'Trap and handle errors', 'Return value' : 'The value you specify for error conditions.', 'Arguments' : 'value - The value, reference, or formula to check for an error.value_if_error - The value to return if an error is found.', 'Syntax' : '=IFERROR(value, value_if_error)' },
    'IFNA' : { 'Summary' : 'The Excel IFNA function is a simple way to trap and handle #N/A errors specifically without catching other errors. The IFNA function returns a custom result when a formula generates the #N/A error, and a normal result when no error is detected.', 'Purpose' : 'Trap and handle #N/A errors', 'Return value' : 'The value supplied for #N/A errors', 'Arguments' : 'value - The value, reference, or formula to check for an error.value_if_na - The value to return if #N/A error is found.', 'Syntax' : '=IFNA(value, value_if_na)' },
    'IFS' : { 'Summary' : 'The Excel IFS function can run multiple tests and return a value corresponding to the first TRUE result. Use the IFS function to evaluate multiple conditions without multiple nested IF statements. IFS allows shorter, easier to read formulas.', 'Purpose' : 'Test multiple conditions, return first true', 'Return value' : 'Value corresponding with first TRUE result', 'Arguments' : 'test1 - First logical test.value1 - Result when test1 is TRUE.test2, value2 - [optional] Second test/value pair.', 'Syntax' : '=IFS(test1, value1, [test2, value2], ...)' },
    'NOT' : { 'Summary' : 'The Excel NOT function returns the opposite of a given logical or Boolean value. When given TRUE, NOT returns FALSE. When given FALSE, NOT returns TRUE. Use the NOT function to reverse a logical value.', 'Purpose' : 'Reverse arguments or results', 'Return value' : 'A reversed logical value', 'Arguments' : 'logical - A value or logical expression that can be evaluated as TRUE or FALSE.', 'Syntax' : '=NOT(logical)' },
    'OR' : { 'Summary' : 'The Excel OR function returns TRUE if any given argument evaluates to TRUE, and returns FALSE if all supplied arguments evaluate to FALSE. For example, to test A1 for either "x" or "y", use =OR(A1="x",A1="y"). The OR function can be used as the logical test inside the IF function to avoid nested IFs, and can be combined with the AND function.', 'Purpose' : 'Test multiple conditions with OR', 'Return value' : 'TRUE if any arguments evaluate TRUE; FALSE if not.', 'Arguments' : 'logical1 - The first condition or logical value to evaluate.logical2 - [optional] The second condition or logical value to evaluate.', 'Syntax' : '=OR(logical1, [logical2], ...)' },
    'SWITCH' : { 'Summary' : 'The Excel SWITCH function compares one value against a list of values, and returns a result corresponding to the first match found. When no match is found, SWITCH can return an optional default value.', 'Purpose' : 'Match multiple values, return first match', 'Return value' : 'Result corresponding with first match', 'Arguments' : 'expression - The value or expression to match against.val1/result1 - The first value and result pair.val2/result2 - [optional] The second value and result pair.default - [optional] The default value to use when no match is found.', 'Syntax' : '=SWITCH(expression, val1/result1, [val2/result2], ..., [default])' },
    'TRUE' : { 'Summary' : 'The Excel TRUE function returns the Boolean value TRUE. The TRUE function is classified as a "compatibility function", needed only for compatibility with other spreadsheet applications. There is no need to use TRUE() if you are creating a spreadsheet in Excel.', 'Purpose' : 'Generate the logical value TRUE', 'Return value' : 'The logical value TRUE', 'Arguments' : '', 'Syntax' : '=TRUE()' },
    'XOR' : { 'Summary' : 'The XOR function performs what is called "exclusive OR". With two logical statements, XOR returns TRUE if either statement is TRUE, but returns FALSE if both statements are TRUE. If neither is TRUE, XOR also returns FALSE.', 'Purpose' : 'Perform exclusive OR', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'logical1 - An expression, constant, or reference that evaluates to TRUE or FALSE.logical2 - [optional] An expression, constant, or reference that evaluates to TRUE or FALSE.', 'Syntax' : '=XOR(logical1, [logical2], ...)' },
    'DATE' : { 'Summary' : 'The Excel DATE function creates a valid date from individual year, month, and day components. The DATE function is useful for assembling dates that need to change dynamically based on other values in a worksheet.', 'Purpose' : 'Create a date with year, month, and day', 'Return value' : 'A valid Excel date', 'Arguments' : 'year - Number for year.month - Number for month.day - Number for day.', 'Syntax' : '=DATE(year, month, day)' },
    'DATEDIF' : { 'Summary' : 'The Excel DATEDIF function returns the difference between two date values in years, months, or days. The DATEDIF (Date + Dif) function is a "compatibility" function that comes from Lotus 1-2-3. For reasons unknown, it is only documented in Excel 2000, but you can use it in your formulas in all Excel versions since that time.', 'Purpose' : 'Get days, months, or years between two dates', 'Return value' : 'A number representing time between two dates', 'Arguments' : 'start_date - Start date in Excel date serial number format.end_date - End date in Excel date serial number format.unit - The time unit to use (years, months, or days).', 'Syntax' : '=DATEDIF(start_date, end_date, unit)' },
    'DATEVALUE' : { 'Summary' : 'The Excel DATEVALUE function converts a date represented as a text string into a valid Excel date. For example, the formula =DATEVALUE("3/10/1975") returns a serial number (27463) in the Excel date system that represents March 10, 1975. Proper Excel dates are more useful than text dates since they can be directly manipulated with formulas and pivot tables .', 'Purpose' : 'Convert a date in text format to a valid date', 'Return value' : 'A valid Excel time as a serial number', 'Arguments' : 'date_text - A valid date in text format.', 'Syntax' : '=DATEVALUE(date_text)' },
    'DAY' : { 'Summary' : 'The Excel DAY function returns the day of the month as a number between 1 to 31 from a given date. You can use the DAY function to extract a day number from a date into a cell. You can also use the DAY function to extract and feed a day value into another function, like the DATE function.', 'Purpose' : 'Get the day as a number (1-31) from a date', 'Return value' : 'A number (1-31) representing the day component in a date.', 'Arguments' : 'date - A valid Excel date.', 'Syntax' : '=DAY(date)' },
    'DAYS' : { 'Summary' : 'The Excel DAYS function returns the number of days between two dates. With a start date in A1 and end date in B1, =DAYS(B1,A1) will return the days between the two dates.', 'Purpose' : 'Count days between dates', 'Return value' : 'A number representing days.', 'Arguments' : 'end_date - The end date.start_date - The start date.', 'Syntax' : '=DAYS(end_date, start_date)' },
    'DAYS360' : { 'Summary' : 'The Excel DAYS360 function returns the number of days between two dates based on a 360-day year, where all months are assumed to have 30 days. For example, the formula =DAYS360("1-Jan-2021","31-Dec-2021") returns 360 days.', 'Purpose' : 'Get days between 2 dates in a 360-day year', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.method - [optional] Day count method. FALSE (default) = US method, TRUE = European method.', 'Syntax' : '=DAYS360(start_date, end_date, [method])' },
    'EDATE' : { 'Summary' : 'The Excel EDATE function returns a date on the same day of the month, n months in the past or future. You can use EDATE to calculate expiration dates, maturity dates, and other due dates. Use a positive value for months to get a date in the future, and a negative value for dates in the past.', 'Purpose' : 'Shift date n months in future or past', 'Return value' : 'New date as Excel serial number', 'Arguments' : 'start_date - Start date as a valid Excel date.months - Number of months before or after start_date.', 'Syntax' : '=EDATE(start_date, months)' },
    'EOMONTH' : { 'Summary' : 'The Excel EOMONTH function returns the last day of the month, n months in the past or future. You can use EOMONTH to calculate expiration dates, due dates, and other dates that need to land on the last day of a month. Use a positive value for months to move forward in time, and a negative number to move back in time.', 'Purpose' : 'Get last day of month n months in future or past', 'Return value' : 'Last day of month date', 'Arguments' : 'start_date - A date that represents the start date in a valid Excel serial number format.months - The number of months before or after start_date.', 'Syntax' : '=EOMONTH(start_date, months)' },
    'HOUR' : { 'Summary' : 'The Excel HOUR function returns the hour component of a time as a number between 0-23. For example, with a time of 9:30 AM, HOUR will return 9. You can use the HOUR function to extract the hour into a cell, or feed the result into another formula, like the TIME function.', 'Purpose' : 'Get the hour as a number (0-23) from a Time', 'Return value' : 'A number between 0 and 23.', 'Arguments' : 'serial_number - A valid Excel time.', 'Syntax' : '=HOUR(serial_number)' },
    'ISOWEEKNUM' : { 'Summary' : 'The Excel ISOWEEKNUM function takes a date and returns a week number (1-54) that follows ISO standards, where weeks begin on Monday and week number 1 is assigned to the first week in a year that contains a Thursday.', 'Purpose' : 'Get ISO week number for a given date', 'Return value' : 'A number between 1 and 54.', 'Arguments' : 'date - A valid Excel date in serial number format.', 'Syntax' : '=ISOWEEKNUM(date)' },
    'MINUTE' : { 'Summary' : 'The Excel MINUTE function extracts the minute component of a time as a number between 0-59. For example, with a time of 9:45 AM, minute will return 45. You can use the MINUTE function to extract the minute into a cell, or feed the result into another function like the TIME function.', 'Purpose' : 'Get minute as a number (0-59) from time', 'Return value' : 'Number between 0 and 59.', 'Arguments' : 'serial_number - A valid date or time.', 'Syntax' : '=MINUTE(serial_number)' },
    'MONTH' : { 'Summary' : 'The Excel MONTH function extracts the month from a given date as number between 1 to 12. You can use the MONTH function to extract a month number from a date into a cell, or to feed a month number into another function like the DATE function.', 'Purpose' : 'Get month as a number (1-12) from a date', 'Return value' : 'A number between 1 and 12.', 'Arguments' : 'serial_number - A valid Excel date.', 'Syntax' : '=MONTH(serial_number)' },
    'NETWORKDAYS' : { 'Summary' : 'The Excel NETWORKDAYS function calculates the number of working days between two dates. NETWORKDAYS automatically excludes weekends (Saturday and Sunday) and can optionally exclude a list of holidays supplied as dates. ', 'Purpose' : 'Get the number of working days between two dates', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.holidays - [optional] A list of non-work days as dates.', 'Syntax' : '=NETWORKDAYS(start_date, end_date, [holidays])' },
    'NETWORKDAYS.INTL' : { 'Summary' : 'The Excel NETWORKDAYS.INTL function calculates the number of working days between two dates. NETWORKDAYS.INTL can optionally exclude a list of holidays and provides a way to specify which days of the week are considered weekends.', 'Purpose' : 'Get work days between two dates', 'Return value' : 'A number representing days.', 'Arguments' : 'start_date - The start date.end_date - The end date.weekend - [optional] Setting for which days of the week should be considered weekends.holidays - [optional] A reference to dates that should be considered non-work days.', 'Syntax' : '=NETWORKDAYS.INTL(start_date, end_date, [weekend], [holidays])' },
    'NOW' : { 'Summary' : 'The Excel NOW function returns the current date and time, updated continuously when a worksheet is changed or opened. The NOW function takes no arguments. You can format the value returned by NOW as a date, or as a date with time by applying a number format.', 'Purpose' : 'Get the current date and time', 'Return value' : 'A number representing the current date and time in Excel.', 'Arguments' : '', 'Syntax' : '=NOW()' },
    'SECOND' : { 'Summary' : 'The Excel SECOND function returns the second component of a time as a number between 0-59. For example, with a time of 9:10:15 AM, second will return 15. You can use the SECOND function to extract the second into a cell, or feed the result into another formula, like the TIME function.', 'Purpose' : 'Get the Second as a number (0-59) from a Time', 'Return value' : 'A number between 0 and 59', 'Arguments' : 'serial_number - A valid time in a format Excel recognizes.', 'Syntax' : '=SECOND(serial_number)' },
    'TIME' : { 'Summary' : 'The Excel TIME function is a built-in function that allows you to create a time with individual hour, minute, and second components. The TIME function is useful when you want to assemble a proper time inside another formula.', 'Purpose' : 'Create a time with hours, minutes, and seconds', 'Return value' : 'A decimal number representing a particular time in Excel.', 'Arguments' : 'hour - The hour for the time you wish to create.minute - The minute for the time you wish to create.second - The second for the time you wish to create.', 'Syntax' : '=TIME(hour, minute, second)' },
    'TIMEVALUE' : { 'Summary' : 'The Excel TIMEVALUE function converts a time represented as text into a proper Excel time. For example, the formula =TIMEVALUE("9:00 AM") returns 0.375, the numeric representation of 9:00 AM in Excel\'s time system. Numeric time values are more useful than text since they can be directly manipulated with formulas and pivot tables.', 'Purpose' : 'Get a valid time from a text string', 'Return value' : 'A valid Excel time as a decimal number', 'Arguments' : 'time_text - A date and/or time in a text format recognized by Excel.', 'Syntax' : '=TIMEVALUE(time_text)' },
    'TODAY' : { 'Summary' : 'The Excel TODAY function returns the current date, updated continuously when a worksheet is changed or opened. The TODAY function takes no arguments. You can format the value returned by TODAY with a date number format. If you need current date and time, use the NOW function.', 'Purpose' : 'Get the current date', 'Return value' : 'Excel date as a serial number', 'Arguments' : '', 'Syntax' : '=TODAY()' },
    'WEEKDAY' : { 'Summary' : 'The Excel WEEKDAY function takes a date and returns a number between 1-7 representing the day of week. By default, WEEKDAY returns 1 for Sunday and 7 for Saturday, but this is configurable. You can use the WEEKDAY function inside other formulas to check the day of week.', 'Purpose' : 'Get the day of the week as a number', 'Return value' : 'A number between 0 and 7.', 'Arguments' : 'serial_number - The date for which you want to get the day of week.return_type - [optional] A number representing day of week mapping scheme. Default is 1.', 'Syntax' : '=WEEKDAY(serial_number, [return_type])' },
    'WEEKNUM' : { 'Summary' : 'The Excel WEEKNUM function takes a date and returns a week number (1-54) that corresponds to the week of year. The WEEKNUM function starts counting on the week that contains January 1. By default, weeks begin on Sunday, but this can be changed.', 'Purpose' : 'Get the week number for a given date', 'Return value' : 'A number between 1 and 54.', 'Arguments' : 'serial_num - A valid Excel date in serial number format.return_type - [optional] The day the week begins. Default is 1.', 'Syntax' : '=WEEKNUM(serial_num, [return_type])' },
    'WORKDAY' : { 'Summary' : 'The Excel WORKDAY function takes a date and returns the nearest working day n days in the future or past. You can use the WORKDAY function to calculate things like ship dates, delivery dates, and completion dates that need to take into account working and non-working days.', 'Purpose' : 'Get a date n working days in the future or past', 'Return value' : 'A serial number representing a particular date in Excel.', 'Arguments' : 'start_date - The date from which to start.days - The working days before or after start_date.holidays - [optional] A list dates that should be considered non-work days.', 'Syntax' : '=WORKDAY(start_date, days, [holidays])' },
    'WORKDAY.INTL' : { 'Summary' : 'The Excel WORKDAY.INTL function takes a date and returns the nearest working n days in the future or past, based on an offset value you provide. Unlike the WORKDAY function, WORKDAY.INTL allows you to customize which days are considered weekends (non-working days). You can use WORKDAY.INTL function to calculate completion dates, ship dates, etc. that take into account non-working days.', 'Purpose' : 'Get date n working days in future or past', 'Return value' : 'Next or previous working date based on inputs', 'Arguments' : 'start_date - The start date.days - The end date.weekend - [optional] Setting for which days of the week should be considered weekends.holidays - [optional] A list of one or more dates that should be considered non-work days.', 'Syntax' : '=WORKDAY.INTL(start_date, days, [weekend], [holidays])' },
    'YEAR' : { 'Summary' : 'The Excel YEAR function returns the year component of a date as a 4-digit number. You can use the YEAR function to extract a year number from a date into a cell or to extract and feed a year value into another formula, like the DATE function.', 'Purpose' : 'Get the year from a date', 'Return value' : 'Year as 4-digit number', 'Arguments' : 'date - A valid Excel date.', 'Syntax' : '=YEAR(date)' },
    'YEARFRAC' : { 'Summary' : 'The Excel YEARFRAC function returns a decimal value that represents fractional years between two dates. You can use YEARFRAC to do things like calculate age with a birthdate.', 'Purpose' : 'Get the fraction of a year between two dates', 'Return value' : 'A decimal number', 'Arguments' : 'start_date - The start date.end_date - The end date.basis - [optional] The type of day count basis to use (see below).', 'Syntax' : '=YEARFRAC(start_date, end_date, [basis])' },
    'ADDRESS' : { 'Summary' : 'The Excel ADDRESS function returns the address for a cell based on a given row and column number. For example, =ADDRESS(1,1) returns $A$1. ADDRESS can return an address in relative, mixed, or absolute format, and can be used to construct a cell reference inside a formula.', 'Purpose' : 'Create a cell address from a row and column number', 'Return value' : 'A cell address in the current or given worksheet.', 'Arguments' : 'row_num - The row number to use in the cell address.col_num - The column number to use in the cell address.abs_num - [optional] The address type (i.e. absolute, relative). Defaults to absolute.a1 - [optional] The reference style, A1 vs R1C1. Defaults to A1 style.sheet - [optional] The name of the worksheet to use. Defaults to current sheet.', 'Syntax' : '=ADDRESS(row_num, col_num, [abs_num], [a1], [sheet])' },
    'AREAS' : { 'Summary' : 'The Excel AREAS function returns the number of areas in a given reference. For example, =AREAS((A1:C1,A2:C2)) returns 2. Multiple references must be enclosed in an extra set of parentheses.', 'Purpose' : 'Get the number of areas in a reference.', 'Return value' : 'A number representing number of areas.', 'Arguments' : 'reference - Reference(s) to a cell or range of cells.', 'Syntax' : '=AREAS(reference)' },
    'CHOOSE' : { 'Summary' : 'The Excel CHOOSE function returns a value from a list using a given position or index. For example, =CHOOSE(2,"red","blue","green") returns "blue", since blue is the 2nd value listed after the index number. The values provided to CHOOSE can include references.', 'Purpose' : 'Get a value from a list based on position', 'Return value' : 'The value at the given position.', 'Arguments' : 'index_num - The value to choose. A number between 1 and 254.value1 - The first value from which to choose.value2 - [optional] The second value from which to choose.', 'Syntax' : '=CHOOSE(index_num, value1, [value2], ...)' },
    'COLUMN' : { 'Summary' : 'The Excel COLUMN function returns the column number for a reference. For example, COLUMN(C5) returns 3, since C is the third column in the spreadsheet. When no reference is provided, COLUMN returns the column number of the cell which contains the formula.', 'Purpose' : 'Get the column number of a reference.', 'Return value' : 'A number representing the column.', 'Arguments' : 'reference - [optional] A reference to a cell or range of cells.', 'Syntax' : '=COLUMN([reference])' },
    'COLUMNS' : { 'Summary' : 'The Excel COLUMNS function returns the count of columns in a given reference. For example, COLUMNS(A1:C3) returns 3, since the range A1:C3 contains 3 columns.', 'Purpose' : 'Get the number of columns in an array or reference.', 'Return value' : 'Number of columns', 'Arguments' : 'array - A reference to a range of cells.', 'Syntax' : '=COLUMNS(array)' },
    'FIELDVALUE' : { 'Summary' : 'The Excel FIELDVALUE function extracts a given field value from a data type. The field is specified by name and provided as a text value.', 'Purpose' : 'Extract field value from a data type', 'Return value' : 'Field value for given data type', 'Arguments' : 'value - The data type with field values.field_name - The field name provided as a text value.', 'Syntax' : '=FIELDVALUE(value, field_name)' },
    'FORMULATEXT' : { 'Summary' : 'The Excel FORMULATEXT function returns a formula as a text string from a given reference. You can use FORMULATEXT to extract the formula as text from a cell. If you use FORMULATEXT on a cell that doesn\'t contain a formula, it returns #N/A.', 'Purpose' : 'Get the formula in a cell', 'Return value' : 'The formula as text', 'Arguments' : 'reference - Reference to cell or cell range.', 'Syntax' : '=FORMULATEXT(reference)' },
    'GETPIVOTDATA' : { 'Summary' : 'The Excel GETPIVOTDATA function can retrieve specific data from a pivot table by name based on the structure, instead of cell references.', 'Purpose' : 'Retrieve data from a pivot table in a formula', 'Return value' : 'The data requested', 'Arguments' : 'data_field - The name of the value field to query.pivot_table - A reference to any cell in the pivot table to query.field1, item1 - [optional] A field/item pair.', 'Syntax' : '=GETPIVOTDATA(data_field, pivot_table, [field1, item1], ...)' },
    'HLOOKUP' : { 'Summary' : 'The Excel HLOOKUP function finds and retrieve a value from data in a horizontal table. The "H" in HLOOKUP stands for "horizontal", and lookup values must appear in the first row of the table, moving horizontally to the right. HLOOKUP supports approximate and exact matching, and wildcards (* ?) for finding partial matches.', 'Purpose' : ' Look up a value in a table arranged horizontally', 'Return value' : 'The matched value from a table.', 'Arguments' : 'lookup_value - The value to look up.table_array - The table from which to retrieve data.row_index - The row number from which to retrieve data.range_lookup - [optional] A Boolean to indicate exact match or approximate match. Default = TRUE = approximate match.', 'Syntax' : '=HLOOKUP(lookup_value, table_array, row_index, [range_lookup])' },
    'HYPERLINK' : { 'Summary' : 'The Excel HYPERLINK function returns a hyperlink from a given destination and link text. You can use HYPERLINK to create a clickable hyperlink with a formula. The HYPERLINK function can build links to workbook locations, pages on the internet, or to files on network servers.', 'Purpose' : 'Create a clickable link.', 'Return value' : 'A clickable hyperlink', 'Arguments' : 'link_location - The path to the file or page to be opened.friendly_name - [optional] The link text to display in a cell.', 'Syntax' : '=HYPERLINK(link_location, [friendly_name])' },
    'INDEX' : { 'Summary' : 'The Excel INDEX function returns the value at a given location in a range or array. You can use INDEX to retrieve individual values, or entire rows and columns. The MATCH function is often used together with INDEX to provide row and column numbers.', 'Purpose' : 'Get a value in a list or table based on location', 'Return value' : 'The value at a given location.', 'Arguments' : 'array - A range of cells, or an array constant.row_num - The row position in the reference or array.col_num - [optional] The column position in the reference or array.area_num - [optional] The range in reference that should be used.', 'Syntax' : '=INDEX(array, row_num, [col_num], [area_num])' },
    'INDIRECT' : { 'Summary' : 'The Excel INDIRECT function returns a valid cell reference from a given text string. INDIRECT is useful when you want to assemble a text value that can be used as a valid reference.', 'Purpose' : 'Create a reference from text', 'Return value' : 'A valid worksheet reference.', 'Arguments' : 'ref_text - A reference supplied as text.a1 - [optional] A boolean to indicate A1 or R1C1-style reference. Default is TRUE = A1 style.', 'Syntax' : '=INDIRECT(ref_text, [a1])' },
    'LOOKUP' : { 'Summary' : 'The Excel LOOKUP function performs an approximate match lookup in a one-column or one-row range, and returns the corresponding value from another one-column or one-row range. LOOKUP\'s default behavior makes it useful for solving certain problems in Excel.', 'Purpose' : 'Look up a value in a one-column range', 'Return value' : 'A value in the result vector.', 'Arguments' : 'lookup_value - The value to search for.lookup_vector - The one-row, or one-column range to search.result_vector - [optional] The one-row, or one-column range of results.', 'Syntax' : '=LOOKUP(lookup_value, lookup_vector, [result_vector])' },
    'MATCH' : { 'Summary' : 'MATCH is an Excel function used to locate the position of a lookup value in a row, column, or table. MATCH supports approximate and exact matching, and wildcards (* ?) for partial matches. Often, MATCH is combined with the INDEX function to retrieve a value at a matched position.', 'Purpose' : 'Get the position of an item in an array', 'Return value' : 'A number representing a position in lookup_array.', 'Arguments' : 'lookup_value - The value to match in lookup_array.lookup_array - A range of cells or an array reference.match_type - [optional] 1 = exact or next smallest (default), 0 = exact match, -1 = exact or next largest.', 'Syntax' : '=MATCH(lookup_value, lookup_array, [match_type])' },
    'OFFSET' : { 'Summary' : 'The Excel OFFSET function returns a reference to a range constructed with five inputs: (1) a starting point, (2) a row offset, (3) a column offset, (4) a height in rows, (5) a width in columns. OFFSET is handy in formulas that require a dynamic range.', 'Purpose' : 'Create a reference offset from given starting point', 'Return value' : 'A cell reference.', 'Arguments' : 'reference - The starting point, supplied as a cell reference or range.rows - The number of rows to offset below the starting reference.cols - The number of columns to offset to the right of the starting reference.height - [optional] The height in rows of the returned reference.width - [optional] The width in columns of the returned reference.', 'Syntax' : '=OFFSET(reference, rows, cols, [height], [width])' },
    'ROW' : { 'Summary' : 'The Excel ROW function returns the row number for a reference. For example, ROW(C5) returns 5, since C5 is the fifth row in the spreadsheet. When no reference is provided, ROW returns the row number of the cell which contains the formula.', 'Purpose' : 'Get the row number of a reference', 'Return value' : 'A number representing the row.', 'Arguments' : 'reference - [optional] A reference to a cell or range of cells.', 'Syntax' : '=ROW([reference])' },
    'ROWS' : { 'Summary' : 'The Excel ROWS function returns the count of rows in a given reference. For example, ROWS(A1:A3) returns 3, since the range A1:A3 contains 3 rows.', 'Purpose' : 'Get the number of rows in an array or reference.', 'Return value' : 'Number of rows', 'Arguments' : 'array - A reference to a cell or range of cells.', 'Syntax' : '=ROWS(array)' },
    'TRANSPOSE' : { 'Summary' : 'The Excel TRANSPOSE function "flips" the orientation of a given range or array: TRANSPOSE flips a vertical range to a horizontal range, and flips a horizontal range to a vertical range.', 'Purpose' : 'Flip the orientation of a range of cells', 'Return value' : 'An array in a new orientation.', 'Arguments' : 'array - The array or range of cells to transpose.', 'Syntax' : '=TRANSPOSE(array)' },
    'VLOOKUP' : { 'Summary' : 'VLOOKUP is an Excel function to look up data in a table organized vertically. VLOOKUP supports approximate and exact matching, and wildcards (* ?) for partial matches. Lookup values must appear in the first column of the table passed into VLOOKUP.', 'Purpose' : 'Lookup a value in a table by matching on the first column', 'Return value' : 'The matched value from a table.', 'Arguments' : 'lookup_value - The value to look for in the first column of a table.table_array - The table from which to retrieve a value.column_index_num - The column in the table from which to retrieve a value.range_lookup - [optional] TRUE = approximate match (default). FALSE = exact match.', 'Syntax' : '=VLOOKUP(lookup_value, table_array, column_index_num, [range_lookup])' },
    'CHAR' : { 'Summary' : 'The Excel CHAR function returns a character when given a valid character code. CHAR can be used to specify characters that are hard to enter in a formula. For example, CHAR(10) returns a line break, and can be used to add a line break to text in a formula.', 'Purpose' : 'Get a character from a number', 'Return value' : 'A single character specified by a number.', 'Arguments' : 'number - A number between 1 and 255.', 'Syntax' : '=CHAR(number)' },
    'CLEAN' : { 'Summary' : 'The Excel CLEAN function takes a text string and returns text that has been "cleaned" of line breaks and other non-printable characters.', 'Purpose' : 'Strip non-printable characters from text', 'Return value' : 'Text with non-printable characters removed.', 'Arguments' : 'text - The text to clean.', 'Syntax' : '=CLEAN(text)' },
    'CODE' : { 'Summary' : 'The Excel CODE function returns a numeric code for a given character. For example, CODE("a") returns the code 97.', 'Purpose' : 'Get the code for a character', 'Return value' : 'A numeric code representing a character.', 'Arguments' : 'text - The text for which you want a numeric code.', 'Syntax' : '=CODE(text)' },
    'CONCAT' : { 'Summary' : 'The Excel CONCAT function concatenates (joins) values supplied as references or constants. Unlike the CONCATENATE function (which CONCAT replaces), CONCAT will accept a range of cells to join, in addition to individual cell references.', 'Purpose' : 'Join text values without delimiter', 'Return value' : 'Result of concatenated text', 'Arguments' : 'text1 - First text value, cell reference, or range.text2 - [optional] Second text value, cell reference, or range.', 'Syntax' : '=CONCAT(text1, [text2], ...)' },
    'CONCATENATE' : { 'Summary' : 'The Excel CONCATENATE function concatenates (joins) join up to 30 values together and returns the result as text. In Excel 2019 and later, the CONCAT and TEXTJOIN functions are better, more flexible alternatives.', 'Purpose' : 'Join text together', 'Return value' : 'Text joined together.', 'Arguments' : 'text1 - The first text value to join together.text2 - The second text value to join together.text3 - [optional] The third text value to join together.', 'Syntax' : '=CONCATENATE(text1, text2, [text3], ...)' },
    'DOLLAR' : { 'Summary' : 'The Excel DOLLAR function converts a number to text using the Currency number format. The TEXT function can do the same thing, and is much more versatile.', 'Purpose' : 'Convert a number to text in currency format', 'Return value' : 'A number as text in currency format.', 'Arguments' : 'number - The number to convert.decimals - The number of digits to the right of the decimal point. Default is 2.', 'Syntax' : '=DOLLAR(number, decimals)' },
    'EXACT' : { 'Summary' : 'The Excel EXACT function compares two text strings, taking into account upper and lower case characters, and returns TRUE if they are the same, and FALSE if not. EXACT is case-sensitive.', 'Purpose' : 'Compare two text strings', 'Return value' : 'A boolean value (TRUE or FALSE)', 'Arguments' : 'text1 - The first text string to compare.text2 - The second text string to compare.', 'Syntax' : '=EXACT(text1, text2)' },
    'FIND' : { 'Summary' : 'The Excel FIND function returns the position (as a number) of one text string inside another. When the text is not found, FIND returns a #VALUE error.', 'Purpose' : 'Get location substring in a string', 'Return value' : 'A number representing the location of substring', 'Arguments' : 'find_text - The substring to find.within_text - The text to search within.start_num - [optional] The starting position in the text to search. Optional, defaults to 1.', 'Syntax' : '=FIND(find_text, within_text, [start_num])' },
    'FIXED' : { 'Summary' : 'The Excel FIXED function converts a number to text with fixed number of decimals, rounding as needed with the given number of decimals. The FIXED function can be useful when concatenating a formatted number text.', 'Purpose' : 'Format number as text with fixed decimals', 'Return value' : 'Number formatted as text', 'Arguments' : 'number - The number to round and format.decimals - [optional] Number of decimals to use. Default is 2.no_commas - [optional] Suppress commas. TRUE = no commas, FALSE = commas. Default is FALSE.', 'Syntax' : '=FIXED(number, [decimals], [no_commas])' },
    'LEFT' : { 'Summary' : 'The Excel LEFT function extracts a given number of characters from the left side of a supplied text string. For example, LEFT("apple",3) returns "app".', 'Purpose' : 'Extract text from the left of a string', 'Return value' : 'One or more characters.', 'Arguments' : 'text - The text from which to extract characters.num_chars - [optional] The number of characters to extract, starting on the left side of text. Default = 1.', 'Syntax' : '=LEFT(text, [num_chars])' },
    'LEN' : { 'Summary' : 'The Excel LEN function returns the length of a given text string as the number of characters. LEN will also count characters in numbers, but number formatting is not included.', 'Purpose' : 'Get the length of text.', 'Return value' : 'Number of characters', 'Arguments' : 'text - The text for which to calculate length.', 'Syntax' : '=LEN(text)' },
    'LOWER' : { 'Summary' : 'The Excel LOWER function converts a text string to all lowercase letters. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Convert text to lower case', 'Return value' : 'Text in lower case.', 'Arguments' : 'text - The text that should be converted to lower case.', 'Syntax' : '=LOWER(text)' },
    'MID' : { 'Summary' : 'The Excel MID function extracts a given number of characters from the middle of a supplied text string. For example, =MID("apple",2,3) returns "ppl".', 'Purpose' : 'Extract text from inside a string', 'Return value' : 'The characters extracted.', 'Arguments' : 'text - The text to extract from.start_num - The location of the first character to extract.num_chars - The number of characters to extract.', 'Syntax' : '=MID(text, start_num, num_chars)' },
    'NUMBERVALUE' : { 'Summary' : 'The Excel NUMBERVALUE function converts a number in text format to numeric value, using specified decimal and group separators. This function can be used to convert locale-specific values into locale-independent values.', 'Purpose' : 'Convert text to number with custom separators', 'Return value' : 'Numeric value', 'Arguments' : 'text - The text to convert to a number.decimal_separator - [optional] The character for decimal values.group_separator - [optional] The character for grouping by thousands.', 'Syntax' : '=NUMBERVALUE(text, [decimal_separator], [group_separator])' },
    'PROPER' : { 'Summary' : 'The Excel PROPER function capitalizes each word in a given text string. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Capitalize the first letter in each word', 'Return value' : 'Text in proper case.', 'Arguments' : 'text - The text that should be converted to proper case.', 'Syntax' : '=PROPER(text)' },
    'REPLACE' : { 'Summary' : 'The Excel REPLACE function replaces characters specified by location in a given text string with another text string. For example =REPLACE("XYZ123",4,3,"456") returns "XYZ456".', 'Purpose' : 'Replace text based on location', 'Return value' : 'The altered text.', 'Arguments' : 'old_text - The text to replace.start_num - The starting location in the text to search.num_chars - The number of characters to replace.new_text - The text to replace old_text with.', 'Syntax' : '=REPLACE(old_text, start_num, num_chars, new_text)' },
    'REPT' : { 'Summary' : 'The Excel REPT function repeats characters a given number of times. For example, =REPT("x",5) returns "xxxxx".', 'Purpose' : 'Repeat text as specified', 'Return value' : 'The repeated text.', 'Arguments' : 'text - The text to repeat.number_times - The number of times to repeat text.', 'Syntax' : '=REPT(text, number_times)' },
    'RIGHT' : { 'Summary' : 'The Excel RIGHT function extracts a given number of characters from the right side of a supplied text string. For example, RIGHT("apple",3) returns "ple".', 'Purpose' : 'Extract text from the right of a string', 'Return value' : 'One or more characters.', 'Arguments' : 'text - The text from which to extract characters on the right.num_chars - [optional] The number of characters to extract, starting on the right. Optional, default = 1.', 'Syntax' : '=RIGHT(text, [num_chars])' },
    'SEARCH' : { 'Summary' : 'The Excel SEARCH function returns the location of one text string inside another. SEARCH returns the position of find_text inside within_text as a number. SEARCH supports wildcards, and is not case-sensitive.', 'Purpose' : 'Get the location of substring in a string', 'Return value' : 'A number representing the location of substring', 'Arguments' : 'find_text - The substring to find.within_text - The text to search within.start_num - [optional] Starting position. Optional, defaults to 1.', 'Syntax' : '=SEARCH(find_text, within_text, [start_num])' },
    'SUBSTITUTE' : { 'Summary' : 'The Excel SUBSTITUTE function replaces text in a given string by matching. For example =SUBSTITUTE("952-455-7865","-","") returns "9524557865"; the dash is stripped. SUBSTITUTE is case-sensitive and does not support wildcards.', 'Purpose' : 'Replace text based on content', 'Return value' : 'The processed text', 'Arguments' : 'text - The text to change.old_text - The text to replace.new_text - The text to replace with.instance - [optional] The instance to replace. If not supplied, all instances are replaced.', 'Syntax' : '=SUBSTITUTE(text, old_text, new_text, [instance])' },
    'TEXT' : { 'Summary' : 'The Excel TEXT function returns a number in a given number format, as text. You can use the TEXT function to embed formatted numbers inside text.', 'Purpose' : 'Convert a number to text in a number format', 'Return value' : 'A number as text in the given format.', 'Arguments' : 'value - The number to convert.format_text - The number format to use.', 'Syntax' : '=TEXT(value, format_text)' },
    'TEXTJOIN' : { 'Summary' : 'The Excel TEXTJOIN function concatenates multiple values together with or without a delimiter. TEXTJOIN can concatenate values provided as cell references, ranges, or constants, and can optionally ignore empty cells', 'Purpose' : 'Join text values with a delimiter', 'Return value' : 'Concatenated text', 'Arguments' : 'delimiter - Separator between each text.ignore_empty - Whether to ignore empty cells or not.text1 - First text value or range.text2 - [optional] Second text value or range.', 'Syntax' : '=TEXTJOIN(delimiter, ignore_empty, text1, [text2], ...)' },
    'TRIM' : { 'Summary' : 'The Excel TRIM function strips extra spaces from text, leaving only a single space between words and no space characters at the start or end of the text.', 'Purpose' : 'Remove extra spaces from text', 'Return value' : 'Text with extra spaces removed.', 'Arguments' : 'text - The text from which to remove extra space.', 'Syntax' : '=TRIM(text)' },
    'UNICHAR' : { 'Summary' : 'The Excel UNICHAR function returns a Unicode character based on a given number.', 'Purpose' : 'Get Unicode character by number', 'Return value' : 'Unicode character', 'Arguments' : 'number - Code point for a Unicode character in decimal.', 'Syntax' : '=UNICHAR(number)' },
    'UNICODE' : { 'Summary' : 'The Excel UNICODE function returns a number (code point) corresponding to a Unicode character. Unicode is computing standard for the unified encoding, representation, and handling of text in most of the world\'s writing systems. ', 'Purpose' : 'Get number from Unicode character', 'Return value' : 'Unicode code point in decimal notation', 'Arguments' : 'text - Unicode character to convert to number.', 'Syntax' : '=UNICODE(text)' },
    'UPPER' : { 'Summary' : 'The Excel UPPER function converts a text string to all uppercase letters. Numbers, punctuation, and spaces are not affected.', 'Purpose' : 'Convert text to upper case', 'Return value' : 'Uppercase text.', 'Arguments' : 'text - The text thatto convert to upper case.', 'Syntax' : '=UPPER(text)' },
    'VALUE' : { 'Summary' : 'The Excel VALUE function converts text that appears in a recognized format (i.e. a number, date, or time format) into a numeric value. Normally, the VALUE function is not needed in Excel, because Excel automatically converts text to numeric values.', 'Purpose' : 'Convert text to a number', 'Return value' : 'A numeric value.', 'Arguments' : 'text - The text value to convert to a number.', 'Syntax' : '=VALUE(text)' },
    'ARRAYTOTEXT' : { 'Summary' : 'The Excel ARRAYTOTEXT function converts an array or range to a text string. The result can optionally include or omit curly braces.', 'Purpose' : 'Converts array or range to a text string', 'Return value' : 'A text string showing values', 'Arguments' : 'array - The array or range to convert to text.format - [optional] Output format. 0 = concise (default), and 1 = strict.', 'Syntax' : '=ARRAYTOTEXT(array, [format])' },
    'BYCOL' : { 'Summary' : 'The Excel BYCOL function applies a LAMBDA function to each column in a given array and returns one result per column as a single array. In the example shown, data is the named range C5:H9.', 'Purpose' : 'Apply function to column', 'Return value' : 'One result per column', 'Arguments' : 'array - The array or array to process.lambda - The lambda function to apply to each column.', 'Syntax' : '=BYCOL(array, lambda)' },
    'BYROW' : { 'Summary' : 'The Excel BYROW function applies a LAMBDA function to each row of a given array and returns one result per row in a single array. In the example shown, data is the named range C5:H9. ', 'Purpose' : 'Apply function to row', 'Return value' : 'One result per row', 'Arguments' : 'array - The array or array to process.lambda - The lambda function to apply to each row.', 'Syntax' : '=BYROW(array, lambda)' },
    'CHOOSECOLS' : { 'Summary' : 'The Excel CHOOSECOLS function returns specific columns from an array or range. The columns to return are provided as numbers in separate arguments. Each number corresponds to the numeric index of a column in the given array.', 'Purpose' : 'Return specific columns from an array', 'Return value' : 'Extracted columns in a single array', 'Arguments' : 'array - The array to extract columns from.col_num1 - The numeric index of the first column to return.col_num2 - [optional] The numeric index of the second column to return.', 'Syntax' : '=CHOOSECOLS(array, col_num1, [col_num2], ...)' },
    'CHOOSEROWS' : { 'Summary' : 'The Excel CHOOSEROWS function returns specific rows from an array or range. The rows to return are provided as numbers in separate arguments. Each number corresponds to the numeric index of a row in the given array.', 'Purpose' : 'Return specific rows from an array', 'Return value' : 'Extracted rows in a single array', 'Arguments' : 'array - The array to extract rows from.row_num1 - The numeric index of the first row to return.row_num2 - [optional] The numeric index of the second row to return.', 'Syntax' : '=CHOOSEROWS(array, row_num1, [row_num2], ...)' },
    'DROP' : { 'Summary' : 'The Excel DROP function returns a subset of a given array by "dropping" rows and columns. The number of rows and columns to remove is provided by separate rows and columns arguments. Rows and columns can be dropped from the start or end of the given array.', 'Purpose' : 'Remove portion of an array', 'Return value' : 'The remaining array', 'Arguments' : 'array - The source array or range.rows - [optional] Number of rows to drop.col - [optional] Number of columns to drop.', 'Syntax' : '=DROP(array, [rows], [col])' },
    'EXPAND' : { 'Summary' : 'The EXPAND function expands an array by adding rows and columns, which are supplied as separate arguments. The numbers given for rows and columns represent the dimensions of the final array.', 'Purpose' : 'Expand array by adding rows or columns', 'Return value' : 'Expanded array', 'Arguments' : 'array - The array to expand.rows - [optional] The final number of rows. Default is total rows.columns - [optional] The final number of columns. Default is total columns.pad_with - [optional] Value to use for new cells. Default is #N/A.', 'Syntax' : '=EXPAND(array, [rows], [columns], [pad_with])' },
    'FILTER' : { 'Summary' : 'The Excel FILTER function filters a range of data based on supplied criteria, and extracts matching records.', 'Purpose' : 'Filters range with given criteria', 'Return value' : 'Array of filtered values', 'Arguments' : 'array - Range or array to filter.include - Boolean array, supplied as criteria.if_empty - [optional] Value to return when no results are returned.', 'Syntax' : '=FILTER(array, include, [if_empty])' },
    'HSTACK' : { 'Summary' : 'The Excel HSTACK function combines arrays horizontally into a single array. Each subsequent array is appended to the right of of the previous array.', 'Purpose' : 'Combine ranges or arrays horizontally', 'Return value' : 'A single combined range or array', 'Arguments' : 'array1 - The first array or range to combine.array2 - [optional] The second array or range to combine.', 'Syntax' : '=HSTACK(array1, [array2], ...)' },
    'ISOMITTED' : { 'Summary' : 'The Excel ISOMITTED function is a helper function for LAMBDA functions to allow optional arguments. Inside a LAMBDA function, ISOMITTED will return TRUE when an argument has not been provided.', 'Purpose' : 'Check for optional arguments in LAMBDAs', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'argument - The argument to test for.', 'Syntax' : '=ISOMITTED(argument)' },
    'LAMBDA' : { 'Summary' : 'The Excel LAMBDA function provides a way create custom functions that can be reused throughout a workbook, without VBA or macros.', 'Purpose' : 'Create custom function', 'Return value' : 'As defined by formula', 'Arguments' : 'parameter - An input value for the function.calculation - The calculation to perform as the result of the function. Must be last argument.', 'Syntax' : '=LAMBDA(parameter, ..., calculation)' },
    'LET' : { 'Summary' : 'The Excel LET function lets you define named variables in a formula. There are two primary reasons you might want to do this: (1) to improve performance by eliminating redundant calculations and (2) to make more complex formulas easier to read and write.', 'Purpose' : 'Assign variables inside formula', 'Return value' : 'Normal formula result', 'Arguments' : 'name1 - First name to assign. Must begin with a letter.value1 - The value or calculation to assign to name 1.name2/value2 - [optional] Second name and value. Entered as a pair of arguments.result - A calculation or a variable previously calculated.', 'Syntax' : '=LET(name1, value1, [name2/value2], ..., result)' },
    'MAKEARRAY' : { 'Summary' : 'The Excel MAKEARRAY function returns a array with specified rows and columns, based on a custom LAMBDA calculation. MAKEARRAY can be used to create arrays with variable dimensions where values are the result of a calculation.', 'Purpose' : 'Create array with calculated values', 'Return value' : 'An array of calculated values', 'Arguments' : 'rows - The number of rows to create.columns - The number of columns to create.lambda - The custom LAMBDA calculation to apply.', 'Syntax' : '=MAKEARRAY(rows, columns, lambda)' },
    'MAP' : { 'Summary' : 'The Excel MAP function "maps" a custom LAMBDA function to each value in a supplied array. The LAMBDA is applied to each value, and the result from MAP is an array of results with the same dimensions as the original array.', 'Purpose' : 'Map array to custom function', 'Return value' : 'Array of results', 'Arguments' : 'array1 - The array to be mapped.array2 - [optional] Additional arrays required by the LAMBDA.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=MAP(array1, [array2], ..., lambda)' },
    'RANDARRAY' : { 'Summary' : 'The Excel RANDARRAY function generates an array of random numbers between two values. The size or the array is is specified by rows and columns arguments. The generated values can be either decimals or whole numbers.', 'Purpose' : 'Get array of random numbers', 'Return value' : 'Array of random values', 'Arguments' : 'rows - [optional] Row count. Default = 1.columns - [optional] Column count. Default = 1.min - [optional] Minimum value. Default = 0.max - [optional] Maximum value. Default = 1.integer - [optional] Whole numbers. Boolean, TRUE or FALSE. Default = FALSE.', 'Syntax' : '=RANDARRAY([rows], [columns], [min], [max], [integer])' },
    'REDUCE' : { 'Summary' : 'The Excel REDUCE function applies a custom LAMBDA function to each element in a given array and accumulates results to a single value.', 'Purpose' : 'Reduce an array', 'Return value' : 'A single value', 'Arguments' : 'initial_value - [optional] The initial value of the accumulator.array - The array to be reduced.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=REDUCE([initial_value], array, lambda)' },
    'SCAN' : { 'Summary' : 'The SCAN function applies a custom LAMBDA function to each element in a given array and returns an array that contains the intermediate values created during the scan. SCAN can be used to generate running totals and other calculations that show intermediate results. ', 'Purpose' : 'Scan array and return intermediate results', 'Return value' : 'An array of results', 'Arguments' : 'initial_value - [optional] The initial value of the accumulator.array - The array to be scanned.lambda - The custom LAMBDA function to apply.', 'Syntax' : '=SCAN([initial_value], array, lambda)' },
    'SEQUENCE' : { 'Summary' : 'The Excel SEQUENCE function generates a list of sequential numbers in an array. The array can be one dimensional, or two-dimensional, determined by rows and columns arguments. ', 'Purpose' : 'Get array of list of sequential numbers', 'Return value' : 'Array of sequential values', 'Arguments' : 'rows - Number of rows to return.columns - [optional] Number of columns to return.start - [optional] Starting value (defaults to 1).step - [optional] Increment between each value (defaults to 1).', 'Syntax' : '=SEQUENCE(rows, [columns], [start], [step])' },
    'SORT' : { 'Summary' : 'The Excel SORT function sorts the contents of a range or array in ascending or descending order. Values can be sorted by one or more columns. SORT returns a dynamic array of results.', 'Purpose' : 'Sorts range or array', 'Return value' : 'Sorted array', 'Arguments' : 'array - Range or array to sort.sort_index - [optional] Column index to use for sorting. Default is 1.sort_order - [optional] 1 = Ascending, -1 = Descending. Default is ascending order.by_col - [optional] TRUE = sort by column. FALSE = sort by row. Default is FALSE.', 'Syntax' : '=SORT(array, [sort_index], [sort_order], [by_col])' },
    'SORTBY' : { 'Summary' : 'The Excel SORTBY function sorts the contents of a range or array based on the values from another range or array. The range or array used to sort does not need to appear in results.', 'Purpose' : 'Sorts range or array by column', 'Return value' : 'Sorted array', 'Arguments' : 'array - Range or array to sort.by_array - Range or array to sort by.sort_order - [optional] Sort order. 1 = ascending (default), -1 = descending.array/order - [optional] Additional array and sort order pairs.', 'Syntax' : '=SORTBY(array, by_array, [sort_order], [array/order], ...)' },
    'STOCKHISTORY' : { 'Summary' : 'The Excel STOCKHISTORY function retrieves historical stock price information based on a given symbol and date range. The primary purpose of STOCKHISTORY is to get the history of a financial instrument over time. The result is an array of values that spill onto the worksheet into multiple cells.', 'Purpose' : 'Retrieve stock price information', 'Return value' : 'Array of stock price information', 'Arguments' : 'stock - A ticker symbol in double quotes ("MSFT", "AAPL", "GOOG", etc.).start_date - The start date for data to be retrieved.end_date - [optional] The end date for data to be retrieved. Default is start_date.interval - [optional] Time interval. Daily = 0, weekly = 1, monthly = 2. Default is 0.headers - [optional] No header = 0, basic header = 1, instrument + header = 2. Default is 1.properties - [optional] Additional data to retrieve. Default is Date and Close. See below.', 'Syntax' : '=STOCKHISTORY(stock, start_date, [end_date], [interval], [headers], [properties], ...)' },
    'TAKE' : { 'Summary' : 'The Excel TAKE function returns a subset of a given array. The number of rows and columns to return is provided by separate rows and columns arguments. Rows and columns can be extracted from the start or end of the given array.', 'Purpose' : 'Get a subset of an array', 'Return value' : 'A subset of a given array', 'Arguments' : 'array - The source array or range.rows - [optional] Number of rows to return as an integer.col - [optional] Number of columns to return as an integer.', 'Syntax' : '=TAKE(array, [rows], [col])' },
    'TEXTAFTER' : { 'Summary' : 'The Excel TEXTAFTER function returns the text that occurs after a given substring or delimiter. In cases where multiple delimiters appear in the text, TEXTAFTER can return text after the nth occurrence of a delimiter.', 'Purpose' : 'Extract text after delimiter', 'Return value' : 'Extracted text', 'Arguments' : 'text - The text string to extract from.delimiter - The character(s) that delimit the text.instance_num - [optional] The instance of the delimiter in text. Default is 1.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.match_end - [optional] Treat end of text as delimiter. 0 = disabled, 1 = enabled. Default is 0.if_not_found - [optional] Value to return when no match is found. #N/A is default.', 'Syntax' : '=TEXTAFTER(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found])' },
    'TEXTBEFORE' : { 'Summary' : 'The Excel TEXTBEFORE function returns the text that occurs before a given substring or delimiter. In cases where multiple delimiters appear in the text, TEXTBEFORE can return text before the nth occurrence of the delimiter.', 'Purpose' : 'Extract text before delimiter', 'Return value' : 'Extracted text', 'Arguments' : 'text - The text string to extract from.delimiter - The character(s) that delimit the text.instance_num - [optional] The instance of the delimiter in text. Default is 1.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.match_end - [optional] Treat end of text as delimiter. 0 = disabled, 1 = enabled. Default is 0.if_not_found - [optional] Value to return when no match is found. #N/A is default.', 'Syntax' : '=TEXTBEFORE(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found])' },
    'TEXTSPLIT' : { 'Summary' : 'The Excel TEXTSPLIT function splits text by a given delimiter to an array that spills into multiple cells. TEXTSPLIT can split text into rows or columns.', 'Purpose' : 'Split a text string with a delimiter', 'Return value' : 'Text in multiple cells ', 'Arguments' : 'text - The text string to split.col_delimiter - The character(s) to delimit columns.row_delimiter - [optional] The character(s) to delimit rows.ignore_empty - [optional] Ignore empty values. TRUE = ignore, FALSE = preserve. Default is FALSE.match_mode - [optional] Case-sensitivity. 0 = enabled, 1 = disabled. Default is 0.pad_with - [optional] Value to pad missing values in 2d arrays.', 'Syntax' : '=TEXTSPLIT(text, col_delimiter, [row_delimiter], [ignore_empty], [match_mode], [pad_with])' },
    'TOCOL' : { 'Summary' : 'The Excel TOCOL function transforms an array into a single column. By default, TOCOL will scan values by row, but TOCOL can also scan values by column.', 'Purpose' : 'Transform array to single column', 'Return value' : 'A single column of values', 'Arguments' : 'array - The array to transform.ignore - Setting to ignore blanks and errors.scan_by_column - Scan array by column. TRUE=column, FALSE=row (default=TRUE).', 'Syntax' : '=TOCOL(array, ignore, scan_by_column)' },
    'TOROW' : { 'Summary' : 'The Excel TOROW function transforms an array into a single row. By default, TOROW will scan values by row, but TOROW can also scan values by column.', 'Purpose' : 'Transform array to single row', 'Return value' : 'A single row of values', 'Arguments' : 'array - The array to transform.ignore - Control to ignore blanks and errors.scan_by_column - Scan array by column. TRUE = column, FALSE = row (default = TRUE).', 'Syntax' : '=TOROW(array, ignore, scan_by_column)' },
    'UNIQUE' : { 'Summary' : 'The Excel UNIQUE function returns a list of unique values in a list or range. Values can be text, numbers, dates, times, etc.', 'Purpose' : 'Extract unique values from range', 'Return value' : 'Array of unique values', 'Arguments' : 'array - Range or array from which to extract unique values.by_col - [optional] How to compare and extract. By row = FALSE (default); by column = TRUE.exactly_once - [optional] TRUE = values that occur once, FALSE= all unique values (default).', 'Syntax' : '=UNIQUE(array, [by_col], [exactly_once])' },
    'VALUETOTEXT' : { 'Summary' : 'The Excel VALUETOTEXT function converts a value to text. By default, text values pass though unaffected. However, in strict mode, text values are enclosed in double quotes (""). Numeric values are converted to text in all cases and number formatting is lost.', 'Purpose' : 'Converts a value to a text string', 'Return value' : 'Value as a text string', 'Arguments' : 'value - The value to convert to text.format - [optional] Output format. 0 = concise (default), and 1 = strict.', 'Syntax' : '=VALUETOTEXT(value, [format])' },
    'VSTACK' : { 'Summary' : 'The Excel VSTACK function combines arrays vertically into a single array. Each subsequent array is appended to the bottom of the previous array.', 'Purpose' : 'Combine ranges or arrays vertically', 'Return value' : 'A single combined range or array', 'Arguments' : 'array1 - The first array or range to combine.array2 - [optional] The second array or range to combine.', 'Syntax' : '=VSTACK(array1, [array2], ...)' },
    'WRAPCOLS' : { 'Summary' : 'The Excel WRAPCOLS function converts a one-dimensional array into a two-dimensional array by wrapping values into separate columns. The length of each column is given as the wrap_count argument: when the count is reached, WRAPCOLS starts a new column.', 'Purpose' : 'Wrap array into columns', 'Return value' : 'Array wrapped by column', 'Arguments' : 'vector - The array or range to wrap.wrap_count - Max values in each column.pad_with - [optional] Value to use for unfilled places.', 'Syntax' : '=WRAPCOLS(vector, wrap_count, [pad_with])' },
    'WRAPROWS' : { 'Summary' : 'The Excel WRAPROWS function converts a one-dimensional array into a two-dimensional array by wrapping values into separate rows. The length of each row is given as the wrap_count argument: when the count is reached, WRAPROWS starts a new row.', 'Purpose' : 'Wrap array into rows', 'Return value' : 'Array wrapped by row', 'Arguments' : 'vector - The array or range to wrap.wrap_count - Max values in each row.pad_with - [optional] Value to use for unfilled places.', 'Syntax' : '=WRAPROWS(vector, wrap_count, [pad_with])' },
    'XLOOKUP' : { 'Summary' : 'The Excel XLOOKUP function is a modern and flexible replacement for older functions like VLOOKUP, HLOOKUP, and LOOKUP. XLOOKUP supports approximate and exact matching, wildcards (* ?) for partial matches, and lookups in vertical or horizontal ranges.', 'Purpose' : 'Lookup values in range or array', 'Return value' : 'Matching value(s) from return array', 'Arguments' : 'lookup - The lookup value.lookup_array - The array or range to search.return_array - The array or range to return.not_found - [optional] Value to return if no match found.match_mode - [optional] 0 = exact match (default), -1 = exact match or next smallest, 1 = exact match or next larger, 2 = wildcard match.search_mode - [optional] 1 = search from first (default), -1 = search from last, 2 = binary search ascending, -2 = binary search descending.', 'Syntax' : '=XLOOKUP(lookup, lookup_array, return_array, [not_found], [match_mode], [search_mode])' },
    'XMATCH' : { 'Summary' : 'The Excel XMATCH function performs a lookup and returns a position in vertical or horizontal ranges. It is a more robust and flexible successor to the MATCH function. XMATCH supports approximate and exact matching, reverse search, and wildcards (* ?) for partial matches. ', 'Purpose' : 'Get the position of an item in a list or table', 'Return value' : 'Numeric position in lookup array', 'Arguments' : 'lookup_value - The lookup value.lookup_array - The array or range to search.match_mode - [optional] 0 = exact match (default), -1 = exact match or next smallest, 1 = exact match or next larger, 2 = wildcard match.search_mode - [optional] 1 = search from first (default), -1 = search from last, 2 = binary search ascending, -2 = binary search descending.', 'Syntax' : '=XMATCH(lookup_value, lookup_array, [match_mode], [search_mode])' },
    'BIN2DEC' : { 'Summary' : 'The Excel BIN2DEC function converts a binary number to the decimal equivalent. The input number must contain only zeros and ones and be less than 10 characters long, otherwise the function returns the #NUM! error value.', 'Purpose' : 'Converts a binary number to decimal', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The binary number you want to convert to decimal.', 'Syntax' : '=BIN2DEC(number)' },
    'BIN2HEX' : { 'Summary' : 'The Excel BIN2HEX function converts a binary number to its hexadecimal equivalent.', 'Purpose' : 'Converts a binary number to hexadecimal', 'Return value' : 'Hexadecimal number', 'Arguments' : 'number - The binary number you want to convert to hexadecimal.places - [optional] If omitted uses the least number of characters required to represent the number, otherwise pads the result with zeros up to the specified number of places.', 'Syntax' : '=BIN2HEX(number, [places])' },
    'BIN2OCT' : { 'Summary' : 'The Excel BIN2OCT function converts a binary number to its octal equivalent.', 'Purpose' : 'Converts a binary number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The binary number you want to convert to octal.places - [optional] If omitted uses the least number of characters required to represent the number, otherwise pads the result with zeros up to the specified number of places.', 'Syntax' : '=BIN2OCT(number, [places])' },
    'BITAND' : { 'Summary' : 'The Excel BITAND function returns a decimal number representing the bitwise AND of two numbers.', 'Purpose' : 'Returns a \'Bitwise And\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITAND(number1, number2)' },
    'BITLSHIFT' : { 'Summary' : 'The Excel BITLSHIFT function shifts a number by the specified number of bits, effectively doubling or halving the number a specified number of times.', 'Purpose' : 'Returns a number shifted left by some number of bits', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The number to be bit shifted.shift_amount - The amount of bits to shift, if negative shifts bits to the right instead.', 'Syntax' : '=BITLSHIFT(number, shift_amount)' },
    'BITOR' : { 'Summary' : 'The Excel BITOR function returns a decimal number representing the bitwise OR of two numbers. For each corresponding bit in the binary representation of the numbers a logical OR operation is performed, and the resulting number returned.', 'Purpose' : 'Returns a \'Bitwise Or\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITOR(number1, number2)' },
    'BITRSHIFT' : { 'Summary' : 'The Excel BITRSHIFT function shifts a number by the specified number of bits, effectively halving or doubling the number a specified number of times.', 'Purpose' : 'Returns a number shifted right by some number of bits', 'Return value' : 'Decimal Number', 'Arguments' : 'number - The number to be bit shifted.shift_amount - The amount of bits to shift to the right, if negative shifts bits to the left instead.', 'Syntax' : '=BITRSHIFT(number, shift_amount)' },
    'BITXOR' : { 'Summary' : 'The Excel BITXOR function returns a decimal number representing the bitwise XOR of two numbers. For each corresponding bit in the binary representation of the numbers a logical XOR operation is performed and the resulting number returned.', 'Purpose' : 'Returns a \'Bitwise Xor\' of two numbers', 'Return value' : 'Decimal Number', 'Arguments' : 'number1 - A positive decimal number.number2 - A positive decimal number.', 'Syntax' : '=BITXOR(number1, number2)' },
    'COMPLEX' : { 'Summary' : 'The Excel COMPLEX function creates a complex number with given real and imaginary coefficients. COMPLEX returns a text result in the form x + yi or x + yj.', 'Purpose' : 'Convert coefficients to complex number', 'Return value' : 'Complex number as text', 'Arguments' : 'real_num - The real number.i_num - The imaginary number.suffix - [optional] The suffix, either "i" or "j".', 'Syntax' : '=COMPLEX(real_num, i_num, [suffix])' },
    'CONVERT' : { 'Summary' : 'The Excel CONVERT function converts a number in one measurement system to another. For example, you can use CONVERT to convert feet into meters, pounds into kilograms, Fahrenheit to Celsius, gallons into liters, and for many other unit conversions.', 'Purpose' : 'Convert measurement units', 'Return value' : 'A number in the new measurement system', 'Arguments' : 'number - The numeric value to convert.from_unit - The starting units for number.to_unit - The ending units for the result.', 'Syntax' : '=CONVERT(number, from_unit, to_unit)' },
    'DEC2BIN' : { 'Summary' : 'The Excel DEC2BIN function converts a decimal number to its binary equivalent.', 'Purpose' : 'Converts a decimal number to binary', 'Return value' : 'Binary number', 'Arguments' : 'number - The decimal number you want to convert to binary.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2BIN(number, [places])' },
    'DEC2HEX' : { 'Summary' : 'The Excel DEC2HEX function converts a decimal number to its hexadecimal equivalent.', 'Purpose' : 'Converts a decimal number to hexadecimal', 'Return value' : 'Hexadecimal number', 'Arguments' : 'number - The decimal number you want to convert to hexadecimal.places - [optional] Pads the resulting number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2HEX(number, [places])' },
    'DEC2OCT' : { 'Summary' : 'The Excel DEC2OCT function converts a decimal number to its octal equivalent.', 'Purpose' : 'Converts a decimal number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The decimal number you want to convert to octal.places - [optional] Pads the resulting octal number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=DEC2OCT(number, [places])' },
    'DELTA' : { 'Summary' : 'The Excel DELTA function will test if two numeric values are equal. When values are equal, DELTA returns 1, otherwise, DELTA returns zero.', 'Purpose' : 'Test two values are equal', 'Return value' : 'The number one or zero', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=DELTA(number1, [number2])' },
    'HEX2BIN' : { 'Summary' : 'The Excel HEX2BIN function converts a hexadecimal number to its binary equivalent.', 'Purpose' : 'Converts a hexadecimal number to binary', 'Return value' : 'Binary number', 'Arguments' : 'number - The hexadecimal number you want to convert to binary.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=HEX2BIN(number, [places])' },
    'HEX2DEC' : { 'Summary' : 'The Excel HEX2DEC function converts a hexadecimal number to its decimal equivalent.', 'Purpose' : 'Converts a hexadecimal number to decimal', 'Return value' : 'Decimal number', 'Arguments' : 'number - The hexadecimal number you want to convert to decimal.', 'Syntax' : '=HEX2DEC(number)' },
    'HEX2OCT' : { 'Summary' : 'The Excel HEX2OCT function converts a hexadecimal number to its octal equivalent.', 'Purpose' : 'Converts a hexadecimal number to octal', 'Return value' : 'Octal number', 'Arguments' : 'number - The hexadecimal number you want to convert to octal.places - [optional] Pads the resulting binary number with zeros up to the specified number of digits. If omitted returns the least number of characters required to represent the number.', 'Syntax' : '=HEX2OCT(number, [places])' },
    'IMABS' : { 'Summary' : 'The Excel IMABS function returns the absolute value of a complex number in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get absolute value of complex number', 'Return value' : 'Absolute value as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMABS(inumber)' },
    'IMAGINARY' : { 'Summary' : 'The Excel IMAGINARY function returns the imaginary coefficient of a complex number given in the form x + yi or x + yj.', 'Purpose' : 'Get imaginary coefficient of complex number', 'Return value' : 'Imaginary coefficient as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMAGINARY(inumber)' },
    'IMPOWER' : { 'Summary' : 'The Excel IMPOWER function returns a complex number raised to a given power. The complex number must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Raise complex number to given power', 'Return value' : 'Complex number as text', 'Arguments' : 'inumber - A complex number.number - Power to raise number.', 'Syntax' : '=IMPOWER(inumber, number)' },
    'IMPRODUCT' : { 'Summary' : 'The Excel IMPRODUCT function returns the product of one or more complex numbers. The complex number must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get product of complex numbers', 'Return value' : 'Product as complex number', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - [optional] Complex number 2.', 'Syntax' : '=IMPRODUCT(inumber1, [inumber2], ...)' },
    'IMREAL' : { 'Summary' : 'The Excel IMREAL function returns the real coefficient of a complex number in the form x + yi or x + yj. ', 'Purpose' : 'Get real coefficient of complex number', 'Return value' : 'Real coefficient as number', 'Arguments' : 'inumber - A complex number.', 'Syntax' : '=IMREAL(inumber)' },
    'IMSUB' : { 'Summary' : 'The Excel IMSUB function returns the difference between two complex numbers. Complex numbers must be in the form x + yi or x + yj. Use the COMPLEX function to create complex numbers', 'Purpose' : 'Get difference between two complex numbers', 'Return value' : 'Difference between complex numbers as text', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - Complex number 2.', 'Syntax' : '=IMSUB(inumber1, inumber2)' },
    'IMSUM' : { 'Summary' : 'The Excel IMSUM function returns the sum of two or more complex numbers. The complex numbers must be in the form x + yi or x + yj. Use the COMPLEX function to create a complex number from real and imaginary parts.', 'Purpose' : 'Get sum of complex numbers', 'Return value' : 'Sum of complex numbers as text', 'Arguments' : 'inumber1 - Complex number 1.inumber2 - [optional] Complex number 2.', 'Syntax' : '=IMSUM(inumber1, [inumber2], ...)' },
    'ACCRINT' : { 'Summary' : 'The Excel ACCRINT function returns the accrued interest for a security that pays periodic interest', 'Purpose' : 'Get accrued interest periodic', 'Return value' : 'Accrued interest', 'Arguments' : 'id - Issue date of the security.fd - First interest date of security.sd - Settlement date of security.rate - Interest rate of security.par - Par value of security.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).calc - [optional] Calculation method (see below, default = TRUE).', 'Syntax' : '=ACCRINT(id, fd, sd, rate, par, freq, [basis], [calc])' },
    'ACCRINTM' : { 'Summary' : 'The Excel ACCRINTM function returns the accrued interest for a security that pays interest at maturity (i.e. pays interest one time only).', 'Purpose' : 'Get accrued interest at maturity', 'Return value' : 'Accrued interest', 'Arguments' : 'id - Issue date of the security.sd - Settlement date of the security.rate - Annual coupon rate.par - Par value of security.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ACCRINTM(id, sd, rate, par, [basis])' },
    'AMORDEGRC' : { 'Summary' : 'The Excel AMORDEGRC function returns the depreciation for a given accounting using a depreciation coefficient determined by asset life.', 'Purpose' : 'Depreciation for accounting period coefficient', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Asset cost.purchase - Asset purchase date.first - First period end date.salvage - Asset salvage value.period - Period for which to calculate depreciation.rate - Rate of depreciation.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=AMORDEGRC(cost, purchase, first, salvage, period, rate, [basis])' },
    'AMORLINC' : { 'Summary' : 'The Excel AMORLINC function returns the depreciation for each accounting period', 'Purpose' : 'Depreciation for accounting period', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Asset cost.purchase - Asset purchase date.first - End date of first period.salvage - Asset salvage value.period - The period for which to calculate depreciation.rate - Rate of depreciation.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=AMORLINC(cost, purchase, first, salvage, period, rate, [basis])' },
    'COUPDAYBS' : { 'Summary' : 'The Excel COUPDAYBS function returns the number of days from the beginning of the coupon period to the settlement date.', 'Purpose' : 'Get days from coupon period to settlement date', 'Return value' : 'Days as a number', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYBS(settlement, maturity, frequency, [basis])' },
    'COUPDAYS' : { 'Summary' : 'The Excel COUPDAYS function returns the number of days in a coupon period that includes the settlement date.', 'Purpose' : 'Get days in coupon period incl settlement date', 'Return value' : 'Calculated days', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYS(settlement, maturity, frequency, [basis])' },
    'COUPDAYSNC' : { 'Summary' : 'The Excel COUPDAYSNC function returns the number of days from the settlement date to the next coupon date.', 'Purpose' : 'Get days from settlement date to next coupon date', 'Return value' : 'Days to next coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPDAYSNC(settlement, maturity, frequency, [basis])' },
    'COUPNCD' : { 'Summary' : 'The Excel COUPNCD function returns the next coupon date after the settlement date.', 'Purpose' : 'Get next coupon date after settlement date', 'Return value' : 'Next coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPNCD(settlement, maturity, frequency, [basis])' },
    'COUPNUM' : { 'Summary' : 'The Excel COUPNUM function returns the number of coupons, or interest payments, payable between the settlement date and maturity date.', 'Purpose' : 'Get number of coupons payable', 'Return value' : 'Number of coupons payable', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPNUM(settlement, maturity, frequency, [basis])' },
    'COUPPCD' : { 'Summary' : 'The Excel COUPPCD function returns the previous coupon date before the settlement date for a coupon bond.', 'Purpose' : 'Get previous coupon date before settlement date', 'Return value' : 'Previous coupon date', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.frequency - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=COUPPCD(settlement, maturity, frequency, [basis])' },
    'CUMIPMT' : { 'Summary' : 'The Excel CUMIPMT function is a financial function that returns the cumulative interest paid on a loan between a start period and an end period. You can use CUMIPMT to calculate and verify the total interest paid on a loan, or the interest paid between any two payment periods.', 'Purpose' : 'Get cumulative interest paid on a loan', 'Return value' : 'The interest amount', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.start_period - First payment in calculation.end_period - Last payment in calculation.type - When payments are due. 0 = end of period. 1 = beginning of period.', 'Syntax' : '=CUMIPMT(rate, nper, pv, start_period, end_period, type)' },
    'CUMPRINC' : { 'Summary' : 'The Excel CUMPRINC function is a financial function that returns the cumulative principal paid on a loan between a start period and an end period. You can use CUMPRINC to calculate and verify the total principal paid on a loan, or the principal paid between any two payment periods.', 'Purpose' : 'Get cumulative principal paid on a loan', 'Return value' : 'The principal amount', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.start_period - First payment in calculation.end_period - Last payment in calculation.type - When payments are due. 0 = end of period. 1 = beginning of period.', 'Syntax' : '=CUMPRINC(rate, nper, pv, start_period, end_period, type)' },
    'DB' : { 'Summary' : 'The Excel DB function returns the depreciation of an asset for a specified period using the fixed-declining balance method. The calculation is based on initial asset cost, salvage value, the number of periods over which the asset is depreciated and, optionally, the number of months in the first year.', 'Purpose' : 'Depreciation - fixed-declining balance', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.month - [optional] Number of months in the first year. Defaults to 12.', 'Syntax' : '=DB(cost, salvage, life, period, [month])' },
    'DDB' : { 'Summary' : 'The Excel DDB function returns the depreciation of an asset for a given period using the double-declining balance method or another method you specify by changing the factor argument.', 'Purpose' : 'Depreciation - double-declining', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.factor - [optional] Rate at which the balance declines. If omitted, defaults to 2.', 'Syntax' : '=DDB(cost, salvage, life, period, [factor])' },
    'DISC' : { 'Summary' : 'The Excel DISC function returns the discount rate for a security.', 'Purpose' : 'Get discount rate for a security', 'Return value' : 'Discount rate as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.pr - Security price per $100 face value.redemption - Security redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=DISC(settlement, maturity, pr, redemption, [basis])' },
    'DOLLARDE' : { 'Summary' : 'The Excel DOLLARDE function converts a dollar price entered with a special notation to a dollar price displayed as a decimal number. The DOLLARFR function does the opposite conversion.', 'Purpose' : 'Convert dollar price as fraction to decimal', 'Return value' : 'Equivalent decimal number', 'Arguments' : 'fractional_dollar - Dollar component in special fractional notation.fraction - The denominator in the fractional unit. 8 = 1/8, 16 = 1/16, 32 = 1/32, etc.', 'Syntax' : '=DOLLARDE(fractional_dollar, fraction)' },
    'DOLLARFR' : { 'Summary' : 'The Excel DOLLARFR function converts a dollar price in a regular decimal number format to a dollar price in a particular fractional notation used for securities where pricing is given to the nearest 1/8, 1/16, 1/32, etc. The DOLLARDE function does the opposite conversion.', 'Purpose' : 'Convert price to fractional notation', 'Return value' : 'Dollar value in fractional notation', 'Arguments' : 'decimal_dollar - Pricing as a normal decimal number.fraction - The denominator in the fractional unit. 8 = 1/8, 16 = 1/16, 32 = 1/32, etc.', 'Syntax' : '=DOLLARFR(decimal_dollar, fraction)' },
    'DURATION' : { 'Summary' : 'The Excel DURATION function returns the annual duration of a security with periodic interest payments, calculated with the Macauley duration formula.', 'Purpose' : 'Get annual duration with periodic interest', 'Return value' : 'Duration in years', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.coupon - The security\'s annual coupon rate.yld - The security\'s annual yield.freq - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=DURATION(settlement, maturity, coupon, yld, freq, [basis])' },
    'EFFECT' : { 'Summary' : 'The Excel EFFECT function returns the effective annual interest rate, given a nominal interest rate and the number of compounding periods per year. Effective annual interest rate is the interest rate actually earned due to compounding. ', 'Purpose' : 'Get effective annual interest rate', 'Return value' : 'Effective annual interest rate', 'Arguments' : 'nominal_rate - The nominal or stated interest rate.npery - Number of compounding periods per year.', 'Syntax' : '=EFFECT(nominal_rate, npery)' },
    'FV' : { 'Summary' : 'The Excel FV function is a financial function that returns the future value of an investment. You can use the FV function to get the future value of an investment assuming periodic, constant payments with a constant interest rate.', 'Purpose' : 'Get the future value of an investment', 'Return value' : 'future value', 'Arguments' : 'rate - The interest rate per period.nper - The total number of payment periods.pmt - The payment made each period. Must be entered as a negative number.pv - [optional] The present value of future payments. If omitted, assumed to be zero. Must be entered as a negative number.type - [optional] When payments are due. 0 = end of period, 1 = beginning of period. Default is 0.', 'Syntax' : '=FV(rate, nper, pmt, [pv], [type])' },
    'FVSCHEDULE' : { 'Summary' : 'The Excel FVSCHEDULE function returns the future value of a single sum based on a schedule of given interest rates. FVSCHEDULE can be used to find the future value of an investment with a variable or adjustable rate.', 'Purpose' : 'Get future value of principal compound interest', 'Return value' : 'Future value', 'Arguments' : 'principal - The initial investment sum.schedule - Schedule of interest rates, provided as range or array.', 'Syntax' : '=FVSCHEDULE(principal, schedule)' },
    'INTRATE' : { 'Summary' : 'The Excel INTRATE function returns the interest rate for a fully invested security.', 'Purpose' : 'Get interest rate for fully invested security', 'Return value' : 'Interest rate as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.investment - The amount originally invested.redemption - The amount received at maturity.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=INTRATE(settlement, maturity, investment, redemption, [basis])' },
    'IPMT' : { 'Summary' : 'The Excel IPMT function can be used to calculate the interest portion of a given loan payment in a given payment period. For example, you can use IPMT to get the interest amount of a payment for the first period, the last period, or any period in between.', 'Purpose' : 'Get interest in given period', 'Return value' : 'The interest amount', 'Arguments' : 'rate - The interest rate per period.per - The payment period of interest.nper - The total number of payment periods.pv - The present value, or total value of all payments now.fv - [optional] The cash balance desired after last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=IPMT(rate, per, nper, pv, [fv], [type])' },
    'IRR' : { 'Summary' : 'The Excel IRR function is a financial function that returns the internal rate of return (IRR) for a series of cash flows that occur at regular intervals.', 'Purpose' : 'Calculate internal rate of return', 'Return value' : 'Calculated return as percentage', 'Arguments' : 'values - Array or reference to cells that contain values.guess - [optional] An estimate for expected IRR. Default is .1 (10%).', 'Syntax' : '=IRR(values, [guess])' },
    'ISPMT' : { 'Summary' : 'The Excel ISPMT function calculates the interest paid during a given period of an investment where principal payments are equal. The given period is specified as a zero-based number instead of a 1-based number.', 'Purpose' : 'Get interest paid for specific period', 'Return value' : 'Interest amount in given period', 'Arguments' : 'rate - Interest rate.per - Period (starts with zero, not 1).nper - Number of periods.pv - Present value.', 'Syntax' : '=ISPMT(rate, per, nper, pv)' },
    'MDURATION' : { 'Summary' : 'The Excel MDURATION function returns the Macauley modified duration for a security with an assumed par value of $100', 'Purpose' : 'Get Macauley modified duration par value of $100', 'Return value' : 'Modified duration in years', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.coupon - The security\'s annual coupon rate.yld - The security\'s annual yield.freq - Number of coupon payments per year (annual = 1, semi-annual = 2, quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=MDURATION(settlement, maturity, coupon, yld, freq, [basis])' },
    'MIRR' : { 'Summary' : 'The Excel MIRR function is a financial function that returns the modified internal rate of return (MIRR) for a series of cash flows, taking into account both discount rate and reinvestment rate for future cash flows.', 'Purpose' : 'Calculate modified internal rate of return', 'Return value' : 'Calculated return as percentage', 'Arguments' : 'values - Array or reference to cells that contain cash flows.finance_rate - Required rate of return (discount rate) as percentage.reinvest_rate - Interest rate received on cash flows reinvested as percentage.', 'Syntax' : '=MIRR(values, finance_rate, reinvest_rate)' },
    'NOMINAL' : { 'Summary' : 'The Excel NOMINAL function returns the nominal interest rate when given an effective annual interest rate and the number of compounding periods per year. The effective rate is the actual rate due to compounding. The nominal rate is typically the stated rate.', 'Purpose' : 'Get annual nominal interest rate', 'Return value' : 'Nominal interest rate', 'Arguments' : 'effect_rate - The effective annual interest rate.npery - Number of compounding periods per year.', 'Syntax' : '=NOMINAL(effect_rate, npery)' },
    'NPER' : { 'Summary' : 'The Excel NPER function is a financial function that returns the number of periods for a loan or investment. You can use the NPER function to get the number of payment periods for a loan, given the amount, the interest rate, and periodic payment amount.', 'Purpose' : 'Get number of periods for loan or investment', 'Return value' : 'The number of periods', 'Arguments' : 'rate - The interest rate per period.pmt - The payment made each period.pv - The present value, or total value of all payments now.fv - [optional] The future value, or a cash balance you want after the last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=NPER(rate, pmt, pv, [fv], [type])' },
    'NPV' : { 'Summary' : 'The Excel NPV function is a financial function that calculates the net present value (NPV) of an investment using a discount rate and a series of future cash flows.', 'Purpose' : 'Calculate net present value', 'Return value' : 'Net present value', 'Arguments' : 'rate - Discount rate over one period.value1 - First value(s) representing cash flows.value2 - [optional] Second value(s) representing cash flows.', 'Syntax' : '=NPV(rate, value1, [value2], ...)' },
    'ODDFPRICE' : { 'Summary' : 'The Excel ODDFPRICE function returns the price per $100 face value of a security with an odd (irregular) first period.', 'Purpose' : 'Get price per $100 odd first period', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.fd - First coupon date.rate - Annual coupon rate of security.yld - Annual required rate of return.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDFPRICE(sd, md, id, fd, rate, yld, redem, freq, [basis])' },
    'ODDFYIELD' : { 'Summary' : 'The Excel ODDFYIELD function returns the yield of a security with an odd (irregular) first period.', 'Purpose' : 'Get yield security with odd first period', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.fd - First coupon date.rate - Annual coupon rate of security.pr - Price of security.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDFYIELD(sd, md, id, fd, rate, pr, redem, freq, [basis])' },
    'ODDLPRICE' : { 'Summary' : 'The Excel ODDLPRICE function returns the price per $100 face value of a security with an odd (irregular) last period.', 'Purpose' : 'Get price per $100 face value with odd last period', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Last interest date of security.rate - Interest rate of security.yld - Annual required rate of return.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDLPRICE(sd, md, id, rate, yld, redem, freq, [basis])' },
    'ODDLYIELD' : { 'Summary' : 'The Excel ODDLYIELD function returns the yield of a security with an odd (irregular) last period.', 'Purpose' : 'Get yield of security with odd last period', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.ld - Last interest date of security.rate - Interest rate of security.pr - Price per $100 face value.redem - Redemption value per $100 face value.freq - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=ODDLYIELD(sd, md, ld, rate, pr, redem, freq, [basis])' },
    'PDURATION' : { 'Summary' : 'The Excel PDURATION function returns the number of periods required for an investment to reach a desired value.', 'Purpose' : 'Get periods required to reach given value', 'Return value' : 'Required time in periods', 'Arguments' : 'rate - Interest rate per period.pv - Present value of the investment.fv - Future value of the investment.', 'Syntax' : '=PDURATION(rate, pv, fv)' },
    'PMT' : { 'Summary' : 'The Excel PMT function is a financial function that returns the periodic payment for a loan. You can use the PMT function to figure out payments for a loan, given the loan amount, number of periods, and interest rate.', 'Purpose' : 'Get the periodic payment for a loan', 'Return value' : 'loan payment as a number', 'Arguments' : 'rate - The interest rate for the loan.nper - The total number of payments for the loan.pv - The present value, or total value of all loan payments now.fv - [optional] The future value, or a cash balance you want after the last payment is made. Defaults to 0 (zero).type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=PMT(rate, nper, pv, [fv], [type])' },
    'PPMT' : { 'Summary' : 'The Excel PPMT function can be used to calculate the principal portion of a given loan payment. For example, you can use PPMT to get the principal amount of a payment for the first period, the last period, or any period in between.', 'Purpose' : 'Get principal payment in given period', 'Return value' : 'The principal payment', 'Arguments' : 'rate - The interest rate per period.per - The payment period of interest.nper - The total number of payments for the loan.pv - The present value, or total value of all payments now.fv - [optional] The cash balance desired after last payment is made. Defaults to 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.', 'Syntax' : '=PPMT(rate, per, nper, pv, [fv], [type])' },
    'PRICE' : { 'Summary' : 'The Excel PRICE function returns the price per $100 face value of a security that pays periodic interest.', 'Purpose' : 'Get price per $100 face value - periodic interest', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.rate - Annual coupon rate.yld - Annual required rate of return.redemption - Redemption value per $100 face value.frequency - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICE(sd, md, rate, yld, redemption, frequency, [basis])' },
    'PRICEDISC' : { 'Summary' : 'The Excel PRICEDISC function returns the price per $100 face value of a discounted security.', 'Purpose' : 'Get price per $100 discounted security', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.discount - Discount rate of the security.redemption - Redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICEDISC(sd, md, discount, redemption, [basis])' },
    'PRICEMAT' : { 'Summary' : 'The Excel PRICEMAT function returns the price per $100 face value of a security that pays interest at maturity.', 'Purpose' : 'Get price per $100 interest at maturity', 'Return value' : 'Bond price', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.rate - Security interest rate at date of issue.yld - Annual yield of the security.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=PRICEMAT(sd, md, id, rate, yld, [basis])' },
    'PV' : { 'Summary' : 'The Excel PV function is a financial function that returns the present value of an investment. You can use the PV function to get the value in today\'s dollars of a series of future payments, assuming periodic, constant payments and a constant interest rate.', 'Purpose' : 'Get the present value of an investment', 'Return value' : 'Present value', 'Arguments' : 'rate - The interest rate per period.nper - The number of payment periods.pmt - The payment made each period.fv - [optional] Future value. If omitted, defaults to zero.type - [optional] Payment type, 0 = end of period, 1 = beginning of period. Default is 0.', 'Syntax' : '=PV(rate, nper, pmt, [fv], [type])' },
    'RATE' : { 'Summary' : 'The Excel RATE function is a financial function that returns the interest rate per period of an annuity. You can use RATE to calculate the periodic interest rate, then multiply as required to derive the annual interest rate. The RATE function calculates by iteration.', 'Purpose' : 'Get the interest rate per period of an annuity', 'Return value' : 'The interest rate per period', 'Arguments' : 'nper - The total number of payment periods.pmt - The payment made each period.pv - The present value, or total value of all loan payments now.fv - [optional] The future value, or desired cash balance after last payment. Default is 0.type - [optional] When payments are due. 0 = end of period. 1 = beginning of period. Default is 0.guess - [optional] Your guess on the rate. Default is 10%.', 'Syntax' : '=RATE(nper, pmt, pv, [fv], [type], [guess])' },
    'RECEIVED' : { 'Summary' : 'The Excel RECEIVED function returns the amount received at maturity for a fully invested security.', 'Purpose' : 'Get amount received at maturity', 'Return value' : 'Amount received', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.investment - Amount investment in the security.discount - The security\'s discount rate.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=RECEIVED(settlement, maturity, investment, discount, [basis])' },
    'RRI' : { 'Summary' : 'The Excel RRI function returns an equivalent interest rate for the growth of an investment. You can use RRI to calculate Compound Annual Growth Rate (CAGR) in Excel.', 'Purpose' : 'Get equivalent interest rate for growth', 'Return value' : 'Calculated interest rate', 'Arguments' : 'nper - Number of periods.pv - Present value of investment.fv - Future value of investment.', 'Syntax' : '=RRI(nper, pv, fv)' },
    'SLN' : { 'Summary' : 'The Excel SLN function returns the depreciation of an asset for one period, calculated with a straight-line method. The calculated depreciation is based on initial asset cost, salvage value, and the number of periods over which the asset is depreciated.', 'Purpose' : 'Depreciation - straight-line', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.', 'Syntax' : '=SLN(cost, salvage, life)' },
    'SYD' : { 'Summary' : 'The Excel SYD function returns the "sum-of-years" depreciation for an asset in a given period. The calculated depreciation is based on initial asset cost, salvage value, and the number of periods over which the asset is depreciated.', 'Purpose' : 'Depreciation - sum-of-years', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.period - Period to calculation depreciation for.', 'Syntax' : '=SYD(cost, salvage, life, period)' },
    'TBILLEQ' : { 'Summary' : 'The Excel TBILLEQ function returns the bond-equivalent yield for a Treasury bill.', 'Purpose' : 'Get bond-equivalent yield for a Treasury bill', 'Return value' : 'Yield as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.discount - Discount rate of the security.', 'Syntax' : '=TBILLEQ(settlement, maturity, discount)' },
    'TBILLPRICE' : { 'Summary' : 'The Excel TBILLPRICE function returns the price per $100 face value for a Treasury bill.', 'Purpose' : 'Get price per $100 Treasury bill', 'Return value' : 'Price per $100', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.discount - The discount rate for the security.', 'Syntax' : '=TBILLPRICE(settlement, maturity, discount)' },
    'TBILLYIELD' : { 'Summary' : 'The Excel TBILLYIELD function returns the yield for a Treasury bill.', 'Purpose' : 'Get yield for a Treasury bill', 'Return value' : 'Yield as percentage', 'Arguments' : 'settlement - Settlement date of the security.maturity - Maturity date of the security.price - Price per $100.', 'Syntax' : '=TBILLYIELD(settlement, maturity, price)' },
    'VDB' : { 'Summary' : 'The Excel VDB function returns the depreciation of an asset for given period, using the double-declining balance method or another method specified by changing the factor argument. By default, the VDB function will switch to straight line calculation. VDB stands for variable declining balance.', 'Purpose' : 'Depreciation - double-declining variable', 'Return value' : 'Depreciation in given period', 'Arguments' : 'cost - Initial cost of asset.salvage - Asset value at the end of the depreciation.life - Periods over which asset is depreciated.start - Start period.end - End period.factor - [optional] Rate at which the balance declines. If omitted, defaults to 2.no_switch - [optional] Don\'t switch to straight line. Default is FALSE.', 'Syntax' : '=VDB(cost, salvage, life, start, end, [factor], [no_switch])' },
    'XIRR' : { 'Summary' : 'The Excel XIRR function is a financial function that returns the internal rate of return (IRR) for a series of cash flows that occur at irregular intervals. The XIRR function uses iteration to arrive at a result.', 'Purpose' : 'Calculate internal rate of return for irregular cash flows', 'Return value' : 'Calculated internal rate of return', 'Arguments' : 'values - Array or reference to cells that contain cash flows.dates - Dates that correspond to cash flows, in any order.guess - [optional] An estimate for expected IRR. Default is 0.1 (10%).', 'Syntax' : '=XIRR(values, dates, [guess])' },
    'XNPV' : { 'Summary' : 'The Excel XNPV function is a financial function that calculates the net present value (NPV) of an investment using a discount rate and a series of cash flows that occur at irregular intervals.', 'Purpose' : 'Calculate net present value for irregular cash flows', 'Return value' : 'Net present value', 'Arguments' : 'rate - Discount rate to apply to the cash flows.values - Values representing cash flows.dates - Dates that correspond to cash flows, in any order.', 'Syntax' : '=XNPV(rate, values, dates)' },
    'YIELD' : { 'Summary' : 'The Excel YIELD function returns the yield on a security that pays periodic interest.', 'Purpose' : 'Get yield for security that pays periodic interest', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.rate - Annual coupon rate.pr - Security\'s price per $100 face value.redemption - Redemption value per $100 face value.frequency - Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=YIELD(sd, md, rate, pr, redemption, frequency, [basis])' },
    'YIELDDISC' : { 'Summary' : 'The Excel YIELDDISC function returns the annual yield for a discounted security, such as a Treasury bill, that is issued at a discount but that matures at face value.', 'Purpose' : 'Get annual yield for discounted security', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.pr - Price of security.redemption - Redemption value per $100 face value.basis - [optional] Day count basis (see below, default =0).', 'Syntax' : '=YIELDDISC(sd, md, pr, redemption, [basis])' },
    'YIELDMAT' : { 'Summary' : 'The Excel YIELDMAT function returns the annual yield of a security that pays interest at maturity.', 'Purpose' : 'Get annual yield of security interest at maturity', 'Return value' : 'Yield as percentage', 'Arguments' : 'sd - Settlement date of the security.md - Maturity date of the security.id - Issue date of the security.rate - Interest rate of security.pr - Price per $100 face value.basis - [optional] Coupon payments per year (annual = 1, semiannual = 2; quarterly = 4).', 'Syntax' : '=YIELDMAT(sd, md, id, rate, pr, [basis])' },
    'CELL' : { 'Summary' : 'The Excel CELL function returns information about a cell in a worksheet. The type of information to be returned is specified as info_type. CELL can get things like address and filename, as well as detailed info about the formatting used in the cell. See below for a full list of information available.', 'Purpose' : 'Get information about a cell', 'Return value' : 'A text value', 'Arguments' : 'info_type - The type of information to return about the reference.reference - [optional] The reference from which to extract information.', 'Syntax' : '=CELL(info_type, [reference])' },
    'INFO' : { 'Summary' : 'The Excel INFO function returns information about the current environment, including platform, Excel version, number of worksheets in a workbook, and so on. To use the INFO function, supply the type of information you want as text. There are seven types of information available, summarized in the table below.', 'Purpose' : 'Get information about current environment', 'Return value' : 'The information requested', 'Arguments' : 'type_text - The information type to return as text.', 'Syntax' : '=INFO(type_text)' },
    'ISBLANK' : { 'Summary' : 'The Excel ISBLANK function returns TRUE when a cell is empty, and FALSE when a cell is not empty. For example, if A1 contains "apple", ISBLANK(A1) returns FALSE.', 'Purpose' : 'Test if a cell is empty', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISBLANK(value)' },
    'ISERR' : { 'Summary' : 'The Excel ISERR function returns TRUE for any error type except the #N/A error. You can use the ISERR function together with the IF function to test for an error and display a custom message, or perform a different calculation if found.', 'Purpose' : 'Test for any error but #N/A', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check for any error but #N/A.', 'Syntax' : '=ISERR(value)' },
    'ISERROR' : { 'Summary' : 'The Excel ISERROR function returns TRUE for any error type excel generates, including #N/A, #VALUE!, #REF!, #DIV/0!, #NUM!, #NAME?, or #NULL! You can use ISERROR together with the IF function to test for errors and display a custom message, or run a different calculation when an error occurs.', 'Purpose' : 'Test for any error', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check for any error.', 'Syntax' : '=ISERROR(value)' },
    'ISEVEN' : { 'Summary' : 'The Excel ISEVEN function returns TRUE when a value is an even number, and FALSE when a value is an odd number. ISEVEN will return the #VALUE error if a value is not numeric.', 'Purpose' : 'Test if a value is even', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The numeric value to check.', 'Syntax' : '=ISEVEN(value)' },
    'ISFORMULA' : { 'Summary' : 'The Excel ISFORMULA function returns TRUE if a cell contains a formula, and FALSE if not. When a cell contains a formula ISFORMULA will return TRUE regardless of the formula\'s output or error conditions.', 'Purpose' : 'Test if cell contains a formula', 'Return value' : 'TRUE or FALSE', 'Arguments' : 'reference - Reference to cell or cell range.', 'Syntax' : '=ISFORMULA(reference)' },
    'ISLOGICAL' : { 'Summary' : 'The Excel ISLOGICAL function returns TRUE when a cell contains the logical values TRUE or FALSE, and returns FALSE for cells that contain any other value, including empty cells. ', 'Purpose' : 'Test if a value is logical', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to test as logical.', 'Syntax' : '=ISLOGICAL(value)' },
    'ISNA' : { 'Summary' : 'The Excel ISNA function returns TRUE when a cell contains the #N/A error and FALSE for any other value, or any other error type. You can use the ISNA function with the IF function test for #N/A and display a friendly message if the error occurs.', 'Purpose' : 'Test for the #N/A error', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check if #N/A.', 'Syntax' : '=ISNA(value)' },
    'ISNONTEXT' : { 'Summary' : 'The Excel ISNONTEXT function returns TRUE when a cell contains any value except text. This includes numbers, dates, times, errors, and formulas that do not return text. ISNONTEXT also returns TRUE when a cell is empty.', 'Purpose' : 'Test for a non-text value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISNONTEXT(value)' },
    'ISNUMBER' : { 'Summary' : 'The Excel ISNUMBER function returns TRUE when a cell contains a number, and FALSE if not. You can use ISNUMBER to check that a cell contains a numeric value, or that the result of another function is a number.', 'Purpose' : 'Test for numeric value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISNUMBER(value)' },
    'ISODD' : { 'Summary' : 'The Excel ISODD function returns TRUE when a value is an odd number, and FALSE when a value is an even number. ISODD will return the #VALUE error if a value is not numeric.', 'Purpose' : 'Test if a value is odd', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The numeric value to check.', 'Syntax' : '=ISODD(value)' },
    'ISREF' : { 'Summary' : 'The Excel ISREF returns TRUE when a cell contains a reference and FALSE if not. You can use the ISREF function to check for a reference in a formula.', 'Purpose' : 'Test for a reference', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISREF(value)' },
    'ISTEXT' : { 'Summary' : 'The Excel ISTEXT function returns TRUE when a cell contains a text value, and FALSE if the cell contains any other value. You can use the ISTEXT function to check if a cell contains a text value, or a numeric value entered as text.', 'Purpose' : 'Test for a text value', 'Return value' : 'A logical value (TRUE or FALSE)', 'Arguments' : 'value - The value to check.', 'Syntax' : '=ISTEXT(value)' },
    'N' : { 'Summary' : 'The Excel N function returns a number when given a value. The N function can be used to convert TRUE and FALSE to 1 and 0 respectively. When given a text value, the N function returns zero.', 'Purpose' : 'Convert a value to a number', 'Return value' : 'A number or error code', 'Arguments' : 'value - The value to convert to a number.', 'Syntax' : '=N(value)' },
    'NA' : { 'Summary' : 'The Excel NA function returns the #N/A error. #N/A means "not available" or "no value available". You can use the NA function to display the #N/A error when information is missing.', 'Purpose' : 'Create an #N/A error', 'Return value' : 'The #N/A error', 'Arguments' : '', 'Syntax' : '=NA()' },
    'SHEET' : { 'Summary' : 'The Excel SHEET function returns the index number of a sheet in Excel. SHEET will report the sheet number for a cell reference, named range, or Excel Table.', 'Purpose' : 'Get sheet index number', 'Return value' : 'The index number of a given sheet', 'Arguments' : 'value - [optional] The value to check.', 'Syntax' : '=SHEET([value])' },
    'SHEETS' : { 'Summary' : 'The Excel SHEETS function returns the total number of sheets in a given reference. When no arguments are supplied SHEETS returns the total number of sheets in the workbook.', 'Purpose' : 'Get number of sheets in a reference', 'Return value' : 'Sheet count', 'Arguments' : 'reference - [optional] A valid Excel reference.', 'Syntax' : '=SHEETS([reference])' },
    'T' : { 'Summary' : 'The Excel T function returns text when given a text value and an empty string ("") for numbers, dates, and the logical values TRUE and FALSE. You can use the T function to remove values that are not text.', 'Purpose' : 'Filter text values only', 'Return value' : 'Value as text when text', 'Arguments' : 'value - The value to return as text.', 'Syntax' : '=T(value)' },
    'TYPE' : { 'Summary' : 'The Excel TYPE function returns a numeric code representing "type" in 5 categories: number = 1, text = 2, logical = 4, error = 16, and array = 64. Use TYPE when the operation of a formula depends on the type of value in a particular cell.', 'Purpose' : 'Get the type of value in a cell', 'Return value' : 'A numeric code representing type', 'Arguments' : 'value - The value to check the type of.', 'Syntax' : '=TYPE(value)' },
    'ABS' : { 'Summary' : 'The Excel ABS function returns the absolute value of a number. ABS converts negative numbers to positive numbers, and positive numbers are unaffected.', 'Purpose' : 'Find the absolute value of a number', 'Return value' : 'A positive number.', 'Arguments' : 'number - The number to get the absolute value of.', 'Syntax' : '=ABS(number)' },
    'AGGREGATE' : { 'Summary' : 'The Excel AGGREGATE function returns a aggregate calculation like AVERAGE, COUNT, MAX, etc., optionally ignoring hidden rows and errors. A total of 19 operations are available, specified by function number in the first argument (see table for options).', 'Purpose' : 'Return aggregate calculation', 'Return value' : 'Depends on function specified', 'Arguments' : 'function_num - Operation to perform (1-19).options - Values to ignore (0-7).ref1 - First argument.ref2 - [optional] Second argument (k).', 'Syntax' : '=AGGREGATE(function_num, options, ref1, [ref2], ...)' },
    'ARABIC' : { 'Summary' : 'The Excel ARABIC function converts a Roman numeral as text to an Arabic numeral. For example, the formula =ARABIC("VII") returns 7.', 'Purpose' : 'Converts a Roman numerals to an Arabic numerals', 'Return value' : 'A number (in Arabic numeral)', 'Arguments' : 'roman_text - The Roman numeral in text that you want to convert.', 'Syntax' : '=ARABIC(roman_text)' },
    'BASE' : { 'Summary' : 'The Excel BASE function converts a number to the text representation of the same number in a given base, where base is provided as the radix argument.', 'Purpose' : 'Convert number to another base.', 'Return value' : 'The text representation of the converted number.', 'Arguments' : 'number - The number to convert to a given base.radix - The base to convert to.min_length - [optional] The minimum string length to return, achieved by padding with zeros.', 'Syntax' : '=BASE(number, radix, [min_length])' },
    'CEILING' : { 'Summary' : 'The Excel CEILING function rounds a given number up to the nearest specified multiple. CEILING works like the MROUND function, but CEILING always rounds up.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=CEILING(number, significance)' },
    'CEILING.MATH' : { 'Summary' : 'The Excel CEILING.MATH function rounds a number up to a specified multiple. Unlike the CEILING function, CEILING.MATH defaults to a multiple of 1, and provides explicit control over rounding direction for negative numbers.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.mode - [optional] Round negative numbers toward or away from zero. Default is 0.', 'Syntax' : '=CEILING.MATH(number, [significance], [mode])' },
    'CEILING.PRECISE' : { 'Summary' : 'The Excel CEILING.PRECISE function rounds a number up to a given multiple. CEILING.PRECISE defaults to a multiple of 1, and always rounds negative numbers toward zero.', 'Purpose' : 'Round a number up to nearest multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.', 'Syntax' : '=CEILING.PRECISE(number, [significance])' },
    'COMBIN' : { 'Summary' : 'The Excel COMBIN function returns the number of combinations for a given number of items. The COMBIN function does not allow repetitions. To count combinations that allow repetitions, use the COMBINA function.', 'Purpose' : 'Get number of combinations without repetitions', 'Return value' : 'Number of combinations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=COMBIN(number, number_chosen)' },
    'COMBINA' : { 'Summary' : 'The Excel COMBINA function returns the number of combinations with repetitions allowed. To count combinations that do not allow repetitions, use the COMBIN function.', 'Purpose' : 'Get number of combinations with repetitions', 'Return value' : 'Number of combinations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=COMBINA(number, number_chosen)' },
    'DECIMAL' : { 'Summary' : 'The Excel DECIMAL function converts a number in a given base into its decimal number equivalent. For example, the DECIMAL function can convert the binary number 1101 into the decimal number 13.', 'Purpose' : 'Convert a number in a different base to a decimal number', 'Return value' : 'Decimal number', 'Arguments' : 'number - A text string representing a number.radix - The base of the number to be converted, an integer between 2-36.', 'Syntax' : '=DECIMAL(number, radix)' },
    'EVEN' : { 'Summary' : 'The Excel EVEN function rounds numbers up to the next even integer. The EVEN function always rounds numbers away from zero, so positive numbers become larger and negative numbers become smaller (i.e. more negative).', 'Purpose' : 'Round a number up to the next even integer', 'Return value' : 'An even integer.', 'Arguments' : 'number - The number to round up to an even integer.', 'Syntax' : '=EVEN(number)' },
    'FACT' : { 'Summary' : 'The Excel FACT function returns the factorial of a given number. For example, =FACT(3) returns 6, equivalent to 3 x 2 x 1.', 'Purpose' : 'Find the factorial of a number', 'Return value' : 'The factorial of a number', 'Arguments' : 'number - The number to get the factorial of.', 'Syntax' : '=FACT(number)' },
    'FACTDOUBLE' : { 'Summary' : 'The Excel FACTDOUBLE function returns the double factorial of a number. A double factorial is symbolized by two exclamation marks (!!).', 'Purpose' : 'Get double factorial of a number', 'Return value' : 'Calculated doublefactorial', 'Arguments' : 'number - A number greater than or equal to -1.', 'Syntax' : '=FACTDOUBLE(number)' },
    'FLOOR' : { 'Summary' : 'The Excel FLOOR function rounds a given number down to the nearest specified multiple. FLOOR works like the MROUND function, but FLOOR always rounds down.', 'Purpose' : 'Round a number down to the nearest specified multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=FLOOR(number, significance)' },
    'FLOOR.MATH' : { 'Summary' : 'The Excel FLOOR.MATH function rounds a number down to a specified multiple. Unlike the FLOOR function, FLOOR.MATH defaults to a multiple of 1, and provides explicit support for rounding negative numbers.', 'Purpose' : 'Round number down to nearest multiple', 'Return value' : 'A rounded number', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.mode - [optional] For rounding negative numbers toward or away from zero. Default is 0.', 'Syntax' : '=FLOOR.MATH(number, [significance], [mode])' },
    'FLOOR.PRECISE' : { 'Summary' : 'The Excel FLOOR.PRECISE function rounds a number down to a given multiple. FLOOR.PRECISE defaults to a multiple of 1, and always rounds negative numbers away from zero.', 'Purpose' : 'Round number down to nearest multiple', 'Return value' : 'A rounded number', 'Arguments' : 'number - The number that should be rounded.significance - [optional] Multiple to use when rounding. Default is 1.', 'Syntax' : '=FLOOR.PRECISE(number, [significance])' },
    'GCD' : { 'Summary' : 'The Excel GCD function returns the greatest common divisor of two or more integers. The greatest common divisor is the largest integer that goes into all supplied numbers without a remainder. For example, =GCD(60,36) returns 12.', 'Purpose' : 'Get the greatest common divisor of numbers', 'Return value' : 'The largest positive integer that divides the numbers evenly', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=GCD(number1, [number2], ...)' },
    'INT' : { 'Summary' : 'The Excel INT function returns the integer part of a decimal number by rounding down to the integer. Note that negative numbers become more negative. For example, while INT(10.8) returns 10, INT(-10.8) returns -11.', 'Purpose' : 'Get the integer part of a number by rounding down', 'Return value' : 'The integer part of the number after rounding down', 'Arguments' : 'number - The number from which you want an integer.', 'Syntax' : '=INT(number)' },
    'LCM' : { 'Summary' : 'The Excel LCM function returns the least common multiple of integers. The least common multiple is the smallest positive integer that is a multiple of all supplied numbers. For example, =LCM(25,40) returns 200.', 'Purpose' : 'Get the least common multiple of numbers', 'Return value' : 'The least common multiple of all numbers', 'Arguments' : 'number1 - The first number.number2 - [optional] The second number.', 'Syntax' : '=LCM(number1, [number2], ...)' },
    'LOG' : { 'Summary' : 'The Excel LOG function returns the logarithm of a given number, using a supplied base. The base argument defaults to 10 if not supplied.', 'Purpose' : 'Get the logarithm of a number', 'Return value' : 'The logarithm', 'Arguments' : 'number - Number for which you want the logarithm.base - [optional] Base of the logarithm. Defaults to 10.', 'Syntax' : '=LOG(number, [base])' },
    'LOG10' : { 'Summary' : 'The Excel LOG10 function returns the base 10 logarithm of a number. For example, LOG10(100) returns 2, and LOG10(1000) returns 3.', 'Purpose' : 'Get the base-10 logarithm of a number', 'Return value' : 'The logarithm', 'Arguments' : 'number - Number for which you want the logarithm.', 'Syntax' : '=LOG10(number)' },
    'MDETERM' : { 'Summary' : 'The Excel MDETERM function returns the matrix determinant of a given array. The input array must contain numbers only and be a square matrix, with equal rows and columns. The result is a number representing the matrix determinant.', 'Purpose' : 'Get matrix determinant of given array', 'Return value' : 'A number representing the matrix determinant', 'Arguments' : 'array - A square array of numbers only.', 'Syntax' : '=MDETERM(array)' },
    'MINVERSE' : { 'Summary' : 'The Excel MINVERSE function returns the inverse matrix of a given array. The input array must contain numbers only and be a square matrix, with equal rows and columns. The result is an inverse matrix with the same dimensions as the array provided.', 'Purpose' : 'Get inverse matrix of array', 'Return value' : 'Inverse matrix of array with same dimensions', 'Arguments' : 'array - A square array of numbers only.', 'Syntax' : '=MINVERSE(array)' },
    'MMULT' : { 'Summary' : 'The Excel MMULT function returns the matrix product of two arrays. The result from MMULT is an array that contains the same number of rows as array1 and the same number of columns as array2. ', 'Purpose' : 'Perform matrix multiplication', 'Return value' : 'The matrix product of two arrays', 'Arguments' : 'array1 - The first array to multiply.array2 - The second array to multiply.', 'Syntax' : '=MMULT(array1, array2)' },
    'MOD' : { 'Summary' : 'The Excel MOD function returns the remainder of two numbers after division. For example, MOD(10,3) = 1. The result of MOD carries the same sign as the divisor.', 'Purpose' : 'Get the remainder from division', 'Return value' : 'The remainder', 'Arguments' : 'number - The number to be divided.divisor - The number to divide with.', 'Syntax' : '=MOD(number, divisor)' },
    'MROUND' : { 'Summary' : 'The Excel MROUND function returns a number rounded to a given multiple. MROUND will round a number up or down, depending on the nearest multiple.', 'Purpose' : 'Round a number to the nearest specified multiple', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number that should be rounded.significance - The multiple to use when rounding.', 'Syntax' : '=MROUND(number, significance)' },
    'MUNIT' : { 'Summary' : 'The Excel MUNIT function returns a unit matrix for a given dimension, n, with a size of n x n. This resulting matrix contains ones on the main diagonal and zeros in every other position.', 'Purpose' : 'Return unit matrix for a given dimension', 'Return value' : 'Unix matrix of size n x n', 'Arguments' : 'dimension - An integer for the size of the unit matrix.', 'Syntax' : '=MUNIT(dimension)' },
    'ODD' : { 'Summary' : 'The Excel ODD function returns the next odd integer after rounding a given number up. The ODD function always rounds numbers away from zero, so positive numbers become larger and negative numbers become smaller (i.e. more negative).', 'Purpose' : 'Round a number up to the next odd integer', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round up to an odd integer.', 'Syntax' : '=ODD(number)' },
    'POWER' : { 'Summary' : 'The Excel POWER function returns a number raised to a given power. The POWER function is an alternative to the exponent operator (^).', 'Purpose' : 'Raise a number to a power', 'Return value' : 'Number raised to power', 'Arguments' : 'number - Number to raise to a power.power - Power to raise number to (the exponent).', 'Syntax' : '=POWER(number, power)' },
    'PRODUCT' : { 'Summary' : 'The Excel PRODUCT function returns the product of numbers provided as arguments. The PRODUCT function is helpful when multiplying many cells together. The formula =PRODUCT(A1:A3) is the same as =A1*A2*A3.', 'Purpose' : 'Get the product of supplied numbers', 'Return value' : 'Product of supplied numbers', 'Arguments' : 'number1 - The first number or range to multiply.number2 - [optional] The second number or range to multiply.', 'Syntax' : '=PRODUCT(number1, [number2], ...)' },
    'QUOTIENT' : { 'Summary' : 'The Excel QUOTIENT function returns the integer portion of division without the remainder. Use QUOTIENT to discard the remainder after division.', 'Purpose' : 'Returns the quotient without a remainder.', 'Return value' : 'Integer Number', 'Arguments' : 'numerator - The number to be divided.denominator - The number to divide by.', 'Syntax' : '=QUOTIENT(numerator, denominator)' },
    'RAND' : { 'Summary' : 'The Excel RAND function returns a random number between 0 and 1. For example, =RAND() will generate a number like 0.422245717. RAND recalculates when a worksheet is opened or changed.', 'Purpose' : 'Get a random number between 0 and 1', 'Return value' : 'A number between 1 and 0', 'Arguments' : '', 'Syntax' : '=RAND()' },
    'RANDBETWEEN' : { 'Summary' : 'The Excel RANDBETWEEN function returns a random integer between two given numbers. RANDBETWEEN recalculates each time a worksheet is opened or changed.', 'Purpose' : 'Get a random integer between two values', 'Return value' : 'An integer', 'Arguments' : 'bottom - An integer representing the lower value of the range.top - An integer representing the upper value of the range.', 'Syntax' : '=RANDBETWEEN(bottom, top)' },
    'ROMAN' : { 'Summary' : 'The Excel ROMAN function converts a number to a Roman numeral as text. For example, the formula =ROMAN(4) returns IV.', 'Purpose' : 'Converts numbers to Roman numerals', 'Return value' : 'A Roman numeral in text', 'Arguments' : 'number - Number (in Arabic numeral) you want to convert to Roman numeral.form - [optional] The type of Roman numeral you want.', 'Syntax' : '=ROMAN(number, [form])' },
    'ROUND' : { 'Summary' : 'The Excel ROUND function returns a number rounded to a given number of digits. The ROUND function can round to the right or left of the decimal point.', 'Purpose' : 'Round a number to a given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUND(number, num_digits)' },
    'ROUNDDOWN' : { 'Summary' : 'The Excel ROUNDDOWN function returns a number rounded down to a given number of places. Unlike standard rounding, where only numbers less than 5 are rounded down, ROUNDDOWN rounds all numbers down.', 'Purpose' : 'Round down to given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round down.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUNDDOWN(number, num_digits)' },
    'ROUNDUP' : { 'Summary' : 'The Excel ROUNDUP function returns a number rounded up to a given number of decimal places. Unlike standard rounding, where only numbers less than 5 are rounded down, ROUNDUP rounds all numbers up.', 'Purpose' : 'Round a number up to a given number of digits', 'Return value' : 'A rounded number.', 'Arguments' : 'number - The number to round up.num_digits - The place at which number should be rounded.', 'Syntax' : '=ROUNDUP(number, num_digits)' },
    'SQRT' : { 'Summary' : 'The Excel SQRT function returns the square root of a positive number. SQRT returns an error if number is negative.', 'Purpose' : 'Find the positive square root of a number', 'Return value' : 'Positive square root', 'Arguments' : 'number - The number to get the square root of.', 'Syntax' : '=SQRT(number)' },
    'SUBTOTAL' : { 'Summary' : 'The Excel SUBTOTAL function is designed to run a given calculation on a range of cells while ignoring cells that should not be included. SUBTOTAL can return a SUM, AVERAGE, COUNT, MAX, and others (see complete list below), and SUBTOTAL function can either include or exclude values in hidden rows.', 'Purpose' : 'Get a subtotal in a list or database', 'Return value' : 'A number representing a specific kind of subtotal', 'Arguments' : 'function_num - A number that specifies which function to use in calculating subtotals within a list. See table below for full list.ref1 - A named range or reference to subtotal.ref2 - [optional] A named range or reference to subtotal.', 'Syntax' : '=SUBTOTAL(function_num, ref1, [ref2], ...)' },
    'SUM' : { 'Summary' : 'The Excel SUM function returns the sum of values supplied. These values can be numbers, cell references, ranges, arrays, and constants, in any combination. SUM can handle up to 255 individual arguments.', 'Purpose' : 'Add numbers together', 'Return value' : 'The sum of values supplied.', 'Arguments' : 'number1 - The first value to sum.number2 - [optional] The second value to sum.number3 - [optional] The third value to sum.', 'Syntax' : '=SUM(number1, [number2], [number3], ...)' },
    'SUMIF' : { 'Summary' : 'The Excel SUMIF function returns the sum of cells that meet a single condition. Criteria can be applied to dates, numbers, and text. The SUMIF function supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Sum cells in a range that meet criteria', 'Return value' : 'The sum of matching cells', 'Arguments' : 'range - Range to apply criteria to.criteria - Criteria to apply.sum_range - [optional] Range to sum. If omitted, cells in range are summed.', 'Syntax' : '=SUMIF(range, criteria, [sum_range])' },
    'SUMIFS' : { 'Summary' : 'The SUMIFS function sums cells in a range that meet one or more conditions, referred to as criteria. SUMIFS can apply conditions based on dates, numbers, and text. SUMIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Sum cells in a range that meet criteria', 'Return value' : 'The sum of cells that meet all criteria', 'Arguments' : 'sum_range - The range to be summed.range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=SUMIFS(sum_range, range1, criteria1, [range2], [criteria2], ...)' },
    'SUMPRODUCT' : { 'Summary' : 'The Excel SUMPRODUCT function multiplies ranges or arrays together and returns the sum of products. This sounds boring, but SUMPRODUCT is an incredibly versatile function that can be used to count and sum like COUNTIFS or SUMIFS, but with more flexibility. Other functions can easily be used inside SUMPRODUCT to extend functionality even further.', 'Purpose' : 'Multiply, then sum arrays', 'Return value' : 'The result of multipled and summed arrays', 'Arguments' : 'array1 - The first array or range to multiply, then add.array2 - [optional] The second array or range to multiply, then add.', 'Syntax' : '=SUMPRODUCT(array1, [array2], ...)' },
    'SUMSQ' : { 'Summary' : 'The Excel SUMSQ function returns the sum of the squares of the values provided. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Get sum of squares of supplied values', 'Return value' : 'Calculated sum of squares', 'Arguments' : 'number1 - The first argument containing numeric values.number2 - [optional] The first argument containing numeric values.', 'Syntax' : '=SUMSQ(number1, [number2], ...)' },
    'SUMX2MY2' : { 'Summary' : 'The Excel SUMX2PY2 function returns the sum of the difference of squares of corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Sum of difference of squares in two arrays', 'Return value' : 'Calculated sum of difference of squares', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMX2MY2(array_x, array_y)' },
    'SUMX2PY2' : { 'Summary' : 'The Excel SUMX2PY2 function returns the sum of the sum of squares of corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Get sum of squares in two arrays', 'Return value' : 'Calculated sum of sum of squares', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMX2PY2(array_x, array_y)' },
    'SUMXMY2' : { 'Summary' : 'The Excel SUMXMY2 function returns the sum of squares of differences between corresponding values in two arrays. Values can be supplied as constants, cell references, or ranges.', 'Purpose' : 'Sum of squares of differences in two arrays', 'Return value' : 'Calculated sum of squares of differences', 'Arguments' : 'array_x - The first range or array containing numeric values.array_y - The second range or array containing numeric values.', 'Syntax' : '=SUMXMY2(array_x, array_y)' },
    'TRUNC' : { 'Summary' : 'The Excel TRUNC function returns a truncated number based on an (optional) number of digits. For example, TRUNC(4.9) will return 4, and TRUNC(-3.5) will return -3. The TRUNC function does no rounding, it simply truncates as specified.', 'Purpose' : 'Truncate a number to a given precision', 'Return value' : 'A truncated number', 'Arguments' : 'number - The number to truncate.num_digits - [optional] The precision of the truncation (default is 0).', 'Syntax' : '=TRUNC(number, [num_digits])' },
    'ATAN2' : { 'Summary' : 'The Excel ATAN2 function returns the arctangent from x- and y-coordinates. In geometric terms, the function returns the radian angle corresponding to the input point.', 'Purpose' : 'Get arctangent from x- and y-coordinates', 'Return value' : 'The angle in radians of the point.', 'Arguments' : 'x_num - The x coordinate of the input point.y_num - The y coordinate of the input point.', 'Syntax' : '=ATAN2(x_num, y_num)' },
    'COS' : { 'Summary' : 'The Excel COS function returns the cosine of an angle given in radians. To supply an angle to COS in degrees, use the RADIANS function to convert to radians.', 'Purpose' : 'Get the cosine of an angle provided in radians.', 'Return value' : 'The cosine value', 'Arguments' : 'number - The angle in radians for which you want the cosine.', 'Syntax' : '=COS(number)' },
    'COSH' : { 'Summary' : 'The Excel COSH function returns the hyperbolic cosine of a number.', 'Purpose' : 'Get hyperbolic cosine of a number', 'Return value' : 'The x-component of the hyperbolic angle.', 'Arguments' : 'number - The hyperbolic angle.', 'Syntax' : '=COSH(number)' },
    'DEGREES' : { 'Summary' : 'The Excel DEGREES function converts angles (expressed in radians) to degrees. For example, the formula =DEGREES(PI()) returns 180.', 'Purpose' : 'Converts radians to degrees', 'Return value' : 'Degrees', 'Arguments' : 'angle - Angle in radians that you want to convert to degrees.', 'Syntax' : '=DEGREES(angle)' },
    'SIN' : { 'Summary' : 'The Excel SIN function returns the sine of an angle given in radians. To supply an angle to SIN in degrees, multiply the angle by PI()/180 or use the RADIANS function to convert to radians.', 'Purpose' : 'Get the sine of an angle provided in radians.', 'Return value' : 'Sine value', 'Arguments' : 'number - The angle in radians for which you want the sine.', 'Syntax' : '=SIN(number)' },
    'SINH' : { 'Summary' : 'The Excel SINH function returns the hyperbolic sine of a number.', 'Purpose' : 'Get hyperbolic sine of a number.', 'Return value' : 'The hyperbolic sine of a number.', 'Arguments' : 'number - The hyperbolic angle.', 'Syntax' : '=SINH(number)' },
    'AVEDEV' : { 'Summary' : 'The Excel AVEDEV function returns the average of the absolute value of deviations from the mean for a given set of data. Average deviation is a measure of variability.', 'Purpose' : 'Get sum of squared deviations', 'Return value' : 'Calculated sum', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=AVEDEV(number1, [number2], ...)' },
    'AVERAGE' : { 'Summary' : 'The Excel AVERAGE function calculates the average (arithmetic mean) of supplied numbers. AVERAGE can handle up to 255 individual arguments, which can include numbers, cell references, ranges, arrays, and constants.', 'Purpose' : 'Get the average of a group of numbers', 'Return value' : 'A number representing the average.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=AVERAGE(number1, [number2], ...)' },
    'AVERAGEA' : { 'Summary' : 'The Excel AVERAGEA function returns the average of a set of supplied values. Unlike AVERAGE, AVERAGEA will also evaluate the logical values TRUE and FALSE, and numbers represented as text, whereas AVERAGE ignores these values during calculation', 'Purpose' : 'Get the average of a group of numbers and text', 'Return value' : 'A number representing the average.', 'Arguments' : 'value1 - A value or reference to a value that can be evaluated as a number.value2 - [optional] A value or reference to a value that can be evaluated as a number.', 'Syntax' : '=AVERAGEA(value1, [value2], ...)' },
    'AVERAGEIF' : { 'Summary' : 'The Excel AVERAGEIF function calculates the average of numbers in a range that meet supplied criteria. AVERAGEIF criteria can include logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get the average of numbers that meet criteria.', 'Return value' : 'A number representing the average.', 'Arguments' : 'range - One or more cells, including numbers or names, arrays, or references.criteria - A number, expression, cell reference, or text.average_range - [optional] The cells to average. When omitted, range is used.', 'Syntax' : '=AVERAGEIF(range, criteria, [average_range])' },
    'AVERAGEIFS' : { 'Summary' : 'The Excel AVERAGEIFS function calculates the average of numbers in a range that meet one or more criteria. The criteria used for AVERAGEIFS can include logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Average cells that match multiple criteria', 'Return value' : 'The average of the cells that meet all criteria', 'Arguments' : 'avg_rng - The range to average.range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=AVERAGEIFS(avg_rng, range1, criteria1, [range2], [criteria2], ...)' },
    'BINOM.DIST' : { 'Summary' : 'The Excel BINOM.DIST function returns the individual term binomial distribution probability. You can use BINOM.DIST to calculate probabilities that an event will occur a certain number of times in a given number of trials.', 'Purpose' : 'Get binomial distribution probability', 'Return value' : 'Calculated probability', 'Arguments' : 'number_s - The number of successes.trials - The number of independent trials.probability_s - The probability of success on each trial.cumulative - TRUE = cumulative distribution function, FALSE=probability mass function.', 'Syntax' : '=BINOM.DIST(number_s, trials, probability_s, cumulative)' },
    'BINOMDIST' : { 'Summary' : 'The Excel BINOMDIST function returns the individual term binomial distribution probability. You can use BINOMDIST to calculate probabilities that an event will occur a certain number of times in a given number of trials.', 'Purpose' : 'Get binomial distribution probability', 'Return value' : 'Calculated probability', 'Arguments' : 'number_s - The number of successes.trials - The number of independent trials.probability_s - The probability of success on each trial.cumulative - TRUE = cumulative distribution function, FALSE=probability mass function.', 'Syntax' : '=BINOMDIST(number_s, trials, probability_s, cumulative)' },
    'COUNT' : { 'Summary' : 'The Excel COUNT function returns a count of values that are numbers. Numbers include negative numbers, percentages, dates, times, fractions, and formulas that return numbers. Empty cells and text values are ignored.', 'Purpose' : 'Count numbers', 'Return value' : 'Count of numeric values', 'Arguments' : 'value1 - An item, cell reference, or range.value2 - [optional] An item, cell reference, or range.', 'Syntax' : '=COUNT(value1, [value2], ...)' },
    'COUNTA' : { 'Summary' : 'The Excel COUNTA function returns the count of cells that contain numbers, text, logical values, error values, and empty text (""). COUNTA does not count empty cells.', 'Purpose' : 'Count the number of non-blank cells', 'Return value' : 'A number representing non-blank cells.', 'Arguments' : 'value1 - An item, cell reference, or range.value2 - [optional] An item, cell reference, or range.', 'Syntax' : '=COUNTA(value1, [value2], ...)' },
    'COUNTBLANK' : { 'Summary' : 'The Excel COUNTBLANK function returns a count of empty cells in a range. Cells that contain text, numbers, errors, spaces, etc. are not counted. Formulas that return empty strings ("") are counted as blank.', 'Purpose' : 'Count cells that are blank', 'Return value' : 'A number representing blank cells', 'Arguments' : 'range - The range in which to count blank cells.', 'Syntax' : '=COUNTBLANK(range)' },
    'COUNTIF' : { 'Summary' : 'COUNTIF is an Excel function to count cells in a range that meet a single condition. COUNTIF can be used to count cells that contain dates, numbers, and text. The criteria used in COUNTIF supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Count cells that match criteria', 'Return value' : 'A number representing cells counted.', 'Arguments' : 'range - The range of cells to count.criteria - The criteria that controls which cells should be counted.', 'Syntax' : '=COUNTIF(range, criteria)' },
    'COUNTIFS' : { 'Summary' : 'The Excel COUNTIFS function returns the count of cells that meet one or more criteria. COUNTIFS can be used to count cells that contain dates, numbers, and text, with logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : ' Count cells that match multiple criteria', 'Return value' : 'The number of times criteria are met', 'Arguments' : 'range1 - The first range to evaulate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=COUNTIFS(range1, criteria1, [range2], [criteria2], ...)' },
    'DEVSQ' : { 'Summary' : 'The Excel DEVSQ function returns the sum of the squared deviations from the mean for a given set of data. ', 'Purpose' : 'Get sum of squared deviations', 'Return value' : 'Calculated sum', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=DEVSQ(number1, [number2], ...)' },
    'FORECAST' : { 'Summary' : 'The Excel FORECAST function predicts a value based on existing values along a linear trend. FORECAST calculates future value predictions using linear regression, and can be used to predict numeric values like sales, inventory, expenses, measurements, etc.', 'Purpose' : 'Predict value along a linear trend', 'Return value' : 'Predicted value', 'Arguments' : 'x - The x value data point to use to calculate a prediction.known_ys - The dependent array or range of data (y values).kown_xs - The independent array or range of data (x values).', 'Syntax' : '=FORECAST(x, known_ys, kown_xs)' },
    'FORECAST.ETS' : { 'Summary' : 'The Excel FORECAST.ETS function predicts a value based on existing values that follow a seasonal trend. FORECAST.ETS can be used to predict numeric values like sales, inventory, expenses, etc. with a seasonal pattern.', 'Purpose' : 'Predict value with a seasonal trend', 'Return value' : 'Predicted value', 'Arguments' : 'target_date - The time or period for the prediction (x value).values - Existing or historical values (y values).timeline - Numeric timeline values (x values).seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS(target_date, values, timeline, [seasonality], [data_completion], [aggregation])' },
    'FORECAST.ETS.CONFINT' : { 'Summary' : 'The Excel FORECAST.ETS.CONFINT function returns a confidence interval for a forecast value at a specific point on a timeline. It is designed to be used along with the FORECAST.ETS function as a way to show forecast accuracy.', 'Purpose' : 'Get confidence interval for forecast value at given date', 'Return value' : 'Confidence interval value', 'Arguments' : 'target_date - The time or period for the prediction (x value).values - Existing or historical values (y values).timeline - Numeric timeline values (x values).confidence_level - [optional] A number between 0 and 1 (exclusive). Default = 0.95.seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.CONFINT(target_date, values, timeline, [confidence_level], [seasonality], [data_completion], [aggregation])' },
    'FORECAST.ETS.SEASONALITY' : { 'Summary' : 'The Excel FORECAST.ETS.SEASONALITY function returns the length in time of a seasonal pattern based on existing values and a timeline.', 'Purpose' : 'Get length of the seasonal pattern', 'Return value' : 'Season length in timeline units', 'Arguments' : 'values - Existing or historical values (y values).timeline - Numeric timeline values (x values).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.SEASONALITY(values, timeline, [data_completion], [aggregation])' },
    'FORECAST.ETS.STAT' : { 'Summary' : 'The Excel FORECAST.ETS.STAT function returns a particular statistical value relating related to time series forecasting with the FORECAST.ETS function. The statistic_type argument determines which statistic is returned by FORECAST.ETS.STAT.', 'Purpose' : 'Get statistical value related to forecasting', 'Return value' : 'Requested statistic', 'Arguments' : 'values - Existing or historical values (y values).timeline - Numeric timeline values (x values).statistic_type - The statistic to return, a numeric value between 1 and 8 (see table below).seasonality - [optional] Seasonality calculation (0 = no seasonality, 1 = automatic, n = season length in timeline units).data_completion - [optional] Missing data treatment (0 = treat as zero, 1 = average). Default is 1.aggregation - [optional] Aggregation behavior. Default is 1 (AVERAGE). See other options below.', 'Syntax' : '=FORECAST.ETS.STAT(values, timeline, statistic_type, [seasonality], [data_completion], [aggregation])' },
    'FORECAST.LINEAR' : { 'Summary' : 'The Excel FORECAST function predicts a value based on existing values along a linear trend. FORECAST calculates future value predictions using linear regression, and can be used to predict numeric values like sales, inventory, expenses, measurements, etc.', 'Purpose' : 'Predict value along a linear trend', 'Return value' : 'Predicted value', 'Arguments' : 'x - The x value data point to use to calculate a prediction.known_ys - The dependent array or range of data (y values).kown_xs - The independent array or range of data (x values).', 'Syntax' : '=FORECAST.LINEAR(x, known_ys, kown_xs)' },
    'FREQUENCY' : { 'Summary' : 'The Excel FREQUENCY function returns a frequency distribution, which is a list that shows the frequency of values at given intervals. FREQUENCY returns multiple values and must be entered as an array formula with control-shift-enter, except in Excel 365.', 'Purpose' : 'Get the frequency of values in a data set', 'Return value' : 'A vertical array of frequencies', 'Arguments' : 'data_array - An array of values for which you want to get frequencies.bins_array - An array of intervals ("bins") for grouping values.', 'Syntax' : '=FREQUENCY(data_array, bins_array)' },
    'GEOMEAN' : { 'Summary' : 'The Excel GEOMEAN function returns the geometric mean for a set of numeric values. Geometric mean can be used to calculate average rate of return with variable rates.', 'Purpose' : 'Calculate geometric mean', 'Return value' : 'Calculated mean', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=GEOMEAN(number1, [number2], ...)' },
    'HARMEAN' : { 'Summary' : 'The Excel HARMEAN function returns the harmonic mean for a set of numeric values. The harmonic mean is the reciprocal of the arithmetic mean of reciprocals. Harmonic mean can be used to calculate a mean that reduces the impact of large outliers.', 'Purpose' : 'Calculate harmonic mean', 'Return value' : 'Calculated mean', 'Arguments' : 'number1 - First value or reference.number2 - [optional] Second value or reference.', 'Syntax' : '=HARMEAN(number1, [number2], ...)' },
    'INTERCEPT' : { 'Summary' : 'The Excel INTERCEPT function returns the point at which a regression line will intersect the y-axis based on known x and y values.', 'Purpose' : 'Get intercept of linear regression line', 'Return value' : 'y-axis intercept value', 'Arguments' : 'known_ys - An array or range of numeric data points (dependent values).known_xs - An array or range of numeric data points (independent values).', 'Syntax' : '=INTERCEPT(known_ys, known_xs)' },
    'LARGE' : { 'Summary' : 'The Excel LARGE function returns a numeric value based on its position in a list when sorted by value in descending order. In other words, LARGE can retrieve the "nth largest" value  1st largest value, 2nd largest value, 3rd largest value, etc.', 'Purpose' : 'Get nth largest value', 'Return value' : 'The nth largest value in an array.', 'Arguments' : 'array - An array or range of numeric values.k - Position as an integer, where 1 corresponds to the largest value.', 'Syntax' : '=LARGE(array, k)' },
    'LINEST' : { 'Summary' : 'The Excel LINEST function returns statistics for a best fit straight line through supplied x and y values. The values returned by LINEST include slope, intercept, standard error values, and more. To find the best fit of a line to the data, LINEST uses the "least squares" method.', 'Purpose' : 'Get parameters of linear trend', 'Return value' : 'Array of values', 'Arguments' : 'known_ys - An array or range of dependent y values values.known_xs - [optional] An array or range of independent x values.const - [optional] Boolean - normal or force the constant b to equal 0. Default is TRUE = normal calculation.stats - [optional] Boolean - return additional statistics. Default is FALSE = slope and intercept only.', 'Syntax' : '=LINEST(known_ys, [known_xs], [const], [stats])' },
    'MAX' : { 'Summary' : 'The Excel MAX function returns the largest numeric value in the data provided. MAX ignores empty cells, the logical values TRUE and FALSE, and text values.', 'Purpose' : 'Get the largest value', 'Return value' : 'The largest value in supplied data', 'Arguments' : 'number1 - Number, reference to numeric value, or range that contains numeric values.number2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MAX(number1, [number2], ...)' },
    'MAXA' : { 'Summary' : 'The Excel MAXA function returns the largest numeric value in a range of values. The MAXA function ignores empty cells, but evaluates the logical values TRUE and FALSE as 1 and 0, and evaluates text as zero.', 'Purpose' : 'Return largest value.', 'Return value' : 'Largest numeric value', 'Arguments' : 'value1 - Number, reference to numeric value, or range that contains numeric values.value2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MAXA(value1, [value2], ...)' },
    'MAXIFS' : { 'Summary' : 'The Excel MAXIFS function returns the largest numeric value that meets one or more criteria in a range of values. MAXIFS can be used with criteria based on dates, numbers, text, and other conditions. MAXIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get maximum value with criteria', 'Return value' : 'Maximum value', 'Arguments' : 'max_range - Range of values used to determine maximum.range1 - The first range to evaluate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=MAXIFS(max_range, range1, criteria1, [range2], [criteria2], ...)' },
    'MEDIAN' : { 'Summary' : 'The Excel MEDIAN function returns the median (middle number) in the supplied set of data. For example, =MEDIAN(1,2,3,4,5) returns 3.', 'Purpose' : 'Get the median of a group of numbers', 'Return value' : 'A number representing the median.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MEDIAN(number1, [number2], ...)' },
    'MIN' : { 'Summary' : 'The Excel MIN function returns the smallest numeric value in the data provided. The MIN function ignores empty cells, the logical values TRUE and FALSE, and text values.', 'Purpose' : 'Get the smallest value.', 'Return value' : 'The smallest value in supplied data', 'Arguments' : 'number1 - Number, reference to numeric value, or range that contains numeric values.number2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MIN(number1, [number2], ...)' },
    'MINA' : { 'Summary' : 'The Excel MINA function returns the smallest numeric value in a range of values. The MINA function ignores empty cells, but evaluates the logical values TRUE and FALSE as 1 and 0, and evaluates text as zero when these values appear in a range or cell reference.', 'Purpose' : 'Return smallest value.', 'Return value' : 'Smallest numeric value', 'Arguments' : 'value1 - Number, reference to numeric value, or range that contains numeric values.value2 - [optional] Number, reference to numeric value, or range that contains numeric values.', 'Syntax' : '=MINA(value1, [value2], ...)' },
    'MINIFS' : { 'Summary' : 'The Excel MINIFS function returns the smallest numeric value that meets one or more criteria in a range of values. MINIFS can be used with criteria based on dates, numbers, text, and other conditions. MINIFS supports logical operators (>,<,<>,=) and wildcards (*,?) for partial matching.', 'Purpose' : 'Get minimum value with criteria', 'Return value' : 'Minimim value', 'Arguments' : 'min_range - Range of values used to determine minimum.range1 - The first range to evaluate.criteria1 - The criteria to use on range1.range2 - [optional] The second range to evaluate.criteria2 - [optional] The criteria to use on range2.', 'Syntax' : '=MINIFS(min_range, range1, criteria1, [range2], [criteria2], ...)' },
    'MODE' : { 'Summary' : 'The Excel MODE function returns the most frequently occurring number in a numeric data set. For example, =MODE(1,2,4,4,5,5,5,6) returns 5.', 'Purpose' : 'Get most frequently occurring number', 'Return value' : 'A number representing the mode.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE(number1, [number2], ...)' },
    'MODE.MULT' : { 'Summary' : 'The Excel MODE.MULT function returns an array of the most frequently occurring numbers in a numeric data set. For example, =MODE.MULT(1,2,3,3,4,5,5) returns {3;5}, because there are two modes, 3 and 5.', 'Purpose' : 'Get most frequently occurring numbers', 'Return value' : 'Numbers representing mode(s)', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE.MULT(number1, [number2], ...)' },
    'MODE.SNGL' : { 'Summary' : 'The Excel MODE.SNGL function returns the most frequently occurring number in a numeric data set. For example, =MODE.SNGL(1,2,4,4,5,5,5,6) returns 5.', 'Purpose' : 'Get most frequently occurring number', 'Return value' : 'A number representing the mode.', 'Arguments' : 'number1 - A number or cell reference that refers to numeric values.number2 - [optional] A number or cell reference that refers to numeric values.', 'Syntax' : '=MODE.SNGL(number1, [number2], ...)' },
    'NORM.INV' : { 'Summary' : 'The Excel NORM.INV function returns the inverse of the normal cumulative distribution for the specified mean and standard deviation. Given the probability of an event occurring below a threshold value, the function returns the threshold value associated with the probability.', 'Purpose' : 'Get the inverse of normal cumulative distribution', 'Return value' : 'The threshold value associated with a probability', 'Arguments' : 'probability - The probability of an event occurring below a threshold.mean - The mean of the distribution.standard_dev - The standard deviation of the distribution.', 'Syntax' : '=NORM.INV(probability, mean, standard_dev)' },
    'NORM.S.DIST' : { 'Summary' : 'The Excel NORM.S.DIST function returns output for the standard normal cumulative distribution (CDF) and the standard normal probability density function (PDF).', 'Purpose' : 'Get the standard normal CDF and PDF.', 'Return value' : 'The standard normal cumulative distribution function', 'Arguments' : 'z - Numeric z-score value.cumulative - Logical value that determines the form of the function.', 'Syntax' : '=NORM.S.DIST(z, cumulative)' },
    'NORM.S.INV' : { 'Summary' : 'The Excel NORM.S.INV function returns the inverse of the standard normal cumulative distribution.', 'Purpose' : 'Get inverse of the standard normal cumulative distribution', 'Return value' : 'Returns the threshold value of a probability.', 'Arguments' : 'probability - A probability corresponding to the standard normal distribution.', 'Syntax' : '=NORM.S.INV(probability)' },
    'PERCENTILE' : { 'Summary' : 'The Excel PERCENTILE function calculates the "kth percentile" for a set of data. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - Number representing kth percentile.', 'Syntax' : '=PERCENTILE(array, k)' },
    'PERCENTILE.EXC' : { 'Summary' : 'The Excel PERCENTILE.EXC function calculates the "kth percentile" for a set of data where k is 0 to 1. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE.EXC to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - A value between 0 and 1 that represents the k:th percentile.', 'Syntax' : '=PERCENTILE.EXC(array, k)' },
    'PERCENTILE.INC' : { 'Summary' : 'The Excel PERCENTILE.INC function calculates the "kth percentile" for a set of data where k is 0 to 1, inclusive. A percentile is a value below which a given percentage of values in a data set fall. You can use PERCENTILE.INC to determine the 90th percentile, the 80th percentile, etc.', 'Purpose' : 'Get kth percentile', 'Return value' : 'Calculated percentile for k', 'Arguments' : 'array - Data values.k - Number representing kth percentile.', 'Syntax' : '=PERCENTILE.INC(array, k)' },
    'PERCENTRANK' : { 'Summary' : 'The Excel PERCENTRANK function returns the rank of a value in a data set as a percentage of the data set. You can use PERCENTRANK to find the relative standing of a value within a data set. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, inclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK(array, x, [significance])' },
    'PERCENTRANK.EXC' : { 'Summary' : 'The Excel PERCENTRANK.EXC function returns the relative rank of a value in a data set as a percentage representing how many values are less than or equal to the value. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, exclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK.EXC(array, x, [significance])' },
    'PERCENTRANK.INC' : { 'Summary' : 'The Excel PERCENTRANK.INC function returns the relative rank of a value in a data set as a percentage representing the number of values less than or equal to the value. Percentile rank is commonly used as a way to interpret standing in standardized tests.', 'Purpose' : 'Get percentile rank, inclusive', 'Return value' : 'Calculated rank as a decimal value', 'Arguments' : 'array - Array of data values.x - Value to rank.significance - [optional] Number of significant digits in result. Defaults to 3.', 'Syntax' : '=PERCENTRANK.INC(array, x, [significance])' },
    'PERMUT' : { 'Summary' : 'The Excel PERMUT function returns the number of permutations (combinations where order is significant) for a given number of items. The PERMUT function does not allow repetitions. To allow permutations with repetitions, use the PERMUTATIONA function.', 'Purpose' : 'Get number of permutations without repetitions', 'Return value' : 'Number of permutations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=PERMUT(number, number_chosen)' },
    'PERMUTATIONA' : { 'Summary' : 'The Excel PERMUTATIONA function returns the number of permutations (combinations where order is significant) for a given number of items. The PERMUTATIONA function allows repetitions. To calculate the number of permutations without repetitions, use the PERMUT function.', 'Purpose' : 'Get number of permutations with repetitions', 'Return value' : 'Number of permutations as an integer', 'Arguments' : 'number - The total number of items.number_chosen - The number of items in each combination.', 'Syntax' : '=PERMUTATIONA(number, number_chosen)' },
    'QUARTILE' : { 'Summary' : 'The Excel QUARTILE function returns the quartile (each of four equal groups) for a given set of data. QUARTILE can return minimum value, first quartile, second quartile, third quartile, and max value.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return.', 'Syntax' : '=QUARTILE(array, quart)' },
    'QUARTILE.EXC' : { 'Summary' : 'The Excel QUARTILE.EXC function returns the quartile for a given set of data. QUARTILE.EXC can return, first quartile, second quartile, and third quartile.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return, 1-3.', 'Syntax' : '=QUARTILE.EXC(array, quart)' },
    'QUARTILE.INC' : { 'Summary' : 'The Excel QUARTILE.INC function returns the quartile (each of four equal groups) for a given set of data. QUARTILE.INC can return minimum value, first quartile, second quartile, third quartile, and max value. Starting with Excel 2010, the QUARTILE.INC function replaces the QUARTILE function with the same behavior.', 'Purpose' : 'Get the quartile in a data set', 'Return value' : 'Value for requested quartile', 'Arguments' : 'array - A reference containing data to analyze.quart - The quartile value to return.', 'Syntax' : '=QUARTILE.INC(array, quart)' },
    'RANK' : { 'Summary' : 'The Excel RANK function returns the rank of a numeric value when compared to a list of other numeric values. RANK can rank values from largest to smallest (i.e. top sales) as well as smallest to largest (i.e. fastest time).', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - The range that contains numbers to rank against.order - [optional] Whether to rank in ascending or descending order.', 'Syntax' : '=RANK(number, ref, [order])' },
    'RANK.AVG' : { 'Summary' : 'The Excel RANK.AVG function returns the rank of a number against a list of other other numeric values. When values contain duplicates, the RANK.AVG function will assign an average rank to each set of duplicates.', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - An array that contains the numbers to rank against.order - [optional] Rank ascending or descending. Default is zero.', 'Syntax' : '=RANK.AVG(number, ref, [order])' },
    'RANK.EQ' : { 'Summary' : 'The Excel RANK.EQ function returns the rank of a number against a list of other other numeric values. When values contain duplicates, RANK.EQ will assign the higher rank to each set of duplicates.', 'Purpose' : 'Rank a number against a range of numbers', 'Return value' : 'A number that indicates rank.', 'Arguments' : 'number - The number to rank.ref - An array that contains the numbers to rank against.order - [optional] Rank ascending or descending. Default is zero.', 'Syntax' : '=RANK.EQ(number, ref, [order])' },
    'SKEW' : { 'Summary' : 'The Excel SKEW function returns the skewness of a distribution, which is a measure of symmetry. A positive result indicates a distribution that tails off to the right. A negative result indicates a distribution that tails off to the left. ', 'Purpose' : 'Get skewness of a distribution', 'Return value' : 'A positive or negative value', 'Arguments' : 'number1 - A range or reference that contains numeric values.number2 - [optional] A range or reference that contains numeric values.', 'Syntax' : '=SKEW(number1, [number2], ...)' },
    'SKEW.P' : { 'Summary' : 'The Excel SKEW.P function returns the skewness of a distribution, which is a measure of symmetry. A positive result indicates a distribution that tails off to the right. A negative result indicates a distribution that tails off to the left. ', 'Purpose' : 'Get skewness of a distribution based on population', 'Return value' : 'A positive or negative value', 'Arguments' : 'number1 - A range or reference that contains numeric values.number2 - [optional] A range or reference that contains numeric values.', 'Syntax' : '=SKEW.P(number1, [number2], ...)' },
    'SLOPE' : { 'Summary' : 'The Excel SLOPE function returns the slope of a regression line based on known y values and known x values. A regression line is a "best fit" line based on known data points.', 'Purpose' : 'Get slope of linear regression line', 'Return value' : 'Calculated slope as a number', 'Arguments' : 'known_ys - An array or range of numeric data points (dependent values).known_xs - An array or range of numeric data points (independent values).', 'Syntax' : '=SLOPE(known_ys, known_xs)' },
    'SMALL' : { 'Summary' : 'The Excel SMALL function returns a numeric value based on its position in a list when sorted by value in ascending order. In other words, SMALL can return the "nth smallest" value (1st smallest value, 2nd smallest value, 3rd smallest value, etc.) from a set of numeric data.', 'Purpose' : 'Get nth smallest value', 'Return value' : 'The nth smallest value in the array.', 'Arguments' : 'array - An array or range of numeric values.k - Position as an integer, where 1 corresponds to the smallest value.', 'Syntax' : '=SMALL(array, k)' },
    'STANDARDIZE' : { 'Summary' : 'The Excel STANDARDIZE function returns a normalized value (z-score) based on the mean and standard deviation.', 'Purpose' : 'Calculate a normalized value (z-score)', 'Return value' : 'Normalized value', 'Arguments' : 'x - The value to normalize.mean - The arithmetic mean of the distribution.standard_dev - The standard deviation of the distribution.', 'Syntax' : '=STANDARDIZE(x, mean, standard_dev)' },
    'STDEV' : { 'Summary' : 'The Excel STDEV function returns the standard deviation for data that represents a sample. To calculate the standard deviation for an entire population, use STDEVP or STDEV.P.', 'Purpose' : 'Get the standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV(number1, [number2], ...)' },
    'STDEV.P' : { 'Summary' : 'The Excel STDEV.P function calculates the standard deviation for a sample set of data. STDEV.P calculates standard deviation using the "n" method, ignoring logical values and text.', 'Purpose' : 'Get standard deviation of population', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV.P(number1, [number2], ...)' },
    'STDEV.S' : { 'Summary' : 'The Excel STDEV.S function calculates the standard deviation for a sample set of data. STDEV.S replaces the older STDEV function, with the same behavior.', 'Purpose' : 'Get the standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEV.S(number1, [number2], ...)' },
    'STDEVA' : { 'Summary' : 'The Excel STDEVA function calculates standard deviation for a sample of data. Unlike the STDEV function, STDEVA will evaluate text and logicals that appear in references. To calculate standard deviation for an entire population, use STDEVPA or STDEV.P.', 'Purpose' : 'Get standard deviation in a sample', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVA(number1, [number2], ...)' },
    'STDEVP' : { 'Summary' : 'The STDEVP function calculates the standard deviation for data that represents a population. STDEVP has been replaced with a newer function called STDEV.P, which has the same behavior.', 'Purpose' : 'Get standard deviation of population', 'Return value' : 'Estimated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVP(number1, [number2], ...)' },
    'STDEVPA' : { 'Summary' : 'The Excel STDEVPA function calculates the standard deviation for an entire population. Unlike the STDEVP function, STDEVPA evaluates text and logicals that appear in references. To calculate standard deviation for a sample, use STDEVA or STDEV.S.', 'Purpose' : 'Get standard deviation for a population', 'Return value' : 'Calculated standard deviation', 'Arguments' : 'number1 - First number or reference in the sample.number2 - [optional] Second number or reference.', 'Syntax' : '=STDEVPA(number1, [number2], ...)' },
    'TRIMMEAN' : { 'Summary' : 'The Excel TRIMMEAN function calculates mean (average) while excluding outliers. The number of data points to exclude is provided as a percentage.', 'Purpose' : 'Calculate mean excluding outliers', 'Return value' : 'Calculated mean', 'Arguments' : 'array - Values to trim and average.percent - The number of data points to exclude from the calculation.', 'Syntax' : '=TRIMMEAN(array, percent)' },
    'VAR' : { 'Summary' : 'The Excel VAR function estimates the variance of a sample of data. If data represents the entire population, use the VARP function or the newer VAR.P function. VAR ignores text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR(number1, [number2], ...)' },
    'VAR.P' : { 'Summary' : 'The Excel VAR.P function returns the variance in an entire population. If data represents a sample of the population, use the VAR.S function.', 'Purpose' : 'Get variation of population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR.P(number1, [number2], ...)' },
    'VAR.S' : { 'Summary' : 'The Excel VAR.S function returns the variance of a sample. If data represents the entire population, use the VAR.P function. VAR.S ignores text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VAR.S(number1, [number2], ...)' },
    'VARA' : { 'Summary' : 'The Excel VARA function estimates the variance of a sample of data. Unlike the VAR function, the VARA function evaluates text values and logicals in references.', 'Purpose' : 'Get variation of a sample', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARA(number1, [number2], ...)' },
    'VARP' : { 'Summary' : 'The Excel VARP function calculates the variance of an entire population of data. If data represents a sample, use the VAR function or the newer VAR.S function. VARP ignores text values and logicals in references.', 'Purpose' : 'Get variation of a population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARP(number1, [number2], ...)' },
    'VARPA' : { 'Summary' : 'The Excel VARPA function computes the variance of a population of data. Unlike the VARP function, the VARPA function evaluates text values and logicals in references.', 'Purpose' : 'Get variation of a population', 'Return value' : 'Computed variance', 'Arguments' : 'number1 - First number or reference.number2 - [optional] Second number or reference.', 'Syntax' : '=VARPA(number1, [number2], ...)' },
    'ENCODEURL' : { 'Summary' : 'The Excel ENCODEURL function returns a URL-encoded string composed of US-ASCII characters. ENCODEURL is only available in Excel 2013 and later on Windows.', 'Purpose' : 'Get URL-encoded string', 'Return value' : 'Encoded text', 'Arguments' : 'text - The text to be encoded.', 'Syntax' : '=ENCODEURL(text)' },
    'FILTERXML' : { 'Summary' : 'The Excel FILTERXML function returns specific data from XML text using the specified XPath expression.', 'Purpose' : 'Get data from XML with Xpath', 'Return value' : 'Matching data as text', 'Arguments' : 'xml - Valid XML as a text string.xpath - A valid Xpath expression as a text string.', 'Syntax' : '=FILTERXML(xml, xpath)' },
    'DAVERAGE' : { 'Summary' : 'The Excel DAVERAGE function returns the average in a given field for records that match criteria. ', 'Purpose' : 'Get average from matching records', 'Return value' : 'The average value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DAVERAGE(database, field, criteria)' },
    'DCOUNT' : { 'Summary' : 'The Excel DCOUNT function counts matching records in a database using criteria and an optional field. When a field is provided DCOUNT will only count numeric values in the field. Use DCOUNTA to count numbers or text values in a given field.', 'Purpose' : 'Count matching records in a database', 'Return value' : 'Numeric count of matching records', 'Arguments' : 'database - Database range including headers.field - [optional] Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DCOUNT(database, [field], criteria)' },
    'DCOUNTA' : { 'Summary' : 'The Excel DCOUNTA function counts matching records in a database using criteria and an optional field. When a field is provided, DCOUNTA counts both numeric and text values when the field value is not empty. Use DCOUNT to count only numeric values in a given field.', 'Purpose' : 'Count matching records in a database', 'Return value' : 'Numeric count of matching records', 'Arguments' : 'database - Database range including headers.field - [optional] Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DCOUNTA(database, [field], criteria)' },
    'DGET' : { 'Summary' : 'The Excel DGET function gets a single value in a given field from a record that matches criteria. DGET will throw the #NUM error if more than one record matches criteria.', 'Purpose' : 'Get value from matching record', 'Return value' : 'The value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DGET(database, field, criteria)' },
    'DMAX' : { 'Summary' : 'The Excel DMAX function returns the maximum value in a field, from a set of records that match criteria. Use the DMIN function to get the minimum value.', 'Purpose' : 'Get max from matching records', 'Return value' : 'The maximum value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DMAX(database, field, criteria)' },
    'DMIN' : { 'Summary' : 'The Excel DMIN function returns the minimum value in a field, from a set of records that match criteria. Use the MAX function to get the maximum value.', 'Purpose' : 'Get min from matching records', 'Return value' : 'The minimum value in a given field', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DMIN(database, field, criteria)' },
    'DPRODUCT' : { 'Summary' : 'The Excel DPRODUCT function returns the product of values from a set of records that match criteria. The values to multiply are extracted from a given field in the database, specified as an argument.', 'Purpose' : 'Get product from matching records', 'Return value' : 'The calculated product', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DPRODUCT(database, field, criteria)' },
    'DSTDEV' : { 'Summary' : 'The Excel DSTDEV function returns the standard deviation of sample data extracted from records that match the given criteria. If data represents the entire population, use the DSTDEVP function.', 'Purpose' : 'Get standard deviation of sample in matching records', 'Return value' : 'The calculated standard deviation', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSTDEV(database, field, criteria)' },
    'DSTDEVP' : { 'Summary' : 'The Excel DSTDEVP function returns the standard deviation for an entire population of data extracted from records that match the given criteria. If data represents the entire population, use the DSTDEVP function.', 'Purpose' : 'Get standard deviation of population in matching records', 'Return value' : 'The calculated standard deviation', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSTDEVP(database, field, criteria)' },
    'DSUM' : { 'Summary' : 'The Excel DSUM function returns the sum of values from a set of records that match criteria. The values to sum are extracted from a given field in the database.', 'Purpose' : 'Get sum from matching records', 'Return value' : 'The calculated sum', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DSUM(database, field, criteria)' },
    'DVAR' : { 'Summary' : 'The Excel DVAR function returns the variance of a sample extracted from records that match the given criteria. If data represents the entire population, use the DVARP function.', 'Purpose' : 'Get sample variance for matching records', 'Return value' : 'The calculated variance', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DVAR(database, field, criteria)' },
    'DVARP' : { 'Summary' : 'The Excel DVARP function returns the variance of an entire population extracted from records that match given criteria. If data represents the a sample only, use the DVAR function.', 'Purpose' : 'Get population variance for matching records', 'Return value' : 'The calculated variance', 'Arguments' : 'database - Database range including headers.field - Field name or index to count.criteria - Criteria range including headers.', 'Syntax' : '=DVARP(database, field, criteria)' },
    }


    if detail=="['Summary','Purpose','Return value','Arguments','Syntax']":
        a =  fun[funcName.upper()]
        return  json.dumps(a, indent=4)

    else:
        try:
            a =  fun[funcName.upper()][detail.capitalize()]
            return  json.dumps(a, indent=4)
        
        except:
            print("Invalid Detail : try as detail ['Summary','Purpose','Return value','Arguments','Syntax']")

def barakhadi():
    """Print all hindi barakhadi"""
    try:
        from prettytable import PrettyTable
    except:
        import os 
        os.system("pip install prettytable")
        from prettytable import PrettyTable

    vowels = ["A", "a", "i", "ee", "u", "oo", "e", "ai", "o", "au", "am", "an"]
    table = PrettyTable( vowels )
    letters = ["k", "kh", "g", "gh", "ch", "chh", "j", "jh", "t", "th", "d", "d", "n", "t", "th", "d", "dh", "n", "p", "ph", "b", "bh", "m", "y", "r", "l", "w", "sh", "sh", "s", "h", "ksh", "gy"]
    for char in letters:
        list = []
        for i in vowels:
            list.append( char + i )
        table.add_row( list )
    barakhadi = str( table ).upper() 
    return barakhadi

def tables(Start_point,End_point):
    """Print Tables from starting point to end point"""
    try:
        from prettytable import PrettyTable
    except:
        import os 
        os.system("pip install prettytable")
        from prettytable import PrettyTable
    nums = [i for i in range(Start_point,End_point+1)]
    myTable = PrettyTable(nums)
    for i in range(1,11):
        list = []
        for j in nums:
            list.append(i * j)
        myTable.add_row(list)
    return myTable

def romanToDecimal(romanNumeral):
    """Roman value to decimal value"""
    romanNumeral = romanNumeral.upper()
    tallies = {'I': 1, 'V': 5, 'X': 10, 'L': 50, 'C': 100, 'D': 500, 'M': 1000}
    sum = 0
    for i in range(len(romanNumeral) - 1):
        left = romanNumeral[i]
        right = romanNumeral[i + 1]
        if tallies[left] < tallies[right]:
            sum -= tallies[left]
        else:
            sum += tallies[left]
    sum += tallies[romanNumeral[-1]]
    return sum

def textAnalyse(text):
    """Text analyse returns the dictionary of every char how many percentage of string taking"""
    dictionary = {}
    def count_char(text, char):
        count = 0
        for c in text:
            if c == char:
                count +=1
        return count
    text = text.lower()
    for char in "abcdefghijklmnopqrstuvwxyz":
        percent = 100 * count_char(text, char)/len(text)
        per = round(percent,2)
        if(per != 00.00):
            dictionary.update({f"{char}": f"{per}%"})
    return dictionary

def mean(word):
    wordsDic = {"abandoned industrial site": ["Site that cannot be used for any purpose, being contaminated by pollutants."], "abandoned vehicle": ["A vehicle that has been discarded in the environment, urban or otherwise, often found wrecked, destroyed, damaged or with a major component part stolen or missing."], "abiotic factor": ["Physical, chemical and other non-living environmental factor."], "access road": ["Any street or narrow stretch of paved surface that leads to a specific destination, such as a main highway."], "access to the sea": ["The ability to bring goods to and from a port that is able to harbor sea faring vessels."], "accident": ["An unexpected, unfortunate mishap, failure or loss with the potential for harming human life, property or the environment.", "An event that happens suddenly or by chance without an apparent cause."], "accumulator": ["A rechargeable device for storing electrical energy in the form of chemical energy, consisting of one or more separate secondary cells.\\n(Source: CED)"], "acidification": ["Addition of an acid to a solution until the pH falls below 7."], "acidity": ["The state of being acid that is of being capable of transferring a hydrogen ion in solution."], "acidity degree": ["The amount of acid present in a solution, often expressed in terms of pH."], "acid rain": ["Rain having a pH less than 5.6."], "acid": ["A compound capable of transferring a hydrogen ion in solution.", "Being harsh or corrosive in tone.", "Having an acid, sharp or tangy taste.", "A powerful hallucinogenic drug manufactured from lysergic acid.", "Having a pH less than 7, or being sour, or having the strength to neutralize  alkalis, or turning a litmus paper red."], "acoustic filter": ["A device employed to reject sound in a particular range of frequencies while passing sound in another range of frequencies."], "acoustic insulation": ["The process of preventing the transmission of sound by surrounding with a nonconducting material."], "acoustic level": ["Physical quantity of sound measured, usually expressed in decibels.\\n(Source: KORENa)"], "acoustic property": ["The characteristics found within a structure that determine the quality of sound in its relevance to hearing.\\n(Source: KOREN)"], "acoustics": ["The science of the production, transmission and effects of sound."], "actinide": ["An element member of the actinide group of 15 radioactive elements."], "actinium": ["A radioactive element of the actinide series, occurring as a decay product of uranium. It is used as an alpha particle source and in neutron production.\\n(Source: CED)"], "action group": ["A collection of persons united to address specific sociopolitical or socioeconomic concerns."], "activated carbon": ["A powdered, granular or pelleted form of amorphous carbon characterized by a very large surface area per unit volume because of an enormous number of fine pores.\\n(Source: LANDY)"], "activated sludge": ["Sludge that has been aerated and subjected to bacterial action; used to speed breakdown of organism matter in raw sewage during secondary waste treatment.\\n(Source: LANDY)"], "act": ["Something done voluntarily by a person, and of such a nature that certain legal consequences attach to it.", "Legal documents, decrees, edicts, laws, judgments, etc.", "To do something.", "To perform a theatrical role."], "adaptable species": ["Species capable of adapting to changing circumstances."], "chemical addition": ["Chemical reaction in which one or more of the double bonds or triple bonds in an unsaturated compound is converted to a single bond by the addition of other atoms or groups."], "additional packaging": ["Additional packaging around the normal sales packaging, for example as protection against theft or for the purpose of advertising."], "addition polymer": ["A polymer formed by the chain addition of unsaturated monomer molecules, such as olefins, with one another without the formation of a by-product, as water; examples are polyethylene, polypropylene and polystyrene."], "additive": ["A substance mixed in small quantities with another product to modify its chemical or physical state, for example to make food look visually more attractive.", "Proper to be added."], "adhesive": ["Substance used for sticking objects together."], "acceptable daily intake": ["The measurement of the amount of any chemical substance that can be safely consumed by a human being in a day. Calculations are usually based on the maximum level of a substance that can be fed to animals without producing any harmful effects. This is divided by a \"safety factor\" to allow for the differences between animals and humans and to take account of the variation in human diets."], "administration": ["The management or direction of the affairs of a public or private office, business or organization."], "administrative body": ["Any governmental agency or organization charged with managing and implementing regulations, laws and government policies.\\n(Source: BLD)", "All representatives in a company that have the assignment to administrate the company itself."], "administrative competence": ["The power of an administrative organ to exercise control over a certain field."], "administrative fiat": ["An authoritative decree, sanction or order issued from an office with executive or managerial authority, without necessarily having the force of law or its equivalent.\\n(Source: RHW / BLD)"], "administrative jurisdiction": ["The extent, power or territory in which an office with executive or managerial authority administers justice or declares judgments.\\n(Source: RHW / BLD)"], "administrative law": ["Body of law created by administrative agencies in the form of rules, regulations, orders and decisions to carry out regulatory powers and duties of such agencies.\\n(Source: BLACK)"], "administrative sanction": ["Any formal official imposition of penalty or fine, e.g.: destruction, taking, seizure, or withholding of property; assessment of damages, reimbursement, restitution, compensation, costs, charges or fees; requirement, revocation or suspension of license; or any other compulsory or restrictive action taken by an organization, agency or its representative."], "adsorption": ["The physical or chemical bonding of molecules of gas, liquid or a dissolved substance to the external surface of a solid or the internal surface, if the material is porous, in a very thin layer."], "adult": ["A person who is fully grown, developed or of a specified age.", "(of animals) fully developed."], "adult education": ["Any instruction or training, informal or formal, which is geared to persons of mature age, regardless of previous education, and typically offered by university extension programs, employers, correspondence courses or community groups."], "advertisement": ["The action of drawing public attention to goods, services or events, often through paid announcements in newspapers, magazines, television or radio.\\n(Source: C / RHW)"], "product advertising": ["The creation and dissemination of paid announcements or public notices to draw attention to goods, services or events offered by some entity, usually for purchase.\\n(Source: RHW)"], "advice": ["Official notice, opinion, counsel or recommendation that is optional or at the receiver's discretion."], "aeration": ["Exposition to the action of air."], "aerial photograph": ["An image of the ground surface made on a light-sensitive material and taken at a high altitude from an aircraft, spacecraft or rocket.\\n(Source: MHD)"], "aerobic process": ["A process requiring the presence of oxygen."], "aerobiology": ["The study of the atmospheric dispersal of airborne fungus spores, pollen grains, and microorganisms; and, more broadly, of airborne propagules of algae and protozoans, minute insects such as aphids, and pollution gases and particles which exert specific biologic effects."], "aerodynamic noise": ["Acoustic noise caused by turbulent airflow over the surface of a body."], "aerosol": ["A gaseous suspension of ultramicroscopic particles of a liquid or a solid.\\n(Source: MGH)", "An aerosol can for applying paint, deodorant, etc., as a fine spray."], "afforestation": ["Establishment of a new forest by seeding or planting of nonforested land.", "The planting of trees on land which was previously used for other uses than forestry.", "The planting of trees in an area, or the management of an area to allow trees to regenerate or colonize naturally, in order to produce a forest."], "Africa": ["The second largest of the continents, on the Mediterranean in the north, the Atlantic in the west, and the Red Sea, Gulf of Aden, and Indian Ocean in the east."], "afterburning": ["The incineration of polluting gases and particles resulting from incompletely combusted fuel, and the breakdown of other molecules associated with combustion into inert chemicals."], "age": ["The period of time that a person, animal or plant has lived or is expected to live.", "To begin to look older; to get older.", "To make older.", "A period of history having some distinctive feature.", "How long something has existed."], "agricultural biotechnology": ["An advanced technology that allows plant breeders to make precise genetic changes to impart beneficial traits to crop plants."], "agricultural building": ["The buildings and adjacent service areas of a farm.\\n(Source: WEBSTE)"], "agricultural ecology": ["Study of the ecology of agricultural systems and the natural resources required to sustain them."], "agricultural economics": ["An applied social science that deals with the production, distribution, and consumption of agricultural or farming goods and services."], "agricultural engineering": ["A discipline concerned with developing and improving the means for providing food and fiber for mankind's needs.\\n(Source: MGH)"], "agricultural equipment": ["Machines utilized for tillage, planting, cultivation and harvesting of crops. Despite its benefits in increasing yields, mechanisation has clearly had some adverse environmental effects: deep ploughing exposes more soil to wind and water erosion; crop residues can be removed as opposed to ploughing back into the soil; removal of residues can lead to a serious loss of organic content in the soil, which may increase the risk of soil erosion.\\n(Source: MGH /  DOBRIS)"], "agricultural machinery": ["Machines utilized for tillage, planting, cultivation and harvesting of crops. Despite its benefits in increasing yields, mechanisation has clearly had some adverse environmental effects: deep ploughing exposes more soil to wind and water erosion; crop residues can be removed as opposed to ploughing back into the soil; removal of residues can lead to a serious loss of organic content in the soil, which may increase the risk of soil erosion.\\n(Source: MGH /  DOBRIS)"], "agricultural management": ["The administration or handling of soil, crops and livestock."], "agricultural pest": ["Insects and mites that damage crops, weeds that compete with field crops for nutrients and water, plants that choke irrigation channels or drainage systems, rodents that eat young plants and grain, and birds that eat seedlings or stored foodstuffs.\\n(Source: WRIGHT)"], "agricultural policy": ["A course of action adopted by government or some other organization that determines how to deal with matters involving the cultivation of land; raising crops; feeding, breeding and raising livestock or poultry; and other farming issues.\\n(Source: RHW)"], "agricultural production": ["The amount of grown crops and breeded livestock per year in a given area."], "agriculture": ["The production of plants and animals useful to man, involving soil cultivation and the breeding and management of crops and livestock."], "agrochemical": ["Any substance or mixture of substances used or intended to be used for preventing, destroying, repelling, attracting, inhibiting, or controlling any insects, rodents, birds, nematodes, bacteria, fungi, weeds or other forms of plant, animal or microbial life regarded as pests."], "agroforestry": ["The interplanting of farm crops and trees, especially leguminous species. In semiarid regions and on denuded hillsides, agroforestry helps control erosion and restores soil fertility, as well as supplying valuable food and commodities at the same time.\\n(Source: ALL)"], "agroindustry": ["Industry dealing with the supply, processing and distribution of farm products.\\n(Source: PHC)"], "agrometeorology": ["The study of the interaction between meteorological and hydrological factors, on the one hand, and agriculture in the widest sense, including horticulture, animal husbandry and forestry, on the other.\\n(Source: EURMET)"], "AIDS": ["A disease of the human immune system caused by the human immunodeficiency virus (HIV)."], "air": ["A predominantly mechanical mixture of a variety of individual gases forming the earth's enveloping atmosphere.", "To expose to fresh air.", "To send data over the airwaves, as in radio or television.", "An expression or appearance indicating a certain state of mind.", "A succession of notes forming a distinctive sequence.", "The space above the earth's surface where planes fly.", "To expose to cool or cold air so as to cool or freshen."], "air conditioning": ["A system or process for controlling the temperature and sometimes the humidity and purity of the air in a house, etc."], "aircraft": ["A vehicle, designed to be supported by the air, either by the dynamic action of the air upon the surfaces of the structure or object or by its own buoyancy.\\n(Source: MGH)"], "aircraft noise": ["Noise caused by various sources associated with aircraft operation, such as propeller and engine exhaust, jet noise, and sonic boom."], "air movement": ["Air movements within the Earth's atmospheric circulation; also called planetary winds. Two main components are recognized: first, the latitudinal meridional component due to the Coriolis force (a deflecting motion or force discussed by G.G. de Coriolis in 1835. The rotation of the Earth causes a body moving across its surface to be deflected to the right in the N hemisphere and to the left in the S hemisphere); and secondly, the longitudinal component and the vertical movement, resulting largely from varying pressure distributions due to differential heating and cooling of the Earth's surface.\\n(Source: WHIT)"], "air pollutant": ["Any pollutant agent or combination of such agents, including any physical, chemical, biological, radioactive substance or matter which is emitted into or otherwise enters the ambient air and can, in high enough concentrations, harm humans, animals, vegetation or material.\\n(Source: LEE /  TOE)"], "air pollution": ["Presence in the atmosphere of large quantities of gases, solids and radiation produced by the burning of natural and artificial fuels, chemical and other industrial processes and nuclear explosions."], "airport": ["A landing and taking-off area for civil aircraft, usually with surfaced runways and aircraft maintenance and passenger facilities."], "air quality": ["The degree to which air is polluted; the type and maximum concentration of man-produced pollutants that should be permitted in the atmosphere.\\n(Source: ALL /  WRIGHT)"], "air quality control": ["The measurement of ambient air-pollution concentrations in order to determine whether there is a problem in a given region.\\n(Source: CONFERa)"], "air safety": ["Any measure, technique or design intended to reduce the risk of harm posed by either moving vehicles or projectiles above the earth's surface or pollutants to the earth's atmosphere."], "air temperature": ["The temperature of the atmosphere which represents the average kinetic energy of the molecular motion in a small region and is defined in terms of a standard or calibrated thermometer in thermal equilibrium with the air."], "air traffic": ["Aircraft moving in flight or on airport runways."], "air traffic law": ["International rules and conventions relating to air transportation."], "air traffic regulation": ["Rules and regulations that govern civil and military air traffic."], "air transportation": ["The use of aircraft, predominantly airplanes, to move passengers and cargo."], "alarm": ["The act of signalling an impending danger in order to call attention to some event or condition.", "A signal given to call attention to some event or condition which may be an impending danger."], "alcohol": ["A group of organic chemical compounds composed of carbon, hydrogen, and oxygen. The molecules in the series vary in chain length and are composed of a hydrocarbon plus a hydroxyl group. Alcohol includes methanol and ethanol.\\n(Source: EIADOE)", "A flammable, colorless liquid which is used amongst others as solvent, disinfectant and intoxicant.", "A drink (a liquor or brew) containing ethanol, commonly known as alcohol."], "alga": ["Simple, green, aquatic plants without stems, roots or leaves. They are found floating in the sea and fresh water, but they also grow on the surface of damp walls, rocks, the bark of trees and on soil.\\n(Source: WRIGHT)"], "algal bloom": ["Excessive and rapid growth of algae and other aquatic plants. It takes place when there are too many nutrients in the water through pollution from agricultural areas, i.e. higher levels of nitrogen and phosphates."], "algicide": ["Any substance or chemical applied to kill or control algal growth."], "alicyclic compound": ["Any substance composed of two or more unlike atoms held together by chemical bonds characterized by straight-chained, branched or cyclic properties."], "alicyclic hydrocarbon": ["A class of organic compounds containing only carbon and hydrogen atoms joined to form one or more rings and having the properties of both aliphatic and cyclic substances.\\n(Source: MGH /  RRDA)"], "aliphatic compound": ["Any organic compound of hydrogen and carbon characterized by a straight chain of the carbon atoms.\\n(Source: MGH)"], "aliphatic hydrocarbon": ["Hydrocarbons having an open chain of carbon atoms, whether normal or forked, saturated or unsaturated.\\n(Source: MGH)"], "alkali land": ["Any geomorphic area, often a level lake-like plain, with soil containing a high percentage of mineral salts, located especially in arid regions.\\n(Source: MHD / RHW)"], "alkali soil": ["Soil that contains sufficient exchangeable sodium to interfere with water penetration and crop growth, either with or without appreciable quantities of soluble salts.\\n(Source: LANDY)"], "alkane": ["Paraffins. A homologous series of saturated hydrocarbons having the general formula CnH2n+2. Their systematic names end in -ane. They are chemically inert, stable, and flammable. The first four members of the series (methane, ethane, propane, butane) are gases at ordinary temperatures; the next eleven are liquids, and form the main constituents of paraffin oil; the higher members are solids. Paraffin waxs consists mainly of higher alkanes.\\n(Source: UVAROV)", "Member of the homologous series of saturated hydrocarbons having the general formula CnH2n+2."], "alkyl compound": ["Compound containing one or more alkyl radicals."], "allergen": ["Any antigen, such as pollen, a drug, or food, that induces an allergic state in humans or animals.\\n(Source: MGH)"], "allergy": ["A condition of abnormal sensitivity in certain individuals to contact with substances such as proteins, pollens, bacteria, and certain foods. This contact may result in exaggerated physiologic responses such as hay fever, asthma, and in severe enough situations, anaphylactic shock.\\n(Source: KOREN)"], "allocation": ["The assignment or allotment of resources to various uses in accord with a stated goal or policy.\\n(Source: ODE)"], "alloy": ["Any of a large number of substances having metallic properties and consisting of two or more elements; with few exceptions, the components are usually metallic elements."], "alluvion": ["An overflowing; an inundation or flood, especially when the water is charged with much suspended material.\\n(Source: BJGEO)"], "alpha radiation": ["A stream of alpha particles which are ejected from many radioactive substances having a penetrating power of a few cm in air but can be stopped by a thin piece of paper."], "alternative technology": ["Technology that aims to utilize resources sparingly, with minimum damage to the environment."], "alumina": ["A natural or synthetic oxide of aluminum widely distributed in nature, often found as a constituent part of clays, feldspars, micas and other minerals, and as a major component of bauxite."], "alveolus": ["A tiny, thin-walled, capillary-rich sac in the lungs where the exchange of oxygen and carbon dioxide takes place."], "amalgam": ["A solution of a metal in mercury."], "Americas": ["Continent which extends on a great part of the Occidental Hemisphere of the Earth, from the Artic Ocean in the North, to the Cape Horn in the South at the confluence of the Atlantic and Pacific Oceans, which delimits the continent on the East and West respectively."], "Ames test": ["A bioassay developed by Bruce N. Ames in 1974, performed on bacteria to assess the capability of environmental chemicals to cause mutations."], "amine": ["One of a class of organic compounds which can be considered to be derived from ammonia by replacement of one or more hydrogens by organic radicals.\\n(Source: MGH)"], "amino acid": ["Organic compounds containing a carboxyl group (-COOH) and an amino group (-NH2). About 30 amino acids are known. They are fundamental constituents of living matter because protein molecules are made up of many amino acid molecules combined together. Amino acids are synthesized by green plants and some bacteria, but some (arginine, histidine, lysine. threonine, methionine, isoleucine, leucine, valine, phenylalanine, tryptophane) cannot be synthesized by animals and therefore are essential constituents of their diet. Proteins from specific plants may lack certain amino acids, so a vegetarian diet must include a wide range of plant products.\\n(Source: ALL)"], "ammonia": ["A colorless gaseous alkaline compound that is very soluble in water, has a characteristic pungent odour, is lighter than air, and is formed as a result of the decomposition of most nitrogenous organic material."], "ammonification": ["Addition of ammonia or ammonia compounds, especially to the soil."], "ammonium": ["A positively charged polyatomic cation of the chemical formula NH4+ formed by protonation of ammonia (NH3)."], "amphibian": ["A class of vertebrate animals characterized by a moist, glandular skin, gills at some stage of development, and no amnion during the embryonic stage.\\n(Source: MGH)"], "amusement park": ["An open-air entertainment area consisting of stalls, side shows etc.\\n(Source: CED)"], "analysis": ["The mathematical study of functions, sequences, series, limits, derivatives and integrals."], "analytical chemistry": ["The branch of chemistry dealing with techniques which yield any type of information about chemical systems.\\n(Source: MGH)"], "analytical method": ["Method to analyse the performance of a process or system."], "anatomy": ["The science concerned with the physical structure of animals and plants."], "angiosperm": ["The division of seed plants that includes all the flowering plants, characterized by the possession of flowers. The ovules, which become seeds after fertilization, are enclosed in ovaries. The xylem contains true vessels. The angiospermae are divided into two subclasses: Monocotyledoneae and Dycotiledoneae.\\n(Source: ALL)"], "angling": ["The art or sport of catching fish with a rod and line and a baited hook or other lure, such as a fly."], "animal disease": ["A disease that is mainly found in certain animals (and not in plants or humans)."], "animal ecology": ["A study of the relationships of animals to their environment.\\n(Source: MGH)"], "animal experiment": ["Investigation carried out in animals for research purposes."], "animal genetics": ["The scientific study of the hereditary material of animals for theoretical and practical applications such as increased population, conservation and disease research.\\n(Source: EEN)"], "animal housing": ["Any kind of shelter, refuge affording protection to animals."], "animal husbandry": ["A branch of agriculture concerned with the breeding and feeding of domestic animals.\\n(Source: MGH)"], "animal manure": ["Animal excreta collected from stables and barnyards with or without litter; used to enrich the soil.\\n(Source: MGH)"], "animal noise": ["Noise caused by animals such as dogs kept in kennels or in private homes as pets."], "animal nutrition": ["Ingestion, digestion and/or assimilation of food by animals."], "animal physiology": ["Study of the normal processes and metabolic functions of animal organisms.\\n(Source: LBC)"], "animal protection": ["Precautionary actions or procedures taken to prevent or reduce the harm to sentient, non-human species, posed, in most cases, by humans."], "animal for slaughter": ["Animals bred and killed for the production of food."], "animal shelter": ["A protection providing housing for animals in bad weather. (Source: RRDA)", "A facility that houses homeless, lost or abandoned animals; primarily a large variety of dogs and cats and other animals used as pets."], "animal": ["Any living organism characterized by voluntary movement, the possession of cells with noncellulose cell walls and specialized sense organs enabling rapid response to stimuli, and the ingestion of complex organic substances such as plants and other animals.", "Any living organism of the Animalia reign except human", "Of or relating to animals."], "animal trade": ["The process or act of exchanging, buying or selling animals, especially livestock."], "anion": ["An ion that is negatively charged."], "annelid": ["An animal member of the phylum Annelida."], "antagonism": ["The situation in which two chemicals upon interaction interfere in such a way that the action of one partially or completely inhibits the effects of the other."], "Antarctica": ["A continent lying chiefly within the Antarctic Circle and asymmetrically centered on the South Pole."], "Antarctic ecosystem": ["The ecosystem of the antarctic region of planet Earth."], "Antarctic Ocean": ["The waters, including ice shelves, that surround the continent of Antarctica, which comprise the southernmost parts of the Pacific, Atlantic and Indian oceans, and also the Ross, Amundsen, Bellingshausen and Weddell seas."], "Antarctic region": ["An area within the Antarctic Circle that includes the fifth largest continent and its surrounding waters, consisting mostly of thick ice shelves.\\n(Source: INP / CIA)"], "anthropic activity": ["Action resulting from or influenced by human activity or intervention."], "anthropologic reserve": ["Area of protection of the life style of societies where traditional human activities are still maintained and the exploitation of natural resources is still carried out without compromising the future availability."], "antibiotic": ["A chemical substance, produced by microorganisms and synthetically, that has the capacity to inhibit the growth of, and even to destroy, bacteria and other microorganisms."], "antibody": ["A complex protein that is produced in response to the introduction of a specific antigen into an animal. Antibodies belong to a class of proteins called immunoglobins, which are formed by plasma cells in the blood as a defence mechanism against invasion by parasites, notably bacteria and viruses, either by killing them or rendering them harmless.\\n(Source: ALL2)"], "anticipation of danger": ["The act of foreseeing, expecting and taking measures against possible future exposure to harm, death or a thing that causes these.\\n(Source: ISEP)"], "apartment block": ["An apartment building in which each apartment is individually wholly owned and the common areas are jointly owned."], "apiculture": ["The agricultural practice of intentional maintenance of honey bee colonies."], "appeal": ["Resort to a superior court to review the decision of an inferior court or administrative agency.", "Request turned to an administrative or judicial organ in order to obtain the review or revocation of an action or provision.", "To take a court case to a higher court for review."], "appeal procedure": ["Procedure through which it is possible to resort to a superior court to review the decision of an inferior court."], "applied ecology": ["The application of ecological principles to the solution of human problems."], "applied science": ["Science whose results are employed in technical applications."], "aquaculture": ["The cultivation and harvest of freshwater or marine animals and plants, in ponds, tanks, cages or on protected beds."], "aquatic animal": ["Animal having a water habitat."], "aquatic ecology": ["The study of the relationships among aquatic living organisms and between those organisms and their environment.\\n(Source: ALLa)"], "aquatic mammal": ["A diverse group of roughly 120 species of mammal that are primarily ocean-dwelling or depend on the ocean for food."], "aquatic organism": ["Organisms which live in water.\\n(Source: PHC)"], "aquatic plant": ["Plant adapted for a partially or completely submerged life."], "aqueduct": ["A channel for supplying water; often underground, but treated architecturally on high arches when crossing valleys or low ground.", "Duct for conveying water to a given place.", "Canal or passage in the body in which liquids flow."], "aquifer": ["Layers of rock, sand or gravel that can absorb water and allow it to flow."], "arable farming": ["Growing crops as opposed to dairy farming, cattle farming, etc."], "arboriculture": ["The planting and care of woody plants, especially trees."], "archaeological site": ["Any location containing significant relics and artifacts of past culture.\\n(Source: LANDY)"], "archaeology": ["The scientific study of the material remains of the cultures of historical or prehistorical peoples.\\n(Source: MGH)"], "archipelago": ["A group of many islands including the waters that surround them.\\n(Source: DOE)", "A cluster of several islands."], "architecture": ["The art and science of designing and building structures, or large groups of structures, in keeping with aesthetic and functional criteria.", "A specification that identifies components and their associated functionality, describes connectivity of components, and describes the mapping of functionality onto components."], "Arctic Ocean": ["The smallest and most poorly studied of the oceans on earth. It covers an area of 14 million square km that is divided by three submarine ridges, i.e. the Alpha Ridge, the Lomonosov Ridge, and an extension of the mid-Atlantic ridge. It is also nearly landlocked, covered\\nyear-round by pack ice, and the third of its area is continental shelf.\\n(Source: OCEAN)"], "Arctic region": ["The northernmost area of the earth, centered on the North Pole, that includes the Arctic Ocean, the northern reaches of Canada, Alaska, Russia, Norway and most of Greenland, Iceland and Svalbard.\\n(Source: INP)"], "distribution area": ["The overall geographical distribution of a talon."], "armament": ["The weapons, ammunition and equipment held by a military unit or state.", "The total force held by a military unit or state."], "armed forces": ["The military units of a state, typically divided by their differing contexts of operations, such as the army, navy, air force and marines."], "aromatic compound": ["Compound characterized by the presence of at least one benzene ring."], "aromatic hydrocarbon": ["Hydrocarbon having an unsaturated ring containing alternating double and single bonds, especially containing a benzene ring."], "aromatic substance": ["Substance having a distinctive, usually fragrant smell."], "arsenic": ["A toxic metalloid element with symbol As and atomic number 33, existing in several allotropic forms, that occurs principally in realgar and orpiment and as the free element. It is used in semiconductors, lead-based alloys, and high temperature brasses."], "art": ["The creation of works of beauty or other special significance.", "The products of human creativity; works of art collectively.", "A superior skill that one can learn by study, practice, and observation.", "Photographs or other visual representations in a printed publication."], "arthropod": ["The largest phylum in the animal kingdom; adults typically have segmented body, a sclerotized integument, and many-jointed segmental limbs.\\n(Source: MGH)", "Animal member of the phylum Arthropoda."], "Articulata": ["Animals characterized by the repetition of similar segments (metameres), exhibited especially by arthropods, annelids, and vertebrates in early embryonic stages and in certain specialized adult structures."], "artificial lake": ["Lake created behind manmade barriers."], "asbestos": ["Generic name for a group of fibrous mineral silicates."], "asbestos cement": ["A hardened mixture of asbestos fibers, Portland cement and water used in relatively thin slabs for shingles, wallboard and siding."], "ASEAN": ["Association of Southeast Asian Nations. Regional organization of states of Southeast Asia created on august 8th, 1967."], "ash": ["The incombustible matter remaining after a substance has been incinerated.", "Any of the trees belonging to the genus Fraxinus.", "Wood of the ash tree."], "Asia": ["The world's largest continent. It occupies the eastern part of the Eurasian landmass and its adjacent islands and is separated from Europe by the Ural Mountains. Asia borders on the Arctic Ocean, the Pacific Ocean, the Indian Ocean, and the Mediterranean and Red Seas in the west. It includes the largest peninsulas of Asia Minor, India, Arabia, and Indochina and the island groups of Japan, Indonesia, the Philippines, and Ceylon."], "assimilation": ["Conversion of nutritive material to living tissue.\\n(Source: KOREN)"], "association": ["A formal association of people with similar interests."], "astronautics": ["The science of space flight."], "astronomy": ["The science concerned with celestial bodies and the observation and interpretation of the radiation received in the vicinity of the earth from the component parts of the universe."], "atlas": ["A bound collection of maps or charts, plates, engravings or tables illustrating any subject.", "The most superior (first) cervical vertebra of the spine."], "atmosphere": ["The gaseous envelope surrounding the Earth in a several kilometers-thick layer.", "Gaseous envelope of a celestial body.", "A store's physical characteristics that are used to develop an image and draw customers."], "atmospheric chemistry": ["The study of the production, transport, modification, and removal of atmospheric constituents in the troposphere and stratosphere."], "atmospheric circulation": ["The general movement and circulation of air, which transfers energy between different levels of the atmosphere."], "atmospheric humidity": ["A measurable quantity of the moisture content found in the earth's atmosphere.\\n(Source: RHW)"], "atmospheric model": ["A simulation, pattern or plan designed to demonstrate the structure or workings of the atmosphere surrounding any object, including the Earth.\\n(Source: APD)"], "atmospheric ozone": ["A triatomic molecule of oxygen; a natural constituent of the atmosphere, with the highest concentrations in the ozone layer or stratosphere; it is found at a level between 15 and 30 km above the Earth, which prevents harmful ultraviolet B radiation, which causes skin cancer and threatens plant life, from reaching the ground. The fragile shield is being damaged by chemicals released on Earth. The main chemicals that are depleting stratospheric ozone are chlorofluorocarbons (CFCs), which are used in refrigerators, aerosols and as cleaners in many industries and halons, which are used in fire extinguishers. The damage is caused when these chemicals release highly reactive forms of chlorine and bromine.\\n(Source: GILP96 /  WRIGHT)"], "atmospheric physics": ["The study of the physical phenomena of the atmosphere."], "atmospheric precipitation": ["The settling out of water from cloud in the form of rain, hail, snow, etc."], "atmospheric science": ["The sciences that study the dynamics, physics and chemistry of atmospheric phenomena and processes."], "attribution": ["Under certain circumstances, the tax law applies attribution rules to assign to one taxpayer the ownership interest of another taxpayer.\\n(Source: WESTS)", "Act of accrediting an author or an artist for creating a specific work or idea."], "audiovisual media": ["Any means of communication transmitted to both the sense of hearing and the sense of sight, especially technologies directed to large audiences."], "autoecology": ["That part of ecology which deals with individual species and their reactions to environmental factors.\\n(Source: UNUN)"], "automobile industry": ["Branch of industry that manufactures automobiles."], "avalanche": ["A fall or slide of a large mass, as of snow or rock, down a mountainside.", "Great quantity of ice or snow that falls down suddenly from a mountain slope while  increasing in volume and speed."], "avalanche protection": ["The total of measures and devices implemented to protect people, property or natural resources from avalanche conditions, including avalanche forecasting and warning, avalanche zoning, ski testing and the use of explosives and other equipment to stabilize an avalanche area."], "aviation law": ["International rules regulating air transportation."], "avifauna": ["All the birds in a particular region."], "background level": ["Term used in a variety of situations, always as the constant or natural amount of a given substance, radiation, noise, etc."], "background radiation": ["Radiation resulting from natural sources, as opposed to man-made sources, and to which people are exposed in everyday, normal life; for example from rocks and soil."], "bacterial bed": ["A device that removes some suspended solids from sewage."], "bactericide": ["An agent that destroys bacteria."], "bacteriology": ["The science and study of bacteria."], "banking": ["Transactional business between any bank and that bank's clients or customers."], "barium": ["A soft silvery-white metallic element of the alkaline earth group. It has the symbol Ba, and atomic number 56. It is used in bearing alloys and compounds are used as pigments.\\n(Source: CED)"], "baseline monitoring": ["Monitoring of long-term changes in atmospheric compositions of particular significance to the weather and the climate.\\n(Source: YOUNG)"], "basic food requirement": ["The minimum nutriments deemed necessary for a person of a particular age, gender, physiological condition and activity level to sustain life, health and growth."], "basicity": ["The state of a solution of containing an excess of hydroxyl ions."], "basidiomycete": ["Any of various fungi of the subdivision Basidiomycota."], "bathing water": ["A body of water where bathing is permitted."], "battery": ["A cell or several cells connected together, each cell containing the essentials for producing voltaic electricity."], "bay": ["(Laurus nobilis) A shrub of the family Lauraceae.", "An open, curving indentation made by the sea or a lake into a coastline.", "To produce a loud, short, explosive sound similar to that of a dog.", "A herb made from a leaf of several of the shrubs of the family Lauraceae.", "A compartment in an aircraft used for some specific purpose."], "beach": ["A lat, narrow strip of sand, gravel or pebbles along the shoreline of a body of water (ocean, river, lake).", "To land on a beach; (of animals) to become stranded out of the water."], "beaching": ["The washing ashore of whales or other cetaceans that have died for natural causes, or because of highly polluted sea water or after being trapped in drift nets."], "bee conservation": ["The care, preservation and husbandry of hymenopterous insects valued for their ability to pollinate crops and other flora or for their production of honey."], "beef cattle": ["Cattle bred for the production of meat."], "bee": ["Any of the membranous-winged insects which compose the superfamily Apoidea in the order Hymenoptera characterized by a hairy body and by sucking and chewing mouthparts.", "The second letter of the Roman alphabet."], "beetle": ["Any insect of the order Coleoptera, having biting mouthparts and forewings modified to form shell-like protective elytra."], "beneficial organism": ["Any pollinating insect, or any pest predator, parasite, pathogen or other biological control agent which functions naturally or as part of an integrated pest management program to control another pest.\\n(Source: LEE)"], "benthic division": ["The bottom of a body of water often occupied by benthos.\\n(Source: GILP96)"], "benthic ecosystem": ["The interacting system of the biological communities located at the bottom of bodies of freshwater and saltwater and their non-living environmental surroundings.\\n(Source: TOE / DOE)"], "benthos": ["Those organisms attached to, living on, in or near the bottom of the sea, river bed or lake floor."], "benzene": ["A colorless, liquid, flammable, aromatic hydrocarbon used to manufacture styrene and phenol. Also known as benzol.\\n(Source: MGH)"], "benzopyrene": ["A five-ring aromatic hydrocarbon found in coal tar, in cigarette smoke, and as a product of incomplete combustion."], "beryllium": ["A corrosion-resistant, toxic silvery-white metallic element that occurs chiefly in beryl and is used mainly in x-ray windows and in the manufacture of alloys. Symbol: Be, atomic number: 4."], "beta radiation": ["Ionizing radiation which is produced as a stream of high speed electrons emitted by certain types of radioactive substance when they decay."], "beverage industry": ["Industry sector which produces beverages."], "beverage": ["Any one of various liquids for drinking."], "bibliography": ["A complete or selective listing of documents by a given subject, author or publisher, often including the description and identification of the editions, dates of issue, titles, authorship, publishers or other written materials.\\n(Source: RHW / ISEP)"], "bicycle": ["A vehicle with two wheels in tandem, pedals connected to the rear wheel by a chain, handlebars for steering, and a saddlelike seat."], "bilateral convention": ["An international agreement, especially one dealing with a specific matter, involving two or both sides, factions, or the like."], "bilge oil": ["Waste oil that accumulates, usually in small quantities, inside the lower spaces of a ship, just inside the shell plating, and usually mixed with larger quantities of water."], "bilge water": ["Water that builds up in the bottom of a ship's bilge."], "bioaccumulation": ["The accumulation of pollutants in living organisms by direct adsorption or through food chains."], "bio-availability": ["The extent to which a drug or other substance is taken up by a specific tissue or organ after administration.\\n(Source: ZINZAN /  CEDa)"], "biochemistry": ["The study of chemical substances occurring in living organisms and the reactions and methods for identifying these substances."], "biocide": ["A diverse group of poisonous substance including preservatives, insecticides, disinfectants and pesticides used for the control of organisms that are harmful to human or animal health or that cause damage to natural or manufactured products.\\n(Source: GRAHAW)"], "bioclimatology": ["The study of climate in relation to fauna and flora."], "biocoenosis": ["A community or natural assemblage of organisms; often used as an alternative to ecosystem but strictly is the fauna/flora association excluding physical aspects of the environment."], "bioconcentration factor": ["The quotient of the concentration of a chemical in aquatic organisms at a specific time or during a discrete time period of exposure, divided by the concentration in the surrounding water at the same time or during the same period.\\n(Source: KOREN)"], "biodegradability": ["The extent to which a substance can be decomposed - or rotted - by bacteria and fungi."], "biodegradation": ["Breaking down of a substance by microorganisms."], "biodiversity": ["Number and variety of living organisms; includes genetic diversity, species diversity, and ecological diversity."], "bioethics": ["The study of ethical problems arising from biological research and its applications in such fields as organ transplantation, genetic engineering, or artificial insemination."], "biogas": ["Gas, rich in methane, which is produced by the fermentation of animal dung, human sewage or crop residues in an air-tight container."], "biogeochemical cycle": ["Movement of chemical elements in a circular pathway, from organisms to physical environment, back to organisms."], "biogeochemistry": ["The study of the chemical, physical, geological, and biological processes and reactions that govern the composition of the natural environment and its energy transportation cycles."], "biogeographical region": ["Area of the Earth's surface defined by the species of fauna and flora it contains."], "biogeography": ["The science concerned with the geographical distribution of animal and plant life."], "biological engineering": ["The application of engineering principles and techniques to biology and medicine. It is largely concerned with the design of replacement body parts, such as limbs, heart valves, etc."], "biological indicator": ["A species or organism that is used to grade environmental quality or change."], "biological monitoring": ["The direct measurement of changes in the biological status of a habitat, based on evaluations of the number and distribution of individuals or species before and after a change.\\n(Source: ALL)"], "biological nitrogen fixation": ["A process in which atmospheric nitrogen is converted to ammonia by a pair of bacterial enzymes called nitrogenase."], "biological pest control": ["Any living organism applied to or introduced into the environment that is intended to function as a pesticide against another organism declared to be a pest."], "biological weapon": ["Living organisms (or infective material derived from them) which are intended to cause disease or death in animals, plants, or man, and which depend for their effects on their ability to multiply in the person, animal or plant attacked. Various living organisms (for example, rickettsiae, viruses and fungi), as well as bacteria, can be used as weapons."], "biology": ["A division of the natural sciences concerned with the study of life and living organisms."], "bioluminescence": ["The production of light of various colors by living organisms, e.g. some bacteria and fungi, glow-worms and many marine animals)."], "biomass": ["Biomass refers strictly speaking to the total weight of all the living things in an ecosystem. However, it has come to refer to the amount of plant and crop material that could be produced in an ecosystem for making biofuels and other raw materials used in industry, for example.\\n(Source: WRIGHT)"], "biophysics": ["The science involving the application of physical principles and methods to study and explain the structures of living organisms and the mechanics of life processes."], "bioreactor": ["A container, such as a large fermentation chamber, for growing living organisms that are used in the industrial production of substances such as pharmaceuticals, antibodies, or vaccines."], "biorhythm": ["A cyclically recurring pattern of physiological states in an organism or organ, such as alpha rhythm or circadian rhythm; believed by some to affect physical and mental states and behaviour."], "biosafety": ["The combination of knowledge, techniques and equipment used to manage or contain potentially infectious materials or biohazards in the laboratory environment, to reduce or prevent harm to laboratory workers, other persons and the environment."], "biosphere": ["That part of the Earth and atmosphere capable of supporting living organisms."], "biosphere reserve": ["Protected land and coastal areas that are approved under the Man and Biosphere programme (MAB) in conjunction with the Convention on International Trade in Endangered Species (CITES). Each reserve has to have an ecosystem that is recognized for its diversity and usefulness as a conservation unit. The reserves have at least one core area where there can be no interference with the natural ecosystem. A transition zone surrounds this and within it scientific research is allowed. Beyond this is a buffer zone which protects the whole reserve from agricultural, industrial and urban development. Biosphere reserves and buffer zones were regarded as examples of a new generation of conservation techniques.\\n(Source: WRIGHT)"], "biosynthesis": ["Production, by synthesis or degradation, of a chemical compound by a living organism.\\n(Source: MGH)"], "biotechnology": ["A combination of biology and technology. It is used to describe developments in the application of biological organisms for commercial and scientific purposes."], "biotic factor": ["The influence upon the environment of organisms owing to the presence and activities of other organisms, as distinct from a physical, abiotic, environmental factor."], "biotope": ["A region of relatively uniform environmental conditions, occupied by a given plant community and its associated animal community."], "biotope network": ["Intersection of corridors connecting patchy ecological communities. Species survival tends to be higher in patches that have higher connectivity."], "biotope protection": ["Measures taken to ensure that the biological and physical components of a biotope are in equilibrium by maintaining constant their relative numbers and features."], "bird": ["Any of the bipedal, warm-blooded vertebrates that lay eggs having wings which, for most species, enables them to fly.", "A powered heavier-than-air aircraft with fixed wings that obtains lift by the Bernoulli effect and is used for transportation.", "Badminton equipment consisting of a ball of cork or rubber with a crown of feathers."], "bird sanctuary": ["Special area where birds are protected."], "bird of prey": ["Any of various carnivorous bird of the orders Falconiformes and Strigiformes which feed on meat taken by hunting."], "bird species": ["Any species of the warm-blooded vertebrates which make up the class Aves."], "birth control": ["Limitation of the number of children born by preventing or reducing the frequency of impregnation.", "The intentional prevention of pregnancy through the use of various devices, practices, surgical procedures or medication."], "bitumen": ["A generic term applied to natural inflammable substances of variable colour, hardness, and volatility, composed principally of a mixture of hydrocarbons substantially free from oxygenated bodies."], "black coal": ["A natural black graphitelike material used as a fuel, formed from fossilized plants and consisting of amorphous carbon with various organic and some inorganic compounds."], "blast furnace": ["A tall, cylindrical smelting furnace for reducing iron ore to pig iron; the blast of air blown through solid fuel increases the combustion rate."], "bleaching agent": ["A chemical that removes colors or whitens."], "bleaching clay": ["Clay capable of chemically adsorbing oils, insecticides, alkaloids, vitamins, carbohydrates and other materials; it is used for refining and decolorizing mineral and vegetable oils."], "bleaching process": ["The process of removing colored components from a textile."], "blue-green alga": ["Microorganisms, formerly classified as algae but now regarded as bacteria, including nostoc, which contain a blue pigment in addition to chlorophyll.\\n(Source: CED)"], "boating": ["To travel or go in a boat as a form of recreation."], "boiler": ["An enclosed vessel in which water is heated and circulated, either as hot water or as steam, for heating or power."], "boiling point": ["The temperature at which the transition from the liquid to the gaseous phase occurs in a pure substance at fixed pressure."], "book": ["A collection of sheets of paper bound together to hinge at one edge, containing printed or written material, pictures, etc.", "Part of a larger published work.", "To record in a register.", "To arrange for (something for someone else) in advance.", "To engage for a performance."], "bookkeeping": ["The art or science of recording business accounts and transactions."], "border": ["The dividing line or frontier between political or geographic regions.", "The boundary line or the area immediately inside the boundary.", "The boundary of a surface.", "To have its boundary touch something; to share a border."], "boron": ["A very hard almost colourless crystalline metalloid element that in impure form exists as a brown amorphous powder. It occurs principally in borax and is used in hardening steel."], "botanical garden": ["A place in which plants are grown, studied and exhibited."], "botany": ["A branch of the biological sciences which embraces the study of plants and plant life."], "boundary layer": ["The layer of fluid adjacent to a physical boundary in which the fluid motion is significantly affected by the boundary and has a mean velocity less than the free stream value.\\n(Source: LBC)"], "bovid": ["Any animal belonging to the Bovidae family."], "brackish water": ["Water, salty between the concentrations of fresh water and sea water; usually 5-10 parts x thousand."], "bradyseism": ["The gradual uplift or descent of part of the Earth's surface caused by the filling or emptying of an underground magma chamber and/or hydrothermal activity."], "breast milk": ["Milk from the breast for feeding babies."], "breeding": ["The application of genetic principles to the improvement of farm animals and cultivated plants."], "breeding bird": ["Individual in a bird population that are involved in reproduction during a particular period in a given place."], "brewing industry": ["A sector of the economy in which an aggregate of commercial enterprises is engaged in the manufacture and marketing of beverages made from malt and hops by steeping, boiling and fermentation, such as beer, ale and other related beverages."], "brick": ["A building material usually made from clay, molded as a rectangular block, and baked or burned in a kiln."], "bridge": ["A structure that spans and provides a passage over a road, railway, river, or some other obstacle.", "A system which connects two or more local area networks at layer 2.", "To be or make bridge over something.", "The ridge of the nose running from the root of the nose down to the tip.", "An elevated platform above the upper deck of a mechanically propelled ship from which it is navigated.", "A wrestling move performed from a supine position, lying down face-up."], "bromine": ["A pungent dark red volatile liquid element (symbol Br, atomic number 35) of the halogen series that occurs in brine and is used in the production of chemicals."], "brooding": ["Incubating eggs by sitting on them."], "brook": ["A small stream or rivulet, commonly swiftly flowing in rugged terrain, of lesser length and volume than a creek; especially a stream that issues directly from the ground, as from a spring or seep, or that is produced by heavy rainfall or melting snow.", "To allow (something that one dislikes or disagrees with) to continue to exist or occur without interference; accept or undergo, often unwillingly."], "bryophyte": ["Any plant of the division Bryophyta, having stems and leaves but lacking true vascular tissue and roots and reproducing by spores: includes the mosses and liverworts."], "budget": ["A balance sheet or statement of estimated receipts and expenditures."], "bug": ["Any of the suborder Heteroptera, having piercing and sucking mouthparts, specialized as a beak.\\n(Source: CED)", "A problem in computer software or hardware or in electronic hardware in general.", "To make someone rather angry or impatient; to cause annoyance.", "Any insect, arachnid, or other terrestrial arthropod that is a pest."], "building": ["Structure with a roof and walls, such as a house or factory.", "The process of constructing."], "building area": ["Land and other places on, under, in or through which the temporary and permanent works are to be executed and any other lands or places needed for the purposes of construction.\\n(Source: ECHO1)"], "building component": ["A building element which uses industrial products that are manufactured as independent until capable of being joined with other elements."], "building land": ["Area of land suitable for building on."], "building material": ["Any material used in construction, such as steel, concrete, brick, masonry, glass, wood, etc."], "building planning": ["The activity of designing, organizing or preparing for future construction or reconstruction of edifices and facilities.\\n(Source: RHW)"], "building site": ["A piece of land on which a house or other building is being built."], "building technology": ["The application of engineering principles and technology to building design and construction."], "built environment": ["That part of the physical surroundings which are people-made or people-organized, such as buildings and other major structures, roads, bridges and the like, down to lesser objects such as traffic lights, telephone and pillar boxes."], "built-up area": ["Area which is full of houses, shops, offices and other buildings, with very little open space.", "The area within a city or town, as indicated by appropriate traffic signs (or, in the United Kingdom, by the presence of street lights), where different traffic rules are in effect, such as a reduction of the speed limit."], "bulb cultivation": ["The cultivation of flower bulb is divided into two sectors: for forcing (flower bulbs used by professional growers for the production of cut flowers and potted plants) and for dry sales (flower bulbs for garden planting, flower pots, landscaping and parks).\\n(Source: BULB)"], "bus": ["A large, long-bodied motor vehicle equipped with seating for passengers, usually operating as part of a scheduled service."], "business": ["The activity, position or site associated with commerce or the earning of a livelihood.", "Commercial, industrial or financial activity."], "butterfly": ["A lepidopteran that is active at day."], "button-cell battery": ["A tiny, circular battery made for a watch or for other microelectric applications."], "by-catch": ["Fish that is caught unintentionally while intending to catch other fish and that is often discarded back into the sea."], "by-product": ["A product from a manufacturing process that is not considered the principal material."], "cable": ["Strands of insulated electrical conductors laid together, usually around a central core, and wrapped in a heavy insulation.", "To send a message by telegraph."], "cadmium": ["Chemical element with symbol Cd and atomic number 48, silvery gray transition metal."], "cadmium contamination": ["The release and presence in the air, water and soil of cadmium, a toxic, metallic element, from sources such as the burning of coal and tobacco and improper disposal of cadmium-containing waste.\\n(Source: FFD / EEN)"], "calcium": ["A malleable silvery-white metallic element of the alkaline earth group with symbol Ca and atomic number 20; the fifth most abundant element in the earth crust, occurring especially as forms of calcium carbonate. It is an essential constituent of bones and teeth and is used as a deoxidizer in steel.\\n(Source: CED)"], "calcium content": ["Amount of calcium contained in a solution."], "calibration": ["The marking the scale of a measuring instrument so that readings can be made in appropriate units."], "canal": ["An artificial open waterway used for transportation, waterpower, or irrigation."], "cancer": ["Any malignant cellular tumour including carcinoma and sarcoma."], "cancer risk": ["The probability that exposure to some agent or substance will adversely transform cells to replicate and form a malignant tumor."], "car": ["A four-wheeled motor vehicle used for land transport."], "carbohydrate": ["Any of the group of organic compounds composed of carbon, hydrogen and oxygen, including sugars, starches and celluloses."], "carbon": ["A nonmetallic element with symbol C and atomic number 6 existing in the three crystalline forms: graphite, diamond and buckminsterfullerene: occurring in carbon dioxide, coal, oil and all organic compounds.\\n(Source: CED)"], "carbonate": ["A salt or ester of carbonic acid.\\n(Source: CED)"], "carbon cycle": ["The cycle of carbon in the biosphere, in which plants convert carbon dioxide to organic compounds that are consumed by plants and animals, and the carbon is returned to the biosphere in inorganic form by processes of respiration and decay.\\n(Source: MGH)"], "carbon dioxide": ["A colourless gas with a faint tingling smell and taste."], "carbon dioxide tax": ["Compulsory charges levied on fuels to reduce the output of carbon dioxide (CO2)."], "carbon monoxide": ["Chemical formula CO; a colorless, odorless, and tasteless gas."], "carcinogenicity": ["The ability or tendency of a substance or physical agent to cause or produce cancer."], "carcinogenicity test": ["Test for assessing if a chemical or physical agent increases the risk of cancer."], "carcinogen": ["A substance that causes cancer in humans and animals.", "Causing cancer."], "cardiology": ["The branch of medicine that studies the heart."], "cardiovascular disease": ["The class of diseases that involve the heart or blood vessels (arteries and veins)."], "carnivore": ["An animal that eats meat."], "cartography": ["The making of maps and charts for the purpose of visualizing spatial distributions over various areas of the earth."], "cash crop": ["Crops that are grown for sale in the town markets or for export. They include coffee, cocoa, sugar, vegetables, peanuts and non-foods, like tobacco and cotton."], "catalysis": ["A phenomenon in which a relatively small amount of substance augments the rate of a chemical reaction without itself being consumed.\\n(Source: MGH)"], "catalyst": ["A substance whose presence alters the rate at which a chemical reaction proceeds, but whose own composition remains unchanged by the reaction. Catalysts are usually employed to accelerate reactions(positive catalyst), but retarding (negative) catalysts are also used.\\n(Source: ALL)", "A substance which speeds up chemical reactions."], "catalytic converter": ["A device designed to clean up the exhaust fumes from petrol-driven vehicles."], "catastrophe": ["A sudden, widespread disaster or calamity that greatly exceeds the resources of an area or region.", "A sudden violent change in the earth's surface."], "catchment area": ["An area from which surface runoff is carried away by a single drainage system."], "cation": ["A positively charged atom or group of atoms, or a radical which moves to the negative pole (cathode) during electrolysis.\\n(Source: MGH)"], "cattle": ["Domesticated bovine animals, including cows, steers and bulls, raised and bred on a ranch or farm."], "cave": ["1) An underground hollow with access from the ground surface or from the sea, often found in limestone areas and on rocky coastlines.\\n2) A natural cavity, chamber or recess which leads beneath the surface of the earth, generally in a horizontal or obliquely inclined direction. It may be in the form of a passage or a gallery, its shape depending in part on the joint pattern or structure of the rock and partly on the type of process involved in its excavation. Thus, caves worn by subterranean rivers may be different in character from, and of considerably greater extent than, a sea-cave eroded by marine waves.\\n3) A natural underground open space, generally with a connection to the surface and large enough for a person to enter. The most common type of cave is formed in a limestone by dissolution.\\n(Source: CED /  WHIT /  BJGEO)"], "cellulose": ["The main polysaccharide in living plants, forming the skeletal structure of the plant cell wall; a polymer of beta-D-glucose linked together with the elimination of water to form chains of 2000-4000 units."], "cement": ["A dry powder made from silica, alumina, lime, iron oxide, and magnesia which hardens when mixed with water; used as an ingredient in concrete."], "Central Africa": ["A geographic region of the African continent close to the equator that includes Cameroon, Chad, Equatorial Guinea, Gabon, the Central African Republic and the Democratic Republic of Congo."], "Central America": ["A narrow continental region of the Western hemisphere, existing as a bridge between North and South America, often considered to be the southern portion of North America, and including countries such as Guatemala, Belize, El Salvador, Honduras, Nicaragua, Costa Rica and Panama."], "Central Asia": ["A geographic region of the Asian continent between the Caspian Sea on the west and China on the east, extending northward into the central region of Russia and southward to the northern borders of Iran and Afghanistan, and comprised of independent former republics of the Soviet Union, including Kazakstan, Uzbekistan, Turkmenistan, Kyrgyzstan and Tajikistan."], "central government": ["A system in which a governing or administrative body has a certain degree of power or authority to prevail in the management of local, national and international matters."], "centrifugation": ["Separation of particles from a suspension in a centrifuge: balanced tubes containing the suspension are attached to the opposite ends of arms rotating rapidly about a central point; the suspended particles are forced outwards, and collect at the bottoms of the tubes.\\n(Source: UVAROV)"], "cephalopod": ["Exclusively marine animals constituting the most advanced class of the Mollusca, including squid, octopuses, and Nautilus.\\n(Source: MGH)"], "ceramics": ["The art and techniques of producing articles of clay, porcelain, etc."], "ceramics industry": ["Industry producing ceramic items."], "cetacean": ["Order of aquatic mammals, including the whales, dolphins, and porpoises."], "Chagas' disease": ["A form of trypanosomiasis found in South America, caused by the protozoan Trypanosoma cruzi, characterized by fever and often inflammation of the hearth muscle.\\n(Source: CED)"], "chain management": ["The administration, organization and planning for the flow of materials or merchandise through various stages of production and distribution, involving a network of vendors, suppliers, manufacturers, distributors, retailers and other trading partners.\\n(Source: MSE)"], "charcoal": ["A porous solid product containing 85-98% carbon and produced by heating carbonaceous materials such as cellulose, wood or peat at 500-600 C\u00b0 in the absence of air.\\n(Source: MGH)"], "chelicerate": ["A subphylum of the phylum Artrophoda; chelicerae are characteristically modified as pincers."], "chemical analysis": ["The complex of operations aiming to determine the kinds of constituents of a given substance.\\n(Source: ZINZAN)"], "chemical engineering": ["The branch of engineering concerned with industrial manufacture of chemical products."], "chemical industry": ["The industry that comprises the companies that produce industrial chemicals."], "chemical oceanography": ["The study of the behavior of the chemical elements within the Earth's oceans."], "chemical plant": ["Plants where basic raw materials are chemically converted into a variety of products."], "chemical property": ["Property of a substance depending on the arrangement of the atoms in the molecule, e.g. bio-availability, degradability, persistence, etc.\\n(Source: RRDA)"], "chemical reaction": ["A change in which a substance is transformed into one or more new substances."], "chemical": ["Any substance used in or resulting from a reaction involving changes to atoms or molecules.", "Of or relating to chemistry."], "chemical structure": ["The arrangement of atoms in a molecule of a chemical compound."], "chemical treatment": ["A process that alters the chemical structure of the constituents of the waste to produce either an innocuous or a less hazardous material. Chemical processes are attractive because they produce minimal air emissions, they can often be carried out on the site of the waste generator, and some processes can be designed and constructed as mobile units.\\n(Source: PARCOR)"], "chemical waste": ["Any by-product of a chemical process, including manufacturing processes. Often this by-product is considered a toxic or polluting substance.\\n(Source: APD / ERG)"], "chemical weapon": ["Chemical agents of warfare including all gaseous, liquid or solid chemical substances which might be employed because of their direct toxic effects on man and animals."], "chemisorption": ["The process of chemical adsorption."], "chemistry": ["The scientific study of the properties, composition, and structure of matter, the changes in structure and composition of matter, and accompanying energy changes."], "child": ["Living being as genetically proceeding from an other one.", "A person below the age of puberty.", "An entity that is narrower in scope."], "chimney": ["A vertical structure of brick, masonry, or steel that carries smoke or steam away from a fire, engine, etc."], "chiropteran": ["Order of placental mammals, comprising the bats, having the front limbs modified as wings."], "chloride": ["A compound which is derived from hydrochloric acid and contains the chlorine atom in the -1 oxidation state.\\n(Source: MGH)"], "chlorinated hydrocarbon": ["A class of persistent, broad-spectrum insecticides that linger in the environment and accumulate in the food chain. Among them are DDT, aldrin, dieldrin, heptachlor, chlordane, lindane, endrin, mirex, hexachloride, and toxaphene. In insects and other animals these compounds act primarily on the central nervous system. They also become concentrated in the fats of organisms and thus tend to produce fatty infiltration of the heart and fatty degeneration of the liver in vertebrates. In fishes they have the effect of preventing oxygen uptake, causing suffocation. They are also known to slow the rate of photosynthesis in plants. Their danger to the ecosystem resides in their rate stability and the fact that they are broad-spectrum poisons which are very mobile because of their propensity to stick to dust particles and evaporate with water into the atmosphere.\\n(Source: EPAGLO /  PORT)"], "chlorination": ["The application of chlorine to water, sewage or industrial wastes for disinfection or other biological or chemical purposes.\\n(Source: ALL)"], "chlorine": ["A very reactive and highly toxic green, gaseous element, belonging to the halogen family of substances with symbol Cl and atomic number 17."], "chloroethylene": ["A flammable, explosive gas with an ethereal aroma; soluble in alcohol and ether, slightly soluble in water; boils at -14\u00b0 C; an important monomer for polyvinyl chloride and its copolymers; used in organic synthesis and in adhesives."], "chlorofluorocarbon": ["Gases formed of chlorine, fluorine, and carbon whose molecules normally do not react with other substances; they are therefore used as spray can propellants because they do not alter the material being sprayed."], "partially halogenated chlorofluorohydrocarbon": ["Hydrocarbons whose hydrogen atoms have been partially substituted with chlorine and fluorine. They are used in refrigeration, air conditioning, packaging, insulation, or as solvents and aerosol propellants. Because they are not destroyed in the lower atmosphere they drift into the upper atmosphere where their chlorine components destroy ozone."], "chlorophenol": ["Any organochloride of phenol that contains one or more covalently bonded chlorine atoms."], "chlorophyll": ["A green pigment, present in algae and higher plants, that absorbs light energy and thus plays a vital role in photosynthesis."], "chlorosis": ["A disease condition of green plants seen as yellowing of green parts of the plants.\\n(Source: MGH)"], "chromatography": ["A method of separating and analyzing mixtures of chemical substances by selective adsorption in a column of powder or on a strip of paper."], "chromium": ["A hard grey metallic element that takes a high polish, occurring principally in chromite: used in steel alloys and electroplating to increase hardness and corrosion-resistance."], "chrysophyta": ["The golden-brown and orange-yellow algae; a diverse group of microscopically small algae which inhabit fresh and salt water, many being planktonic. They contain carotenoid pigments and may be unicellular, colonial, filamentous or amoeboid."], "church": ["A building where Christian religious activities take place."], "city": ["Term used generically today to denote any urban form but applied particularly to large urban settlements. There are, however, no agreed definitions to separate a city from the large metropolis or the smaller town."], "civil air traffic": ["Air traffic pertaining to or serving the general public, as distinguished from military air traffic."], "civil engineering": ["The planning, design, construction, and maintenance of fixed structures and ground facilities for industry, transportation, use and control of water or occupancy."], "civilian protection": ["The organization and measures, usually under governmental or other authority depending on the country, aimed at preventing, abating or fighting major emergencies for the protection of the civilian population and property, particularly in wartime."], "civil law": ["The body of law dealing with the private relations between members of a community."], "classification": ["An arrangement or organization of persons, items or data elements into groups by reason of common attributes, characteristics, qualities or traits."], "clay": ["A loose, earthy, extremely fine-grained, natural sediment or soft rock composed primarily of clay-size or colloidal particles and characterized by high plasticity and by a considerable content of clay mineral and subordinate amounts of finely divided quartz, decomposed feldspar, carbonates, ferruginous matter, and other impurities; it forms a plastic, moldable mass when finely ground and mixed with water, retains its shape on drying, and becomes firm, rocklike and permanently hard on heating or firing.", "The physical structure of a dead animal or person."], "clean technology": ["Industrial process which causes little or no pollution."], "climate": ["The average weather condition in a region of the world."], "climate protection": ["Precautionary actions, procedures or installations undertaken to prevent or reduce harm from pollution to natural weather conditions or patterns, including the prevailing temperature, atmospheric composition and precipitation."], "climate type": ["Weather conditions typical of areas roughly corresponding to lines of latitude."], "climatic alteration": ["The slow variation of climatic characteristics over time at a given place. This may be indicated by the geological record in the long term, by changes in the landforms in the intermediate term, and by vegetation changes in the short term.\\n(Source: WHIT)"], "climatic change": ["The long-term fluctuations in temperature, precipitation, wind, and all other aspects of the Earth's climate."], "climatic zone": ["A belt of the earth's surface within which the climate is generally homogeneous in some respect."], "climatology": ["That branch of meteorology concerned with the mean physical state of the atmosphere together with its statistical variations in both space and time as reflected in the weather behaviour over a period of many years."], "climax": ["A botanical term referring to the terminal community said to be achieved when a sere (a sequential development of a plant community or group of plant communities on the same site over a period of time) achieves dynamic equilibrium with its environment and in particular with its prevailing climate. Each of the world's major vegetation climaxes is equivalent to a biome. Many botanists believe that climate is the master factor in a plant environment and that even if several types of plant succession occur in an area they will all tend to converge towards a climax form of vegetation.\\n(Source: WHIT)", "To reach a sexual climax; to experience orgasm.", "The moment of most intense feeling and pleasure during sexual activity."], "clinical symptom": ["Any objective evidence of disease or of a patient's condition founded on clinical observation.\\n(Source: RRDA)"], "cloning": ["The production of genetically identical individuals from a single parent."], "clothing": ["Clothes considered as a group.", "All coverings designed to be worn on a person's body."], "cloud": ["Suspensions of minute water droplets or ice crystals produced by the condensation of water vapour.", "To cover with clouds."], "coagulation": ["A separation or precipitation from a dispersed state of suspended particles resulting from their growth."], "coal": ["The natural, rocklike, brown to black derivative of forest-type plant material, usually accumulated in peat beds and progressively compressed and indurated until it is finally altered in to graphite-like material."], "coal-fired power plant": ["Power plant which is fuelled by coal."], "coal gasification": ["Process of conversion of coal to a gaseous product which is used as fuel in electric power stations."], "coal liquefaction": ["The process of preparing a liquid mixture of hydrocarbons by destructive distillation of coal.\\n(Source: MGH)"], "coal mining": ["The technical and mechanical job of removing coal from the earth and preparing it for market."], "coal refining": ["The processing of coal to remove impurities."], "coal technology": ["The processing of coal to make gaseous and liquid fuels.\\n(Source: ENVAR)"], "coast": ["A line or zone where the land meets the sea or some other large expanse of water."], "coastal erosion": ["The gradual wearing away of material from a coast by the action of sea water."], "coastal fishing": ["Fishing in an area of the sea next to the shoreline.\\n(Source: PHC)"], "coastal water": ["The part of the ocean directly off the coast."], "coastguard": ["A maritime force which aids shipping, saves lives at sea, prevents smuggling, etc."], "coating": ["A material applied onto or impregnated into a substrate for protective, decorative, or functional purposes. Such materials include, but are not limited to, paints, varnishes, sealers, adhesives, thinners, diluents, and inks."], "cobalt": ["A metallic element with symbol Co and atomic number 27, used chiefly in alloys."], "cockroach": ["The most primitive of the living winged insects."], "code": ["A systematic collection, compendium or revision of laws, rules, or regulations.", "To enter a program or other instructions into a computer (or other electronic device) to instruct it to do a particular task."], "coelenterate": ["Animals that have a single body cavity (the coelenteron)."], "co-incineration": ["Joint incineration of hazardous waste, in any form, with refuse and/or sludge.\\n(Source: LEE)"], "coke": ["A coherent, cellular, solid residue remaining from the dry distillation of a coking coal or of pitch, petroleum, petroleum residue, or other carbonaceous materials; contains carbon as its principal constituent.\\n(Source: MGH)", "A street name for cocaine."], "cold": ["A condition of low temperature.", "Having a low temperature.", "A contagious, viral infectious disease of the upper respiratory system; common symptoms include cough, sore throat, runny nose, nasal congestion and sneezing.", "Psychologically distant; without human warmth or emotion.", "(color) giving no sensation of warmth.", "Sexually unresponsive.", "Without compunction or human feeling."], "coliform bacterium": ["A group of bacteria that are normally abundant in the intestinal tracts of human and other warm-blooded animals and are used as indicators (being measured as the number of individuals found per millilitre of water) when testing the sanitary quality of water."], "colloid": ["An intimate mixture of two substances, one of which, called the dispersed phase, is uniformly distributed in a finely divided state through the second substance, called the dispersion medium."], "colloidal state": ["A system of particles in a dispersion medium, with properties distinct from those of a true solution because of the larger size of the particles. The presence of these particles can often be detected by means of the ultramicroscope.\\n(Source: UVAROV)"], "colour": ["An attribute of things that results from the light they reflect, transmit, or emit in so far as this light causes a visual sensation that depends on its wavelengths.", "To add color to."], "combination effect": ["A combined effect of two or more substances or organisms which is greater than the sum of the individual effect of each."], "combined cycle-power station": ["This type of plant is flexible in response and can be built in the 100-600 MW capacity range. It produces electrical power from both a gas turbine (ca. 1300\u00b0C gas inlet temperature), fuelled by natural gas or oil plus a steam turbine supplied with the steam generated by the 500\u00b0C exhaust gases from the gas turbine. The thermal efficiency of these stations is ca. 50 per cent compared with a maximum of 40 per cent from steam turbine coal fired power stations. This type of plant can be built in two years compared with six years for a coal-fired station and 10-15 years for nuclear.\\n(Source: PORT)"], "combustibility": ["The property of a substance of being capable of igniting and burning."], "combustion engine": ["An engine that operates by the energy of combustion of a fuel."], "commercial law": ["The whole body of substantive jurisprudence applicable to the rights, intercourse and relations of persons engaged in commerce, trade or mercantile pursuits."], "commercial traffic": ["The operations and movements related to the transportation and exchange of goods.\\n(Source: RRDA)"], "commercial vehicle": ["Vehicle designed and equipped for the transportation of goods."], "communications": ["The concept, science, technique and process of transmitting, receiving or otherwise exchanging information and data."], "community-pays principle": ["A tenet of environmental policy, according to which the costs of ecological challenges, environmental quality improvements and the removal of environmental hazards are allotted to community groups or local corporations and, thereby, to the general public."], "commuter traffic": ["Traffic caused by people travelling regularly over some distance, as between a suburb and a city and back, between their place of residence and their place of work."], "commuting": ["Traveling from one's residence to one's regular place of business and back to the residence."], "compaction": ["Reduction of the bulk of solid waste by rolling and tamping."], "company policy": ["Official guidelines or set of guidelines adopted by a company for the management of its activity."], "comparative law": ["The study of the principles of legal science by the comparison of various systems of law.\\n(Source: BLACK)"], "comparative test": ["A test conducted to determine whether one procedure is better than another."], "comparison": ["The placing together or juxtaposing of two or more items to ascertain, bring into relief, or establish their similarities and dissimilarities."], "compensation": ["Equivalent in money for a loss sustained; equivalent given for property taken or for an injury done to another; recompense or reward for some loss, injury or service.\\n(Source: WESTS)"], "economic competition": ["The market condition where an individual or firm that wants to buy or sell a commodity or service has a choice of possible suppliers or customers."], "competitiveness": ["The ability of a firm to strive in the market with rivals in the production and sale of commodities or services and, analogously, the ability of a country to maintain a relatively high standard of living for its citizens through trade in international markets.\\n(Source: http://www.indiana.edu/~ipe/glossry.html / OED)"], "complex formation": ["Formation of a complex compound. Also known as complexing or complexation."], "complexing agent": ["A substance capable of forming a complex compound with another material in solution."], "compost": ["A mixture of decaying organic matter used to fertilize and condition the soil."], "composting": ["The natural biological decomposition of organic material in the presence of air to form a humus-like material."], "compression": ["Reduction in the volume of a substance due to pressure.\\n(Source: MGH)", "A condition in which the volume of fuel and air in an engine cylinder is reduced as a result of increased pressure by a piston.", "The system of forces that tend to decrease the volume of or shorten rocks.", "Any of several techniques that reduce the number of bits required to represent information in data transmission or storage."], "compressor": ["A device that produces pressure."], "European Communities": ["The collective body that resulted in 1967 from the merger of the administrative networks of the European Atomic Energy Community (EURATOM), the European Coal and Steel Community (ECSC), and the European Economic Community (EEC). The singular term has also been widely used.\\n(Source: ABDN)"], "concrete": ["A mixture of aggregate, water, and a binder, usually Portland cement; it hardens to stonelike condition when dry.", "To build using concrete; to cover with cement.", "Not abstract.", "Particular, perceivable, real."], "conductivity": ["The ratio of the electric current density to the electric field in a material."], "congress": ["A formal meeting, often consisting of representatives of various organizations, that is assembled to promote, discuss or make arrangements regarding a particular subject or some matter of common interest."], "conifer": ["An order of conebearing plants which includes nearly all the present day Gymnospermae. Most are tall evergreen trees with needle-like (e.g., pines), linear (e.g. firs) or scale-like (e.g., cedars) leaves. They are characteristic of temperate zones and the main forest trees of colder regions. They provide timber, resins, tars, turpentine and pulp for paper.\\n(Source: ALL)"], "conservation": ["The protection of a natural resource, usually by planned management, to prevent its depletion or destruction."], "constitutional law": ["That branch of the public law of a nation or state which treats of the organization, powers and frame of government, the distribution of political and governmental authorities and functions, the fundamental principles which are to regulate the relations of government and citizen and which prescribes generally the plan and method according to which the public affairs of the nation or state are to be administered.", "A law in a country's constitution."], "construction work": ["The construction, rehabilitation, alteration, conversion, extension, demolition or repair of buildings, highways, or other changes or improvement to real property, including facilities providing utility services."], "consultation": ["Any meeting or inquiry of concerned persons or advisors for the purpose of deliberation, discussion or decision on some matter or action.\\n(Source: BLD)"], "consumer group": ["A collection of persons united to address concerns regarding the purchase and use of specific commodities or services.\\n(Source: RHW)"], "consumer protection": ["Information disseminated or measures and programs established to prevent and reduce damage, injury or loss to users of specific commodities and services.\\n(Source: RHW)"], "consumption": ["Spending for survival or enjoyment in contrast to providing for future use or production.", "A common and deadly infectious disease that is caused by mycobacteria, primarily Mycobacterium tuberculosis."], "container": ["A large case that can be transported by truck and than easily loaded on a ship."], "contaminated soil": ["Soil which because of its previous or current use has substances under, on or in it which, depending upon their concentration and/or quantity, may represent a direct potential or indirect hazard to man or to the environment.\\n(Source: GRAHAW)"], "contamination": ["Introduction into or onto water, air, soil or other media of microorganisms, chemicals, toxic substances, wastes, wastewater or other pollutants in a concentration that makes the medium unfit for its next intended use."], "continental shelf": ["The gently sloping seabed of the shallow water nearest to a continent, covering about 45 miles from the shore and deepening over the sloping sea floor to an average depth of 400 ft."], "contour farming": ["The performing of cultivations along lines connecting points of equal elevation so reducing the loss of top soil by erosion, increasing the capacity of the soil to retain water and reducing the pollution of water by soil."], "contract": ["An agreement between two or more persons which creates an obligation to do or not to do a particular thing. Its essential are competent parties, subject matter, a legal consideration, mutuality of agreement, and mutuality of obligation.", "An agreement with which a person or a company are engaged towards another person or company to deliver a good or a service in exchange for a predetermined payment.", "To reduce in width or extent.", "To acquire or catch (a disease, something noxious, bad condition)."], "contract cleaner": ["A commercial service provider, usually bound by a written agreement, responsible for the removal of dirt, litter or other unsightly materials from any property.\\n(Source: RHW)"], "controlled burning": ["The planned use of carefully controlled fire to accomplish predetermined management goals. The burn is set under a combination of weather, fuel moisture, soil moisture, and fuel arrangement conditions that allow the management objectives to be attained, and yet confine the fire to the planned area.\\n(Source: DUNSTE)"], "controlling authority": ["The power of a person or an organized assemblage of persons to manage, direct, superintend, restrict, regulate, govern, administer or oversee.\\n(Source: BLD)"], "convention": ["International agreement on a specific topic.", "The preferred method of accomplishing a task.", "A large formal assembly."], "conventional energy": ["Power provided by traditional means such as coal, wood, gas, etc., as opposed to alternative energy sources such as solar power, tidal power, wind power, etc."], "cooling": ["A decrease in temperature.", "A mechanism for keeping something cool.", "Causing cold or cooling."], "cooling oil": ["Oil used as a cooling agent, either with forced circulation or with natural circulation."], "cooling tower": ["A device that aids in heat removal from water used as a coolant in electric power generating plants."], "cooling water": ["Water used to make something less hot, such as the irradiated elements from a nuclear reactor or the engine of a machine."], "copper": ["Chemical element with symbol Cu and atomic number 29; one of the most important nonferrous metals; a ductile and malleable metal found in various ores and used in industry, engineering, and the arts in both pure and alloyed form."], "coppice": ["A growth of small trees that are repeatedly cut down at short intervals; the new shoots are produced by the old stumps."], "coral": ["The skeleton of certain solitary and colonial anthozoan coelenterates; composed chiefly of calcium carbonate."], "coral reef": ["Underwater structures built up from the skeletons of reef-building coral a small primitive marine animal, and other marine animals and algae over thousands of years."], "core meltdown": ["Accidental overheating of the core of a nuclear reactor resulting in the core melting and radiation escaping."], "cork": ["The thick light porous outer bark of the cork oak, used widely as an insulator and for stoppers for bottles, casks, etc.", "Conical or cylindrical-shaped plug that is pushed in the bottleneck of a (wine) bottle to stop it up."], "corridor": ["A narrow hall or passage with rooms leading off it."], "corrosion": ["A process in which a solid, especially a metal, is eaten away and changed by a chemical action."], "corrosion inhibitor": ["A chemical agent which slows down or prohibits a corrosion reaction."], "cosmetic industry": ["Industry for the production of substances for improving the appearance of the body."], "cosmic radiation": ["Radiations consisting of atomic nuclei, especially protons, of very high energy that reach the earth from outer space. Some cosmic radiations are very energetic and are able to penetrate a mile or more into the Earth."], "cost-benefit analysis": ["The attempt to assess, compare and frequently justify the total price or loss represented by a certain activity or expenditure with the advantage or service it provides."], "cost increase": ["The augmentation or rise in the amount of money incurred or asked for in the exchange of goods and services."], "cost recovery basis": ["A standard used to provide reimbursement to individuals or organizations for any incurred expense or provided service."], "cost": ["In economics, the value of the factors of production used by a firm in producing or distributing goods and services or engaging in both activities.\\n(Source: GREENW)", "The amount of money paid per unit for a good or service.", "To be priced at.", "To require to lose, suffer, or sacrifice."], "cotton": ["Fiber obtained from plants of the genus Gossypium, used in making fabrics, cordage, and padding and for producing artificial fibers and cellulose.", "A shrub of the genus Gossypium known for the soft fibers that protect its seeds."], "county": ["An area comprising more than one city and whose boundaries have been designed according to some biological, political, administrative, economic, demographic criteria.", "The land under the jurisdiction of a count."], "court of justice": ["A tribunal having jurisdiction of appeal and review, including the ability to overturn decisions of lower courts or courts of first instance.\\n(Source: BLD)"], "covering": ["Structure or material that covers an edifice.", "Something put around something else, usually in order to give it another look or to protect it from its environment."], "craft": ["An occupation or trade requiring manual dexterity or skilled artistry.", "The skilled practice of a practical occupation."], "credit assistance": ["The help and support from banks and other financial institutions in providing money or goods without requiring present payment.\\n(Source: ISEP /  OED)"], "criminality": ["A violation of the law, punishable by the State in criminal proceedings."], "criminal law": ["That body of the law that deals with conduct considered so harmful to society as a whole that it is prohibited by statute, prosecuted and punished by the government.\\n(Source: DUHA)"], "critical level": ["The concentration limit beyond which a substance can cause dangerous effects to living organisms.\\n(Source: RRDA)"], "critical load": ["The maximum load that a given system can tolerate before failing.\\n(Source: GRAHAWa)"], "crocodile": ["Any large tropical reptile of the family Crocodylidae: order Crocodylia. They have a broad head, tapering snout, massive jaws, and a thick outer covering of bony plates.\\n(Source: CED)"], "crop rotation": ["An agricultural technique in which, season after season, each field is sown with crop plants in a regular rotation, each crop being repeated at intervals of several years."], "crop waste": ["Any unusable portion of plant matter left in a field after harvest.\\n(Source: CNI)"], "crossing place": ["A place, often shown by markings, lights, or poles, where a street, railway, etc. may be crossed."], "crude oil": ["A comparatively volatile liquid bitumen composed principally of hydrocarbon, with traces of sulphur, nitrogen or oxygen compounds; can be removed from the earth in a liquid state."], "crustacean": ["A subphylum of arthropod animals having jointed feet and mandibles, two pairs of antennae, and segmented, chitin-encased bodies."], "cryptogam": ["A large group of plants, comprising the Thallophyta, Bryophyta and Pteridophyta, the last of which are cryptogams."], "crystallography": ["The branch of science that deals with the geometric description of crystals and their internal arrangement."], "cultivated plant": ["Plants specially bred or improved by cultivation."], "cultivation": ["The practice of growing and nurturing plants outside of their wild habitat (i.e., in gardens, nurseries, arboreta)."], "cultivation method": ["Any procedure or approach used to prepare land or soil for the growth of new crops, or to promote or improve the growth of existing crops."], "cultural facility": ["Any building or structure used for programs or activities involving the arts or other endeavors that encourage refinement or development of the mind.\\n(Source: WCD / OED)"], "cultural heritage": ["The inherited body of beliefs, customs, artistic activity and knowledge that has been transmitted by ancestors.\\n(Source: RHW)"], "curriculum": ["The aggregate of courses of study provided in a particular school, college, university, adult education program, technical institution or some other educational program."], "customs": ["Duties charged upon commodities on their importation into, or exportation out of, a country.", "The head office dealing with tariffs."], "cyanate": ["A salt or ester of cyanic acid containing the radical OCN."], "cyanide": ["Any of a group of compounds containing the CN group and derived from hydrogen cyanide, HCN."], "cyclone": ["A storm characterized by the converging and rising giratory movement of the wind around a zone of low pressure (the eye) towards which it is violently pulled from a zone of high pressure."], "cytology": ["A branch of the biological sciences which deals with the structure, behaviour, growth, and reproduction of cells and the functions and chemistry of cell components."], "cytotoxicity": ["The degree to which an agent is toxic to cells."], "dairy farm": ["A commercial establishment for processing or selling milk and milk products."], "dairy industry": ["Production of food made from milk or milk products."], "dairy product": ["Food which is derived from milk and contains mostly milk."], "dam": ["Structure constructed across a watercourse or stream channel."], "damage": ["An injury or harm impairing the function or condition of a person or thing.\\n(Source: CED)", "To put a thing in bad condition by making it suffer some damage.", "To mar the surface or appearance of."], "dangerous goods": ["Goods or products that are full of hazards or risks when used, transported, etc."], "data analysis": ["The evaluation of digital data, i.e. data represented by a sequence of code characters.\\n(Source: MGH)"], "data carrier": ["A medium on which data can be recorded, and which is usually easily transportable, such as cards, tape, paper, or disks."], "data exchange": ["A reciprocal transfer of individual facts, statistics or items of information between two or more parties for the purpose of enhancing knowledge of the participants."], "data processing": ["Any operation or combination of operations on data, including everything that happens to data from the time they are observed or collected to the time they are destroyed.\\n(Source: MGH)"], "data protection": ["Policies, procedures or devices designed to maintain the integrity or security of information."], "dating": ["An estimation of the age of an artifact, biological vestige, linguistic usage, etc."], "decay product": ["An isotope formed by the radioactive decay of some other isotope. This newly formed isotope possesses physical and chemical properties that are different from those of its parent isotope, and may also be radioactive."], "DDT": ["A persistent organochlorine insecticide, also known as dichlorodiphenyltrichloroethane, that was introduced in the 1940s and used widely because of its persistence (meaning repeated applications were unnecessary), its low toxicity to mammals and its simplicity and cheapness of manufacture. It became dispersed all over the world and, with other organochlorines, had a disruptive effect on species high in food chains, especially on the breeding success of certain predatory birds. DDT is very stable, relatively insoluble in water, but highly soluble in fats. Health effects on humans are not clear, but it is less toxic than related compounds. It is poisonous to other vertebrates, especially fish, and is stored in the fatty tissue of animals as sublethal amounts of the less toxic DDE. Because of its effects on wildlife its use in most countries is now forbidden or strictly limited.\\n(Source: MGH /  ALL)"], "debt": ["Something owed to someone else.", "Passive balance that corresponds to the difference between all proceeds and all expenditures, the current ones and the ones registered on the capital account, excluding the financial operations."], "deciduous forest": ["The temperate forests comprised of trees that seasonally shed their leaves, located in the east of the USA, in Western Europe from the Alps to Scandinavia, and in the eastern Asia. The trees of deciduous forests usually produce nuts and winged seeds.\\n(Source: WRIGHT)"], "deciduous tree": ["Any tree losing its leaves in autumn and growing new ones in the spring.\\n(Source: CAMB)"], "decision": ["A selection of something from a collection of options or alternatives.", "An opinion and judgment formed or emitted about something.", "Firmness of conviction."], "decomposition": ["The reduction of the body of a formerly living organism into simpler forms of matter.", "The process by which a complex problem or system is broken down into parts that are easier to conceive, understand, program, and maintain."], "decontamination": ["The removing or neutralizing of chemical, biological, or radiological contamination from a person, object, or area."], "decree": ["A declaration of the court announcing the legal consequences of the facts found.", "Administrative, legislative or juridical act being issued by a executive organ being made of general or specific juridical prescriptions.", "To decide with authority.", "To issue a decree.", "High level administrative act usually issued by the head of State or, in some countries, the chief of the government."], "deep sea": ["Region of open ocean beyond the continental shelf."], "deep sea fishing": ["Fishing in the deepest parts of the sea."], "deer": ["The common name for 41 species of even-toed ungulates that compose the family Cervidae in the order Artiodactyla; males have antlers."], "defoliation": ["The drop of foliage from plants caused by herbicides such as Agent Orange, diuron, triazines, all of which interfere with photosynthesis."], "deforestation": ["The removal of forest and undergrowth to increase the surface of arable land or to use the timber for construction or industrial purposes."], "degradability": ["The capacity of being decomposed chemically or biologically."], "degradation": ["The act of abasing.", "A lowering from one's standing or rank in office or society."], "degreasing": ["The removal of grease."], "de-inking": ["Series of processes by which various types of printing inks are removed from paper fibre pulp during the pre-processing and recycling of recovered paper products."], "delinquency": ["Set of crimes.", "Failure to make payments on time."], "delta": ["A delta is a vast, fan-shaped creation of land, or low-lying plain, formed from successive layers of sediment washed from uplands to the mouth of some rivers, such as the Nile, the Mississippi and the Ganges. The nutrient-rich sediment is deposited by rivers at the point where, or before which, the river flows into the sea. Deltas are formed when rivers supply and deposit sediments more quickly that they can be removed by waves of ocean currents. The importance of deltas was first discovered by prehistoric man, who was attracted to them because of their abundant animal and plant life. Connecting waterways through the deltas later provided natural routes for navigation and trade, and opened up access to the interior. Deltas are highly fertile and often highly populated areas. They would be under serious threat of flooding from any sea-level rise.\\n(Source: WRIGHT)"], "demand": ["The desire, ability and willingness of an individual to purchase a good or service.", "To desire a service or physical goods, often without returning the favor in kind."], "democracy": ["A system of governance in which ultimate authority power is vested in the people and exercised directly by them or by their freely elected agents."], "demographic evolution": ["The gradual pattern of change in the growth of human populations in a particular region or country, from a rapid increase in the birth and death rates to a leveling off in the growth rate due to reduced fertility and other factors.\\n(Source: DOE / ANT)"], "demography": ["The statistical study of human vital statistics and population dynamics (natality, mortality, age, profession etc).", "A statistic characterizing human populations or segments of human populations broken down by age or sex or income etc."], "dendrochronology": ["The science of dating the age of a tree by studying annual growth rings."], "dendrometry": ["The measuring of the diameter of standing trees from the ground with a dendrometer that can also be used to measure tree heights."], "denitrification": ["The loss of nitrogen from soil by biological or chemical means."], "deposition": ["The process by which polluting material is precipitated from the atmosphere and accumulates in ecosystems."], "deregulation": ["The removal or relaxation of government control over the economic activities of some commercial entity, industry or economic sector."], "dermapteran": ["Any of various insects of the order Dermaptera."], "desalination": ["Removal of salt, as from water or soil.", "Removal of salt and other minerals from water."], "desalination plant": ["Plant for the extraction of fresh water from saltwater by the removal of salts, usually by distilling."], "desert": ["A wide, open, comparatively barren tract of land with few forms of life and little rainfall.", "Left behind by the owner or keeper.", "To leave someone who needs or counts on you."], "desertification": ["The development of desert conditions as a result of human activity or climatic changes."], "desert locust": ["One of about a dozen species of short-horned grasshoppers (Acridoidea) that are known to change their behavior and form swarms of adults or bands of hoppers (wingless nymphs). The swarms that form can be dense and highly mobile. (Source: FAO)"], "desorption": ["The process of removing a sorbed substance by the reverse of adsorption or absorption."], "detection": ["The act or process of discovering evidence or proof of governmental, legal or ethical violations.\\n(Source: RHW)", "Act of detecting something with a detector."], "detector": ["A mechanical, electrical, or chemical device that automatically identifies and records or registers a stimulus, such as an environmental change in pressure or temperature, an electrical signal, or radiation from a radioactive material."], "detergent": ["A surface-active agent used for removing dirt and grease from a variety of surfaces and materials.", "A substance used when cleaning."], "determination method": ["Method employed in the assessment or in the evaluation of a quantity, a quality, a fact, an event, etc.\\n(Source: ZINZANa)"], "deterrent": ["Any measure, implement or policy designed to discourage or restrain the actions or advance of another agent, organization or state.\\n(Source: RHW)", "Tending to deter."], "detoxification": ["The act or process of removing a poison or the toxic properties of a substance in the body."], "developed country": ["A nation possessing a relatively high degree of industrialization, infrastructure and other capital investment, sophisticated technology, widespread literacy and advanced living standards among its populations as a whole."], "developing country": ["A country whose people are beginning to utilize available resources in order to bring about a sustained increase in per capita production of goods and services."], "development aid": ["Economic assistance or other types of support provided to developing countries to promote or encourage advancement in living standards, institutions, infrastructure, agricultural practices and other aspects of an economy, and to resolve problems typically  associated with developing countries."], "development area": ["Area which has been given special help from a government to encourage business and factories to be set up there."], "development planning": ["The act or process of formulating a course of action that promotes the economic advancement of a region or people, particularly in countries known to have low levels of economic productivity and technological sophistication.\\n(Source: OED / WBG)"], "development plan": ["The statement of local planning policies that each local planning authority is required by statute to maintain, and which can only be made or altered by following the procedures prescribed for that purpose, which include obligations to consult widely and to hold a public local inquiry into objections. The development plan includes: 1) the structure plan for the area (normally prepared by the country council); 2) an area-wide development plan for each district council area.\\n(Source: GRAHAW)"], "dialysis": ["A process of selective diffusion through a membrane; usually used to separate low-molecular-weight solutes which diffuse through the membrane from the colloidal and high-molecular-weight solutes which do not.", "A method to clean the blood of patients with renal failure."], "diatom": ["Unicellular algae, some of which are colonial, green or brownish in colour (but all contain chlorophyll) and with siliceous and often highly sculptured cell walls."], "dictionary": ["A reference book containing an explanatory alphabetical list of words, identifying usually, the phonetic, grammatical, and semantic value of each word, often with etymology, citations, and usage guidance and other information."], "didactics": ["The art or science of teaching."], "diesel engine": ["An internal combustion engine operating on a thermodynamic cycle in which the ratio of compression of the air charge is sufficiently high to ignite the fuel subsequently injected into the combustion chamber."], "diesel fuel": ["Heavy oil residue used as fuel for certain types of diesel engines."], "differentiation": ["The development of cells so that they are capable of performing specialized functions in the organs and tissues of the organisms to which they belong.", "In mathematics, the process of finding a derivative."], "diffusion": ["The spontaneous movement and scattering of particles (atoms and molecules), of liquid, gases, and solids.\\n(Source: MGH)"], "digested sludge": ["Sludge or thickened mixture of sewage solids with water that has been decomposed by anaerobic bacteria."], "digital land model": ["A representation of a surface's topography stored in a numerical format. Each pixel has been assigned coordinates and an altitude.\\n(Source: CCRS)"], "diluted acid": ["A less concentrated acid."], "dioxin": ["A heterocyclic and aromatic molecule, where two carbon atoms have been substituted by oxygen atoms."], "direct discharger": ["Factory and industrial concern which does not discharge their sewage into public sewers, but directly into a waterway."], "directive": ["The second rank of administrative acts (inferior to regulations, superior to decisions) made by the council or commission of the European Communities on order to carry out their tasks in accordance with the Treaties. They must be addressed to states, not individuals, but many create rights for individuals or allow the directive to be pleaded before municipal court."], "disabled person": ["Person lacking one or more physical power, such as the ability to walk or to coordinate one's movements, as from the effects of a disease or accident, or through mental impairment."], "disaster": ["The result of a vast ecological breakdown in the relations between man and his environment, a serious and sudden event (or slow, as in drought) on such a scale that the stricken community needs extraordinary efforts to cope with it, often with outside help or international aid.", "An event that results in large-scale damage and loss of human life, caused by natural forces, technical failure or human error."], "disaster preparedness": ["The aggregate of measures to be taken in view of disasters, consisting of plans and action programmes designed to minimize loss of life and damage, to organize and facilitate effective rescue and relief, and to rehabilitate after disaster. Preparedness requires the necessary legislation and means to cope with disaster or similar emergency situations. It is also concerned with forecasting and warning, the education and training of the public, organization and management, including plans, training of personnel, the stockpiling of supplies and ensuring the needed funds and other resources.\\n(Source: GUNN)"], "disaster relief": ["Money, food or other assistance provided for those surviving a sudden, calamitous event causing loss of life, damage or hardship."], "discharge regime": ["The rate of flow of a river at a particular moment in time, related to its volume and its velocity.\\n(Source: WHIT)"], "disease": ["A definite pathological process having a characteristic set of signs and symptoms which are detrimental to the well-being of the individual."], "disinfectant": ["An agent, such as heat, radiation, or a chemical, that disinfects by destroying, neutralizing, or inhibiting the growth of disease-carrying microorganisms.\\n(Source: AMHER)"], "disinfection": ["The complex of physical, chemical or mechanical operations undertaken to destroy pathogenic germs."], "dispatch note": ["Document accompanying something being transported (including living beings) and usually required at certain specific steps."], "dispersion": ["A distribution of finely divided particles in a medium.\\n(Source: MGH)"], "displaced person": ["A person who, for different reasons or circumstances, has been compelled to leave his or her home."], "disposal of warfare materials": ["Disposal of the material remnants of war, which can seriously impede development and cause injuries and the loss of lives and property."], "dissolution": ["Dissolving of a material.", "Excessive indulgence in sensual pleasures."], "dissolved organic carbon": ["The fraction of total organic carbon (all carbon atoms covalently bonded in organic molecules) in water that passes through a 0.45 micron pore-diameter filter.\\n(Source: WQA)"], "distillation": ["The process of producing a gas or vapour from a liquid by heating the liquid in a vessel and collecting and condensing the vapours into liquids."], "distilling industry": ["A sector of the economy in which an aggregate of commercial enterprises is engaged in the manufacture and marketing of alcoholic beverages made by a distillation process of vaporization and condensation, such as vodka, rum, whiskey and other related beverages.\\n(Source: RHW / SIC)"], "distribution": ["The sum of the commercial and service activities that transfer the produced goods to the consumer.", "In statistics, the relative arrangements of the elements of a statistical population based on some criterion, as frequency, time, or location.", "The process by which commodities get to final consumers, including storing, selling, shipping, and advertising.", "In Linux, a collection of software making up the Linux operating system. The software is usually compiled by either a company or organization. It is designed to be easy to install, administer, and use by virtue of it being an integrated whole. Examples include Ubuntu, SUSE Linux, Red Hat, and Debian."], "district heating": ["The supply of heat, either in the form of steam or hot water, from a central source to a group of buildings."], "disused military site": ["Military site where all activity has ceased."], "ditch": ["A long, narrow excavation artificially dug in the ground; especially an open and usually unpaved waterway, channel, or trench for conveying water for drainage or irrigation, and usually smaller than a canal. Some ditches may be natural watercourses."], "DNA": ["The principal material of inheritance. It is found in chromosomes and consists of molecules that are long unbranched chains made up of many nucleotides. Each nucleotide is a combination of phosphoric acid, the monosaccharide deoxyribose and one of four nitrogenous bases: thymine, cytosine, adenine or guanine. The number of possible arrangements of nucleotides along the DNA chain is immense. Usually two DNA strands are linked together in parallel by specific base-pairing and are helically coiled. Replication of DNA molecules is accomplished by separation of the two strands, followed by the building up of matching strands by means of base-pairing, using the two halves as templates. By a mechanism involving RNA, the structure of DNA is translated into the structure of proteins during their synthesis from amino acids.\\n(Source: ALL)"], "document": ["Material of any kind, regardless of physical form, which furnishes information, evidence or ideas, including items such as contracts, bills of sale, letters, audio and video recordings, and machine readable data files.", "To record in documents.", "To support or supply with references."], "documentation": ["The process of accumulating, classifying and disseminating information, often to support the claim or data given in a book or article.\\n(Source: OED)"], "dog": ["A common four-legged animal, especially kept by people as a pet or to hunt or guard things.", "A dull, unattractive girl or woman.", "An iron for holding wood in a fireplace."], "domestic appliance": ["A machine or device, especially an electrical one used domestically."], "domesticated animal": ["Wild animal which has been trained to live near a house and not be frightened of human beings.\\n(Source: PHC)"], "domestic trade": ["Trade wholly carried on at home; as distinguished from foreign commerce.\\n(Source: WESTS)"], "domestic waste": ["Waste generated by residential households and comprised of any material no longer wanted or needed.\\n(Source: EED)"], "dosage": ["The amount of a substance required to produce an effect.\\n(Source: CONFER)"], "dose": ["The amount of test substance administered. Dose is expressed as weight of test substance (g, mg) per unit weight of test animal (e.g., mg/kg), or as weight of food or drinking water.\\n(Source: LEE)", "A powerful hallucinogenic drug manufactured from lysergic acid."], "dose-effect relationship": ["The relation between the quantity of a given substance and a measurable or observable effect."], "dragonfly": ["Any of the insects composing six families of the suborder Anisoptera and having four large, membranous wings and compound eyes that provide keen vision."], "drainage": ["1) Removal of groundwater or surface water, or of water from structures, by gravity or pumping.\\n2) The discharge of water from a soil by percolation (the process by which surface water moves downwards through cracks, joints and pores in soil and rocks).\\n(Source: MGH /  WHIT)"], "dredged material": ["Unconsolidated material removed from rivers, streams, and shallow seas with machines such as the bucket-ladder dredge, dragline dredge, or suction dredge."], "drilling": ["The act of boring holes in the earth for finding water or oil, for geologic surveys, etc."], "drinking water": ["Water that is suitable to drink, does not present health hazards and whose quality is regulated by legislation."], "drinking water treatment": ["The Directive on the Quality of Surface Water Intended for Drinking Water defines three categories of water treatment (A1, A2, A3) from simple physical treatment and disinfection to intensive physical and chemical treatment. The treatment to be used depends on the quality of the water abstracted. The Directive uses imperative values for parameters known to have an adverse effect on health and also guide values for those which are less adverse. There is also a directive which complements the \"surface water abstraction\" Directive by indicating the methods of measurement and the frequency of sampling and analysis required.\\n(Source: PORT)"], "drought": ["A period of abnormally dry weather sufficiently prolonged so that the lack of water causes a serious hydrologic imbalance (such as crop damage, water supply shortage) in the affected area."], "drought control": ["Measures taken to prevent, mitigate or eliminate damage caused to the ecosystem, especially crops, by a sustained period of dry weather."], "dry cleaning": ["The cleaning of fabrics with a solvent other than water."], "dry farming": ["A system of extensive agriculture allowing the production of crops without irrigation in areas of limited rainfall."], "drying": ["The process of partially or totally removing water or other liquids from a solid."], "drying out": ["Removal of water from any substance."], "dual economy": ["An economy based upon two separate/distinct economic systems which co-exist in the same geographical space. Dualism is characteristic of many developing countries in which some parts of a country resemble advanced economies while other parts resemble traditional economies, i.e. there are circuits of production and exchange.\\n(Source: GOOD)"], "dune": ["A low mound, ridge, bank, or hill of loose, windblown granular material (generally sand, sometimes volcanic ash), either bare or covered with vegetation, capable of movement from place but always retaining its characteristic shape."], "duration of sunshine": ["Period of the day during which the sun is shining."], "dust": ["Any kind of solid material divided in particles of very small size.", "To remove solid material divided in particles of very small size to clean something.", "Dust or fine dirt to be found on the ground, on floors, on streets and ways."], "dust removal": ["The removal of dust from air by ventilation or exhaust systems."], "dwelling": ["Any enclosed space wholly or partially used or intended to be used for living, sleeping, cooking, and eating.", "The abode of a human being, their place of residence."], "dye": ["A substance used to modify the color of something.", "To modify the color of something by applying dye."], "dyke": ["An artificial wall, embankment, ridge, or mound, usually of earth or rock fill, built around a relatively flat, low-lying area to protect it from flooding."], "dyke reinforcement": ["The addition of material to strengthen the structure of the dykes."], "early warning system": ["Any series of procedures and devices designed to detect sudden or potential threats to persons, property or the environment at the first sign of danger."], "earthquake": ["The violent shaking of the ground produced by deep seismic waves, originating from the epicentre."], "earth science": ["The science that deals with the earth or any part thereof; includes the disciplines of geology, geography, oceanography and meteorology, among others."], "Earth-Sun relationship": ["The Earth depends on the sun for its existence as a planet hospitable to life, and solar energy is the major factor determining the climate. Hence, conditions on the sun and conditions on Earth are inextricably linked. Although the sun's rays may appear unchanging, its radiation does vary. Many scientists suspect that sunspot activity has a greater influence on climatic change than variations attributed to the greenhouse effect.\\n(Source: WRIGHT)"], "earthworm": ["Any of numerous oligochaete worms of the suborder Lumbricina which burrow in the soil and help aerate and break up the ground."], "earwig": ["Any of various insects of the order Dermaptera, which typically have an elongated body with small leathery forewings, semicircular membranous hindwings, and curved forceps at the tip of the abdomen."], "East Africa": ["A geographic region of the African continent that includes Burundi, Kenya, Rwanda, Tanzania, Uganda, Ethiopia and Somalia, and also Mt. Kilimanjaro and Lake Victoria."], "Eastern Asia": ["A geographic region of the Asian continent bordered by the Pacific Ocean in the east that includes China, Japan, Korea, Macao, Taiwan and Siberia."], "Eastern Europe": ["A geographic region of the European continent west of Asia and east of Germany and the Adriatic Sea, traditionally consisting of countries that were formerly part of the Soviet Union, such as Poland, the Czech Republic, Slovakia, Hungary, Romania, Serbia, Croatia and Bulgaria."], "East-West trade": ["Trade between countries and companies of the Western hemisphere with those of the Eastern hemisphere (usually referring to former Communist countries of Eastern Europe)."], "EC Council of Ministers": ["The organ of the EU that is primarily concerned with the formulation of policy and the adoption of Community legislation."], "EC ecolabel": ["The European Community (EC) initiative to encourage the promotion of environmentally friendly products."], "echinoderm": ["Marine coelomate animals distinguished from all others by an internal skeleton composed of calcite plates, and a water-vascular system to serve the needs of locomotion, respiration, nutrition or perception.", "A phylum of marine animals found at all ocean depths. The phylum appeared near the start of the Cambrian period, and contains about 7,000 living species,"], "ecological adaptation": ["Change in an organism so that it is better able to survive or reproduce, thereby contributing to its fitness."], "ecological balance": ["The condition of equilibrium among the components of a natural community such that their relative numbers remain fairly constant and their ecosystem is stable. Gradual readjustments to the composition of a balanced community take place continually in response to natural ecological succession and to alterations in climatic and other influences.\\n(Source: ALL)"], "ecological niche": ["The space occupied by a species, which includes both the physical space as well as the functional role of the species."], "ecology": ["The study of the interrelationships between living organisms and their environment."], "trophic ecology": ["The study of the feeding relationships of organisms in communities and ecosystems. Trophic links between populations represent flows of organisms, organic energy and nutrients. Trophic transfers are important in population dynamics, biogeochemistry, and ecosystem energetics.\\n(Source: PARCOR)"], "economic analysis": ["The quantitative and qualitative identification, study, and evaluation of the nature of an economy or a system of organization or operation."], "economic development": ["The state of nations and the historical processes of change experienced by them, the extent to which the resources of a nation are brought into productive use."], "economic growth": ["An increase over successive periods in the productivity and wealth of a household, country or region, as measured by one of several possible variables, such as the gross domestic product."], "economic instrument": ["Any tool or method used by an organization to achieve general developmental goals in the production of, or in the regulation of, material resources."], "economic policy": ["A definite course of action adopted and pursued by a government, political party or enterprise pertaining to the production, distribution and use of income, wealth and commodities."], "economics": ["The social study of the production, distribution, and consumption of wealth."], "economic system": ["Organized sets of procedures used within or between communities to govern the production and distribution of goods and services."], "economic theory": ["The study of relationships in the economy."], "economic viability": ["Capability of developing and surviving as a relatively independent social, economic or political unit."], "economic zoning": ["A land-use planning design or control where specific types of businesses or private sector investment are encouraged within designated boundaries.\\n(Source: ALL / EEN)"], "economy": ["The system of activities and administration through which a society uses its resources to produce wealth."], "ecophysiology": ["The study of biophysical, biochemical and physiological processes used by animals to cope with factors of their physical environment, or employed during ecological interactions with other organisms."], "ecosystem": ["A community of organisms and their physical environment interacting as an ecological unit.\\n(Source: LBC)"], "ecotourism": ["Excursions to relatively untouched lands, which for the tourist promise the chance to observe unusual wildlife and indigenous inhabitants."], "ecotoxicity": ["Quality of some substances or preparations which present or may present immediate or delayed risks for one or more sectors of the environment.\\n(Source: GRAHAW)"], "ecotoxicology": ["The science dealing with the adverse effects of chemical, physical agents, and natural products on populations and communities of plants, animals and human beings."], "ecotype": ["Species that has special characteristics which allow it to live in a certain habitat."], "edaphology": ["The study of the relationships between soil and organisms, including the use made of land by mankind."], "edible fat": ["A blend of a partially hydrogenated vegetable fat and natural butterfat."], "education": ["The act or process of imparting or acquiring knowledge or skills."], "educational institution": ["An organization or establishment devoted to the act or process of imparting or acquiring knowledge or skills.\\n(Source: RHW)"], "educational planning": ["The process of making arrangements or preparations to facilitate the training, instruction or study that leads to the acquisition of skills or knowledge, or the development of reasoning and judgment.\\n(Source: RHW)"], "education policy": ["A course of action adopted and pursued by government or some other organization, which promotes or determines the goals, methods and programs to be used for training, instruction or study that leads to the acquisition of skills or knowledge, or the development of reasoning and judgment.\\n(Source: RHW)"], "educational system": ["Any formulated, regular or special organization of instruction, training or knowledge disclosure, especially the institutional structures supporting that endeavor.\\n(Source: ISEP /  OED)"], "effect": ["The result or outcome of a cause. Effects include: a) direct effects, which are caused by the action and occur at the same time and place, b) indirect effects, which are caused by the action and are later in time or farther removed in distance, that are still reasonably foreseeable.\\n(Source: LANDY)", "Images or sound added to enhance the experience of viewing a movie or listening to music.", "The result or outcome of a cause.", "Consequence or result of a deed.", "Condition that which follows something on which it depends.", "[With verbal nouns, forming phrases approximately equivalent to the source verb]"], "efficiency criterion": ["Parameter or rule for assessing the competency in performance of production relative to the input of resources."], "efficiency level": ["The ratio of output to input, usually given as a percentage."], "effluent": ["Liquid waste or sewage discharged into a river or the sea."], "egg": ["An approximately spherical or ellipsoidal body produced by birds, snakes, insects and other animals housing the embryo during its development.", "Egg (either fertilized or not) from domesticated birds, most commonly hens, seen as food.", "The female gamete of an animal or plant, capable of fusing with a male gamete to produce a zygote.", "The contents of one or more (hen's usually) eggs as a culinary ingredient, etc.", "Something shaped like an egg, such as an Easter egg or a chocolate egg.", "A swelling on one's head, usually large or noticeable, associated with an injury.", "A person of Caucasian (Western) ancestry, who has a strong desire to learn about and immerse him- or herself in East Asian culture, and/or such a person who is perceived as behaving as if he or she were Asian.", "In terms such as good egg, bad egg, tough egg etc., a person, fellow.", "A foolish or obnoxious person."], "elasticity": ["Ability of a material to return to original dimensions after deformation."], "electrical engineering": ["Engineering that deals with practical applications of electricity."], "electrical industry": ["The generation, transmission, distribution and sale of electric power to the general public."], "electricity": ["A general term used for all phenomena caused by electric charge whether static or in motion."], "electricity consumption": ["Amount of electricity consumed by an apparatus."], "electricity generation": ["The act or process of transforming other forms of energy into electric energy."], "electric line": ["Wires conducting electric power from one location to another."], "electric power": ["The rate at which electric energy is consumed or delivered by an electric device or system, equal to the product of the current and the voltage drop."], "electric power plant": ["A stationary plant containing apparatus for large-scale conversion of some form of energy (such as hydraulic, steam, chemical, or nuclear energy) into electrical energy."], "electric vehicle": ["Vehicle driven by an electric motor and characterized by being silent and less polluting."], "electrokinetics": ["The study of the motion of electric charges, especially of steady currents in electric circuits, and of the motion of electrified particles in electric or magnetic fields.\\n(Source: MGH)"], "electrolysis": ["The production of a chemical reaction by passing an electric current through an electrolyte. In electrolysis, positive ions migrate to the cathode and negative ions to the anode."], "electronics": ["Study, control, and application of the conduction of electricity through gases or vacuum or through semiconducting or conducting materials.", "Electronic part of a device."], "electronic scrap": ["Any material from electronic devices and systems, generated as a waste stream in a processing operation or discarded after service."], "electrosmog": ["Pollution caused by electric and magnetic fields generated by power lines, electrical equipment, mobile and cordless phones, radar, electrical household appliances, microwave ovens, radios, computers, electric clocks, etc."], "chemical element": ["A substance made up of atoms with the same atomic number; common examples are hydrogen, gold, and iron."], "emancipation": ["The state of being free from social or political restraint or from the inhibition of moral or social conventions."], "embryo": ["An early stage of development in multicellular organisms.", "A minute rudimentary plant contained within a seed or an archegonium."], "embryogenesis": ["The formation and development of an embryo from an egg."], "emergency relief": ["Money, food or other assistance provided for those surviving a sudden and usually unexpected occurrence requiring immediate action, especially an incident of potential harm to human life, property or the environment."], "emergency shelter": ["Shelter given to persons who are deprived of the essential necessities of life after a disaster."], "emission": ["A discharge of particulate gaseous, or soluble waste material/pollution into the air from a polluting source."], "emission factor": ["The relationship between the amount of pollutants produced to the amount of raw materials processed, or fuel consumed, in any polluting process."], "emission forecast": ["The final step in a clean air plan is to predict future air quality to demonstrate that we can (if we can) meet the health standards by implementing the measures proposed in the plan. This is done by first projecting the emission inventory into the future, taking into account changes in population, housing, employment in specific business sectors, and vehicle miles traveled. These data are obtained from various sources and the resulting emissions are adjusted to account for regulations and control measures scheduled for implementation during the same time period. Additional adjustments are made to reflect large facilities that are expected to start up, modify, or shut down. The resulting inventory is an emission forecast, and is usually expressed in tons per day of particular pollutants for a given year. Additional steps may be required to determine how the forecasted quantities of air pollution will affect the overall air quality. One way to accomplish this is through computer modeling. A computer model simulates how pollutants disperse, react, and move in the air. The inputs to such a computer model are complex. They include weather patterns, terrain, and the chemical nature of air pollutants.\\n(Source: APCD)"], "emission situation": ["The overall state regarding pollutant emission in a given area."], "emission standard": ["The maximum amount of discharge legally allowed from a single source, mobile or stationary."], "employment": ["Productive activity, service, trade, or craft for which one is regularly paid.", "The work or occupation in which a person is employed.", "Act through which a subordinated work contract starts."], "emulsification": ["The process of dispersing one liquid in a second immiscible liquid."], "emulsion": ["A stable dispersion of one liquid in a second immiscible liquid, such as milk (oil dispersed in water)."], "endocrine system": ["The chemical coordinating system in animals, that is, the endocrine glands that produce hormones."], "endocrinology": ["The study of the endocrine glands and the hormones that they synthesize and secrete.\\n(Source: MGH)"], "energy": ["The capacity to do work; involving thermal energy (heat), radiant energy (light), kinetic energy (motion) or chemical energy; measured in joules.", "A source of power, such as fuel and electrical energy, used for driving machines, providing light and heat, and powering electric devices."], "energy balance": ["The energetic state of a system at any given time."], "energy conservation": ["The reduction of energy consumption through efficient energy use."], "energy consumption": ["Amount of energy consumed by a person or an apparatus."], "energy conversion": ["The process of changing energy from one form to another."], "energy demand": ["Amount of energy needed by a person or an apparatus."], "energy economics": ["The production, distribution, and consumption of usable power such as fossil fuel, electricity, or solar radiation.\\n(Source: RHW)"], "energy management": ["The administration or handling of power derived from sources such as fossil fuel, electricity and solar radiation."], "energy market": ["The trade or traffic of energy sources treated as a commodity (such as fossil fuel, electricity, or solar radiation).\\n(Source: RHW)"], "energy policy": ["A statement of a country's intentions in the energy sector."], "energy production": ["Generation of energy in a coal fired power station, in an oil fired power station, in a nuclear power station, etc."], "energy recovery": ["A form of resource recovery in which the organic fraction of waste is converted to some form of usable energy. Recovery may be achieved through the combustion of processed or raw refuse to produce steam through the pyrolysis of refuse to produce oil or gas; and through the anaerobic digestion of organic wastes to produce methane gas.\\n(Source: LANDY)"], "energy resource": ["Potential supplies of energy which have not yet been used (such as coal lying in the ground, solar heat, wind power, geothermal power, etc.).\\n(Source: PHC)"], "energy saving": ["A set of strategies for avoiding wasting energy."], "energy source": ["Potential supplies of energy including fossil and nuclear fuels as well as solar, water, wind, tidal and geothermal power.\\n(Source: PHC)"], "energy technology": ["Technology used to produce energy."], "enforcement": ["The execution, carrying out or putting into effect an order, regulation, law or official decree."], "enriched uranium": ["Uranium whose concentration of uranium-235, which is able to sustain a nuclear chain reaction, is increased by removing uranium-238.\\n(Source: ALL)"], "enrichment": ["The process of increasing the abundance of a specified isotope in a mixture of isotopes. It is usually applied to an increase in the proportion of U-235, or the addition of Pu-239 to natural uranium for use in a nuclear reactor or weapon."], "environmental auditing": ["An assessment of the nature and extent of any harm or detriment, or any possible harm or detriment, that may be inflicted on any aspect of the environment by any activity process, development programme, or any product, chemical, or waste substance. Audits may be designed to: verify or otherwise comply with environmental requirements; evaluate the effectiveness of existing environmental management systems; assess risks generally; or assist in planning for future improvements in environment protection and pollution control\\n(Source: GILP96)"], "environmental awareness": ["The growth and development of awareness, understanding and consciousness toward the biophysical environment and its problems, including human interactions and effects."], "environmental chemistry": ["Science dealing with the physical, chemical and biochemical processes that polluting substances undergo when introduced in the environment."], "environmental cost": ["Expenses incurred as a result of some violation of ecological integrity either by an enterprise that implements a program to rectify the situation, or by society or the ecosystem as a whole when no person or enterprise is held liable."], "environmental crime": ["An unlawful act against the environment, such as water contamination, hazardous waste disposal, air contamination, unpermitted installation of plants, oil spills, etc.\\n(Source: AZENPa)", "An unlawful act against the environment, such as water contamination, hazardous waste disposal, air contamination, unpermitted installation of plants, oil spills, etc."], "environmental criminal law": ["The aggregate of statutory enactments pertaining to actions or instances of ecological negligence deemed injurious to public welfare or government interests and legally prohibited."], "environmental damage": ["Harm done to the environment, e.g. loss of wetlands, pollution of rivers, etc."], "environmental economics": ["A subfield of economics concerned with environmental issues."], "environmental education": ["The educational process that deals with the human interrelationships with the environment and that utilizes an interdisciplinary problem-solving approach with value clarification. Concerned with education progress of knowledge, understanding, attitudes, skills, and commitment for environmental problems and considerations. The need for environmental education is continuous, because each new generation needs to learn conservation for itself.\\n(Source: UNUN)"], "environmental ethics": ["An ecological conscience or moral that reflects a commitment and responsibility toward the environment, including plants and animals as well as present and future generations of people. Oriented toward human societies living in harmony with the natural world on which they depend for survival and well being.\\n(Source: UNUN)"], "environmental history": ["A systematic and chronological account of past events and conditions relating to the ecosystem, its natural resources or, more generally, the external factors surrounding and affecting human life.\\n(Source: TOE)"], "environmental impact": ["Any alteration of environmental conditions or creation of a new set of environmental conditions, adverse or beneficial, caused or induced by the action or set of actions under consideration."], "environmental indicator": ["A measurement, statistic or value that provides a proximate gauge or evidence of the effects of environmental management programs or of the state or condition of the environment."], "environmental informatics": ["Science and techniques of data elaboration and of computer processing of information concerning ecosystems and ecology."], "environmental investment": ["Securities held for the production of income in the form of interest and dividends with the aim of benefitting the environment.\\n(Source: ISEP /  EFP)"], "environmental legislation": ["Branch of law relating to pollution control; national parks, wildlife, fauna and flora, wilderness and biodiversity; environmental and occupational health; environmental planning; heritage conservation and a large number of international conventions relating to the environment.\\n(Source: GILP96)"], "environmental legislation on agriculture": ["A binding rule or body of rules prescribed by a government to regulate any aspect of farm and livestock production that poses a threat to ecological integrity and human health, especially the use of pesticides, fertilizers and land."], "environmental liability": ["The penalty to be paid by an organization for the damage caused by pollution and restoration necessary as a result of that damage, whether by accidental spillages from tankers, industrial waste discharges into waterways or land, or deliberate or accidental release of radioactive materials."], "environmentally unfriendly firm": ["Firm that dores not comply with environmental regulations for the disposal of noxious wastes generated during the production cycle."], "environmental medicine": ["The art and science of the protection of good health, the promotion of aesthetic values, the prevention of disease and injury through the control of positive environmental factors, and the reduction of potential physical, biological, chemical, and radiological hazards."], "environmental policy": ["Official statements of principles, intentions, values, and objective which are based on legislation and the governing authority of a state and which serve as a guide for the operations of governmental and private activities in environmental affairs."], "environmental pollution": ["The introduction by man into the environment of substances or energy liable to cause hazards to human health, harm to living resources and ecological systems, damage to structure or amenity, or interference with legitimate uses of the environment.\\n(Source: GRAHAW)"], "environmental protection": ["Measures and controls to prevent damage and degradation of the environment, including the sustainability of its living resources."], "environmental protection cost": ["The amount of money incurred in the preservation, defense, or shelter of natural resources.\\n(Source: EFP / OED)"], "environmental psychology": ["A branch of experimental psychology which studies the relationships between behavior and the environmental context in which it occurs."], "environmental quality": ["Properties and characteristics of the environment, either generalized or local, as they impinge on human beings and other organisms. Environmental quality is a general term which can refer to: varied characteristics such as air and water purity or pollution, noise, access to open space, and the visual effects of buildings, and the potential effects which such characteristics may have on physical and mental health.\\n(Source: LANDY)"], "environmental report": ["An account or statement, usually in writing, describing in detail events, situations or conditions pertaining to the ecosystem, its natural resources or any of the external factors surrounding and affecting human life.\\n(Source: TOE)"], "environmental research": ["The study of the environment and its modifications caused by human activities."], "environmental risk assessment": ["Qualitative and quantitative evaluation of the risk posed to the environment by the actual or potential presence and/or use of specific pollutants.\\n(Source: OPPTIN)"], "environmental science": ["The interdisciplinary study of environmental problems, within the framework of established physical and biological principles, i.e. oriented toward a scientific approach."], "environmental security": ["Measures taken or policies instituted to protect and promote the safety of external conditions affecting the life, development and survival of an organism.\\n(Source: TOE)"], "environmental specimen bank": ["Places in which selected specimens (fish, mussels, milk, soil sample and human tissue, etc.) are stored without being allowed to decompose."], "environmental subsidy": ["Payment by a government to assist or improve performance regarding ecological maintenance or the protection, defense, or shelter of natural resources.\\n(Source: ODE)"], "environmental terminology": ["The vocabulary of technical terms and usage appropriate to community, corporate, governmental and other groups concerned with protecting natural resources, preserving the integrity of the ecosystem and safeguarding human health.\\n(Source: ISEP /  TOE)"], "environmental vandalism": ["The egregious or blatant destruction of delicate ecosystems, especially in violation of environmental protection laws."], "environmental warfare": ["The direct manipulation or destruction of ecological resources as either a political threat or for actual military advantage."], "environment": ["The set of all natural systems, including the air, land, water, and living things other than humans.", "The set of all natural and human-made surroundings that affect individuals, social groupings, and other life.", "The complex of physical, chemical, and biotic factors that surround and act upon a specific organism or upon a specific group of organisms."], "enzyme": ["Any of a group of catalytic proteins that are produced by living cells and that mediate and promote the chemical processes of life without themselves being altered or destroyed."], "epidemic": ["A sudden increase in the incidence rate of a disease to a value above normal, affecting large numbers of people and spread over a wide area.", "Spreading rapidly and extensively by infection and affecting many individuals in an area or a population at the same time."], "epidemiology": ["The study of the occurrence and distribution of disease and injury specified by person, place, and time."], "equine": ["An animal belonging to the family of Equidae."], "equipment": ["Any collection of materials, supplies, instrumentality or apparatuses stored, furnished or provided for an undertaking, service or activity."], "equivalent dose": ["A quantity used in radiation protection, expressing all radiation on a common scale for calculating the effective absorbed dose."], "ergonomics": ["The study of human capability and psychology in relation to the working environment and the equipment operated by the worker."], "erosion": ["The general process or the group of processes whereby the materials of Earth's crust are loosened, dissolved, or worn away and simultaneously moved from one place to another, by natural agencies, which include weathering, solution, corrosion, and transportation, but usually exclude mass wasting.\\n(Source: BJGEO)"], "erosion control": ["Practices used during construction or other land disturbing activities to reduce or prevent soil erosion."], "estuarine biology": ["The scientific study of the characteristic life processes of living organisms found in a semi-enclosed coastal body of water which has a free connection with the open sea and within which sea water is measurably diluted with freshwater.\\n(Source: WOR / MHE / APD)"], "estuarine oceanography": ["The study of the physical, chemical, biological and geological characteristics of a semi-enclosed coastal body of water which has a free connection with the open sea and within which sea water is measurably diluted with fresh water.\\n(Source: MHE / APD)"], "estuary": ["A river mouth or stream mouth is a part of a river where it flows into the sea, river, lake, reservoir or ocean.", "Area at the mouth of a river where it broadens into the sea, and where fresh and sea water intermingle to produce brackish water. The estuarine environment is very rich in wildlife, particularly aquatic, but it is very vulnerable to damage as a result of the actions of humans.\\n(Source: WRIGHT)"], "etching substance": ["Substance capable of wearing away the surface of a metal, glass, etc. by chemical action."], "ether": ["A colorless liquid, slightly soluble in water; used as a reagent, intermediate, anesthetic, and solvent.\\n(Source: MGH)", "A class of chemical compounds which contain an oxygen atom connected to two (substituted) alkyl groups."], "ethics": ["The philosophical study of the moral value of human conduct and of the rules and principles that ought to govern it."], "ethnology": ["The science that deals with the study of the origin, distribution, and relations of races or ethnic groups of mankind."], "ethology": ["The study of animal behaviour in a natural context."], "EU Council": ["The Council of the European Union is an institution which exercises legislative and decision-making powers. At the same time, it is the forum in which the representatives of the Governments of the 15 Member States can assert their interests and try to reach compromises. The Council ensures general coordination of the activities of the European Community, the main objective of which is the establishment of an internal market, i.e. an area without internal frontiers guaranteeing four freedoms of movement - for goods, persons, services and capital - to which should soon be added a single currency. In addition, the Council is responsible for intergovernmental cooperation, in common foreign and security policy (CFSP) and in the areas of justice and home affairs (JHA), including for example matters of immigration and asylum, combating terrorism and drugs and judicial cooperation.\\n(Source: UEEU)"], "Euratom": ["A precursor to the European Community, the European Atomic Energy Community was founded in 1958 by the European Common Market to conduct research, develop nuclear energy, create a common market for nuclear fuels and supervise the nuclear industry so as to prevent abuse and protect health.\\n(Source: ERD)"], "Europe": ["The second smallest continent, forming the Western extension of Eurasia: the border with Asia runs from the Urals to the Caspian and the Black Sea."], "European Commission": ["The European Union's administrative body, composed of twenty independent members appointed by the Member States for five-year terms and vested with powers of initiative, implementation, management and control according to the mandates established in EU Treaties or handed down by the EU Council."], "European Court of Justice": ["The supreme court of The European Union which oversees the application of the\\nEU treaties, decides upon the validity and the meaning of Community legislation and determines whether any act or omission by the European Commission, the Council of Minister or any member state constitutes a breach of Community law."], "European Environment Agency": ["The EEA is being set up to provide the European Community and its member states with objective, reliable and standardized information on the environment. It will assess the success of existing environmental policies and the data will be used to develop new policies for environmental protection measures. It will gather information covering the present, and foreseeable, state of the environment. The priority area are: air quality and emissions; water quality, pollutants and resources; soil quality, flora and fauna, and biotopes; land use and natural resources; waste management; noise pollution; chemicals; and protection of coastal areas. The Agency will also take into account the socio-economics dimension, cover transboundary and international matters, and avoid the duplication of the activities of other bodies.\\n(Source: WRIGHT)"], "European Environmental Council": ["Council of European Union environment ministers that aims to preserve the quality of the environment, human health, the prudent and rational utilisation of natural resources and to promote measures at international level to deal with regional or worldwide environmental problems."], "European Parliament": ["Formerly the \"Assembly\" of EEC. Comprises some 520 \"representatives of the peoples\" of European Community states, directly elected, and based in Strasbourg. Exercises advisory and supervisory powers; debates and passes resolutions and may veto admission of new member states.\\n(Source: CURZON)"], "European Union": ["The 27 nations (Austria, Belgium, Bulgaria, Cyprus, Czechia, Denmark, Estiona, Finland, France, Germany, Greece, Hungary, Ireland, Italy, Latvia, Luxembourg, Malta, the Netherlands, Poland, Portugal, Romania, Slovakia, Slovenia, Spain, Sweden and the UK) that have joined together to form an economic community with common monetary, political and social aspirations."], "eutrophication": ["A process of pollution that occurs when a lake or stream becomes over-rich in plant nutrient and as a consequence becomes overgrown in algae and other aquatic plants."], "evaluation": ["An assessment or a summary of a particular situation."], "evaporation": ["Conversion from a liquid or solid state to a vapour."], "evapotranspiration": ["Discharge of water from the earth's surface to the atmosphere by evaporation from lakes, streams and soil surfaces and by transpiration from plants."], "evolution": ["The biological theory or process whereby species of plants and animals change with the passage of time so that their descendants differ from their ancestors, i.e. development from earlier forms by hereditary transmission of slight variations in successive generations.", "A gradual process of development, formation, or growth, especially, one leading to a more advanced or complex form."], "exact science": ["Mathematics and other sciences based on calculation."], "excavated hole": ["A pit, cavity, or other uncovered cutting produced by excavation."], "executive order": ["An order or regulation issued by the president or some administrative authority under his direction for the purpose of interpreting, implementing or giving administrative effect to a provision of the constitution or of some law or treaty."], "exhaust device": ["A duct or pipe through which waste material is emitted; a combination of components which provides for enclosed flow of exhaust gas from engine parts to the atmosphere.\\n(Source: AMHER /  LEE)"], "exhaust gas": ["Offgas produced during combustion processes discharged directly or ultimately to the atmosphere."], "exotic species": ["Plants, animals or microorganisms which are introduced by humans into areas where they are not native. Exotics are often associated with negative ecological consequences for native species and the ecosystems."], "expenditure": ["Spending by consumers, investors, or government for goods or services."], "experiment": ["A test under controlled conditions that is made to demonstrate a known truth, examine the validity of a hypothesis, or determine the efficacy of something previously untried.", "To conduct an experiment or investigation.", "To try something new, as in order to gain experience."], "expert system": ["A computer configuration of hardware and software that simulates the judgment and behavior of a human or an organization with extensive knowledge in a particular field, often by giving answers, solutions or diagnoses.\\n(Source: RHW / WIC)"], "exploration": ["A careful systematic search."], "explosion": ["A violent, sudden release of energy resulting from powders or gases undergoing instantaneous ignition or from some other means of detonation, often accompanied by a force producing great amounts of heat, major structural damages, shock waves and flying shrapnel.\\n(Source: HMD)"], "explosive": ["A substance, such as trinitrotoluene, or a mixture, such as gunpowder, that is characterized by chemical stability but may be made to undergo rapid chemical change without an outside source of oxygen, whereupon it produces a large quantity of energy generally accompanied by the evolution of hot gases.", "With the capability to, or likely to, explode.", "Liable to lead to sudden change or violence."], "export": ["To send, take or carry an article of trade or commerce out of the country.", "Any good or commodity, transported from one country to another country in a legitimate fashion, typically for use in trade."], "exposure": ["The time for which a material is illuminated or irradiated."], "expropriation": ["The act of depriving an owner of private property for public use."], "extensive cattle farming": ["Farming system practiced in very large farms, characterized by low levels of inputs per unit area of land; in such situations the stocking rate, the number of livestock units per area, is low."], "externality": ["Discrepancies between private costs and social costs or private advantages and social advantages; the basic concept of externality is interdependence without compensation."], "extraction": ["Any process by which a pure metal is obtained from its ore.\\n(Source: UVAROV)"], "extractive industry": ["Primary activities involved in the extraction of non-renewable resources.\\n(Source: GOOD)"], "fabric": ["Any cloth made from yarn or fibres by weaving, knitting, felting, etc."], "factor market": ["A market where services of the factors of production (not the actual factors of production) are bought and sold."], "fallout": ["The descent of airborne solid or liquid particles to the ground, which occurs when the speed at which they fall due to gravity exceeds that of any upward motion of the air surrounding them."], "fallow area": ["Land area normally used for crop production but left unsown for one or more growing seasons."], "fallow land": ["Arable land not under rotation that is set at rest for a period of time ranging from one to five years before it is cultivated again, or land usually under permanent crops, meadows or pastures, which is not being used for that purpose for a period of at least one year. Arable land which is normally used for the cultivation of temporary crops but which is temporarily used for grazing is included."], "family": ["A group comprising parents, offsprings and others closely related or associated with them.", "A group of persons sharing a home or living space, who aggregate and share their incomes, as evidenced by the fact that they regularly take meals together.", "A biological taxon, a group of animals or plants, part of an order and consisting of one or more genera.", "Of or related to a family."], "family planning": ["The control of the number of children in a family and of the intervals between them, especially by the use of contraceptives."], "famine": ["A severe shortage of food, as through crop failure or over population. It may be due to poor harvests following drought, floods, earthquake, war, social conflict, etc."], "farm animal": ["Animals reared in farms for working and producing food such as meat, eggs and milk."], "farm": ["Any tract of land or building used for agricultural purposes, such as for raising crops and livestock."], "fauna": ["The entire animal life of a given region, habitat or geological stratum."], "federal government": ["A system in which a country or nation formed by a union or confederation of independent states is governed by a central authority or organization."], "federal law": ["A binding rule or body of rules established by a government that has been constituted as a union of independent political units or states."], "fee": ["A charge fixed by law for services of public officers or for use of a privilege under control of government."], "fen": ["Waterlogged, spongy ground containing alkaline decaying vegetation, characterized by reeds, that may develop into peat. It sometimes occurs in the sinkholes of karst region."], "fermentation": ["Any enzymatic transformation of organic substrates, especially carbohydrates, generally accompanied by the evolution of gas."], "fern": ["Any of a large number of vascular plants composing the division Polypodiophyta, without flowers and fruits.\\n(Source: MGH)"], "fibre": ["The portion of plant products that moves through the human digestive system without being digested."], "field": ["A limited area of land with grass or crops growing on it, which is usually surrounded by fences or closely planted bushes when it is part of a farm.", "A particular environment or walk of life.", "A single aspect of each member of an entity in a database.", "A land area free of woodland or human settlements.", "The open country near or belonging to a city.", "A region affected by a particular force.", "An area that can be seen at a given time.", "A place where a battle is fought.", "A realm of practical, direct, or natural operation, contrasting with an office, classroom, or laboratory.", "A number system w\u0131th functions that has the same properties relative to the operations of addition and multiplication used for real numbers.", "A region containing a particular mineral.", "The background of the shield.", "An area of memory or storage reserved for a particular value.", "A component of a database record in which a single unit of information is stored.", "A physical or virtual location for the input of information in the form of characters.", "To intercept or catch (a ball) and play it.", "To be the team catching and throwing the ball, as opposed to hitting it.", "To place a team in (a game)."], "field damage": ["A decline in the productivity of an area of land or in its ability to support natural ecosystems or types of agriculture."], "field experiment": ["Experiment carried out on a substance or on an organism in the open air as opposed to in a laboratory."], "field study": ["Scientific study made in the open air to collect information that can not be obtained in a laboratory."], "filling material": ["Any substance used to fill the holes and irregularities in planed or sanded surfaces so as to decrease the porosity of the surface for finish coatings."], "filling station": ["A place where petrol and other supplies for motorists are sold.", "A facility selling fuel for road motor vehicles."], "film": ["A sequence of animated images.", "A thin covering layer, often about something temporarily deposited on the surface.", "To capture a motion picture onto film.", "To become covered by a thin layer.", "A thin flexible strip of cellulose coated with a photographic emission, used in cameras to make negatives and transparencies, capture motion pictures, etc."], "filter": ["A porous material for separating suspended particulate matter from liquids by passing the liquid through the pores in the filter and sieving out the solids.\\n(Source: MGH)", "Any item, mechanism, device or procedure that acts to separate or isolate.", "To separate or isolate components from one another with the help of a filter."], "filter cake": ["Accumulated solids, wet or dry, generated by any filtration process, including accumulation on fabric filters in air filtering processes, or accumulation of wet solids in liquid filtering processes.\\n(Source: EED /  ISEP)"], "filtration": ["Separation of suspended particles from a liquid, gas, etc., by the action of a filter.", "The act of filtering."], "financial compensation": ["The financial reparations that a claimant seeks or a court awards for injuries sustained or property harmed by another.\\n(Source: IVW)"], "financial market": ["A place or institution in which buyers and sellers meet and trade monetary assets, including stocks, bonds, securities and money."], "financing": ["Procurement of monetary resources or credit to operate a business or acquire assets."], "fine": ["A pecuniary punishment or penalty imposed by lawful tribunal upon person convicted of crime or misdemeanor."], "fine dust": ["Air-borne solid particles, originating from human activity and natural sources, such as wind-blown soil and fires, that eventually settle through the force of gravity, and can cause injury to human and other animal respiratory systems through excessive inhalation."], "fire": ["The state of combustion in which inflammable material burns, producing heat, flames and often smoke.", "An unwanted and uncontrolled burning of matter.", "Intense adverse criticism.", "To terminate the employment of one or more employees.", "Uncontrolled burning, conflagration."], "fire precaution": ["Measure, action or installation implemented in advance to avert the possibility of any unexpected and potentially harmful combustion of materials.\\n(Source: RHW)"], "fire protection": ["All necessary precautions to see that fire is not initiated, by ensuring that all necessary fire fighting apparatus is in good order and available for use if fire should break out, and by ensuring that personnel are properly trained and drilled in fighting fire."], "fire safety requirement": ["Rules to be followed and safety systems to be adopted for preventing or fighting fire.\\n(Source: RRDA)"], "fire service": ["Organisation with trained personnel for dealing with fires and other incidents and for co-operating in their prevention."], "firing": ["The process of applying fire or heat, as in the hardening or glazing of ceramics.\\n(Source: HARRIS)"], "firm": ["A commercial association of two or more persons, especially when incorporated.", "Resistant to pressure.", "A place where an activity is accomplished, whether actual, as a pub, or virtual, as a website.", "Fixed; closely compressed.", "Marked by firm determination or resolution; not shakable.", "Strong and sure (e.g. grasp)."], "fish disease": ["An illness affecting fish, including bacterial, viral and fungal infections, parasites and maltnutrition."], "fishery": ["The industry of catching, processing and selling fish."], "fish": ["A cold-blooded vertebrate animal that lives in water that moves with the help of fins and breathes using gills (Pisces).", "To catch or try to catch fish.", "A new inmate in a prison."], "fish farming": ["Raising of fish in inland waters, estuaries or coastal waters."], "fishing": ["The art or sport of catching fish with a rod and line and a baited hook or other lure, such as a fly.", "The attempt to catch fish or other aquatic animal with a hook or with nets, traps, etc."], "fishing industry": ["Industry for the handling, processing, and packing of fish or shellfish for market or shipment."], "fishing vessel": ["Ship or boat that is used to catch fish on seas, lakes or rivers."], "fish stock": ["The population of fish in a certain area."], "flag of convenience": ["Practice of registering a merchant vessel with a country that has favourable (i.e. less restrictive ) safety requirements, registration fees, etc."], "flaring": ["1) Flares use open flames during normal and/or emergency operations to combust hazardous gaseous. The system has no special features to control temperature or time of combustion; however, supplemental fuel may be required to sustain the combustion. Historically, flares have been used to dispose of waste gases in the oil and gas industry and at wastewater treatment plants having anaerobic digestors. Regulation for thermal destruction of hazardous wastes limit the practical use of flaring to combustion of relatively simple hydrocarbons, such as methane from digesters or landfill gas collection systems. \\n2) A control device that burns hazardous materials to prevent their release into the environment; may operate continuously or intermittently, usually on top a stack.\\n(Source: CORBIT /  EPAGLO)"], "rapid test": ["Medical test whose results are available very quickly."], "flea": ["Any of the wingless insects composing the order Siphonaptera; most are ectoparasites of mammals and birds.\\n(Source: MGH)"], "flocculant": ["A reagent added to a dispersion of solids in a liquid to bring together the fine particles to form flocs."], "flocculation": ["A process of contact and adhesion whereby the particles of a dispersed substance form large clusters or the aggregation of particles in a colloid to form small lumps, which then settle out."], "flood": ["An overflowing; an inundation or flood, especially when the water is charged with much suspended material.\\n(Source: BJGEO)", "An unusual accumulation of water above the ground caused by high tide, heavy rain, melting snow or rapid runoff from paved areas.", "To cover with large amounts of water."], "flooding": ["A general and temporary condition of partial or complete inundation of normally dry land areas from the overflow of inland and/or tidal waters, and/or the unusual and rapid accumulation or runoff of surface waters from any source."], "flora restoration": ["The process of returning plant ecosystems and habitats to their original conditions."], "flotation": ["A process used to separate particulate solids by causing one group of particles to float; utilizes differences in surface chemical properties of the particles, some of which are entirely wetted by water, others are not."], "flow": ["The flowing of a fluid.", "To move as a fluid from one position to another (e.g. of people).", "To move along, of liquids."], "flower": ["The reproductive structure of angiosperm plants, consisting of stamens and carpels surrounded by petals and sepals all borne on the receptacle.", "A plant that is cultivated or admired for its beautiful blossoms.", "(Of a plant) To produce blooms or flowers."], "flowering plant": ["The division of seed plants that includes all the flowering plants, characterized by the possession of flowers. The ovules, which become seeds after fertilization, are enclosed in ovaries. The xylem contains true vessels. The angiospermae are divided into two subclasses: Monocotyledoneae and Dycotiledoneae.\\n(Source: ALL)", "Member of the angiosperm, the class of seed plants that includes all the flowering plants."], "flow field": ["The velocity and the density of a fluid as functions of position and time."], "flowing water": ["Moving waters like rivers and streams."], "flue gas": ["The gaseous combustion product generated by a furnace and often exhausted through a chimney (flue)."], "fluidised bed": ["A bed of finely divided solid through which air or a gas is blown in a controlled manner so that it behaves as a liquid."], "fluoridation": ["The addition of the fluorine ion to municipal water supplies in a final concentration of 0.8-1.6 ppm (parts per million) to help prevent dental caries in children."], "fluorine": ["A gaseous chemical element with symbol F and atomic number 9; a member of the halide family, it is the most electronegative element and the most chemically energetic of the nonmetallic elements; highly toxic and corrosive; used in rocket fuels and as a chemical intermediate.\\n(Source: MGH)"], "river transport": ["Transportation of goods or persons by means of ships travelling on rivers."], "fly ash": ["Finely divided particles of ash that are entrained in flue gases resulting from the combustion of fuel or other material."], "foaming agent": ["A substance which makes it possible to form a homogenous dispersion of a gaseous phase in a liquid or solid medium."], "fodder": ["Bulk feed for livestock, especially hay, straw, etc.\\n(Source: CED)"], "fog": ["Water droplets or, rarely, ice crystals suspended in the air in sufficient concentration to reduce visibility appreciably.", "To hide from view."], "mist": ["Fine water droplets suspended in the air, which reduce visibility. Usually mists form at night, when the temperature falls because the sky is clear. If visibility falls below 1,000 metres, the mist becomes a fog."], "foliage": ["The leaves of a plant together."], "food": ["A substance that can be ingested and utilized by the organism as a source of nutrition and energy."], "food additive": ["Substances that have no nutritive value in themselves (or are not being used as nutrients) which are added to food during processing to improve colour, texture, flavour, or keeping qualities."], "food chain": ["A sequence of organisms on successive trophic levels within a community, through which energy is transferred by feeding; energy enters the food chain during fixation by primary producers (mainly green plants) and passes to the herbivores (primary consumers) and then to the carnivores (secondary and tertiary consumers)."], "food hygiene": ["That part of the science of hygiene that deals with the principles and methods of sanitation applied to the quality of foodstuffs, to their processing, preparation, conservation and consumption by man."], "food industry": ["The commercial production and packaging of foods that are fabricated by processing, by combining various ingredients, or both."], "food irradiation": ["The process of applying high energy to food products, to sterilize them and extend their shelf-life by killing microorganisms, insects and other pests residing on it."], "food preservation": ["Processing designed to protect food from spoilage caused by microbes, enzymes, and autooxidation."], "food quality": ["The quality characteristics of food that is acceptable to consumers."], "food science": ["The applied science which deals with the chemical, biochemical, physical, physiochemical, and biological properties of foods."], "foodstuff": ["A substance that can be used or prepared for use as food."], "food technology": ["The application of science and engineering to the refining, manufacturing, and handling of foods; many food technologists are food scientists rather than engineers."], "footpath": ["A narrow path for walkers only."], "forage contamination": ["Introduction of hazardous or poisonous substances such as arsenic or lead into, or onto, fodder for animals."], "forecast": ["An estimate of a future condition."], "foreign policy": ["The diplomatic policy of a nation in its interactions with other nations."], "foreign trade": ["Trade between countries and firms belonging to different countries."], "forest": ["A vegetation community dominated by trees and other woody shrubs, growing close enough together that the tree tops touch or overlap, creating various degrees of shade on the forest floor.", "In graph theory, a disjoint union of trees."], "forest damage": ["Reduction of tree population in forests caused by acidic precipitation, forest fires, air pollution, deforestation, pests and diseases of trees, wildlife, etc."], "forest ecosystem": ["Any forest environment, in which plants and animals interact with the chemical and physical features of the environment, in which they live."], "forest fire": ["A conflagration in or destroying large wooded areas having a thick growth of trees and plants."], "forest pest": ["Organism that damages trees."], "forest policy": ["A course of action adopted and pursued by government or some other organization, which seeks to preserve or protect an extensive area of woodland, often to produce products and benefits such as timber, wildlife habitat, clean water, biodiversity and recreation."], "forest reserve": ["Forest area set aside for the purpose of protecting certain fauna and flora, or both."], "forestry": ["The management of forest lands for wood, forages, water, wildlife, and recreation."], "forestry practice": ["The farming of trees to ensure a continuing supply of timber and other forest products. Foresters care for existing trees, protecting them from fire, pests and diseases, and felling where trees are overcrowded or dying and when ready for cropping. They also plant new areas (afforestation) and replant felled areas (reafforestation).\\n(Source: GOOD)"], "fossil": ["Any remains, trace, or imprint of a plant or animal that has been preserved in the Earth's crust since some past geologic or prehistoric time."], "fossil fuel": ["The energy-containing materials which were converted over many thousands of years from their original form of trees, plants and other organisms after being buried in the ground."], "four stroke engine": ["An internal combustion engine whose cycle is completed in four piston strokes; includes a suction stroke, compression stroke, expansion stroke, and exhaust stroke."], "framework legislation": ["A body of rules prescribed by a government, often composed in a series of inter-related parts, to establish or lay the foundation for a new project, agency or organizational structure.\\n(Source: RHW)"], "access to information": ["The ability, right and permission to approach and use, or the general availability of resources that convey knowledge."], "freight transport": ["Transportation of goods by ship, aircraft or other vehicles."], "freon": ["Trade name for a group of polyhalogenated hydrocarbons containing fluorine and chlorine; an example is trichlorofluoromethane."], "freshwater": ["Water having a relatively low mineral content, generally less than 500 mg/l of dissolved solids."], "freshwater biology": ["The scientific study of the characteristic life processes of living organisms found in a natural body of water that does not contain significant amounts of dissolved salts and minerals, such as a lake or river."], "freshwater ecosystem": ["The living organisms and nonliving materials of an inland aquatic environment."], "freshwater organism": ["Organism which lives in freshwater.\\n\\n(Source: PHC)"], "frog": ["Any insectivorous anuran amphibian of the family Ranidae, such as Rana temporaria of Europe, having a short squat tailless body with a moist smooth skin and very long hind legs specialized for hopping."], "frost": ["A deposit of interlocking ice crystals formed by direct sublimation on objects.\\n(Source: MGH)"], "fruit": ["A fully matured plant ovary with or without other floral or shoot parts united with it at maturity.", "A botanical fruit that can be eaten raw used as food."], "fruit cultivation": ["Cultivation of fruit trees for home consumption or on a commercial basis."], "fruit tree": ["Any tree that bears edible fruit.\\n(Source: CED)"], "fuel": ["Solid, liquid, or gaseous material such as gas, gasoline, oil, coal or wood, used to produce heat or power by burning."], "fuel additive": ["Substance (such as tetraethyl lead) which is added to petrol to prevent knocking."], "fuel alcohol": ["Alternative source of energy for motor vehicles. It is produced by fermentation of sugar cane by the yeast Saccharomyces cerevisiae.\\n(Source: DICCHE)"], "fuel consumption": ["The amount of fuel utilized.\\n(Source: PHCa)"], "fuel oil": ["A liquid product burned to generate heat, exclusive of oils with a flash point below 38\u00b0C; includes heating oils, stove oils, furnace oils, bunker fuel oils.\\n(Source: MGH)"], "fuel wood": ["Wood used for heating."], "fume": ["Solids in the air that have been generated by the condensation of vapors, chemical reactions or sublimation (a direct change from solid to gas). Often metallic oxides or metals, these particles are less than 1 micrometer in diameter and may be toxic.\\n(Source: ALL)"], "fumigation": ["The use of a chemical compound in a gaseous state to kill insects, nematodes, arachnids, rodents, weeds, and fungi in confined or inaccessible locations; also used to control weeds, nematodes, and insects in the field."], "functional substance": ["A substance from the point of view of its function or purpose, for example a painting agent or a preserving substance."], "mycete": ["Nucleated usually filamentous, sporebearing organisms devoid of chlorophyll."], "fungus": ["Nucleated usually filamentous, sporebearing organism devoid of chlorophyll."], "fungicide": ["A chemical used to kill or halt the development of fungi that cause plant disease."], "fur": ["The hair-covered, dressed pelt of a mammal, used in the making of garments and as trimming or decoration."], "fur animal": ["Animal bred and slaughtered for its fur."], "furan": ["A colourless flammable toxic liquid heterocyclic compound, used in the synthesis of nylon.\\n(Source: CED)"], "furnace": ["A structure or apparatus in which heat is produced by the combustion of fuel, often to warm houses, melt metals, produce steam and bake pottery."], "furniture": ["The movable articles in a room or an establishment that make it fit for living or working.", "A movable object (such as a table, chair, lamp) inside a dwelling, that is useful or decorative."], "furriery": ["The business or trade of dressed furs and garments made from the coats of certain animals."], "gamma radiation": ["A form of electromagnetic radiation or light emission of frequencies produced by sub-atomic particle interactions, such as electron-positron annihilation or radioactive decay."], "garden": ["A piece of land next to a house where flowers and other plants are grown and which often has an area of grass.", "To grow plants in a garden; to create or maintain a garden."], "garden waste": ["Natural organic matter discarded from gardens and yards including leaves, grass clippings, prunings, brush and stumps."], "garrigue": ["Mediterranean bush consisting of low evergreen shrubs and abundant herbaceous plants."], "gas": ["A substance that continues to occupy in a continuous manner the whole of the space in which it is placed, however large or small this place is made, the temperature remaining constant.", "A fuel for internal combustion engines consisting essentially of volatile flammable liquid hydrocarbons derived from crude petroleum.", "To show off."], "gas chromatography": ["A separation technique involving passage of a gaseous moving phase through a column containing a fixed phase; it is used principally as a quantitative analytical technique for volatile compounds.\\n(Source: MGH)"], "gas company": ["Company charged with the production and distribution of gas for domestic use.\\n(Source: RRDA)"], "gas engine": ["An internal combustion engine that uses gaseous fuel."], "gaseous state": ["State of matter in which the matter concerned occupies the whole of its container irrespective of its quantity.\\n(Source: DICCHE)"], "gasification": ["Any chemical or heat process used to convert a substance to a gas."], "gas liquefaction": ["Conversion of a gas to the liquid phase by cooling or compression."], "gas mixture": ["Mixture of two or more different gases."], "gas network": ["Interconnected system of pipes for the distribution and supply of gas."], "gasohol": ["A mixture of 80% or 90% petrol with 20% or 10% ethyl alcohol, for use as a fuel in internal combustion engines."], "gasoline engine": ["An internal combustion engine that uses a mixture of air and gasoline vapour as a fuel."], "gas pipeline": ["A long pipe, especially underground, used to transport gas over long distances."], "gas powered plant": ["Power station which burns gas, as opposed to a coal-fired station or nuclear power station."], "gas purification": ["Removal of pollutants or contaminants from waste incineration or other combustion processes.\\n(Source: MGHa)"], "gas reservoir": ["Large tank for storing coal gas or natural gas.\\n(Source: PHC)"], "gas supply": ["The provision and storage of any fuel gas, for the use of a municipality, or other fuel gas user."], "gastropod": ["Any mollusc of the class Gastropoda, typically having a flattened muscular foot for locomotion and a head that bears stalked eyes."], "gene bank": ["Storehouse of seeds or vegetative tissue, kept in low humidity and temperature, to help maintain genetic diversity."], "general chemistry": ["The study of the elements and the compounds they form."], "gene": ["A unit of heredity composed of DNA occupying a fixed position on a chromosome. A gene may determine a characteristic of an individual by specifying a polypeptide chain that forms a protein or part of a protein (structural gene); or repress such operation (repressor gene).\\n(Source: CED)"], "genetic diversity": ["The variation between individuals and between populations within a species."], "genetic effect": ["Inheritable change, chiefly mutations produced by chemical substances, herbicides, radiations, etc."], "genetic engineering": ["1) The complex of techniques for the production of new genes and the alteration of the structure of the chromosomes to produce effects beneficial to man, in agriculture and medicine.\\n2) The intentional production of new genes and alteration of genomes by the substitution or addition of new genetic material.\\n(Source: ZINZAN /  MGH)"], "genetic information": ["The information for protein synthesis contained in the nucleotide sequences of the DNA polynucleotide chain.\\n(Source: RRDA)"], "genetic modification": ["Inheritable changes produced by ionizing radiation, exposure to certain chemicals, ingestion of some medication and from other causes.\\n(Source: CONFER)"], "genetic resource": ["The gene pool in natural and cultivated stocks of organisms that are available for human exploitation. It is desirable to maintain as diverse a range of organisms as possible, particularly of domesticated cultivars and their ancestors, in order to maintain a wide genetic base. The wider the genetic base, the greater the capacity for adaptation to particular environmental conditions.\\n(Source: ALL2)"], "genetics": ["The science that is concerned with the study of biological inheritance."], "genetic variation": ["Change in one or more phenotypic characteristics, due to gene mutation or rearrangement, environmental effects, etc."], "geodesy": ["A subdivision of geophysics which includes determination of the size and shape of the earth, the earth's gravitational field, and the location of points fixed to the earth's crust in an earth-referred coordinate system."], "geogenic factor": ["Factors which originate in the soil, as opposed to those of anthropic origin (anthropogenic).\\n(Source: RRDA)"], "geographic information system": ["An organized collection of computer hardware, software, geographic data, and personnel designed to efficiently capture, store, update, manipulate, analyze, and display all forms of geographically referenced information that can be drawn from different sources, both statistical and mapped."], "geography": ["The study of the natural features of the earth's surface, comprising topography, climate, soil, vegetation, etc. and man's response to them."], "geology": ["The study or science of the earth, its history, and its life as recorded in the rocks."], "geomorphology": ["The study of the classification, description, nature, origin, and development of present landforms and their relationships to underlying structures, and of the history of geologic changes as recorded by these surface features."], "geophysics": ["The physics of the earth and its environment, that is, earth, air and space."], "geotechnology": ["The application of scientific methods and engineering techniques to the exploitation and use of natural resources."], "geothermal energy": ["An energy produced by tapping the earth's internal heat. At present, the only available technologies to do this are those that extract heat from hydrothermal convection systems, where water or steam transfer the heat from the deeper part of the earth to the areas where the energy can be tapped. The amount of pollutants found in geothermal vary from area to area but may contain arsenic, boron, selenium, lead, cadmium, and fluorides. They also may contain hydrogen sulphide, mercury, ammonia, radon, carbon dioxide, and methane.\\n(Source: KOREN)"], "germ": ["A pathogenic micro-organism.", "Living substance capable of developing into an organ, part, or organism as a whole; a primordium."], "germination": ["The beginning or the process of development of a spore or seed."], "germ plasm": ["The hereditary material transmitted to the offspring via the gametes."], "glacier": ["Slow moving masses of ice which have accumulated either on mountains or in polar regions."], "glaciology": ["The study of all aspects of snow and ice, and in particular of existing glaciers, ice sheets, and their physical properties."], "glass": ["A hard, amorphous, inorganic, usually transparent, brittle substance made by fusing silicates, sometimes borates and phosphates, with certain basic oxides and then rapidly cooling to prevent crystallization.", "A surface that reflects light.", "A vessel (especially one made of glass) from which drinks may be drunk.", "A smooth surface, usually made of glass with reflective material painted on the underside, that reflects light so as to give an image of what is in front of it.", "An addictive psychoactive drug of formula C\u2081\u2080H\u2081\u2085N."], "glass industry": ["Industry for the production of glassware.\\n(Source: CED)"], "global warming": ["Changes in the surface-air temperature, referred to as the global temperature, brought about by the greenhouse effect which is induced by emission of greenhouse gases into the air."], "glossary": ["An alphabetical list of terms concerned with a particular subject, field or area of usage that includes accompanying definitions."], "glue": ["Substance used for sticking objects together."], "golf": ["A game played on a large open course, the object of which is to hit a ball using clubs, with as few strokes as possible, into each of usually 18 holes.", "To play golf."], "grain": ["Edible, starchy seeds of the grass family (Graminae) usable as food by man and his livestock."], "grass": ["A very large and widespread family of Monocotyledoneae, with more than 10.000 species, most of which are herbaceous, but a few are woody. The stems are jointed, the long, narrow leaves originating at the nodes. The flowers are inconspicuous, with a much reduced perianth, and are wind-pollinated or cleistogamous.", "A drug prepared from the cannabis plant, that is smoked or ingested for its euphoric effect."], "grass fire": ["A conflagration in or destroying large areas of any vegetation in the Gramineae family as found in fields, meadows, savannas or other grasslands."], "grasshopper": ["A plant-eating insect with long back legs that can jump very high and makes a sharp high noise using its back legs or wings."], "grassland": ["An area where the vegetation is dominated by grasses and other herbaceous plants."], "grassland ecosystem": ["The interacting system of the biological communities located in biomes characterized by the dominance of indigenous grasses, grasslike plants and forbs, and their non-living environmental surroundings.\\n(Source: TOE / DOE)"], "gravel": ["To have an unwanted negative influence on someone, to be distractive to or for someone, impress someone or something in a troublesome or uneasy way.", "A mixture of rock fragments and pebbles that is coarser than sand.\\n(Source: CED)", "To make someone rather angry or impatient; to cause annoyance."], "gravel pit": ["A place where gravel is dug out of the ground."], "grazing": ["The vegetation on pastures that is available for livestock to feed upon."], "greenbelt": ["An area of land around an urban area that is protected from large-scale housing."], "green corridor": ["Avenues along which wide-ranging animals can travel, plants can propagate, genetic interchange can occur, populations can move in response to environmental changes and natural disasters, and threatened species can be replenished from other areas."], "environmental tax": ["An amount of money demanded by a government to finance clean-up, prevention, reduction, enforcement or educational efforts intended to promote ecological integrity and the conservation of natural resources."], "greenhouse cultivation": ["Cultivation of plants, especially of out-of-season plants, in glass-enclosed, climate-controlled structures.\\n(Source: MGH)"], "greenhouse effect": ["The warming of the Earth's atmosphere caused by the increasing concentration of atmospheric gases, such as water vapour and carbon dioxide. These gases absorb radiation emitted by the Earth, thus slowing down the loss of radiant energy from the Earth back to space."], "greenhouse gas": ["A component of the atmosphere that influences the greenhouse effect, namely carbon dioxide, methane, nitrous oxides, ozone, CFCs and water vapour."], "green manure": ["Herbaceous plant material plowed into the soil while still green."], "green revolution": ["The development of high-yield strains of wheat, corn and rice during the 1960s and early 1970s to increase the food supplies and solve the world's hunger problems."], "green space": ["A plot of vegetated land separating or surrounding areas of intensive residential or industrial use and devoted to recreation or park uses."], "green vegetable": ["A vegetable having the edible parts rich in chlorophyll and forming an important source of vitamins and micronutrients."], "grinding": ["The process of reducing an object to powder or small fragments."], "gross national product": ["Value of all goods and services produced in a country in one year, plus income earned by its citizens abroad, minus income earned by foreigners in the country."], "groundwater": ["Water that occupies pores and crevices in rock and soil, below the surface and above a layer of impermeable material."], "groundwater extraction": ["The process, deliberate or inadvertent, of extracting ground water from a source at a rate so in excess of the replenishment that the ground water level declines persistently, threatening exhaustion of the supply or at least a decline of pumping levels to uneconomic depths."], "gulf": ["An inlet of the sea of large areal proportions, more indented than a bay and generally more enclosed."], "gymnosperm": ["Any seed-bearing plant of the division Gymnospermae, in which the ovules are borne naked on the surface of the mega sporophylls, which are often arranged in cones."], "gypsum": ["A colourless or white mineral used in the building industry and in the manufacture of cement, rubber, paper and plaster of Paris."], "habitat": ["The locality in which a plant or animal naturally grows or lives. It can be either the geographical area over which it extends, or the particular station in which a specimen is found.\\n2) A physical portion of the environment that is inhabited by an organism or population of organisms. A habitat is characterized by a relative uniformity of the physical environment and fairly close interaction of all the biological species involved. In terms of region, a habitat may comprise a desert, a tropical forest, a prairie field, the Arctic Tundra or the Arctic Ocean.\\n(Source: WRIGHT /  GILP)"], "hail": ["Precipitation in the form of balls or irregular lumps of ice.", "To fall from the clouds in form of ball or lumps of ice."], "half-life": ["The time required for one-half the atoms of a given amount of radioactive material to undergo radioactive decay."], "haloform": ["A haloalkane, containing three halogen atoms, e.g. iodoform, CHI3; a haloform reaction is a reaction to produce haloforms from a ketone. For example, if propanone is treated with bleaching powder, the chlorinated ketone so formed reacts to form chloroform.\\n(Source: UVAROV)"], "halogenated biphenyl": ["Halogen derivatives of biphenyl."], "halogenated hydrocarbon": ["One of a group of halogen derivatives of organic hydrogen and carbon containing compounds; the group includes monohalogen compounds (alkyl or aryl halides) and polyhalogen compounds that contain the same or different halogen atoms."], "halogenated phenol": ["Halogen derivatives of phenol."], "harbour": ["To maintain (a theory, thoughts, or feelings).", "To secretly shelter (as of fugitives or criminals).", "To keep in one's possession; of animals."], "hardness": ["Resistance of a solid to indentation, scratching, abrasion or cutting.\\n(Source: MGH)"], "harvest": ["The amount or measure of the crop gathered in a season.", "To gather the ripened crop.", "The process of gathering the ripened crop."], "hazard": ["A physical or chemical agent capable of causing harm to persons, property, animals, plants or other natural resources."], "haze": ["Reduced visibility in the air as a result of condensed water vapour, dust, etc., in the atmosphere.\\n(Source: CED)", "Meteorologic phenomenon consisting of a big number of dry and extremely small particles (dust, sand, smoke) in suspension and carried by the air, so that visibility is considerably reduced (aprox. between 1 and 5 kms). It occurs when the relative humidity is below 70-80%. It has an opalescent color."], "health": ["A state of dynamic equilibrium between an organism and its environment in which all functions of mind and body are normal."], "health care": ["The prevention, treatment, and management of illness and the preservation of mental and physical well being through the services offered by the medical, nursing, and allied health professions.", "Treatment done for a patient in order to alleviate his pain and to heal him."], "health facility": ["A facility or location where medical, dental, surgical, or nursing attention or treatment is provided to humans or animals."], "health regulation": ["A body of rules or orders prescribed by government or management to promote or protect the soundness of human bodies and minds in the workplace, at home or in the general environment.\\n(Source: BLD / RHW)"], "hearing impairment": ["A decrease in strength or any abnormality or partial or complete loss of hearing or of the function of ear, or hearing system, due directly \\nor secondarily to pathology or injury; it may be either temporary or permanent."], "hearing protection": ["The total of measures and devices implemented to preserve persons from harm to the faculty of perceiving sound."], "heater": ["An apparatus that heats or provides heat."], "heathland": ["An area with poor acid soil, typically dominated by ling (Calluna) or heaths (Erica)."], "heating": ["A system for supplying heat to a building."], "heat pump": ["A device which transfers heat from a cooler reservoir to a hotter one, expending mechanical energy in the process."], "heat supply": ["The provision of heating fuel, coal or other heating source materials, or the amount of heating capacity, for the use of a municipality, or other heat user.\\n(Source: ISEP)"], "heavy metal": ["A metal whose specific gravity is approximately 5.0 kg/l or higher."], "hedge": ["A line of closely planted bushes or shrubs, marking the boundaries of a property."], "herbicide": ["A chemical that controls or destroys undesirable plants."], "herbivore": ["An animal that feeds on plants."], "heterocyclic compound": ["Compound in which the ring structure is a combination of more than one kind of atom."], "higher education": ["Study beyond secondary school at an institution that offers programs terminating in undergraduate and graduate degrees.\\n(Source: COE)"], "high mountain": ["The mountain part that exceeds the 1500 meters of altitude."], "high-speed railway": ["Railway track designed so that trains can travel at speeds in excess of 200 km/h."], "high-speed train": ["Train travelling at maximum speeds of 320 km/h on special high-speed rail lines."], "high voltage line": ["An electric line with a voltage on the order of thousands of volts."], "highway": ["A public road especially an important road that joins cities or towns together.", "A wide road built for fast moving traffic travelling long distances, with a limited number of points at which drivers can enter and leave it."], "hill": ["A natural elevation of the land surface, usually rounded."], "historical research": ["The study of events in relation to their development over time.\\n(Source: GOOD)"], "historical site": ["Place where significant historical events occurred and which is important to an indigenous culture or a community.\\n(Source: LANDYa)"], "history": ["A systematic written account comprising a chronological record of events (as affecting a city, state, nation, institution, science, or art) and usually including a philosophical explanation of the cause and origin of such events.", "The scientific study of events from a time-related perspective and the passing on of the knowledge obtained by this study for the purpose of education.", "the past events concerned in the development of a particular place, object, subject etc."], "holiday": ["A day on which work is suspended by law or custom, such as a religious festival, bank holiday, etc."], "horse": ["A large animal with four legs of the Equus caballus species which people ride on or use for carrying things or pulling vehicles."], "horticulture": ["The art and science of growing plants."], "hospital": ["A place where people who are ill or injured are treated and taken care of by doctors and nurses."], "hospital waste": ["Solid waste, both biological and non-biological, produced by hospitals and discarded and not intended for further use."], "hotel industry": ["The industry related with the provision of lodging and usually meals and other services for travelers and other paying guests."], "hot water": ["Water that has been heated."], "household": ["A group of persons sharing a home or living space, who aggregate and share their incomes, as evidenced by the fact that they regularly take meals together.", "Found in or having its origin in a home."], "housing": ["Dwelling-houses collectively."], "housing density": ["The number of dwelling units or the residential population of a given geographic area."], "housing improvement": ["An addition, renovation or repair to a place of residence that increases its aesthetic, functional or financial value."], "housing quality standard": ["A norm or measure applicable in legal cases and considered to reflect a relatively high grade or level of excellence in the construction, maintenance, operation, occupancy, use or appearance of dwelling units.\\n(Source: BLD)"], "human biology": ["The study of human life and character."], "human ecology": ["The study of the growth, distribution, and organization of human communities relative to their interrelationships with other humans and other species and with their environment."], "human health": ["The avoidance of disease and injury and the promotion of normalcy through efficient use of the environment, a properly functioning society, and an inner sense of well-being.\\n(Source: KOREN)"], "human-made disaster": ["Violent, sudden and destructive change in the environment caused by man."], "human pathology": ["Branch of medicine concerned with the cause, origin, and nature of disease, including the changes occurring as a result of disease.\\n(Source: CED)"], "human physiology": ["A branch of biological sciences that studies the functions of organs and tissues in human beings.\\n(Source: OMD / WOR)"], "human settlement": ["Cities, towns, villages, and other concentrations of human populations which inhabit a given segment or area of the environment."], "humus": ["The more or less decomposed organic matter in the soil.", "Earth formed by the decay of vegetable matter.", "A popular dish in the Middle East that consists of cooked, mashed chickpeas, blended with tahini, olive oil, lemon juice, salt and garlic."], "hunting": ["The pursuit and killing or capture of wild animals."], "hurricane": ["A tropical cyclone of great intensity; any wind reaching a speed of more than 73 miles per hour (117 kilometers per hour) is said to have hurricane force."], "hydraulic engineering": ["A branch of civil engineering concerned with the design, erection, and construction of sewage disposal plants, waterworks, dams, water-operated power plants and such."], "hydraulics": ["The branch of science and technology concerned with the mechanics of fluids, especially liquids."], "hydrobiology": ["Study of organisms living in water.\\n(Source: ZINZAN)"], "hydrocarbon": ["A very large group of chemical compounds composed only of carbon and hydrogen.\\n(Source: MGH)"], "hydrochloric acid": ["A solution of hydrogen chloride gas in water."], "hydroculture": ["Cultivation of plants without soil but in sand or vermiculite or other granular material, using a liquid solution of nutrients to feed them."], "hydroelectric power plant": ["Power station which operates with the free renewable source of energy provided by falling water."], "hydrogen": ["A flammable colourless gas that is the lightest and most abundant element in the universe. It occurs mainly in water and in most organic compounds and is used in the production of ammonia and other chemicals, in the hydrogenation of fats and oils, and in welding."], "hydrogeology": ["The science dealing with the occurrence of surface and ground water, its utilization, and its functions in modifying the earth, primarily by erosion and deposition."], "hydrography": ["Science which deals with the measurement and description of the physical features of the oceans, lakes, rivers, and their adjoining coastal areas, with particular reference to their control and utilization."], "hydrologic balance": ["An accounting of the inflow to, outflow from, and storage in a hydrologic unit such as a drainage basin, aquifer, soil zone, lake or reservoir; the relationship between evaporation, precipitation, runoff, and the change in water storage."], "hydrologic cycle": ["The movement of water between the oceans, ground surface and atmosphere by evaporation, precipitation and the activity of living organisms."], "hydrology": ["The science that treats the occurrence, circulation, distribution, and properties of the waters of the earth, and their reaction with the environment.", "The science that treats the occurrence, circulation, distribution, and properties of the waters of the earth, and their reaction with the environment.\\n(Source: MGH)"], "hydrolysis": ["Decomposition or alteration of a chemical substance by water; in aqueous solutions of electrolytes, the reactions of cations with water to produce a weak base or of anions to produce a weak acid.\\n(Source: MGH)"], "hydrometeorology": ["That part of meteorology of direct concern to hydrologic problems, particularly to flood control, hydroelectric power, irrigation, and similar fields of engineering and water resource.\\n(Source: ZINZAN)"], "water power": ["Energy obtained from natural or artificial waterfalls, either directly by turning a water wheel or turbine, or indirectly by generating electricity in a dynamo driven by a turbine."], "hydrosphere": ["All the waters of the Earth, as distinguished from the rocks, living things , and the air."], "hygiene": ["A set of practices associated with the preservation of health, the prevention and fighting of diseases and healthy living.", "The study and use of practical measures for the preservation of public health."], "hymenopteran": ["Insects including bees, wasps, ants, and sawflies, having two pair of membranous wings and an ovipositor specialized for stinging, sawing or piercing.\\n(Source: CED)"], "ice": ["The dense substance formed by the freezing of water to the solid state; it commonly occurs in the form of hexagonal crystals.", "To cool with ice.", "An addictive psychoactive drug of formula C\u2081\u2080H\u2081\u2085N."], "iceberg": ["A large mass of detached land ice floating in the sea or stranded in shallow water."], "ideology": ["A body of ideas that reflects the beliefs and interest of a nation, political system, etc. and underlies political action.\\n(Source: CED)"], "image processing": ["The process of converting 'raw' remotely sensed data into a usable form through the application of various transformations such as supervised and unsupervised classification schemes.\\n(Source: FORUMT)"], "immission": ["The reception of material, such as pollutants, by the environment and from any source."], "immission control": ["Legislative and administrative procedures aimed at reducing the damage caused by emissions. Pollution control programmes are normally based on human-oriented acceptable dose limits. A very important measure concerns the organisation of an emission inventory.\\n(Source: GOODa)"], "immission control law": ["A law that protects the residents' health and resources of a region by limiting air pollution."], "immission damage": ["Damage caused by pollution from a distinct source of emission."], "immission forecast": ["The prediction of immissions is calculated on the basis of the pollutant load, the source height, the wind speed and the dispersion coefficient."], "immune system": ["A body system that helps an organism to resist disease, through the activities of specialised blood cells or antibodies produced by them in response to natural exposure or inoculation.\\n(Source: KOREN /  CED)"], "immunity": ["The ability of an organism to resist disease or toxins by natural or artificial means."], "immunoassay": ["Any of several methods for the quantitative determination of chemical substances such as hormones, drugs, and certain proteins that utilize the highly specific binding between an antigen and an antibody."], "immunological disease": ["The disruption of the complex system of interacting cells, cell products and cell-forming tissues that protect the body from pathogens, destroys infected and malignant cells and removes cellular debris.\\n(Source: SMD / RHW)"], "immunology": ["A branch of biology concerned with the native or acquired resistance of higher animal forms and humans to infections."], "impactor": ["Instrument which samples atmospheric suspensoids by impaction; such instruments consist of a housing which constrains the air flow past a sensitized sampling plate."], "import": ["The act of bringing goods and merchandise into a country from a foreign country.", "To bring (something) in from a foreign country, especially for sale or trade.", "An object brought from a foreign country, especially for sale or trade."], "impoverishment": ["The state of having little or no money and few or no material possessions"], "impulsive noise": ["Noise characterized by transient short-duration disturbances distributed essentially uniformly over the useful passband of a transmission system."], "incineration": ["The burning of a dead body."], "incineration of waste": ["The controlled burning of solid, liquid, or gaseous combustible wastes to produce gases and solid residues containing little or no combustible material in order to reduce the bulk of the original waste materials."], "incinerator": ["Device which burns waste."], "slope": ["The inclined surface of any part of the Earth's surface, as a hillslope; also, a broad part of a continent descending toward an ocean, as the Pacific slope.\\n(Source: BJGEO)", "To be at an angle; to move downwards."], "income": ["The gain derived from capital, from labour or effort, or both combined, including profit or gain through sale or conversion of capital.", "Compensation for the selling of goods and services.", "Payment received for goods or services or coming from other sources as for instance, investments.", "Money that a person or an institution obtains."], "incorporation": ["The act of incorporating a substance to another substance."], "indemnity": ["Financial compensation, reimbursement or security for damages or loss offered by a government, insurance policy or contractual agreement under specified conditions and for specific casualties."], "Indian Ocean": ["A body of water between the continents of Africa, Antarctica, Asia and Australia including the Bay of Bengal in the east and the Arabian Sea (with the Red Sea, the Gulf of Aden and the Persian Gulf) in the west, and containing several islands and island chains, such as the Andaman, Nicobar and Seychelles."], "indicator": ["A blinking light mounted near the left and right front and rear corners of a vehicle, and sometimes on the sides, used to indicate the intention of a lateral change of position (turn or lane change)."], "indigenous forest": ["Forests which are native to a given area."], "indoor environment": ["Environment situated in the inside of a house or other building."], "industrial area": ["Areas allocated for industry within a town-planning scheme or environmental plan. The range of industries accommodated in a plan may include: light industry, service industry, general industry, hazardous, noxious or offensive industry, waterfront industry, extractive industry. Standards are usually defined for industrial areas relating to access and roads, drainage, car parking, aesthetics, landscaping, buffer zones, noise levels, and air and water pollution.\\n(Source: GILP96)"], "industrial medicine": ["The branch of medicine which deals with the relationship of humans to their occupations, for the purpose of the prevention of disease and injury and the promotion of optimal health, productivity, and social adjustment."], "industrial process": ["Procedures involving chemical or mechanical steps to aid in the manufacture of items, usually carried out on a very large scale."], "industrial site": ["The location for the individual manufacturing firm."], "industrial sludge": ["Sludge produced as a result of industrial production processes or manufacturing."], "industrial society": ["A large-scale community with diverse manufacturing sectors and an infrastructure and economy based on the science, technology and instrumental rationality of the modern West."], "industrial waste": ["Waste materials discarded from industrial operations, or derived from manufacturing processes; may be solid, sludge (wet solids) or liquid wastes and may or may not be considered hazardous.\\n(Source: HMD /  ISEP)"], "industry": ["A group of establishments engaged in the same or similar kinds of economic activities. They produce a range of commodities that are sold with the expectation of recovering the total cost of production."], "inert waste": ["Wastes that do not undergo any significant physical, chemical, or biological transformations when deposited in a landfill."], "infant mortality": ["The rate of deaths occurring in the first year of life for a given population."], "infection": ["The entry and development or multiplication of an infectious agent in the body of a living organism.", "Process in which a disease is transmitted."], "infectious disease": ["Pathogenic condition resulting from invasion of an host by a pathogen that propagates causing infection.", "A disease caused by a microorganism or other agent, such as a bacterium, fungus, or virus, that enters the body of an organism."], "infestation of crops": ["Invasion of crop by parasites."], "infiltration": ["Movement of water through the soil surface into the ground."], "inflammable substance": ["Substance liable to catch fire."], "informatics": ["Science and technique of data elaboration and of automatic treatment of information."], "information": ["All facts, ideas or imaginative works of the mind which have been communicated, published or distributed formally or informally in any format, or the knowledge that is communicated or received."], "information service": ["An organized system of providing assistance or aid to individuals who are seeking information, such as by using databases and other information sources to communicate or supply knowledge or factual data.\\n(Source: RHW / OMD)"], "information system": ["Any coordinated assemblage of persons, devices and institutions used for communicating or exchanging knowledge or data, such as by simple verbal communication, or by completely computerized methods of storing, searching and retrieving information.\\n(Source: MHD)"], "information technology": ["The systems, equipment, components and software required to ensure the retrieval, processing and storage of information in all centres of human activity (home, office, factory, etc.), the application of which generally requires the use of electronics or similar technology."], "infraction": ["A breach, violation, or infringement; as of a law, a contract, a right or duty.", "A crime less serious than a felony."], "infrared radiation": ["Electromagnetic radiation whose wavelengths lie in the range from 0.75 or 0.8 micrometer to 1000 micrometers."], "infrasound": ["Vibrations of the air at frequencies too low to be perceived as sound by the human ear, below about 15 hertz."], "infrastructure": ["The basic network or foundation of capital facilities or community investments which are necessary to support economic and community activities."], "inhabitant": ["A person occupying a region, town, house, country, etc.", "A human, officially being inhabitant of certain area inside well defined, and precise, borders - usually seen from a standpoint of census, government, register, etc."], "injury": ["A stress upon an organism that disrupts the structure or function and results in a pathological process."], "ink": ["A dispersion of a pigment or a solution of a dye in a carrier vehicle, yielding a fluid, paste, or powder to be applied to and dried on a substrate; writing, marking, drawing, and printing inks are applied by several methods to paper, metal, plastic, wood, glass, fabric, or other substrate."], "inland fishery": ["Fishing in lakes, streams, etc."], "inland navigation": ["The navigation of inland waterways, i.e. navigable rivers, canals, sounds, lakes, inlets, etc."], "inland water": ["A lake, river, or other body of water wholly within the boundaries of a state.\\n(Source: MGH)"], "inland waterways transport": ["Transportation of persons and goods by boats travelling on rivers, channels or lakes."], "innovation": ["Something newly introduced, such as a new method or device."], "inorganic chemistry": ["A branch of chemistry dealing with the chemical reactions and properties of all inorganic matter.\\n(Source: LEE)"], "inorganic substance": ["Chemical compound that does not contain carbon as the principal element (excepting carbonates, cyanides, and cyanates).\\n(Source: MGH)"], "insecticide": ["Any chemical agent used to destroy invertebrate pests."], "insectivore": ["(Insectivora) Order of placental mammals, being typically small, with simple teeth, and feeding on invertebrates.", "An animal with a diet that consists chiefly of insects and similar small creatures."], "in situ": ["In the natural or normal place."], "inspection": ["An official examination and evaluation of the extent to which specified goals, objectives, standards, policies or procedures of an agency, organization, department or unit have been met properly."], "inspection service": ["An organization designated to look into, supervise and report upon, the staff members and workings of some institution or department, or the conforming to laws and regulations by a segment of society or other group.\\n(Source: OED)"], "sound insulation material": ["Material used to reduce the transmission of sound to or from a body, device, room, etc."], "insurance": ["An agreement of providing financial protection contingencies, such as death, loss or damage and involving payment of regular premiums in return for a policy guaranteeing such protection.", "The business of providing a financial protection against most losses or harm to a person, property or a firm in return for premiums paid."], "insurance coverage": ["The protection provided against risks or a risk, often as specified by the type of protection or the item being protected."], "intensive farming": ["Farming in which as much use is made of the land as possible by growing crops close together or by growing several crops in a year or by using large amounts of fertilizers.\\n(Source: PHC)"], "interaction of pesticides": ["The enhancement of activity of pesticides when they are used in combination with others.\\n(Source: PARCOR)"], "interchange of electronic data": ["A transference of binary coded information items between two or more computers across any communications channel capable of carrying electromagnetic signals."], "interdisciplinary research": ["The utilisation, combination and coordination of two or more appropriate disciplines, technologies and humanities in an integrated approach toward problems."], "interest": ["A sum paid or charged for the use of money or for borrowing money over a given time period.", "A great attention and concern from someone or something.", "That which affects one's welfare or happiness.", "To attract attention or concern; to excite the curiosity of; to engage the interest of.", "To be on the mind of.", "To be of importance or consequence."], "interest group": ["A group of people who share common traits, attitudes, beliefs or objectives and who have formed a formal organization to serve specific concerns of the membership."], "interlaboratory comparison": ["Tests performed at the same time in different laboratories to validate the quality of the results."], "international agreement": ["Cooperation in international efforts to support global goals."], "international competitiveness": ["The ability of firms to strive with rivals in the production and sale of commodities in worldwide markets.\\n(Source: ODE / OED)"], "international convention": ["Treaties and other agreements of a contractual character between different countries or organizations of states creating legal rights and obligations between the parties."], "International Court of Justice": ["Judicial arm of the United Nations. It has jurisdiction to give advisory opinions on matters of law and treaty construction when requested by the General Assembly, Security Council or any other international agency authorised by the General Assembly to petition for such opinion. It has jurisdiction, also, to settle legal disputes between nations when voluntarily submitted to it.\\n(Source: BLACK)"], "international law": ["The system of law regulating the interrelationship of sovereign states and their rights and duties with regard to one another."], "international safety": ["Freedom from danger or the quality of averting risk of harm to persons, property or the environment shared across one or more national boundaries; consequently, the combined efforts of more than one nation to achieve or preserve that state.\\n(Source: OED / RHW)"], "international trade": ["The flow of commodities and goods between nations."], "interpretation method": ["Method employed in the assessment of the meaning and significance of data, results, facts, etc."], "intertidal zone": ["The area between land and sea which is regularly exposed to the air by the tidal movement of the sea."], "inventory": ["A detailed list of articles, goods, property, etc."], "inversion": ["A reversal in the usual direction of a process, as in the change of density of water at 4\u00b0 C.\\n(Source: PITT)"], "inversion layer": ["The atmosphere layer through which an inversion occurs."], "invertebrate": ["Any animal lacking a backbone, including all species not classified as vertebrates.", "Lacking a backbone."], "investment": ["Any item of value purchased for profitable return, as income, interest or capital appreciation."], "in vitro assay": ["Assay taking place in an artificial environment."], "in vivo assay": ["Experiment that is carried out in the living organism."], "iodine": ["A nonmetallic halogen element; the poisonous, corrosive dark plates or granules are readily sublimed; insoluble in water, soluble in common solvents; used as germicide and antiseptic, in dyes, tinctures, and pharmaceuticals, in engraving lithography, and as a catalyst and analytical reagent."], "ion exchange": ["The process in which ions are exchanged between a solution and an insoluble solid, usually a resin."], "ion exchanger": ["A permanent insoluble material (usually a synthetic resin) which contains ions that will exchange reversibly with other ions in a surrounding solution."], "ionosphere": ["A region of the earth's atmosphere, extending from about 60 to 1000 kilometers above the earth's surface, in which there is a high concentration of free electrons and ions formed as a result of ionizing radiation entering the atmosphere from space."], "ion": ["An electrically charged atom or group of atoms formed by the loss or gain of one or more electrons."], "iron": ["A malleable ductile silvery-white ferromagnetic metallic element with symbol Fe and atomic number 26, occurring principally in haematite and magnetite. It is widely used for structural and engineering purposes.", "Made out of iron.", "A small appliance used in ironing to remove wrinkles from fabric.", "To remove wrinkles from fabric."], "irradiation": ["Exposure to or treatment with light or other electromagnetic radiation or with beams of particles."], "irrigation": ["The act of supplying land with water so that crops and plants will grow or grow stronger."], "irrigation canal": ["A permanent irrigation conduit constructed to convey water from the source of supply to one or more farms."], "irrigation farming": ["Farming based on the artificial distribution and application of water to arable land to initiate and maintain plant growth.\\n(Source: GOODa)"], "island": ["A land mass, especially one smaller than a continent, entirely surrounded by water.", "A barrier on roads and highways between the opposing flows of traffic, usually covered with vegetation.", "Area in the middle of a road where pedestrians can wait while crossing."], "island ecosystem": ["Unique but fragile and vulnerable ecosystem due to the fact that the evolution of their flora and fauna has taken place in relative isolation. Many remote islands have some of the most unique flora in the world; some have species of plants and animals that are not found anywhere else, which have evolved in a specialized way, sheltered from the fierce competition that species face on mainland."], "isomer": ["Two or more compounds having the same molecular formula, but a different arrangement of atoms within the molecule. (Source: CED /  MGH)", "One of two or more chemical substances having the same elementary percentage composition and molecular weight but differing in structure, and therefore in properties; there are many ways in which such structural differences occur.\\n(Source: CED /  MGH)"], "isotope": ["Any of two or more atoms with the same atomic number that contain different numbers of neutrons."], "ivory": ["The fine-grained creamy-white dentine forming the tusks of elephants, and the teeth or tusks of certain other large animals such as the walrus; it has long been esteemed for a wide variety of ornamental articles.\\n(Source: BJGEO)"], "joint debtor": ["Persons united in a joint liability or indebtedness. Two or more persons jointly liable for the same debt."], "judicial assistance": ["A program sponsored or administered by a government to guide through and represent in court proceedings persons who are in financial need and cannot afford private counsel.\\n(Source: BLD)"], "judicial body": ["Any public organization or branch of government responsible for the administration of justice or the enforcement of laws.\\n(Source: BLD)"], "jurisdiction": ["The power of a court to hear and decide a case or give a certain punishment or sanction.", "The area or territory where a particular person or group of people (such as a court) has the right to excersise their legal authority."], "jurisprudence": ["The science or philosophy of law."], "karst": ["A geological formation resulting from the erosion of carbonate rocks."], "stocking": ["A soft garment worn on the foot and lower leg, usually knit or woven, worn under shoes or other footwear."], "kerosene": ["Higly refined kerosene used as fuel for jet engines.", "Higly refined sulphurless kerosene used for kerosene lamps, lanterns and portable stoves and produces very little soot."], "laboratory": ["A room or building with scientific equipment for doing scientific tests or for teaching science, or a place where chemicals or medicines are produced."], "laboratory experiment": ["Experimental tests or investigations carried out in a laboratory.\\n(Source: CEDa)"], "laboratory research": ["Research carried out in a laboratory for testing chemical substances, growing tissues in cultures, or performing microbiological, biochemical, hematological, microscopical, immunological, parasitological tests, etc.\\n(Source: PHC)"], "laboratory technique": ["The sum of procedures used on natural sciences such as chemistry, biology, physics in order to conduct an experiment, all of them following the scientific method."], "laboratory waste": ["Discarded materials produced by analytical and research activities in a laboratory.\\n(Source: ERG)"], "lacquer": ["A material which contains a substantial quantity of a cellulose derivative, most commonly nitrocellulose but sometimes a cellulose ester, such as cellulose acetate or cellulose butyrate, or a cellulose ether such as ethyl cellulose; used to give a glossy finish, especially on brass and other bright metals."], "lagoon": ["A body of water cut off from the open sea by coral reefs or sand bars."], "lake basin": ["The depression in the Earth's surface occupied or formerly occupied by a lake."], "lake pollution": ["The direct or indirect human alteration of the biological, physical, chemical or radiological integrity of lake water, or a lake ecosystem.\\n(Source: Landy)"], "lake": ["An enclosed body of water, usually but not necessarily fresh water, from which the sea is excluded."], "lamp": ["A device for producing light."], "land": ["A specified geographical tract of the Earth's surface including all its attributes, comprising its geology, superficial deposits, topography, hydrology, soils, flora and fauna, together with the results of past and present human activity, to the extent that these attributes exert a significant influence on the present and future land utilization.\\n(Source: WHIT)", "The range occupied by a community or other group.", "To descend to a surface, especially from the air; to arrive on shore.", "The part of Earth which is not covered by oceans or other bodies of water.", "A partitioned and measurable area on the Earth which is owned.", "Area that is suitable for farming.", "In a compact disc or similar recording medium, an area of the medium which does not have pits.", "The space between the rifling grooves in a gun.", "A strip area in a field between furrows made for irrigation.", "The geographic area under the control of a political state.", "Territorial possessions.", "To descend, reach or come to rest.", "To deliver (a blow)."], "land and property register": ["The system of registering certain legal estates or interests in land. It describes the land and any additional rights incidental to it, such as rights of way over adjoining land.\\n(Source: DICLAW)"], "land clearing": ["Removal of trees, undergrowth, etc. in preparation for ploughing, building, etc."], "land consolidation": ["Joining small plots of land together to form larger farms or large fields."], "land cover": ["Interface between the earth's crust and the atmosphere made of a combination of vegetation, soil, rock, water and human-made structures."], "land ecology": ["Study of the relationship between terrestrial organisms and their environment."], "landfill": ["A site where garbage is collected and buried."], "landfill covering": ["The protective shielding, consisting of soil or some other material, that encloses disposal sites for waste to minimize the chance of releasing hazardous substances into the environment."], "landfill degasification": ["Landfill gas is highly dangerous as methane is highly explosive; therefore it must be controlled at all operational landfill sites, whether by active or passive ventilation or both especially in the case of deep sites. There exist venting systems for shallow and deep sites respectively.\\n(Source: PORT)"], "landform": ["Any physical, recognizable form or feature of the Earth's surface, having a characteristic shape and produced by natural causes; it includes major forms such as plane, plateau and mountain, and minor forms such as hill, valley, slope, esker, and dune. Taken together the landforms make up the surface configuration of the Earth's.\\n(Source: BJGEO)"], "land mammal": ["Mammal that lives on shore."], "land planning": ["The activity of designing, organizing or preparing for the future use of solid areas of the earth's surface, especially regions valued for natural resources, utilized as agricultural resources or considered for human settlement.\\n(Source: RHW)"], "land register": ["A public register containing information on the land and landowners."], "landscape": ["The traits, patterns, and structure of a specific geographic area.", "A mode of printing where the horizontal sides are longer than the vertical sides."], "landscape architecture": ["The creation, development, and decorative planting of gardens, grounds, parks, and other outdoor spaces."], "landscape conservation": ["The safeguarding, for public enjoyment, of landscape and of opportunities for outdoor recreation, tourism and similar activities; the concept includes the preservation and enhancement not only of what has been inherited but the provision of new amenities and facilities."], "landscape ecology": ["The study of landscapes taking account of the ecology of their biological populations. The subjects thus embraces geomorphology and ecology and is applied to the design and architecture of landscapes.\\n(Source: ALL2)"], "landslide": ["Mass-movement landforms and processes involving the downslope transport, under gravitationary influence of soil and rock material en masse."], "land value": ["The monetary or material worth in commerce or trade of an area of ground considered as property."], "laser": ["A device that produces a powerful, highly directional, monochromatic, coherent beam of light."], "laundering": ["The act of washing and ironing clothes, linen, etc."], "law amendment": ["An alteration of or addition to any statute with legal force that, if approved by the appropriate legislative authority, supersedes the original statute."], "law enforcement": ["Any variety of activities associated with promoting compliance and obedience to the binding rules of a state, especially the prevention, investigation, apprehension or detention of individuals suspected or convicted of violating those rules."], "leaching": ["1) The process of separating a liquid from a solid (as in waste liquid by percolation into the surrounding soil. \\n2) Extraction of soluble components of a solid mixture by percolating a solvent through it.\\n3) To lose or cause to lose soluble substances by the action of a percolating liquid."], "lead": ["A heavy toxic bluish-white metallic element with symbol Pb and atomic number 82 that is highly malleable; occurs principally as galena and is used in alloys, accumulators, cable sheaths, paints, and as a radiation shield.", "To be ahead of others, e.g., in a race.", "The distance that a shooter aims ahead of a moving target in order to hit it with the projectile.", "To treat with lead.", "To move ahead (of others) in time or space.", "A small stick of graphite used in pencil that leaves marks when rubbed against a surface."], "lead compound": ["A chemical compound present as gasoline additives, in paint, ceramic products, roofing, caulking, electrical applications, tubes, or containers. Lead exposure may be due to air, water, food, or soil. Lead in the air is primarily due to lead-based fuels and the combustion of solid waste, coal, oils, and emissions from alkyl lead manufacturers, wind blown dust volcanoes, the burning of lead-painted surfaces, and cigarette smoke. Lead in drinking water comes from leaching from lead pipes, connectors, and solder in both the distribution system and household plumbing.\\n(Source: KOREN)"], "lead level in blood": ["A measure of the amount of lead or lead salts absorbed by the body as a possible sign of acute or chronic lead poisoning, which can affect the nervous, digestive or muscular systems."], "leaf": ["The main organ of photosynthesis and transpiration in higher plants, usually consisting of a flat green blade attached to the stem directly or by a stalk.", "A sheet of a book, magazine, etc (consisting of two pages, one on each face of the leaf)."], "leakage": ["The accidental, uncontrolled discharge or seepage of liquids, gases and other substances to unintended and unwanted locations, frequently causing risks of damage or harm to persons, property or the environment."], "leather": ["The dressed or tanned hide of an animal, usually with the hair removed."], "leather industry": ["Industry for the production of leather goods such as garments, bags, etc."], "legal basis": ["The fundamental law or judicial precedent that warrants or supports a subsequent decision or action by any governmental, corporate or private entity."], "legal regulation": ["Any order or rule issued by a government stipulating its procedures for the creation, execution or adjudication of laws."], "legal remedy": ["The means by which a right is enforced or the violation of a right is prevented, redressed, or compensated.\\n(Source: BLACK)"], "legal text": ["The exact wording or language of a law or other document in conformity with the law or having the authority of law.\\n(Source: BLD)"], "legislation": ["The act or process of making laws."], "legislative authority": ["The power of a deliberative assembly of persons or delegates to bring a bill, resolution or special act to an official, legally binding status.\\n(Source: RHW)"], "legislative competence": ["The skill, knowledge, qualification, capacity or authority to make, give or enact rules with binding force upon a population or jurisdiction."], "legislature": ["The department, assembly, or body of persons that makes statutory laws for a state or nation."], "leisure time": ["Time free from work or other duties; spare time."], "lepidopteran": ["Any insect of the order Lepidoptera that has a slender body with clubbed antennae and typically rests with the wings (which are often brightly coloured) closed over the back."], "levy": ["A ratable portion of the produce of the property and labor of the individual citizens, taken by the nation, in the exercise of its sovereign rights, for the support of government, for the administration of the laws, and as the means for continuing in operation the various legitimate functions of the state."], "lexicon": ["The vocabulary of a particular sphere of activity, region, social class or individual, or the total set of morphemes or meaningful units of a language and its words."], "liability": ["Subjection to a legal obligation. Liability is civil or criminal according to whether it is enforced by the civil or criminal courts.", "Responsibility to someone or for some activity.", "An obligation to pay money to another party.", "The quality of being something that holds you back."], "library": ["Place where books and other literary materials are kept.", "A collection of subroutines used to develop software."], "lichen": ["Composite organisms formed by the symbiosis between species of fungi and an algae."], "life cycle": ["The phases, changes, or stages through which an organism passes throughout its lifetime.", "The useful life of a product or system; the developmental history of an individual or group in society."], "life science": ["A science based on living organisms collectively."], "lifestyle": ["The particular attitudes, habits or behaviour associated with an individual or group."], "light": ["A device for producing light.", "Electromagnetic radiation that is capable of causing a visual sensation.", "To start (a fire).", "To give light to (something).", "Of low weight.", "Object, natural or artificial, that produces light.", "Having colors relat\u0131vely near white.", "(of the military or industry) using (or being) relatively small or light weapons or equipment.", "Low in degree or quantity or number (e.g. of rain, snow, accent).", "Psychologically light; especially free from sadness or troubles.", "Low in fat, calories, alcohol, salt, etc.", "(used of soil) loose and large-grained in consistency."], "lighting": ["The supply of illumination in streets or dwellings."], "separator of light liquids": ["A mechanical device for separating and removing residues from fuel and lubricating oil from waste water coming from filling stations and industrial plants in order to avoid pollution of water bodies; this system is based on the different specific weights of water and fuel residues that float on the water and can be easily removed."], "lignite": ["Coal of relatively recent origin consisting of accumulated layers of partially decomposed vegetation, intermediate between peat and bituminous coal; often contains patterns from the wood from which it formed.\\n(Source: MGH /  CED /  WRIGHT)"], "lignite mining": ["Extraction of brown coal from natural deposits; lignite is a brownish-black solid fuel in the second stage in the development of coal. It has a little over half the heating value of bituminous or anthracite coal.\\n(Source: KORENa)"], "lime": ["Any of various mineral and industrial forms of calcium oxide differing chiefly in water content and percentage of constituent such as silica, alumina and iron.", "A green citrus fruit"], "limestone": ["A sedimentary rock consisting chiefly of calcium carbonate, primarily in the form of the mineral calcite and with or without magnesium carbonate."], "limnology": ["The study of bodies of fresh water with reference to their plant and animal life, physical properties, geographical features, etc.\\n(Source: CED)"], "linear source of sound": ["Point noise sources placed one after the other one as, for instance, in a row of cars moving on a road.\\n(Source: VALAMB)"], "line source": ["A source of air, noise, water contamination or electromagnetic radiation that emanates from a linear source such as a road."], "lipid": ["One of a class of compounds which contain long-chain aliphatic hydrocarbons and their derivatives, such as fatty acids, alcohols, amines, amino alcohols, and aldehydes; includes waxes, fats, and derived compounds.\\n(Source: MGH)"], "liquefied gas": ["A gaseous compound or mixture converted to the liquid phase by cooling or compression; examples are liquefied petroleum gas (LPG), liquefied natural gas (LNG), liquid oxygen, and liquid ammonia."], "liquid manure": ["Any fertilizer substance with a moisture content of over ninety percent, usually consisting of animal excrement with water added.", "Liquid excrements of animals and people, accumulated for reuse as fertilizer."], "liquid state": ["A state of matter intermediate between that of crystalline substances and gases in which a substance has the capacity to flow under extremely small shear stresses and conforms to the shape of a confining vessel, but is relatively incompressible, lacks the capacity to expand without limit, and can posses a free surface."], "literature": ["Written material such as poetry, novels, essays, especially works of imagination characterized by excellence of style and expression and by themes of general or enduring interest."], "literature data bank": ["A fund of information on a particular subject or group of related subjects, divided into discrete documents and usually stored in and used with a computer system.\\n(Source: RHW)"], "literature study": ["The identification, description, analysis and classification of books and other materials used or consulted in the preparation of a work.\\n(Source: WEBSTE)"], "lithosphere": ["The solid portion of the Earth, as compared with the atmosphere and the hydrosphere.\\n(Source: BJGEO)"], "litter": ["Straw, hay or similar material used as bedding by animals.", "Small pieces of garbage, such as cans, bottles and wrappings, that people have left in a public place.", "A seat mounted on a frame with two poles on which a person can be carried."], "littoral": ["The intertidal zone of the seashore."], "livestock": ["Cattle, horses, and similar animals kept for domestic use especially on a farm."], "livestock breeding": ["The raising of livestock by crossing different varieties to obtain new varieties with desired characteristics."], "livestock farming": ["Breeding of cattle, horses and similar animals."], "living space": ["Any room, structure or area used as a residence and associated with subsistence activities, including sleeping, relaxing or eating."], "lizard": ["(Sauria) A reptile of the order Squamata.", "Any reptile of the suborder Lacertilia, especially those of the family Lacertidae, typically having an elongated body, four limbs, and a small tail: includes the gechos, iguanas, chameleons, monitors, and slow worms."], "load bearing capacity": ["The maximum load that a system can support before failing."], "teleheating": ["The supply of heat, either in the form of steam or hot water, from a central source to a group of buildings."], "local traffic": ["Traffic moving within a city, town, or area and subject to frequent stops, as distinguished from long distance traffic."], "locomotive": ["A self-propelled engine driven by steam, electricity or diesel power and used for drawing trains along railway tracks."], "long-distance traffic": ["Traffic moving over extended areas, great distances and usually not subject to frequent stops."], "long-term effect": ["Effect which will last long after the cause has ceased."], "long-term trend": ["The prevailing tendency or general direction expected for some observed value over a lengthy and extended period of time, often determined by studying and analyzing statistical data."], "lorry": ["A large motor vehicle of more than 3,500 kilograms designed for carrying cargo.", "Any motor vehicle designed for carrying cargo, including vans and pickups.", "Small rail car wihout cover to transport goods out of mines or quarries."], "loss": ["The result of a business operation where overhead costs are greater than the receipts or income.\\n(Source: ISEP /  ODE)", "The act of being defeated and losing something, such as a match."], "loss of biotope": ["Destruction of biotopes produced by environmental degradation which in turn is caused by air- or water-borne pollution.\\n(Source: WPR)"], "loudness": ["The magnitude of the physiological sensation produced by a sound, which varies directly with the physical intensity of sound but also depends on frequency of sound and waveform."], "low-cost housing": ["Residences built at minimal expense and designed to keep the rental rate or price of purchase affordable for persons with limited means, usually determined by an annual income level set below the local median."], "Lower House": ["The body of a bicameral legislature composed of representatives elected by the general populace and organized into electorates or districts, each comprising an equal number of citizens.\\n(Source: CIV)"], "low-level flight": ["Flying at low altitude."], "low-level technology": ["Any relatively unsophisticated technical equipment or method with an amplitude or functionality below what is available in a similar or comparable system.\\n(Source: RHW / APD)"], "lubricant": ["A substance used to reduce friction between parts or objects in relative motion.\\n(Source: MGH)"], "luminosity": ["The functional relationship between stellar magnitude and the number and distribution of stars of each magnitude interval. Also known as relative luminosity factor.", "The ability of emitting or reflecting light."], "lye": ["The alkaline solution that is obtained from the leaching of wood ashes.\\n(Source: MGH)"], "lymphatic system": ["A system of vessels and nodes conveying lymph in the vertebrate body, beginning with capillaries in tissue spaces and eventually forming the thoracic ducts which empty in the subclavian veins.\\n(Source: MGH)"], "lysimetry": ["The measurement of the water percolating through soils and the determination of the materials dissolved by the water."], "machine manufacture": ["The making or production of mechanical apparatuses used for commercial or industrial purposes, such as engines and turbines, elevators and conveying equipment, computers and office equipment, and hoists, cranes and industrial trucks."], "macroeconomic goal": ["An aim or objective pertaining to the production, distribution and use of income, wealth and commodities in a country, region or other large area, typically concerned with governmental fiscal and monetary policy as it affects employment, consumption, investment and growth levels.\\n(Source: ODE)"], "macroeconomics": ["Modern economic analysis that is concerned with data inaggregate as opposed to individual form such as national income, consumption and investment."], "magnetic tape": ["A plastic, paper, or metal tape that is coated or impregnated with magnetizable iron oxide particles, used in magnetic recording.\\n(Source: MGH)"], "magnetism": ["A class of physical phenomena associated with moving electricity, including the mutual mechanical forces among magnets and electric currents."], "mailing list": ["A series of addresses or e-mail addresses to which solicited or unsolicited mass mailings can be sent.\\n(Source: RHW)"], "malaria": ["A group of human and animal febrile diseases with a chronic relapsing course caused by hemosporidian blood parasites of the genus Plasmodium, transmitted by the bite of Anopheles mosquito."], "malformation": ["Permanent structural change that may adversely affect survival, development or function.\\n(Source: KOREN)"], "malnutrition": ["Defective nutrition due to inadequate intake of nutrients or to their faulty digestion, assimilation or metabolism."], "mammal": ["Any animal of the Mammalia class, a class of warm-blooded vertebrates having a thoracic diaphragm, a four-chambered heart and in which the females feed the young with their own milk."], "management": ["The management or direction of the affairs of a public or private office, business or organization.", "Government, control, superintendence, physical or manual handling or guidance; act of managing by direction or regulation, or administration, as management of family, or of household, etc.\\n(Source: BLACK)"], "mandate": ["A command or authorization to act in a particular way given by an administrator to a subordinate, a court to a lower court or an electorate to its representative.\\n(Source: RHW)"], "mangrove": ["Any of various tropical evergreen trees or shrubs that grow in shallow coastal water; Plants of the Rhizophoraceae family and/or of the genus Rhizophora."], "mangrove swamp": ["A wet, spongy area of land in tropical climates and along coastal regions that is dominated by mangrove trees and shrubs, particularly red mangroves (Rhizophora), black mangroves (Avicennia) and white mangroves (Laguncularia)."], "man-made climate change": ["Man-made climate changes due to the greenhouse effect and other human activities."], "man-nature relationship": ["The interrelationship between human activity and geographical environment."], "manpower": ["The power generated by a man working."], "manufacturing trade": ["The process or act of exchanging, buying or selling any manufactured product, or the raw materials for any manufacturing process.\\n(Source: RHW /  ISEP)"], "manure": ["Animal excreta collected from stables and barnyards with or without litter; used to enrich the soil."], "map": ["A representation, normally on a flat medium, that displays the physical and political features of a surface area of the earth, showing them in their respective forms, sizes and relationships according to some convention of representation.", "The visual representation of a person or an object.", "Representation of the location of datasets in a computer memory to speed up access and visualization."], "mapping": ["The process of making a map of an area; especially the field work necessary for the production of a map.", "Representation of the location of datasets in a computer memory to speed up access and visualization."], "mapping of lichens": ["Maps of lichens distribution indicating air quality. Fruticose lichens (with branched structures well above the surface) are more susceptible to SO2 damage than foliose lichens (whose leaflike thallus lies nearly flat on surface) and both in turn are more susceptible than crustose lichens (which embed their tissue in the cracks of bark, soil, or rocks). The use of morphological lichen types as indicators of air pollution concentrations is well developed.\\n(Source: WESTM)"], "marble": ["Metamorphic rock composed of recrystallized calcite or dolomite."], "marginal land": ["Low quality land the value of whose production barely covers its cultivation costs."], "mariculture": ["Cultivation of marine organisms in their natural habitats, usually for commercial purposes."], "marina": ["A small port that is used for pleasure rather than trade, often with hotels, restaurants and bars."], "marine biology": ["A branch of biology that deals with those living organisms which inhabit the sea.\\n(Source: MGH)"], "marine ecology": ["An integrative science that studies the basic structural and functional relationships within and among living populations and their physical-chemical environments in marine ecosystems. Marine ecology focuses on specific organisms as well as on particular environments or physical settings."], "marine ecosystem": ["Any marine environment, from pond to ocean, in which plants and animals interact with the chemical and physical features of the environment."], "marine engineering": ["The design, construction, installation, operation, and maintenance of main power plants, as well as the associated auxiliary machinery and equipment, for the propulsion of ships.\\n(Source: MGH)"], "marine environment": ["The oceans, seas, bays, estuaries, and other major water bodies, including coastal marine and nearshore zones."], "marine fauna": ["Animals which live in the sea."], "marine fishery": ["The harvest of animals and plants from the ocean to provide food and recreation for people, food for animals, and a variety of organic materials for industry."], "marine geology": ["That aspect of the study of the ocean that deals specifically with the ocean floor and the ocean-continent border, including submarine relief features, the geochemistry and petrology of the sediments and rocks of the ocean bottom and the influence of seawater and waves on the ocean bottom and its materials.\\n(Source: BJGEO)"], "marine pollution": ["Any detrimental alteration of the marine environment caused by the intentional or accidental release of dangerous or toxic substances, such as industrial, commercial and urban waste water."], "marine reserve": ["Sea area where marine wildlife is protected."], "marine sediment": ["Solid fragmental material, originated from weathering of rocks, that has settled down from a state of suspension in the water."], "maritime law": ["That system of law which particularly relates to marine commerce and navigation, to business transacted at sea or relating to navigation, to ships and shipping, to seamen, to the transportation of persons and property by sea, and to marine affairs generally.", "The area of law that deals with ships at sea and the rights of sailors, passengers, and owners of cargo."], "maritime navigation": ["Travelling on the sea by means of boats, ships, etc.\\n(Source: CEDa)"], "marker": ["Small amount of an easily detected substance that can be used to follow and quantify the flow of materials or movement of organisms not otherwise visible or detectable by ordinary means.", "A pen with a wide tip made of felt or fibre.", "An isotope of an element, a small amount of which may be incorporated into a sample of material in order to follow the course of that element through a chemical, biological, or physical process, and thus also follow the larger sample. The tracer may be radioactive, in which case observations are made by measuring the radioactivity.\\n(Source: ECHO1)"], "tracer": ["A minute quantity of radioactive isotope used in medicine or biology to study the chemical changes within living tissues.", "A person or thing that traces."], "market": ["Place of commercial activity in which articles are bought and sold."], "market economy": ["A mixed economy that relies heavily on markets to answer the three basic questions of allocation, but with a modest amount of government involvement. While it is commonly termed capitalism, market-oriented economy is much more descriptive of how the economy is structured.\\n(Source: AMOS2)"], "market form": ["The organizational form or structure of the trade or traffic of a particular commodity.\\n(Source: ISEP /  RHW)"], "marketing": ["A related group of business activities whose purpose is to satisfy the demands for goods and services of consumers, businesses and government."], "market research": ["The systematic gathering, recording, computing, and analysing of data about problems relating to the sale and distribution of goods and services for certain time periods."], "marsupial": ["Type of mammal with a pouch in which the young are carried."], "material": ["The substance of which a product is made or composed.", "Worldly, as opposed to spiritual.", "Having to do with matter."], "balance of matter": ["A calculation to inventory material inputs versus outputs in a process system."], "material life cycle": ["All the stages involved in the manufacturing, distribution and retail, use and re-use and maintenance, recycling and waste management of materials."], "materials science": ["The study of the nature, behaviour, and use of materials applied to science and technology."], "mathematical analysis": ["The branch of mathematics most explicitly concerned with the limit process or the concept of convergence; includes the theories of differentiation, integration and measure, infinite series, and analytic functions.\\n(Source: MGH)"], "maximum immission concentration": ["The maximum concentration of air polluting substances in the free environment whose impact when of specified duration and frequency is not objectionable to man, fauna and flora.\\n(Source: ECHO2)"], "meadow": ["Strictly a term for a field of permanent grass used for hay, but also applied to rich, waterside grazing areas that are not suitable for arable cultivation.\\n(Source: GOOD)", "A piece of land covered or cultivated with grass, usually intended to be mown for hay."], "measuring": ["The ability of the analytical method or protocol to quantify as well as identify the presence of the substance in question.\\n(Source: LEE)"], "meat": ["The edible flesh of animals, especially that of mammals."], "mechanical engineering": ["The branch of engineering concerned with the design, construction, and operation of machines.\\n(Source: CED)"], "medical science": ["The science and art of treating and healing."], "medicinal plant": ["Plants having therapeutic properties."], "Mediterranean Area": ["The collective islands and countries of the inland sea between Europe, Africa and Asia that is linked to the Atlantic Ocean at its western end by the Strait of Gibraltar and includes the Tyrrhenian, Adriatic, Aegean and Ionian seas."], "melting": ["A change of the state of a substance from the solid phase to the liquid phase. (Source: MGH)"], "membrane": ["A thin tissue that encloses or lines biological cells, organs, or other structures."], "mercury": ["A heavy silvery-white toxic liquid metallic element with symbol Hg and atomic number 80 occurring principally in cinnabar: used in thermometers, barometers, mercury-vapour lamps, and dental amalgams."], "metabolism": ["All the chemical reactions that take place in a living organism, comprising both anabolism and catabolism."], "metabolite": ["A product of intermediary metabolism."], "metallic mineral": ["Mineral containing metals, such as bauxite, pyrite, etc."], "metal oxide": ["Any binary compound in which oxygen is combined with one or more metal atoms."], "metal plating": ["A thin, adherent layer of metal on an object."], "metal": ["An opaque crystalline material usually of high strength with good electrical and thermal conductivities, ductility and reflectivity."], "meteorological forecasting": ["A branch of science that studies the dynamics of the atmosphere and the direct effects of the atmosphere upon the Earth's surface, oceans and inhabitants, focusing particularly on weather and weather conditions."], "meteorology": ["The science concerned with the atmosphere and its phenomena."], "methane": ["A colourless, odourless, and tasteless gas, lighter than air and reacting violently with chlorine and bromine in sunlight, a chief component of natural gas; used as a source of methanol, acetylene, and carbon monoxide."], "methodology": ["The system of methods and principles used in a particular discipline."], "metropolis": ["A large city, specifically that city in a country which is the seat of government, of ecclesiastical authority, or of commercial activity.\\n(Source: GOOD)"], "microbiological analysis": ["Analysis for the identification of viruses, bacteria, fungi and parasites."], "microbiology": ["The science and study of microorganisms, including protozoans, algae, fungi, bacteria, viruses, and rickettsiae.\\n(Source: MGH)"], "microclimate": ["The local, rather uniform climate of a specific place or habitat, compared with the climate of the entire area of which it is a part."], "microclimate effect": ["An effect on the climate on a small scale, such as a single forest or other bounded area."], "microclimatology": ["The study of a microclimate, including the study of profiles of temperature, moisture and wind in the lowest stratum of air, the effects of the vegetation and of shelterbelts, and the modifying effects of towns and buildings.\\n(Source: MGH)"], "microcomputer": ["A microprocessor combined with input/output interface devices, some type of external memory, and the other elements required to form a working computer system; it is smaller, lower in cost, and usually slower than a minicomputer.\\n(Source: MGH)"], "microecosystem": ["A small-scale, simplified, experimental ecosystem, laboratory- or field- based, which may be: a) derived directly from nature (e.g. when samples of pond water are maintained subsequently by the input of artificial light and gas-exchange); or b) built up from axenic cultures (a culture of an organism that consists of one type of organism only, i.e. that is free from any contaminating organism) until the required conditions of organisms and environment are achieved. Also known as microcosm.\\n(Source: ALL2)"], "microelectronics": ["The technology of constructing circuits and devices in extremely small packages by various techniques.\\n(Source: MGH)"], "microfiltration": ["The separation or removal from a liquid of particulates and microorganisms in the size range of 0.1 to 0.2 microns in diameter."], "micropollutant": ["Pollutant which exists in very small traces in water.\\n(Source: PHC)"], "microscopy": ["The interpretative application of microscope magnification to the study of materials that cannot be properly seen by the unaided eye."], "microwave": ["An electromagnetic wave which has a wavelength between about 0.3 and 30 centimeters, corresponding to frequencies of 1-100 gigahertz; however there are no sharp boundaries between microwaves and infrared and radio waves.", "An appliance for cooking food using microwave energy.", "To cook or heat in a microwave oven."], "animal migration": ["Movements that particular animals carry out regularly often between breeding places and winter feeding grounds."], "migratory bird": ["A bird which migrates in a group."], "migratory species": ["A species that moves from one biome to another for food or to breed."], "military air traffic": ["Air traffic of or relating to the armed forces."], "military zone": ["Area whose utilization is exclusively reserved to the army."], "milk": ["The whitish fluid secreted by the mammary gland for the nourishment of the young; composed of carbohydrates, proteins, fats, mineral salts, vitamins, and antibodies.", "To draw milk from (a mammal, especially a cow)."], "mill": ["A building where grain is crushed into flour.", "An establishment where products are manufactured using industrial methods."], "mine": ["An opening or excavation in the earth for extracting minerals.\\n(Source: MGH)", "An explosive device, concealed under or on the ground and designed to destroy or disable enemy targets as they pass over or near the device.", "To extract from the earth by excavation."], "mineral deposit": ["A mass of naturally occurring mineral material, e.g. metal ores or nonmetallic mineral, usually of economic value, without regard to mode of origin.\\n(Source: BJGEO)"], "mineralogy": ["The science which concerns the study of natural inorganic substances called minerals.\\n(Source: MGH)"], "mineral": ["A naturally occurring substance with a characteristic chemical composition expressed by a chemical formula; may occur as individual crystals or may be disseminated in some other material or rock."], "mineral water": ["Water containing naturally or artificially supplied minerals or gases."], "mining district": ["A district where mineral exploitation is performed."], "mining engineering": ["Engineering concerned with the discovery, development and exploitation of coal, ores, and minerals, as well as the cleaning, sizing and dressing of the product."], "mining geology": ["The study of geologic aspects of mineral deposits, with particular regard to problems associated with mining."], "mining industry": ["A sector of the economy in which an aggregate of commercial enterprises is engaged in the extraction of minerals occurring naturally, often involving quarrying, well operations, milling, exploration and development.\\n(Source: SIC)"], "mining regulation": ["A rule or order prescribed by government or management to promote the safety, legality or ecological responsibility of any aspect of the process or industry of ore extraction.\\n(Source: BLD)"], "ministry": ["The body of top government administrators or other high ranking public officials that are selected by a head of state to manage certain aspects of a state's affairs, as opposed to civil servants whose tenure is unaffected by public changes resulting from democratic elections or some other process."], "minority": ["A group that is different racially, politically, etc. from a larger group of which it is a part."], "miscibility": ["The tendency or capacity of two or more liquids to form a uniform blend, that is, to dissolve in each other; degrees are total miscibility, partial miscibility, and immiscibility.\\n(Source: MGH)"], "mite": ["An order of small Arachnida with rounded bodies. Mites are very abundant in the soil, feeding on plant material and invertebrate animals. Some parasitic mites (e.g. red spider) damage crops and can be serious pests. Others cause diseases in animals. Ticks are blood-suckers, some being vectors of diseases such as Rocky Mountain spotted fever in humans and fowls, and louping ill in cattle and sheep.\\n(Source: ALL)"], "mitigation measure": ["Any procedure or action undertaken to reduce the adverse impacts that a project or activity may have on the environment.\\n(Source: TOE)"], "mixed forest": ["A forest composed of broadleaf trees and coniferous trees."], "mixed use area": ["Use of land for more than one purpose; e.g. grazing of livestock, watershed and wildlife protection, recreation, and timber production.\\n(Source: RRDA)"], "mixing": ["The intermingling of different materials to produce a homogeneous mixture."], "mobile home": ["Living quarters mounted on wheels and capable of being towed by a motor vehicle.\\n(Source: CED)"], "model": ["A representation, usually on a smaller scale, of a device, structure, etc. \\n(Source: CED /  LEE)", "A person who serves as a subject for artwork, usually in the medium of photography but also for painting or drawing.", "Person whose job is to wear clothes in order to present them.", "A quantitative or mathematical representation or computer simulation which attempts to describe the characteristics or relationships of physical events.", "A grouping based on shared characteristics.", "To display an object for others to see, especially in regard to wearing clothing while performing the role of a fashion model.", "To create from a substance such as clay.", "A typical example or instance.", "A type of product."], "moisture": ["Water that is dispersed through a gas in the form of water vapour or small droplets, dispersed through a solid, or condensed on the surface of a solid."], "molecular biology": ["The study of the chemical structures and processes of biological phenomena at the molecular level; the discipline is particularly concerned with the study of proteins, nucleic acids, and enzymes, the macromolecules essential to life processes. It seeks to understand the molecular basis of genetic processes. Techniques used include X-ray diffraction and electron microscopy.\\n(Source: GILP96)"], "monitoring": ["The regularly checking in order to perceive change in some quality or quantity.\\n(Source: BRACK)"], "monitoring technique": ["Techniques employed in the process of checking, observing and measuring events, processes or physical, chemical, biological and environmental phenomena.\\n(Source: ZINZANa /  DUNSTEa)"], "monopoly": ["The market condition where a particular commodity or service has only one seller."], "monument": ["An object, especially large and made of stone, built to remember and show respect to a person or group of people, or a special place made for this purpose.", "A burial vault (usually for some famous person)."], "moor": ["A tract of unenclosed waste ground, usually covered with heather, coarse grass, bracken, and moss."], "moral persuasion": ["Appealing to the ethical principles or beliefs of an adversary or the public to convince the adversary to change behavior or attitudes."], "morphology": ["The branch of biology concerned with the form and structure of organisms.", "In linguistics, the study of word structure."], "mortality": ["The number of deaths occurring in a given population for a given period of time."], "moss": ["Any plant of the class Bryophyta, occurring in nearly all damp habitats."], "motorcycle": ["Single-track, two-wheeled motor vehicle."], "motor fuel": ["Any gaseous or liquid flammable fuel that burns in an internal combustion engine."], "motor vehicle": ["A road vehicle driven by a motor or engine, especially an internal combustion engine."], "mountain": ["A feature of the earth's surface that rises high above the base and has generally steep slopes and a relatively small summit area.", "A great number or large amount of things not placed in a pile."], "mountaineering": ["The sport, hobby or profession of walking, hiking and climbing up mountains."], "mountainous area": ["Area characterized by conspicuous peaks, ridges, or mountain ranges.\\n(Source: BJGEO)"], "mountain range": ["A single, large mass consisting of a succession of mountains or narrowly spaced mountain ridges, with or without peaks, closely related in position, direction, formation, and age."], "mowing": ["The cutting down of grass, crops or grain with a scythe or a mechanical device."], "mud flat": ["A relatively level area of fine silt along a shore (as in a sheltered estuary) or around an island, alternately covered and uncovered by the tide, or covered by shallow water."], "mulch": ["A layer of organic material applied to the surface of the ground to retain moisture."], "multilateral agreement": ["A binding agreement between three or more parties."], "multinational firm": ["A business company operating in multiple countries."], "municipal cleansing": ["The aggregation of services offered by a town or city in which streets and other public areas are kept clean, such as through trash pick-ups, street sweeping and decontamination of water, soil and other natural resources.\\n(Source: FFD)"], "municipality": ["A town, city, or other district having powers of local self-government.\\n(Source: LANDY)"], "municipal level": ["The jurisdiction, position or status of city, town or local government.\\n(Source: DAM / OED)"], "muscular system": ["The muscle cells, tissues, and organs that effect movement in all vertebrates."], "museum": ["A place or building where objects of historical, artistic, or scientific interest are exhibited, preserved or studied.\\n(Source: CED)", "Of or relating to a museum."], "mushroom": ["An organism belonging to a family of Basidiomycetes that are characterized by the production of spores on gills."], "music": ["The artistic organisation of sounds or tones that expresses ideas and emotions through the elements of rhythm, melody, harmony and tonal colour.", "A document which contains a musical composition in printed or written form."], "mussel farming": ["Breeding of mussels for sale as food."], "mustelid": ["A large, diverse family of low-slung, long-bodied carnivorous mammals including minks, weasels, and badgers; distinguished by having only one molar in each upper jaw, and two at the most in the lower jaw."], "mutagenicity": ["The property of chemical or physical agents of inducing changes in genetic material that are transmitted during cell division."], "mutagen": ["An agent that raises the frequency of mutation of genetic material above the spontaneous rate."], "mutant": ["An individual bearing an allele that has undergone mutation and is expressed in the phenotype."], "mutation": ["A change in the chemical constitution of the DNA in the chromosomes of an organism."], "mycology": ["The branch of botany concerned with the study of fungi."], "mycorrhiza": ["The symbiotic association of the root of a higher plant with a fungus."], "national legislation": ["A binding rule or body of rules prescribed by the government of a sovereign state that holds force throughout the regions and territories within the government's dominion.\\n(Source: RHW)"], "national park": ["Areas of outstanding natural beauty, set aside for the conservation of flora, fauna and scenery, and for recreation, if this does not conflict with the conservation objectives of the parks and their landscapes. Hunting, logging, mining, commercial fishing, agriculture and livestock grazing are all controlled within national parks, as is industrial activity.\\n(Source: WRIGHT)"], "natural area": ["An area of certain natural conditions, as opposed to a civilized area shaped and inhabited mainly by humans."], "natural disaster": ["Violent, sudden and destructive change in the environment without cause from human activity, due to phenomena such as floods, earthquakes, fire and hurricanes."], "natural fertiliser": ["Organic material added to the soil to supply chemical elements needed for plant nutrition."], "natural forest": ["A forest area that has developed free from the influence of humans and remains largely unaffected by their activities."], "natural gas": ["A natural fuel containing methane and hydrocarbons that occurs in certain geologic formations.\\n(Source: LANDY)"], "natural gas extraction": ["The tapping of natural gas from wells located under the sea and in general from underground sources often in association with petroleum deposits; it is used as a fuel, having largely replaced coal-gas for this purpose, and as a source of intermediates for organic synthesis."], "natural hazard": ["The probability of occurrence, within a specific period of time in a given area of a potentially damaging phenomenon of nature.\\n(Source: GUNN)"], "natural heritage": ["Generally, the world's natural resources as handed down to the present generation, and specifically, the earth's outstanding physical, biological and geological formations, and habitats of threatened species of animals and plants and areas with scientific, conservation or aesthetic value.\\n(Source: WHC /  OED)"], "rights of nature": ["A rule or body of rules that derives from nature and is believed to be binding upon human society, as opposed to human-made laws such as legislative acts and judicial decisions.\\n(Source: WOR / INP)"], "natural monument": ["A natural/cultural feature which is of outstanding or unique value because of its inherent rarity, representative of aesthetic qualities or cultural significance. Guidance for selection of a natural monument is: a) The area should contain one or more features of outstanding significance (appropriate natural features include spectacular waterfalls, caves, craters, fossil beds, sand dunes and marine features, along with unique or representative fauna and flora; associated cultural features might include cave dwellings, cliff-top forts, archaeological sites, or natural sites which have heritage significance to indigenous peoples).; b) The area should be large enough to protect the integrity of the feature and its immediately related surroundings.\\n(Source: AERG)"], "natural park": ["A designation project of lands which preserves natural resources for their scientific, scenic, cultural and/or educational value by limiting development and management practices. Land managed to protect rare and endangered species of flora and fauna will be designed as natural areas.\\n(Source: LANDY)"], "natural radioactivity": ["Radiation stemming mainly from uranium, present in small amounts in many rocks, soils, building material, etc."], "natural resource": ["A feature or component of the natural environment that is of value in serving human needs, e.g. soil, water, plantlife, wildlife, etc."], "natural science": ["The branches of science dealing with objectively measurable phenomena pertaining to the transformation and relationships of energy and matter; includes biology, physics, and chemistry."], "natural stone": ["A stone that occurs in nature, as distinguished from a man-made substitute."], "nature conservation": ["Active management of the earth's natural resources and environment to ensure their quality is maintained and that they are wisely used.\\n(Source: PHC)"], "nature reserve": ["Area allocated to preserve and protect certain animals and plants, or both."], "nausea": ["Desire to vomit."], "necrosis": ["The pathologic death of living tissue in a plant or animal."], "need": ["To need a number or amount of something, but not having any at all.", "The feeling of the lack of something.", "To need a number or amount of something, but not having enough or any at all.", "What is necessary to satisfy a need.", "To feel that something is necessary."], "nematode": ["A group of unsegmented worms which have been variously recognized as an order, class, and phylum.", "One of the most common phyla of animals, with over 80,000 different described species (of which over 15,000 are parasitic). They are ubiquitous in freshwater, marine, and terrestrial environments, where they often outnumber other animals in both individual and species counts, and are found in locations as diverse as Antarctica and oceanic trenches."], "nervous system": ["A coordinating and integrating system which functions in the adaptation of an organism to its environment; in vertebrates, the system consists of the brain, brainstem, spinal cord, cranial and peripheral nerves, and ganglia."], "net resource depletion": ["The total decrease in the amount of natural materials available for use by humans and other living beings."], "neurotoxicity": ["The occurrence of adverse effects on a nervous system following exposure to a chemical.\\n(Source: KOREN)"], "neutralisation": ["The act of making a solution neutral by adding a base to an acidic solution, or an acid to a basic solution."], "new community": ["A sociopolitical, religious, occupational or other group of common characteristics and interests formed as an alternative to social, and often residential, options currently available.\\n(Source: RHW)"], "nickel": ["A malleable ductile silvery-white metallic element that is strong and corrosion-resistant, occurring principally in pentlandite and niccolite: used in alloys, especially in toughening steel, in electroplating, and as a catalyst in organic synthesis.\\n(Source: CED)"], "nitrate": ["Any salt or ester of nitric acid, such as sodium nitrate."], "nitrification": ["The process by which ammonia compounds, including man-made fertilizer and the humus provided by organic matter or plant and animal origin, are converted into nitrites and then nitrates, which are then absorbed as a nutrient by crops."], "nitrite": ["A salt or ester of nitric acid, included in compounds such as potassium nitrite, sodium nitrite and butyl nitrite."], "nitro compound": ["Any one of a class of usually organic compounds that contain the monovalent group, -NO2 (nitro group or radical) linked to a carbon atom."], "nitrogen": ["Gaseous, non-metallic chemical element with symbol N and atomic number 7."], "nitrogen cycle": ["The complex set of processes by which crops acquire the large amount of nitrogen they need to make proteins, nucleic acids and other biochemicals of which they are composed, and how the nitrogen returns to the atmosphere."], "nitrogen dioxide": ["A reddish-brown gas; it exists in varying degrees of concentration in equilibrium with other nitrogen oxides; used to produce nitric acid."], "nitrogen fixation": ["Assimilation of atmospheric nitrogen by a variety of microorganisms which live freely in soil."], "nitrogen monoxide": ["A colourless gas, soluble in water, ethanol and ether."], "nitrosamine": ["Any one of a class of neutral, usually yellow oily compounds containing the divalent group."], "noise": ["Sound which is unwanted, either because of its effects on humans, its effect on fatigue or malfunction of physical equipment, or its interference with the perception or detection of other sounds.", "A random and unwanted signal."], "noise analysis": ["Determination of the frequency components that make up a particular noise being studied.\\n(Source: MGH)"], "noise barrier": ["A barrier for reducing the propagation of sound that are widely used in industry and alongside roads and railways."], "noise emission": ["The release of noise into the environment from various sources that can be grouped in: transportation activities, industrial activities and daily normal activities."], "noise immission": ["Immission in the environment of acoustic vibrations that negatively affect human beings, animals, plants or other objects."], "noise level": ["Physical quantity of unwanted sound measured, usually expressed in decibels."], "noise measurement": ["The process of quantitatively determining one or more properties of acoustic noise."], "noise pollutant": ["Noise in the environment which can be harmful to human beings, animals and plants.\\n(Source: ISEP)"], "noise pollution": ["Harmful or unwanted sounds in the environment, which in specific places, can be measured and averaged over a period of time."], "noise protection": ["Adoption of measures for controlling noise pollution, such as restriction of the emission of noise from industrial, commercial and domestic premises, from motor vehicles and aircrafts, the provision of noise barriers and buffer zones, the fitting of sound attenuation equipment, etc.\\n(Source: CONFERa /  GILP96a)"], "nomad": ["A member of a people or tribe who move from place to place to find pasture and food."], "nomenclature": ["The body of specialized words relating to a particular subject."], "non-ferrous metal": ["Any metal other than iron and its alloys."], "non-metallic mineral": ["Minerals containing non-metals, such as quartz, garnet, etc.\\n(Source: RRDA)"], "non-metal": ["A chemical element, that does not have the chemical or physical properties of a metal, e. g. oxygen or sulfur."], "non-polluting fuel": ["Clean fuel that does not release polluting emissions in the environment, such as methane."], "non-renewable resource": ["A natural resource which, in terms of human time scales, is contained within the Earth in a fixed quantity and therefore can be used once only in the foreseeable future (although it may be recycled after its first use)."], "non-returnable container": ["Any container for which no specific provisions for its return from the consumer or final use has been established."], "norm": ["An established standard, guide, or regulation.", "The most common and popular way of thinking among a population."], "normalisation": ["(Database) The process of structuring data to minimise duplication and inconsistencies."], "North Africa": ["A geographic region of the African continent south of Europe and the Mediterranean Sea, and north of Africa's tropical rain forest, including Morocco, Algeria, Tunisia, Libya and the Egyptian region west of the Suez Canal, and also the Sahara Desert and Atlas Mountains."], "North America": ["A continent in the northern half of the western hemisphere, bounded by the Arctic Ocean in the north, by the Pacific Ocean and the Bering Sea in the west, and by the Atlantic Ocean and the Gulf of Mexico in the east, connected to South America by the Isthmus of Panama, and including the United States, Canada, Mexico and several small island nations.\\n(Source: INP)"], "North Atlantic Ocean": ["The northern part of the Atlantic Ocean, extending northward from the equator to the Arctic Ocean."], "North Pacific Ocean": ["An ocean north of the equator between the eastern coast of Asia and the western coasts of the Americas, extending northward to the arctic region, with principal arms including the Gulf of Alaska, the Sea of Okhotsk, the Sea of Japan and the Bering, Yellow, East China, South China and Philippine seas, and islands including the Aleutian, Midway, Marshall and Hawaiian islands, the Japanese island arc and the Malay Archipelago."], "novel food": ["A type of food that does not have a significant history of consumption or is produced by a relatively new method."], "nuclear accident": ["An event occurring in a nuclear power plant or anywhere that radioactive materials are used, stored, or transported and involving the release of potentially dangerous levels of radioactive materials into the environment.\\n(Source: FEMAa)"], "nuclear energy": ["Energy released by nuclear fission or nuclear fusion."], "nuclear facility": ["A place, including buildings, where all the activities relating to nuclear research are performed.\\n(Source: CAMB)"], "nuclear fission": ["The division of an atomic nucleus into parts of comparable mass; usually restricted to heavier nuclei such as isotopes of uranium, plutonium, and thorium."], "nuclear fuel": ["Material that can be used in nuclear fission or fusion to create nuclear energy."], "nuclear fuel element": ["A piece of nuclear fuel which has been formed and coated, and is ready to be placed in a reactor fuel assembly."], "nuclear fusion": ["Combination of two light nuclei to form a heavier nucleus with release of some binding energy."], "nuclear physics": ["The study of the characteristics, behaviour and internal structures of the atomic nucleus."], "nuclear debate": ["The ongoing, public discussion and dispute over the uses of nuclear energy."], "nuclear power plant": ["A power plant in which nuclear energy is converted into heat for use in producing steam for turbines, which in turn drive generators that produce electric power."], "nuclear reaction": ["A reaction involving a change in an atomic nucleus, such as fission, fusion, neutron capture, or radioactive decay, as distinct from a chemical reaction, which is limited to changes in the electron structure surrounding the nucleus."], "nuclear reactor": ["Device which creates heat and energy by starting and controlling atomic fission."], "nuclear safety": ["Measures and techniques implemented to reduce the possibility of incidence and the potential harm posed by radioactive substances used as an energy source, a test material or in weaponry."], "nuclear test": ["Test performed to evaluate nuclear weapons."], "nuclear weapon": ["Any bomb, warhead, or projectile using active nuclear material to cause a chain reaction upon detonation."], "nucleic acid": ["Any of several organic acids combined with proteins (DNA or RNA) which exist in the nucleus and protoplasm of all cells."], "nuisance": ["Something which annoys."], "nutrient medium": ["A liquid or gel designed to support the growth of microorganisms, cells or small plants."], "nutrient content": ["The amount of proteins, carbohydrates, fats, inorganic salts (e.g. nitrates, phosphates), minerals (e.g. calcium, iron), and water."], "nutrient cycle": ["A biogeochemical cycle, in which inorganic nutrients move through the soil, living organisms, air and water or through some of these."], "nutrient removal": ["Elimination of nutrients as, for example, from sewage in order to prevent eutrophication of water in reservoirs."], "nutrient": ["Chemical elements which are involved in the construction of living tissue and which are needed by both plant and animal. The most important in terms of bulk are carbon, hydrogen and oxygen, with other essential ones including nitrogen, potassium, calcium, sulphur and phosphorus."], "nutrition": ["Chemical elements which are involved in the construction of living tissue and which are needed by both plant and animal. The most important in terms of bulk are carbon, hydrogen and oxygen, with other essential ones including nitrogen, potassium, calcium, sulphur and phosphorus.", "A process in animals and plants involving the intake of nutrient materials and their subsequent assimilation into the tissues."], "oak": ["Any tree of the genus Quercus in the order Fagales, characterized by simple, usually lobed leaves, scaly winter buds, a star-shaped pith, and its fruit, the acorn, which is a nut; the wood is tough, hard, and durable, generally having a distinct pattern.", "Wood of the oak tree."], "objection": ["The act of a party who objects to some matter or proceeding in the course of a trial or an argument or reason urged by him in support of his contention that the matter or proceeding objected to is improper or illegal.\\n(Source: BLACK)", "An argument that contradicts what is said by other persons."], "obligation to label": ["The legal responsibility or duty compelling manufacturers to affix certain marks or other written identification to their products, as is directed by laws, regulations or government standards."], "occupational disease": ["A functional or organic disease caused by factors arising from the operations or materials of an individual's industry, trade, or occupation."], "occupational medicine": ["The branch of medicine which deals with the relationship of humans to their occupations, for the purpose of the prevention of disease and injury and the promotion of optimal health, productivity, and social adjustment."], "occupational safety regulation": ["Law enacted to reduce the incidence among workers of personal injuries, illnesses, and deaths resulting from employment."], "ocean": ["The mass of water occupying all of the Earth's surface not occupied by land, but excluding all lakes and inland seas."], "ocean circulation": ["Water current flow in a closed circular pattern within an ocean."], "ocean current": ["A net transport of ocean water along a definable path.\\n(Source: MGH)"], "ocean dumping": ["The process by which pollutants, including sewage, industrial waste, consumer waste, and agricultural and urban runoff are discharged into the world's oceans."], "Oceania": ["The islands of the southern, western and central Pacific Ocean, including Melanesia, Micronesia, and Polynesia. The term is sometimes extended to encompass Australia, New Zealand, and the Malay Archipelago.\\n(Source: AMHER)"], "oceanography": ["The scientific study and exploration of the oceans and seas in all their aspects.\\n(Source: MGH)"], "ocean temperature": ["A measure, referenced to a standard value, of the heat or coldness in a body of oceanic water."], "odonate": ["Order in the class of insecta that includes dragonflies and damselflies."], "environmental criminality": ["Unlawful acts against the environment, such as water contamination, hazardous waste disposal, air contamination, unpermitted installation of plants, oil spills, etc.\\n(Source: AZENPa)"], "office": ["Any room, set of rooms or building used for the administration of government service, business transactions or other work related activities.", "Any building used for the administration of government service, business transactions or other work related activities.", "The actions and activities assigned to or required or expected of a person or group.", "Professional or clerical workers in an office."], "official hearing": ["Proceedings of relative formality, with definite issues of fact or of law to be tried, in which witnesses are heard and parties proceeded against have right to be heard.\\n(Source: WESTS)"], "offshore oil drilling": ["Oil extraction from platforms situated a short distance from the coast."], "oil binding agent": ["Highly absorbent agents used for physically removing spilled oil in case of leakages and oil accidents occurring in water bodies, industry, work-shops, on roads, etc."], "oil boom": ["A floating device used to contain oil on a body of water.", "A boom in the oil producing sector of an economy."], "oil disaster": ["The disaster caused by the dumping and accidental spillage of oil into waterways from ships and land-based or offshore installations. Oil pollution may destroy or damage aquatic life and wildlife such as birds, contaminate water supplies and create fire hazards.\\n(Source: GILP96)"], "oil pipeline": ["A line of pipe connected to valves and other control devices, for conducting oil."], "oil pollution": ["Contamination of any ecosystem, but usually of freshwater or marine ecosystems, by oil or other petroleum products."], "oil recovery vessel": ["A boat used for recovering oil spilled at sea from oil tankers."], "oil refinery": ["A plant where crude petroleum is transformed into fuels, lubricants, and other petroleum-derived products."], "oil refining": ["The separation of petroleum mixtures into their component parts."], "oil shale": ["A kerogen-bearing, finely laminated brown or black sedimentary rock that will yield liquid or gaseous hydrocarbons on distillation."], "oil slick": ["The mass of oil that floats on a surface of water, which is discharged accidentally, naturally or by design, and can be moved by currents, tides and the wind."], "oil spill": ["Contamination of any ecosystem, but usually of freshwater or marine ecosystems, by oil or other petroleum products.", "The accidental release of oil, or other petroleum products usually into freshwater or marine ecosystems, and usually in large quantities."], "oil tanker": ["A very large ship which carries crude oil or other petroleum products in big tanks."], "olfactometry": ["The testing and measurement of the sensitivity of the sense of smell."], "onchocerciasis": ["Infection with the filaria Onchocerca volvulus; results in skin tumours, papular dermatitis, and ocular complications."], "oncology": ["The study of the causes, development, characteristics, and treatment of tumors."], "opencast mining": ["The extraction of metal ores and minerals that lie near the surface by removing the overlying material and breaking and loading the ore.", "Superficial mining, in which the valuable rock is exposed by removal of overburden."], "opinion": ["That which one holds to be true; the acceptance of a fact, opinion, or assertion as real or true despite a lack of strong evidence or knowledge.", "Judgement or belief not founded on certainty or proof."], "ore": ["A mineral or mineral aggregate, mixed with gangue, that can be worked and treated at a profit."], "organ": ["A fully differentiated structural and functional unit, such as a kidney or a root, in an animal or plant.", "A keyboard instrument played using one or more manuals and a pedalboard. Sound is produced by an airflow through metal or wood pipes and/or electronically by sampled organ sounds or oscillators."], "organic carbon": ["Carbon which comes from an animal or plant. \\n\\n(Source: PHC)"], "organic chemistry": ["A branch of chemistry dealing with the study of composition, reaction, properties, etc. of organic compounds.\\n(Source: LEE)"], "organic farming": ["Farming without the use of industrially made fertilizers or pesticides."], "organic solvent": ["Organic materials, including diluents and thinners, which are liquids at standard conditions and which are used as dissolvers, viscosity reducers, or cleaning agents.\\n(Source: LEE)"], "organic substance": ["Chemical compounds, based on carbon chains or rings and also containing hydrogen with or without oxygen, nitrogen, or other elements.\\n(Source: MGH)"], "organic waste": ["A type of waste which can be broken down into its base compounds by micro-organisms."], "organism": ["An individual constituted to carry out all life functions."], "organochlorine compound": ["Organic compounds containing a C-Cl bond."], "organohalogen compound": ["Organic compounds containing a C-halogen bond."], "organometallic compound": ["Molecules containing carbon-metal linkage; a compound containing an alkyl or aryl radical bonded to a metal.\\n(Source: MGH)"], "organonitrogen compound": ["Organic compounds having a C-N bond.\\n(Source: RRDA)"], "organooxygen compound": ["Compounds, both aliphatic and aromatic, which have a C-O bond, including alcohols, aldehydes, etc."], "organophosphorous compound": ["Organic compound that contains phosphorous; short-lived, but some can be toxic when first applied.\\n(Source: EPAGLO)"], "organosilicon compound": ["Any natural substance composed of two or more unlike atoms held together by chemical bonds and containing silicon, a non-metallic element often found in rocks or minerals.\\n(Source: RHW)"], "organotin compound": ["Chemical compound used in anti-foulant paints to protect the hulls of boats and ships, buoys and pilings from marine organisms such as barnacles.\\n(Source: EPAGLO)"], "ornithology": ["The branch of zoology that deals with the study of birds, including their physiology, classification, ecology, and behaviour."], "orography": ["The study of mountain systems and the depiction of their relief.\\n(Source: WHIT)"], "orthopteran": ["A heterogeneous order of generalized insects with gradual metamorphosis, chewing mouthparts, and four wings."], "osmosis": ["The passage of a solvent through a semipermeable membrane separating two solutions of different concentrations."], "local recreation": ["A pastime, diversion, exercise or other means of enjoyment and relaxation that is carried out in a particular city, town or small district."], "overburden": ["The material such as soil and rock lying above a mineral deposit that must be removed in order to work the deposit."], "overcrowding": ["An excess of people gathered together in a confined space."], "overexploitation": ["The use of raw materials excessively without considering the long-term ecological impacts of such use.\\n(Source: WPR)"], "overfishing": ["Taking out of the sea more fish than natural population growth can sustain."], "overgrazing": ["The damaging of land as a result of excessive animal grazing, for example sheep and goats."], "overhead power line": ["Suspended cables by which electrical power is distributed throughout a country."], "overpopulation": ["A population density that exceeds the capacity of the environment to supply the health requirements of the individual organism."], "overwintering": ["The passing of winter in a particular place."], "oxidation": ["A chemical reaction that increases the oxygen content of a compound."], "oxidation-reduction": ["An oxidizing chemical change, where an element's positive valence is increased (electron loss), accompanied by a simultaneous reduction of an associated element (electron gain)."], "oxide": ["Binary chemical compound in which oxygen is combined with a metal or nonmetal."], "oxygen": ["A gaseous chemical element with symbol O and atomic number 8; an essential element in cellular respiration and in combustion processes; the most abundant element in the earth's crust and about 20% of the air by volume.\\n(Source: MGH)"], "oxygenation": ["Treating with oxygen."], "oxygen content": ["Amount of oxygen contained in a solution."], "ozone": ["An allotropic form of oxygen containing three atoms in the molecule. It is a bluish gas, very active chemically, and a powerful oxidizing agent. Ozone is formed when oxygen or air is subjected to a silent electric discharge. It occurs in ordinary air in very small amounts only.\\n(Source: UVAROV)"], "ozone depletion potential": ["A factor that reflects the ozone depletion potential of a substance, on a mass per kilogram basis, as compared to chlorofluorocarbon-11 (CFC-11). Such factor shall be based upon the substance's atmospheric life time, the molecular weight of bromine and chlorine, and the substance's ability to be photolytically disassociated, and upon other factors determined to be an accurate measure of relative ozone depletion potential.\\n(Source: LEE)"], "ozone layer": ["The general stratum of the upper atmosphere in which there is an appreciable ozone concentration and in which ozone plays an important part in the radiative balance of the atmosphere."], "packaging": ["All products made of any materials of any nature to be used for the containment, protection, handling, delivery and presentation of goods, from raw materials to processed goods, from the producer to the user or the consumer."], "paint": ["A mixture of pigment and a vehicle, such as oil or water, that together form a liquid or paste that can be applied to a surface to provide an adherent coating that imparts colour, protects the surface and/or gives the surface different features.", "To make a painting.", "To make a painting of."], "painting business": ["A commercial service through which paint, a decorative or protective coating product, or similar products are applied to the interiors and exteriors of buildings and other surfaces."], "paint shop": ["A shop where paint and related items are sold."], "paper": ["Felted or matted sheets of cellulose fibers, formed on a fine-wire screen from a dilute water suspension, and bonded together as the water is removed and the sheet is dried.", "Made of paper.", "A scholarly written work describing the results of observations or stating hypotheses."], "parameter": ["1) A quantity in an equation which must be specified beside the independent variables to obtain the solution for the dependent variables. \\n2) A quantity which is constant under a given set of conditions, but may be different under other conditions.\\n(Source: LEE /  MGH)"], "parasite": ["Organism which lives and obtains food at the expense of another organism, the host.", "A person who exploits fellow human beings."], "parasitology": ["A branch of biology which deals with those organisms, plant or animal, which have become dependent on other living creatures."], "Parliament": ["An assembly of elected representatives, typically controlled by a political party and constituting the legislative and, in some cases, the executive power of a state."], "participation": ["The act of sharing or taking part in a civic, community or public action."], "particle": ["Any very small part of matter, such as a molecule, atom, or electron.", "One-syllable suffixes or short words in Japanese and Korean grammar that immediately follow the modified noun, verb, adjective, or sentence. They have a wide range of grammatical functions, including the indication of a question or the speaker's assertiveness, certitude, or other feelings.", "A word or term that lack a precise lexical definition, that is typically short, indeclinable, and have a grammatical function.", "A very small piece of matter."], "particle separator": ["A device for segregation of solid particles by size range, as a screening."], "passenger transport": ["The conveyance of people over land, water or through air by automobile, bus, train, airplane or some other means of travel."], "pasture": ["Land covered with grass or herbage and grazed by or suitable for grazing by livestock.", "To put livestock into a field or pasture or meadow to graze.", "(For livestock) To feed on grass or herbage from a pasture.", "To feed as in a meadow or pasture."], "pathogen": ["Any disease-producing agent or microorganism."], "pathogenic organism": ["Agents producing or capable of producing disease."], "pathology": ["The branch of medicine concerned with the causes, origin, and nature of disease, including the changes occurring as a result of disease."], "peat": ["Unconsolidated soil material consisting largely of undecomposed or slightly decomposed organic matter accumulated under conditions of excessive moisture.\\n(Source: LANDY)"], "pedestrian zone": ["Area in a city where vehicles are not allowed."], "pedosphere": ["That shell or layer of the Earth in which soil-forming processes occur."], "penalty": ["Punitive sanction taken against someone who has broken the law.", "A free kick in football taken from 11 m in front of the goal with only the goalkeeper defending.", "A disadvantage imposed upon a competitor or team, according to the rules of the game.", "A legal punishment."], "pentachlorophenol": ["A toxic phenolic compounds with formula C6HOCl5, used as a fungicide, herbicide and molluscicide."], "perchloroethylene": ["Stable, colorless liquid, nonflammable and nonexplosive, with low toxicity; used as a dry-cleaning and industrial solvent, in pharmaceuticals and medicines, and for metal cleaning."], "periphyton": ["A plant or animal organism which is attached or clings to surfaces of leaves or stems of rooted plants above the bottom stratum."], "permeability": ["The ability of a membrane or other material to permit a substance to pass through it."], "permissible exposure limit": ["An exposure limit that is set for exposure to an hazardous substance or harmful agent and enforced by OSHA (Occupational Safety and Health Act) as a legal standard. It is based on time-weighted average concentrations for a normal 8-hour work day and 40 hour work week."], "permission": ["Voluntary agreement or permission."], "peroxyacetylnitrate": ["A pollutant created by the action of sunlight on hydrocarbons and nitrogen oxides in the air. An ingredient of smog."], "persistence": ["The capacity of a substance to remain chemically stable. This is an important factor in estimating the environmental effects of substances discharged into the environment. Certain toxic substances (e.g., cyanides) have a low persistence, whereas other less immediately toxic substances (e.g., many organochlorines) have a high persistence and may therefore produce more serious effects.\\n(Source: ALL)", "Lasting for a long period, being present for a long period."], "persistence of pesticides": ["The ability of a chemical to retain its molecular integrity and hence its physical, chemical, and functional characteristics in the environment through which such a chemical may be transported and distributed for a considerable period of time.\\n(Source: GILP96)"], "pest": ["Any unwanted insect or other organism that attacks and damages crops, reduces the fertility of land or injures or irritates livestock or people.", "A persistently annoying person."], "pest control": ["Keeping down the number of pests by killing them or preventing them from attacking."], "pesticide": ["A general term for chemical agents that are used in order to kill unwanted plants, animals pests or disease-causing fungi."], "residual pesticide": ["A pesticide remaining in the environment for a fairly long time, continuing to be effective for days, weeks, and months."], "pest infestation": ["The occurrence of one or more pest species in an area or location where their numbers and impact are currently or potentially at intolerable levels.", "A sudden increase in destructiveness or population numbers of a pest species in a given area."], "pet": ["An animal which is kept in the home as a companion and treated affectionately.", "To stroke or caress in an erotic manner, as during lovemaking."], "petrochemical industry": ["The production of materials derived from petroleum or natural gas.\\n(Source: MGH)"], "petrol": ["A fuel for internal combustion engines consisting essentially of volatile flammable liquid hydrocarbons derived from crude petroleum."], "petroleum": ["A comparatively volatile liquid bitumen composed principally of hydrocarbon, with traces of sulphur, nitrogen or oxygen compounds; can be removed from the earth in a liquid state."], "petroleum consumption": ["Petroleum belongs to non-renewable energy sources; it is a complex substance derived from the carbonized remains of trees, ferns, mosses, and other types of vegetable matter. The principal chemical constituents of oil are carbon, hydrogen, and sulphur. The various fuels made from crude oil are jet fuel, gasoline, kerosine, diesel fuel, and heavy fuel oils. Major oil consumption is in the following areas: transportation, residential-commercial, industrial and for generating electric power.\\n(Source: PARCOR)"], "petroleum geology": ["The branch of economic geology that relates to the origin, migration and accumulation of oil and gas, and to the discovery of commercial deposits. Its practice involves the application of geochemistry, geophysics, paleontology, structural geology and stratigraphy to the problems of finding hydrocarbons.\\n(Source: BJGEO)"], "petroleum industry": ["Manufacturing industry utilizing complex combination of interdependent operations engaged in the storage and transportation, separation of crude molecular constituents, molecular cracking, molecular rebuilding, and solvent finishing to produce petrochemical products."], "phanerogam": ["Plants that produce seeds. The group comprises the Gymnospermae and the Angiospermae.\\n(Source: ALL)"], "pharmaceutical industry": ["Concerted activity concerned with manufacturing pharmaceutical goods."], "pharmacokinetics": ["The study of the rates of absorption, tissue distribution, biotransformation, and excretion.\\n(Source: LEE)"], "pharmacology": ["The science dealing with the nature and properties of drugs, particularly their actions.\\n(Source: MGH)"], "phenol": ["A white crystalline soluble poisonous acidic derivative of benzene, used as an antiseptic and disinfectant and in the manufacture of resins, nylon, dyes, explosives and pharmaceuticals.\\n(Source: CED)"], "pheromone": ["Any substance secreted by an animal which influences the behaviour of other individuals of the same species.\\n(Source: MGH)"], "philosophy": ["The academic discipline concerned with making explicit the nature and significance of ordinary and scientific beliefs and investigating the intelligibility of concepts by means of rational argument concerning their presuppositions, implications, and interrelationships; in particular, the rational investigation of the nature and structure of reality (metaphysics), the resources and limits of knowledge (epistemology), the principles and import of moral judgment (ethics), and the relationship between language and reality (semantics)."], "phosphate": ["Any salt or ester of any phosphoric acid, especially a salt of orthophosphoric acid."], "phosphate removal": ["Replacement of phosphate in detergents by environmentally safer substances, such as zeolite. The substitute will not act as a nutrient, and so will not cause eutrophication as a result of the accelerated growth of plants and microorganisms if it is released into waterways.\\n(Source: WRIGHTa)"], "phosphate substitute": ["All substances that are able to substitute phosphate compounds in detergents; they must have the same chemical and physical properties and must be less polluting for the environment.\\n(Source: RRDA)"], "phosphorus": ["A nonmetallic element used to manufacture phosphoric acid, in phosphor bronzes, incendiaries, pyrotechnics, matches, and rat poisons; the white or yellow allotrope is a soft waxy solid, soluble in carbon disulfide, insoluble in water and alcohol, and is poisonous and self-igniting in air; the red allotrope is an amorphous powder, insoluble in all solvents and is nonpoisonous; the black allotrope comprises lustrous crystals similar to graphite, and is insoluble in most solvents."], "photochemical effect": ["The result or consequence of a chemical reaction caused by light or ultraviolet radiation."], "photochemical oxidant": ["Any of the chemicals which enter into oxidation reactions in the presence of light or other radiant energy."], "photochemical product": ["Degradation products that are produced by the action of light radiation.\\n(Source: FLGISAa)"], "photochemical reaction": ["Chemical reaction which is initiated by light of a specific wavelength."], "photochemical smog": ["A combination of fog and chemicals that come from automobile and factory emissions and is acted upon by the action of the sun."], "photogrammetry": ["The process of making measurements from photographs, used especially in the construction of maps from aerial photographs and also in military intelligence, medical and industrial research, etc."], "photograph": ["An image captured by a camera or some other device and reproduced as a picture, usually on a sensitized surface and formed by the chemical action of light or of radiant energy.", "To obtain an image of someone or something on photographic film or digital format by using photography."], "photosynthesis": ["Process by which plants transform carbon dioxide and water into carbohydrates and other compounds, using energy from the sun captured by chlorophyll in the plant."], "physical geography": ["The study of the spatial and temporal characteristics and relationships of all phenomena within the Earth's physical environment."], "physical oceanography": ["The study of the physical aspects of the ocean, the movements of the sea, and the variability of these factors in relationship to the atmosphere and the ocean bottom.\\n(Source: MGH)"], "physical planning": ["A form of urban land use planning which attempts to achieve an optimal spatial coordination of different human activities for the enhancement of the quality of life.\\n(Source: LANDY)"], "physical process": ["A continuous action or series of changes which alters the material form of matter.\\n(Source: RHW)"], "physical property": ["Property of a substance that cannot change without involving a change in chemical composition.", "Physical quantity that is characteristic for a material or an object, e. g. density"], "physical science": ["The sciences concerned with nonliving matter, energy, and the physical properties of the universe, such as physics, chemistry, astronomy, and geology."], "physics": ["The study of those aspects of nature which can be understood in a fundamental way in terms of elementary principles and laws."], "physiology": ["The biological study of the functions of living organisms and their parts."], "phytopathology": ["The study of plant diseases and their control.\\n(Source: ZINZAN)"], "phytoplankton": ["Planktonic plant life.\\n(Source: MGH)"], "phytosociology": ["The study of vegetation, including the organization, interdependence, development, geographical distribution and classification of plant communities."], "phytotoxicity": ["Ability of a substance to cause injury or damage to a plant."], "satellite image": ["A pictorial representation of data projected onto a two-dimensional grid of individual picture elements (pixels) and acquired from a human-made vessel placed in orbit round a planet, moon or star."], "pilotage": ["The service provided by a pilot, one who controls the movements of a ship or aircraft by visual or electronic means."], "pilot plant": ["A small version of a planned industrial plant, built to gain experience in operating the final plant."], "pilot project": ["A small scale experiment or set of observations undertaken to decide how and whether to launch a full-scale project."], "pinniped": ["A mammal belonging to the Pinnipedia, an order of aquatic placental mammals having a streamlined body and limbs specialized as flippers: includes seals, sea lions, and the walrus."], "pipeline": ["A line of pipe connected to valves and other control devices, for conducting fluids, gases, or finely divided solids.\\n(Source: MGH)", "A system of tubes, especially the ones with a large diameter, for conducting ou distributing liquids or gases.", "To convey something by a system of pipes."], "pipe": ["A rigid tube that transports water, steam or other fluid, as used in plumbing and numerous other applications.", "A device consisting of a mouthpiece, a long pipe stem and a pipe bowl, that is used to smoke tobacco."], "plain": ["An extensive, broad tract of level or rolling, almost treeless land with a shrubby vegetation, usually at a low elevation.", "Having a surface without slope nor variations in altitude.", "To state complaints, discontent, displeasure, or unhappiness.", "Having only one color."], "plan": ["A scheme of action, a method of proceeding, or a series of steps, thought out in advance to accomplish a goal.", "Scale drawing of a structure or its parts.", "To make or work out a plan for; devise.", "To have the intention to carry out some action.", "To make a (graphic) design of."], "plankton": ["Small organisms (animals, plants, or microbes) passively floating in water."], "planning": ["The act of making a detailed scheme for attaining an objective."], "planning law": ["A binding rule or body of rules prescribed by a government to organize, designate and regulate land use."], "planning permission": ["An authorization, license or equivalent control document issued by a government agency that approves a step by step method and process of defining, developing and outlining various possible courses of action to meet existing or future needs, goals and objectives.\\n(Source: TOE / ISEP)"], "plant breeding": ["Raising a certain type of plant by crossing one variety with another to produce a new variety where the desired characteristics are strongest."], "plant community": ["Any group of plants belonging to a number of different species that co-occur in the same habitat or area and interact through trophic and spatial relationships; typically characterized by reference to one or more dominant species."], "plant disease": ["A disease that affects plants."], "plant genetics": ["The scientific study of the hereditary material of plants for purposes such as hybridization, improved food resources and increased production."], "plant protection product": ["Any substance or mixture of substances which through physiological action protects the plants against parasites, fungi, virus, or other damaging factors.\\n(Source: KORENa)"], "plantigrade": ["Pertaining to mammals walking with the whole sole of the foot touching the ground.", "Mammal walking with the whole sole of the foot touching the ground."], "planting": ["The establishment of trees or other plants by transplanting, or planting seedlings or cuttings."], "plant physiology": ["The study of the function and chemical reactions within the various organs of plants.\\n(Source: UVAROV)"], "plant protection": ["Conservation of plant species that may be rare or endangered, and of other plants of particular significance.\\n(Source: GILP96)"], "plant trade": ["Trade of plants subjected to regulations established by the Convention on International Trade in Endangered Species (CITES)."], "plasma technology": ["1) Common name for a number of industrial applications of plasma, such as: etching of semiconductor chips, deposition of silicon for solar cell production, deposition of silicon dioxide for passivation of surfaces, activation of surfaces, melting and welding with plasma arcs as well as plasma chemistry. \\n2) Plasma technology consists of minute gas-filled cells, which emit light when an electric current is channelled through them.\\n(Source: IEAP /  Z2Z)"], "plastic": ["A polymeric material (usually organic) of large molecular weight which can be shaped by flow; usually refers to the final product with fillers, plasticizers, pigments, and stabilizers included (versus the resin, the homogeneous polymeric starting material); examples are polyvinyl chloride, polyethylene, and urea-formaldehyde.", "Capable of being molded or modeled."], "plastic waste": ["Any discarded plastic (organic, or synthetic, material derived from polymers, resins or cellulose) generated by any industrial process, or by consumers.\\n(Source: APD)"], "platinum": ["A ductile malleable silvery-white metallic element very resistant to heat and chemicals. It occurs free and in association with other platinum metals, especially in osmiridium; used in jewellery, laboratory apparatus, electrical contacts, dentistry, electroplating, and as a catalyst."], "playground": ["A piece of land used for recreation, especially by children, often including equipment such as swings and slides."], "plutonium": ["A highly toxic metallic transuranic element with symbol Pu and atomic number 94."], "poaching": ["The action of catching game, fish, etc. illegally by trespassing on private property.\\n(Source: CED)"], "point source": ["A single identifiable localized source of something."], "poison": ["A substance which, when ingested, inhaled, or absorbed, or when applied to, injected into, or developed within the body, in relatively small amounts, may cause injury, harm, or destruction to organs, tissue, or life.", "To administer a toxic substance."], "poisoning": ["The morbid condition produced by a poison which may be swallowed, inhaled, injected, or absorbed through the skin.\\n(Source: KOREN)"], "polar ecosystem": ["The interacting systems of the biological communities and their nonliving environmental surroundings located in the regions where the air temperature is perennially below 10\u00b0 Celsius, usually at and near the North and South Poles.", "Ecosystem of the region around Earth's poles."], "polar region": ["Area relating to the earth's poles or the area inside the Arctic or Antarctic Circles."], "polder": ["A generally fertile tract of flat, low-lying land (as in Netherlands and Belgium) reclaimed and protected from the sea, a lake, a river, or other body of water by the use of embankments, dikes, dams, or levees."], "police": ["Branch of the government which is charged with the preservation of public order, the promotion of public health and safety, and the prevention, detection, and punishment of crimes."], "police law": ["A binding rule or body of rules prescribed by a government to regulate the employment and tactics of police or other civil agents organized to maintain order, prevent and detect crimes and promote obedience to civil regulations and authority."], "policy": ["A general plan of action, formulated by a political party, a government agency or a similar institution."], "politics": ["The theory and practice of acquiring and exercising the power to govern in a society in order to arbitrate values, allocate resources and establish and enforce rules."], "policy planning": ["The process of making arrangements or preparations to facilitate any course of action that may be adopted and pursued by government, business or some other organization."], "political doctrine": ["A policy, position or principle advocated, taught or put into effect concerning the acquisition and exercise of the power to govern or administrate in society.\\n(Source: RHW)"], "political ecology": ["The study of how political, economic, and social factors affect environmental issues."], "political geography": ["The study of the effects of political actions on human geography, involving the spatial analysis of political phenomena.\\n(Source: GOOD)"], "political party": ["An organized group that has as its fundamental aim the attainment of political power and public office for its designated leaders. Usually, a\\npolitical party will advertise a common commitment by its leaders and its membership to a set of political, social, economic and/or cultural values."], "political power": ["The might, ability or authority of governments, citizens groups and other interested parties in enacting change or in influencing or controlling the outcome of governmental or public policies affecting a nation, region or municipality.\\n(Source: BLD)"], "pollen": ["A fine granular substance produced in flowers. Collective term for pollen grains or microspores produced in the anthers of flowering plants."], "pollutant": ["A substance, usually a residue of human activity, which has an undesirable effect upon the environment.", "A substance that pollutes."], "pollutant accumulation": ["The process by which concentrations of pollutants progressively increase in the tissues of living organisms in environments where these pollutants are present."], "pollutant emission": ["Release of polluting substances in the air, water and soil from a given source and measured at the immission point."], "pollutant load": ["The amount of polluting material that a transporting agent, such as a stream, a glacier, or the wind, is actually carrying at a given time."], "polluter-pays principle": ["The principle that those causing pollution should meet the costs to which it gives rise."], "pollution": ["The indirect or direct alteration of the biological, thermal, physical, or radioactive properties of any medium in such a way as to create a hazard or potential hazard to human health or to the health, safety or welfare of any living species.\\n(Source: ALL)"], "pollution load": ["The amount of polluting material that a transporting agent, such as a stream, a glacier, or the wind, is actually carrying at a given time."], "pollution measurement": ["The assessment of the concentration of pollutants for a given time in a given point."], "polybrominated biphenyl": ["A chemical substance consisting of several bromine atoms attached to biphenyl."], "polychlorinated biphenyl": ["Any of a class of aromatic organic compounds formed by the chlorination of the hydrocarbon biphenyl; they have many industrial applications but are damaging to the environment."], "polychlordibenzo-p-dioxin": ["PCDD are formed (along with variants including furans) when compounds containing chlorine are burnt at low temperature in improperly operated/designed domestic refuse and industrial waste incinerators where PCDDs can be found in both the flue gases and the fly ash.\\n(Source: PORT)"], "polychlorinated dibenzofuran": ["A family containing 135 individual, colorless compounds known as congeners with varying harmful health and environmental effects. They are produced as unwanted compounds during the manufacture of several chemicals and consumer products such as wood treatment chemicals, some metals, and paper products; also produced from the burning of municipal and industrial waste in incinerators, from exhaust of leaded gasoline, heat, or production of electricity. They are hazardous to the respiratory system, gastrointestinal system, liver, musculoskeletal system, skin and nervous system; and are toxic by inhalation, ingestion, and contact. Symptoms of exposure include frequent coughing, severe respiratory infections, chronic bronchitis, abdominal pain, muscle pain, acne rashes, skin color changes, unexpected weight loss, nonmalignant or malignant liver disease.\\n(Source: KOREN)"], "polychlorinated terphenyl": ["Compounds consisting of three benzene rings linked to each other in either ortho, meta or para positions and substituted with chlorine atoms."], "polycyclic aromatic hydrocarbon": ["Hydrocarbons containing two or more closed rings of atoms."], "polycyclic hydrocarbon": ["Hydrocarbon molecule with two or more nuclei; examples are naphtalene, with two benzene rings side by side, or diphenyl, with two bond-connected benzene rings. Also known as polynuclear hydrocarbon.\\n(Source: MGH)"], "polyethylene terephtalate": ["A thermoplastic polyester resin made from ethylene glycol and terephthalic acid; melts at 265\u00b0C; used to make films or fibers."], "polymer": ["Substance made of giant molecules formed by the union of simple molecules (monomers).\\n(Source: MGH)"], "polyvinyl chloride": ["Polymer of vinyl chloride; tasteless, odourless; insoluble in most organic solvents; a member of the family of vinyl resins."], "pond": ["A natural body of standing fresh water occupying a small surface depression, usually smaller than a lake and larger than a pool."], "tailings pond": ["Any collection of liquid effluents or wastewater drained or separated out during the processing of crops or mineral ores."], "pool": ["A small, natural body of standing water, usually fresh; e.g. a stagnant body of water in a marsh, or a still body of water within a cave."], "population distribution": ["The density, dispersal pattern and apportionment of the total number of persons in any area.\\n(Source: RHW / EEN)"], "population dynamics": ["The process of numerical and structural change within populations resulting from births, deaths, and movements."], "population ecology": ["The study of the interaction of a particular species or genus population with its environment."], "population growth": ["An increase in the total number of inhabitants of a country, city, district or area."], "population movement": ["Any shift or migration of a statistically significant number of persons inhabiting a country, district or area.\\n(Source: RHW)"], "population structure": ["The organization of, and inter-relationships among, inhabitants of a given region, country or city."], "population trend": ["The direction of change in the total number of persons inhabiting a country, city, district or area."], "potash": ["Any of several compounds containing potassium, especially soluble compounds such as potassium oxide, potassium chloride, and various potassium sulfates, used chiefly in fertilizers."], "rock salt mining": ["Rock salt mining is an underground mining process in which the salt is physically dug out of the ground in an operation involving drilling, blasting and crushing the rock. The major percentage of this output is used for winter road maintenance.\\n(Source: SALINF)"], "poultry": ["Domesticated fowl grown for their meat and eggs.", "A bird that is kept for its meat and eggs."], "poverty": ["State in which the individual lacks the resources necessary for subsistence.", "Lack of the means of subsistence."], "power station": ["A stationary plant containing apparatus for large-scale conversion of some form of energy (such as hydraulic, steam, chemical, or nuclear energy) into electrical energy.", "A stationary plant containing apparatus for large-scale conversion of some form of energy (such as hydraulic, steam, chemical, or nuclear energy) into electrical energy."], "precipitation enhancement": ["Increase of precipitation resulting from changes in the colloidal stability of clouds. This can be either intentional, as with cloud seeding, or unintentional, as with air pollution, which increases aerosol concentrations and reduces sunlight.\\n(Source: PARCOR)"], "predator": ["Animal which kills and eats other animals.\\n(Source: PHC)", "Man who is hostile to, feels hatred towards, opposes the interests of, or intends injury to someone else."], "prefabricated building": ["Building whose sections are manufactured in specialized factories and later transported and assembled on a building site."], "preliminary proceedings": ["Any introductory action in the judicial process designed to determine the need for further court involvement or to expedite a motion that requires immediate attention.\\n(Source: BLD)"], "premium": ["Amount to be paid for a contract of insurance or life assurance."], "preservative": ["A chemical added to foodstuffs to prevent oxidation, fermentation or other deterioration, usually by inhibiting the growth of bacteria."], "preserve": ["A sweet spread made of any of a variety of berries.", "To keep something or someone safe or prevent harm coming to someone or something.", "To protect; to keep; to maintain the condition of."], "press": ["Printed matter as a whole, especially newspapers and periodicals.", "A crowd of people pressed close together in a small space.", "To apply pressure to an item.", "To force or impel in a given direction."], "pressing": ["Needing urgent attention."], "pressure": ["A type of stress which is exerted uniformly in all directions; its measure is the force exerted per unit area.", "To exert violence, or constraint upon or against a person in order to obtain something by physical, moral or intellectual means."], "pressure group": ["Any politically active group with a common set of values about resource use allocation."], "price": ["The amount of money paid per unit for a good or service.", "To attach a price tag to goods or services which are to be sold.", "To fix or set a price to be paid for, or asked for, a good or service which one wants to sell."], "primary education": ["The first five or six years of instruction in elementary schools.\\n(Source: COE)"], "primary energy consumption": ["Consumption of energy used in the same form as in its naturally occurring state, for example crude oil, coal, natural gas, e.g. before it is converted into electricity.\\n(Source: BRACK)"], "primary sector": ["That part of a country's or region's economy that makes direct use of natural resources, including agriculture, forestry, fishing and the fuel, metal and mining industries."], "primate": ["Order of mammals containing monkeys, apes, and human beings.", "In the Western Catholic Church and in the Anglican Communion, a bishop with higher rank than a metropolitan archbishop but, in the Catholic Church, with less high rank than a major archbishop."], "primary forest": ["Forest which originally covered a region before changes in the environment brought about by people."], "printing industry": ["A sector of the economy in which an aggregate of commercial enterprises is engaged in the reproduction of written text or images in multiple copies such as books, periodicals, newspapers or other similar formats.\\n(Source: SIC)"], "printing work": ["The art, process or business of producing reproductions of written text or images in multiple copies, in book, periodical or newspaper formats, or in other similar formats.\\n(Source: SIC / RHW)"], "private household": ["Living quarters where a group of persons (family) live together.\\n(Source: GOOD)"], "private law": ["The branch of law dealing with such aspects of relationships between individuals that are of no direct concern to the state."], "private sector": ["Segment of the economy not run by government, including households, sole traders, partnerships and companies."], "private transport": ["Transport performed with private means."], "proboscidean": ["An order of herbivorous placental mammals characterized by having a proboscis, incisors enlarged to become tusks, and pillarlike legs with five toes bound together on a broad pad."], "procaryote": ["Organisms (i.e. prokaryotes) whose genetic material (filaments of DNA) is not enclosed by a nuclear membrane, and that do not possess mitochondria or plastids. Bacteria and cyanophyta are the only prokaryotic organisms."], "procedural law": ["Law which prescribes method of enforcing rights or obtaining redress for their invasion. Laws which fix duties, establish rights and responsibilities among and for persons, natural or otherwise, are \"substantive laws\" in character, while those which merely prescribe the manner in which such rights and responsibilities may be exercised and enforced in a court are \"procedural laws\".\\n(Source: BLACK)"], "processing": ["The act of converting material from one form into another desired form."], "process water": ["Water used in a manufacturing or treatment process or in the actual product manufactured."], "producer liability": ["Obligations, responsibilities or debts imposed upon all members of an industry that manufactures or produces a product or service causing injury or harm to a consumer and apportioned according to each member's share of the market for the product.\\n(Source: BLD)"], "product": ["Something produced by human or mechanical effort or by a natural process.", "A chemical substance formed as a result of a chemical reaction.", "A commodity offered for sale.", "A quantity obtained by multiplication of two or more numbers."], "product information": ["Factual, circumstantial and, often, comparative knowledge concerning various goods, services or events, their quality and the entities producing them."], "productivity": ["The amount of output or yield per unit of input or expenditure achieved by a company, industry or country."], "productivity trend": ["The general direction or tendency in the measurement of the production of goods and services having exchange value."], "product liability": ["The legal liability of manufacturers and sellers to compensate buyers, users, and even bystanders, for damages or injuries suffered because of defects in goods purchased."], "product standard": ["A standard which prescribes aspects of the physical or chemical composition of products which have potential for causing environmental damage or the handling, presentation and packaging of products, particularly those which are toxic.\\n(Source: GRAHAW)"], "profit": ["An excess of the receipts over the spending, costs and expenses of a business or other commercial entity during any period.", "What it remains after subtracting from the total of the revenues the total of the costs of an economic activity or a commercial or financial operation.", "Income following the deduction of all expenses, taxes, and the like.", "The advantageous quality of being beneficial.", "To derive a benefit from."], "programme": ["A scheme of action, a method of proceeding, or a series of steps, thought out in advance to accomplish a goal.", "To enter a program or other instructions into a computer (or other electronic device) to instruct it to do a particular task.", "To arrange the schedule of an event."], "prohibition": ["An interdiction or forbidding of an activity or action by authority or law."], "project": ["To make or work out a plan for; devise.", "To extend out or project in space.", "To show on a screen.", "To communicate vividly (e.g. feelings)."], "propellant": ["A gas used in aerosol preparations to expel the liquid contents through an atomizer."], "prosecution": ["The pursuit of legal proceedings, particularly criminal proceedings."], "prosperity": ["State of being prosperous; wealth or success."], "water protection area": ["Area surrounding a water recovery plant in which certain forms of soil utilization are restricted or prohibited in order to protect the groundwater.\\n(Source: AZENP)"], "protection of species": ["Measures adopted for the safeguarding of species, of their ecosystems and their biodiversity.\\n(Source: ADMIN)"], "protection system": ["A series of procedures and devices designed to preserve people, property or the environment from injury or harm.\\n(Source: RHW)"], "protein": ["Any of a class of high-molecular weight polymer compounds composed of a variety of alfa-amino acids joined by peptide linkages."], "protocol": ["The original draft of a document.", "An international agreement of a less formal nature than a treaty. It is often used to amend treaties. (Source: DICLAW)", "A formal description of digital message formats and the rules for exchanging those messages in or between computing systems and in telecommunications."], "protozoan": ["A diverse phylum of eukaryotic microorganisms; the structure varies from a simple uninucleate protoplast to colonial forms, the body is either naked or covered by a test, locomotion is by means of pseudopodia or cilia or flagella, there is a tendency toward universal symmetry in floating species and radial symmetry in sessile types, and nutrition may be phagotrophic or autotrophic or saprozoic."], "province": ["A geographic area of some considerable extent, smaller than a continent but larger than a region, which is unified by some or all of its characteristics and which can therefore be studied as a whole. A faunal province, for example, has a particular assemblage of animal species, which differs from assemblages in different contemporaneous environments elsewhere.\\n(Source: WHIT)", "An administrative subdivision of a country, in some cases relatively autonomous and equivalent to a state, in others, smaller and less autonomous and more akin to a county."], "psychology": ["The science that deals with the functions of the mind and the behaviour of an organism in relation to its environment.\\n(Source: MGH)"], "psychosomatic illness": ["Illness arising from or aggravated by a mind-body relationship."], "public action": ["A measure or provision taken on behalf and with the consent of the general populace."], "public bath": ["A place having baths for public use."], "public building": ["A building to which there is free access by the public and which is available for the use of a community."], "public health": ["The discipline in health science that, at the level of the community or the public, aims at promoting prevention of disease, sanitary living, laws, practices and a healthier environment.\\n(Source: GUNN)"], "public law": ["The branch of law which governs relationships between individuals and the government."], "public opinion": ["The purported, collective view of the public on some issue or problem, typically formulated by selective polling or sampling, and frequently used as a guide to action or decision."], "public opinion polling": ["The canvassing of a representative sample of a large group of people on some question in order to determine the general opinion of a group."], "public park": ["Park with big trees, ornamental plants, alleys bordered by trees or bushes, fountains and statues situated in a town and whose access is free."], "public participation": ["The involvement of citizens in public matters, with the purpose of exerting influence."], "public-private partnership": ["A joint venture between corporations and government or between community members and government or business beyond the course of normal interaction."], "public sector": ["Segment of the economy run to some degree by government, including national and local governments, government-owned firms and quasi-autonomous non-government organizations."], "public service": ["An enterprise concerned with the provision to the public of essentials, such as electricity or water.\\n(Source: CED)"], "public transport": ["The act or the means of conveying people in mass as opposed to conveyance in private vehicles.\\n(Source: GOOD)"], "public utility": ["An enterprise concerned with the provision to the public of essentials, such as electricity or water.\\n(Source: CED)"], "pulmonary disease": ["Any disease pertaining to the lungs."], "pulp": ["A soft and moist mass of material usually obtained by pressing or beating a relatively hard object. It is mostly used about vegetable matter.", "The soft center of a tooth, where blood vessels and nerve endings are located.", "The soft and moist interior of a fruit.", "The edible inner of fruit, as opposed to that of animals, fish or nuts."], "pump": ["A machine that draws a fluid into itself through an entrance port and forces the fluid out through an exhaust port.\\n(Source: MGH)", "To use a pump to move (liquid or gas).", "To move up and down (e.g. weights in the gym)."], "purchase": ["The acquisition or the act of buying something by payment of money or its equivalent.", "To obtain in exchange for money or goods.", "The mechanical advantage gained by being in a position to use a lever."], "purification": ["The removal of unwanted constituents from a substance."], "purin": ["Any of a number of nitrogenous bases, such as guanine and adenine, that are derivatives of purine and constituents of nucleic acids and certain coenzymes.\\n(Source: CED)"], "pyrolysis": ["The breaking apart of complex molecules into simpler units by the use of heat.\\n(Source: MGH)"], "quality control": ["The inspection, analysis, and other relevant actions taken to provide control over what is being done, manufactured, or fabricated, so that a desirable level of quality is achieved and maintained."], "quality of life": ["All the factors that determine the well-being of an individual or societies, including wealth, employment, physical and mental health, environment, education and leisure time."], "quarry": ["An open or surface working or excavation for the extraction of building stone, ore, coal, gravel, or minerals.", "Animal hunted or caught for food.", "A person who is the aim of an attack (especially a victim of ridicule or exploitation) by some hostile person or influence."], "quarrying": ["The surface exploitation and removal of stone or mineral deposits from the earth's crust.\\n(Source: MGH)"], "race relations": ["The associations, tensions or harmony between two or more groups of people distinguished by history, culture, religion or physique: distinctions erroneously construed as being based on consistent biological differences and as representing, in effect, species of a human genus.\\n(Source: SOC / RHW)"], "radar": ["A system using beamed and reflected radiofrequency energy for detecting and locating objects, measuring distance or altitude, navigating, homing, bombing and other purposes."], "radiation": ["Emission of any rays from either natural or man-made origins, such as radio waves, the sun's rays, medical X-rays and the fall-out and nuclear wastes produced by nuclear weapons and nuclear energy production. Radiation is usually divided between non-ionizing radiation, such as thermal radiation (heat) and light, and nuclear radiation. Non-ionizing radiation includes ultraviolet radiation from the sun which, although it can damage cells and tissues, does not involve the ionization events of nuclear radiation.\\n(Source: WRIGHT)"], "radiation damage": ["Somatic and genetic damage to living organisms caused by exposure to ionizing radiation."], "radiation dose": ["The total amount of radiation absorbed by material or tissues, in the sense of absorbed dose, exposure dose, or dose equivalent."], "radiation effect": ["Prolonged exposure to ionizing radiation from various sources that can be harmful. Nuclear radiation from fallout from nuclear weapons or from power stations, background radiation from substances naturally present in the soil, exposure to X-rays can cause radiation sickness. Massive exposure to radiation can kill quickly and any person exposed to radiation is more likely to develop certain types of cancer than other members of the population.\\n(Source: PHC)"], "radiation exposure": ["The act or state of being subjected to electromagnetic energy strong enough to ionize atoms thereby posing a threat to human health or the environment.\\n(Source: APD / MHD)"], "radiation monitoring": ["The periodic or continuous surveillance or analysis of the level of radiant energy present in a given area, to determine that its prescribed amount has not been exceeded or that it meets acceptable safety standards.\\n(Source: TOE / OMD)"], "radiation physics": ["The study of ionizing radiation and its effects on matter."], "radiation protection": ["Precautionary actions, measures or equipment implemented to guard or defend people, property and natural resources from the harmful effects of ionizing energy."], "radiation sickness": ["Damage to the body resulting from excessive exposure to ionizing radiation which causes symptoms like nausea, fatigue, vomiting, and diarrhea and in severe cases loss of hair, hemorrhage, inflammation and death."], "radio": ["The process, equipment or programming involved in transmitting and receiving sound signals by electromagnetic waves.", "A device that can capture the signal sent over radio waves and render the modulated signal as sound."], "radioactive contamination": ["Contamination of a substance, living organism or site caused by radioactive material."], "radioactive emission": ["The release of radioactive substances into the environment deriving from nuclear installations and from mining, purification and enrichment operations of radioactive elements.\\n(Source: FLGISA)"], "radioactive fallout": ["The material that descends to the earth or water well beyond the site of a surface or subsurface nuclear explosion."], "radioactive substance": ["Any substance that contains one or more radionuclides of which the activity or the concentration cannot be disregarded as far as radiation protection is concerned.\\n(Source: ECHO2)"], "radioactive tracer": ["A radioactive isotope which, when injected into a biological or physical system, can be traced by radiation detection devices, permitting determination of the distribution or location of the substance to which it is attached."], "radioactive waste": ["Any waste that emit radiation in excess of normal background level, including the toxic by-products of the nuclear energy industry."], "radioactivity": ["The property possessed by some atomic nuclei of disintegrating spontaneously, with loss of energy through emission of a charged particle and/or gamma radiation."], "radionuclide": ["A nuclide that exhibits radioactivity.", "An unstable isotope of an element that decays or disintegrates spontaneously, emitting radiation."], "radon": ["A radioactive gaseous element emitted naturally from rocks and minerals where radioactive elements are present. It is released in non-coal mines, e.g. tin, iron, fluorspar, uranium. Radon is an alpha particle emitter as are its decay products and has been indicted as a cause of excessive occurrence of lung cancer in uranium miners. Concern has been expressed at radon levels in some housing usually adjacent to granite rocks or old tin mining regions.\\n(Source: PORT)"], "rag": ["To make someone rather angry or impatient; to cause annoyance.", "A piece of old cloth; a tattered piece of cloth; a shred, a tatter."], "rail traffic": ["The movement and circulation of vehicles transporting goods and people on railroad systems."], "rail transport": ["Transportation of goods and persons by railway.\\n(Source: CEDa)"], "rain": ["Precipitation in the form of liquid water drops with diameters greater than 0.5 millimetres.", "To fall from the clouds in drops of water."], "rain forest": ["A forest of broad-leaved, mainly evergreen, trees found in continually moist climates in the tropics, subtropics, and some parts of the temperate zones."], "rainout": ["A sporting fixture that could not be completed because of rain."], "rain water": ["Water which falls as rain from clouds."], "random test": ["A test which does not always yield the same result when repeated under the same conditions."], "rare species": ["Species which have a restricted world range."], "raw material": ["A crude, unprocessed or partially processed material used as feedstock for a processing operation."], "raw material securing": ["Measures used to ensure the provision of or the access to crude, unprocessed or partially processed materials used as feedstock for processing or manufacturing.\\n(Source: RHWa /  MHD)"], "reaction kinetics": ["That branch of physical chemistry concerned with the mechanisms and rates of chemical reactions."], "reactor": ["A device that introduces either inductive or capacitive reactance into a circuit, such as a coil or capacitor.\\n(Source: MGH)"], "reactor safety": ["Those studies and activities that seek to minimise the risk of a nuclear reactor accident.\\n(Source: RRDA)"], "recommendation": ["An action which is advisory in nature rather than one having any binding effect.", "The act of commending."], "recreation": ["Activities that promote refreshment of health or spirits by relaxation and enjoyment.", "Any activity, such as play, that diverts, amuses or stimulates."], "recycled paper": ["Paper that has been separated from the solid waste stream for utilization as a raw material in the manufacture of a new product."], "recycling": ["A resource recovery method involving the collection and treatment of a waste product for use as raw material in the manufacture of the same or a similar product."], "life-cycle management": ["Management of all the stages involved in the life of a product such as raw materials acquisition, manufacturing, distribution and retail, use and re-use and maintenance, recycling and waste management, in order to create less environmentally harmful products.\\n(Source: PORT)"], "red tide": ["Sea water which is covered or discoloured by the sudden growth of algal bloom or by a great increase in single-celled organisms, dinoflagellates."], "chemical reduction": ["Chemical reaction in which an element gains an electron."], "reed": ["Any of various types of tall stiff grass-like plants growing together in groups near water."], "reef": ["A line of rocks in the tidal zone of a coast, submerged at high water but partly uncovered at low water."], "refinery": ["A factory for the purification of some crude material such as ore, sugar, oil, etc.\\n(Source: CED)"], "refining": ["The processing of raw material to remove impurities. \\n\\n(Source: PHC)"], "reflection": ["The return of waves or particles from surfaces on which they are incident."], "reflectometry": ["The study of the reflectance of light or other radiant energy."], "refrigerant": ["A substance that by undergoing a change in phase (liquid to gas, gas to liquid) releases or absorbs a large latent heat in relation to its volume, and thus effects a considerable cooling effect.", "Causing cold or cooling."], "refrigeration": ["The cooling of substances, usually food, below the environmental temperature for preservative purposes."], "refrigerator": ["A household appliance used for keeping food fresh by refrigeration."], "refuge": ["A restricted and isolated area in which plants and animals persisted during a period of continental climatic change that made surrounding areas uninhabitable; especially an ice-free or unglaciated area within or close to a continental ice sheet or upland ice cap, where hardy biotas eked out an existence during a glacial phase. It later served as a center of dispersal for the repopulation of surrounding areas after climatic readjustment.", "A shelter from danger or hardship.", "A place of safety, refuge or protection.", "A shielding or protection against the unpleasant, unwanted, or dangerous."], "refugee": ["A person who is outside his country of origin and who, due to well-founded fear of persecution, is unable or unwilling to avail himself of that country protection."], "refuse-sludge compost": ["Compost derived by the biodegradation of the organic constituents of solid wastes and wastewater sludges."], "regeneration": ["The renewing or reuse of materials such as activated carbon, single ion exchange resins, and filter beds by appropriate means to remove organics, metals, solids, etc.\\n(Source: LEE)"], "region": ["A designated area or an administrative division of a city, county or larger geographical territory that is formulated according to some biological, political, economic or demographic criteria.", "A place in or a part of the body in any way indicated.", "Any considerable and connected part of a space or surface.", "A large area or range of something specified but with undefined boundaries.", "A tract of land of undefined size."], "registration": ["An instance of or a certificate attesting to the fact of entering in an official list various pieces of information in order to facilitate regulation or authorization, including one's name, contact information and, in some instances, data concerning a specific possession or property.", "The act of registering or state of being registered."], "renewable raw material": ["Resources that have a natural rate of availability and yield a continual flow of services which may be consumed in any time period without endangering future consumption possibilities as long as current use does not exceed net renewal during the period under consideration."], "ordinance": ["A rule established by authority; a permanent rule of action."], "rehabilitation": ["A conservation measure involving the correction of past abuses that have impaired the productivity of the resources base.\\n(Source: MGH)"], "rehousing": ["The provision with new or different housing."], "religion": ["The expression of man's belief in and reverence for a superhuman power recognized as the creator and governor of the universe.", "An institution to express belief in a divine power."], "remote sensing": ["The scientific detection, recognition, inventory and analysis of land and water area by the use of distant sensors or recording devices such as photography, thermal scanners, radar, etc.", "Complex of techniques for the remote measure of electromagnetic energy emitted by objects."], "removal": ["The elimination of substances from a medium or from the environment.\\n(Source: RRDA)", "The act of removing a part from a whole."], "renaturation": ["A process of returning natural ecosystems or habitats to their original structure and species composition."], "renewable resource": ["A resource capable of being continuously renewed or replaced through such processes as organic reproduction and cultivation such as those practiced in agriculture, animal husbandry, forestry and fisheries."], "replacement": ["Substitution of an atom or atomic group with a different one.", "The act of replacing or substituting.", "Someone appointed as the substitute of another, and empowered to act for him, in his name or on his behalf."], "representation": ["Any conduct or action undertaken on behalf of a person, group, business or government, often as an elected or appointed voice."], "reprocessing": ["Restoration of contaminated nuclear fuel to a usable condition."], "reptile": ["A class of terrestrial vertebrates, characterized by the lack of hair, feathers, and mammary glands; the skin is covered with scales, they have a three chambered heart and the pleural and peritoneal cavities are continuous.", "Any cold-blooded vertebrate of the class Reptilia."], "rescue service": ["Service organized to provide immediate assistance to persons injured or in distress.\\n(Source: RRDA)"], "research": ["Scientific investigation aimed at discovering and applying new facts, techniques and natural laws.", "A detailed critical inspection."], "research project": ["Proposal, plan or design containing the necessary information and data for conducting a specific survey."], "reservoir": ["An artificial or natural storage place for water, such as a lake or pond, from which the water may be withdrawn as for irrigation, municipal water supply, or flood control."], "residential area": ["Area that has only private houses, not offices and factories."], "residential building": ["A building allocated for residence."], "residual risk": ["Remaining potential for harm to persons, property or the environment following all possible efforts to reduce predictable hazards.\\n(Source: TOE)"], "resin": ["Any of a class of solid or semisolid organic products of natural or synthetic origin with no definite melting point, generally of high molecular weight."], "resorption": ["Absorption or, less commonly, adsorption of material by a body or system from which the material was previously released."], "resource": ["Any component of the environment that can be utilized by an organism.", "Something that one uses."], "respiration": ["The process in living organisms of taking in oxygen from the surroundings and giving out carbon dioxide."], "respiratory air": ["Air volumes inspired and expired through the lungs."], "respiratory disease": ["A disease of the airways."], "respiratory protection apparatus": ["Any of a group of devices that protect the respiratory system from exposure to airborne contaminants; usually a mask with a fitting to cover the nose and mouth.\\n(Source: KOREN)"], "respiratory tract": ["The structures and passages involved with intake, expulsion, and exchange of oxygen and carbon dioxide in the vertebrate body."], "responsibility": ["The obligation to answer for an act done, and to repair or otherwise make restitution for any injury it may have caused."], "resting form": ["Resistant structure that allows the organism to survive adverse environmental conditions.\\n(Source: ALL2)"], "restoration": ["The process of renewing or returning something to its original, normal or unimpaired condition."], "retail trade": ["The sale of goods, in small numbers and directly to the consumer."], "retarding basin": ["A basin designed and operated to provide temporary storage and thus reduce the peak flood flows of a stream."], "reusable container": ["Any container which has been conceived and designed to accomplish within its life cycle a minimum number of trips or rotations in order to be refilled or reused for the same purpose for which it was conceived.\\n(Source: PORT)"], "revegetation": ["Planting of new trees and, particularly, of native plants in disturbed sites where the vegetation cover has been destroyed, to stabilize the land surface from wind and water erosion and to reclame the land for other uses."], "reverse osmosis": ["A technique whereby a solution is forced through a semipermeable membrane under pressure, used to generate drinkable water from sea water, or to separate chemical compounds."], "rice": ["An erect grass, Oryza sativa, that grows in East Asia on wet ground and has drooping flower spikes and yellow oblong edible grains that become white when polished.", "Seeds of the rice plant (Oryza sativa) used as food.", "Boiled rice."], "petition right": ["A legal guarantee or just claim enabling a citizen or employee to compose and submit a formal written request to an authority asking for some benefit or favor or for intervention and redress of some wrong."], "right to information": ["The individual's right to know in general about the existence of data banks, the right to be informed on request and the general right to a print-out of the information registered and to know the actual use made of the information."], "risk": ["The expected number of lives lost, persons injured, damage to property and disruption of economic activity due to a particular natural phenomenon, and consequently the product of the probability of occurrence and the expected magnitude of damage.\\n(Source: GUNN /  RRDA)", "A qualitative assessment describing the likelihood of an attacker/threat using an exploit to successfully bypass a defender, attack a vulnerability, and compromise a system. (Schneider)"], "risk analysis": ["A technique used to determine the likelihood or chance of hazardous events occurring (such as release of a certain quantity of a toxic gas) and the likely consequences."], "risk assessment": ["The qualitative and quantitative evaluation performed in an effort to define the risk posed to human health and/or the environment by an action or by the presence or use of a specific substance or pollutant."], "risk-benefit analysis": ["A systematic process of evaluating and assessing the hazards of loss versus the possibility of financial gain or profit."], "risk communication": ["The exchange of information about health or environmental risks among risk assessors and managers, the general public, news media, interest groups, etc."], "risk perception": ["A subjective appreciation by individuals which will more often than not bear little relation to the statistical probability of damage or injury."], "risk reduction": ["Any act, instance or process lowering the probability that harm will come to an area or its population as the result of some hazard."], "river": ["A stream of water which flows in a channel from high ground to low ground and ultimately to a lake or the sea, except in a desert area where it may dwindle away to nothing."], "river water": ["Water which flows in a channel from high ground to low ground and ultimately to a lake or the sea, except in a desert area where it may dwindle away to nothing.\\n(Source: WHIT)"], "road": ["A long piece of hard ground that people can drive along from one place to another."], "road safety": ["Any measure, technique or design intended to reduce the risk of harm posed by moving vehicles along a constructed land route.\\n(Source: RHW)"], "road salt": ["Salt used against the formation of ice on roads."], "road traffic": ["Circulation of motor vehicles and people on the road network."], "road traffic engineering": ["Discipline which includes the design of highways and pedestrian ways, the study and application of traffic statistics, and the environmental aspects of the transportation of goods and people.\\n(Source: CED)"], "rock": ["Any aggregate of minerals that makes up part of the earth's crust. It may be unconsolidated, such as sand, clay, or mud, or consolidated, such as granite, limestone, or coal.", "To move gently back and forth.", "A music style characterized by basic drum-beat, generally 4/4 riffs, based on (usually electric) guitar, bass guitar, drums, and vocals."], "rock wool": ["A generic term for felted or matted fibers manufactured by blowing or spinning threads of molten rock, slag, or glass.\\n(Source: BJGEO)"], "rodent": ["Any of the relatively small placental mammals that constitute the order Rodentia, having constantly growing incisor teeth specialized for gnawing."], "root": ["The absorbing and anchoring organ of a vascular plant; it bears neither leaves nor flowers and is usually subterranean.", "A word from which another word or words are derived.", "Origin, beginning of an event, a condition or a period"], "rotary furnace": ["A heat-treating furnace of circular construction which rotates the workpiece around the axis of the furnace during heat treatment; workpieces are transported through the furnace along a circular path."], "rubber": ["A cream to dark brown elastic material obtained by coagulating and drying the latex from certain plants, especially the rubber tree.", "A contraceptive device consisting of a thin rubber or latex sheath worn over the penis during intercourse.", "An elastic hydrocarbon polymer that naturally occurs as a milky colloidal suspension, or latex, in the sap of some plants."], "rubber processing": ["The systematic series of actions in which a solid substance deriving from rubber trees and plants is toughened and treated chemically to give it the strength, elasticity, resistance and other qualities needed for the manufacture of products such as erasers, elastic bands, water hoses, electrical insulation and tires.\\n(Source: RHW)"], "rubber processing industry": ["A sector of the economy in which an aggregate of commercial enterprises is engaged in the manufacture and marketing of natural or synthetic rubber products.\\n(Source: RHW)"], "rubber waste": ["Any refuse or unwanted material made of synthetic or natural rubber, often the byproduct of rubber processing.\\n(Source: RHW)"], "runoff": ["Rate at which water is removed by flowing over the soil surface. This rate is determined by the texture of the soil, slope, climate, and land use cover (e.g. paved surface, grass, forest, bare soil).\\n(Source: LANDY)"], "rural population": ["The total number of persons inhabiting an agricultural or pastoral region.\\n(Source: RHW)"], "agritourism": ["A form of tourism in which holidays are organized in a farm: meals are prepared with natural products and guests are entertained with handicraft, sporting and agricultural activities."], "safety": ["The state of being secure from harm, injury, danger or risk.", "A contraceptive device consisting of a thin rubber or latex sheath worn over the penis during intercourse."], "safety measure": ["An action, procedure or contrivance designed to lower the occurrence or risk of injury, loss and danger to persons, property or the environment.\\n(Source: OED / RHW)"], "safety rule": ["A principle or regulation governing actions, procedures or devices intended to lower the occurrence or risk of injury, loss and danger to persons, property or the environment.\\n(Source: OED / RHW)"], "safety standard": ["A norm or measure applicable in legal cases for any action, procedure or contrivance designed to lower the occurrence or risk of injury, loss and danger to persons, property or the environment."], "safety study": ["Research, detailed examination and usually a written report on the need for or efficacy of actions, procedures or devices intended to lower the occurrence or risk of injury, loss and danger to persons, property or the environment."], "salamander": ["Any amphibian of the order Urodela (or Caudata). The adults keep their tails by opposition to the frogs and the caecilians.", "Name given to most of the species of amphibians of the order Urodela."], "salination": ["The accumulation of soluble salts by evaporation of the waters that bore them to the soil zone, in a soil of an arid, poorly drained region."], "salmonella": ["General name for a family of microorganisms, one of the largest groups of bacteria, that includes those most frequently implicated in food poisoning and gastroenteritis. Unhygienic handling and inadequate cooking of poultry and meat, improper storage of cold meats and, more recently, contamination of battery-reared hen eggs, are the most common sources of salmonella infections.\\n(Source: WRIGHT)"], "salt content": ["Amount of salt contained in a solution."], "salt marsh": ["Area of brackish, shallow water usually found in coastal areas and in deltas."], "salt meadow": ["A meadow subject to overflow by salt water."], "salt plug": ["The core of a salt dome."], "salt": ["The reaction product when a metal displaces the hydrogen of an acid.", "A condiment (NaCl - Sodium Chloride) used to add to or enhance the flavour of food (commonly with pepper).", "Containing salt.", "To season with salt.", "To preserve with salt.", "To spread salt.", "Randomly generated data added to an encryption algorithm to increase its effectiveness."], "salt water": ["Water that contains dissolved salts."], "salvage": ["The act, process, or business of rescuing vessels or their cargoes from loss at sea."], "sampling": ["The obtaining of small representative quantities of material for the purpose of analysis."], "sampling technique": ["Method of selecting items at random from a set in such a manner that the sample will be representative of the whole."], "sanction": ["A measure, including removal of diplomatic ties, ban on trade, or military intervention, adopted by a country, or group of countries, against another country for political reasons.", "The approval, by some authority, that makes something valid."], "sand": ["A loose material consisting of small mineral particles, or rock and mineral particles, distinguishable by the naked eye; grains vary from almost spherical to angular, with a diameter range from 1/16 to 2 millimeters.", "To cover with sand.", "To rub with sandpaper."], "sand dune fixation": ["Stabilization of dunes effected by the planting of marram grass (Ammophila arenaria), or rice grass, whose long roots bind the surface layers of sand and so hinder its removal by wind. A larger scale method of dealing with the same problem is by afforestation.\\n(Source: BLYFRE)"], "sand dune": ["An accumulation of loose sand heaped up by the wind."], "sand extraction": ["The extraction of sand by mining for building purposes and for the extraction of heavy minerals such as rutile and zircon."], "sand pit": ["A place where sand is extracted from the ground."], "sanitation": ["The study and use of practical measures for the preservation of public health."], "sanitation plan": ["Plans for the control of the physical factors in the human environment that can harm development, health, or survival."], "saprobic index": ["Indication or measure of the level of organic pollution."], "saprobe": ["Referring to the classification of organisms according to the way in which they tolerate pollution."], "satellite": ["An object that orbits around a larger one."], "saving": ["The amount of current income which is not spent for survival or enjoyment."], "sawdust": ["Small wood fragments produced by a saw when cutting."], "schistosomiasis": ["A disease in which humans are parasitized by any of three species of blood flukes: Schistosoma mansoni, S. haematobium, and S. japonicum; adult worms inhabit the blood vessels."], "school": ["An institution or building at which children and young people receive education.", "Group of a large number of fish (or other sea animals, such as dolphins or whales), normally from the same species, that swim together."], "school teaching": ["Instruction or training received in any educational institution, but especially to persons under college age.\\n(Source: RHW)"], "science": ["The study of the physical universe and its contents by means of reproducible observations, measurements, and experiments to establish, verify, or modify general laws to explain its nature and behaviour."], "scrap material": ["Recyclable material from any manufacturing process or discarded consumer products."], "scrap material price": ["The amount of money or the monetary rate at which materials discarded from manufacturing operations can be bought or sold.\\n(Source: TOE / RHW)"], "scrap metal": ["Any metal material discarded from manufacturing operations and usually suitable for reprocessing."], "scrap vehicle": ["Car which is no longer functional and may be dismantled for spare parts or completely demolished."], "screening": ["The reduction of the electric field about a nucleus by the space charge of the surrounding electrons."], "sea": ["The mass of water occupying all of the Earth's surface not occupied by land, but excluding all lakes and inland seas.", "In general, the marine section of the globe as opposed to that of the land.", "A body of salt water that is smaller than an ocean and generally in proximity to a continent.", "Different parts of the ocean.", "The use of the sea (as in, naval operations, the shipping trade, the profession of a sailor, etc.)", "The darker parts of the moon's surface.", "A large lake.", "The volume of water in the sea in relation to the tides.", "Condition of the sea with regards to \u0131ts use (like sailing or swimming).", "At sea, the direction of the waves.", "A large, heavy wave in the sea.", "Wind driven waves.", "A large number (of something)", "A large horizontal surface.", "A great quantity (of a liquid).", "A space filled with particles of a certain kind.", "A large quantity (of something)."], "sea bed": ["The bottom of the ocean."], "sea circulation": ["Large-scale horizontal water motion within an ocean."], "sea level": ["The level of the surface of the ocean; especially, the mean level halfway between high and low tide, used as a standard in reckoning land elevation or sea depths."], "seashore": ["The zone of unconsolidated material that extends landward from the low water-line to where there is marked change in material or physiographic form or to the line of permanent vegetation."], "season": ["One of the six equal periods into which the Hindu year is divided.", "One of the four equal periods into which the year is divided by the equinoxes and solstices, resulting from the apparent movement of the sun north and south of the equator during the course of the earth's orbit around it. These periods (spring, summer, autumn and winter) have their characteristic weather conditions in different regions, and occur at opposite times of the year in the N and S hemispheres.", "A yearly recurring period of undetermined length, relatively long but still shorter than a year, when a certain crop is ripe or a certain type of work, most commonly related to agriculture, is being performed.", "A predetermined series of cultural events; for example theatrical performances or  sports events, that take place under an extended period of time, which however is shorter than a year.", "To add spices."], "seasonal migration": ["The periodic movement of a population from one region or climate to another in accordance with the yearly cycle of weather and temperature changes."], "sea water": ["Water found in the seas or oceans which has an average salinity of about 3.5%."], "sea water desalination": ["Removal salt from ocean or brackish water."], "secondary biotope": ["In the case of disruption of an existing biotope, secondary biotope can be created as a compensation and substitute measure for the loss of the natural one.\\n(Source: RRDA)"], "secondary education": ["The years of instruction following elementary school and until the end of high school.\\n(Source: COE)"], "secondary sector": ["The part of a country or region's economy that produces commodities without much direct use of natural resources."], "second-hand goods": ["Goods or products that have been used previously."], "economic sector": ["A part of a country's or region's commercial, industrial and financial activity, delimited either by public, corporate and private organization of expenditures or by agriculture, manufacturing and service product types."], "sedimentary basin": ["A geomorphic feature of the earth in which the surface has subsided for a prolonged time, including deep ocean floors, intercontinental rifts and elevated and interior drainage basins."], "sediment": ["Any material transported by water which will ultimately settle to the bottom after the water loses its transporting power.\\n(Source: LANDY)", "Matter deposited by some natural process."], "seed dressing": ["A chemical applied before planting to protect seeds and seedlings from disease or insects."], "water seepage": ["The slow movement of water through small openings and spaces in the surface of unsaturated soil into or out of a body of surface or subsurface water.\\n(Source: MGH)"], "seismic activity": ["The phenomenon of Earth movements."], "seismic monitoring": ["The gathering of seismic data from an area."], "seizure": ["The official or legally authorized act of taking away possessions or property, often for a violation of law or to enforce a judgment imposed by a court of law."], "selenium": ["A highly toxic, nonmetallic element with symbol Se and atomic number 34; used in analytical chemistry, metallurgy, and photoelectric cells."], "self-purification": ["A natural process of organic degradation that produces nutrients utilized by autotrophic organisms.\\n(Source: LBC)"], "semiconductor": ["A solid crystalline material whose electrical conductivity is intermediate between that of a metal and an insulator and is usually strongly temperature-dependent."], "semimanufactured product": ["Product that has undergone a partial processing and is used as raw material in a successive productive step.\\n(Source: ZINZAN)"], "semi-metal": ["An element having some properties characteristic of metals and others of non-metals."], "sensitivity analysis": ["A formalized procedure to identify the impact of changes in various model components on model output. Sensitivity analysis is an integral part of simulation experimentation and may influence model formulations. It is commonly used to examine model behaviour. The general procedure is to define a model output variable that represents an important aspect of model behaviour. The values of various inputs of the model are then varied and the resultant change in the output variable is monitored. Large changes in the output variable imply that the particular input varied is important in controlling model behaviour. Within this general definition, sensitivity analysis has been applied to a variety of model inputs including state variables, environmental variables and initial conditions.\\n(Source: YOUNG)"], "separator": ["A machine for separating materials of different specific gravity by means of water or air."], "septic tank": ["A tank, usually underground, into which sewage flows, the deposited matter being wholly, or partially broken down through anaerobic action."], "sequestration": ["1) A legal term referring generally to the act of valuable property being taken into custody by an agent of the court and locked away for safekeeping, usually to prevent the property from being disposed of or abused before a dispute over its ownership can be resolved.\\n2) The taking of someone's property, voluntarily (by deposit) or involuntarily (by seizure), by court officers or into the possession of a third party, awaiting the outcome of a trial in which ownership of that property is at issue.\\n(Source: DUC /  EMBMO)", "The act of segregating or sequestering."], "snake": ["Any reptile of the suborder Serpentes, typically having a scaly cylindrical limbless body, fused eyelids, and a jaw modified for swallowing large prey."], "services": ["The business sector that consists of companies whose line of work involves doing something for customers, but that do not produce goods.", "A service station to get food and eat something, often found at motorways."], "settlement concentration": ["The distribution or total amount of communities, villages and houses within a specified geographic area."], "urban sprawl": ["The expansion of urban areas into surrounding rural areas, creating low-density neighbourhoods."], "settling tank": ["A tank into which a two-phase mixture is fed and the entrained solids settle by gravity during storage."], "sewage": ["A liquid composed by waste substances in decomposition that is conveyed in sewers."], "sewage farm": ["Area of land on which sewage or any other type of waste water is distributed in order to purify it."], "sewage sludge": ["A semi-liquid waste with a solid concentration in excess of 2500 parts per million, obtained from the purification of municipal sewage."], "sewerage system": ["System of pipes, usually underground, for carrying waste water and human waste away from houses and other buildings, to a place where they can be safely get rid of."], "shellfish": ["An aquatic invertebrate, such as a mollusc or crustacean, that has a shell."], "shielding device": ["Barrier devised for keeping people away from harmful substances."], "shifting cultivation": ["Agricultural practice using the rotation of fields rather than crops, short cropping periods followed by long fallows and the maintenance of fertility by the regeneration of vegetation.\\n(Source: PHC)"], "ship": ["A vessel propelled by engines or sails for navigating on the water, especially a large vessel that can not be carried aboard another, as distinguished from a boat.", "A boat that by its size, solidity and power is appropriate for long navigations and big marine enterprises."], "shipbuilding": ["The art or business of designing and constructing ships."], "shipping accident": ["An unexpected incident, failure or loss involving a vessel or its contents in the course of commercial transport that poses potential harm to persons, property or the environment.\\n(Source: RHW)"], "ship garbage": ["Domestic and operational wastes, disposed of continuously or periodically, that are generated during the normal operation of a ship; usually excluding fresh fish waste from fishing operations."], "shooting range": ["Area designed for target shooting."], "shop": ["A place, especially a small building, for the retail sale of goods and services.", "To visit shops; to look around shops with the intention of buying something."], "show": ["A performance, program or exhibition providing entertainment to a group of people, displayed either through some communication media, such as radio or television, or live at a museum or theater.", "To give a proof that something is true.", "To have somebody see something.", "To go or travel in the company of someone.", "The pretending that something is the case in order to make a good impression."], "shredder": ["A size-reduction machine which tears or grinds materials to a smaller and more uniform particle size."], "shrub": ["A woody perennial plant, smaller than a tree, with several major branches arising from near the base of the main stem.", "A plant resembling a small tree, but has no, and will never develop, a stem."], "sick building syndrome": ["A set of symptoms, including headaches, fatigue, eye irritation, and dizziness, typically affecting workers in modern airtight office buildings and thought to be caused by indoor pollutants, such as formaldehyde fumes, particulate matter, microorganisms, etc."], "side effect": ["Any secondary effect, especially an undesirable one."], "sieving": ["The size distribution of solid particles on a series of standard sieves of decreasing size, expressed as a weight percent.\\n(Source: MGH)"], "silencer": ["Any device designed to reduce noise, especially the device in the exhaust system of a motor vehicle."], "silicon": ["A brittle metalloid element with symbol Si and atomic number 14 that exists in two allotropic forms; occurs principally in sand, quartz, granite, feldspar, and clay. It is usually a grey crystalline solid but is also found as a brown amorphous powder. It is used in transistors, rectifiers, solar cells, and alloys. Its compounds are widely used in glass manufacture, the building industry, and in the form of silicones."], "silo": ["A large round tower on a farm for storing grain or winter food for cattle."], "silt": ["The fine mineral material formed from the erosion of rock fragments and deposited by rivers and lakes. Its particles are the intermediate form between sand and clay. The particles can range in size from 0.01-0.05 mm in diameter."], "silver": ["A very ductile malleable brilliant greyish-white element with symbol Ar and atomic number 47 having the highest electrical and thermal conductivity of any metal.", "Made of silver.", "The colour of silver. A shiny greyish-white."], "simulation": ["A representation of a problem, situation in mathematical terms, especially using a computer.\\n(Source: CED)", "The attempt by a football player to gain an unfair advantage by falling to the ground and possibly feigning an injury."], "sizing": ["Act of fixing the cross-section of structural components on the basis of statics and material strength."], "skiing": ["The gliding over snow on skis, especially as a sport."], "skin": ["The tissue forming the outer covering of the vertebrate body: it consists of two layers, the outermost of which may be covered with hair, scales, feathers, etc. It is mainly protective and sensory in function.", "Strip or pull off the skin or hide of"], "slag": ["A nonmetallic product resulting from the interaction of flux and impurities in the smelting and refining of metals."], "slaughterhouse": ["A place where animals are butchered for food."], "slaughterhouse waste": ["Animal body parts cut off in the preparation of carcasses for use as food. This waste can come from several sources including slaughterhouses, restaurants, stores and farms.\\n(Source: OED)"], "sleep": ["A periodic state of physiological rest during which consciousness is suspended and metabolic rate is decreased.", "To rest in a state of decreased consciousness and reduced metabolism."], "sleep disturbance": ["Medical disorder of the sleep patterns of a person or animal. (Source: Wikipedia)"], "sludge": ["A semifluid, slushy, murky mass of sediment resulting from treatment of water, sewage, or industrial and mining wastes, and often appearing as local bottom deposits in polluted bodies of water.\\n(Source: BJGEO)", "Soaked clay or soil; very soft ground.", "A soft, soupy, or muddy bottom deposit, such as found on tideland or in a stream bed."], "sluice": ["Vertical sliding gate or valve to regulate the flow of water in a channel or lock."], "smog": ["Air pollution consisting of smoke and fog."], "smog warning": ["Action, device or announcement that serves to give caution or notice to the level of air pollutants typically associated with oxidants in a given area."], "smoke": ["An aerosol, consisting of visible particles and gases, produced by the incomplete burning of carbon-based materials, such as wood and fossil fuels.", "To inhale smoke from for example a cigarette or a cigar.", "A product manufactured out of cured and finely cut leaves, which are rolled or stuffed into a paper-wrapped cylinder for smoking.", "To kill a person or an animal with a shot from a firearm.", "To expose food to the smoke of wood fires in order to preserve it.", "To give off smoke."], "smoking": ["The inhalation and exhalation of carcinogenic fumes from burning plant material, usually tobacco.", "The process of flavoring, cooking, or preserving food by exposing it to the smoke from burning or smoldering plant materials, most often wood."], "colubrid": ["Family of snakes (Colubridae), including many harmless snakes, such as the grass snake."], "snow": ["The most common form of frozen precipitation, usually flakes or starlike crystals, matted ice needles, or combinations, and often rime-coated.", "To fall from the clouds in the form of ice crystals.", "Material composed of small ice crystals.", "A street name for cocaine.", "To confuse completely by concealing one's true motives from, especially by elaborately feigning good intentions so as to gain an end."], "snowslide": ["An avalanche of relatively pure snow; some rock and earth material may also be carried downward."], "soaking": ["Absorption of liquid by a solid or a semisolid material.\\n(Source: MGH)"], "soap": ["A cleansing agent, manufactured in bars, granules, flakes, or liquid form, made from a mixture of the sodium salts of various fatty acids of natural oils and fats.", "A television serial about the lives of melodramatic characters, which are often filled with strong emotions, highly dramatic situations and suspense."], "social condition": ["An existing circumstance, situation or state affecting the life, welfare and relations of human beings in community.\\n(Source: RHW)"], "social development": ["The state of nations and the historical processes of change experienced by them."], "social differentiation": ["A concept associated with evolutionary theories of history and with structural functionalism. Societies are seen as moving from the simple to the complex via a process of social change based on structural differentiation."], "social dynamics": ["The pattern, change, development and driving forces of a human group, community or society."], "social facility": ["Any structure designed, built or installed to provide space for living or interaction among persons in a community.\\n(Source: RHW)"], "social group": ["A collection of people who interact with one another and share a certain feeling of unity.\\n(Source: SOC)"], "social medicine": ["Medicine as applied to treatment of diseases which occur in certain social groups."], "social movement": ["A organized effort by a significant number of people to change (or resist change in) some major aspect or aspects of society."], "social participation": ["Collective, civic action shared and performed by a significant number of the community or general population.\\n(Source: RHW)"], "social policy": ["A course of action adopted and pursued by government, business or some other organization, which seeks to ensure that all people have acceptable working or living conditions by providing social security, welfare, health care, insurance, fair employment practices, low cost housing or educational opportunities."], "social problem": ["A generic term applied to the range of conditions and aberrant behaviours which are considered to be manifestations of social disorganization and to warrant changing via some means of social engineering."], "social relief": ["Public assistance especially financial given to persons in special need or difficulty."], "social security": ["Branch of social legislation which has as its purpose the protection of workers from risks resulting from the impairment or loss of their earning capacity due to predetermined events."], "social structure": ["A term loosely applied to any recurring pattern of social behaviour; or, more specifically, to the ordered interrelationships between the different elements or a social system or society."], "social system": ["The concept of system appears throughout the social and natural sciences and has generated a body of literature of its own (general systems theory). A system is any pattern of relationships between elements, and is regarded as having emergent properties on its own over and above the properties of its elements."], "society": ["Human group of people, more or less large and complex, associated for some common interest and characterized by distinctive hierarchical relationships.", "A formal association of people with similar interests."], "sociology": ["The study of the development, organization, functioning and classification of human societies."], "software": ["The general term used to describe all of the various programs that may be used on a computer system. It can be divided into four main categories: systems software, development software, user interface software, applications software."], "soil": ["The top layer of the land surface of the earth that is composed of disintegrated rock particles, humus, water and air.", "A mixture of sand and organic material, used to support plant growth.", "To make filthy.", "To become filthy."], "soil acidification": ["The buildup of hydrogen cations, also called protons, which reduces the pH of the soil."], "soil air": ["The air and other gases in spaces in the soil; specifically that which is found within the zone of aeration. Also known as soil atmosphere.\\n(Source: MGH)"], "soil biology": ["The study of the living organisms, mainly microorganisms and microinvertebrates which live within the soil, and which are largely responsible for the decomposition processes vital to soil fertility."], "soil chemistry": ["The study of the inorganic and organic components of the soil and its life cycles."], "soil compaction": ["An increase in bulk density (mass per unit volume) and a decrease in soil porosity resulting from applied loads, vibration, or pressure."], "soil condition": ["Description of the character of the surface of the ground at the time of observation, especially in relation to the influence of rain and snow.\\n(Source: ECHO2)"], "soil decontamination": ["Technologies employed in the removal of PCBs, PAH, pesticides and, more generally, of organic compounds by physical, chemical or biological treatments.\\n(Source: EUROPAa)"], "soil erosion": ["Detachment and movement of topsoil or soil material from the upper part of the profile, by the action of wind or running water, especially as a result of changes brought about by human activity, such as unsuitable or mismanaged agriculture."], "soil fertility": ["The status of a soil with respect to the amount and availability to plants of elements necessary for plant growth."], "soil formation": ["The combination of natural processes by which soils are formed."], "soil improvement": ["Process of protecting the soil from excessive erosion and making soil more fertile and productive.\\n(Source: LANDY)"], "soil layer": ["Distinctive successive layers of soil produced by internal redistribution processes. Conventionally the layers have been divided into A, B and C horizons. The A horizon is the upper layer, containing humus and is leached and/or eluviated of many minerals. The B horizon forms a zone of deposition and is enriched with clay minerals and iron/aluminium oxides from the A layer. The C layer is the parent material for the present soil and may be partially weathered rock, transported glacial or alluvial material or an earlier soil.\\n(Source: ALL)"], "soil map": ["A two-dimensional representation that shows the areal extent or the distribution of soils in relation to other features of the land surface."], "soil mechanics": ["The study of the physical properties of soil, especially those properties that affect its ability to bear weight such as water content, density, strength, etc.\\n(Source: CED)"], "soil mineralogy": ["Study of the formation, occurrence, properties, composition, and classification of the minerals present in the soil.\\n(Source: BJGEOa)"], "soil moisture": ["Water stored in soils."], "soil organism": ["Organism which lives in the soil."], "soil pollutant": ["Solid, liquid and gaseous substances that detrimentally alter the natural condition of the soil."], "soil profile": ["A vertical section of a soil, showing horizons and parent material."], "soil quality": ["All current positive or negative properties with regard to soil utilization and soil functions."], "soil salination": ["The accumulation of soluble mineral salts near the surface of soil, usually caused by the capillary flow of water from saline ground water."], "soil science": ["The study of the properties, occurrence, and management of soil as a natural resource."], "soil subsidence": ["A sinking down of a part of the earth's crust, generally due to underground excavations."], "soil surface sealing": ["Any activity or process in which ground surface areas are packed or plugged to prevent percolation or the passage of fluids."], "soil type": ["A phase or subdivision of a soil series based primarily on texture of the surface soil to a depth at least equal to plow depth (about 15 cm).\\n(Source: BJGEO)"], "soil use": ["Functional utilization of soil for agriculture, industry, or residential building purposes.\\n(Source: GREMES)"], "soil water": ["Water stored in soils.\\n(Source: LANDY)"], "solar cell": ["A device for converting sunlight into electrical power using a semiconductor sensitive to the photovoltaic effect.", "A device that absorbs radiant energy and converts it into electrical energy."], "solar collector": ["Device which converts the energy from light into electricity."], "solar energy": ["The energy transmitted from the sun in the form of electromagnetic radiation. The most successful examples of energy extraction from the sun are so far solar cells used in satellites and solar collectors used to heat water.\\n(Source: MGH /  ALL)"], "solar heating": ["A domestic or industrial heating system that makes direct use of solar energy."], "solar power station": ["Plant where energy is generated using radiation from the sun."], "solar radiation": ["The electromagnetic radiation and particles emitted by the sun."], "solid matter": ["A crystalline material, that is, one in which the constituent atoms are arranged in a three-dimensional lattice, periodic in three independent directions."], "solid state": ["The physical state of matter in which the constituent molecules, atoms, or ions have no translatory motion although they vibrate about the fixed positions that they occupy in a crystal lattice."], "solubility": ["The ability of a substance to form a solution with another substance.\\n(Source: MGH)"], "solvent": ["Substance, generally a liquid, capable of dissolving another substance.", "The conclusion or end to which any course or condition of things leads."], "songbird": ["Any passerine bird of the suborder Oscines, having highly developed vocal organs and, in most, a music call.\\n(Source: CED)"], "sonic boom": ["A noise caused by a shock wave that emanates from an aircraft or other object traveling at or above sonic velocity."], "soot": ["Impure black carbon with oily compounds obtained from the incomplete combustion of resinous materials, oils, wood, or coal."], "sorption": ["The taking up, usually, of a liquid or gas into the body of another material (the absorbent)."], "sound": ["Auditory sensation produced by the oscillations, stress, pressure, particle displacement, and particle velocity in a medium with internal forces; pressure variation that the human ear can detect.\\n(Source: KOREN)", "To produce a sound."], "sound emission": ["Diffusion into the environment of a sound emitted from a given source."], "sound immission": ["The introduction in the environment of noise deriving from various sources that can be grouped in: transportation activities, industrial activities and daily normal activities.\\n(Source: DIFIDa)"], "sound level": ["The sound pressure level (in decibels) at a point in a sound field, averaged over the audible frequency range and over a time interval.\\n(Source: MGH)"], "soundproofing": ["Reducing or eliminating reverberation in a room by placing sound-absorbing materials on the walls and ceiling.\\n(Source: MGH)"], "sound propagation": ["The travelling of acoustic waves in the atmosphere with a speed independent of their amplitude. The speed only depends on the acoustic medium and is proportional to the square root of the absolute temperature for any given medium.\\n(Source: RRDA /  PARCOR)"], "sound transmission": ["Passage of a sound wave through a medium or series of media."], "South America": ["A continent in the southern part of the western hemisphere, astride the equator and the Tropic of Capricorn, bordered by the Caribbean Sea to the north and between the Atlantic and Pacific Oceans, connected to North America by the Isthmus of Panama, and divided into twelve countries:  Argentina, Bolivia, Brazil, Chile, Columbia, Ecuador, Guyana, Paraguay, Peru, Suriname, Uruguay and Venezuela."], "South Atlantic Ocean": ["An ocean south of the equator between the eastern coast of South America and the western coast of Africa that extends southward to the Antarctic continent, including the Drake Passage, South Sandwich Islands and Falkand Islands."], "Southeast Asia": ["A geographic region of continental Asia, south of China, west of the South Pacific Ocean, north of the Indian Ocean, and east of the Bay of Bengal and the Indian subcontinent, including the Indochina Peninsula, the Malay Peninsula and the Indonesian and Philippine Archipelagos, and countries such as Brunei, Cambodia, Indonesia, Laos, Malaysia, Myanmar, the Philippines, Singapore, Thailand and Vietnam."], "Southern Africa": ["A geographic region of the African continent astride the Tropic of Capricorn, including Angola, Botswana, Lesotho, Malawi, Mozambique, Namibia, South Africa, Swaziland, Zambia and Zimbabwe, and also the Kalahari Desert, Zambezi River and Orange River.\\n(Source: AFR)", "ISO 639-6 entity"], "Southern Asia": ["A geographic region of the Asian continent bordered in the north by the countries of Central Asia and in the south by the Arabian Sea and the Bay of Bengal, extending  westward into Iran and eastward into China, including Afghanistan, Pakistan, India, Nepal, Bangladesh, Burma, Bhutan and Sri Lanka."], "South Pacific Ocean": ["An ocean south of the equator between Southeast Asia and Australia in the Eastern hemisphere and South America in the Western hemisphere, extending southward to the Antarctic region, including the Tasman and Coral seas and numerous islands, such as Galapagos, Solomon, Easter, Samoa, Fiji and Tonga islands, and also New Zealand and its islands."], "space travel": ["Travel in the space beyond the earth's atmosphere performed for scientific research purposes."], "space waste": ["Nonfunctional debris of human origin left in a multitude of orbits about the earth as the result of the exploration and use of the environment lying outside the earth's atmosphere."], "spasmodic croup": ["A respiratory condition that is usually triggered by an acute viral infection of the upper airway."], "special law": ["One relating to particular persons or things; one made for individual cases or for particular places or districts; one operating upon a selected class, rather than upon the public generally. A law is special when it is different from others of the same general kind or designed for a particular purpose, or limited in range or confined to a prescribed field of action or operation."], "special waste": ["Waste which must be handled in a particular manner and for which particular rules apply."], "species": ["A taxonomic category ranking immediately below a genus and including closely related, morphologically similar individuals which actually or potentially inbreed."], "conservation of species": ["Controlled utilization, protection or development of selected classes of plants or animals for their richness, biodiversity and benefits to humanity.\\n(Source: TOE / EEN)"], "spectroscopy": ["The branch of physics concerned with the production, measurement, and interpretation of electromagnetic spectra arising from either emission or absorption of radiant energy by various substances."], "speed": ["A scalar measure of the rate of movement of a body expressed either as the distance travelled divided by the time taken (average speed) or the rate of change of position with respect to time at a particular point (instantaneous speed). It is measured in metres per second, miles per hour, etc.", "To move faster.", "An addictive psychoactive drug of formula C\u2081\u2080H\u2081\u2085N.", "To cause to move faster.", "To move fast."], "speed limit": ["The maximum permitted speed at which a vehicle may travel on certain roads."], "spider": ["Any predatory silk-producing arachnid of the order Araneae, having four pairs of legs and a rounded unsegmented body consisting of abdomen and cephalothorax.", "A type of skimmer in the form of a wire mesh basket attached to a handle, used to remove food from a hot liquid or skim off foam from a broth."], "spillage": ["The uncontrolled discharge, leakage, dripping or running over of fluids or liquid substances.", "Fluid or liquid substance that was discharged, leaked, dripped or running over without control."], "spoil dump": ["Place where rubbish and waste minerals dug out of a mine are deposited."], "poriferan": ["A phylum of the animal kingdom characterized by the presence of canal systems and chambers through which water is drawn in and released; tissues and organs are absent."], "sport": ["The complex of individual or group activities pursued for exercise or pleasure, often taking a competitive form.", "A person who engages in sports."], "sports facility": ["Buildings, constructions, installations, organized areas and equipment for indoor and outdoor sport activities.\\n(Source: RRDA)"], "spray can": ["An aerosol can for applying paint, deodorant, etc., as a fine spray."], "sprayed asbestos": ["Asbestos emitted into the atmosphere in a spraying operation."], "spring water": ["Water obtained from an underground formation from which water flows naturally to the surface, or would flow naturally to the surface if it were not collected underground."], "square": ["Delimited area on a game board, a form or in a table", "An open area in a town, sometimes including the surrounding buildings.", "A two dimensional polygon with four equal sides and four right angles.", "Mathematics: to multiply a value, term, or expression by itself.", "Having the shape of a square (the polygone)."], "squatter settlement": ["Settlement on the outskirts of a city, often built without authorization, where poor people live in improvised dwellings made from carton, wood or corrugated metal."], "stable": ["A building or structure usually with stalls that is used to house and feed horses, cattle or other animals.", "In a state that is not likely to change."], "stack": ["A great number or large amount of things not placed in a pile.", "A pile of similar objects, each directly on top of the last.", "A linear data structure in which the last datum stored is the first retrieved.", "To place one or more objects or material in the form of a stack or on an existing stack.", "To put together several things in one pile; to arrange in stacks."], "standard": ["Something considered by an authority or by general consent as a basis of comparison.", "A rule or principle that is used as a basis for judgement.", "An object regarded as the most common size or form of its kind.", "An average or normal quality, quantity, or level."], "staple food": ["The most commonly or regularly eaten food in a country or community and which forms the mainstay of the total calorie supply, especially in the poorer populations and at times of food shortage."], "starch": ["A polysaccharide which is a combination of many monosaccharide molecules, made during photosynthesis and stored as starch grains in many plants.", "To treat with laundry starch in order to stiffen."], "state": ["A people permanently occupying a fixed territory bound together by common law, habits and custom into one body politic exercising, through the medium of an organized government, independent sovereignty and control over all persons and things within its boundaries, unless or until authority is ceded to a federation or union of other states.", "A political entity asserting ultimate authority over a geographical area.", "The condition in which someone or something is in.", "To declare to be a fact.", "A political division of a federation retaining a degree of autonomy.", "In computing, the stable condition of a processor during a particular clock cycle.", "In computing, the set of all parameters relevant to a computation.", "In computing, the values of all parameters at some point in a computation.", "To put before."], "state of the art": ["Everything made available to the public by means of a written or oral description, by use or in any other way before the date of the patent application, or an application filed in a foreign country the priority of which is validly claimed."], "state of matter": ["One of the three fundamental conditions of matter: the solid, the liquid, and gaseous states."], "station": ["A place along a route or line at which a bus, train, etc. stops for fuel or to pick up or let off passengers or goods, especially with ancillary buildings and services.", "A place used for broadcasting radio or television."], "statistical analysis": ["The body of techniques used in statistical inference concerning a population."], "statistics": ["A branch of mathematics dealing with the collection, analysis, interpretation, and presentation of masses of numerical data."], "status of development": ["The extent to which a society promotes human well-being in all dimensions of existence by forming people's capabilities, expanding choices and increasing opportunities.\\n(Source: POP)"], "steam generator": ["A pressurized system in which water is vaporized to steam by heat transferred from a source of higher temperature, usually the products of combustion from burning fuels."], "steel": ["Any of various alloys based on iron containing carbon (usually 0.1-0.7 per cent) and often small quantities of other elements such as phosphorus, sulphur, manganese, chromium, and nickel. Steels exhibit a variety of properties, such as strength, machinability, malleability, etc., depending on their composition and the way they have been treated."], "steel industry": ["Industry that deals with the processing of iron."], "steroid": ["A compound composed of a series of four carbon rings joined together to form a structural unit called cyclopentanoperhydrophenanthrene."], "stock management": ["The handling or controlling of accumulated materials or stored goods."], "stocktaking": ["The counting over of materials or goods on hand, as in a stockroom or store."], "stone": ["A lump or mass of hard consolidated mineral matter that is used in construction, either crushed for use as aggregate or cut into shaped blocks as dimension stone.", "A small (and usually irregular) piece of mineral, approximately 20-200 mm in diameter.", "The wooden shell found inside some fruits, particularly drupes, that surrounds the seed.", "To kill or excecute (a person) by throwing rocks or boulders at and on them.", "An Imperial unit of weight and mass, equal to 6.35029318 kilograms.", "Made out of stone."], "storm": ["An atmospheric disturbance involving perturbations of the prevailing pressure and wind fields on scales ranging from tornadoes to extratropical cyclones; also the associated weather and the like.\\n(Source: MGH)", "To act or speak violently, as if in state of a great anger."], "storm damage": ["Damage caused by a storm, for example damaged houses, streets and power lines, uprooted trees, destroyed crops."], "stove": ["A chamber within which a fuel-air mixture is burned to provide heat, the heat itself being radiated outward from the chamber; used for space heating, process-fluid heating, and steel blast furnaces.", "A kitchen appliance used for cooking food."], "stratification": ["The arrangement of a body of water, as a lake, into two or more horizontal layers of different characteristics, especially densities.\\n(Source: MGH)"], "stratosphere": ["The layer of the atmosphere which is sandwiched between the troposphere and mesosphere."], "stratospheric ozone depletion": ["Damage of the ozone shield by chemicals released on Earth."], "stream measurement": ["The quantitative determination of the rate and amount of flow or discharge from a natural body of running water, such as a small river or brook."], "street cleaning": ["The process of removing dirt, litter or other unsightly materials from city or town streets."], "strength of materials": ["The material's ability to resist an applied force."], "stress": ["A stimulus or succession of stimuli of such magnitude as to tend to disrupt the homeostasis of the organism.", "Emphasis on a word or phrase by pronouncing it by increasing the volume or changing the tone.", "To stress, single out as important.", "Difficulty that causes worry or emotional tension.", "To test the limits of.", "To put stress on; to utter with an accent."], "strip mining": ["Superficial mining, in which the valuable rock is exposed by removal of overburden."], "strontium": ["A soft silvery-white element of the alkaline earth group of metals, occurring chiefly as celestite and as strontianite."], "structure-activity relationship": ["The association between a chemical structure and carcinogenicity."], "structure-borne noise": ["Sound that travels over at least part of its path by means of the vibration of a solid structure."], "submarine morphology": ["That aspect of geological oceanography which deals with the relief features of the ocean floor and with the forces that modify them."], "submarine": ["A boat that can go underwater.", "Located under the surface of the sea."], "subsidence": ["A sinking down of a part of the earth's crust, generally due to underground excavations.", "The sudden sinking or gradual downward settling of the Earth's surface with little or no horizontal motion. The movement is not restricted in rate, magnitude, or area involved. Subsidence may be caused by natural geologic processes, such as solution, thawing, compaction, slow crustal warping, or withdrawal of fluid lava from beneath a solid crust; or by man's activity, such as subsurface mining or the pumping of oil or ground water."], "subsidy": ["Any monetary grant made by the government to a private industrial undertaking or charitable organization, but especially one given to consumers or producers in order to lower the market price of some service or product and make it readily affordable to the public."], "subsoil": ["Soil underlying surface soil, devoid of plant roots."], "suburb": ["A residential district situated on the outskirts of a city or town."], "sulphur dioxide": ["A poisonous gas with the formula SO2 that is released by volcanoes and the burning of coal and petroleum."], "sulphuric acid": ["A highly corrosive acid made from sulfur dioxide; widely used in the chemical industry."], "surface-active agent": ["A substance that, when used in small quantities, modifies the surface properties of liquids or solids."], "surface runoff": ["The water flow that occurs when the soil is infiltrated to full capacity and excess water from rain, meltwater, or other sources flows over the land."], "surface tension": ["The force acting on the surface of a liquid, tending to minimize the area of the surface; quantitatively, the force that appears to act across a line of unit length on the surface. Also known as interfacial force; interfacial tension; surface intensity.\\n(Source: MGH)"], "surface treatment": ["Any method of treating a material (metal, polymer, or wood) so as to alter the surface, rendering it receptive to inks, paints, lacquers, adhesives, and various other treatments, or resistant to weather or chemical attack."], "surface water": ["All waters on the surface of the Earth found in streams, rivers, ponds, lakes, marshes or wetlands, and as ice and snow."], "surgical waste": ["Any tissue, blood or mucus removed during surgery or autopsy, soiled surgical dressings, or other materials requiring special disposal procedures."], "surplus": ["The extent to which assets exceed liabilities, especially the profits remaining after operating expenses, taxes, interest and insurance costs are subtracted.\\n(Source: IVW)", "More than is needed, desired, or required."], "survey": ["A critical examination of facts or conditions to provide information on a situation. Usually conducted by interviews and/or on-site visitations.", "A detailed critical inspection.", "To plot a map of (land)."], "sustainable development": ["Development that provides economic, social and environmental benefits in the long term having regard to the needs of living and future generations."], "marsh": ["An periodically inundated area of low ground having shrubs and trees, with or without the formation of peat."], "sweetener": ["A sweetening agent, especially one that does not contain sugar."], "symbiosis": ["A close and mutually beneficial association of organisms of different species."], "synecology": ["Study of the ecology of organisms, populations, communities or systems."], "synergism": ["An ecological association in which the physiological processes of behaviour of an individual are enhanced by the nearby presence of another organism."], "synthetic detergent": ["An artificially produced solid or liquid cleansing substance that acts like soap but is stronger, and is capable of dissolving oily materials and dispersing them in water.\\n(Source: DOE / RIC)"], "synthetic material": ["Material made artificially by chemical reaction.\\n(Source: CEDa)"], "systems analysis": ["A means of organizing elements into an integrated analytic and/or decisionmaking procedure to achieve the best possible results.\\n(Source: LANDY)"], "systems theory": ["The science concerned with the general study of structures and behaviours of systems which may be applicable in different branches of learning."], "tank farm": ["Storage space for containers of liquids or gases."], "tannin": ["One of a group of complex organic chemicals commonly found in leaves, unripe fruits, and the bark of trees."], "tar": ["A viscous material composed of complex, high-molecular-weight, compounds derived from the distillation of petroleum or the destructive distillation of wood or coal.", "A long-necked, waisted lute."], "target group": ["The group of people that something, for example an advertising campaign, is primarily aimed at."], "tariff": ["A classified list or scale of charges made in any private or public business.\\n(Source: OED)"], "tar sand": ["A mixture of bitumen, sand, clay and water."], "tax": ["An amount of money demanded by a government for its support or for specific facilities or services, most frequently levied upon income, property or sales."], "taxation": ["The act or result of a government requiring money for its support or for specific facilities or services.\\n(Source: RHW)"], "tax law": ["A binding rule or body of rules prescribed by a government stipulating the sum of money and manner of collection it demands for governmental support, facilities and services, usually levied upon income, property, sales or other financial resources."], "taxonomy": ["The branch of biology concerned with the classification of organisms into groups based on similarities of structures, origin, etc.", "A hierarchical organization of a subject area, from one perspective in one language."], "teaching": ["The act of imparting knowledge or skill."], "teaching method": ["A procedure, technique or system with definite plans for instruction or imparting knowledge."], "technology": ["Systematic knowledge of industrial processes and their application."], "technology assessment": ["The systematic analysis of the anticipated impact of a particular technology in regard to its safety and efficacy as well as its social, political, economic, and ethical consequences.\\n(Source: KOREN)"], "technology transfer": ["The transfer of development and design work from a parent company to a subsidiary or from one country to another as a form of aid to help promote development and sustainable growth."], "tectonics": ["A branch of geology dealing with the broad architecture of the outer part of the Earth, that is, the regional assembling of structural or deformation features, a study of their mutual relations, origin and historical evolution."], "telecommunications": ["The conveyance of images, speech and other sounds, usually over great distances, through technological means, particularly by television, telegraph, telephone or radio."], "telematics": ["The convergence of computing and communications technologies, thus the use of telephone or radio to link computers and the use of computers to send messages via telephone or radio links.\\n(Source: NECTAR)"], "telemetry": ["The use of radio waves, telephone lines, etc., to transmit the readings of measuring instruments to a device on which the readings can be indicated or recorded."], "television": ["The process, equipment or programming involved in converting a succession of audiovisual images into corresponding electrical signals that are transmitted by means of electromagnetic waves to distant receivers or screens, at which the signals can be used to reproduce the original image.", "A device for receiving television signals and displaying them in visual form."], "temperate forest": ["Mixed forest of conifers and broad-leaf deciduous trees, or mixed conifer and broad-leaf evergreen trees, or entirely broad-leaf deciduous, or entirely broad-leaf evergreen trees, found in temperate regions across the world; characterized by high rainfall, warm summers, cold winters occasionally subzero, seasonality; typically with dense canopies, understorey saplings and tall shrubs, large animals, carnivores dominant, very rich in bird species."], "temperate woodland": ["Forest dominated by broad-leaved hardwoods, which occurs over large tracts in the mid-latitudes of Europe, N. America, and eastern Asia, but which is restricted in the southern hemisphere to Chilean Patagonia."], "temperature": ["A measure of cold or hot. A property that determines the direction of heat flow when an object is brought into thermal contact with other objects."], "temporary shelter": ["Simple facility for asylum or provisional lodgings to individuals or groups in emergencies.\\n(Source: ECHO2)"], "teratogenesis": ["The process whereby abnormalities of the offspring are generated, usually as the result of damage to the embryonal structure during the first trimester of pregnancy, producing deformity of the fetus."], "teratogenicity": ["The ability or tendency to produce anomalies of formation."], "teratogen": ["Substance causing formation of a congenital anomaly or monstrosity in the embryo."], "terminology": ["The body of specialized words relating to a particular subject.", "The study of the designating of concepts particular to one or more domains of human activity, through research and analysis of terms in context, for the purpose of documenting and promoting correct usage."], "termite": ["A soft-bodied insect of the order Isoptera; individuals feed on cellulose and live in colonies with a caste system comprising three types of functional individuals: sterile workers and soldiers, and the reproductives."], "terrestrial area": ["Subdivisions of the continental surfaces distinguished from one another on the basis of the form, roughness, and surface composition of the land.\\n(Source: PARCOR)"], "territorial policy": ["A course of action adopted and pursued by government, business or some other organization, which determines the present and future use of each parcel of land in an area.\\n(Source: DOE)"], "territory": ["An area that an animal or group of animals defends, mainly against members of the same species.", "Land that is controlled by a specific country or ruler.", "Land or an area of a particular type.", "A tract of land of undefined size.", "A geographic area owned or controlled by a single person or organization.", "The region of responsibility assigned to a representative, agent, or the like.", "A non-sovereign geographic area which has come under the authority of an external government but has not yet been admitted to the full rights of a province or federal state of the controlling country."], "tertiary sector": ["The part of a country or region's economy that produces services or assets lacking a tangible and storable form.", "The business sector that consists of companies whose line of work involves doing something for customers, but that do not produce goods."], "test": ["To carry out an examination on (a substance, material, or system) by applying some chemical or physical procedure designed to indicate the presence of a substance or the possession of a property.", "A session in which a product or piece of equipment is placed under everyday and/or extreme conditions and is examined for its durability, etc.", "A series of questions (set by the teacher or professor), aiming to gauge how much students have learnt over a given academic module, term or year.", "To test or examine for the presence of disease or infection.", "to check a property or quality of"], "test animal": ["An animal on which experiments are conducted in order to provide evidence for or against a scientific hypothesis, or to prove the efficacy of drugs or the reaction to certain products.\\n(Source: CEDa)"], "test organism": ["Any animal organism used for scientific research."], "textile industry": ["Industry for the production of fabrics.\\n(Source: MGHa)"], "textile": ["A material made of natural or man-made fibers and used for the manufacture of items such as clothing and furniture fittings."], "thallium": ["Bluish-white metal with tinlike malleability, but a little softer; used in alloys."], "theory of money": ["A coherent group of general propositions about the supply and demand of money, interest rates, the flow of money's influence on the overall economy or the policies that should be adopted by institutions controlling the money supply."], "theory of the welfare state": ["A political conception of government in a capitalist economy where the state is responsible for insuring that all members of society attain a minimum standard of living through redistribution of resources, progressive taxation and universal social programs, including health care and education."], "therapy": ["The treatment of physical, mental or social disorders or disease."], "thermal insulation": ["The process of preventing the passage of heat to or from a body by surrounding it with a nonconducting material."], "thermal pollution": ["The excessive raising or lowering of water temperature above or below normal seasonal ranges in streams, lakes, or estuaries or oceans as the result of discharge of hot or cold effluents into such water.\\n(Source: LANDY /  WPR)"], "thermal power plant": ["A power-generating plant which uses heat to produce energy. Such plants may burn fossil fuels or use nuclear energy to produce the necessary thermal energy."], "thermal water": ["Water, generally of a spring or geyser, whose temperature is appreciably above the local mean annual air temperature."], "thermodynamics": ["The branch of physics which seeks to derive, from a few basic postulates, relationships between properties of matter, especially those connected with temperature, and a description of the conversion of energy from one form to another."], "thermoselect process": ["A thermic waste processing technology."], "thesaurus": ["A compilation of terms showing synonyms, related terms and other relationships and dependencies, often used in a book format or as a standardized, controlled vocabulary for an information storage and retrieval system."], "tidal power": ["Mechanical power, which may be converted to electrical power, generated by the rise and fall of ocean tides."], "tidal water": ["Any water whose level changes periodically due to tidal action."], "tide": ["The periodic rise and fall of the water resulting from gravitational interaction between the sun, moon and earth."], "time": ["The grammatical construct of the time in which a sentence acts.", "The dimension of the physical universe which, at a given place, orders the sequence of events.", "To measure the amount of time an object takes to complete a course (e.g., \"to clock a race car\").", "The period of time a prisoner is imprisoned.", "A designated instant in time.", "An instance or occurrence of an event."], "tissue": ["A part of an organism consisting of a large number of cells having a similar structure and function.", "A sheet of paper that absorbs water, used for example to weep wet surfaces."], "titanium": ["A strong malleable white metallic element with symbol Ti and atomic number 22, which is very corrosion-resistant and occurs in rutile and ilmenite. It is used in the manufacture of strong lightweight alloys, especially aircraft parts."], "titanium dioxide": ["A white, water-insoluble powder that melts at 1560\u00b0C, and which is produced commercially from the titanium dioxide minerals ilmenite and rutile; used in paints and cosmetics."], "toad": ["Any anuran amphibian of the family Bufonidae, such as Bufo bufo of Europe. They are similar to frogs but are more terrestrial, having a drier warty skin."], "tobacco": ["A genus of short-leafed plants (Nicotiana spp., L.) of the nightshade family indigenous to North and South America.", "Leaves of certain varieties of the tobacco plant, cultivated and harvested to make cigarettes, cigars, snuff, for smoking in pipes or for chewing."], "tobacco smoke": ["The grey, brown, or blackish mixture of gases and suspended carbon particles resulting from the combustion of tobacco. Tobacco smoke is inhaled and distributes toxins widely throughout the body and causes an enormous variety of illness among users and among non-smokers exposed to tobacco smoke."], "tornado": ["A rapidly rotating column of air developed around a very intense low-pressure centre."], "tortoise": ["Any herbivorous terrestrial chelonian reptile of the family Testudinidae, of most warm regions, having a heavy dome-shaped shell and clawed limbs."], "total parameter": ["The sum of parameters that must be taken into account when assessing water quality (organoleptic factors, physico-chemical factors, toxic substances, microbiological parameters."], "tourism": ["The temporary movement of people to destinations outside their normal places or work and residence, the activities undertaken during their stay in those destinations and the facilities created to cater for their needs."], "touristic zone": ["Any section of a region which attracts travelers, often because of its scenery, objects of interest or recreational activities."], "toxic effect": ["A result produced by the ingestion or contact of poisonous materials."], "toxicity": ["The degree of danger posed by a substance to animal or plant life."], "toxic metal": ["Metal (usually heavy metals) which interferes with the respiration, metabolism or growth of organisms."], "toxicological testing": ["Test for the determination of the inherent toxicity of a chemical."], "toxicology": ["A science that deals with poisons, their actions, their detection, and the treatment of the conditions they produce.\\n(Source: LANDY)"], "toxic waste": ["Refuse posing a significant hazard to the environment or to human health when improperly handled."], "toxin": ["A substance that may present a risk or injury to health or the environment."], "trace element": ["Any of various chemical elements that occur in very small amounts in organisms and are essential for many physiological and biochemical processes."], "tracheophyte": ["A large group of plants characterized by the presence of specialized conducting tissues (xylem and phloem) in the roots, stems, and leaves.\\n(Source: MGH)"], "trade barrier": ["An artificial restraint on the free exchange of goods and services between nations."], "trade policy": ["A course of action adopted and pursued by government, business or some other organization, which promotes or determines the direction for the act or process of buying, selling or exchanging goods and services within a country or between countries."], "trade restriction": ["Commercial discrimination that apply to the exports of certain countries but not to similar goods from other countries."], "traditional health care": ["A system of treating and healing maladies based on cultural beliefs and practices handed down from generation to generation.\\n(Source: FIT)"], "traffic": ["The movement of vehicles, ships, aircraft, persons, etc., in an area or over a route.", "The vehicles, persons, etc., moving in an area or over a route.", "The buying and selling, especially of illicit trade.", "To buy and sell goods illegally.", "To exchange goods."], "traffic accident": ["An unexpected incident with potential for harm occurring through the movement or collision of vessels, vehicles or persons along a land, water, air or space route.\\n(Source: OED)"], "traffic control": ["The organization of a more efficient movement of traffic within a given road network by rearranging the flows, controlling the intersections and regulating the times and places for parking."], "traffic engineering": ["The determination of the required capacity and layout of highway and street facilities that can safely and economically serve vehicular movement between given points.\\n(Source: MGH)"], "traffic infrastructure": ["The fundamental facilities and systems used for the movement of vehicles, often provided through public funding."], "traffic jam": ["A number of vehicles so obstructed that they can scarcely move."], "traffic monitoring": ["The periodic or continuous surveillance or analysis of the movement of persons, objects, vehicles or other conveyances along an area of passage."], "traffic noise": ["Noise emitted by vehicles (heavy vehicles, cars and motorcycles, tyre/road interaction)."], "traffic on water": ["The movement of boats and other vessels over any water route or area."], "train": ["A self-propelled, connected group of vehicles moving on rails.", "To point or cause to go (blows, weapons, or objects such as photographic equipment) towards", "To develop behaviour by instruction and practice.", "A group of animals, vehicles, or people that follow one another in a line.", "To do physical exercise to improve one's fitness.", "To exercise in order to prepare for an event or competition.", "To teach by training.", "To undergo training or instruction for a particular role, function, or profession.", "To educate for a future role or function.", "To act as a trainer or coach (to), as in sports."], "training": ["The process of bringing a person or a group of persons to an agreed standard of proficiency and skilled behavior, by practice and instruction.", "The period in which someone who starts a profession is trained; the position of apprentice."], "trajectory": ["The path described by an object moving in air or space under the influence of such forces as thrust, wind resistance, and gravity, especially the curved path of a projectile."], "transition element": ["One of a group of metallic elements in which the members have the filling of the outermost shell to 8 electrons interrupted to bring the penultimate shell from 8 to 18 or 32 electrons; includes elements 21 through 29 (scandium through copper), 39 through 47 (yttrium through silver), 57 through 79 (lanthanum through gold), and 89 through 112 (actinium through ununbium) on."], "transpiration": ["The loss of water vapour from a plant, mainly through the stomata and to a small extent through the cuticle and lenticels.", "The production and evaporation of a watery fluid called sweat that is excreted by the sweat glands in the skin of mammals."], "transportation business": ["Any commercial venture involved in the processes of conveying things or people from one place to another."], "transportation policy": ["Comprehensive statements of the objectives and policies which a local transport authority intends to pursue; it includes and estimate of transport expenditure, a statement of transport objectives, etc.\\n(Source: GOOD)"], "transportation": ["The act or means of moving tangible objects (persons or goods) from place to place. Often involves the use of some type of vehicle.", "The act of expelling a person from his native land."], "trapping": ["The act of catching an animal in a mechanical device or enclosed place or pit."], "travel": ["To move from one place to another generally by using a transportation mean; to undertake a trip.", "The transport of people on a trip or journey."], "travel cost": ["Expenditure of money or the amount of money incurred for journeying or going from one place to another by some mode of transportation.\\n(Source: ISEP /  RHW)"], "treaty": ["An international agreement in writing between two states or a number of states. They are binding in international law; some create law only for those states that are parties to them."], "tree": ["Any large woody perennial plant with a distinct trunk giving rise to branches or leaves at some distance from the ground.", "A widely-used data structure that emulates a tree structure with a set of linked nodes."], "tree nursery": ["An area where trees, shrubs, or plants are grown for transplanting, for use as stocks for budding and grafting.\\n(Source: ECHO2)"], "trend": ["The general drift, tendency, or bent of a set of statistical data as related to time or another related set of statistical data.\\n(Source: MGH)"], "triazine": ["Azines that contain three nitrogen atoms in their molecules."], "trinity of principles": ["Three fundamental principles of environmental policy: precautionary principle, polluter pays-principle and cooperation principle."], "tritium": ["The hydrogen isotope having mass number 3; it is one form of heavy hydrogen, the other being deuterium."], "trophic level": ["Any of the feeding levels through which the passage of energy through an ecosystem proceeds."], "tropical forest ecosystem": ["The interacting system of a biological community and its non-living environmental surroundings in forests found in tropical regions near the equator, which are characterized by warm to hot weather and abundant rainfall."], "tropical forest": ["A vegetation class consisting of tall, close-growing trees, their columnar trunks more or less unbranched in the lower two-thirds, and forming a spreading and frequently flat crown; occurs in areas of high temperature and high rainfall."], "tropical rain forest": ["A type of forest that occurs roughly within the latitudes 28 degrees north or south of the equator and is characterized by high average temperatures and a significant amount of rainfall."], "tropics": ["The region of the earth's surface lying between two parallels of latitude on the earth, one 23\u00b027' north of the equator and the other 23\u00b027' south of the equator, representing the points farthest north and south at which the sun can shine directly overhead and constituting the boundaries of the Torrid Zone.\\n(Source: AMHER)"], "troposphere": ["The lowest of the concentric layers of the atmosphere, occurring between the Earth's surface and the tropopause."], "tropospheric ozone": ["Tropospheric ozone is a secondary pollutant formed from emissions of nitrogen oxides, non-methane volatile organic compounds and carbon monoxide. Ozone scars lung tissue, makes eyes sting and throats itch. It has been implicated as a contributor to forest dieback, damage to agricultural crops, etc.\\n(Source: WPR)"], "tundra": ["An area supporting some vegetation (lichens, mosses, sedges and low shrubs) between the northern upper limit of trees and the lower limit of perennial snow on mountains, and on the fringes of the Antarctic continent and its neighbouring islands."], "tunnel": ["A underground passageway, especially one for trains or cars that passes under a mountain, river or a congested urban area.", "An Internet Protocol (IP) network communications channel between two networks. It is used to transport another network protocol by encapsulation and often encryption of its packets."], "turbidity": ["Cloudy or hazy appearance in a naturally clear liquid caused by a suspension of colloidal liquid droplets or fine solids."], "turbine": ["A fluid acceleration machine for generating rotary mechanical power from the energy in a stream of fluid.\\n(Source: MGH)"], "tween-deck tanker": ["A sea-going vessel that includes space between two continuous floor-like surfaces or platforms, which is also designed for bulk shipments of liquids or gases."], "twin-hull craft": ["Oil tank vessels provided with a double-hull to meet the regulatory safety requirements in oil transportation."], "two-stroke engine": ["An internal combustion engine whose cycle is completed in two strokes of the piston."], "type of claim": ["A class or category of interests or remedies recognized in law or equity that create in the holder a right to the interest or its proceeds, typically taking the form of money, property or privilege.\\n(Source: BLD)"], "typhoon": ["A severe tropical cyclone in the western Pacific."], "tyre": ["A rubber ring placed over the rim of a wheel of a road vehicle to provide traction and reduce road shocks."], "ultrafiltration": ["Separation of colloidal or very fine solid materials by filtration through microporous or semipermeable mediums."], "ultrasound": ["Sound waves having a frequency above about 20,000 hertz."], "ultraviolet radiation": ["The part of the electromagnetic spectrum with wavelengths shorter than light but longer than x-rays; in the range of 4-400 nm.\\n(Source: CED)"], "underground train": ["A train for transportation of people, mostly beneath the surface of the ground, in order to lessen the traffic."], "unemployment": ["The condition of being without remunerative employment."], "ungulate": ["Animal with hooved feet.", "Having a hoof."], "United Nations": ["A voluntary association of around 180 state signatory to the UN charter (1945), whose primary aim is to maintain international peace and security, solve economic, social, and political problems through international co-operation, and promote respect for human rights.", "Relating to the United Nations."], "unleaded petrol": ["Petrol, which has no lead additives in it and therefore creates less lead pollution in the atmosphere."], "clean air area": ["Area where significant reductions in ozone forming pollutants have been achieved."], "raw water": ["Water that has not been treated."], "upbringing": ["The way in which a child is cared for and taught while it is growing up."], "Upper House": ["The body of a bicameral legislature comprising either representatives of member states in a federation or a select number of individuals from certain privileged estates or social classes."], "uranium": ["A metallic element highly toxic and radioactive; used as nuclear fuel.\\nSymbol: U, atomic number: 92."], "urban area": ["Areas within the legal boundaries of cities and towns; suburban areas developed for residential, industrial or recreational purposes.", "The area within a city or town, as indicated by appropriate traffic signs (or, in the United Kingdom, by the presence of street lights), where different traffic rules are in effect, such as a reduction of the speed limit."], "urban decay": ["Condition where part of a city or town becomes old or dirty or ruined, because businesses and wealthy families have moved away from it."], "urban design": ["A plan, outline or preliminary sketch of, or for, a city or town."], "urban development": ["Any physical extension of, or changes to, the uses of land in metropolitan areas, often involving subdivision into zones; construction or modification of buildings, roads, utilities and other facilities; removal of trees and other obstructions; and population growth and related economic, social and political changes."], "urban green": ["The complex of private and public gardens in an urban area.\\n(Source: DIFID)"], "urban landscape": ["The traits, patterns and structure of a city's specific geographic area, including its biological composition, its physical environment and its social patterns."], "urban management": ["The administration, organization and planning performed for cities or towns, particularly the process of converting farmland or undeveloped land into offices, businesses, housing and other forms of development.\\n(Source: DOE)"], "urban planning": ["The activity of designing, organizing or preparing for the future lay-out and condition of a city or town.", "The study and theory of building and other physical needs in cities or predominantly urban cultures."], "urban population": ["The total number of persons inhabiting a city, metropolitan region or any area where the sum of residents exceeds a designated amount."], "urban renewal": ["A continuing process of remodelling urban areas by means of rehabilitation and conservation as well as redevelopment. Urban renewal programmes are generally undertaken by public authorities and concern those parts of the city which have fallen below current standards of public acceptability."], "urban stress": ["A state of bodily or mental tension developed through city living, or the physical, chemical, or emotional factors that give rise to that tension."], "urban study": ["The study and theory of building and other physical needs in cities or predominantly urban cultures."], "urban traffic": ["Movements of vehicles and people within a city.\\n(Source: RRDA)"], "urban water supply": ["The distribution of water, including collection, treatment and storage, for use in a town, city or municipal area, and used generally for domestic and industrial needs."], "valley": ["Any low-lying land bordered by higher ground; especially an elongate, relatively large, gently sloping depression of the Earth's surface, commonly situated between two mountains or between ranges of hills or mountains, and often containing a stream with an outlet."], "vanadium": ["A silvery-white, ductile metal resistant to corrosion; used in alloy steels and as an x-ray target."], "vandalism": ["The deliberate or wanton destruction of personal or public property caused by a vandal."], "varnish": ["A transparent surface coating which is applied as a liquid and then changes to a hard solid."], "vegetation cover": ["Number of plants growing on a certain area of land."], "vegetable cultivation": ["Cultivation of herbaceous plants that are used as food."], "plant ecology": ["Study of the relationships between plants and their environment.\\n(Source: LBC)"], "plant selection": ["The selection by man of particular genotypes in a plant population because they exhibit desired phenotypic characters.\\n(Source: LBC)"], "vegetable oil": ["An edible, mixed glyceride oil derived from plants (fruit, leaves, and seeds)."], "plant reproduction": ["Any of various processes, either sexual or asexual, by which a plant produces one or more individuals similar to itself."], "vegetable": ["Any of various herbaceous plants having parts that are used as food.", "A person with severe brain damage or who is in a persistent vegetative state.", "An organism that is not an animal, especially an organism capable of photosynthesis."], "vegetation": ["1) The plants of an area considered in general or as communities, but not taxonomically; the total plant cover in a particular area or on the Earth as a whole. 2) The total mass of plant life that occupies a given area.\\n(Source: ALL /  MGH)", "The plants that inhabit a certain region or environment."], "vegetation type": ["A community of plants or plant life that share distinguishable characteristics.\\n(Source: PEM)"], "vehicle": ["Any conveyance in or by which people or objects are transported."], "vehicle inspection": ["An official periodical examination of an automobile, truck, boat, airplane or other means of conveyance to determine compliance in design or operation with legal standards for safety or pollution emissions.\\n(Source: DAM / RHW)"], "ventilation": ["The process of supplying or removing air, by natural or mechanical means, to or from any space; such air may or may not have been conditioned."], "vermin": ["Small animals and insects that can be harmful and which are difficult to control when they appear in large numbers.\\n(Source: CAMB)"], "vertebrate": ["Any chordate animal of the subphylum Vertebrata, characterized by a bony or cartilaginous skeleton and a well-developed brain: the group contains fishes, amphibians, reptiles, birds, and mammals.\\n(Source: CED)"], "veterinary medicine": ["The branch of medical practice which treats of the diseases and injuries of animals."], "viaduct": ["A long high bridge, usually held up by many arches, which carries a railway or a road over a valley or other similar area at a lower level."], "vibration": ["A periodic motion of small amplitude and high frequency, characteristic of elastic bodies."], "video": ["A format or system used to record and transmit visual or audiovisual information by translating moving or still images into electrical signals.\\n(Source: MVG)"], "village": ["A group of houses and other buildings, such as a church, a school and some shops, which is smaller than a town, usually in the countryside.", "Small town or part of it."], "vinasse": ["The residual liquid from the distillation of alcoholic liquors, specifically, that remaining from the fermentation and distillation of beet-sugar molasses, valuable as yielding potassium salts, ammonia, etc."], "virology": ["The study of submicroscopic organisms known as viruses."], "virus": ["Submicroscopic agents that infect plants, animals and bacteria, and are unable to reproduce outside the tissues of the host.\\n(Source: ALL)", "Computer program that is designed to damage a computer and that is able to spread itself to other computers."], "viscosity": ["A measure of the resistance of a fluid."], "vitamin": ["An organic compound present in variable, minute quantities in natural foodstuffs and essential for the normal processes of growth and maintenance of the body."], "viticulture": ["Division of horticulture concerned with grape growing, studies of grape varieties, methods of culture, and insect and disease control."], "vocabulary": ["A list of words or phrases of a language, technical field or some specialized area, usually arranged in alphabetical order and often provided with brief definitions and with foreign translations."], "vocational training": ["A special training for a regular occupation or profession, especially, one for which one is specially suited or qualified."], "volatile organic compound": ["Organic compound readily passing off by evaporation."], "volatility": ["The property of a substance or substances to convert into vapor or gas without chemical change."], "volcanic eruption": ["The ejection of solid, liquid, or gaseous material from a volcano."], "volcanism": ["The processes by which magma and its associated gases rise into the crust and are extruded onto the Earth's surface and into the atmosphere.\\n(Source: BJGEO)"], "volcano": ["A vent in the surface of the Earth through which magma and associated gases and ash erupt.", "A mountain formed by volcanic material."], "voluntary work": ["Unpaid activities done by citizens often organized in associations, to provide services to others, particularly to elderly and poor people, handicapped, etc."], "Wadden Sea": ["A shallow sea extending along the North Sea coasts of The Netherlands, Germany and Denmark."], "wage system": ["System which compensates the employees with a fixed sum per piece, hour, day or another period of time, covering all compensations including salary."], "wall": ["A vertical construction made of stone, brick, wood, etc., with a length and height much greater than its thickness, used to enclose, divide or support.", "A type of small thin wall, made \u200b\u200bof wood or masonry and used for the division of an apartment or any building.", "A divisive or containing structure in an organ or cavity."], "war": ["A conflict or a state of hostility between two or more parties, nations or states, in which armed forces or military operations are used."], "warm-blooded animal": ["Animal which has a body temperature that stays the same and does not change with the temperature of its surroundings."], "warning system": ["Any series of procedures and devices designed to detect sudden or potential threats to persons, property or the environment, often utilizing radar technology."], "wastage": ["Extravagant or useless consumption or expenditures."], "waste": ["Unwanted or undesired material, usually discarded.", "To use goods and wealth inconsiderately, without any care.", "Excessive spending of goods and wealth.", "To cause extensive destruction or ruin utterly."], "waste balance": ["The inventory of all waste produced or recovered during a certain time period, classified by type and quantity.\\n(Source: DOG)"], "waste bin": ["A container for litter, rubbish, etc.\\n(Source: CED)"], "waste collection": ["The periodic or on-demand removal of solid waste from primary source locations using a collection vehicle and followed by the depositing of this waste at some central facility or disposal site."], "waste degasification": ["The removal of gaseous components from waste."], "waste exchange": ["Exchange of the recyclable part of wastes. This procedure allows to minimize waste volume and the cost relating to waste disposal. The basis of waste exchange is the concept that \"one company's waste is another company's raw material\".\\n(Source: ECOUK /  ECHO2)"], "waste gas": ["Any unusable aeriform fluid, or suspension of fine particles in air, given off by a manufacturing process or the burning of a substance in a enclosed area.\\n(Source: OED / RHW)"], "waste glass": ["Discarded material from the glass manufacturing process or from used consumer products made of glass."], "waste gypsum": ["By-product of the wet limestone flue gas desulphurisation process.\\n(Source: PORTa)"], "waste heat": ["Heat derived from the cooling process of electric power generating plants and which can cause thermal pollution of watercourses, promoting algal bloom."], "waste heat charge": ["The release of heat generated as a byproduct from industrial or power generation processes.\\n(Source: TOE)"], "waste oil": ["Oil that arises as a waste product of the use of oils in a wide range of industrial and commercial activities, such as engineering, power generation and vehicle maintenance and should be properly disposed of, or treated in order to be reused."], "waste paper": ["Newspapers, magazines, cartons and other paper separated from solid waste for the purpose of recycling."], "waste recycling": ["A method of recovering wastes as resources which includes the collection, and often involving the treatment, of waste products for use as a replacement of all or part of the raw material in a manufacturing process."], "waste sorting": ["Separating waste into different materials, such as glass, metal, paper, plastic, etc.\\n(Source: PHC)"], "waste treatment": ["Any process or combination of processes that changes the chemical, physical or biological composition or character of any waste or reduces or removes its harmful properties or characteristics for any purpose."], "waste water": ["Used water, or water that is not needed, which is permitted to escape, or unavoidably escapes from canals, ditches, reservoirs or other bodies of water, for which the owners of these structures are legally responsible."], "waste water charge": ["Imposed fee, expense, or cost for the management of spent or used water that contains dissolved or suspended matter from a home, community farm, or industry.\\n(Source: TOE / RHW)"], "water bottom": ["The floor upon which any body of water rests.\\n(Source: BJGEO)"], "water collection": ["The catching of water, especially rain water, in a structure such as a basin or reservoir."], "water conservation": ["The protection, development and efficient management of water resources for beneficial purposes."], "water consumption": ["The utilization patterns and quantities entailed in a community or human group's use of water for survival, comfort and enjoyment."], "watercourse": ["A natural stream arising in a given drainage basin but not wholly dependent for its flow on surface drainage in its immediate area, flowing in a channel with a well-defined bed between visible banks or through a definite depression in the land, having a definite and permanent or periodic supply of water, and usually, but not necessarily, having a perceptible current in a particular direction and discharging at a fixed point into another body of water.\\n(Source: BJGEO)"], "water distribution system": ["The system of pipes supplying water to communities and industries."], "water erosion": ["The breakdown of solid rock into smaller particles and its removal by water."], "waterfall": ["A perpendicular or steep descent of the water of a stream."], "water flea": ["A fresh-water branchiopod crustacean of the genus Daphnia characterized by a transparent bivalve shell."], "hydrologic flow": ["The characteristic behaviour and the total quantity of water involved in a drainage basin, determined by measuring such quantities as rainfall, surface and subsurface storage and flow, and evapotranspiration.\\n(Source: BJGEO)"], "water for consumption": ["Consumptive water use starts with withdrawal, but in this case without any return, e.g. irrigation, steam escaping into the atmosphere, water contained in final products, i.e. it is no longer available directly for subsequent use."], "waterfowl": ["Aquatic birds which constitute the order Anseriformes, including the swans, ducks, geese, and screamers."], "water hardness": ["The amount of calcium and magnesium salts dissolved in water."], "water hyacinth": ["Floating aquatic plant, Eichhornia crassipes of tropical America, having showy bluish-purple flowers and swollen leafstalks: family Pontederiaceae. It forms dense masses in rivers, ponds, etc., and is a serious pest in the southern U.S., Java, Australia, New Zealand, and parts of Africa.\\n(Source: CED)"], "water level": ["The level reached by the surface of a body of water."], "water pollutant": ["A chemical or physical agent introduced to any body of water that may detrimentally alter the natural condition of that body of water and other associated bodies of water."], "water pollution": ["The manmade or man-induced alteration of the chemical, physical, biological and radiological integrity of water.\\n(Source: LANDY)"], "water pollution prevention": ["Precautionary measures, actions or installations implemented to avert or hinder human-made or human-induced alteration of the physical, biological, chemical and radiological integrity of water."], "water protection": ["Measures to conserve surface and groundwater; to ensure the continued availability of water for growing domestic, commercial and industrial uses and to ensure sufficient water for natural ecosystems.\\n(Source: GILP96a)"], "water pump": ["A machine or apparatus used to lift water, usually from a well or borehole, which is powered manually or by engine, wind or some other source."], "water purification": ["Any of several processes in which undesirable impurities in water are removed or neutralized."], "water quality": ["A graded value of the components (organic and inorganic, chemical or physical) which comprise the nature of water."], "water quality management": ["Water quality management concerns four major elements: the use (recreation, drinking water, fish and wildlife propagation, industrial or agricultural) to be made of the water; criteria to protect those uses; implementation plans (for needed industrial-municipal waste treatment improvements) and enforcement plans, and an anti-degradation statement to protect existing high quality waters.\\n(Source: USC)"], "water salination": ["Process by which water becomes more salty, found especially in hot countries where irrigation is practised."], "water science": ["The science that treats the occurrence, circulation, distribution, and properties of the waters of the earth, and their reaction with the environment.\\n(Source: MGH)"], "watershed": ["The dividing line between two adjacent river systems, such as a ridge.", "An area of land where all rainwater and melting snow naturally moves to the same body of water."], "water supply": ["A source or volume of water available for use; also, the system of reservoirs, wells, conduits, and treatment facilities required to make the water available and usable."], "water transportation": ["Transportation of goods or persons by means of ships travelling on the sea or on inland waterways.\\n(Source: CEDa)"], "water treatment": ["Purification of water to make it suitable for drinking or for any other use."], "waterway": ["A river, canal, or other navigable channel used as a means of travel or transport."], "water well": ["A well sunk to extract water from a zone of saturation."], "waterworks": ["Plant for treating and purifying water before it is pumped into pipes for distribution to houses, factories, schools, etc.", "The water supply system of a town etc., including reservoirs, pumps and pipes."], "wave energy": ["Power extracted from the motion of sea waves at the coast."], "sea wave": ["A moving ridge or swell of water occurring close to the surface of the sea, characterized by oscillating and rising and falling movements, often as a result of the frictional drag of the wind.\\n(Source: OED / INP)"], "weapon": ["An instrument of attack or defense in combat, as a gun, missile, or sword."], "weather": ["The day-to-day meteorological conditions, especially temperature, cloudiness, and rainfall, affecting a specific place."], "weather condition": ["The complex of meteorological characteristics in a given region.\\n\\n(Source: RRDA)"], "weather modification": ["The changing of natural weather phenomena by technical means."], "weather monitoring": ["The periodic or continuous surveillance or analysis of the state of the atmosphere and climate, including variables such as temperature, moisture, wind velocity and barometric pressure.\\n(Source: TOE / RHW)"], "weather forecasting": ["The act or process of predicting and highlighting meteorological conditions that are expected for a specific time period and for a specific area or portion of air space, by using objective models based on certain atmospheric parameters, along with the skill and experience of a meteorologist.\\n(Source: FEM / AUS)"], "weed": ["Any plant that grows wild and profusely, especially one that grows among cultivated plants, depriving them of space, food, etc.", "A drug prepared from the cannabis plant, that is smoked or ingested for its euphoric effect.", "To pull out weeds by hand.", "To clear (a cultivated area) of weeds (unwanted vegetation)."], "weight": ["The gravitational force with which the earth attracts a body. By extension, the gravitational force with which a star, planet, or satellite attracts a nearby body."], "welding": ["Joining two metals by applying heat to melt and fuse them, with or without filler metal."], "well": ["A hole dug into the earth to reach a supply of water, oil, brine or gas.", "An interjection in response to a statement that is only partially agreed with by the speaker. It is often followed by a counterstatement by the speaker elaborating on the nature of the disagreement.", "To a great extent or degree."], "West Africa": ["A geographic region of the African continent bordered in the west and south by the Atlantic Ocean, including the republics of Benin, Burkina Faso, Cape Verde, Ivory Coast, Gambia, Ghana, Guinea-Bissau, Liberia, Mali, Mauritania, Niger, Nigeria, Senegal, Sierra Leone and Togo.\\n(Source: ECW)"], "Western Asia": ["A geographic region of Asia that includes Turkey, Iran and other countries of the Middle East and the Arabian peninsula."], "Western Europe": ["A geographic region of the European continent surrounded by the North Sea, Atlantic Ocean and the Mediterranean Sea, including Belgium, France, Germany, Great Britain, Greece, Italy, Luxembourg, Netherlands, Portugal, Spain and other member countries of the Western European Union."], "wetland": ["Area that is inundated by surface or ground water with frequency sufficient to support a prevalence of vegetative or aquatic life that requires saturated or seasonally saturated soil conditions for growth or reproduction."], "wet scrubber": ["An air cleaning device that literally washes out the dust. Exhaust air is forced into a spray chamber, where fine water particles cause the dust to drop from the air stream. The dust-ladden water is then treated to remove the solid material and is often recirculated.", "Equipment through which a gas is passed to remove impurities (solid, liquid, or gaseous particles) by intimate contact with a suitable liquid, usually an aqueous medium."], "whale": ["Large marine mammals of the order Cetacea; the body is streamlined, the broad flat tail is used for propulsion, and the limbs are balancing structures."], "whaling": ["Catching whales to use as food or for their oil, etc.", "Relating to whales."], "wholesale trade": ["The business of selling goods to retailers in larger quantities than they are sold to final consumers but in smaller quantities than they are purchased from manufacturers."], "wild animal": ["A non-domesticated animal living independently of man."], "wildlife": ["All non-domesticated plants, animals and other organisms living in the wild."], "wildlife sanctuary": ["An area designated for the protection of wild animals."], "wild plant": ["A non-domesticated plant."], "wind": ["The motion of air relative to the earth's surface; usually means horizontal air motion, as distinguished from vertical motion.", "To wrap something in loops around something else."], "wind erosion": ["The breakdown of solid rock into smaller particles and its removal by wind."], "windmill": ["A machine for grinding or pumping driven by a set of adjustable vanes or sails that are caused to turn by the force of the wind."], "wind power": ["Energy extracted from wind, traditionally in a windmill, but increasingly by more complicated designes including turbines, usually to produce electricity but also for water pumping."], "wind power station": ["Power station which uses wind to drive a turbine which creates electricity."], "woman": ["An adult human member of the sex that produces ova and bears young."], "woman's status": ["The social position, rank or relative importance of women in society."], "timber": ["A wood, especially when regarded as a construction material.\\n(Source: CED)"], "wood": ["An area where trees grow, where there are, no streets, no buildings, no agriculture beyond growing trees.", "A dense growth of trees more extensive than a grove and smaller than a forest.", "The substance making up the central part of the trunk and branches of a tree. Used as a material for construction, to manufacture various items, etc. or as fuel."], "woodland clearance": ["The permanent clear-felling of an area of forest or woodland."], "wood preservation": ["The use of chemicals to prevent or retard the decay of wood, especially by fungi or insects; widely used preservatives include creosote, pitch, sodium fluoride and tar; especially used on wood having contact with the ground."], "wood waste": ["Waste which is left over after the processing of raw timber.\\n(Source: ISEP)"], "wool": ["The soft, curly hair that forms the fleece of sheep, lamas and other animals and which is used to produce clothing."], "work accident": ["Accident occurring in the course of the employment and caused by inherent or related factors arising from the operation of materials of one's occupation."], "working condition": ["All existing circumstances affecting labor in the workplace, including job hours, physical aspects, legal rights and responsibilities."], "working hours": ["The time devoted to gainful employment or job-related activities, usually calculated as hours per day or per week."], "workplace": ["Any or all locations or environments where people are employed."], "world": ["The Earth with all its inhabitants and all things upon it.", "The third planet (counted from the center) of our solar system.", "Everything that exists anywhere.", "Social context of a person.", "Human collective existence.", "A planet,especially one which is inhabited or inhabitable.", "A great amount.", "A state or place of existence other than that on Earth.", "A state or place of existence other than that of contemporary life."], "world heritage site": ["Site of great cultural significance and geographic areas of outstanding universal value, for example the Pyramids of Egypt, the historical centre of Rome, the Grand Canyon of United States, Venice, the Taj Mahal of India, the Great Wall of China.\\n(Source: GILP96)"], "write-off": ["Accounting procedure that is used when an asset is uncollectible and is therefore charged-off as a loss."], "X ray": ["Short wavelength electromagnetic wave usually produced by bombarding a metal target in a vacuum."], "yeast": ["Many species of unicellular fungi, most of which belong to the Ascomycetes and reproduce by budding. The genus Saccharomyces is used in brewing and winemaking because in low oxygen concentration it produces zymase, an enzyme system that breaks down sugars to alcohol and carbon dioxide. Saccharomyces is also used in bread-making. Some yeasts are used as a source of protein and of vitamins of the B group.\\n(Source: ALL)"], "infant": ["A young child in the first years of life.\\n(Source: ISEP)"], "youth": ["The state of being young."], "youth work": ["Job opportunities and employment for adolescents, either for financial reward or educational enrichment.\\n(Source: RHW)"], "zinc": ["Chemical element with symbol Zn and atomic number 30; a brittle bluish-white metallic element that becomes coated with a corrosion-resistant layer in moist air and occurs chiefly in sphalerite and smithsonite.", "To cover with zinc."], "zoning": ["Designation and reservation under a master plan of land use for light and heavy industry, dwellings, offices, and other buildings."], "zoological garden": ["Area in which animals, especially wild animals, are kept so that people can go and look at them, or study them."], "zoology": ["The study of animals, including their classification, structure, physiology, and history."], "zoonosis": ["Infectious disease that is able to be transmitted from animals to humans or from humans to animals."], "accounting": ["Method of recording all the transactions affecting the financial condition of a business or organization."], "animal life": ["All of the animal life of any particular region or time."], "consumer product": ["Economic good that directly satisfies human wants or desires.\\n(Source: WEBSTE)"], "human body": ["The entire physical structure of an human being."], "human science": ["Group of sciences including sociology, anthropology, psychology, pedagogy, etc. as opposed to the humanistic group."], "juridical act": ["An act relating to the administration of justice."], "physical chemistry": ["A science dealing with the effects of physical phenomena on chemical properties.\\n(Source: LEE)"], "plant life": ["The plants that inhabit a certain region or environment."], "risk management": ["The process of evaluating and selecting alternative regulatory and non-regulatory responses to prepare for the probability of an accidental occurrence and its expected magnitude of damage, including the consideration of legal, economic and behavioral factors.\\n(Source: HMD / TOE)"], "safety system": ["A unified, coordinated assemblage or plan of procedures and devices intended to lower the occurrence or risk of injury, loss and danger to persons, property or the environment.\\n(Source: OED / RHW)"], "social science": ["The study of society and of the relationship of individual members within society, including economics, history, political science, psychology, anthropology, and sociology."], "promotion of trade and industry": ["Any activity that encourages or supports the buying, selling or exchanging of goods or services with other countries, which could include marketing, diplomatic pressure or the provision of export incentives such as credits and guarantees, government subsidies, training and consultation or advice."], "masonry": ["A construction of stone or similar materials such as concrete or brick.", "Worldwide widespread movement for humanitarianism which gives its supporters an understanding of the ideal of the noble humanity.", "A widespread secret fraternal order whose members pledge mutually assistance and brotherly love."], "sand flat": ["A flat, marshy or barren tract of land that is alternately covered and uncovered by the tide, and consisting of unconsolidated sediment (mostly mud and sand)."], "animal species": ["Species belonging to the animal kingdom."], "plant species": ["Species belonging to the plant kingdom."], "occupation": ["Productive activity, service, trade, or craft for which one is regularly paid.", "Task with which one occupies oneself.", "A situation where a country or region is under the control of a foreign army."], "folk tradition": ["The common beliefs, practices, customs and other cultural elements of an ethnic or social group that are rooted in the past, but are persisting into the present due to means such as arts and crafts, songs and music, dance, foods, drama, storytelling and certain forms of oral communication.\\n(Source: VFP)"], "law branch": ["A subdivision of the body of principles and regulations established by a government or other authority, generally defined by its scope or application.\\n(Source: BLD / ISEP)"], "judicial system": ["Entire network of courts in a particular jurisdiction."], "measuring instrument": ["Instrument that shows the extent or amount or quantity or degree of something."], "major risk": ["The high probability that a given hazard or situation will yield a significant amount of lives lost, persons injured, damage to property , disruption of economic activity or harm to the environment; or any product of the probability of occurrence and the expected magnitude of damage beyond a maximum acceptable level.\\n(Source: TOE / HMD)"], "rescue system": ["Any series of procedures and devices used by trained personnel to provide immediate assistance to persons who are in danger or injured.\\n(Source: GT2 / HMD)"], "tax system": ["A co-ordinated body of methods or plan of procedures for levying compulsory charges for the purpose of raising revenue."], "forest ecology": ["The science that deals with the relationship of forest trees to their environment, to one another, and to other plants and to animals in the forest."], "urban ecology": ["Concept derived from biology in which the city is viewed as a total environment, as a life-supporting system for the large number of people concentrated there, and within this people organize themselves and adapt to a constantly changing environment. Regarded as the same as human ecology.\\n(Source: GOOD)"], "ecozone": ["A broad geographic area in which there are distinctive climate patterns, ocean conditions, types of landscapes and species of plants and animals."], "environmental engineering": ["Branch of engineering concerned with the environment and its proper management. The major environmental engineering disciplines regard water supply, wastewater, stormwater, solid waste, hazardous waste, noise radiology, industrial hygiene, oceanography and the like.\\n(Source: PORT)"], "altitude": ["In general, a term used to describe a topographic eminence.\\n(Source: WHIT)", "A specific altitude or height above a given level.", "The angle between the horizontal and a point at a higher level (in surveying)."], "cove": ["A deep recess hollow, or nook in a cliff or steep mountainside, or a small, straight valley extending into a mountain or down a mountainside.\\n(Source: BJGEO /  WHIT)", "A valley or portion of lowland that penetrates into a plateau or mountain front.\\n(Source: BJGEO /  WHIT)"], "canyon": ["A long deep, relatively narrow steep-sided valley confined between lofty and precipitous walls in a plateau or mountainous area, often with a stream at the bottom; similar to, but largest than, a gorge. It is characteristic of an arid or semiarid area (such as western U.S.) where stream downcutting greatly exceeds weathering.\\n(Source: BJGEO)", "A valley, especially a long, narrow, steep valley, cut in rock by a river."], "geographic circque": ["A deep steep-walled half-bowl-like recess or hollow, variously described as horseshoe- or crescent-shaped or semi-circular in plan, situated high on the side of a mountain and commonly at the head of a glacial valley and produced by the erosive activity of a mountain glacier. It often contains a small round lake, and it may or may not be occupied by ice or snow.\\n(Source: BJGEO)"], "continent": ["A protuberance of the Earth's crustal shell, with an area of several million square miles and sufficient elevation so that much of it above sea level."], "creek": ["A narrow inlet or bay, especially of the sea.\\n(Source: CED)"], "fault": ["A fracture or a zone of fractures along which there has been displacement of the sides relative to one another parallel to the fracture.", "A wrong action attributable to bad judgment or ignorance or inattention.", "An imperfection in a device or machine.", "Wrong act done deliberately or good act omitted deliberately.", "An incorrect action not made deliberately."], "cliff": ["A steep coastal declivity which may or may not be precipitous, the slope angle being dependent partly on the jointing, bedding and hardness of the materials from which the cliff has been formed, and partly on the erosional processes at work. Where wave attack is dominant the cliff-foot will be rapidly eroded and cliff retreat will take place, especially in unconsolidated materials such as clays, sands, etc., frequently leaving behind an abrasion platform at the foot of the cliff.\\n(Source: WHIT)"], "open sea": ["The high seas lying outside the exclusive economic zones of states. All states have equal rights to navigate, to overfly, to lay submarine cables, to construct artificial islands, to fish, and to conduct scientific research within the high seas.\\n(Source: GOOD)"], "coral reef lagoon": ["A coastal stretch of shallow saltwater virtually cut off from the open sea by a coral reef.\\n(Source: WHIT)"], "river bed": ["The channel containing or formerly containing the water of a river."], "barrier reef": ["An elongated accumulation of coral lying at low-tide level parallel to the coast but separated from it by a wide and deep lagoon or strait."], "marine park": ["A permanent reservation on the seabed for the conservation of species."], "reserve": ["Any area of land or water that has been set aside for a special purpose, often to prevent or reduce harm to its wildlife and ecosystems.\\n(Source: RHW / DOE)", "To arrange for (something for someone else) in advance.", "To give or assign a resource to a particular person or cause.", "To assign a resource to a particular person or cause."], "alignment": ["The selection and detailed layout of public transport routes in the light of construction, operation, service, technology, and economic criteria.", "The spatial property possessed by an arrangement or position of things in a straight line or in parallel lines."], "bocage": ["The wooded countryside characteristic of northern France, with small irregular-shaped fields and many hedges and copses. In the French language the word bocage refers both to the hedge itself and to a landscape consisting of hedges. Bocage landscapes usually have a slightly rolling landform, and are found mainly in maritime climates. Being a small-scale, enclosed landscape, the bocage offers much variations in biotopes, with habitats for birds, small mammals, amphibians, reptiles and butterflies."], "French formal garden": ["A style of garden displaying symmetry and geometrical patterns."], "English garden": ["A plot of ground consisting of an orderly and balanced arrangement of masses of flowers, shrubs and trees, following British traditions or style.\\n(Source: CBO)"], "site protection": ["Precautionary actions, procedures or installations undertaken to prevent or reduce harm to the environmental integrity of a physical area or location."], "coast protection": ["A form of environmental management designed to allay the progressive degradation of the land by coastal erosion processes."], "environmental citizenship": ["The state, character or behavior of a person viewed as a member of the ecosystem with attendant rights and responsibilities, especially the responsibility to maintain ecological integrity and the right to exist in a healthy environment.\\n(Source: TOE / RHW)"], "sponsorship": ["A person, firm, organization, etc. that provides or pledges money for an undertaking or event."], "migratory fish": ["Fishes that migrate in a body, often between breeding places and winter feeding grounds.\\n(Source: RRDA)"], "marine mammal": ["A diverse group of roughly 120 species of mammal that are primarily ocean-dwelling or depend on the ocean for food.", "Mammal which is adapted to live in the sea, such as whales, dolphins, porpoises, etc."], "ovine": ["Horned ruminant mammals raised in many breeds for wool, edible flesh, or skin."], "shelter": ["Cover or protection, as from weather or danger; place of refuge.\\n(Source: CED)", "A refuge, haven or other cover or protection from something.", "To take cover.", "To provide cover.", "A shielding or protection against the unpleasant, unwanted, or dangerous."], "nesting area": ["A place where birds gather to lay eggs."], "spawning ground": ["Area of water where fish come each year to produce their eggs."], "nesting": ["The building of nests for egg laying and rearing of offspring."], "animal population": ["A group of animals inhabiting a given area.\\n(Source: CED)"], "animal reproduction": ["Any of various processes, either sexual or asexual, by which an animal produces one or more individuals similar to itself."], "survival": ["The act or fact of surviving or condition of having survived."], "endemic species": ["Species native to, and restricted to, a particular geographical region."], "broad-leaved tree": ["Deciduous tree which has wide leaves, as opposed to the needles on conifers.\\n(Source: PHC)"], "sea grass bed": ["Seaweeds communities formed by green, brown and red macroscopic algae and by sea phanerogams such as Posidonia oceanica and Zostera noltii, etc."], "macrophyte": ["A large macroscopic plant, used especially of aquatic forms such as kelp (variety of large brown seaweed which is a source of iodine and potash).\\n(Source: LBC /  PHC)"], "riverside vegetation": ["Plants growing in areas adjacent to rivers and streams."], "chestnut": ["Any north temperate fagaceous tree of the genus Castanea, such as Castanea sativa, which produce flowers in long catkins and nuts in a prickly bur.", "The nut of the chestnut tree."], "vegetation level": ["A subdivision of vegetation characteristic of a certain altitude above sea level at a given latitude.\\n(Source: ECHO2)"], "plant population": ["The number of plants in an area."], "arboretum": ["Collection of trees from different parts of the world, grown for scientific study."], "chorology": ["The study of the causal relations between geographical phenomena occurring within a particular region."], "botanical conservatory": ["Gardens for the conservation of rare species of plants.\\n(Source: RAMADE)"], "plant heritage": ["The sum of the earth's or a particular region's herb, vegetable, shrub and tree life viewed as the inheritance of the present generation, especially plant species deemed worthy of preservation and protection from extinction.\\n(Source: PPP / OED)"], "pruning": ["The cutting off or removal of dead or living parts or branches of a plant to improve shape or growth."], "mountain forest": ["An extensive area of woodland that is found at natural elevations usually higher than 2000 feet."], "state forest": ["Forest owned and managed by the State."], "Mediterranean forest": ["Type of forest found in the Mediterranean area comprising mainly xerophilous evergreen trees."], "private forest": ["A privately owned forest."], "maquis": ["A low evergreen shrub formation, usually found on siliceous soils in the Mediterranean lands where winter rainfall and summer drought are the characteristic climate features."], "nursery garden": ["A place where plants are propagated and nurtured until they reach a size appropriate for replanting at another location."], "forest protection": ["Branch of forestry concerned with the prevention and control of damage to forests arising from the action of people or livestock, of pests and abiotic agents."], "resinous plant": ["A plant yielding or producing resin."], "big game": ["Large wild animals that weigh typically more than 30 lb when fully grown, hunted for food, sport or profit."], "shellfish farming": ["Raising of shellfish in inland waters, estuaries or coastal waters, for commercial purposes."], "oyster farming": ["Raising oysters for human consumption."], "competitive examination": ["A test given to a candidate for a certificate or a position and concerned typically with problems to be solved, skills to be demonstrated, or tasks to be performed."], "initial training": ["Any education, instruction or discipline occurring at the beginning of an activity, task, occupation or life span."], "pedagogy": ["The principles, practice, or profession of teaching.\\n(Source: CED)", "Science on education and teaching."], "cycle path": ["Part of the road or a special path for the use of people riding bicycles."], "ski run": ["A trail, slope, or course for skiing."], "ecomuseum": ["A private, non-profit facility where plants and animals can be viewed in a natural outdoor setting.\\n(Source: AGRENV)"], "folklore": ["The traditional and common beliefs, practices and customs of a people, which are passed on as a shared way of life, often through oral traditions such as folktales, legends, anecdotes, proverbs, jokes and other forms of communication.\\n(Source: VFP)"], "country lodge": ["A small house or a hut located in the countryside."], "lodging": ["Provision of accommodation for rest or for residence in a room or rooms or in a dwelling place."], "public": ["The community or people in general or a part or section of the community grouped because of a common interest or activity.\\n(Source: CED)"], "path": ["A route or track between one place to another.", "The direction of movement, line or route of a vessel at any given moment."], "educational path": ["A guided trail, designed to explain to children a piece of countryside, the type of soil, flora, fauna, etc. Such trails may be self-guiding, using either explanatory notices set up at intervals or numbered boards referring to a printed leaflet: in other cases parties may be led by a demonstrator or warden.\\n(Source: GOOD)"], "seaside resort": ["A place near the sea where people spend their holidays and enjoy themselves."], "winter sports resort": ["Resort where sports held in the open air on snow or ice, especially skiing are practiced."], "all-terrain vehicle": ["A land carriage so constructed that it can be used on any kind of road or rough terrain and can be operated for many purposes, such as carrying goods, transporting the injured, conveying passengers, etc."], "population density": ["The number of people relative to the space occupied by them."], "young": ["Living being as genetically proceeding from an other one.", "The offspring or descendants of an animal (in some languages, it is used to refer to humans).", "In the early part of growth or life."], "active population": ["The number of people available and eligible for employment within a given enterprise, region or nation."], "time allocation": ["The act of assigning various hours of one's day, week or year to particular activities, especially those falling within the categories of work and leisure."], "goods": ["A term of variable content and meaning. It may include every species of personal chattels or property. Items of merchandise, supplies, raw materials, or finished goods. Land is excluded."], "goods and services": ["The total of economic assets, including both physical or storable objects and intangible acts of human assistance."], "time budget": ["Determining or planning for allotment of time in hours, days, weeks, etc.\\n(Source: RHW)"], "living environment": ["External conditions or surroundings in which people live or work."], "product life cycle": ["A product life cycle includes the following phases: acquisition of raw materials, production, packaging, distribution, use, recyling, and disposal."], "quality certification": ["The formal assertion in writing that a commodity, service or other product has attained a recognized and relatively high grade or level of excellence.\\n(Source: BLD / RHW)"], "living standard": ["A measurement of the development level in a country or community, gauged by factors such as personal income, education, life expectancy, food consumption, health care, technology and the use of natural resources.\\n(Source: TEX)"], "supply and demand": ["The relationship between the amount or quantity of a commodity that is available for purchase and the desire or ability of consumers to buy or purchase the commodity, which, in theory, determines the commodity's price in a free market.\\n(Source: MGHME)"], "ecological inequality": ["Any imbalance or disparity among inhabitants of the same living environment deemed inappropriate, unjust or detrimental to that environment's integrity.\\n(Source: TOE / RHW)"], "social inequality": ["Unequal rewards or opportunities for different individuals within a group or groups within a society. If equality is judged in terms of legal equality, equality of opportunity, or equality of outcome, then inequality is a constant feature of the human condition."], "myth": ["A traditional or legendary story, usually dealing with supernatural beings, ancestors, heroes or events, that is with or without determinable basis of fact or a natural explanation, but is used to explain some practice, rite or phenomenon of nature, or to justify the existence of a social institution."], "social psychology": ["Study of the effects of social structure on cognition and behavior, of processes of face-to-face interaction, and of the negotiation of social order."], "feeling for nature": ["A consciousness, sensibility or sympathetic perception of the physical world and its scenery in their uncultivated state."], "socioeconomics": ["The study of the interaction between society and economy."], "administrative deed": ["Any formal and legitimate step taken or decision made on matters of policy by a chief or other top-level officer within an organization.\\n(Source: DAM)"], "territorial government": ["An administrative body or system in which political direction or control is exercised over a designated area or an administrative division of a city, county or larger geographical area.\\n(Source: RHW / BLD)"], "citizen": ["A native or naturalized member of a state or nation who owes allegiance, bears responsibilities and obtains rights, including protection, from the government."], "parliamentary debate": ["Formal discussion or dispute on a particular matter among the members of the parliament."], "subsidiary principle": ["The fundamental doctrine or tenet that policy making decisions should be made at the most decentralized level, in which a centralized governing body would not take action unless it it is more effective than action taken at a lower government level."], "national accounting": ["Organised method of recording all business transactions in the national economy."], "satellite account": ["A separate financial record or statement that discloses financial activity in a particular area and supplements existing financial records.\\n(Source: RHW)"], "household expenditure": ["Any spending done by a person living alone or by a group of people living together in shared accommodation and with common domestic expenses.\\n(Source: ODE)"], "intervention fund": ["Money or financial resources set aside to interpose or interfere in any business affair in order to affect an outcome.\\n(Source: OED)"], "financial fund": ["Monetary resources set aside for some purpose."], "International Monetary Fund": ["An international organization established in 1944, affiliated with the United Nations that acts as an international bank facilitating the exchange of national currencies and providing loans to member nations."], "gross domestic product": ["The total output of goods and services produced by a national economy in a given period, usually a year, valued at market prices. It is gross, since no allowance is made, for the value of replacement capital goods.", "A measure of the economic production of a particular territory in financial capital terms over a specific time period."], "process analysis": ["The examination of a process to understand it and therefore develop ideas for its improvement."], "audit": ["The periodic or continuous verification of the accounts, assets and liabilities of a company or other organization, often to confirm compliance with legal and professional standards.", "To conduct an independent review and examination of system records and activities in order to test the adequacy and effectiveness of data security and data integrity procedures, to ensure compliance with established policy and operational procedures, and to recommend any necessary changes."], "water cost": ["The value or the amount of money exchanged for the production and sustained supply of water.\\n(Source: EFP / RHW)"], "ecomarketing": ["The marketing of products that are presumed to be environmentally safe."], "market study": ["The gathering and studying of data to determine the projection of demand for an item or service."], "free trade": ["Trade which is unimpeded by tariffs, import and export quotas and other measures which obstruct the free movement of goods and services between states."], "calculation": ["The act, process or result of calculating.\\n(Source: CED)"], "density": ["The mass of a substance per unit volume."], "index": ["A list of record surrogates arranged in order of some attribute expressible in machine-orderable form.\\n(Source: MGH)"], "census survey": ["An official periodic count of a population including such information as sex, age, occupation, etc."], "statistical series": ["An ordered sequence of data samples in numerical form used to predict or demonstrate trends through time and space."], "opinion survey": ["The canvassing of a representative sample of a large group of people on some question in order to determine the general opinion of a group."], "rate": ["The amount of change in some quantity during a time interval divided by the length of the time interval."], "seasonal variation": ["In time series, that part of the movement which is assigned to the effect of the seasons on the year."], "scientific committee": ["An organized group of persons elected or appointed to discuss scientific matters."], "applied research": ["Research directed toward using knowledge gained by basic research to make things or to create situations that will serve a practical or utilitarian purpose.\\n(Source: MGH)"], "scientific research": ["Systematic investigation to establish facts or principles concerning a specific scientific subject."], "agronomy": ["The principles and procedures of soil management and of field crop and special-purpose plant improvement, management, and production."], "agrosystem": ["Ecosystem dominated by the continuous agricultural intervention of man."], "crop treatment": ["Use of chemicals in order to avoid damage of crops by insects or weeds.\\n(Source: WRIGHTa)"], "aviculture": ["The raising, keeping, and care of birds."], "transhumance": ["The seasonal migration of livestock to suitable grazing grounds."], "mineral conditioner": ["Any naturally occurring inorganic substances with a definite chemical composition and usually of crystalline structure, such as rocks, which are used to stabilize soil, improving its resistance to erosion, texture and permeability.\\n(Source: RHW / SOI)"], "slash and burn culture": ["A traditional farming system that has been used by generations of farmers in tropical forests and the savannah of north and east Africa. It is known to be an ecologically sound form of cultivation, and because the soil is poor in tropical rain forests it is a sustainable method of farming. It is still practised today, primarily in the developing countries. Small areas of bush or forests are cleared and the smaller trees burned. This unlocks the nutrients in the vegetation and gives the soil fertilizer that is easily taken up by plants. A few years later the soil is degraded and the farmer moves on to do the same at another site. The original ground is left fallow for anything up to 20 years so that the forest can regenerate. With the growth in population and in the subsequent need for more farming land to produce food, the method is increasingly being used today to clear large areas of tropical forests for cattle ranching, and in most cases the ground is not left fallow for long enough and, with modern mechanized farming systems, not enough tree stumps or suitable habitats for plant life are left to start the regeneration process.\\n(Source: WRIGHT)"], "chalk": ["A soft, pure, earthy, fine-textured, usually white to light gray or buff limestone of marine origin, consisting almost wholly (90-99%) of calcite.", "A writing implement (made of white or coloured chalk) that leaves an impression through being divided into a powder or paste that sticks to the surface."], "organic matter": ["Plant and animal residue that decomposes and becomes a part of the soil."], "drainage system": ["A surface stream, or a body of impounded surface water, together with all other such streams and water bodies that are tributary to it and by which a region is drained. An artificial drainage system includes also surface and subsurface conduits."], "irrigation system": ["A system of man-made channels for supplying water to land to allow plants to grow."], "soil salinity": ["Measurement of the quantity of mineral salts found in a soil. Many semi-arid and arid areas are naturally salty. By definition they are areas of substantial water deficit where evapotranspiration exceeds precipitation. Thus, whereas in humid areas there is sufficient water to percolate through the soil and to leach soluble materials from the soil and the rocks into the rivers and hence into the sea, in deserts this is not the case. Salts therefore tend to accumulate.\\n(Source: PHC /  GOUD)"], "approach": ["The way or means of entry or access.", "The method, orientation, way of thought in which one takes up a subject, a problem, an argument etc.", "The act of drawing spatially closer to something.", "To begin to deal with, e.g., a task, a problem, etc.", "To come near to; to move towards.", "To come near or verge on, resemble, come nearer in quality, or character.", "To make advances to someone, usually with a proposal or suggestion.", "To come near in time."], "railway station": ["A place along a route or line at which a train stops to pick up or let off passengers or goods, especially with ancillary buildings and services.", "A building in or at which trains stop."], "bus station": ["A place along a route or line at which a bus stops for fuel or to pick up or let off passengers or goods, especially with ancillary buildings and services.\\n(Source: CED)"], "railway network": ["The whole system of railway distribution in a country."], "road network": ["The system of roads through a country."], "navigation": ["The science or art of conducting ships or aircraft from one place to another, esp. the method of determining position, course, and distance travelled over the surface of the earth by the principles of geometry and astronomy and by reference to devices (as radar beacons or instruments) designed as aids.", "The transport and movement of goods, people and animals over water."], "merchant shipping": ["Transportation of persons and goods by means of ships travelling along fixed navigation routes.\\n(Source: ZINZANa)"], "combined transport": ["Transport in which more than one carrier is used, e.g. road, rail and sea."], "periurban space": ["Any expanse of land or region located on the outskirts of a city or town.\\n(Source: RHW)"], "single family dwelling": ["An unattached dwelling unit inhabited by an adult person plus one or more related persons."], "traditional architecture": ["Methods of construction which use locally available resources to address local needs."], "building destruction": ["The tearing down of buildings by mechanical means."], "building restoration": ["The accurate reestablishment of the form and details of a building, its artifacts, and the site on which it is located, usually as it appeared at a particular time."], "ISO standard": ["Documented agreements containing technical specifications or other precise criteria to be used consistently as rules, guidelines, or definitions of characteristics, to ensure that materials, products, processes and services are fit for their purpose.\\n(Source: ISOCH)"], "technical regulation": ["A government or management prescribed rule that provides detailed or stringent requirements, either directly or by referring to or incorporating the content of a standard, technical specification or code of practice.\\n(Source: PVG)"], "codification": ["The process of collecting and arranging systematically, usually by subject, the laws of a state or country, or the rules and regulations covering a particular area or subject of law or practice."], "animal rights": ["Just claims, legal guarantees or moral principles accorded to sentient, non-human species, including freedom from abuse, consumption, experimentation, use as clothing or performing for human entertainment."], "citizen rights": ["Rights recognized and protected by law, pertaining to the members of a state.\\n(Source: ZINZANa)"], "notice": ["Factual information, advice or a written warning communicated to a person by an authorized source, often conveyed because of a legal or administrative rule requiring transmission of such information to all concerned parties.", "To pay attention and perceive something.", "A sign posted in a public place as an advertisement.", "To see, discover or determine something, unclear, distant or hidden, by looking carefully.", "Advance notification (usually written) of the intention to withdraw from an arrangement of contract.", "To make or write a comment on."], "order": ["A direction or command of a court. In this sense it is often used synonymously with judgment.", "The document bearing the seal of the court recording its judgment in a case.", "To express as instruction to be executed by the receiver, in accordance with an authority acknowledged by him.", "A biological taxon, a group of species, part of a class and consisting of one or more families", "A formal association of people with similar interests.", "That which is enjoined or ordered to one or several persons by a superior authority.", "A condition of regular or proper arrangement.", "A command given by a superior (e.g., a military or law enforcement officer) that must be obeyed.", "A group of person living under a religious rule.", "A degree in a continuum of size or quantity.", "To place a request for goods at a company.", "To give instructions to or direct somebody to do something with authority."], "building permit": ["Authorization required by local governmental bodies for the erection of an enclosed structure or for the major alteration or expansion of an existing edifice."], "law draft": ["The form in which proposed statutes, resolutions or special acts are introduced into a legislative body, before they are enacted or passed."], "regulation": ["A specification of behavior used as an authoritative guide for conduct.", "The act of regulating; a rule or order prescribed for management or government; a regulating principle; a precept. Rule of order prescribed by superior or competent authority relating to action on those under its control."], "concession": ["Any rebate, abatement, voluntary grant of or a yielding to a demand or claim, typically made by a government or controlling authority to an individual or organization.\\n(Source: BLD)"], "declaration of public utility": ["Administrative Act giving the right to take private property for public use.\\n(Source: BLACKa)"], "public inquiry": ["An investigation, especially a formal one conducted into a matter of public utility by a body constituted for that purpose by a government, local authority, or other organization."], "easement": ["The rights of use over the property of someone else; a burden on a piece of land causing the owner to suffer access by another."], "crime": ["Any act done in violation of those duties which an individual owes to the community, and for the breach of which the law has provided that the offender shall make satisfaction to the public.\\n(Source: BLACK)"], "criminal law procedure": ["The rules of law governing the procedure by which crimes are investigated, prosecuted, adjudicated, and punished.\\n(Source: BLACK)"], "conflict": ["A state of opposition or disagreement between ideas, interests, etc."], "litigation": ["A judicial contest, a judicial controversy, a suit at law.\\n(Source: BLACK)"], "justice": ["The correct application of law as opposed to arbitrariness."], "trial": ["A judicial examination and determination of issues between parties to action; whether they need issues of law or of fact. A judicial examination, in accordance with law of the land, of a cause, either civil or criminal, of the issues between the parties, whether of law or fact, before a court that has proper jurisdiction.", "Grammatical number related to precisely 3 objects of the same type"], "court": ["An organ of the government, belonging to the judicial department, whose function is the application of the laws to controversies brought before it and the public administration of justice.", "The residence of a sovereign.", "The actual enclosed space in which a judge regularly holds court.", "To engage in behavior leading to mating.", "To engage in activities intended to win someone's affections."], "lease": ["Agreement which gives rise to relationship of landlord and tenant (real property) or lessor and lessee (real or personal property). Contract for exclusive possession of lands or tenements for determinate period. Contract for possession and profits of lands and tenements either for life, or for certain period of time, or during the pleasure of the parties.", "To hold under a lease or rental agreement of goods and services.", "A contract granting use or occupation of property during a specified period in exchange for a specified rent.", "The period of a lease.", "To operate or live in some property or land through a long-term contract from the owner.", "To take or hold by lease.", "To grant a lease.", "To let for money."], "certification": ["The formal assertion in writing of some fact.", "A procedure by which a third party gives written assurance that a product, process or service conforms to specified requirements.\\n(source: ISO/IEC Guide 2:1996)"], "homologation": ["The granting of approval by an official authority."], "pre-emption": ["The right of first refusal to purchase land in the event that the grantor of the right should decide to sell."], "prescription": ["Acquisition of rights to the property caused by reason of continuous and prolonged use.", "A written description by a physician of medicine and dosage."], "repression": ["The act, as by power or authority, of arresting or inhibiting the communication of ideas or facts as expressed in a practice, movement, publication or piece of evidence in a court proceeding.", "The psychological act of excluding desires and impulses (wishes, fantasies or feelings) from one's consciousness and attempting to hold or subdue them in the subconscious. (source: Wikipedia)", "The persecution of an individual or group for political reasons, particularly for the purpose of restricting or preventing their ability to take part in the political life of society."], "devolution": ["The act of assigning or entrusting authority, powers or functions to another as deputy or agent, typically to a subordinate in the administrative structure of an organization or institution."], "biomarker": ["A normal metabolite that, when present in abnormal concentrations in certain body fluids, can indicate the presence of a particular disease or toxicological condition."], "quality objective": ["Any goal or target established for a product, service or endeavor that aspires to attain a relatively high grade or level of excellence."], "solid particle": ["Any tiny or very small mass of material that has a definite volume and shape and resists forces that would alter its volume or shape."], "sensor": ["The generic name for a device that senses either the absolute value or a change in a physical quantity such as temperature, pressure, flow rate, or pH, or the intensity of light, sound, or ratio waves and converts that change into a useful input signal for an information-gathering system."], "instrumentation": ["Designing, manufacturing, and utilizing physical instruments or instrument systems for detection, observation, measurement, automatic control, automatic computation, communication, or data processing."], "metrology": ["The science of measurement."], "observation satellite": ["Man-made device that orbits the earth, receiving, processing and transmitting signals and generating images such as weather pictures."], "atrazine": ["Herbicide belonging to the triazine group, widely employed and particularly in maize crops."], "organic nitrogen": ["Essential nutrient of the food supply of plants and the diets of animals. Animals obtain it in nitrogen-containing compounds, particularly aminoacids. Although the atmosphere is nearly 80% gaseous nitrogen, very few organisms have the ability to use it in this form. The higher plants normally obtain it from the soil after microorganisms have converted the nitrogen into ammonia or nitrates, which they can then absorb. This conversion of nitrogen, known as nitrogen fixation, is essential for the formation of amino acids which, in turn, are the building blocks of proteins.\\n(Source: WRIGHT)"], "halogenated compound": ["A substance containing halogen atoms."], "pyralene": ["Chemical compound belonging to the polychlorinated biphenyls family, used in the production of electrical equipment which requires dielectric fluid such as power transformers and capacitors, as well as in hydraulic machinery, vacuum pumps, compressors and heat-exchanger fluids.\\n(Source: PZ)"], "asbestosis": ["A non-malignant progressive, irreversible, lung disease, characterized by diffuse fibrosis, resulting from the inhalation of asbestos fibers."], "genotoxicity": ["The action of chemical, physical and biological agents that damage DNA."], "intoxication": ["The state of being poisoned; the condition produced by a poison which may be swallowed, inhaled, injected, or absorbed through the skin.\\n(Source: KOREN)"], "total organic carbon": ["The amount of carbon covalently bound in organic compounds in a water sample."], "laboratory test": ["A test, examination or evaluation performed in a laboratory."], "biotic index": ["Scale for showing the quality of an environment by indicating the types of organisms present in it (e.g. how clean a river is)."], "photodegradation": ["The capability of being decomposed by prolonged exposure to light."], "insoluble substance": ["Substance incapable of forming a solution, especially in water."], "non-volatile substance": ["Substance that is not capable of changing from a solid or liquid form to a vapour.\\n(Source: CEDa)"], "volatile substance": ["A substance capable of readily changing from a solid or liquid form to a vapour; having a high vapour pressure and a low boiling point."], "chemical corrosivity": ["The tendency of a metal to wear away another by chemical attack.\\n(Source: MGH)"], "experimental study": ["Study based on experimentation."], "drawing": ["The visual representation of a person or an object.", "The act of creating an artistic picture, likeness, diagram or representation.", "A picture, likeness, diagram or representation, usually written on paper."], "organoleptic property": ["Property that can be perceived by sense organs"], "cardiovascular system": ["Those structures, including the heart and blood vessels, which provide channels for the flow of blood.", "The parts of a animal body comprising the heart, veins, capillaries and arteries."], "enterovirus": ["Any of a subgroup of the picornaviruses infecting the gastrointestinal tract and discharged in feces, including coxsackieviruses, echoviruses, and polioviruses; may be involved in respiratory disease, meningitis, and neurological disease.\\n(Source: KOREN)"], "animal biology": ["The scientific study of the natural processes of animals."], "plant biology": ["A branch of the biological sciences which embraces the study of plants and plant life."], "genetic pool": ["The total number of genes or the amount of genetic information possessed by all the reproductive members of a population of sexually reproducing organisms."], "hearing acuity": ["Effectiveness of hearing."], "decibel": ["A unit used to express relative difference on power, usually between acoustic or electric signals, equal to ten times the common logarithm of the ratio of the two level."], "acoustical quality": ["The characteristics of a confined space that determines its ability to enable music and speech to be heard clearly within it."], "airborne noise": ["Noise caused by the movement of large volumes of air and the use of high-pressure air."], "background noise": ["Noise coming from source other than the noise source being monitored."], "rolling noise": ["Deeply resounding, reverberating noise caused by the friction between car tyres and road surfaces."], "tidal power station": ["Power station where the generation of power is provided by the ebb and flow of the tides. The principle is that water collected at high tide behind a barrage is released at low tide to turn a turbine that, in turn, drives a generator."], "hydroelectric energy": ["The free renewable source of energy provided by falling water that drives the turbines. Hydropower is the most important of the regenerable energy sources because of its highest efficiency at the energy conversion. There are two types of hydroelectric power plants: a) run-of-river power plants for the use of affluent water; b) storage power plants (power stations with reservoir) where the influx can be regulated with the help of a reservoir. Mostly greater differences in altitudes are being used, like mountain creeks. Power stations with reservoirs are generally marked by barrages with earth fill dam or concrete dams. Though hydropower generally can be called environmentally acceptable, there exist also some problems: a) change of groundwater level and fill up of the river bed with rubble. b) Risk of dam breaks. c) Great demand for land space for the reservoir. d) Diminution, but partly also increase of value of recreation areas. As the hydropowers of the world are limited, the world energy demand however is rising, finally the share of hydropower will decrease.\\n(Source: PORT /  PHC /  PZ)"], "water mill": ["A mill whose power is provided by a large wheel which is turned by moving water, especially a river."], "radioelement": ["An element that is naturally radioactive."], "fast reactor": ["Nuclear reactor which produces more fissile material than it consumes, using fast-moving neutrons and making plutonium-239 from uranium-238, thereby increasing the reactor's efficiency."], "contaminated area": ["Any site or region that is damaged, harmed or made unfit for use by the introduction of unwanted substances, particularly microorganisms, chemicals, toxic and radioactive materials and wastes.\\n(Source: TOE / HMD)"], "atmospheric aerosol": ["Particulate matter suspended in the air. The particulate matter may be in the form of dusts, fumes, or mist. Aerosols in the atmosphere are the form in which pollutants such as smoke are dispersed.\\n(Source: LANDY /  PHC)"], "biofuel": ["A gaseous, liquid, or solid fuel that contains an energy content derived from a biological source."], "ethanol": ["A colorless liquid, miscible with water, used as a reagent and solvent.", "A flammable, colorless liquid which is used amongst others as solvent, disinfectant and intoxicant."], "clean air car": ["Vehicles that functions without emitting pollutants in the atmosphere."], "continental climate": ["A climate characterized by hot summers, cold winters, and little rainfall, typical of the interior of a continent."], "desert climate": ["A climate type which is characterized by insufficient moisture to support appreciable plant life; that is, a climate of extreme aridity."], "equatorial climate": ["Climate characterized by constant temperatures, abundant rainfall and a very short dry season."], "Mediterranean climate": ["A type of climate characterized by hot, dry, sunny summers and a winter rainy season; basically, this is the opposite of a monsoon climate. Also known as etesian climate."], "mountain climate": ["Very generally, the climate of relatively high elevations; mountain climates are distinguished by the departure of their characteristics from those of surrounding lowlands, and the one common basis for this distinction is that of atmospheric rarefaction; aside from this, great variety is introduced by differences in latitude, elevation, and exposure to the sun; thus, there exists no single, clearly defined, mountain climate. Also known as highland climate.\\n(Source: MGH)"], "oceanic climate": ["A regional climate which is under the predominant influence of the sea, that is, a climate characterized by oceanity; the antithesis of a continental climate."], "temperate climate": ["The climate of the middle latitudes; the climate between the extremes of tropical climate and polar climate."], "tropical climate": ["A climate which is typical of equatorial and tropical regions, that is, one with continually high temperatures and with considerable precipitation, at least during part of the year."], "thunderstorm": ["A storm caused by strong rising air currents and characterized by thunder and lightning and usually heavy rain or hail."], "glaze": ["A coating of ice, generally clear and smooth but usually containing some air pockets, formed on exposed objects by the freezing of a film of supercooled water deposited by rain, drizzle, or fog, or possibly condensed from supercooled water vapour."], "water table": ["Water that occupies pores, cavities, cracks and other spaces in the crustal rocks. It includes water precipitated from the atmosphere which has percolated through the soil, water that has risen from deep magmatic sources liberated during igneous activity and fossil water retained in sedimentary rocks since their formation. The presence of groundwater is necessary for virtually all weathering processes to operate. Phreatic water is synonymous with groundwater and is the most important source of any water supply.\\n(Source: WHIT)"], "hydrometry": ["The science and technology of measuring specific gravities, particularly of liquids."], "sedimentology": ["The scientific study of sedimentary rocks and of the processes by which they were formed."], "demesnial water": ["A body of water that is owned and maintained by a national governmental body or agency."], "bog": ["A stretch waterlogged, spongy ground, chiefly composed of decaying vegetable matter, especially of rushes, cotton grass, and sphagnum moss."], "water desalination": ["Any mechanical procedure or process where some or all of the salt is removed from water."], "swell": ["A regular movement of marine waves created by wind stress in the open ocean which travels considerable distances.", "To grow larger in volume.", "To grow larger in volume."], "river management": ["The administration or handling of a waterway or a stream of flowing water.\\n(Source: RHW)"], "flushing": ["Removing lodged deposits of rock fragments and other debris by water flow at high velocity; used to clean water conduits and drilled boreholes.\\n(Source: MGH)"], "canal lock": ["A chamber with gates on both ends connecting two sections of a canal or other waterway, to raise or lower the water level in each section."], "bank protection": ["Engineering work which aims at the protection of banks of a river, or slopes of embankments along it, from erosion by the current of flow, from floods, etc."], "retaining reservoir": ["Basin used to hold water in storage."], "water taste": ["Taste in water that can be caused by foreign matter, such as organic compounds, inorganic salts or dissolved gases."], "green tide": ["A proliferation of a marine green plankton toxic and often fatal to fish, perhaps stimulated by the addition of nutrients."], "water salinity": ["The degree of dissolved salts in water measured by weight in parts per thousand."], "catchment": ["A structure in which water is collected."], "fountain": ["A stream of water that is forced up into the air through a small hole, especially for decorative effect.", "An ornamental water feature consisting of one or more streams of water originating from a statue or other structure."], "separate sewer system": ["Sewer system having distinct pipes for collecting superficial water and sewage water."], "combined sewer system": ["A sewer intended to serve as a sanitary sewer and a storm sewer, or as an industrial sewer and a storm sewer."], "water aeration": ["Addition of air to sewage or water so as to raise its dissolved oxygen level."], "water regeneration": ["A process in which naturally occurring microorganisms, plants, trees or geophysical processes break down, degrade or filter out hazardous substances or pollutants from a body of water, cleansing and treating contaminated water without human intervention."], "water resources management": ["Measures and activities concerning the supply of water, the improvement of efficiency in its use, the reduction of losses and waste, water-saving practices to reduce costs and to slow the depletion of the water supply to ensure future water availability.\\n(Source: EARTH1a)"], "bulky waste": ["Large item of waste material, such as appliances, furniture, large auto parts, trees, branches, stumps, etc.\\n(Source: LANDY)"], "alkaline battery": ["A primary cell that uses an alkaline electrolyte, usually potassium hydroxide, and delivers about 1.5 volts at much higher current rates than the common carbon-zinc cell."], "electric battery": ["A direct-current voltage source made up of one or more units that convert chemical, thermal, nuclear, or solar energy into electrical energy."], "metal waste": ["Metal material discarded during manufacturing or processing operations which cannot be directly fed back into the operation."], "mineral waste": ["Waste material resulting from ore extraction that is usually left on the soil surface.\\n(Source: GREMES)"], "wreck": ["The hulk of a wrecked or stranded ship; a ship dashed against rocks or land and broken or otherwise rendered useless.\\n(Source: ISEP)"], "mineral oil": ["Oil which derives from petroleum and is made up of hydrocarbons."], "whey": ["The watery liquid that separates from the curd when the milk is clotted, as in making cheese."], "thickening": ["Any thickened enlargement.", "In cooking, the process of increasing the viscosity of a liquid either by reduction, or by the addition of a thickening agent, typically containing starch."], "industrial wasteland": ["Area of land which is no longer usable for cultivation or for any other purpose after having been the site of an industrial plant."], "quartering": ["The act of dismembering the carcass of an animal with the production of organic waste which if improperly disposed cause problems of pollution and fawl smells."], "piggery": ["A place where pigs are kept and reared."], "aggregate extraction": ["Extraction of crushed rock or gravel screened to sizes for use in road surfaces, concretes, or bituminous mixes."], "biofiltration": ["The distribution of settled sewage on a bed of inert granular material through which it is allowed to percolate. In doing so, the effluent is aerated thus allowing aerobic bacteria and fungi to reduce its biochemical oxygen demand.\\n(Source: PORT)"], "dechlorination": ["Removal of chlorine from a substance."], "engineering": ["The science by which the properties of matter and the sources of power in nature are made useful to humans in structures, machines, and products."], "aerobic treatment": ["The introduction of air into sewage so as to provide aerobic biochemical stabilization during a detention period.\\n(Source: KOREN)"], "primary treatment": ["Removal of floating solids and suspended solids, both fine and coarse, from raw sewage."], "vitrification": ["Formation of a glassy or noncrystalline material."], "underground quarry": ["Quarry located below the surface of the Earth."], "geotechnics": ["The application of scientific methods and engineering principles to civil engineering problems through acquiring, interpreting, and using knowledge of materials of the crust of the earth.\\n(Source: MGH)"], "rock mechanics": ["The theoretical and applied science of the physical behavior of rocks, representing a \"branch of mechanics concerned with the response of rock to the force fields of its physical environment\"."], "bush clearing": ["The removal of brush using mechanical means, either by cutting manually or by using machinery for crushing, rolling, flailing, or chipping it, or by chemical means or a combination of these.\\n(Source: DUNSTE)"], "flood protection": ["Precautionary measures, equipment or structures implemented to guard or defend people, property and lands from an unusual accumulation of water above the ground."], "volcanology": ["The branch of geology that deals with volcanism."], "civil safety": ["Actions and measures undertaken, often at a local level, to ensure that citizens of a community are secure from harm, injury, danger or risk.\\n(Source: RHW / OEC)"], "industrial safety": ["Measures or techniques implemented to reduce the risk of injury, loss and danger to persons, property or the environment in any facility or place involving the manufacturing, producing and processing of goods or merchandise."], "ecocatastrophe": ["A sudden, widespread disaster or calamity causing extensive damage to the environment that threatens the quality of life for people living in the affected area or region, potentially leading to many deaths."], "nuclear hazard": ["Risk or danger to human health or the environment posed by radiation emanating from the atomic nuclei of a given substance, or the possibility of an uncontrolled explosion originating from a fusion or fission reaction of atomic nuclei.\\n(Source: MHD / TOE)"], "disaster zone": ["An area that officially qualifies for emergency governmental aid as a result of a catastrophe, such as an earthquake or flood."], "damage insurance": ["A commercial product which provides a guarantee against damage to property in return for premiums paid."], "pollution insurance": ["A commercial agreement which provides protection against the risks, or a particular risk, associated with pollution, toxic waste disposal or related concerns.\\n(Source: RHW)"], "water damage": ["Damage caused by water, for example as a result of flooding or severe storms."], "appraisal": ["An expert or official valuation."], "compensation for damage": ["Equivalent in money or other form for a loss sustained for an injury, for property taken, etc."], "public institution": ["Institution for the management of public issues."], "patent": ["A grant of right to exclude others from making, using or selling one's invention and includes right to license others to make, use or sell it."], "press release": ["An official statement or announcement distributed to members of the media by a public relations firm, government agency or some other organization, often to supplement or replace an oral presentation."], "speech": ["An address or form of oral communication in which a speaker makes his thoughts and emotions known before an audience, often for a given purpose.\\n(Source: RHW)"], "cinematographic film": ["Any motion picture of a story, drama, episode or event, often considered as an art form or used as a medium for entertainment."], "documentary film": ["Any motion picture or movie in which an actual event, era or life story is presented factually, with little or no fiction."], "parliamentary report": ["A written account describing in detail observations or the results of an inquiry into an event or situation and presented to an official, deliberative body with legislative powers.\\n(Source: RHW)"], "statutory text": ["A document or a portion thereof expressing an official enactment of a legislative body, with emphasis on the document's precise wording or language.\\n(Source: RHW)"], "thesis": ["A treatise on a particular subject, in which original research has been done, in order to receive a doctoral degree."], "CD-ROM": ["A compact disc on which a large amount of digitalised read-only data can be stored."], "information network": ["A system of interrelated persons and/or devices linked to permit the exchange of data or knowledge.\\n(Source: ISEP /  RHW)"], "assay": ["Qualitative or quantitative determination of the components of a material, such as an ore or a drug."], "method": ["A way of proceeding or doing something, especially a systematic or regular one.", "A particular means of accomplishing something."], "groundwater quality": ["Groundwater accounts for over 95% of the earth's useable fresh-water resources; over half the world's population depends on groundwater for drinking-water supplies. This invisible resource is vulnerable to pollution and over-exploitation. Effective conservation of groundwater supplies requires the integration of land-use and water management.\\n(Source: GILP96)"], "ontogenesis": ["The entire sequence of events involved in the development of an individual organism."], "land tax": ["A tax laid upon the legal or beneficial owner of real property, and apportioned upon the assessed value of his land."], "open lawn": ["Any relatively unobstructed field of cultivated and mown grass, especially near a house or in a park."], "urban concentration": ["A process in which an increasing proportion of a country's population is concentrated in urban areas.\\n(Source: GOOD)"], "home garden": ["A plot of cultivated ground adjacent to a dwelling and usually devoted in whole or in part to the growing of herbs, fruits, flowers, or vegetables for household use."], "photography": ["The process of forming visible images directly or indirectly by the action of light or other forms of radiation on sensitive surfaces.", "The occupation of taking and printing photographs or making movies."], "bottle cap": ["A device used to seal the openings of bottles of many types."], "voting": ["The act of formally expressing an opinion or choice in some matter or for some candidate, usually by voice or ballot."], "budget policy": ["The programmatic use of a government's spending and revenue-generating activities to influence the economy and achieve specific objectives."], "international balance": ["A system in which nations or blocks of nations strive to maintain an equilibrium of power to prevent dominance by any single nation or to reduce conflict or the possibility of war."], "monetary economics": ["The study, policies or system of institutions and procedures by which a country or region's commerce is supplied with notes, coins, bank deposits or other equivalent mediums of exchange."], "free movement of capital": ["The unrestrained flow of cash, funds, and other means of wealth between countries with different currencies."], "economic geography": ["The geography of people making a living, dealing with the spatial patterns of production, distribution and consumption of goods and services. The development of economic geography over the past three decades has witnessed the substitution of analysis for description, leading to an identification of the factors and an understanding of the processes affecting the spatial differentiation of economic activities over the earth's surface.\\n(Source: GOOD)"], "credit": ["The financial facility or system by which goods and services are provided in return for deferred, instead of immediate, payment.", "(accounting) To attribute a credit (to an account).", "To give someone credit for something.", "To ascribe an achievement to.", "Approval.", "Money available for a client to borrow.", "A short note recognizing a source of information or of a quoted passage."], "freedom": ["The quality or state of being free, especially to enjoy political and civil liberties.\\n(Source: CED)", "The condition of being free to act, believe or express oneself as one chooses."], "fodder plant": ["A plant used to feed livestock."], "textile plant": ["Plant producing material suitable to be made into cloths."], "tropical plant": ["A plant growing in tropical areas in conditions of constant rain and high temperature."], "type of tenure": ["The manner in which land is owned and possessed, i.e. of title to its use.\\n(Source: GOOD)"], "petrochemical": ["Chemicals manufactured from the products of oil refineries, based largely on ethylene, propylene and butylene produced in the cracking of petrol fractions."], "speciality chemical": ["Various fine chemical products like glue, adhesives, resins, rubber, plastic compounds, selective herbicide, etc.\\n(Source: ICBT)"], "processed foodstuff": ["Food which has been treated to improve its appearance or to prevent it going bad."], "convenience food": ["Food so prepared and presented as to be easily and quickly ready for consumption."], "root crop": ["Plant which stores edible material in a root, corm or tuber."], "cultivation system": ["Any overall structure or set-up used to organize the activity of preparing land or soil for the growth of new crops, or the activity of promoting or improving the growth of existing crops."], "fisheries structure": ["All the structures (fishing vessels, trawling nets, factory ships, catcher boats, etc.) used in fishing industry.\\n(Source: PARCORa)"], "fishing ground": ["Area of sea or freshwater where fish are caught."], "coal industry": ["Industry related with the technical and mechanical activity of removing coal from the earth and preparing it for market."], "energy industry": ["Industry which converts various types of fuels as well as solar, water, tidal, and geothermal energy into other energy forms for a variety of household, commercial, transportation, and industrial application.\\n(Source: PZ)"], "precision engineering": ["Research and development, design, manufacture and measurement of high accuracy components and systems. It is related to mechanical, electronic, optical and production engineering, physics, chemistry, and computer and materials science.\\n(Source: ASPE)"], "materials technology": ["Any technical means or equipment used for the production and optimization of material goods that consist of any of a diverse range of properties, either alone or in combination, such as glass, metal, plastics and ceramics.\\n(Source: APD)"], "military equipment": ["Equipment necessary to the performance of military activities, either combat or noncombat."], "machinery": ["A group of mechanical or electrical parts or machines arranged to perform or assist a particular function."], "business activity": ["Any profit-seeking undertaking or venture that involves the production, sale and purchase of goods or services."], "building service": ["The aggregation of services, including construction, development, maintenance and leasing, performed for human-occupied properties, such as office buildings and apartment houses.\\n(Source: PBS)"], "destination of transport": ["The targeted place to which persons, materials or commodities are conveyed over land, water or through the air."], "degradation of the environment": ["The process by which the environment is progressively contaminated, overexploited and destroyed."], "accounting system": ["The system of setting up, maintaining, and auditing the books of a firm and of analyzing its financial status and operating results."], "customs tariff": ["An official list or schedule setting forth the duties imposed by a government on imported or exported goods.\\n(Source: OED)"], "commercial transaction": ["The conduct or carrying on of trade, business or a financial matter to a conclusion or settlement.\\n(Source: RHW)"], "pay policy": ["A course of action or procedure regarding compensation or recompensation for work done or services rendered.\\n(Source: RHW)"], "European Monetary System": ["An organization established in Europe in 1979 to coordinate financial policy and exchange rates for the continent by running the Exchange Rate Mechanism (ERM) and assisting movement toward a common European currency and a central European bank.\\n(Source: ODE)"], "money market": ["A financial market that trades Treasury bills, commercial paper and other short-term financial instruments."], "exchange policy": ["Course of action or procedure by government, business, or an individual concerning trade activities.\\n(Source: ISEP /  RHW)"], "public debt": ["The total amount of all government securities outstanding."], "tax on consumption": ["A sum of money demanded from businesses by a government, usually based on a percentage of total sales of select goods and services, and generally passed on to consumers with each individual purchase.\\n(Source: ODE)"], "tax on capital": ["A government imposed levy on the wealth or assets gained by an individual, firm, or corporation for the purpose of raising revenue to pay for services or improvements for the general public benefit.\\n(Source: EFP / RHW)"], "income tax": ["A tax on the annual profits arising from property, business pursuits, professions, trades or offices."], "market price": ["The price actually given in current market dealings; the actual price at which given stock or commodity is currently sold in the usual and ordinary course of trade and competition between sellers and buyers.\\n(Source: WESTS)"], "transport cost": ["The outlay or expenditure involved in moving goods from one place to another.\\n(Source: ODE)"], "prices policy": ["The guiding procedure, philosophy, or course of action for decisions regarding the monetary rate or value for goods and services."], "company structure": ["The type of organization of a company. Three kinds of structure are usually recognized: centralized, formal or hierarchical."], "private international law": ["The part of the national law of a country that establishes rules for dealing with cases involving a foreign element."], "public international law": ["The general rules and principles pertaining to the conduct of nations and of international organizations and with the relations among them.\\n(Source: BLD)"], "international economic law": ["The recognized rules guiding the commercial relations of at least two sovereign states or private parties involved in cross-border transactions, including regulations for trade, finance and intellectual property.\\n(Source: IEL)"], "family law": ["Branch of specialty of law concerned with such subjects as adoption, annulment, divorce, paternity, custody and child support."], "traffic regulation": ["A body of rules or orders prescribed by government or management for the safe and orderly movement of vehicles on land, sea or in the air.\\n(Source: BLD / RHW)"], "law relating to prisons": ["Binding rules and regulations pertaining to the construction, use and operation of jails, penitentiaries and other places of legal confinement and punishment."], "competition law": ["That part of the law dealing with matters such as those arising from monopolies and mergers, restrictive trading agreements, resale price maintenance and agreements involving distortion of competition affected by EU rules."], "ruling": ["A judicial or administrative interpretation of a provision of a statute, order, regulation, or ordinance. May also refer to judicial determination of admissibility of evidence, allowance of motion, etc."], "legal procedure": ["All proceedings authorised or sanctioned by law, and brought or instituted in a court of legal tribunal, for the acquiring of a right or the enforcement of a remedy.\\n(Source: WESTS)"], "legal system": ["The organization and network of courts and other institutions, procedures and customs, officers and other personnel concerned with interpretation and enforcement of a country's law or with advice and assistance in matters pertaining to those laws."], "legislative procedure": ["Any prescribed step or manner of proceeding that a law making body takes in proposing laws, resolutions or special acts before they can be enacted or passed.\\n(Source: RHW)"], "management technique": ["Systematic approach or method of performance for the accomplishment of administrative goals or tasks."], "construction policy": ["A course of action adopted and pursued by government, business or some other organization, which plans or organizes for the maintenance, development and erection of houses, offices, bridges or other building structures.\\n(Source: OED)"], "space policy": ["A course of action adopted and pursued by government or some other organization, which seeks to support research and the exploration of planets, asteroids and other elements in the region beyond earth's atmosphere or beyond the solar system.\\n(Source: OED)"], "economic region": ["A district or an administrative division of a city or territory that is designed according to some material, distributive or productive criteria."], "humanitarian aid": ["The support or relief given to save human lives or to alleviate suffering, including public health efforts and the provision of financial resources and food, often when governmental authorities are unable or unwilling to provide for such assistance."], "international conflict": ["A controversy, disagreement, quarrel or warfare between or among two or more nations or countries, often requiring involvement or monitoring by other members of the global community."], "peacekeeping": ["The activities to prevent, contain, moderate and/or terminate the hostilities between or within States, through the medium of an impartial third party intervention, organised and directed internationally."], "level of education": ["A position along a scale of increasingly advanced training marking the degree or grade of instruction either obtained by an individual, offered by a some entity or necessary for a particular job or task.\\n(Source: RHW)"], "general education": ["Informal learning or formal instruction with broad application to human existence beyond the domain of any particular subject or discipline, often equated with liberal arts in the university setting and contrasted to courses required for a specific major or program."], "schoolwork": ["The material studied in or for an educational institution, comprising homework and work done in the classroom.\\n(Source: RHW)"], "documentary system": ["A coordinated assemblage of people, devices or other resources providing written, printed or digitized items that furnish or substantiate information or evidence.\\n(Source: RHW)"], "communications system": ["A coordinated assemblage of people, devices or other resources designed to exchange information and data by means of mutually understood symbols."], "data processing system": ["An assembly of computer hardware, firmware and software configured for the purpose of performing various operations on digital information elements with a minimum of human intervention.\\n(Source: JON)"], "health care profession": ["A profession specific to the health care industry."], "war victim": ["A person that suffers from the destructive action undertaken as a result of an armed conflict between two or more parties, particularly death, injury, hardship, loss of property or dislocation."], "internal migration": ["A population shift occurring within national or territorial boundaries, often characterized by persons seeking labor opportunities in more advantageous areas.\\n(Source: ISEP)"], "marital status": ["The standing of an individual with regard to a legally recognized conjugal relationship, either in the present or past."], "socio-cultural group": ["A collection of people who interact and share a sense of unity on account of a common ethnic, ancestral, generational or regional identity.\\n(Source: RHW)"], "employment structure": ["The organization and proportions of the various job types and skill levels in an enterprise or economy.\\n(Source: LAB)"], "camp": ["Tents, cabins, etc., used as temporary lodgings by a group of travellers, holiday-makers, Scouts, Gypsies, etc.", "To live in a tent or similar temporary accomodation."], "royalty": ["Compensation for the use of a person's property, based on an agreed percentage of the income arising from its use."], "allowance": ["Regular allocation or deduction of money."], "salina": ["A place where crystalline salt deposits are formed or found, such as a salt flat or pan, a salada, or a salt lick."], "hiking trail": ["A trail in the country along which one can walk, usually for pleasure or exercise."], "eco-balance": ["An eco-balance refers to the consumption of energy and resources and the pollution caused by the production cycle of a given product. The product is followed throughout its entire life cycle, from the extraction of the raw materials, manufacturing and use, right through to recycling and final handling of waste.\\n(Source: DUNI)"], "nitrogen oxide": ["A colorless gas that, at room temperature, reacts with\\noxygen to form nitrogen dioxide; may be used to form other compounds."], "oven": ["An enclosed heated compartment usually lined with a refractory material used for drying substances, firing ceramics, heat-treating, etc."], "bovine": ["Medium-sized to large ungulates, including domestic cattle, Bison, the Water Buffalo, the Yak, and the four-horned and spiral-horned antelopes."], "approval": ["Approbation; a sanctioning of an item."], "cleansing": ["The act or process of washing, laundering or removing dirt and other unwanted substances from the surface of an object, thing or place.\\n(Source: RHW)"], "inner city": ["In the United States, United Kingdom and Ireland: Part of a city at or near the centre, especially a slum area where poor people live in bad housing."], "sluice-gate": ["A valve or gate fitted to a sluice to control the rate of flow of water."], "deciduous wood": ["The temperate forests comprised of trees that seasonally shed their leaves, located in the east of the USA, in Western Europe from the Alps to Scandinavia, and in the eastern Asia. The trees of deciduous forests usually produce nuts and winged seeds.\\n(Source: WRIGHT)", "Wood taken from a deciduous tree."], "mixed woodland": ["A forest composed of broadleaf trees and coniferous trees."], "penal sanction": ["Punishment for the commission of a specific crime, such as fines, restitution, probation and imprisonment."], "coniferous tree": ["Any tree bearing cones."], "aerial photography": ["The creation of photographs from an airplane."], "swamp": ["A permanently waterlogged area in which there is often associated tree growth, e.g. mangroves in hot climates."], "legislative process": ["The entire course of action necessary to bring a law, resolution or special act to an authoritative, legally binding status.\\n(Source: RHW)"], "returnable container": ["Container whose return from the consumer or final user is assured by specific means (separate collection, deposits, etc.), independently on its final destination, in order to be reused, recovered or subjected to specific waste management operations.\\n(Source: PORTa)"], "intermediate product": ["Product that has undergone a partial processing and is used as raw material in a successive productive step."], "mutagenic substance": ["Agents that induce a permanent change in the genetic material."], "excise": ["A tax charged on goods produced within the country."], "dipteran": ["An order of insects possessing only a single pair of wings on the mesothorax."], "coniferous wood": ["Forest, mainly containing conifers."], "underground railway": ["An electric passenger railway operated in underground tunnels."], "genetically modified organism": ["An organism that has undergone external processes by which its basic set of genes has been altered."], "surface active compound": ["Any soluble substance composed of two or more unlike atoms held together by chemical bonds that reduces interfacial tension between liquids or a liquid and a solid, often used as detergents, wetting agents and emulsifiers."], "pH-value": ["(logarithmical) Measure of the acidity or alkalinity of an aqueous solution."], "mining": ["The act, process or industry of extracting coal, ores, etc. from the earth.\\n(Source: CED)"], "Black Sea": ["An inland sea between southeastern Europe and Anatolia."], "Caspian Sea": ["A landlocked sea between Asia and European Russia. It is the world\u2019s largest inland body of water."], "Mediterranean Sea": ["The largest inland sea between Europe, Africa and Asia, linked to the Atlantic Ocean at its western end by the Strait of Gibraltar, including the Tyrrhenian, Adriatic, Aegean and Ionian seas, and major islands such as Sicily, Sardina, Corsica, Crete, Malta and Cyprus."], "indigenous knowledge": ["Local knowledge that is unique to a given culture or society, which is the basis for local-level decision making in agriculture, health care, education and other matters of concern in rural communities.\\n(Source: WIK)"], "professional society": ["A group of persons engaged in the same profession, business, trade or craft that is organized or formally structured to attain common ends.\\n(Source: RHW)"], "subject": ["The general category, often stated in a word or phrase, to which the ideas of a passage as a whole belong.", "The grammatical subject.", "The subject of discourse; the point at issue.", "Area of knowledge taught in an educational institution."], "physical alteration": ["Any change in a body or substance that does not involve an alteration in its chemical composition."], "information infrastructure": ["The basic, underlying framework and features of a communications system supporting the exchange of knowledge, including hardware, software and transmission media.\\n(Source: WIC / RHW)"], "wide area network": ["A system of interrelated computer and telecommunications devices linking two or more computers separated by a great distance for the exchange of electronic data.\\n(Source: WIC)"], "World Wide Web": ["A graphical, interactive, hypertext information system that is cross-platform and can be run locally or over the global Internet. The Web consists of Web servers offering pages of information to Web browsers who view and interact with the pages. Pages can contain formatted text, background colors, graphics, as well as audio and video clips."], "homepage": ["The preset document that is displayed after starting a World Wide Web browser, or the main World Wide Web document in a series of related documents.\\n(Source: UNM / WIC)"], "hypertext": ["The organization of information units typically containing visible links that users can select or click with a mouse pointer or some other computer device to automatically retrieve or display other documents.\\n(Source: WIC / TWI)"], "newsgroup": ["A discussion group on a specific topic maintained on a computer network, frequently on the Internet."], "electronic mail": ["Information or message that is transmitted or exchanged from one computer terminal to another, through telecommunication."], "multimedia technology": ["Any technical means used to combine text, sound, still or animated images and video in computers and electronic products, often allowing audience interactivity.\\n(Source: ENC / WIS)"], "exhibit": ["A display of an object or collection of objects for general dissemination of information, aesthetic value or entertainment.", "To make known something heretofore kept secret."], "newsletter": ["A printed periodical bulletin circulated to members of a group."], "public relations": ["The methods and activities employed by an individual, organization, corporation, or government to promote a favourable relationship with the public."], "bibliographic information system": ["A coordinated assemblage of people, devices or other resources organized for the exchange of data pertaining to the history, physical description, comparison, and classification of books and other works.\\n(Source: RHW)"], "bibliographic information": ["Data pertaining to the history, physical description, comparison, and classification of books and other works.\\n(Source: RHW)"], "referral information system": ["A coordinated assemblage of people, devices or other resources organized to provide directions leading people to sources known to provide knowledge or assistance on a specified topic or request.\\n(Source: RHW)"], "statistical information system": ["A coordinated assemblage of people, devices or other resources enabling the exchange of numerical data that has been collected, classified or interpreted for analysis.\\n(Source: RHW)"], "library service": ["The duties of an establishment, or a public institution, charged with the care and organizing of a collection of printed and other materials, and the duty of interpreting such materials to meet the informational, cultural, educational, recreational or research needs of its clients.\\n(Source: OED /  LFS)"], "inter-library loan": ["The service provided by one library in which a second library's clients are temporarily allowed to use books and other printed materials belonging to the first library; and consequently the system providing rules and infrastructure for this service to a group of libraries.\\n(Source: RHW)"], "information clearing-house": ["A central institution or agency for the collection, maintenance, and distribution of materials or data compiled to convey knowledge on some subject.\\n(Source: RHW)"], "information exchange": ["A reciprocal transference of data between two or more parties for the purpose of enhancing knowledge of the participants."], "relational database": ["A collection of digital information items organized as a set of formally described tables from which the information can be accessed or reassembled in different ways without reorganizing the tables."], "multispectral scanner": ["A remote sensing term referring to a scanning radiometer that simultaneously acquires images in various wavebands at the same time."], "pixel": ["The smallest unit of information in an image or raster map."], "spectral band": ["Closely grouped bands of lines characteristic of molecular gases of chemical compounds (spectroscopy)."], "image processing digital system": ["A coordinated assemblage of computer devices designed to capture and manipulate pictures stored as data in discrete, quantized units or digits.\\n(Source: GIS)"], "digital image processing technique": ["Techniques employed in the calibration of image data, the correction or reduction of errors occurring during capture or transmission of the data and in various types of image enhancement-operations which increase the ability of the analyst to recognize features of interest.\\n(Source: YOUNG)"], "pattern recognition": ["A remote sensing term referring to an automated process through which unidentified patterns can be classified into a limited number of discrete classes through comparison with other class-defining patterns or characteristics."], "mosaic": ["A composite photograph consisting of separate aerial photographs of overlapping surface areas, producing an overall image of a surface area too large to be depicted in a single aerial photograph."], "image filtering": ["A remote sensing term related to image enhancement that refers to the removal of a spatial component of electromagnetic radiation.\\n(Source: WHITa)"], "image enhancement": ["In remote sensing, the filtering of data and other processes to manipulate pixels to produce an image that accentuates features of interest or visual interpretation."], "geometric correction": ["A remote sensing term referring to the adjustment of an image for geometric errors.\\n(Source: DWEB)"], "image registration": ["The process of linking map coordinates to control points with known earth-surface coordinates."], "image classification": ["Processing techniques which apply quantitative methods to the values in a digital yield or remotely sensed scene to group pixels with similar digital number values into feature classes or categories.\\n(Source: DYNAMO)"], "atmospheric correction": ["The removal of atmospheric effects from astronomical data or satellite imagery. These effects are caused by the scattering and absorption of sunlight by particles in the earth's athmosphere; the removal of these effects improves not only the quality of the observed earth surface imaging but also the accuracy of classification of the ground objects.\\n(Source: YOUNG)"], "GIS digital format": ["The digital form of data collected by remote sensing."], "vector": ["One of the two major types of internal data organization used in GIS. Vector systems are based primarily on coordinate geometry.", "A mathematical object defined by both magnitude and direction; in contrast to a scalar, an object with magnitude only.", "An element in a vector space, often represented as a coordinate vector.", "A virus modified to deliver genetic material into a cell.", "An organism that transmits diseases or infections."], "point": ["A position on a reference system determined by a survey.", "Zero-dimensional mathematical object.", "A certain place in a continuum.", "A dot-shaped punctuation mark.", "A small spot, mark or feature which does not bear any details.", "The narrow, acute end of an object of variable thickness.", "To indicate with a pointy object; to direct into a position.", "To indicate a person, thing, direction, etc. e.g. with a finger."], "line": ["Term used in GIS technologies in the vector type of internal data organization: spatial data are divided into point, line and polygon types.", "The descendants of one individual.", "A succession of notes forming a distinctive sequence.", "A measure of length equal to one twelfth of an inch.", "An infinitely long, infinitely thin, not bent line in geometry.", "A mark that is long relative to its width."], "polygon": ["In the vector type of GIS internal data organization spatial data are conveniently divided into point, line and polygon types. Some vector GIS store information in the form of points, line segments and point pairs; others maintain close lists of points defining polygon regions.", "Geometrical figure that is circumscribed by straight lines."], "raster": ["One of the two major types of internal data organization used in GIS."], "attribute": ["A distinctive feature of an object. In mapping and GIS applications, the objects are points, lines, or polygons that represent features such as sampling locations, section corners (points); roads and streams (lines); lakes, forest and soil types (polygons). These attributes can be further divided into classes such as tree species Douglas-fir and ponderosa pine) for forest types and paved and gravel for road types. Multiple attributes are generally associated with objects that are located on a single map layer.\\n(Source: FORUMT)", "To credit something to.", "To attribute or credit to.", "To associate ownership of (something) to someone."], "GIS digital technique": ["The transformation to digital form of data collected by remote sensing, traditional field and documentary methods and of existing historical data such as paper maps, charts, and publications."], "interpolation": ["A process used to estimate an intermediate value of one (dependent) variable which is a function of a second (independent) variable when values of the dependent variable corresponding to several discrete values of the independent variable are known.\\n(Source: MGH)"], "gridding": ["A system of uniformly spaced perpendicular lines and horizontal lines running north and south, and east and west on a map, chart, or aerial photograph; used in locating points."], "national boundary": ["The line demarcating recognized limits of established political units."], "geographical projection": ["A representation of the globe constructed on a plane with lines representative of and corresponding to the meridians and parallels of the curved surface of the earth."], "latitude": ["An angular distance in degrees north or south of the equator (latitude 0\u00b0), equal to the angle subtended at the centre of the globe by the meridian between the equator and the point in question."], "longitude": ["Distance in degrees east or west of the prime meridian at 0\u00b0 measured by the angle between the plane of the prime meridian and that of the meridian through the point in question, or by the corresponding time difference."], "GIS laboratory": ["A laboratory where GIS data drawn from different sources are stored, handled, analyzed and updated.\\n(Source: GILP96a)"], "underground dump": ["Any subterranean or below-ground site in which solid, or other, waste is deposited without environmental controls."], "business economics": ["The art of purchasing and selling goods from an economics perspective or a perspective involving the scientific study of the production, distribution, and consumption of goods and services."], "deterrence": ["The power of discouraging actions or preventing occurrences by instilling the fear of punishment."], "deep sea mining": ["The most valuable of the marine mineral resources is petroleum. About 15% of the world's oil is produced offshore, and extraction capabilities are advancing. One of the largest environmental impacts of deep sea mining are discharged sediment plumes which disperse with ocean currents and thus may negatively influence the marine ecosystem. Coal deposits known as extensions of land deposits , are mined under the sea floor in Japan and England.\\n(Source: PARCOR /  ERIB)"], "semi-liquid manure": ["Manure that contains between 12-20% dry matter, and therefore are too solid for pumping, but too liquid for stacking."], "local heat supply": ["The provision of heating fuel, coal or other heating source materials, or the amount of heating capacity, for the use of a specific local community.\\n(Source: ISEP)"], "forwarding agent": ["A person or business that specializes in the shipment and receiving of goods.", "A person or company that organizes shipments for individuals or other companies."], "citizen initiative": ["Procedure that allows a request, signed by a group of people, to activate a public voting."], "mountain refuge": ["Any shelter or protection from distress or danger located in a predominantly mountainous area.\\n(Source: RHW)"], "space research": ["Research involving studies of all aspects of environmental conditions beyond the atmosphere of the earth."], "red list": ["A series of publications produced by the International Union for the Conservation of Nature and Natural Resources (IUCN) which provides an inventory on the threat to rare plants and animal species and conservation measures."], "insulating material": ["Material that prevents or reduces the transmission of electricity, heat, or sound to or from a body, device or region.\\n(Source: CED)"], "decantation": ["Sizing or classifying particulate matter by suspension in a fluid (liquid or gas), the larger particulates tending to separate by sinking.\\n(Source: ECHO2)"], "general": ["Not specific or particular.", "Rank in the army and air force that is higher than colonel or brigadier, and is usually the highest rank group next to commander in chief, except in countries that use the rank of field marshal.", "Applicable to an entire class or group."], "materials": ["The substance of which a product is made or composed."], "trade": ["To give something in return for something received.", "The act or process of buying, selling or exchanging goods and services at either wholesale or retail, within a country or between countries.", "The act or the business of buying and selling for money. Mercantile or commercial business in general or the buying and selling, or exchanging, of commodities, either by wholesale or retail within a country or between countries.\\n(Source: WESTS)", "The skilled practice of a practical occupation."], "population": ["The people living in a certain area as a whole.", "A group of organisms of one species, occupying a defined area.\\n(Source: LBC)", "The abstract property of a human, of living in a specific area given by precise, and well defined, borders. (This may be part of, or include, citizenship, but not necessarily so, e.g. for people having several places of residence, for foreigners, or ones officially being accepted on long-term transient living terms)", "The totality of persons or objects with which a research study is concerned."], "space": ["Space extending between the sun and the planets of the solar system. Interplanetary space is not empty, but contains dust, particles with an electric charge, and the magnetic field of the sun (also called the IMF, or Interplanetary Magnetic Field).", "The location of an object or organism.", "Relatively empty regions (with very small densities) of the universe outside the atmospheres of celestial bodies."], "transport": ["The act or means of moving tangible objects (persons or goods) from place to place. Often involves the use of some type of vehicle.", "Transfer of mass, momentum, or energy in a system as a result of molecular agitation, including such properties as thermal conduction and viscosity.", "To change the location or place of.", "To delight to a high degree; to hold spellbound."], "water": ["Significant accumulation of water, covering the Earth or another planet.", "Common liquid (H\u2082O) which forms rain, rivers, the sea, etc., and which makes up a large part of the bodies of organisms.", "To pour water onto the soil surrounding plants.", "Of the eyes: To secrete tears because of an irritation caused by wind, smoke etc."], "kid": ["A young goat."], "Southern Ocean": ["The waters, including ice shelves, that surround the continent of Antarctica, which comprise the southernmost parts of the Pacific, Atlantic and Indian oceans, and also the Ross, Amundsen, Bellingshausen and Weddell seas."], "mechanism": ["A group of mechanical or electrical parts or machines arranged to perform or assist a particular function.", "The mechanic part of a device."], "economic science": ["The social study of the production, distribution, and consumption of wealth."], "noble gas": ["Any one of the monatomic gaseous elements forming group 18 (formerly group 0) of the periodic table."], "plant eater": ["An animal that feeds on plants."], "many": ["An indefinite large number of."], "one": ["The first natural number (1).", "One certain or particular.", "The cardinal number that directly follows zero and precedes two, represented in Roman numerals as I, and in Arabic numerals as 1.", "An unspecified individual.", "The symbol representing the number 1.", "Being the only representative of its kind.", "Forming a whole.", "The same in substance or being, in relation to two or more things or persons.", "Identical in nature.", "United in feeling, opinion, purpose, attitude.", "A note or coin worth one unit of a currency.", "One person or thing, identified in context.", "A single individual, as opposed to none.", "An individual among many.", "A person or thing of the kind already mentioned.", "A person or thing having the characteristic mentioned.", "A person called...", "Any person in general, including the speaker.", "An individual..., a specific ...", "The single, special individual", "The digit \"1\"."], "two": ["Two human beings, at least one of whom is a male.", "The second natural number (2).", "The cardinal number occurring after one and before three, represented in Roman numerals as II and in Arabic numerals as 2.", "The digit \"2\"."], "man": ["A member of the human species.", "The generic name for a piece used in board games.", "All human beings.", "An adult human member of the sex that begets young by fertilizing ova."], "humanity": ["All human beings."], "wife": ["A married woman."], "husband": ["The male partner in a marriage."], "three": ["Three human beings, at least one of whom is a male.", "The cardinal number occurring after two and before four, represented in Roman numerals as III, in Arabic numerals as 3.", "The digit \"3\".", "The third natural number (3)."], "pawn": ["A chess piece, the least valuable one."], "print": ["The result of the printing process; something in printed or published form.", "To press something onto or into a surface, usually with a press.", "To reproduce a document with black or color ink using a printer.", "Concrete result of the reproduction process of an image by means of different techniques.", "To produce a positive image on photographic paper from a negative."], "feather": ["A branching, hair-like structure that grows on the skin of birds and protects them against coldness and water and allows their wings to create lift."], "big": ["Of a great size; the weakest sense of great size.", "Having relevant and crucial value.", "(for abstract matters) of larger than normal size.", "In a major way."], "long": ["Having much distance from one terminating point on an object or an area to another terminating point.", "Having relatively great height.", "Of relatively great duration.", "Of a specified linear extent or duration.", "To have a yearning desire.", "Qualifying a measure of length, to indicate that it is greater than stated, or is felt by the speaker to be excessive in duration.", "Having a shape with one dimension of much greater length than the others.", "Having (a specified) distance from end to end.", "Of something consisting of a series of items (like a list, a sentence, a literary work): having a great extent from the start to the end.", "That which has been so for a long time.", "A person who buys a financial security such as a stock, commodity or currency, with the expectation that it will rise in value", "Extending to a great distance.", "For or during a long time.", "Having a financial position in a security so as to profit if the price of the security goes up."], "bark": ["The exterior covering of the trunk and branches of a tree.", "The short, loud, explosive sound produced by a dog.", "To produce a loud, short, explosive sound similar to that of a dog.", "A sailing ship with three or more masts, fore-and-aft sails on the aftermost mast and square sails on all other masts."], "tongue": ["The flexible muscular organ in the mouth that is used to move food around, for tasting and that is moved into various positions to modify the flow of air from the lungs in order to produce different sounds.", "In a shoe, the flap of material that goes between the laces and the foot.", "A person's manner of speaking."], "cat": ["A common four-legged animal (Felis silvestris) that is often kept as a household pet."], "four": ["Four human beings, at least one of whom is a male.", "The fourth natural number (4).", "The cardinal number occurring after three and before five, represented in Roman numerals as IV, in Arabic numerals as 4.", "The digit \"4\"."], "five": ["Five human beings, at least one of whom is a male.", "The cardinal number occurring after four and before six, represented in Roman numerals as V, in Arabic numerals as 5.", "The digit \"5\".", "The fifth natural number (5)."], "I": ["The speaker or writer referring to himself or herself alone.", "The capitalized version of the ninth letter of the Latin alphabet."], "heavy": ["Of a physical object, having great weight."], "small": ["Not large or big; small in size."], "thou": ["The second person singular feminine subject pronoun.", "The second person singular masculine subject pronoun.", "The person addressed as the subject.", "The person addressed."], "he": ["Another person; the person previously mentioned.", "A male other; the male previously mentioned; himself.  \\n3rd person singular masculine subject pronoun."], "we": ["exclusive \"we\": I and at least one other person, but not the addressed person (you)\\n\\n(pronoun 1st person plural without 2nd person)", "inclusive \"we\": I and at least one other person, including the addressed person(s)\\n(pronoun 1st person plural with 2nd person)", "The speaker or writer and at least one other person."], "you": ["The second person plural feminine subject pronoun.", "The second person singular feminine subject pronoun.", "The second person singular masculine subject pronoun.", "The second person plural masculine subject pronoun.", "The second person singular masculine object pronoun.", "The second person plural masculine object pronoun.", "The second person plural feminine object pronoun.", "The person addressed as the subject.", "The group of persons addressed.", "The person addressed.", "An unspecified individual.", "Used before epithets for emphasis."], "they": ["[A group of others previously mentioned.]", "The previously mentioned persons.", "The things previously mentioned.", "Form in its third person plural of the personal pronoun that designates more than one male person (or male animals), which have already been mentioned previously.", "The third person plural of the personal pronoun that designates more than one female person or animal, which have already been mentioned previously.", "An unknown unnamed anonymous authority, ruling body, shaping or governing force, be it real or fictional, working openly or secretly.", "The third person plural of the personal pronoun that designates more than one person or animal, thing or idea which have already been mentioned previously."], "this": ["[Something that is farther than \"this\" but nearer than \"that\".]", "[Used to refer to something between the speaker and the listener.]", "The indicated object, item, etc.", "An indicated thing that is near in space or in mind, as having been just mentioned."], "barque": ["A sailing ship with three or more masts, fore-and-aft sails on the aftermost mast and square sails on all other masts."], "that": ["The indicated item (at a distance from the speaker, next to the listener).", "The indicated item (at a distance from the speaker, or previously mentioned, or at another time).", "Demonstrative pronoun (feminine, singular): the indicated thing is implied, since it is previously mentioned. Collocation: that of; to that of.", "In the same manner or to the same extent as mentioned before."], "seed": ["A mature fertilized plant ovule, consisting of an embryo and its food store surrounded by a protective seed coat (testa).", "Anything that provides inspiration for later work.", "To remove the seeds from.", "To place seeds in or on the ground for future growth.", "One of the outstanding players in a tournament."], "blood": ["A fluid connective tissue consisting of the plasma and cells that circulate in the blood vessels.", "The descendants of one individual."], "mother": ["A woman who has at least one child.", "A female parent.", "A woman acting like a mother.", "A female ancestor (usually in reference to Eve).", "Term of address to an old or elderly woman.", "The female head of a religious organization.", "A woman who runs a brothel.", "A term of address to someone who is a female parent (a biological mother or a woman with parental responsibility).", "The female animal that gave birth to an animal.", "The source of something.", "A country, region, etc. in relation to its inhabitants.", "The Christian Church (usually as \"holy mother\")", "The source of a substance, structure, object.", "The first mold from which other molds are made for the manufacturing of music discs.", "Give birth to.", "To care for and protect in a motherly way."], "father": ["A male parent.", "A person that has founded or originated, as in ''the father of our country''", "The head of an organized crime family."], "rope": ["Thick, strong string made of several strands that have been twisted together."], "worm": ["A generally tubular invertebrate of the annelid phylum.", "A self-replicating program that propagates widely through a network.", "To rid of intestinal worms."], "tail": ["The appendage of an animal that is attached to its posterior and near the anus.", "The fleshy part of the human body that one sits on."], "mouth": ["The opening of a creature through which food is ingested.", "What humans use for speaking.", "Opening in the lower half of a human face which is used for food ingestion and articulation.", "A river mouth or stream mouth is a part of a river where it flows into the sea, river, lake, reservoir or ocean."], "nose": ["The organ of the face used to breath and smell.", "To search or inquire intrusively."], "penis": ["The male sexual organ for copulation and urination; the tubular portion of the male genitalia (excluding the scrotum)."], "cock": ["A device applied to the end of a pipe in order to interrupt and regulate the flow of a liquid or gas.", "A male of various birds.", "A male pheasant.", "A male chicken (Gallus gallus domesticus), a domestic bird.", "The part of a firearm that hits the back of the bullet and sets it off, firing the gun.", "A valve with the function of regulating the flow of a liquid or gas through a pipe."], "heart": ["A muscular organ that pumps blood through the body.", "The perceived center of feelings and intuitions.", "A stylized representation of the muscular organ, used as a symbol for affection, in the shape of two top lobes and a tapering bottom.", "Relating to the heart."], "liver": ["A large organ in the body that stores and metabolizes nutrients, destroys toxins and produces bile. Responsible for thousands of biochemical reactions."], "day": ["The period between sunrise and sunset where one enjoys daylight.", "A period of time lasting 24 hours", "The period of time from one midnight to the next, seven of which consitutes a week"], "year": ["The time it takes the Earth to complete one revolution of the Sun (between 365.24 and 365.26 days depending on the point of reference).", "The time it takes for any planetary body to make one revolution around another body.", "A period between set dates that mark a year, from January 1 to December 31 by the Gregorian calendar."], "board": ["A (usually) rectangular section of a surface, or of a covering or of a wall, fence etc.", "A piece of wood or similar material that has been sawn into a regular shape, usually in preparation for using it in some sort of construction.", "A committee that manages some business of an organization.", "A flat piece of material designed for a special purpose.", "A screen on which information can be displayed to public view.", "To enter trains, buses, ships, aircraft, etc.", "A printed circuit that can be inserted into expansion slots in a computer to increase the computer's capabilities.", "An electrical device consisting of an insulated panel containing switches and dials and meters for controlling other electrical devices.", "Consulting or decisive insititution, composed of more than one person, national or international, private or public, with different scopes.", "All representatives in a company that have the assignment to administrate the company itself.", "Food or meals in general."], "earth": ["The soft and loose material forming a great part of the Earth surface.", "The third planet (counted from the center) of our solar system."], "dirty": ["Covered with or containing unpleasant substances such as dirt or grime.", "To make filthy."], "new": ["Recently made, created or begun.", "(of a cycle) beginning or occurring again (e.g. a fresh start or idea)."], "warm": ["Having a temperature slightly higher than usual, still pleasant.", "To make warm or warmer.", "To become warm or warmer.", "About colors whose relative visual temperature makes them seem warm. Warm colors or hues include red-violet, red, red-orange, orange, yellow-orange, and yellow.", "Having affection or warm regard; loving."], "night": ["The period between sunset and sunrise, when a location faces far away from the sun, thus when the sky is dark."], "smooth": ["Not rough; having a surface texture that lacks friction."], "here": ["This place.", "at this place"], "there": ["That place.", "In a not completely determined place which is not here."], "who": ["What person or people; which person or people."], "what": ["Which thing.", "Exclamation of amazement."], "where": ["Place in which.", "At what place?", "In or at or to what place.", "To which place?", "To which place."], "when": ["at the time following immediately the time when", "At what time.", "As soon as.", "At the time that (Temporal coincidence relationship.)", "At a time in the past.", "At what time in the past."], "how": ["In what way."], "not": ["Negates the meaning of the modified verb.", "Logical operation (not)"], "all": ["Every individual or anything of the given class, with no exceptions.", "Throughout the whole of.", "The totality of.", "Having or showing nothing other than."], "old": ["Having lived or existed for a relatively long period of time.", "(For a person or an animal) Having lived for a relatively long period of time.", "(For an object or a concept) Having existed for a relatively long period of time.", "A person that has been living for a relatively long period of time.", "An object or concept existing for a relatively long period of time."], "some": ["An unspecified quantity of.", "An unspecified quantity or number of.", "An unspecified number of. (The masculine plural indefinite article) - Phrase: some men. - NOTE: In Englih, \"some\" in this sense is an indefinite pronoun.", "The feminine plural of the indefinite article.", "[The plural indefinite article.]", "The plural partitive article.", "[The plural indefinite article, with an adjective that precedes a noun.]", "[The plural partitive article, with an adjective that precedes a noun.]", "An unknown quantity of an uncountable substance."], "few": ["More than one, but not as many as usual or as expected."], "other": ["The one not previously referred to.", "Not the same.", "A few (days, years, etc.) ago.", "Remaining from a group of two or more."], "wide": ["Having a long distance or area between two points, especially horizontally.", "Very large in expanse or scope."], "thick": ["Relatively large distance from one surface to the opposite in its smallest solid dimension."], "love": ["An intense feeling of affection and care towards another person.", "To receive pleasure or satisfaction from something.", "Someone that one loves.", "To have an intense feeling of affection and care towards another person.", "(Tennis) Score of zero.", "To have sex with.", "To be enamored or in love with (somebody)."], "my": ["Belonging to me."], "butter": ["A soft, fatty foodstuff that is made by churning the cream of milk (most often cows milk).", "To spread butter on."], "grumpy": ["Unhappy or irritable - often applied to babies, young children or adults acting childishly."], "short": ["Small in length by comparison.", "An unintentional electrical connection of low resistance or impedance in a circuitry or installation.", "Short in height; low in stature; not tall.", "Lasting for a small length of time; limited in temporal duration.", "Not reaching a standard; Not sufficient to meet a need or requirement.", "A quantity, time, number, etc. that is less than what is expressed.", "Something traveling not as far as intended.", "Having an insufficient supply of.", "Having sold a borrowed stock which the seller hopes to buy at a lower price before the time to return it.", "To cause a short circuit.", "To sell something that is borrowed, with the hope of buying it later at a lower price, before the time to return it.", "To cheat someone by giving them less money than what are due.", "Something short, like a short film, short shot, a short story, a short signal, etc.", "A contraction for a name."], "ear": ["The organ of hearing, consisting of the pinna, auditory canal, eardrum, malleus, incus, stapes and cochlea.", "The fruiting body of a grain plant."], "eye": ["The organ that is sensitive to light, which it converts to electrical signals passed to the brain, by which means animals see.", "The centre of a storm, around which, the winds blow.", "The hole in a needle through which the thread runs", "The dark spot on the surface under the skin of a potato, of which there are usually several.", "To look at."], "jaguar": ["A carnivorous spotted large cat native to South and Central America.", "A French military aircraft."], "belly": ["The lower part of the front of the torso (or a comparable part of an animal), confined by the upper side by the midriff and the lowerside by the pelvis. Contains the intestines."], "abdomen": ["The lower part of the front of the torso (or a comparable part of an animal), confined by the upper side by the midriff and the lowerside by the pelvis. Contains the intestines.", "The cavity containing the major viscera."], "stomach": ["The lower part of the front of the torso (or a comparable part of an animal), confined by the upper side by the midriff and the lowerside by the pelvis. Contains the intestines.", "An organ in the body, involved in digestion of food.", "To allow (something that one dislikes or disagrees with) to continue to exist or occur without interference; accept or undergo, often unwillingly."], "house": ["The abode of a human being, their place of residence.", "To keep within a structure or container; to contain or cover.", "A place that a human built to live in.", "A place where an activity is accomplished, whether actual, as a pub, or virtual, as a website.", "A familiar descendance, for example, a Royal House.", "To admit to residence; provide housing for.", "One of 12 equal areas into which the zodiac is divided."], "handle": ["A closed loop that is normally placed horizontally on an object (for example, on a mug or a cup).", "To feel with the hand; to use or hold with the hand.", "To manage; to control; to practice skill upon."], "hair": ["The collection or mass of filaments growing from the skin of humans and animals, and forming a covering for a part of the head or for any part or the whole body.", "One single of the filaments growing from the skin of humans and animals, and forming a covering for parts of the body.", "A single filament growing from the non-facial part of the head of humans.", "The collection or mass of hair on a person's head except the face."], "head": ["The part of the body of an animal or human which contains the brain, mouth and main sense organs.", "The foremost or leading position in a race, a competition.", "A person who leads, rules, or is in charge.", "The person who is in charge of and runs a school.", "Leader of a department or tribe.", "The complex of cognitive faculties, mostly characteristic of human beings, that enables consciousness, thinking, reasoning, perception, and judgement."], "wing": ["The appendage of an animal's (bird, bat, insect) body that enables it to fly in the air.", "To move autonomously through the air, without any part of the object or object's enclosure touching anything attached to the ground.", "Part of airplane that enables it to stay in the air."], "fingernail": ["The hard, flat, translucent covering near the tip of a human finger, useful for scratching and fine manipulation."], "tofu": ["A protein-rich food made from curdled soybean milk, by coagulating it with magnesium sulfate."], "marriage": ["A union of two persons (usually a man and a woman) which entails legal obligations and is intended to last for life.", "A ceremony celebrating the beginning of a marriage, during which the marrying parties exchanges vows.", "The state of being married."], "wedding": ["A ceremony celebrating the beginning of a marriage, during which the marrying parties exchanges vows."], "wedlock": ["The state of being married."], "matrimony": ["The state of being married."], "nighttime": ["The period between sunset and sunrise, when a location faces far away from the sun, thus when the sky is dark."], "daytime": ["The period between sunrise and sunset where one enjoys daylight."], "collection": ["A method to group defined meanings from a particular source or context.", "The embeding of a sum of due money.", "Several things grouped together or considered as a whole.", "The act of gathering something together.", "In computer science, a data structure which contains some variable number of data items that have some shared significance to the problem being solved and need to be operated upon together in some controlled fashion (e.g. in a sequence).", "A collection of art works."], "choir": ["A singing group; a group of people who sing together.", "The part of a church where the choir assembles for song.", "One of the nine ranks or orders of angels."], "sing": ["To produce harmonious sounds with one's voice."], "brother": ["A male person who has the same parents as another person.", "A man who is member of a religious order and lives under community rules separated from the world.", "A fellow fraternity member.", "A peer, male or female.", "An African-American male.", "Close friend."], "half-brother": ["A brother with whom one has only one parent in common."], "sister": ["A female person who has the same parents as another person.", "A female ascetic who chooses to live her life in prayer and contemplation in a monastery or convent.", "A fellow sorority member.", "An African-American female."], "change": ["To become different in essence or nature; to undergo a change.", "To make different.", "The process of becoming different.", "To put on different clothing; to change clothes.", "To exchange something old or something that has become unusable for something else of the same kind.", "Small denominations of money given in exchange for its equivalent in a larger denomination."], "soprano": ["A musical part or section that is higher than alto and all other sections, with a typical range from the A below \"middle C\" to \"high C\" (two octaves above \"middle C\")."], "celestial": ["Relating to the sky or heavens."], "alto": ["A musical part or section higher than tenor but lower than soprano, with a typical range from the F below \"middle C\" to the E a tenth above it."], "tenor": ["A musical part or section higher than bass but lower than alto, with a typical range from the C one octave below \"middle C\" to the G above.", "That which is understood from a discourse, dialogue or phrase by the way in which it is expressed.", "The general meaning or substance of an utterance."], "bass": ["A musical part or section lower than tenor and all other sections, with a typical range from the D below the bottom of the bass clef to the E above \"middle C\".", "A marine fish (Percicthyidae or Centrarchidae) that is popular as game.", "Of low frequency or range.", "A male singer who sings in the deepest vocal range.", "A sound range of low frequency or range.", "An instrument that plays sounds of low frequency.", "A musical clef indicating that the F3 note is placed on the fourth line.", "Nontechnical name for any of numerous edible marine and freshwater spiny-finned fishes."], "bride": ["A woman who is going to get married or has just got married."], "narrow": ["Having a small width.", "To reduce in width or extent."], "yes": ["A word used to show agreement or affirmation of something."], "no": ["A word used to show disagreement of something.", "A word used to confirm a negatively formulated statement.", "[Used to show disagreement or negation.]"], "because": ["[Indicates that a reason or cause follows].", "By or for the cause that; as a result of that.", "Conjunction initiating a causal phrase."], "why": ["For what reason."], "leader": ["A person who leads, rules, or is in charge.", "Leader of a department or tribe."], "chief": ["A person who leads, rules, or is in charge.", "Leader of a department or tribe.", "Leader of a tribe"], "director": ["A person who leads, rules, or is in charge.", "A person who visualizes a script, controlling the artistic and dramatic aspects, while guiding the technical crew and actors in the fulfilment of his or her vision of a film or theatre production."], "headmaster": ["The person who is in charge of and runs a school."], "parent": ["A person having one or more offsprings.", "An entity that is broader in scope.", "A person who is the caretaker of a child."], "ice cream": ["A cold dessert (made of water, cream and milk, combined with flavourings, emulsifiers and sugar) that's popular when it's hot."], "cake": ["A rich, sweet, baked dessert, typically made with flour, eggs, sugar and butter.", "To coat (something) with a layer of solid material.", "A baked delicacy."], "hello": ["Expression of greeting used by two or more people who meet each other."], "goodbye": ["A parting statement; used when one or more people in a situation, dialogue or location are leaving, while others remain."], "farewell": ["A parting statement; used when one or more people in a situation, dialogue or location are leaving, while others remain.", "An interjection of parting.", "An act of departure from a place or a group.", "An expression of good wish at a permanent departure.", "Any statement of good wish (like \"good bye\") at parting.", "A interjection of good wish at (a non-final) parting said by the staying person to the leaver."], "please": ["An expression used when a person wants something, in order to make their request more polite.", "To give pleasure to; to make happy or satisfied.", "Formal way of being polite when you give something.", "to make someone happy"], "if you please": ["An expression used when a person wants something, in order to make their request more polite."], "thank you": ["[An interjection of gratitude or politeness, used in response to something done or given.]", "An expression of gratitude"], "thanks": ["[An interjection of gratitude or politeness, used in response to something done or given.]"], "heavenly": ["Relating to the sky or heavens.", "Wonderful, lovely or amazing - in relation to a sensual experience (comparable to the experience of heaven)."], "wonderful": ["Causing wonder, admiration or astonishment.", "(of weather) highly enjoyable.", "Deserving praise; worth to be praised."], "half-sister": ["A sister with whom one has only one parent in common."], "aunt": ["A woman with one or more siblings who have one or more children; a sister of someone's father or mother."], "candle": ["A light source consisting of a wick embedded in a solid, flammable substance such as wax, tallow, or paraffin."], "ice lolly": ["A cold dessert or snack (made of water, combined with flavourings and sugar) that is popular when it's hot."], "adieu": ["A parting statement; used when one or more people in a situation, dialogue or location are leaving, while others remain.", "An expression of good wish at a permanent departure."], "bye": ["A parting statement; used when one or more people in a situation, dialogue or location are leaving, while others remain."], "bridegroom": ["A man who is going to get married or has just got married."], "groom": ["A man who is going to get married or has just got married.", "To educate for a future role or function.", "To care for one's external appearance.", "To give a neat appearance to; for care for animals by brushing and cleaning them."], "smell": ["That which is perceived by the nasal organs.", "To perceive the presence of molecules in the air by inhaling them through the nose.", "To give off a smell that can be perceived by the nose."], "Frau": ["Historically polite address for a female person"], "yesterday": ["On the day before today.", "The day before today."], "fermata": ["A piece of musical notation that indicates that the note should be held for longer than the usual duration: until the conductor cuts it off."], "your": ["Of or belonging to you (singular).", "Of or belonging to you (plural).", "Of or belonging to you (plural, formal)", "Of or belonging to you (singular, formal)."], "stop": ["To come to a halt; to cease moving.", "To render passage impossible by physical obstruction.", "An obstruction in a pipe or tube.", "To have an end, in a temporal, spatial, or quantitative sense; either spatial or metaphorical.", "A traffic sign to instruct one to be still and not proceed until the path is clear.", "A place where line buses, trams or trains halt to let passengers get on and off.", "To cause to stop (e.g. an engine or a machine).", "To put an end to a state or an activity.", "To interrupt a trip.", "To hold back, as of a danger or an enemy; check the expansion or influence of.", "To prevent completion (e.g. of a project, of negotiations, etc.)."], "pause": ["To cease or suspend an action temporarily."], "answer": ["To communicate a message of any form in reaction to something that has been asked or expressed, to the being who expressed it.", "To understand the meaning of.", "A statement (either spoken or written) that is made in reaction to a question, a request, criticism or accusation", "To respond to an incoming telephone call."], "gift": ["Something given to another person voluntarily and without charge.", "A talent or quality which is or seems innate or natural.", "To give as a present; make a gift of."], "present": ["Something given to another person voluntarily and without charge.", "Grammatical tense that describes the present or ongoing conditions.", "To have somebody see something.", "The current moment or period of time.", "Existing or happening now, in the presence; being intermediate between past and future.", "To come to the attention of medical staff.", "To give [a gift or award] in a formal manner.", "To submit (a bill or a check) for payment.", "To offer to a court or legislature for consideration.", "To introduce someone to another, in a formal manner.", "To introduce or show to the public.", "To present somebody with something, e.g. to accuse or criticize."], "noun": ["A word that can be used to refer to a person, place, thing, quality, or idea; a part of speech. It can serve as the subject or object of a verb. For example, a table or a computer."], "adverb": ["A word that modifies a verb, adjective, another adverb or a prepositional phrase."], "fat": ["Who is too fat.", "A specialized animal tissue with a high oil content, used for long-term storage of energy.", "Carrying a larger-than-normal amount of fat or weight.", "The ester of glycerol and one, two, or three fatty acids.", "Made of fat.", "(Concerning a person) He who carries a lot of fat."], "hand": ["That part of the fore limb below the forearm or wrist in primates (including humans).", "To give, transmit or pass to, using one's hand.", "A set of cards or pieces of a player at a given time during a game."], "vomit": ["To regurgitate the contents of the stomach.", "Matter ejected from the stomach through the mouth."], "overweight": ["Carrying a larger-than-normal amount of fat or weight.", "Of a large person who has a mass or quantity of fat above normal."], "peach": ["The soft, sweet, juicy fruit of the peach tree, usually with a red or orange skin, yellow flesh and a large stone inside.", "A species of tree, native to China, that bears juicy fruits, usually with a red or orange skin, yellow flesh and a large, wrinkled stone."], "today": ["The current day or date.", "On the current day or date.", "In the current era.", "Metaphoric expression for the present."], "fall": ["Move to a lower position due to the effect of gravity.", "The act of surrendering to the enemy.", "To die in battle.", "A downward slope or bend.", "To go from a higher to a lower place.", "To lose one's balance and hit the ground.", "A sudden drop from an upright position.", "A wrestling move in which a wrestler's shoulders are forced to the mat.", "To move downward and lower (e.g. of temperature values or falling objects).", "To pass suddenly and passively into a state of body or mind (e.g. into a trap, ill, in love, etc.).", "To come under, be classified or included (e.g. into a category).", "To touch or seem as if touching visually or audibly."], "prison": ["A place in which individual persons have restricted personal freedom.", "A building where people are detained after they were convicted for a crime by a court."], "a": ["One; any indefinite example of [indefinite article].", "One certain or particular.", "To; each; per.", "Singular feminine of the indefinite article", "The masculine singular indefinite article.", "A certain; a particular.", "Some; about", "A work by.", "[The indefinite article, used in a negative construction.]"], "jail": ["A place in which individual persons have restricted personal freedom.", "Putting someone in prison or in jail."], "couch": ["A piece of furniture on which more than one person can sit, with cushions, a back, and arm rests.", "Phrase in a style or language that softens or hides the intended meaning"], "bank": ["The sloping side of any hollow in the ground, especially when bordering a river.", "A financial institution where one can borrow money (upon which interest is due) or deposit money (in order to collect interest).", "Accumulation of a same substance, normally in big quantities, or arrangement of similar objects that is considered as a unit, for example: sand bank, fog bank, bank of ice.", "A place where supplies or stock of bodies or substances of the human body are preserved, usually of the same type, for future medical use, for example: blood bank, eye bank, sperm bank.", "A place where elements, usually of the same type are kept, for consultation or later use, for example: data bank, image bank.", "To tip laterally.", "To do business with a financial institution or keep an account at a financial institution.", "To act as the banker in a game or in gambling.", "To have confidence or faith in.", "A flight maneuver; the aircraft tips laterally about its longitudinal axis (especially in turning).", "A long ridge or pile."], "important": ["Having relevant and crucial value.", "Worth paying attention to."], "nowadays": ["In the current era."], "sofa": ["A piece of furniture on which more than one person can sit, with cushions, a back, and arm rests."], "settee": ["A piece of furniture on which more than one person can sit, with cushions, a back, and arm rests."], "limit": ["The point, edge, or line beyond which something cannot or may not proceed.", "To restrict; not to allow to go beyond a certain bound."], "hot": ["Having a high temperature.", "Sexually attractive.", "The quality or state of being warm.", "Characterized by violent and forceful activity or movement; very intense.", "(color) bold and intense.", "Of, pertaining to, or containing spice; or spicy flavour: Provoking a burning sensation due to the presence of chillies or similar hot spices."], "by": ["Close to; next to.", "With the use of; by means of.", "Having the position next to a given place, location or object"], "cap": ["A soft head-covering, often knitted, that fits the head closely.", "A soft head covering with a visor, most commonly of cloth.", "A usually soft and close-fitting head covering, either having no brim or with a visor."], "baby": ["A very young human being, from birth to a year old.", "A woman that is considered sexually attractive by a man, or many men.", "A project of personal concern to someone."], "elephant": ["A mammal of the order Proboscidea, having a trunk, and two large ivory tusks jutting from the upper jaw. Elephants are the largest land animals now existing."], "base": ["Any chemical species, ionic or molecular, capable of accepting or receiving a proton (hydrogen ion) from another substance; the other substance acts as an acid in giving of the proton.", "The lowest side of a in a triangle or other polygon, or the lowest face of a cone, pyramid or other polyhedron.", "Not adhering to ethical or moral principles.", "Having or showing an ignoble lack of honor or morality.", "An installation from which a military force initiates operations.", "The bottom or lowest part.", "To use as a basis for.", "To use purified cocaine by burning it and inhaling the fumes.", "The lowest support of a structure.", "The inferior part of a building, monument or furniture.", "The base of a nucleic acid, such as thymine, uracil, adenine, cytosine and guanine."], "back": ["The side of something opposite the front or useful side; the reverse side; the side that is not normally seen.", "That which is farthest away from the front.", "The part of something that goes last.", "The rear of body, especially the part between the neck and the end of the spine and opposite the chest and belly.", "In some team sports, a position behind most players on the team.", "To travel backward.", "To give support or one's approval to; to be behind; to approve of.", "The direction to here, when the subject has been here before.", "Present again.", "To be in favour of or be behind; to approve of."], "bad": ["Not good; unfavorable; negative.", "A mistake, an oversight, a slight; usually apologetic, referring to one's own failures.", "Having changed its colour, smell or composition (partially or completely), due to being attacked and decomposed by microorganisms (relating to organic matter); damaged by decay.", "With great intensity.", "Characterized by wickedness or immorality."], "error": ["A mistake, an oversight, a slight; usually apologetic, referring to one's own failures.", "Wrong or considered mistaken action.", "An incorrect action not made deliberately."], "mistake": ["A mistake, an oversight, a slight; usually apologetic, referring to one's own failures.", "To fail to understand or interpret the meaning of words or behaviour correctly.", "To make a mistake or be incorrect.", "To identify incorrectly.", "An incorrect action not made deliberately."], "bathtub": ["A tub or pool which is used for bathing."], "zero": ["The cardinal number that denotes no quantity or amount at all.", "The digit \"0\""], "bath": ["A tub or pool which is used for bathing.", "Submerging of the body into water either for washing or for recreation.", "To submerge the body into water either for washing or for recreation.", "A room containing a bath or shower and usually a washbasin and toilet"], "guard-room": ["A place, where police, soldiers, security guards, rescue teams, firemen, etc. spent their time of duty, unless, or until, incidents possibly call them out."], "duty-room": ["A place, where police, soldiers, security guards, rescue teams, firemen, etc. spent their time of duty, unless, or until, incidents possibly call them out."], "cook": ["To prepare by submerging in a liquid (usually water) at 100 degrees Celsius or more.", "A person that has prepared a meal.", "A person whose profession is to prepare food for customers.", "To apply heat to something, usually food.", "To prepare a meal or a single dish.", "To make ready for eating or drinking."], "job": ["Productive activity, service, trade, or craft for which one is regularly paid.", "A piece of work to be done, a task to be fulfilled."], "Job": ["A character of the Old Testament."], "stick": ["A long, thin piece of wood, mainly left in the shape in which it grew, that does not bend.", "An object, specifically for providing support when walking.", "To stay faithful to (an opinion, a belief, etc.).", "To come or be in close contact with; to stick or hold together and resist separation.", "To stick to firmly."], "walking stick": ["An object, specifically for providing support when walking."], "feature": ["A defining characteristic.", "A part of something that is noticeable."], "leg": ["The limb of an animal (including humans) that extends from the groin to the ankle.", "A stage of a journey.", "A single game or match played in a tournament or other sporting contest."], "newspaper": ["A publication (usually published daily or weekly and printed on cheap, low-quality paper) that contains news and other articles."], "computer": ["A programmable device that performs mathematical calculations and logical operations, especially one that can process, store and retrieve large amounts of data very quickly."], "coffee": ["A beverage made by infusing the beans of the coffee plant in hot water.", "A flowering plant of the genus Coffea whose seeds are used to make coffee."], "country": ["A people permanently occupying a fixed territory bound together by common law, habits and custom into one body politic exercising, through the medium of an organized government, independent sovereignty and control over all persons and things within its boundaries, unless or until authority is ceded to a federation or union of other states.", "A political entity asserting ultimate authority over a geographical area.", "A rural area, the countryside - as opposed to a city or town.", "The land [region] of a person's birth, citizenship, residence, etc.", "The people living within the boundaries of a sovereign state.", "A set region of land having particular human occupation or agreed limits, especially inhabited by members of the same race, language speakers etc., or associated with a given person, occupation, species etc.", "A tract of land of undefined size.", "The geographic area under the control of a political state."], "foot": ["The part of a human\u2019s body below the ankle that is used in order to stand and walk.", "A unit of measurement equal to twelve inches and one third of a yard (or exactly 30.48 centimetres).", "The lowest support of a structure."], "fork": ["A utensil with spikes used to put solid food into the mouth.", "An intersection in a road or path where one road is split into two.", "To divide into two or more branches so as to form a fork, starting from a common point.", "In a bicycle, the portion holding the front wheel, allowing the rider to steer and balance."], "finger": ["One of the long extremities of the hand that is used for gripping objects."], "wedding dress": ["Clothing worn by a bride during a wedding ceremony; traditionally white in Western culture."], "wedding ring": ["One of a pair of rings exchanged by bride and groom in a wedding ceremony; symbolizes continuous fidelity."], "wedding band": ["One of a pair of rings exchanged by bride and groom in a wedding ceremony; symbolizes continuous fidelity."], "honeymoon": ["The period of time immediately following a marriage.", "To spend one's honeymoon.", "A holiday or trip taken by a newly married couple."], "wedding gown": ["Clothing worn by a bride during a wedding ceremony; traditionally white in Western culture."], "wedding night": ["The night after the wedding, when the bride and groom spend their first official night together"], "wedding cake": ["An often multi-layered cake ceremoniously cut by the bridal pair at their wedding."], "dowry": ["An amount paid by the parents of a bride to the groom and or his family."], "wedding march": ["Music played when either the couple or the bride arrive at the wedding ceremony."], "Dutch": ["A West Germanic language spoken mainly in the Netherlands, Flanders and Suriname.", "Of or relating to the Netherlands, the Dutch people, or the Dutch language.", "A person of Dutch nationality."], "English": ["A West-Germanic langua