import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnCampaign`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html
 */
export interface CfnCampaignProps {
    /**
     * `AWS::IoTFleetWise::Campaign.Action`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action
     */
    readonly action: string;
    /**
     * `AWS::IoTFleetWise::Campaign.CollectionScheme`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme
     */
    readonly collectionScheme: CfnCampaign.CollectionSchemeProperty | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::Campaign.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name
     */
    readonly name: string;
    /**
     * `AWS::IoTFleetWise::Campaign.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn
     */
    readonly signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::Campaign.TargetArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn
     */
    readonly targetArn: string;
    /**
     * `AWS::IoTFleetWise::Campaign.Compression`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression
     */
    readonly compression?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.DataExtraDimensions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions
     */
    readonly dataExtraDimensions?: string[];
    /**
     * `AWS::IoTFleetWise::Campaign.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.DiagnosticsMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode
     */
    readonly diagnosticsMode?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.ExpiryTime`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime
     */
    readonly expiryTime?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration
     */
    readonly postTriggerCollectionDuration?: number;
    /**
     * `AWS::IoTFleetWise::Campaign.Priority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority
     */
    readonly priority?: number;
    /**
     * `AWS::IoTFleetWise::Campaign.SignalsToCollect`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect
     */
    readonly signalsToCollect?: Array<CfnCampaign.SignalInformationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::Campaign.SpoolingMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode
     */
    readonly spoolingMode?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.StartTime`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime
     */
    readonly startTime?: string;
    /**
     * `AWS::IoTFleetWise::Campaign.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::Campaign`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::Campaign
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html
 */
export declare class CfnCampaign extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::Campaign";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCampaign;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     *
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::IoTFleetWise::Campaign.Action`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action
     */
    action: string;
    /**
     * `AWS::IoTFleetWise::Campaign.CollectionScheme`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme
     */
    collectionScheme: CfnCampaign.CollectionSchemeProperty | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::Campaign.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name
     */
    name: string;
    /**
     * `AWS::IoTFleetWise::Campaign.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn
     */
    signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::Campaign.TargetArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn
     */
    targetArn: string;
    /**
     * `AWS::IoTFleetWise::Campaign.Compression`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression
     */
    compression: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.DataExtraDimensions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions
     */
    dataExtraDimensions: string[] | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.DiagnosticsMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode
     */
    diagnosticsMode: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.ExpiryTime`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime
     */
    expiryTime: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration
     */
    postTriggerCollectionDuration: number | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.Priority`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority
     */
    priority: number | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.SignalsToCollect`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect
     */
    signalsToCollect: Array<CfnCampaign.SignalInformationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.SpoolingMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode
     */
    spoolingMode: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.StartTime`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime
     */
    startTime: string | undefined;
    /**
     * `AWS::IoTFleetWise::Campaign.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::Campaign`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCampaignProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCampaign {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html
     */
    interface CollectionSchemeProperty {
        /**
         * `CfnCampaign.CollectionSchemeProperty.ConditionBasedCollectionScheme`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-conditionbasedcollectionscheme
         */
        readonly conditionBasedCollectionScheme?: CfnCampaign.ConditionBasedCollectionSchemeProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.CollectionSchemeProperty.TimeBasedCollectionScheme`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-timebasedcollectionscheme
         */
        readonly timeBasedCollectionScheme?: CfnCampaign.TimeBasedCollectionSchemeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCampaign {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html
     */
    interface ConditionBasedCollectionSchemeProperty {
        /**
         * `CfnCampaign.ConditionBasedCollectionSchemeProperty.ConditionLanguageVersion`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-conditionlanguageversion
         */
        readonly conditionLanguageVersion?: number;
        /**
         * `CfnCampaign.ConditionBasedCollectionSchemeProperty.Expression`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-expression
         */
        readonly expression: string;
        /**
         * `CfnCampaign.ConditionBasedCollectionSchemeProperty.MinimumTriggerIntervalMs`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-minimumtriggerintervalms
         */
        readonly minimumTriggerIntervalMs?: number;
        /**
         * `CfnCampaign.ConditionBasedCollectionSchemeProperty.TriggerMode`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-triggermode
         */
        readonly triggerMode?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html
     */
    interface SignalInformationProperty {
        /**
         * `CfnCampaign.SignalInformationProperty.MaxSampleCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-maxsamplecount
         */
        readonly maxSampleCount?: number;
        /**
         * `CfnCampaign.SignalInformationProperty.MinimumSamplingIntervalMs`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-minimumsamplingintervalms
         */
        readonly minimumSamplingIntervalMs?: number;
        /**
         * `CfnCampaign.SignalInformationProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-name
         */
        readonly name: string;
    }
}
export declare namespace CfnCampaign {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html
     */
    interface TimeBasedCollectionSchemeProperty {
        /**
         * `CfnCampaign.TimeBasedCollectionSchemeProperty.PeriodMs`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html#cfn-iotfleetwise-campaign-timebasedcollectionscheme-periodms
         */
        readonly periodMs: number;
    }
}
/**
 * Properties for defining a `CfnDecoderManifest`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html
 */
export interface CfnDecoderManifestProps {
    /**
     * `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn
     */
    readonly modelManifestArn: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name
     */
    readonly name: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces
     */
    readonly networkInterfaces?: Array<any | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders
     */
    readonly signalDecoders?: Array<any | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status
     */
    readonly status?: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::DecoderManifest`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::DecoderManifest
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html
 */
export declare class CfnDecoderManifest extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::DecoderManifest";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDecoderManifest;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.ModelManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn
     */
    modelManifestArn: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name
     */
    name: string;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces
     */
    networkInterfaces: Array<any | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders
     */
    signalDecoders: Array<any | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status
     */
    status: string | undefined;
    /**
     * `AWS::IoTFleetWise::DecoderManifest.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::DecoderManifest`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDecoderManifestProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html
     */
    interface CanInterfaceProperty {
        /**
         * `CfnDecoderManifest.CanInterfaceProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-name
         */
        readonly name: string;
        /**
         * `CfnDecoderManifest.CanInterfaceProperty.ProtocolName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolname
         */
        readonly protocolName?: string;
        /**
         * `CfnDecoderManifest.CanInterfaceProperty.ProtocolVersion`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-caninterface.html#cfn-iotfleetwise-decodermanifest-caninterface-protocolversion
         */
        readonly protocolVersion?: string;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html
     */
    interface CanNetworkInterfaceProperty {
        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.CanInterface`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-caninterface
         */
        readonly canInterface: CfnDecoderManifest.CanInterfaceProperty | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.InterfaceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-interfaceid
         */
        readonly interfaceId: string;
        /**
         * `CfnDecoderManifest.CanNetworkInterfaceProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cannetworkinterface.html#cfn-iotfleetwise-decodermanifest-cannetworkinterface-type
         */
        readonly type: string;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html
     */
    interface CanSignalProperty {
        /**
         * `CfnDecoderManifest.CanSignalProperty.Factor`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-factor
         */
        readonly factor: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.IsBigEndian`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-isbigendian
         */
        readonly isBigEndian: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.IsSigned`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-issigned
         */
        readonly isSigned: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.Length`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-length
         */
        readonly length: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.MessageId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-messageid
         */
        readonly messageId: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-name
         */
        readonly name?: string;
        /**
         * `CfnDecoderManifest.CanSignalProperty.Offset`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-offset
         */
        readonly offset: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalProperty.StartBit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignal.html#cfn-iotfleetwise-decodermanifest-cansignal-startbit
         */
        readonly startBit: any | cdk.IResolvable;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html
     */
    interface CanSignalDecoderProperty {
        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.CanSignal`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-cansignal
         */
        readonly canSignal: CfnDecoderManifest.CanSignalProperty | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.InterfaceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-interfaceid
         */
        readonly interfaceId: string;
        /**
         * `CfnDecoderManifest.CanSignalDecoderProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-cansignaldecoder.html#cfn-iotfleetwise-decodermanifest-cansignaldecoder-type
         */
        readonly type: string;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html
     */
    interface ObdInterfaceProperty {
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.DtcRequestIntervalSeconds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-dtcrequestintervalseconds
         */
        readonly dtcRequestIntervalSeconds?: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.HasTransmissionEcu`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-hastransmissionecu
         */
        readonly hasTransmissionEcu?: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-name
         */
        readonly name: string;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.ObdStandard`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-obdstandard
         */
        readonly obdStandard?: string;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.PidRequestIntervalSeconds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-pidrequestintervalseconds
         */
        readonly pidRequestIntervalSeconds?: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.RequestMessageId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-requestmessageid
         */
        readonly requestMessageId: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdInterfaceProperty.UseExtendedIds`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdinterface.html#cfn-iotfleetwise-decodermanifest-obdinterface-useextendedids
         */
        readonly useExtendedIds?: any | cdk.IResolvable;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html
     */
    interface ObdNetworkInterfaceProperty {
        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.InterfaceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-interfaceid
         */
        readonly interfaceId: string;
        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.ObdInterface`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-obdinterface
         */
        readonly obdInterface: CfnDecoderManifest.ObdInterfaceProperty | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdNetworkInterfaceProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdnetworkinterface.html#cfn-iotfleetwise-decodermanifest-obdnetworkinterface-type
         */
        readonly type: string;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html
     */
    interface ObdSignalProperty {
        /**
         * `CfnDecoderManifest.ObdSignalProperty.BitMaskLength`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitmasklength
         */
        readonly bitMaskLength?: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.BitRightShift`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bitrightshift
         */
        readonly bitRightShift?: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.ByteLength`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-bytelength
         */
        readonly byteLength: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.Offset`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-offset
         */
        readonly offset: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.Pid`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pid
         */
        readonly pid: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.PidResponseLength`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-pidresponselength
         */
        readonly pidResponseLength: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.Scaling`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-scaling
         */
        readonly scaling: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.ServiceMode`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-servicemode
         */
        readonly serviceMode: any | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalProperty.StartByte`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignal.html#cfn-iotfleetwise-decodermanifest-obdsignal-startbyte
         */
        readonly startByte: any | cdk.IResolvable;
    }
}
export declare namespace CfnDecoderManifest {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html
     */
    interface ObdSignalDecoderProperty {
        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.InterfaceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-interfaceid
         */
        readonly interfaceId: string;
        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.ObdSignal`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-obdsignal
         */
        readonly obdSignal: CfnDecoderManifest.ObdSignalProperty | cdk.IResolvable;
        /**
         * `CfnDecoderManifest.ObdSignalDecoderProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-decodermanifest-obdsignaldecoder.html#cfn-iotfleetwise-decodermanifest-obdsignaldecoder-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `CfnFleet`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html
 */
export interface CfnFleetProps {
    /**
     * `AWS::IoTFleetWise::Fleet.Id`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-id
     */
    readonly id: string;
    /**
     * `AWS::IoTFleetWise::Fleet.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-signalcatalogarn
     */
    readonly signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::Fleet.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTFleetWise::Fleet.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::Fleet`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::Fleet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::Fleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFleet;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     * `AWS::IoTFleetWise::Fleet.Id`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-id
     */
    id: string;
    /**
     * `AWS::IoTFleetWise::Fleet.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-signalcatalogarn
     */
    signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::Fleet.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTFleetWise::Fleet.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-fleet.html#cfn-iotfleetwise-fleet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnModelManifest`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html
 */
export interface CfnModelManifestProps {
    /**
     * `AWS::IoTFleetWise::ModelManifest.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-name
     */
    readonly name: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-signalcatalogarn
     */
    readonly signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Nodes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-nodes
     */
    readonly nodes?: string[];
    /**
     * `AWS::IoTFleetWise::ModelManifest.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-status
     */
    readonly status?: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::ModelManifest`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::ModelManifest
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html
 */
export declare class CfnModelManifest extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::ModelManifest";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelManifest;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-name
     */
    name: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.SignalCatalogArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-signalcatalogarn
     */
    signalCatalogArn: string;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Nodes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-nodes
     */
    nodes: string[] | undefined;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-status
     */
    status: string | undefined;
    /**
     * `AWS::IoTFleetWise::ModelManifest.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-modelmanifest.html#cfn-iotfleetwise-modelmanifest-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::ModelManifest`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelManifestProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnSignalCatalog`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html
 */
export interface CfnSignalCatalogProps {
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-name
     */
    readonly name?: string;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Nodes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes
     */
    readonly nodes?: Array<CfnSignalCatalog.NodeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::SignalCatalog`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::SignalCatalog
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html
 */
export declare class CfnSignalCatalog extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::SignalCatalog";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSignalCatalog;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     *
     * @cloudformationAttribute NodeCounts.TotalActuators
     */
    readonly attrNodeCountsTotalActuators: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute NodeCounts.TotalAttributes
     */
    readonly attrNodeCountsTotalAttributes: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute NodeCounts.TotalBranches
     */
    readonly attrNodeCountsTotalBranches: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute NodeCounts.TotalNodes
     */
    readonly attrNodeCountsTotalNodes: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute NodeCounts.TotalSensors
     */
    readonly attrNodeCountsTotalSensors: cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-name
     */
    name: string | undefined;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Nodes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes
     */
    nodes: Array<CfnSignalCatalog.NodeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTFleetWise::SignalCatalog.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::SignalCatalog`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSignalCatalogProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html
     */
    interface ActuatorProperty {
        /**
         * `CfnSignalCatalog.ActuatorProperty.AllowedValues`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-allowedvalues
         */
        readonly allowedValues?: string[];
        /**
         * `CfnSignalCatalog.ActuatorProperty.AssignedValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-assignedvalue
         */
        readonly assignedValue?: string;
        /**
         * `CfnSignalCatalog.ActuatorProperty.DataType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-datatype
         */
        readonly dataType: string;
        /**
         * `CfnSignalCatalog.ActuatorProperty.Description`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-description
         */
        readonly description?: string;
        /**
         * `CfnSignalCatalog.ActuatorProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
        /**
         * `CfnSignalCatalog.ActuatorProperty.Max`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-max
         */
        readonly max?: number;
        /**
         * `CfnSignalCatalog.ActuatorProperty.Min`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-min
         */
        readonly min?: number;
        /**
         * `CfnSignalCatalog.ActuatorProperty.Unit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html
     */
    interface AttributeProperty {
        /**
         * `CfnSignalCatalog.AttributeProperty.AllowedValues`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-allowedvalues
         */
        readonly allowedValues?: string[];
        /**
         * `CfnSignalCatalog.AttributeProperty.AssignedValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-assignedvalue
         */
        readonly assignedValue?: string;
        /**
         * `CfnSignalCatalog.AttributeProperty.DataType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-datatype
         */
        readonly dataType: string;
        /**
         * `CfnSignalCatalog.AttributeProperty.DefaultValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-defaultvalue
         */
        readonly defaultValue?: string;
        /**
         * `CfnSignalCatalog.AttributeProperty.Description`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-description
         */
        readonly description?: string;
        /**
         * `CfnSignalCatalog.AttributeProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
        /**
         * `CfnSignalCatalog.AttributeProperty.Max`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-max
         */
        readonly max?: number;
        /**
         * `CfnSignalCatalog.AttributeProperty.Min`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-min
         */
        readonly min?: number;
        /**
         * `CfnSignalCatalog.AttributeProperty.Unit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html
     */
    interface BranchProperty {
        /**
         * `CfnSignalCatalog.BranchProperty.Description`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-description
         */
        readonly description?: string;
        /**
         * `CfnSignalCatalog.BranchProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
    }
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html
     */
    interface NodeProperty {
        /**
         * `CfnSignalCatalog.NodeProperty.Actuator`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-actuator
         */
        readonly actuator?: CfnSignalCatalog.ActuatorProperty | cdk.IResolvable;
        /**
         * `CfnSignalCatalog.NodeProperty.Attribute`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-attribute
         */
        readonly attribute?: CfnSignalCatalog.AttributeProperty | cdk.IResolvable;
        /**
         * `CfnSignalCatalog.NodeProperty.Branch`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-branch
         */
        readonly branch?: CfnSignalCatalog.BranchProperty | cdk.IResolvable;
        /**
         * `CfnSignalCatalog.NodeProperty.Sensor`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-sensor
         */
        readonly sensor?: CfnSignalCatalog.SensorProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html
     */
    interface NodeCountsProperty {
        /**
         * `CfnSignalCatalog.NodeCountsProperty.TotalActuators`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalactuators
         */
        readonly totalActuators?: number;
        /**
         * `CfnSignalCatalog.NodeCountsProperty.TotalAttributes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalattributes
         */
        readonly totalAttributes?: number;
        /**
         * `CfnSignalCatalog.NodeCountsProperty.TotalBranches`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalbranches
         */
        readonly totalBranches?: number;
        /**
         * `CfnSignalCatalog.NodeCountsProperty.TotalNodes`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalnodes
         */
        readonly totalNodes?: number;
        /**
         * `CfnSignalCatalog.NodeCountsProperty.TotalSensors`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalsensors
         */
        readonly totalSensors?: number;
    }
}
export declare namespace CfnSignalCatalog {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html
     */
    interface SensorProperty {
        /**
         * `CfnSignalCatalog.SensorProperty.AllowedValues`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-allowedvalues
         */
        readonly allowedValues?: string[];
        /**
         * `CfnSignalCatalog.SensorProperty.DataType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-datatype
         */
        readonly dataType: string;
        /**
         * `CfnSignalCatalog.SensorProperty.Description`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-description
         */
        readonly description?: string;
        /**
         * `CfnSignalCatalog.SensorProperty.FullyQualifiedName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-fullyqualifiedname
         */
        readonly fullyQualifiedName: string;
        /**
         * `CfnSignalCatalog.SensorProperty.Max`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-max
         */
        readonly max?: number;
        /**
         * `CfnSignalCatalog.SensorProperty.Min`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-min
         */
        readonly min?: number;
        /**
         * `CfnSignalCatalog.SensorProperty.Unit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-unit
         */
        readonly unit?: string;
    }
}
/**
 * Properties for defining a `CfnVehicle`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html
 */
export interface CfnVehicleProps {
    /**
     * `AWS::IoTFleetWise::Vehicle.DecoderManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn
     */
    readonly decoderManifestArn: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.ModelManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn
     */
    readonly modelManifestArn: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name
     */
    readonly name: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.AssociationBehavior`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior
     */
    readonly associationBehavior?: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.Attributes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::IoTFleetWise::Vehicle.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTFleetWise::Vehicle`
 *
 *
 *
 * @cloudformationResource AWS::IoTFleetWise::Vehicle
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html
 */
export declare class CfnVehicle extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTFleetWise::Vehicle";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVehicle;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     *
     * @cloudformationAttribute LastModificationTime
     */
    readonly attrLastModificationTime: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.DecoderManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn
     */
    decoderManifestArn: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.ModelManifestArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn
     */
    modelManifestArn: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name
     */
    name: string;
    /**
     * `AWS::IoTFleetWise::Vehicle.AssociationBehavior`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior
     */
    associationBehavior: string | undefined;
    /**
     * `AWS::IoTFleetWise::Vehicle.Attributes`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTFleetWise::Vehicle.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTFleetWise::Vehicle`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVehicleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
