# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gotenberg_client',
 'gotenberg_client.api',
 'gotenberg_client.api.chromium',
 'gotenberg_client.api.libreoffice',
 'gotenberg_client.api.pdfengines',
 'gotenberg_client.models']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=21.3.0', 'httpx>=0.15.4,<0.23.0', 'python-dateutil>=2.8.0,<3.0.0']

setup_kwargs = {
    'name': 'gotenberg-client',
    'version': '7.0.0',
    'description': 'A client library for accessing Gotenberg',
    'long_description': '# Python client for Gotenberg\n- Client library for accessing [Gotenberg](https://gotenberg.dev/).\n- Compatible with v7 of the Gotenberg API. \n- Autogenerated using [openapi-python-client](https://github.com/openapi-generators/openapi-python-client).\n\n## Usage\nFirst, create a client:\n\n```python\nfrom gotenberg_client import Client\n\nclient = Client(base_url="http://gotenberg:3000")\n```\n\nIf the endpoints you\'re going to hit require authentication, use `AuthenticatedClient` instead:\n\n```python\nfrom gotenberg_client import AuthenticatedClient\n\nclient = AuthenticatedClient(base_url="http://gotenberg:3000", token="SuperSecretToken")\n```\n\nNow call your endpoint and use your models:\n\n```python\nfrom typing import Any\nfrom gotenberg_client.models import URLConversionRequestBody\nfrom gotenberg_client.api.chromium import post_forms_chromium_convert_url\nfrom gotenberg_client.types import Response\n\nresponse: Response[Any] = post_forms_chromium_convert_url.sync_detailed(\n   client=client, body=URLConversionRequestBody(url="http://example.org")\n)\npdf: bytes = response.content\n```\n\nOr do the same thing with an async version:\n\n```python\nfrom typing import Any\nfrom gotenberg_client.models import URLConversionRequestBody\nfrom gotenberg_client.api.chromium import post_forms_chromium_convert_url\nfrom gotenberg_client.types import Response\n\nresponse: Response[Any] = await post_forms_chromium_convert_url.asyncio_detailed(\n   client=client, body=URLConversionRequestBody(url="http://example.org")\n)\npdf: bytes = response.content\n```\n\nBy default, when you\'re calling an HTTPS API it will attempt to verify that SSL is working correctly.\nUsing certificate verification is highly recommended most of the time, but sometimes you may need\nto authenticate to a server (especially an internal server) using a custom certificate bundle.\n\n```python\nclient = AuthenticatedClient(\n    base_url="https://gotenberg.svc", \n    token="SuperSecretToken",\n    verify_ssl="/path/to/certificate_bundle.pem",\n)\n```\n\nYou can also disable certificate validation altogether, but beware that **this is a security risk**.\n\n```python\nclient = AuthenticatedClient(\n    base_url="https://gotenberg.svc", \n    token="SuperSecretToken", \n    verify_ssl=False\n)\n```\n\nSince Gotenberg returns binary responses (application/pdf),\nthe auto-parsing feature of `openapi-python-client` is omitted.\n',
    'author': 'Matyas Richter',
    'author_email': 'matyas@mrichter.cz',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/matyasrichter/gotenberg-client-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
