# Python client for Gotenberg
- Client library for accessing [Gotenberg](https://gotenberg.dev/).
- Compatible with v7 of the Gotenberg API. 
- Autogenerated using [openapi-python-client](https://github.com/openapi-generators/openapi-python-client).

## Usage
First, create a client:

```python
from gotenberg_client import Client

client = Client(base_url="http://gotenberg:3000")
```

If the endpoints you're going to hit require authentication, use `AuthenticatedClient` instead:

```python
from gotenberg_client import AuthenticatedClient

client = AuthenticatedClient(base_url="http://gotenberg:3000", token="SuperSecretToken")
```

Now call your endpoint and use your models:

```python
from typing import Any
from gotenberg_client.models import URLConversionRequestBody
from gotenberg_client.api.chromium import post_forms_chromium_convert_url
from gotenberg_client.types import Response

response: Response[Any] = post_forms_chromium_convert_url.sync_detailed(
   client=client, body=URLConversionRequestBody(url="http://example.org")
)
pdf: bytes = response.content
```

Or do the same thing with an async version:

```python
from typing import Any
from gotenberg_client.models import URLConversionRequestBody
from gotenberg_client.api.chromium import post_forms_chromium_convert_url
from gotenberg_client.types import Response

response: Response[Any] = await post_forms_chromium_convert_url.asyncio_detailed(
   client=client, body=URLConversionRequestBody(url="http://example.org")
)
pdf: bytes = response.content
```

By default, when you're calling an HTTPS API it will attempt to verify that SSL is working correctly.
Using certificate verification is highly recommended most of the time, but sometimes you may need
to authenticate to a server (especially an internal server) using a custom certificate bundle.

```python
client = AuthenticatedClient(
    base_url="https://gotenberg.svc", 
    token="SuperSecretToken",
    verify_ssl="/path/to/certificate_bundle.pem",
)
```

You can also disable certificate validation altogether, but beware that **this is a security risk**.

```python
client = AuthenticatedClient(
    base_url="https://gotenberg.svc", 
    token="SuperSecretToken", 
    verify_ssl=False
)
```

Since Gotenberg returns binary responses (application/pdf),
the auto-parsing feature of `openapi-python-client` is omitted.
