import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface StsOpts {
    /**
     * @default 1
     * @experimental
     */
    readonly replicas?: number;
    /**
     * (experimental) Container image.
     *
     * @experimental
     */
    readonly image: string;
    /**
     * (experimental) namespace.
     *
     * @default - default
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) nodeSelector params.
     *
     * @default - undefined
     * @experimental
     */
    readonly nodeSelectorParams?: {
        [name: string]: string;
    };
    /**
     * (experimental) Additional labels to apply to resources.
     *
     * @default - none
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * (experimental) Resources requests for the DB.
     *
     * @default - Requests = { CPU = 200m, Mem = 256Mi }, Limits = { CPU = 400m, Mem = 512Mi }
     * @experimental
     */
    readonly resources?: ResourceRequirements;
    /**
     * (experimental) The storage class to use for our PVC.
     *
     * @default 'gp2-expandable'
     * @experimental
     */
    readonly storageClassName?: string;
    /**
     * (experimental) The Volume size of our DB in string, e.g 10Gi, 20Gi.
     *
     * @experimental
     */
    readonly volumeSize?: string;
    /**
     * (experimental) Environment variables to pass to the pod.
     *
     * @experimental
     */
    readonly env?: {
        [name: string]: string;
    };
}
/**
 * @experimental
 */
export interface ResourceRequirements {
    /**
     * (experimental) Maximum resources for the web app.
     *
     * @default - CPU = 400m, Mem = 512Mi
     * @experimental
     */
    readonly limits?: ResourceQuantity;
    /**
     * (experimental) Required resources for the web app.
     *
     * @default - CPU = 200m, Mem = 256Mi
     * @experimental
     */
    readonly requests?: ResourceQuantity;
}
/**
 * @experimental
 */
export interface ResourceQuantity {
    /**
     * @default - no limit
     * @experimental
     */
    readonly cpu?: string;
    /**
     * @default - no limit
     * @experimental
     */
    readonly memory?: string;
}
/**
 * @experimental
 */
export declare class MyRedis extends Construct {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly namespace: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, name: string, opts: StsOpts);
}
