# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Indexes']


class Indexes(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['IndexesAclArgs']]] = None,
                 block_sign_size: Optional[pulumi.Input[int]] = None,
                 bucket_rebuild_memory_hint: Optional[pulumi.Input[str]] = None,
                 cold_path: Optional[pulumi.Input[str]] = None,
                 cold_to_frozen_dir: Optional[pulumi.Input[str]] = None,
                 cold_to_frozen_script: Optional[pulumi.Input[str]] = None,
                 compress_rawdata: Optional[pulumi.Input[bool]] = None,
                 datatype: Optional[pulumi.Input[str]] = None,
                 enable_online_bucket_repair: Optional[pulumi.Input[bool]] = None,
                 frozen_time_period_in_secs: Optional[pulumi.Input[int]] = None,
                 home_path: Optional[pulumi.Input[str]] = None,
                 max_bloom_backfill_bucket_age: Optional[pulumi.Input[str]] = None,
                 max_concurrent_optimizes: Optional[pulumi.Input[int]] = None,
                 max_data_size: Optional[pulumi.Input[str]] = None,
                 max_hot_buckets: Optional[pulumi.Input[int]] = None,
                 max_hot_idle_secs: Optional[pulumi.Input[int]] = None,
                 max_hot_span_secs: Optional[pulumi.Input[int]] = None,
                 max_mem_mb: Optional[pulumi.Input[int]] = None,
                 max_meta_entries: Optional[pulumi.Input[int]] = None,
                 max_time_unreplicated_no_acks: Optional[pulumi.Input[int]] = None,
                 max_time_unreplicated_with_acks: Optional[pulumi.Input[int]] = None,
                 max_total_data_size_mb: Optional[pulumi.Input[int]] = None,
                 max_warm_db_count: Optional[pulumi.Input[int]] = None,
                 min_raw_file_sync_secs: Optional[pulumi.Input[str]] = None,
                 min_stream_group_queue_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partial_service_meta_period: Optional[pulumi.Input[int]] = None,
                 process_tracker_service_interval: Optional[pulumi.Input[int]] = None,
                 quarantine_future_secs: Optional[pulumi.Input[int]] = None,
                 quarantine_past_secs: Optional[pulumi.Input[int]] = None,
                 raw_chunk_size_bytes: Optional[pulumi.Input[int]] = None,
                 rep_factor: Optional[pulumi.Input[str]] = None,
                 rotate_period_in_secs: Optional[pulumi.Input[int]] = None,
                 service_meta_period: Optional[pulumi.Input[int]] = None,
                 sync_meta: Optional[pulumi.Input[bool]] = None,
                 thawed_path: Optional[pulumi.Input[str]] = None,
                 throttle_check_period: Optional[pulumi.Input[int]] = None,
                 tstats_home_path: Optional[pulumi.Input[str]] = None,
                 warm_to_cold_script: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: Indexes

        Create and manage data indexes.

        ## Authorization and authentication

        By default, all users can list all indexes. However, if the indexes_list_all capability is enabled in authorize.conf, access to all indexes is limited to only those roles with this capability.
        To enable indexes_list_all capability restrictions on the data/indexes endpoint, create a [capability::indexes_list_all] stanza in authorize.conf. Specify indexes_list_all=enabled for any role permitted to list all indexes from this endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        user01_index = splunk.Indexes("user01-index",
            max_hot_buckets=6,
            max_total_data_size_mb=1000000)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IndexesAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[int] block_sign_size: Controls how many events make up a block for block signatures. If this is set to 0, block signing is disabled for this index. <br>A recommended value is 100.
        :param pulumi.Input[str] bucket_rebuild_memory_hint: Suggestion for the bucket rebuild process for the size of the time-series (tsidx) file to make.
               <be>Caution: This is an advanced parameter. Inappropriate use of this parameter causes splunkd to not start if rebuild is required. Do not set this parameter unless instructed by Splunk Support.
               Default value, auto, varies by the amount of physical RAM on the host<br>
               less than 2GB RAM = 67108864 (64MB) tsidx
               2GB to 8GB RAM = 134217728 (128MB) tsidx
               more than 8GB RAM = 268435456 (256MB) tsidx<br>
               Values other than "auto" must be 16MB-1GB. Highest legal value (of the numerical part) is 4294967295 You can specify the value using a size suffix: "16777216" or "16MB" are equivalent.
        :param pulumi.Input[str] cold_path: An absolute path that contains the colddbs for the index. The path must be readable and writable. Cold databases are opened as needed when searching.
        :param pulumi.Input[str] cold_to_frozen_dir: Destination path for the frozen archive. Use as an alternative to a coldToFrozenScript. Splunk software automatically puts frozen buckets in this directory.
               <br>
               Bucket freezing policy is as follows:<br>
               New style buckets (4.2 and on): removes all files but the rawdata<br>
               To thaw, run splunk rebuild <bucket dir> on the bucket, then move to the thawed directory<br>
               Old style buckets (Pre-4.2): gzip all the .data and .tsidx files<br>
               To thaw, gunzip the zipped files and move the bucket into the thawed directory<br>
               If both coldToFrozenDir and coldToFrozenScript are specified, coldToFrozenDir takes precedence
        :param pulumi.Input[str] cold_to_frozen_script: Path to the archiving script.
               <br>If your script requires a program to run it (for example, python), specify the program followed by the path. The script must be in $SPLUNK_HOME/bin or one of its subdirectories.
               <br>Splunk software ships with an example archiving script in $SPLUNK_HOME/bin called coldToFrozenExample.py. DO NOT use this example script directly. It uses a default path, and if modified in place any changes are overwritten on upgrade.
               <br>It is best to copy the example script to a new file in bin and modify it for your system. Most importantly, change the default archive path to an existing directory that fits your needs.
        :param pulumi.Input[bool] compress_rawdata: This parameter is ignored. The splunkd process always compresses raw data.
        :param pulumi.Input[str] datatype: Valid values: (event | metric). Specifies the type of index.
        :param pulumi.Input[bool] enable_online_bucket_repair: Enables asynchronous "online fsck" bucket repair, which runs concurrently with Splunk software.
               When enabled, you do not have to wait until buckets are repaired to start the Splunk platform. However, you might observe a slight performance degratation.
        :param pulumi.Input[int] frozen_time_period_in_secs: Number of seconds after which indexed data rolls to frozen.
               Defaults to 188697600 (6 years).Freezing data means it is removed from the index. If you need to archive your data, refer to coldToFrozenDir and coldToFrozenScript parameter documentation.
        :param pulumi.Input[str] home_path: An absolute path that contains the hot and warm buckets for the index.
               Required. Splunk software does not start if an index lacks a valid homePath.
               <br>Caution: The path must be readable and writable.
        :param pulumi.Input[str] max_bloom_backfill_bucket_age: Valid values are: Integer[m|s|h|d].
               <br>If a warm or cold bucket is older than the specified age, do not create or rebuild its bloomfilter. Specify 0 to never rebuild bloomfilters.
        :param pulumi.Input[int] max_concurrent_optimizes: The number of concurrent optimize processes that can run against a hot bucket.
               This number should be increased if instructed by Splunk Support. Typically the default value should suffice.
        :param pulumi.Input[str] max_data_size: The maximum size in MB for a hot DB to reach before a roll to warm is triggered. Specifying "auto" or "auto_high_volume" causes Splunk software to autotune this parameter (recommended).
               Use "auto_high_volume" for high volume indexes (such as the main index); otherwise, use "auto". A "high volume index" would typically be considered one that gets over 10GB of data per day.
        :param pulumi.Input[int] max_hot_buckets: Maximum hot buckets that can exist per index. Defaults to 3.
               <br>When maxHotBuckets is exceeded, Splunk software rolls the least recently used (LRU) hot bucket to warm. Both normal hot buckets and quarantined hot buckets count towards this total. This setting operates independently of maxHotIdleSecs, which can also cause hot buckets to roll.
        :param pulumi.Input[int] max_hot_idle_secs: Maximum life, in seconds, of a hot bucket. Defaults to 0. If a hot bucket exceeds maxHotIdleSecs, Splunk software rolls it to warm. This setting operates independently of maxHotBuckets, which can also cause hot buckets to roll. A value of 0 turns off the idle check (equivalent to INFINITE idle time).
        :param pulumi.Input[int] max_hot_span_secs: Upper bound of target maximum timespan of hot/warm buckets in seconds. Defaults to 7776000 seconds (90 days).
        :param pulumi.Input[int] max_mem_mb: The amount of memory, expressed in MB, to allocate for buffering a single tsidx file into memory before flushing to disk. Defaults to 5. The default is recommended for all environments.
        :param pulumi.Input[int] max_meta_entries: Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored. If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies. Highest legal value is 2147483647. To disable this parameter, set to 0.
        :param pulumi.Input[int] max_time_unreplicated_no_acks: Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored.
               If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies.
               Highest legal value is 2147483647. To disable this parameter, set to 0.
        :param pulumi.Input[int] max_time_unreplicated_with_acks: Upper limit, in seconds, on how long events can sit unacknowledged in a raw slice. Applies only if you have enabled acks on forwarders and have replication enabled (with clustering).
               Note: This is an advanced parameter. Make sure you understand the settings on all forwarders before changing this. This number should not exceed ack timeout configured on any forwarder, and should actually be set to at most half of the minimum value of that timeout. You can find this setting in outputs.conf readTimeout setting under the tcpout stanza.
               To disable, set to 0, but this is NOT recommended. Highest legal value is 2147483647.
        :param pulumi.Input[int] max_total_data_size_mb: The maximum size of an index (in MB). If an index grows larger than the maximum size, the oldest data is frozen.
        :param pulumi.Input[int] max_warm_db_count: The maximum number of warm buckets. If this number is exceeded, the warm bucket/s with the lowest value for their latest times is moved to cold.
        :param pulumi.Input[str] min_raw_file_sync_secs: Specify an integer (or "disable") for this parameter.
               This parameter sets how frequently splunkd forces a filesystem sync while compressing journal slices.
               During this period, uncompressed slices are left on disk even after they are compressed. Then splunkd forces a filesystem sync of the compressed journal and removes the accumulated uncompressed files.
               If 0 is specified, splunkd forces a filesystem sync after every slice completes compressing. Specifying "disable" disables syncing entirely: uncompressed slices are removed as soon as compression is complete.
        :param pulumi.Input[int] min_stream_group_queue_size: Minimum size of the queue that stores events in memory before committing them to a tsidx file.
        :param pulumi.Input[str] name: The name of the index to create.
        :param pulumi.Input[int] partial_service_meta_period: Related to serviceMetaPeriod. If set, it enables metadata sync every <integer> seconds, but only for records where the sync can be done efficiently in-place, without requiring a full re-write of the metadata file. Records that require full re-write are be sync'ed at serviceMetaPeriod.
               partialServiceMetaPeriod specifies, in seconds, how frequently it should sync. Zero means that this feature is turned off and serviceMetaPeriod is the only time when metadata sync happens.
               If the value of partialServiceMetaPeriod is greater than serviceMetaPeriod, this setting has no effect.
               By default it is turned off (zero).
        :param pulumi.Input[int] process_tracker_service_interval: Specifies, in seconds, how often the indexer checks the status of the child OS processes it launched to see if it can launch new processes for queued requests. Defaults to 15.
               If set to 0, the indexer checks child process status every second.
               Highest legal value is 4294967295.
        :param pulumi.Input[int] quarantine_future_secs: Events with timestamp of quarantineFutureSecs newer than "now" are dropped into quarantine bucket. Defaults to 2592000 (30 days).
               This is a mechanism to prevent main hot buckets from being polluted with fringe events.
        :param pulumi.Input[int] quarantine_past_secs: Events with timestamp of quarantinePastSecs older than "now" are dropped into quarantine bucket. Defaults to 77760000 (900 days). This is a mechanism to prevent the main hot buckets from being polluted with fringe events.
        :param pulumi.Input[int] raw_chunk_size_bytes: Target uncompressed size in bytes for individual raw slice in the rawdata journal of the index. Defaults to 131072 (128KB). 0 is not a valid value. If 0 is specified, rawChunkSizeBytes is set to the default value.
        :param pulumi.Input[str] rep_factor: Index replication control. This parameter applies to only clustering slaves.
               auto = Use the master index replication configuration value.
               0 = Turn off replication for this index.
        :param pulumi.Input[int] rotate_period_in_secs: How frequently (in seconds) to check if a new hot bucket needs to be created. Also, how frequently to check if there are any warm/cold buckets that should be rolled/frozen.
        :param pulumi.Input[int] service_meta_period: Defines how frequently metadata is synced to disk, in seconds. Defaults to 25 (seconds).
               You may want to set this to a higher value if the sum of your metadata file sizes is larger than many tens of megabytes, to avoid the hit on I/O in the indexing fast path.
        :param pulumi.Input[bool] sync_meta: When true, a sync operation is called before file descriptor is closed on metadata file updates. This functionality improves integrity of metadata files, especially in regards to operating system crashes/machine failures.
        :param pulumi.Input[str] thawed_path: An absolute path that contains the thawed (resurrected) databases for the index.
               Cannot be defined in terms of a volume definition.
               Required. Splunk software does not start if an index lacks a valid thawedPath.
        :param pulumi.Input[int] throttle_check_period: Defines how frequently Splunk software checks for index throttling condition, in seconds. Defaults to 15 (seconds).
        :param pulumi.Input[str] tstats_home_path: Location to store datamodel acceleration TSIDX data for this index. Restart splunkd after changing this parameter.
               If specified, it must be defined in terms of a volume definition.
        :param pulumi.Input[str] warm_to_cold_script: Path to a script to run when moving data from warm to cold.
               This attribute is supported for backwards compatibility with Splunk software versions older than 4.0. Contact Splunk support if you need help configuring this setting.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['block_sign_size'] = block_sign_size
            __props__['bucket_rebuild_memory_hint'] = bucket_rebuild_memory_hint
            __props__['cold_path'] = cold_path
            __props__['cold_to_frozen_dir'] = cold_to_frozen_dir
            __props__['cold_to_frozen_script'] = cold_to_frozen_script
            __props__['compress_rawdata'] = compress_rawdata
            __props__['datatype'] = datatype
            __props__['enable_online_bucket_repair'] = enable_online_bucket_repair
            __props__['frozen_time_period_in_secs'] = frozen_time_period_in_secs
            __props__['home_path'] = home_path
            __props__['max_bloom_backfill_bucket_age'] = max_bloom_backfill_bucket_age
            __props__['max_concurrent_optimizes'] = max_concurrent_optimizes
            __props__['max_data_size'] = max_data_size
            __props__['max_hot_buckets'] = max_hot_buckets
            __props__['max_hot_idle_secs'] = max_hot_idle_secs
            __props__['max_hot_span_secs'] = max_hot_span_secs
            __props__['max_mem_mb'] = max_mem_mb
            __props__['max_meta_entries'] = max_meta_entries
            __props__['max_time_unreplicated_no_acks'] = max_time_unreplicated_no_acks
            __props__['max_time_unreplicated_with_acks'] = max_time_unreplicated_with_acks
            __props__['max_total_data_size_mb'] = max_total_data_size_mb
            __props__['max_warm_db_count'] = max_warm_db_count
            __props__['min_raw_file_sync_secs'] = min_raw_file_sync_secs
            __props__['min_stream_group_queue_size'] = min_stream_group_queue_size
            __props__['name'] = name
            __props__['partial_service_meta_period'] = partial_service_meta_period
            __props__['process_tracker_service_interval'] = process_tracker_service_interval
            __props__['quarantine_future_secs'] = quarantine_future_secs
            __props__['quarantine_past_secs'] = quarantine_past_secs
            __props__['raw_chunk_size_bytes'] = raw_chunk_size_bytes
            __props__['rep_factor'] = rep_factor
            __props__['rotate_period_in_secs'] = rotate_period_in_secs
            __props__['service_meta_period'] = service_meta_period
            __props__['sync_meta'] = sync_meta
            __props__['thawed_path'] = thawed_path
            __props__['throttle_check_period'] = throttle_check_period
            __props__['tstats_home_path'] = tstats_home_path
            __props__['warm_to_cold_script'] = warm_to_cold_script
        super(Indexes, __self__).__init__(
            'splunk:index/indexes:Indexes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['IndexesAclArgs']]] = None,
            block_sign_size: Optional[pulumi.Input[int]] = None,
            bucket_rebuild_memory_hint: Optional[pulumi.Input[str]] = None,
            cold_path: Optional[pulumi.Input[str]] = None,
            cold_to_frozen_dir: Optional[pulumi.Input[str]] = None,
            cold_to_frozen_script: Optional[pulumi.Input[str]] = None,
            compress_rawdata: Optional[pulumi.Input[bool]] = None,
            datatype: Optional[pulumi.Input[str]] = None,
            enable_online_bucket_repair: Optional[pulumi.Input[bool]] = None,
            frozen_time_period_in_secs: Optional[pulumi.Input[int]] = None,
            home_path: Optional[pulumi.Input[str]] = None,
            max_bloom_backfill_bucket_age: Optional[pulumi.Input[str]] = None,
            max_concurrent_optimizes: Optional[pulumi.Input[int]] = None,
            max_data_size: Optional[pulumi.Input[str]] = None,
            max_hot_buckets: Optional[pulumi.Input[int]] = None,
            max_hot_idle_secs: Optional[pulumi.Input[int]] = None,
            max_hot_span_secs: Optional[pulumi.Input[int]] = None,
            max_mem_mb: Optional[pulumi.Input[int]] = None,
            max_meta_entries: Optional[pulumi.Input[int]] = None,
            max_time_unreplicated_no_acks: Optional[pulumi.Input[int]] = None,
            max_time_unreplicated_with_acks: Optional[pulumi.Input[int]] = None,
            max_total_data_size_mb: Optional[pulumi.Input[int]] = None,
            max_warm_db_count: Optional[pulumi.Input[int]] = None,
            min_raw_file_sync_secs: Optional[pulumi.Input[str]] = None,
            min_stream_group_queue_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partial_service_meta_period: Optional[pulumi.Input[int]] = None,
            process_tracker_service_interval: Optional[pulumi.Input[int]] = None,
            quarantine_future_secs: Optional[pulumi.Input[int]] = None,
            quarantine_past_secs: Optional[pulumi.Input[int]] = None,
            raw_chunk_size_bytes: Optional[pulumi.Input[int]] = None,
            rep_factor: Optional[pulumi.Input[str]] = None,
            rotate_period_in_secs: Optional[pulumi.Input[int]] = None,
            service_meta_period: Optional[pulumi.Input[int]] = None,
            sync_meta: Optional[pulumi.Input[bool]] = None,
            thawed_path: Optional[pulumi.Input[str]] = None,
            throttle_check_period: Optional[pulumi.Input[int]] = None,
            tstats_home_path: Optional[pulumi.Input[str]] = None,
            warm_to_cold_script: Optional[pulumi.Input[str]] = None) -> 'Indexes':
        """
        Get an existing Indexes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IndexesAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[int] block_sign_size: Controls how many events make up a block for block signatures. If this is set to 0, block signing is disabled for this index. <br>A recommended value is 100.
        :param pulumi.Input[str] bucket_rebuild_memory_hint: Suggestion for the bucket rebuild process for the size of the time-series (tsidx) file to make.
               <be>Caution: This is an advanced parameter. Inappropriate use of this parameter causes splunkd to not start if rebuild is required. Do not set this parameter unless instructed by Splunk Support.
               Default value, auto, varies by the amount of physical RAM on the host<br>
               less than 2GB RAM = 67108864 (64MB) tsidx
               2GB to 8GB RAM = 134217728 (128MB) tsidx
               more than 8GB RAM = 268435456 (256MB) tsidx<br>
               Values other than "auto" must be 16MB-1GB. Highest legal value (of the numerical part) is 4294967295 You can specify the value using a size suffix: "16777216" or "16MB" are equivalent.
        :param pulumi.Input[str] cold_path: An absolute path that contains the colddbs for the index. The path must be readable and writable. Cold databases are opened as needed when searching.
        :param pulumi.Input[str] cold_to_frozen_dir: Destination path for the frozen archive. Use as an alternative to a coldToFrozenScript. Splunk software automatically puts frozen buckets in this directory.
               <br>
               Bucket freezing policy is as follows:<br>
               New style buckets (4.2 and on): removes all files but the rawdata<br>
               To thaw, run splunk rebuild <bucket dir> on the bucket, then move to the thawed directory<br>
               Old style buckets (Pre-4.2): gzip all the .data and .tsidx files<br>
               To thaw, gunzip the zipped files and move the bucket into the thawed directory<br>
               If both coldToFrozenDir and coldToFrozenScript are specified, coldToFrozenDir takes precedence
        :param pulumi.Input[str] cold_to_frozen_script: Path to the archiving script.
               <br>If your script requires a program to run it (for example, python), specify the program followed by the path. The script must be in $SPLUNK_HOME/bin or one of its subdirectories.
               <br>Splunk software ships with an example archiving script in $SPLUNK_HOME/bin called coldToFrozenExample.py. DO NOT use this example script directly. It uses a default path, and if modified in place any changes are overwritten on upgrade.
               <br>It is best to copy the example script to a new file in bin and modify it for your system. Most importantly, change the default archive path to an existing directory that fits your needs.
        :param pulumi.Input[bool] compress_rawdata: This parameter is ignored. The splunkd process always compresses raw data.
        :param pulumi.Input[str] datatype: Valid values: (event | metric). Specifies the type of index.
        :param pulumi.Input[bool] enable_online_bucket_repair: Enables asynchronous "online fsck" bucket repair, which runs concurrently with Splunk software.
               When enabled, you do not have to wait until buckets are repaired to start the Splunk platform. However, you might observe a slight performance degratation.
        :param pulumi.Input[int] frozen_time_period_in_secs: Number of seconds after which indexed data rolls to frozen.
               Defaults to 188697600 (6 years).Freezing data means it is removed from the index. If you need to archive your data, refer to coldToFrozenDir and coldToFrozenScript parameter documentation.
        :param pulumi.Input[str] home_path: An absolute path that contains the hot and warm buckets for the index.
               Required. Splunk software does not start if an index lacks a valid homePath.
               <br>Caution: The path must be readable and writable.
        :param pulumi.Input[str] max_bloom_backfill_bucket_age: Valid values are: Integer[m|s|h|d].
               <br>If a warm or cold bucket is older than the specified age, do not create or rebuild its bloomfilter. Specify 0 to never rebuild bloomfilters.
        :param pulumi.Input[int] max_concurrent_optimizes: The number of concurrent optimize processes that can run against a hot bucket.
               This number should be increased if instructed by Splunk Support. Typically the default value should suffice.
        :param pulumi.Input[str] max_data_size: The maximum size in MB for a hot DB to reach before a roll to warm is triggered. Specifying "auto" or "auto_high_volume" causes Splunk software to autotune this parameter (recommended).
               Use "auto_high_volume" for high volume indexes (such as the main index); otherwise, use "auto". A "high volume index" would typically be considered one that gets over 10GB of data per day.
        :param pulumi.Input[int] max_hot_buckets: Maximum hot buckets that can exist per index. Defaults to 3.
               <br>When maxHotBuckets is exceeded, Splunk software rolls the least recently used (LRU) hot bucket to warm. Both normal hot buckets and quarantined hot buckets count towards this total. This setting operates independently of maxHotIdleSecs, which can also cause hot buckets to roll.
        :param pulumi.Input[int] max_hot_idle_secs: Maximum life, in seconds, of a hot bucket. Defaults to 0. If a hot bucket exceeds maxHotIdleSecs, Splunk software rolls it to warm. This setting operates independently of maxHotBuckets, which can also cause hot buckets to roll. A value of 0 turns off the idle check (equivalent to INFINITE idle time).
        :param pulumi.Input[int] max_hot_span_secs: Upper bound of target maximum timespan of hot/warm buckets in seconds. Defaults to 7776000 seconds (90 days).
        :param pulumi.Input[int] max_mem_mb: The amount of memory, expressed in MB, to allocate for buffering a single tsidx file into memory before flushing to disk. Defaults to 5. The default is recommended for all environments.
        :param pulumi.Input[int] max_meta_entries: Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored. If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies. Highest legal value is 2147483647. To disable this parameter, set to 0.
        :param pulumi.Input[int] max_time_unreplicated_no_acks: Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored.
               If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies.
               Highest legal value is 2147483647. To disable this parameter, set to 0.
        :param pulumi.Input[int] max_time_unreplicated_with_acks: Upper limit, in seconds, on how long events can sit unacknowledged in a raw slice. Applies only if you have enabled acks on forwarders and have replication enabled (with clustering).
               Note: This is an advanced parameter. Make sure you understand the settings on all forwarders before changing this. This number should not exceed ack timeout configured on any forwarder, and should actually be set to at most half of the minimum value of that timeout. You can find this setting in outputs.conf readTimeout setting under the tcpout stanza.
               To disable, set to 0, but this is NOT recommended. Highest legal value is 2147483647.
        :param pulumi.Input[int] max_total_data_size_mb: The maximum size of an index (in MB). If an index grows larger than the maximum size, the oldest data is frozen.
        :param pulumi.Input[int] max_warm_db_count: The maximum number of warm buckets. If this number is exceeded, the warm bucket/s with the lowest value for their latest times is moved to cold.
        :param pulumi.Input[str] min_raw_file_sync_secs: Specify an integer (or "disable") for this parameter.
               This parameter sets how frequently splunkd forces a filesystem sync while compressing journal slices.
               During this period, uncompressed slices are left on disk even after they are compressed. Then splunkd forces a filesystem sync of the compressed journal and removes the accumulated uncompressed files.
               If 0 is specified, splunkd forces a filesystem sync after every slice completes compressing. Specifying "disable" disables syncing entirely: uncompressed slices are removed as soon as compression is complete.
        :param pulumi.Input[int] min_stream_group_queue_size: Minimum size of the queue that stores events in memory before committing them to a tsidx file.
        :param pulumi.Input[str] name: The name of the index to create.
        :param pulumi.Input[int] partial_service_meta_period: Related to serviceMetaPeriod. If set, it enables metadata sync every <integer> seconds, but only for records where the sync can be done efficiently in-place, without requiring a full re-write of the metadata file. Records that require full re-write are be sync'ed at serviceMetaPeriod.
               partialServiceMetaPeriod specifies, in seconds, how frequently it should sync. Zero means that this feature is turned off and serviceMetaPeriod is the only time when metadata sync happens.
               If the value of partialServiceMetaPeriod is greater than serviceMetaPeriod, this setting has no effect.
               By default it is turned off (zero).
        :param pulumi.Input[int] process_tracker_service_interval: Specifies, in seconds, how often the indexer checks the status of the child OS processes it launched to see if it can launch new processes for queued requests. Defaults to 15.
               If set to 0, the indexer checks child process status every second.
               Highest legal value is 4294967295.
        :param pulumi.Input[int] quarantine_future_secs: Events with timestamp of quarantineFutureSecs newer than "now" are dropped into quarantine bucket. Defaults to 2592000 (30 days).
               This is a mechanism to prevent main hot buckets from being polluted with fringe events.
        :param pulumi.Input[int] quarantine_past_secs: Events with timestamp of quarantinePastSecs older than "now" are dropped into quarantine bucket. Defaults to 77760000 (900 days). This is a mechanism to prevent the main hot buckets from being polluted with fringe events.
        :param pulumi.Input[int] raw_chunk_size_bytes: Target uncompressed size in bytes for individual raw slice in the rawdata journal of the index. Defaults to 131072 (128KB). 0 is not a valid value. If 0 is specified, rawChunkSizeBytes is set to the default value.
        :param pulumi.Input[str] rep_factor: Index replication control. This parameter applies to only clustering slaves.
               auto = Use the master index replication configuration value.
               0 = Turn off replication for this index.
        :param pulumi.Input[int] rotate_period_in_secs: How frequently (in seconds) to check if a new hot bucket needs to be created. Also, how frequently to check if there are any warm/cold buckets that should be rolled/frozen.
        :param pulumi.Input[int] service_meta_period: Defines how frequently metadata is synced to disk, in seconds. Defaults to 25 (seconds).
               You may want to set this to a higher value if the sum of your metadata file sizes is larger than many tens of megabytes, to avoid the hit on I/O in the indexing fast path.
        :param pulumi.Input[bool] sync_meta: When true, a sync operation is called before file descriptor is closed on metadata file updates. This functionality improves integrity of metadata files, especially in regards to operating system crashes/machine failures.
        :param pulumi.Input[str] thawed_path: An absolute path that contains the thawed (resurrected) databases for the index.
               Cannot be defined in terms of a volume definition.
               Required. Splunk software does not start if an index lacks a valid thawedPath.
        :param pulumi.Input[int] throttle_check_period: Defines how frequently Splunk software checks for index throttling condition, in seconds. Defaults to 15 (seconds).
        :param pulumi.Input[str] tstats_home_path: Location to store datamodel acceleration TSIDX data for this index. Restart splunkd after changing this parameter.
               If specified, it must be defined in terms of a volume definition.
        :param pulumi.Input[str] warm_to_cold_script: Path to a script to run when moving data from warm to cold.
               This attribute is supported for backwards compatibility with Splunk software versions older than 4.0. Contact Splunk support if you need help configuring this setting.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["block_sign_size"] = block_sign_size
        __props__["bucket_rebuild_memory_hint"] = bucket_rebuild_memory_hint
        __props__["cold_path"] = cold_path
        __props__["cold_to_frozen_dir"] = cold_to_frozen_dir
        __props__["cold_to_frozen_script"] = cold_to_frozen_script
        __props__["compress_rawdata"] = compress_rawdata
        __props__["datatype"] = datatype
        __props__["enable_online_bucket_repair"] = enable_online_bucket_repair
        __props__["frozen_time_period_in_secs"] = frozen_time_period_in_secs
        __props__["home_path"] = home_path
        __props__["max_bloom_backfill_bucket_age"] = max_bloom_backfill_bucket_age
        __props__["max_concurrent_optimizes"] = max_concurrent_optimizes
        __props__["max_data_size"] = max_data_size
        __props__["max_hot_buckets"] = max_hot_buckets
        __props__["max_hot_idle_secs"] = max_hot_idle_secs
        __props__["max_hot_span_secs"] = max_hot_span_secs
        __props__["max_mem_mb"] = max_mem_mb
        __props__["max_meta_entries"] = max_meta_entries
        __props__["max_time_unreplicated_no_acks"] = max_time_unreplicated_no_acks
        __props__["max_time_unreplicated_with_acks"] = max_time_unreplicated_with_acks
        __props__["max_total_data_size_mb"] = max_total_data_size_mb
        __props__["max_warm_db_count"] = max_warm_db_count
        __props__["min_raw_file_sync_secs"] = min_raw_file_sync_secs
        __props__["min_stream_group_queue_size"] = min_stream_group_queue_size
        __props__["name"] = name
        __props__["partial_service_meta_period"] = partial_service_meta_period
        __props__["process_tracker_service_interval"] = process_tracker_service_interval
        __props__["quarantine_future_secs"] = quarantine_future_secs
        __props__["quarantine_past_secs"] = quarantine_past_secs
        __props__["raw_chunk_size_bytes"] = raw_chunk_size_bytes
        __props__["rep_factor"] = rep_factor
        __props__["rotate_period_in_secs"] = rotate_period_in_secs
        __props__["service_meta_period"] = service_meta_period
        __props__["sync_meta"] = sync_meta
        __props__["thawed_path"] = thawed_path
        __props__["throttle_check_period"] = throttle_check_period
        __props__["tstats_home_path"] = tstats_home_path
        __props__["warm_to_cold_script"] = warm_to_cold_script
        return Indexes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.IndexesAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="blockSignSize")
    def block_sign_size(self) -> pulumi.Output[int]:
        """
        Controls how many events make up a block for block signatures. If this is set to 0, block signing is disabled for this index. <br>A recommended value is 100.
        """
        return pulumi.get(self, "block_sign_size")

    @property
    @pulumi.getter(name="bucketRebuildMemoryHint")
    def bucket_rebuild_memory_hint(self) -> pulumi.Output[str]:
        """
        Suggestion for the bucket rebuild process for the size of the time-series (tsidx) file to make.
        <be>Caution: This is an advanced parameter. Inappropriate use of this parameter causes splunkd to not start if rebuild is required. Do not set this parameter unless instructed by Splunk Support.
        Default value, auto, varies by the amount of physical RAM on the host<br>
        less than 2GB RAM = 67108864 (64MB) tsidx
        2GB to 8GB RAM = 134217728 (128MB) tsidx
        more than 8GB RAM = 268435456 (256MB) tsidx<br>
        Values other than "auto" must be 16MB-1GB. Highest legal value (of the numerical part) is 4294967295 You can specify the value using a size suffix: "16777216" or "16MB" are equivalent.
        """
        return pulumi.get(self, "bucket_rebuild_memory_hint")

    @property
    @pulumi.getter(name="coldPath")
    def cold_path(self) -> pulumi.Output[str]:
        """
        An absolute path that contains the colddbs for the index. The path must be readable and writable. Cold databases are opened as needed when searching.
        """
        return pulumi.get(self, "cold_path")

    @property
    @pulumi.getter(name="coldToFrozenDir")
    def cold_to_frozen_dir(self) -> pulumi.Output[str]:
        """
        Destination path for the frozen archive. Use as an alternative to a coldToFrozenScript. Splunk software automatically puts frozen buckets in this directory.
        <br>
        Bucket freezing policy is as follows:<br>
        New style buckets (4.2 and on): removes all files but the rawdata<br>
        To thaw, run splunk rebuild <bucket dir> on the bucket, then move to the thawed directory<br>
        Old style buckets (Pre-4.2): gzip all the .data and .tsidx files<br>
        To thaw, gunzip the zipped files and move the bucket into the thawed directory<br>
        If both coldToFrozenDir and coldToFrozenScript are specified, coldToFrozenDir takes precedence
        """
        return pulumi.get(self, "cold_to_frozen_dir")

    @property
    @pulumi.getter(name="coldToFrozenScript")
    def cold_to_frozen_script(self) -> pulumi.Output[str]:
        """
        Path to the archiving script.
        <br>If your script requires a program to run it (for example, python), specify the program followed by the path. The script must be in $SPLUNK_HOME/bin or one of its subdirectories.
        <br>Splunk software ships with an example archiving script in $SPLUNK_HOME/bin called coldToFrozenExample.py. DO NOT use this example script directly. It uses a default path, and if modified in place any changes are overwritten on upgrade.
        <br>It is best to copy the example script to a new file in bin and modify it for your system. Most importantly, change the default archive path to an existing directory that fits your needs.
        """
        return pulumi.get(self, "cold_to_frozen_script")

    @property
    @pulumi.getter(name="compressRawdata")
    def compress_rawdata(self) -> pulumi.Output[bool]:
        """
        This parameter is ignored. The splunkd process always compresses raw data.
        """
        return pulumi.get(self, "compress_rawdata")

    @property
    @pulumi.getter
    def datatype(self) -> pulumi.Output[str]:
        """
        Valid values: (event | metric). Specifies the type of index.
        """
        return pulumi.get(self, "datatype")

    @property
    @pulumi.getter(name="enableOnlineBucketRepair")
    def enable_online_bucket_repair(self) -> pulumi.Output[bool]:
        """
        Enables asynchronous "online fsck" bucket repair, which runs concurrently with Splunk software.
        When enabled, you do not have to wait until buckets are repaired to start the Splunk platform. However, you might observe a slight performance degratation.
        """
        return pulumi.get(self, "enable_online_bucket_repair")

    @property
    @pulumi.getter(name="frozenTimePeriodInSecs")
    def frozen_time_period_in_secs(self) -> pulumi.Output[int]:
        """
        Number of seconds after which indexed data rolls to frozen.
        Defaults to 188697600 (6 years).Freezing data means it is removed from the index. If you need to archive your data, refer to coldToFrozenDir and coldToFrozenScript parameter documentation.
        """
        return pulumi.get(self, "frozen_time_period_in_secs")

    @property
    @pulumi.getter(name="homePath")
    def home_path(self) -> pulumi.Output[str]:
        """
        An absolute path that contains the hot and warm buckets for the index.
        Required. Splunk software does not start if an index lacks a valid homePath.
        <br>Caution: The path must be readable and writable.
        """
        return pulumi.get(self, "home_path")

    @property
    @pulumi.getter(name="maxBloomBackfillBucketAge")
    def max_bloom_backfill_bucket_age(self) -> pulumi.Output[str]:
        """
        Valid values are: Integer[m|s|h|d].
        <br>If a warm or cold bucket is older than the specified age, do not create or rebuild its bloomfilter. Specify 0 to never rebuild bloomfilters.
        """
        return pulumi.get(self, "max_bloom_backfill_bucket_age")

    @property
    @pulumi.getter(name="maxConcurrentOptimizes")
    def max_concurrent_optimizes(self) -> pulumi.Output[int]:
        """
        The number of concurrent optimize processes that can run against a hot bucket.
        This number should be increased if instructed by Splunk Support. Typically the default value should suffice.
        """
        return pulumi.get(self, "max_concurrent_optimizes")

    @property
    @pulumi.getter(name="maxDataSize")
    def max_data_size(self) -> pulumi.Output[str]:
        """
        The maximum size in MB for a hot DB to reach before a roll to warm is triggered. Specifying "auto" or "auto_high_volume" causes Splunk software to autotune this parameter (recommended).
        Use "auto_high_volume" for high volume indexes (such as the main index); otherwise, use "auto". A "high volume index" would typically be considered one that gets over 10GB of data per day.
        """
        return pulumi.get(self, "max_data_size")

    @property
    @pulumi.getter(name="maxHotBuckets")
    def max_hot_buckets(self) -> pulumi.Output[int]:
        """
        Maximum hot buckets that can exist per index. Defaults to 3.
        <br>When maxHotBuckets is exceeded, Splunk software rolls the least recently used (LRU) hot bucket to warm. Both normal hot buckets and quarantined hot buckets count towards this total. This setting operates independently of maxHotIdleSecs, which can also cause hot buckets to roll.
        """
        return pulumi.get(self, "max_hot_buckets")

    @property
    @pulumi.getter(name="maxHotIdleSecs")
    def max_hot_idle_secs(self) -> pulumi.Output[int]:
        """
        Maximum life, in seconds, of a hot bucket. Defaults to 0. If a hot bucket exceeds maxHotIdleSecs, Splunk software rolls it to warm. This setting operates independently of maxHotBuckets, which can also cause hot buckets to roll. A value of 0 turns off the idle check (equivalent to INFINITE idle time).
        """
        return pulumi.get(self, "max_hot_idle_secs")

    @property
    @pulumi.getter(name="maxHotSpanSecs")
    def max_hot_span_secs(self) -> pulumi.Output[int]:
        """
        Upper bound of target maximum timespan of hot/warm buckets in seconds. Defaults to 7776000 seconds (90 days).
        """
        return pulumi.get(self, "max_hot_span_secs")

    @property
    @pulumi.getter(name="maxMemMb")
    def max_mem_mb(self) -> pulumi.Output[int]:
        """
        The amount of memory, expressed in MB, to allocate for buffering a single tsidx file into memory before flushing to disk. Defaults to 5. The default is recommended for all environments.
        """
        return pulumi.get(self, "max_mem_mb")

    @property
    @pulumi.getter(name="maxMetaEntries")
    def max_meta_entries(self) -> pulumi.Output[int]:
        """
        Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored. If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies. Highest legal value is 2147483647. To disable this parameter, set to 0.
        """
        return pulumi.get(self, "max_meta_entries")

    @property
    @pulumi.getter(name="maxTimeUnreplicatedNoAcks")
    def max_time_unreplicated_no_acks(self) -> pulumi.Output[int]:
        """
        Upper limit, in seconds, on how long an event can sit in raw slice. Applies only if replication is enabled for this index. Otherwise ignored.
        If there are any acknowledged events sharing this raw slice, this paramater does not apply. In this case, maxTimeUnreplicatedWithAcks applies.
        Highest legal value is 2147483647. To disable this parameter, set to 0.
        """
        return pulumi.get(self, "max_time_unreplicated_no_acks")

    @property
    @pulumi.getter(name="maxTimeUnreplicatedWithAcks")
    def max_time_unreplicated_with_acks(self) -> pulumi.Output[int]:
        """
        Upper limit, in seconds, on how long events can sit unacknowledged in a raw slice. Applies only if you have enabled acks on forwarders and have replication enabled (with clustering).
        Note: This is an advanced parameter. Make sure you understand the settings on all forwarders before changing this. This number should not exceed ack timeout configured on any forwarder, and should actually be set to at most half of the minimum value of that timeout. You can find this setting in outputs.conf readTimeout setting under the tcpout stanza.
        To disable, set to 0, but this is NOT recommended. Highest legal value is 2147483647.
        """
        return pulumi.get(self, "max_time_unreplicated_with_acks")

    @property
    @pulumi.getter(name="maxTotalDataSizeMb")
    def max_total_data_size_mb(self) -> pulumi.Output[int]:
        """
        The maximum size of an index (in MB). If an index grows larger than the maximum size, the oldest data is frozen.
        """
        return pulumi.get(self, "max_total_data_size_mb")

    @property
    @pulumi.getter(name="maxWarmDbCount")
    def max_warm_db_count(self) -> pulumi.Output[int]:
        """
        The maximum number of warm buckets. If this number is exceeded, the warm bucket/s with the lowest value for their latest times is moved to cold.
        """
        return pulumi.get(self, "max_warm_db_count")

    @property
    @pulumi.getter(name="minRawFileSyncSecs")
    def min_raw_file_sync_secs(self) -> pulumi.Output[str]:
        """
        Specify an integer (or "disable") for this parameter.
        This parameter sets how frequently splunkd forces a filesystem sync while compressing journal slices.
        During this period, uncompressed slices are left on disk even after they are compressed. Then splunkd forces a filesystem sync of the compressed journal and removes the accumulated uncompressed files.
        If 0 is specified, splunkd forces a filesystem sync after every slice completes compressing. Specifying "disable" disables syncing entirely: uncompressed slices are removed as soon as compression is complete.
        """
        return pulumi.get(self, "min_raw_file_sync_secs")

    @property
    @pulumi.getter(name="minStreamGroupQueueSize")
    def min_stream_group_queue_size(self) -> pulumi.Output[int]:
        """
        Minimum size of the queue that stores events in memory before committing them to a tsidx file.
        """
        return pulumi.get(self, "min_stream_group_queue_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the index to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="partialServiceMetaPeriod")
    def partial_service_meta_period(self) -> pulumi.Output[int]:
        """
        Related to serviceMetaPeriod. If set, it enables metadata sync every <integer> seconds, but only for records where the sync can be done efficiently in-place, without requiring a full re-write of the metadata file. Records that require full re-write are be sync'ed at serviceMetaPeriod.
        partialServiceMetaPeriod specifies, in seconds, how frequently it should sync. Zero means that this feature is turned off and serviceMetaPeriod is the only time when metadata sync happens.
        If the value of partialServiceMetaPeriod is greater than serviceMetaPeriod, this setting has no effect.
        By default it is turned off (zero).
        """
        return pulumi.get(self, "partial_service_meta_period")

    @property
    @pulumi.getter(name="processTrackerServiceInterval")
    def process_tracker_service_interval(self) -> pulumi.Output[int]:
        """
        Specifies, in seconds, how often the indexer checks the status of the child OS processes it launched to see if it can launch new processes for queued requests. Defaults to 15.
        If set to 0, the indexer checks child process status every second.
        Highest legal value is 4294967295.
        """
        return pulumi.get(self, "process_tracker_service_interval")

    @property
    @pulumi.getter(name="quarantineFutureSecs")
    def quarantine_future_secs(self) -> pulumi.Output[int]:
        """
        Events with timestamp of quarantineFutureSecs newer than "now" are dropped into quarantine bucket. Defaults to 2592000 (30 days).
        This is a mechanism to prevent main hot buckets from being polluted with fringe events.
        """
        return pulumi.get(self, "quarantine_future_secs")

    @property
    @pulumi.getter(name="quarantinePastSecs")
    def quarantine_past_secs(self) -> pulumi.Output[int]:
        """
        Events with timestamp of quarantinePastSecs older than "now" are dropped into quarantine bucket. Defaults to 77760000 (900 days). This is a mechanism to prevent the main hot buckets from being polluted with fringe events.
        """
        return pulumi.get(self, "quarantine_past_secs")

    @property
    @pulumi.getter(name="rawChunkSizeBytes")
    def raw_chunk_size_bytes(self) -> pulumi.Output[int]:
        """
        Target uncompressed size in bytes for individual raw slice in the rawdata journal of the index. Defaults to 131072 (128KB). 0 is not a valid value. If 0 is specified, rawChunkSizeBytes is set to the default value.
        """
        return pulumi.get(self, "raw_chunk_size_bytes")

    @property
    @pulumi.getter(name="repFactor")
    def rep_factor(self) -> pulumi.Output[str]:
        """
        Index replication control. This parameter applies to only clustering slaves.
        auto = Use the master index replication configuration value.
        0 = Turn off replication for this index.
        """
        return pulumi.get(self, "rep_factor")

    @property
    @pulumi.getter(name="rotatePeriodInSecs")
    def rotate_period_in_secs(self) -> pulumi.Output[int]:
        """
        How frequently (in seconds) to check if a new hot bucket needs to be created. Also, how frequently to check if there are any warm/cold buckets that should be rolled/frozen.
        """
        return pulumi.get(self, "rotate_period_in_secs")

    @property
    @pulumi.getter(name="serviceMetaPeriod")
    def service_meta_period(self) -> pulumi.Output[int]:
        """
        Defines how frequently metadata is synced to disk, in seconds. Defaults to 25 (seconds).
        You may want to set this to a higher value if the sum of your metadata file sizes is larger than many tens of megabytes, to avoid the hit on I/O in the indexing fast path.
        """
        return pulumi.get(self, "service_meta_period")

    @property
    @pulumi.getter(name="syncMeta")
    def sync_meta(self) -> pulumi.Output[bool]:
        """
        When true, a sync operation is called before file descriptor is closed on metadata file updates. This functionality improves integrity of metadata files, especially in regards to operating system crashes/machine failures.
        """
        return pulumi.get(self, "sync_meta")

    @property
    @pulumi.getter(name="thawedPath")
    def thawed_path(self) -> pulumi.Output[str]:
        """
        An absolute path that contains the thawed (resurrected) databases for the index.
        Cannot be defined in terms of a volume definition.
        Required. Splunk software does not start if an index lacks a valid thawedPath.
        """
        return pulumi.get(self, "thawed_path")

    @property
    @pulumi.getter(name="throttleCheckPeriod")
    def throttle_check_period(self) -> pulumi.Output[int]:
        """
        Defines how frequently Splunk software checks for index throttling condition, in seconds. Defaults to 15 (seconds).
        """
        return pulumi.get(self, "throttle_check_period")

    @property
    @pulumi.getter(name="tstatsHomePath")
    def tstats_home_path(self) -> pulumi.Output[str]:
        """
        Location to store datamodel acceleration TSIDX data for this index. Restart splunkd after changing this parameter.
        If specified, it must be defined in terms of a volume definition.
        """
        return pulumi.get(self, "tstats_home_path")

    @property
    @pulumi.getter(name="warmToColdScript")
    def warm_to_cold_script(self) -> pulumi.Output[str]:
        """
        Path to a script to run when moving data from warm to cold.
        This attribute is supported for backwards compatibility with Splunk software versions older than 4.0. Contact Splunk support if you need help configuring this setting.
        """
        return pulumi.get(self, "warm_to_cold_script")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

