from _typeshed import StrPath
from lib2to3.pgen2 import grammar
from lib2to3.pgen2.tokenize import _TokenInfo
from typing import IO, Any, Dict, Iterable, Iterator, List, NoReturn, Optional, Tuple

class PgenGrammar(grammar.Grammar): ...

class ParserGenerator:
    filename: StrPath
    stream: IO[str]
    generator: Iterator[_TokenInfo]
    first: Dict[str, Dict[str, int]]
    def __init__(self, filename: StrPath, stream: Optional[IO[str]] = ...) -> None: ...
    def make_grammar(self) -> PgenGrammar: ...
    def make_first(self, c: PgenGrammar, name: str) -> Dict[int, int]: ...
    def make_label(self, c: PgenGrammar, label: str) -> int: ...
    def addfirstsets(self) -> None: ...
    def calcfirst(self, name: str) -> None: ...
    def parse(self) -> Tuple[Dict[str, List[DFAState]], str]: ...
    def make_dfa(self, start: NFAState, finish: NFAState) -> List[DFAState]: ...
    def dump_nfa(self, name: str, start: NFAState, finish: NFAState) -> List[DFAState]: ...
    def dump_dfa(self, name: str, dfa: Iterable[DFAState]) -> None: ...
    def simplify_dfa(self, dfa: List[DFAState]) -> None: ...
    def parse_rhs(self) -> Tuple[NFAState, NFAState]: ...
    def parse_alt(self) -> Tuple[NFAState, NFAState]: ...
    def parse_item(self) -> Tuple[NFAState, NFAState]: ...
    def parse_atom(self) -> Tuple[NFAState, NFAState]: ...
    def expect(self, type: int, value: Optional[Any] = ...) -> str: ...
    def gettoken(self) -> None: ...
    def raise_error(self, msg: str, *args: Any) -> NoReturn: ...

class NFAState:
    arcs: List[Tuple[Optional[str], NFAState]]
    def __init__(self) -> None: ...
    def addarc(self, next: NFAState, label: Optional[str] = ...) -> None: ...

class DFAState:
    nfaset: Dict[NFAState, Any]
    isfinal: bool
    arcs: Dict[str, DFAState]
    def __init__(self, nfaset: Dict[NFAState, Any], final: NFAState) -> None: ...
    def addarc(self, next: DFAState, label: str) -> None: ...
    def unifystate(self, old: DFAState, new: DFAState) -> None: ...
    def __eq__(self, other: Any) -> bool: ...

def generate_grammar(filename: StrPath = ...) -> PgenGrammar: ...
