import sys
from typing import NoReturn, Optional, Sequence, Union

ACCESS_DEFAULT: int
ACCESS_READ: int
ACCESS_WRITE: int
ACCESS_COPY: int

ALLOCATIONGRANULARITY: int

if sys.platform == "linux":
    MAP_DENYWRITE: int
    MAP_EXECUTABLE: int

if sys.platform != "win32":
    MAP_ANON: int
    MAP_ANONYMOUS: int
    MAP_PRIVATE: int
    MAP_SHARED: int
    PROT_EXEC: int
    PROT_READ: int
    PROT_WRITE: int

    PAGESIZE: int

class mmap(Sequence[bytes]):
    if sys.platform == "win32":
        def __init__(
            self, fileno: int, length: int, tagname: Optional[str] = ..., access: int = ..., offset: int = ...
        ) -> None: ...
    else:
        def __init__(
            self, fileno: int, length: int, flags: int = ..., prot: int = ..., access: int = ..., offset: int = ...
        ) -> None: ...
    def close(self) -> None: ...
    def flush(self, offset: int = ..., size: int = ...) -> int: ...
    def move(self, dest: int, src: int, count: int) -> None: ...
    def read_byte(self) -> bytes: ...
    def readline(self) -> bytes: ...
    def resize(self, newsize: int) -> None: ...
    def seek(self, pos: int, whence: int = ...) -> None: ...
    def size(self) -> int: ...
    def tell(self) -> int: ...
    def write_byte(self, byte: bytes) -> None: ...
    def __len__(self) -> int: ...
    def find(self, string: bytes, start: int = ..., end: int = ...) -> int: ...
    def rfind(self, string: bytes, start: int = ..., stop: int = ...) -> int: ...
    def read(self, num: int) -> bytes: ...
    def write(self, string: bytes) -> None: ...
    def __getitem__(self, index: Union[int, slice]) -> bytes: ...
    def __getslice__(self, i: Optional[int], j: Optional[int]) -> bytes: ...
    def __delitem__(self, index: Union[int, slice]) -> NoReturn: ...
    def __setitem__(self, index: Union[int, slice], object: bytes) -> None: ...
