from typing import Any, Dict, List, Optional, Type, Union

from com.inductiveautomation.ignition.common import BasicDataset, Dataset
from com.inductiveautomation.ignition.common.script.builtin import DatasetUtilities
from dev.thecesrom.helper.types import AnyStr
from java.util import Date, Locale

ColType = Union[Date, float, int, str, unicode]

def addColumn(
    dataset: BasicDataset,
    colIndex: int,
    col: List[Any],
    colName: AnyStr,
    colType: Type[ColType],
) -> BasicDataset: ...
def addRow(dataset: BasicDataset, rowIndex: int, row: List[Any]) -> BasicDataset: ...
def addRows(
    dataset: BasicDataset, rowIndex: int, rows: List[List[Any]]
) -> BasicDataset: ...
def appendDataset(dataset1: BasicDataset, dataset2: BasicDataset) -> BasicDataset: ...
def clearDataset(dataset: BasicDataset) -> BasicDataset: ...
def dataSetToHTML(
    showHeaders: bool, dataset: BasicDataset, title: AnyStr
) -> AnyStr: ...
def deleteRow(dataset: BasicDataset, rowIndex: int) -> BasicDataset: ...
def deleteRows(dataset: BasicDataset, rowIndices: List[int]) -> BasicDataset: ...
def exportCSV(filename: AnyStr, showHeaders: bool, dataset: BasicDataset) -> AnyStr: ...
def exportExcel(
    filename: AnyStr,
    showHeaders: bool,
    dataset: List[BasicDataset],
    nullsEmpty: bool = ...,
) -> AnyStr: ...
def exportHTML(
    filename: AnyStr, showHeaders: bool, dataset: BasicDataset, title: AnyStr
) -> AnyStr: ...
def filterColumns(
    dataset: BasicDataset, columns: Union[List[AnyStr], List[int]]
) -> BasicDataset: ...
def formatDates(
    dataset: BasicDataset, dateFormat: AnyStr, locale: Optional[Locale] = ...
) -> BasicDataset: ...
def fromCSV(csv: AnyStr) -> BasicDataset: ...
def getColumnHeaders(dataset: BasicDataset) -> List[AnyStr]: ...
def setValue(
    dataset: BasicDataset, rowIndex: int, columnName: AnyStr, value: Any
) -> BasicDataset: ...
def sort(
    dataset: BasicDataset, keyColumn: Union[AnyStr, int], ascending: bool = ...
) -> BasicDataset: ...
def toCSV(
    dataset: BasicDataset,
    showHeaders: bool = ...,
    forExport: bool = ...,
    localized: bool = ...,
) -> AnyStr: ...
def toDataSet(*args: Any) -> BasicDataset: ...
def toExcel(
    showHeaders: bool,
    dataset: List[BasicDataset],
    nullsEmpty: bool = ...,
    sheetNames: Optional[List[AnyStr]] = ...,
) -> Any: ...
def toPyDataSet(dataset: Dataset) -> DatasetUtilities.PyDataSet: ...
def updateRow(
    dataset: BasicDataset, rowIndex: int, changes: Dict[AnyStr, Any]
) -> BasicDataset: ...
