from typing import Any, Iterator, Optional, Union

from dev.thecesrom.helper.types import AnyStr
from java.lang import Class
from org.python.core import PyInteger, PyList, PyObject, PySequence

class JythonMap:
    def __contains__(self, pyKey: PyObject) -> bool: ...
    def __finditem__(self, key: Union[int, PyObject, AnyStr]) -> PyObject: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __len__(self) -> int: ...
    def get(self, pyKey: PyObject, def_: Optional[PyObject] = ...) -> PyObject: ...
    def has_key(self, pyKey: PyObject) -> bool: ...
    def items(self) -> PyList: ...
    def iteritems(self) -> PyObject: ...
    def iterkeys(self) -> PyObject: ...
    def itervalues(self) -> PyObject: ...
    def keys(self) -> PyList: ...
    def values(self) -> PyList: ...

class JythonSequence:
    def __contains__(self, o: PyObject) -> bool: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __len__(self) -> int: ...
    def __mul__(self, other: PyObject) -> PyObject: ...
    def __rmul__(self, other: PyObject) -> PyObject: ...
    def count(self, element: PyObject) -> PyInteger: ...
    def index(self, element: PyObject) -> int: ...

class MutableJythonMap:
    def __delitem__(self, pyKey: PyObject) -> None: ...
    def __setitem__(self, pyKey: PyObject, pyValue: PyObject) -> None: ...
    def clear(self) -> None: ...
    def pop(self, pyKey: PyObject, def_: Optional[PyObject] = ...) -> PyObject: ...
    def popitem(self) -> PyObject: ...
    def setdefault(
        self, pyKey: PyObject, def_: Optional[PyObject] = ...
    ) -> PyObject: ...
    def update(self, *args: PyObject, **kwargs: AnyStr) -> None: ...

class MutableJythonSequence(JythonSequence):
    def __add__(self, other: PyObject) -> PyObject: ...
    def __contains__(self, o: PyObject) -> bool: ...
    def __imul__(self, other: PyObject) -> PyObject: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __len__(self) -> int: ...
    def __mul__(self, other: PyObject) -> PyObject: ...
    def __rmul__(self, other: PyObject) -> PyObject: ...
    def append(self, element: PyObject) -> None: ...
    def count(self, element: PyObject) -> PyInteger: ...
    def extend(self, sequence: PyObject) -> None: ...
    def index(self, element: PyObject) -> int: ...
    def insert(self, index: int, element: PyObject) -> None: ...
    def pop(self, index: Optional[int] = ...) -> PyObject: ...
    def remove(self, element: PyObject) -> None: ...
    def sort(self, *args: PyObject, **kwargs: AnyStr) -> None: ...

class AbstractJythonMap(JythonMap):
    def __contains__(self, pyKey: PyObject) -> bool: ...
    def __finditem__(self, key: Union[int, PyObject, AnyStr]) -> PyObject: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __len__(self) -> int: ...
    def get(self, pyKey: PyObject, def_: Optional[PyObject] = ...) -> PyObject: ...
    def has_key(self, pyKey: PyObject) -> bool: ...
    def items(self) -> PyList: ...
    def iteritems(self) -> PyObject: ...
    def iterkeys(self) -> PyObject: ...
    def itervalues(self) -> PyObject: ...
    def keys(self) -> PyList: ...
    def values(self) -> PyList: ...

class AbstractJythonSequence(PySequence, JythonSequence):
    def __init__(self, clazz: Class) -> None: ...
    def __add__(self, other: PyObject) -> PyObject: ...
    def __len__(self) -> int: ...
    def __mul__(self, other: PyObject) -> PyObject: ...
    def count(self, element: PyObject) -> PyInteger: ...
    def index(self, element: PyObject) -> int: ...

class AbstractMutableJythonMap(MutableJythonMap):
    def __delitem__(self, pyKey: PyObject) -> None: ...
    def __setitem__(self, pyKey: PyObject, value: PyObject) -> None: ...
    def clear(self) -> None: ...
    def pop(self, pyKey: PyObject, def_: Optional[PyObject] = ...) -> PyObject: ...
    def popitem(self) -> PyObject: ...
    def setdefault(
        self, pyKey: PyObject, def_: Optional[PyObject] = ...
    ) -> PyObject: ...
    def update(self, *args: PyObject, **kwargs: AnyStr) -> None: ...

class AbstractMutableJythonSequence(AbstractJythonSequence, MutableJythonSequence):
    def __add__(self, other: PyObject) -> PyObject: ...
    def append(self, element: PyObject) -> None: ...
    def extend(self, sequence: PyObject) -> None: ...
    def insert(self, index: int, element: PyObject) -> None: ...
    def pop(self, index: Optional[int] = ...) -> PyObject: ...
    def remove(self, element: PyObject) -> None: ...
    def sort(self, *args: PyObject, **kwargs: AnyStr) -> None: ...
