from typing import Any, List, Optional

from dev.thecesrom.helper.types import AnyStr
from java.lang import Class, Enum, Object, StringBuilder

class OPCBrowseElement:
    def getDataType(self) -> Class: ...
    def getDescription(self) -> AnyStr: ...
    def getDisplayName(self) -> AnyStr: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> AnyStr: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class ServerNodeId:
    def getNodeId(self) -> AnyStr: ...
    def getServerName(self) -> AnyStr: ...

class BasicOPCBrowseElement(Object, OPCBrowseElement):
    def __init__(self, *args: Any) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> AnyStr: ...
    def getDisplayName(self) -> AnyStr: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> AnyStr: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class BasicServerNodeId(Object, ServerNodeId):
    nodeId: AnyStr
    serverName: AnyStr
    def __init__(self, serverName: AnyStr, nodeId: AnyStr) -> None: ...
    def getNodeId(self) -> AnyStr: ...
    def getServerName(self) -> AnyStr: ...

class BrowseElement(Object):
    PROP_PROVIDER: int
    PROP_DRIVER: int
    def __init__(self, itemType: Optional[int] = ...) -> None: ...
    def addProperty(self, id_: int, name: AnyStr, value: AnyStr) -> None: ...
    def asServerNodeId(self) -> ServerNodeId: ...
    def createRequestElement(self, type_: int) -> BrowseElement: ...
    def fillInDetails(self, elm: BrowseElement) -> None: ...
    def getBrowsePath(self) -> AnyStr: ...
    def getItemId(self) -> AnyStr: ...
    def getItemName(self) -> AnyStr: ...
    def getItemType(self) -> Optional[int]: ...
    def getProperties(self) -> List[BrowseElement.PropertyElement]: ...
    def getProperty(self, id_: int) -> BrowseElement.PropertyElement: ...
    def getServer(self) -> AnyStr: ...
    def isComplete(self) -> bool: ...
    def setBrowsePath(self, browsePath: AnyStr) -> None: ...
    def setComplete(self, value: bool) -> None: ...
    def setItemId(self, itemId: AnyStr) -> None: ...
    def setItemName(self, itemName: AnyStr) -> None: ...
    def setItemType(self, itemType: int) -> None: ...
    def setServer(self, server: AnyStr) -> None: ...
    @staticmethod
    def toBrowseElement(opcElem: OPCBrowseElement) -> BrowseElement: ...
    @staticmethod
    def toBrowseElements(
        opcElements: List[OPCBrowseElement],
    ) -> List[BrowseElement]: ...
    @staticmethod
    def toServerNodeId(elem: BrowseElement) -> ServerNodeId: ...
    def toXML(
        self,
        out: StringBuilder,
        type_: Optional[int] = ...,
        includeProperties: Optional[bool] = ...,
    ) -> None: ...

    class PropertyElement(Object):
        id: int
        name: AnyStr
        value: AnyStr
        def __init__(self, id_: int, name: AnyStr, value: AnyStr) -> None: ...
        def getId(self) -> int: ...
        def getName(self) -> AnyStr: ...
        def getValue(self) -> AnyStr: ...

class BrowseElementType(Enum):
    DATAVARIABLE: BrowseElementType
    DEVICE: BrowseElementType
    FOLDER: BrowseElementType
    METHOD: BrowseElementType
    OBJECT: BrowseElementType
    PROPERTY: BrowseElementType
    SERVER: BrowseElementType
    VIEW: BrowseElementType
    def isSubscribable(self) -> bool: ...
    @staticmethod
    def values() -> List[BrowseElementType]: ...

class ServerBrowseElement(Object, OPCBrowseElement):
    nodeId: ServerNodeId
    def __init__(self, serverName: AnyStr) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> AnyStr: ...
    def getDisplayName(self) -> AnyStr: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> AnyStr: ...
    def getServerNodeId(self) -> ServerNodeId: ...
