import os

import ansible_runner

config = {
    # base
    'base_root_path': '/mnt/data/starwhale-b',
    'sw_version': 'latest',
    'sw_repository': 'starwhaleai',  # or else ghcr.io/star-whale

    # mysql
    'mysql_image': 'mysql:8.0-debian',
    'mysql_port': '3406',
    'mysql_root_pwd': 'starwhale',
    'mysql_data_dir': '{{ base_root_path }}/local-storage-mysql',

    # minio
    'minio_image': 'quay.io/minio/minio',
    'minio_data_dir': '{{ base_root_path }}/local-storage',
    'minio_default_bucket': 'starwhale',
    'minio_access_key': 'minioadmin',
    'minio_secret_key': 'minioadmin',
    # reason: minio docker file expose fixed port
    'minio_server_port': '9000',
    'minio_console_port': '9001',

    # controller variables
    'controller_image': '{{ sw_repository }}/server:{{ sw_version }}',
    'controller_task_split_num': '2',
    'controller_port': '8182',

    # agent variables
    # agent
    'agent_image': '{{ sw_repository }}/server:{{ sw_version }}',
    # task storage dir
    'agent_data_dir': '{{ base_root_path }}/agent/run',
    # pypi url
    'pypi_index_url': 'http://10.131.0.1:3141/root/pypi-douban/+simple/',
    # pypi extra url
    'pypi_extra_index_url': 'https://pypi.tuna.tsinghua.edu.cn/simple/',
    # pypi trusted host
    'pypi_trusted_host': '10.131.0.1 pypi.tuna.tsinghua.edu.cn',

    # taskset
    'taskset_image': '{{ sw_repository }}/taskset:{{ sw_version }}',
    'taskset_docker_port': '2676',
    'taskset_dind_dir': '{{ base_root_path }}/agent/dind'
}


def deploy(logdir: str = "",
           extravars: dict = {},
           cmdline: str = "",
           inventory: dict = {}):
    cur_path = os.path.abspath(os.path.dirname(__file__))
    if not os.path.exists(logdir):
        print("record dir :" + logdir)
        os.makedirs(logdir)
    # ABSPATH = '/mnt/c/Users/gaoxinxing/IdeaProjects/containerdJavaGrpc/bootstrap/'
    # 可参考：https://gist.github.com/privateip/879683a0172415c408fb2afb82a97511
    r = ansible_runner.run(
        private_data_dir=logdir,
        playbook=cur_path + '/playbook/bootstrap.yaml',
        roles_path=cur_path + '/playbook/roles',
        extravars=extravars,
        cmdline=cmdline,
        # 来源：https://ansible.leops.cn/advanced/dynamic-hosts/
        inventory=inventory
        # optional
        # ssh_key='',
    )
    print("{}: {}".format(r.status, r.rc))
    # successful: 0
    for each_host_event in r.events:
        print(each_host_event['event'])
    print("Final status:")
    print(r.stats)
