# Python SCALE Codec Library
#
# Copyright 2018-2020 openAware BV (NL).
# This file is part of Polkascan.
#
# Polkascan is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Polkascan is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Polkascan. If not, see <http://www.gnu.org/licenses/>.

import unittest

from scalecodec.base import ScaleBytes, RuntimeConfiguration, ScaleDecoder
from scalecodec.metadata import MetadataDecoder


class TestMetadata(unittest.TestCase):

    metadata_v3_hex = "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"
    metadata_v2_hex = "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"
    metadata_v1_hex = "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"
    invalid_metadata_v1_hex = "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"

    def test_decode_metadata_v3(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v3_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV3Decoder")

    def test_decode_metadata_v2(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v2_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV2Decoder")

    def test_decode_metadata_v1(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v1_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV1Decoder")

    def test_decode_invalid_metadata_v1(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v1_hex))
        self.assertRaises(Exception, metadata_decoder.decode())

    def test_all_scale_type_supported_v1(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v1_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV1Decoder")

        for module in metadata_decoder.metadata.modules:
            if module.calls:
                for call in module.calls:
                    for arg in call.args:
                        decoder_class = ScaleDecoder.get_decoder_class(arg.type, ScaleBytes('0x00'))
                        self.assertIsNotNone(decoder_class, msg='{} is not supported by metadata'.format(arg.type))

    def test_all_scale_type_supported_v2(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v2_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV2Decoder")

        for module in metadata_decoder.metadata.modules:
            if module.calls:
                for call in module.calls:
                    for arg in call.args:
                        decoder_class = ScaleDecoder.get_decoder_class(arg.type, ScaleBytes('0x00'))
                        self.assertIsNotNone(decoder_class, msg='{} is not supported by metadata'.format(arg.type))

    def test_all_scale_type_supported_v3(self):
        metadata_decoder = MetadataDecoder(ScaleBytes(self.metadata_v3_hex))
        metadata_decoder.decode()
        self.assertEqual(metadata_decoder.version.value, "MetadataV3Decoder")

        for module in metadata_decoder.metadata.modules:
            if module.calls:
                for call in module.calls:
                    for arg in call.args:
                        decoder_class = ScaleDecoder.get_decoder_class(arg.type, ScaleBytes('0x00'))
                        self.assertIsNotNone(decoder_class, msg='{} is not supported by metadata'.format(arg.type))


