# AUTOGENERATED! DO NOT EDIT! File to edit: 07_robot_model.ipynb (unless otherwise specified).

__all__ = ['read_path', 'show_link', 'show_joint']

# Cell

import gdown
from zipfile import ZipFile
import xml.etree.cElementTree as ET
import os

def read_path(path, output_name):
    """

    This function will read path of stored urdf.xacro file, and output a txt file that get all link informationt.

    Args:
        path : The stored urdf.xacro file path
        output_name : The name of output file
    Return:
        file_path : The stored all link information file path

    """
    file_path = os.path.join("./Data/" + output_name)

    os.system("cat " + path + " | grep \"link name=\" >> " + file_path)

    return file_path

def show_link(path):
    """

    This function will read link information file and show all link.

    Args :
        path : The link information file path
    Return :
        link : list all link
    """

    link = []
    f = open(path, 'r')
    for line in f.readlines():
      index = []
      flag = 0
      for i, element in enumerate(line):
        if element == "<":
          flag = 1
        if flag == 1:
          index.append(i)
      link_string = str(line)
      link.append(link_string[index[0]:])
    f.close()

    return link

def show_joint(path):
    """

    This function will read xml file and show all joint from this file.

    Args:
        path : The xml file path
    Return:
        joint : list all joint at xml file.

    """

    joint = []
    tree = ET.parse(path)
    root = tree.getroot()

    for joints in root.iter("joint"):
        joint.append(joints.attrib)

    return joint