# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import
from exact_sync.v1.api.pagination_base_api import PaginationBaseAPI
import re  # noqa: F401

from pathlib import Path
# python 2 and python 3 compatibility library
import six
from io import BytesIO
from PIL import Image
import json

from exact_sync.v1.api_client import ApiClient


class ImageRegistrationApi(PaginationBaseAPI):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_image_registration(self, **kwargs):  # noqa: E501
        """create_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image_registration(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image:
        :param int target_image:
        :param object transformation_matrix:
        :param float registration_error:
        :param int runtime:
        :param str file:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_image_registration_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_image_registration_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_image_registration_with_http_info(self, **kwargs):  # noqa: E501
        """create_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image_registration_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image:
        :param int target_image:
        :param object transformation_matrix:
        :param float registration_error:
        :param int runtime:
        :param str file:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'source_image', 'target_image', 'transformation_matrix', 'registration_error', 'runtime', 'file']  # noqa: E501
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('expand')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image_registration" % key
                )
            params[key] = val
        del params['kwargs']

        #if ('target_image' not in params or
        #    params['target_image'] is None):
        #    raise ValueError("Missing the required parameter `target_image` when calling `create_image_registration`")  # noqa: E501

        #if ('source_image' not in params or
        #    params['source_image'] is None):
        #    raise ValueError("Missing the required parameter `source_image` when calling `create_image_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E50
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        if 'source_image' in params:
            body_params = params['source_image']
        if 'target_image' in params:
            body_params = params['target_image']
        if 'transformation_matrix' in params:
            body_params = params['transformation_matrix']
        if 'registration_error' in params:
            body_params = params['registration_error']
        if 'runtime' in params:
            body_params = params['runtime']


        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_image_registration(self, id, **kwargs):  # noqa: E501
        """destroy_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image_registration(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_image_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_image_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_image_registration_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image_registration_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_image_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_image_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_image_registrations(self, **kwargs):  # noqa: E501
        """list_image_registrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_image_registrations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str target_image: target_image
        :param str source_image: source_image
        :param str registration_error__range: registration_error__range
        :param str runtime__range: runtime__range
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_image_registrations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_image_registrations_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_image_registrations_with_http_info(self, **kwargs):  # noqa: E501
        """list_image_registrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_image_registrations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str target_image: target_image
        :param str source_image: source_image
        :param str registration_error__range: registration_error__range
        :param str runtime__range: runtime__range
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'id', 'target_image', 'source_image', 'registration_error__range', 'runtime__range']  # noqa: E501
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('expand')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_image_registrations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'target_image' in params:
            query_params.append(('target_image', params['target_image']))  # noqa: E501
        if 'source_image' in params:
            query_params.append(('source_image', params['source_image']))  # noqa: E501
        if 'registration_error__range' in params:
            query_params.append(('registration_error__range', params['registration_error__range']))  # noqa: E501
        if 'runtime__range' in params:
            query_params.append(('runtime__range', params['runtime__range']))  # noqa: E501
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E50
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistrations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_image_registration(self, id, **kwargs):  # noqa: E501
        """partial_update_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image_registration(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param object transformation_matrix2:
        :param float registration_error:
        :param int runtime:
        :param str file:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_image_registration_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image_registration_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param object transformation_matrix:
        :param float registration_error:
        :param int runtime:
        :param str file:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'registration_error', 'runtime', 'transformation_matrix', 'file']  # noqa: E501
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('expand')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_image_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_image_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E50
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501


        body_params = None
        if 'registration_error' in params:
            body_params = params['registration_error']
        if 'runtime' in params:
            body_params = params['runtime']
        if 'transformation_matrix' in params:
            body_params = params['transformation_matrix']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
    
    def retrieve_image_registration(self, id, **kwargs):  # noqa: E501
        """retrieve_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image_registration(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_image_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_image_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_image_registration_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image_registration_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('expand')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_image_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_image_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E50
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
 
    def update_image_registration(self, id, **kwargs):  # noqa: E501
        """update_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_registration(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param ImageRegistration body:
        :param str id2: id
        :param str target_image: target_image
        :param str source_image: source_image
        :param str registration_error__range: registration_error__range
        :param str runtime__range: runtime__range
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_image_registration(self, id, **kwargs):  # noqa: E501
        """update_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_registration(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param ImageRegistration body:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_image_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_image_registration_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_registration_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param ImageRegistration body:
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_image_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_image_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/registration/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


    def register_image(self, source_image, target_image, **kwargs):  # noqa: E501
        """register_images_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_images_image(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image: (required)
        :param int target_image: (required)
        :param int target_depth:  (optional)
        :param tuple thumbnail_size:  (optional) (1024, 1024)
        :param [orb , sift] point_extractor:  (optional)
        :param bool flann:  (optional)
        :param bool crossCheck: (optional)
        :param float ratio:  (optional)
        :param bool use_gray:  (optional)
        :param bool homography:  (optional)
        :param bool filter_outliner:  (optional)
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_image_with_http_info(source_image, target_image, **kwargs)  # noqa: E501
        else:
            (data) = self.register_image_with_http_info(source_image, target_image, **kwargs)  # noqa: E501
            return data


    def register_image_with_http_info(self, source_image, target_image, **kwargs):  # noqa: E501
        """register_images_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_images_image_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image: (required)
        :param int target_image: (required)
        :param int target_depth:  (optional)
        :param tuple thumbnail_size:  (optional) (1024, 1024)
        :param [orb , sift] point_extractor:  (optional)
        :param int maxFeatures: (optional)
        :param bool flann:  (optional)
        :param bool crossCheck: (optional)
        :param float ratio:  (optional)
        :param bool use_gray:  (optional)
        :param bool homography:  (optional)
        :param bool filter_outliner:  (optional)
        :return: ImageRegistration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['source_image', 'target_image', "target_depth", "thumbnail_size", "maxFeatures", "point_extractor", "flann", "crossCheck", "ratio", "use_gray", "homography", "filter_outliner"]  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_images_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('source_image' not in params or
                params['source_image'] is None):
            raise ValueError("Missing the required parameter `source_image` when calling `register_images_image`")  # noqa: E501
        if ('target_image' not in params or
                params['target_image'] is None):
            raise ValueError("Missing the required parameter `target_image` when calling `register_images_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = source_image_id  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}
        if 'id' in params:
            body_params['id'] = params['source_image']  # noqa: E501
        if 'target_image' in params:
            body_params['target_image'] = params['target_image']  # noqa: E501 maxFeatures
        if "target_depth" in params:
            body_params['target_depth'] = params['target_depth']  # noqa: E501
        if "thumbnail_size" in params:
            body_params['thumbnail_size'] = params['thumbnail_size']  # noqa: E501
        if "maxFeatures" in params:
            body_params['maxFeatures'] = params['maxFeatures']  # noqa: E501
        if "point_extractor" in params:
            body_params['point_extractor'] = params['point_extractor']  # noqa: E501
        if "flann" in params:
            body_params['flann'] = params['flann']  # noqa: E501
        if "crossCheck" in params:
            body_params['crossCheck'] = params['crossCheck']  # noqa: E501
        if "ratio" in params:
            body_params['ratio'] = params['ratio']  # noqa: E501
        if "use_gray" in params:
            body_params['use_gray'] = params['use_gray']  # noqa: E501
        if "homography" in params:
            body_params['homography'] = params['homography']  # noqa: E501
        if "filter_outliner" in params:
            body_params['filter_outliner'] = params['filter_outliner']  # noqa: E501



        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            f'/api/v1/images/images/{source_image}/register_images/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


    def download_registration_file(self, file, target_path:Path, **kwargs):

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_image" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}
        path_params = {}
        header_params = {}

        query_params = []
        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        response, status_code, header = self.api_client.call_api(
            file, 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


        with response as r:
            with open(str(target_path),'wb') as f:
                chunk_size=8192
                while True:
                    data = r.read(chunk_size)
                    if not data: break
                    f.write(data)

        return status_code, target_path

    def convert_coodinates(self, id, **kwargs):  # noqa: E501
        """register_images_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image: (required)
        :param dict vector: Annotation vector (required)
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_coodinates_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_coodinates_with_http_info(id, **kwargs)  # noqa: E501
            return data


    def convert_coodinates_with_http_info(self, id, **kwargs):  # noqa: E501
        """register_images_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int source_image: (required)
        :param dict vector: Annotation vector (required)
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'vector']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_images_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `convert_coodinates`")  # noqa: E501
        if ('vector' not in params or
                params['vector'] is None):
            raise ValueError("Missing the required parameter `vector` when calling `convert_coodinates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = id  # noqa: E501

        query_params = []
        if 'vector' in params:
            query_params.append(('vector', params['vector']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}



        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        response = self.api_client.call_api(
            f'/api/v1/images/registration/{id}/convert_coodinates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            #response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


        return json.loads(response.data), response


    def create_inverse_registration(self, id, **kwargs):  # noqa: E501
        """image_registration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int image_registration: (required)
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_inverse_registration_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_inverse_registration_with_http_info(id, **kwargs)  # noqa: E501
            return data


    def create_inverse_registration_with_http_info(self, id, **kwargs):  # noqa: E501
        """register_images_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int image_registration: (required)
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_images_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `convert_coodinates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = id  # noqa: E501

        query_params = []
        header_params = {}
        form_params = []
        local_var_files = {}
        body_params = {}



        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            f'/api/v1/images/registration/{id}/create_inverse_registration/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)