"""
APIs provided by reconciliation-report-server1-0

generated by model_code_gen.py
  - **filename** : ``reconciliation_report.py``
  - **json timestamp** : ``2022-01-07 11:09:47``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.reconciliation_report import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['ReconciliationReportAPI']


class Reconciliation(ChildAPI):
    endpoint = '/reconciliation'
    
    @get('reconciliation-report-info')
    def reconciliation_report_info(self, folderId: str, code: str) -> Union[ReconciliationReportInfo, Awaitable[ReconciliationReportInfo]]:
        """
        查询对账报告编辑态信息
    
        """
        return {'param': {'code': code, 'folderId': folderId}}


class Extra(ChildAPI):
    endpoint = '/'
    
    @post('transaction-datas')
    def transaction_datas(self, transactionParam: TransactionParamDto) -> Union[List[dict], Awaitable[List[dict]]]:
        """
        交易数据
    
        """
        return {'body': transactionParam}


class ReconciliationReportAPI(DynamicRootAPI, builtin=True):
    """对账报告组件接口"""
    module_type = 'RR'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ReconciliationReportAPI'
    module_name = 'deepfos.api.reconciliation_report'
    api_version = (1, 0)

    @cached_property
    def reconciliation(self) -> Reconciliation:
        """
        对账报告
        """
        return Reconciliation(self)

    @cached_property
    def extra(self) -> Extra:
        """
        对账报告对外提供的接口（例如合并算法、外挂的python等)
        """
        return Extra(self)


