"""
APIs provided by reconciliation-engine-server1-0

generated by api_code_gen.py
  - **filename** : ``reconciliation_engine.py``
  - **json timestamp** : ``2022-12-26 11:11:22``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.reconciliation_engine import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['ReconcilationAPI', 'ReconcilationmsAPI']


class DataGetAPI(ChildAPI):
    endpoint = '/data_get'
    
    @post('cancel_ds')
    def cancel_ds(self, cancelItem: CancelItem) -> Union[Any, Awaitable[Any]]:
        """
        取消批次
    
        """
        return {'body': cancelItem}
    
    @post('confirm_ds_batch')
    def confirm_ds_batch(self, confirmItem: ConfirmItem) -> Union[Any, Awaitable[Any]]:
        """
        确认批次
    
        """
        return {'body': confirmItem}
    
    @post('delete_ds_batch')
    def delete_ds_batch(self, deleteDsItem: DeleteDsItem) -> Union[Any, Awaitable[Any]]:
        """
        批量删除批次
    
        """
        return {'body': deleteDsItem}
    
    @post('get_column_data')
    def get_column_data(self, queryColumnDataItem: QueryColumnDataItem) -> Union[int, Awaitable[int]]:
        """
        获取列信息和数据
    
        数据抽取
        """
        return {'body': queryColumnDataItem}


class BalanceAPI(ChildAPI):
    endpoint = '/recon-cfg'
    
    @post('cancel-by-hand')
    def cancel_by_hand(self, cancelSignByHand: CancelSignByHand) -> Union[int, Awaitable[int]]:
        """
        手工取消暂挂或者不参与匹配
    
        手工取消暂挂或者不参与匹配 0.取消暂挂 1.取消不参与匹配
        """
        return {'body': cancelSignByHand}
    
    @post('cancel_recon_match')
    def cancel_recon_match(self, cancelReconMatch: CancelReconMatch) -> Union[int, Awaitable[int]]:
        """
        取消匹配
    
        """
        return {'body': cancelReconMatch}
    
    @post('mark-by-hand')
    def mark_by_hand(self, reconMatchByHand: ReconSignByHand) -> Union[bool, Awaitable[bool]]:
        """
        手动标记对账集 4.手工匹配 6.暂挂 5.不参与匹配
    
        """
        return {'body': reconMatchByHand}


class ReconcilAPI(ChildAPI):
    endpoint = '/'
    
    @post('reconciliation/delete_task')
    def delete_task(self, deleteTaskItem: DeleteTaskItem) -> Union[Any, Awaitable[Any]]:
        """
        删除任务
    
        """
        return {'body': deleteTaskItem}
    
    @post('reconciliation/get_task_list')
    def get_task_list(self, queryTaskListItem: QueryTaskListItem) -> Union[PageInfoRctDO, Awaitable[PageInfoRctDO]]:
        """
        获取任务列表
    
        """
        return {'body': queryTaskListItem}
    
    @post('reconciliation/off_task')
    def off_task(self, offTaskItem: OffTaskItem) -> Union[Any, Awaitable[Any]]:
        """
        关闭任务
    
        """
        return {'body': offTaskItem}
    
    @post('reconciliation/on_task')
    def on_task(self, onTaskItem: OnTaskItem) -> Union[Any, Awaitable[Any]]:
        """
        打开任务
    
        """
        return {'body': onTaskItem}
    
    @post('reconciliationExecution/reconciliation')
    def reconciliation(self, reconciliationExecDto: ReconciliationExecDto) -> Union[int, Awaitable[int]]:
        """
        执行对账任务
    
        """
        return {'body': reconciliationExecDto}

    @post('reconciliationExecution/create')
    def create_task(self, reconciliationExecDto: ReconciliationExecCreate) -> Union[int, Awaitable[int]]:
        """
        创建对账任务

        """
        return {'body': reconciliationExecDto}

    @post('reconciliationExecution/exec')
    def exec_task(self, reconciliationExecDto: ReconciliationExecDto) -> Union[int, Awaitable[int]]:
        """
        执行对账任务(只执行)

        """
        return {'body': reconciliationExecDto}


class ReconcilationAPI(DynamicRootAPI, builtin=True):
    """对账组件——数据集接口"""
    module_type = 'DS'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ReconcilationAPI'
    module_name = 'deepfos.api.reconciliation_engine'
    api_version = (1, 0)

    @cached_property
    def data_get(self) -> DataGetAPI:
        """
        数据抽取
        """
        return DataGetAPI(self)


class ReconcilationmsAPI(DynamicRootAPI, builtin=True):
    """对账组件——对账集接口"""
    module_type = 'MS'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ReconcilationAPI'
    module_name = 'deepfos.api.reconciliation_engine'
    api_version = (1, 0)

    @cached_property
    def balance(self) -> BalanceAPI:
        """
        对账操作
        """
        return BalanceAPI(self)

    @cached_property
    def reconcil(self) -> ReconcilAPI:
        """
        对账
        """
        return ReconcilAPI(self)
