"""
Models used by /deepflow-server3-0

generated by model_code_gen.py
  - **filename** : ``workflow.py``
  - **json timestamp** : ``2023-05-08 11:11:46``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'BusinessKey',
    'ElementDetail',
    'ElementDetailBaseVO',
    'ElementDetailDTO',
    'KeyDetail',
    'LaunchParam',
    'LaunchParamsDTO',
    'LaunchReturnForBatchVO',
    'LaunchReturnVO',
    'Message',
    'ProcInstReturnVO',
    'ProcessLaunchParamsVO',
    'ProcessQueryDTO',
    'ProcessStartDTO',
    'ProcessStartMultipleDTO',
    'TaskInstReturnVO',
    'TaskInstanceVO',
    'TaskQueryFilterDTO',
    'UserDetailVO',
    'UserPageParamsVO',
    'UserPageVO',
    'UserTaskQueryDTO',
    'UserTaskVO',
    'Value',
    'TaskCompleteInstance',
    'TaskReqDto',
    'MessageScope',
    'FlowInstanceQueryDto',
    'FlowInstanceDto',
    'MessageInfo',
    'BusinessKeyQueryDTO',
    'GlobalParam',
    'PageInfo',
    'ProcessData',
    'ProcessInstanceVO',
    'ProcessLaunchDTO',
    'ProcessLaunchMultipleDTO',
    'ProcessVersionVO',
    'TodoPageInfo',
    'UnderwayPageInfo',
    'TaskQueryDto',
    'SendMessageParam',
    'FlowQueryResp'
]


class BusinessKey(BaseModel):
    #: 比较符
    compareType: str
    #: 业务键
    key: str


class ElementDetail(BaseModel):
    """Element Detail

    .. admonition:: 引用接口

        - **POST** ``/process/api/message/list``
        - **POST** ``/process/message/list``
    """
    #: 是否绝对路径
    absoluteTag: Optional[bool]
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 元素文件夹id
    folderId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 相对路径
    relativePath: Optional[str]


class ElementDetailBaseVO(BaseModel):
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹ID
    folderId: Optional[str]
    #: 路径
    path: Optional[str]


class ElementDetailDTO(BaseModel):
    #: 元素名
    elementName: str
    #: 元素文件ID，path和folderId二选一
    folderId: Optional[str]
    #: 元素路径, path和folderId二选一
    path: Optional[str]


class KeyDetail(BaseModel):
    #: code
    code: Optional[str]
    #: enableList
    enableList: Optional[bool]
    #: enableNotNull
    enableNotNull: Optional[bool]
    #: type
    type: Optional[str]


class LaunchParam(BaseModel):
    #: 编码
    code: str
    #: 是否数组
    enableList: Optional[bool]
    #: 是否为空
    enableNull: Optional[bool]
    #: id
    id: str
    #: paramsType
    paramsType: Optional[int]
    #: 数据类型
    type: str


class LaunchParamsDTO(BaseModel):
    """Launch Params DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-launch-params``
        - **POST** ``/process/api/task-instance/get-by-launch-params``
    """
    #: 启动参数
    elementDetail: ElementDetailDTO
    #: 启动参数
    paramMap: Any
    #: 版本号，V开头，不填默认最新版本
    version: Optional[str]


class LaunchReturnForBatchVO(BaseModel):
    """Launch Return For Batch VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch/batch`` (Response: 200)
    """
    #: 标识主键 / 别名
    alias: Optional[str]
    #: 业务唯一性键
    businessKey: Optional[str]
    #: 失败原因
    errorMsg: Optional[str]
    #: 流程启动参数
    paramMap: Optional[Any]
    #: 流程实例ID
    procInstId: Optional[str]
    #: 是否启动成功
    success: Optional[bool]


class LaunchReturnVO(BaseModel):
    """Launch Return VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch`` (Response: 200)
    """
    #: 业务唯一性键
    businessKey: Optional[str]
    #: 流程启动参数
    paramMap: Optional[Any]
    #: 流程实例ID
    procInstId: Optional[str]


class Message(BaseModel):
    """message

    .. admonition:: 引用接口

        - **POST** ``/process/message/list`` (Response: 200)
    """
    #: code
    code: Optional[str]
    #: context
    context: Optional[List[Any]]
    #: id
    id: Optional[str]
    #: name
    name: Optional[str]
    #: params
    params: Optional[List[KeyDetail]]
    #: type
    type: Optional[str]


class ProcInstReturnVO(BaseModel):
    """Proc Inst Return VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/process-instance/id`` (Response: 200)
    """
    #: 业务键
    businessKey: Optional[str]
    #: 工作流元素
    elementDetail: Optional[ElementDetailBaseVO]
    #: 结束时间
    endTime: Optional[str]
    #: 工作流唯一标识
    procDefId: Optional[str]
    #: 流程实例Id
    procInstId: Optional[str]
    #: 流程实例名称
    procInstName: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 流程发起人Id
    startUserId: Optional[str]
    #: 流程状态
    state: Optional[str]
    #: 流程状态描述
    stateDesc: Optional[Any]
    #: 变量列表
    variables: Optional[Any]
    #: 版本号
    version: Optional[str]
    #: 版本名称
    versionName: Optional[str]


class ProcessLaunchParamsVO(BaseModel):
    """Process Launch Params VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/launch-params`` (Response: 200)
    """
    #: 可否为空
    canIsNull: Optional[bool]
    #: 参数编码
    code: Optional[str]
    #: 是否数组
    isArray: Optional[bool]
    #: 数据类型
    type: Optional[str]


class ProcessQueryDTO(BaseModel):
    """Process Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process``
        - **POST** ``/process/instance/global-params``
    """
    #: 元素名称
    elementName: str
    #: 文件id
    folderId: Optional[str]
    #: 元素路径
    path: Optional[str]


class ProcessStartDTO(BaseModel):
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str]
    #: 元素路径
    path: Optional[str]


class ProcessStartMultipleDTO(BaseModel):
    #: 标识主键 / 别名
    alias: str
    #: 备注
    comment: Optional[str]
    #: 附件路径
    filePath: Optional[str]
    #: 启动参数
    paramMap: Optional[Any]


class TaskInstReturnVO(BaseModel):
    """Task Inst Return VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/task-instance/id`` (Response: 200)
    """
    #: 认领人
    assignee: Optional[str]
    #: 认领人类型
    assigneeType: Optional[str]
    #: 流程实例业务键
    businessKey: Optional[str]
    #: 候选人
    candidate: Optional[Any]
    #: 截止时间
    dueDate: Optional[str]
    #: 元素信息
    elementDetail: Optional[ElementDetailBaseVO]
    #: 结束时间
    endTime: Optional[str]
    #: 任务实例名称
    name: Optional[str]
    #: 所属人
    owner: Optional[str]
    #: 流程定义Id
    procDefId: Optional[str]
    #: 流程实例Id
    procInstId: Optional[str]
    #: 流程实例名称
    procInstName: Optional[str]
    #: 优先级
    proiority: Optional[str]
    #: 优先级描述
    proiorityDesc: Optional[Any]
    #: 开始时间
    startTime: Optional[str]
    #: 任务状态
    state: Optional[str]
    #: 状态描述
    stateDesc: Optional[Any]
    #: 任务实例Id
    taskId: Optional[str]


class TaskInstanceVO(BaseModel):
    """Task Instance VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/task-instance/get-by-business-key`` (Response: 200)
        - **POST** ``/process/api/task-instance/get-by-launch-params`` (Response: 200)
    """
    #: 处理人
    assignee: Optional[str]
    #: 处理人类型
    assigneeType: Optional[str]
    #: 业务键
    businessKey: Optional[str]
    #: 结束时间
    endTime: Optional[str]
    #: 所属人
    owner: Optional[str]
    #: 优先级
    priority: Optional[str]
    #: 工作流版本id
    procDefId: Optional[str]
    #: 流程实例展示名称
    procDisplayName: Optional[str]
    #: 工作流元素folderId
    procElementFolderId: Optional[str]
    #: 工作流元素编码
    procElementName: Optional[str]
    #: 工作流元素路径
    procElementPath: Optional[str]
    #: 流程实例id
    procInstId: Optional[str]
    #: 工作流元素id
    processId: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 流程状态
    state: Optional[str]
    #: 任务CODE
    taskCode: Optional[str]
    #: 任务展示名称
    taskDisplayName: Optional[str]
    #: 任务实例ID
    taskId: Optional[str]
    #: 任务名称
    taskName: Optional[str]
    #: 版本号
    version: Optional[str]


class TaskQueryFilterDTO(BaseModel):
    #: 类型
    filterType: Optional[str]
    #: 筛选字段
    key: Optional[str]
    #: 值
    value: Optional[str]


class UserDetailVO(BaseModel):
    #: 是否管理员标识
    adminTag: Optional[str]
    #: 头像
    avatar: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 手机号
    mobilePhone: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: nickname
    nickname: Optional[str]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]
    #: username
    username: Optional[str]


class UserPageParamsVO(BaseModel):
    #: 组件类型
    componentType: Optional[str]
    #: 参数
    key: Optional[str]
    #: povKey
    povKey: Optional[Any]
    #: 值
    value: Optional[str]


class UserPageVO(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetail]
    #: params
    params: Optional[List[UserPageParamsVO]]


class UserTaskQueryDTO(BaseModel):
    """User Task Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process/task/claim/list/page``
        - **POST** ``/process/task/myTask/list/page``
    """
    #: 筛选条件
    filters: Optional[List[TaskQueryFilterDTO]]
    #: 相同节点筛选条件
    nodeFilters: Optional[List[TaskQueryFilterDTO]]
    #: 页码
    pageNo: Optional[int]
    #: 每页大小
    pageSize: Optional[int]
    #: 搜索关键字
    search: Optional[str]
    #: 任务状态
    status: Optional[str]


class UserTaskVO(BaseModel):
    """User Task VO

    .. admonition:: 引用接口

        - **POST** ``/process/task/list`` (Response: 200)
    """
    #: app
    app: Optional[str]
    #: 认领状态
    claimStatus: Optional[str]
    #: 工作流名称
    definitionName: Optional[str]
    #: 多语言描述
    description: Optional[Any]
    #: 截止/到期时间
    dueTime: Optional[str]
    #: 元素编码
    elementName: Optional[str]
    #: 是否允许提交备注
    enableAllowedComment: Optional[bool]
    #: 是否可以快速处理
    enableQuickComplete: Optional[bool]
    #: 结束时间
    endTime: Optional[str]
    #: 执行人
    executor: Optional[UserDetailVO]
    #: 过期状态 EXPIRED-已过期,NORMAL-正常
    expiredStatus: Optional[str]
    #: 过期状态描述
    expiredStatusDesc: Optional[Any]
    #: 文件夹Id
    folderId: Optional[str]
    #: 节点编码
    nodeCode: Optional[str]
    #: 任务节点
    nodeName: Optional[str]
    #: 路径
    path: Optional[str]
    #: 负责人
    principal: Optional[str]
    #: 优先级 LOW-低,MID-中,HIGH-高
    priority: Optional[str]
    #: 优先级描述
    priorityDes: Optional[Any]
    #: 流程定义ID
    processDefinitionId: Optional[str]
    #: 流程id
    processId: Optional[str]
    #: 流程实例ID
    processInstanceId: Optional[str]
    #: space
    space: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 发起人
    startUser: Optional[UserDetailVO]
    #: 任务编码
    taskCode: Optional[str]
    #: 流程ID
    taskDefinitionKey: Optional[str]
    #: 任务ID
    taskId: Optional[str]
    #: 任务名称
    taskName: Optional[str]
    #: 任务状态
    taskStatus: Optional[str]
    #: 查看任务参数
    userPage: Optional[UserPageVO]
    #: 查看任务参数状态
    userPageStatus: Optional[str]
    #: 查看任务参数跳转路径
    userPageUrl: Optional[str]
    #: 任务版本号
    version: Optional[str]


class Value(BaseModel):
    """value

    .. admonition:: 引用接口

        - **POST** ``/process/instance/global-params`` (Response: 200)
    """
    #: value
    value: Optional[Any]
    #: valueType
    valueType: Optional[str]


class TaskCompleteInstance(BaseModel):
    """任务完成实体

    .. admonition:: 引用接口

        - **POST** ``/process/api/complete``
        - **POST** ``/process/task/express-complete``
    """
    #: 备注
    comment: Optional[str]
    #: 附件路径
    filePath: Optional[str]
    #: 结果选项
    outcome: Optional[str]
    #: 任务id
    taskId: Optional[str]


class TaskReqDto(BaseModel):
    #: 任务id
    taskId: Optional[str]


class MessageScope(BaseModel):
    #: 流程实例ID，发送消息方式为PROCESS_INSTANCE时必填
    processInstanceIds: Optional[List[str]]
    #: 发送消息方式：指定流程实例ID/广播
    type: str


class FlowInstanceQueryDto(BaseModel):
    """流程实例查询dto

    .. admonition:: 引用接口

        - **POST** ``/process/instance/monitor/page``
        - **POST** ``/process/instance/started-by-me/page``
    """
    #: 筛选条件
    filters: Optional[List[TaskQueryFilterDTO]]
    #: 页码
    pageNo: Optional[int]
    #: 每页大小
    pageSize: Optional[int]
    #: 搜索关键字
    search: Optional[str]
    #: 流程状态
    status: Optional[str]


class FlowInstanceDto(BaseModel):
    #: 当前节点
    currTaskName: Optional[str]
    #: 流程定义key
    definitionKey: Optional[str]
    #: 多语言描述（工作流）
    description: Optional[Any]
    #: 工作流名称
    displayName: Optional[str]
    #: 结束时间
    endTime: Optional[str]
    #: 截止时间
    expireTime: Optional[str]
    #: 过期状态
    expiredStatus: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 实例ID
    instanceId: Optional[str]
    #: 元素编码
    name: Optional[str]
    #: 路径
    path: Optional[str]
    #: 负责人
    principals: Optional[List[str]]
    #: 流程定义ID
    processDefinitionId: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 流程发起人
    startUser: Optional[UserDetailVO]
    #: 工作流状态 InProgress/进行中 Completed/已完成
    status: Optional[str]
    #: 查看参数
    userPage: Optional[UserPageVO]
    #: 查看任务参数状态
    userPageStatus: Optional[str]
    #: 查看任务参数跳转路径
    userPageUrl: Optional[str]
    #: 流程版本号
    version: Optional[str]


class MessageInfo(BaseModel):
    #: 消息体，预置字段不用填
    messageBody: Any
    #: 消息编码，需要在消息列表内
    messageCode: str
    #: 关联工作流，根据此元素，读取消息列表
    relateProcess: ElementDetailDTO


class BusinessKeyQueryDTO(BaseModel):
    """Business Key Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-business-key``
        - **POST** ``/process/api/task-instance/get-by-business-key``
    """
    #: 业务键
    businessKey: BusinessKey
    #: 启动参数
    elementDetail: Optional[ElementDetailDTO]
    #: 版本号，V开头，不填默认最新版本
    version: Optional[str]


class GlobalParam(BaseModel):
    #: 数组类型初始值
    arrayValue: Optional[List[Value]]
    #: 编码
    code: str
    #: 初始值开关
    enableInitial: Optional[bool]
    #: 是否数组
    enableList: Optional[bool]
    #: id
    id: str
    #: paramsType
    paramsType: Optional[int]
    #: 基本类型初始值
    primitiveValue: Optional[Value]
    #: 数据类型
    type: str
    #: 值
    value: Optional[str]


class PageInfo(BaseModel):
    """Page Info«User Task VO»

    .. admonition:: 引用接口

        - **POST** ``/process/task/claim/list/page`` (Response: 200)
    """
    #: 当前页
    currentPage: Optional[int]
    #: 数据集
    lists: Optional[List[UserTaskVO]]
    #: 页面大小
    pageSize: Optional[int]
    #: start
    start: Optional[int]
    #: 总数量
    totalCount: Optional[int]
    #: totalPage
    totalPage: Optional[int]


class ProcessData(BaseModel):
    #: 流程变量列表
    globalParams: Optional[List[GlobalParam]]
    #: 启动参数列表
    launchParams: Optional[List[LaunchParam]]
    
    #: 工作流唯一ID
    processId: Optional[str]
    


class ProcessInstanceVO(BaseModel):
    """Process Instance VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-business-key`` (Response: 200)
        - **POST** ``/process/api/process-instance/get-by-launch-params`` (Response: 200)
    """
    #: 业务键
    businessKey: Optional[str]
    #: 过期时间
    dueTime: Optional[str]
    #: 结束时间
    endTime: Optional[str]
    #: 过期状态
    expiredStatus: Optional[str]
    #: 工作流版本id
    procDefId: Optional[str]
    #: 流程实例展示名称
    procDisplayName: Optional[str]
    #: 工作流元素folderId
    procElementFolderId: Optional[str]
    #: 工作流元素编码
    procElementName: Optional[str]
    #: 工作流元素路径
    procElementPath: Optional[str]
    #: 流程实例id
    procInstId: Optional[str]
    #: 工作流元素id
    processId: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 发起人
    startUser: Optional[UserDetailVO]
    #: 发起人ID
    startUserId: Optional[str]
    #: 流程状态
    state: Optional[str]
    #: 版本号
    version: Optional[str]


class ProcessLaunchDTO(BaseModel):
    """Process Launch DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch``
    """
    #: 备注
    comment: Optional[str]
    #: 元素信息
    elementDetail: Optional[ProcessStartDTO]
    #: 附件路径
    filePath: Optional[str]
    #: 启动参数
    paramMap: Optional[Any]


class ProcessLaunchMultipleDTO(BaseModel):
    """Process Launch Multiple DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch/batch``
    """
    #: 元素信息
    elementDetail: Optional[ProcessStartDTO]
    #: 启动参数集合
    multipleParams: Optional[List[ProcessStartMultipleDTO]]


class ProcessVersionVO(BaseModel):
    """Process Version VO

    .. admonition:: 引用接口

        - **POST** ``/process/definition/deploy`` (Response: 200)
        - **GET** ``/version/list`` (Response: 200)
        - **POST** ``/version/temporary-version`` (Response: 200)
    """
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[UserDetailVO]
    #: 版本名
    name: Optional[str]
    #: 实例数量
    procInstNum: Optional[int]
    #: 流程ID
    processId: Optional[str]
    #: 更新时间
    updateTime: Optional[str]
    #: 更新人
    updateUser: Optional[UserDetailVO]
    #: 版本号
    version: Optional[str]
    #: 状态
    versionStatus: Optional[str]


class TodoPageInfo(BaseModel):
    """Todo Page Info«User Task VO»

    .. admonition:: 引用接口

        - **POST** ``/process/task/myTask/list/page`` (Response: 200)
    """
    #: 已完成任务数
    completedCount: Optional[int]
    #: 当前页
    currentPage: Optional[int]
    #: 进行中任务数
    inProgressCount: Optional[int]
    #: 数据集
    lists: Optional[List[UserTaskVO]]
    #: 页面大小
    pageSize: Optional[int]
    #: start
    start: Optional[int]
    #: 已终止任务数
    terminatedCount: Optional[int]
    #: 总数量
    totalCount: Optional[int]
    #: totalPage
    totalPage: Optional[int]
    #: 全部任务数
    totalTaskCount: Optional[int]


class UnderwayPageInfo(BaseModel):
    """Underway Page Info«流程实例返回dto»

    .. admonition:: 引用接口

        - **POST** ``/process/instance/monitor/page`` (Response: 200)
        - **POST** ``/process/instance/started-by-me/page`` (Response: 200)
    """
    #: 已完成流程数
    completedCount: Optional[int]
    #: 当前页
    currentPage: Optional[int]
    #: 进行中流程数
    inProgressCount: Optional[int]
    #: 数据集
    lists: Optional[List[FlowInstanceDto]]
    #: 页面大小
    pageSize: Optional[int]
    #: 暂停流程数
    pausedCount: Optional[int]
    #: start
    start: Optional[int]
    #: 已终止流程数
    terminatedCount: Optional[int]
    #: 总数量
    totalCount: Optional[int]
    #: totalPage
    totalPage: Optional[int]
    #: 全部流程数
    totalProcessCount: Optional[int]


class TaskQueryDto(BaseModel):
    """任务查询dto

    .. admonition:: 引用接口

        - **POST** ``/process/task/getTaskListByTaskIds``
        - **POST** ``/process/task/list``
    """
    #: 任务查询列表
    taskQueryDTOList: Optional[List[TaskReqDto]]


class SendMessageParam(BaseModel):
    """发送消息参数

    .. admonition:: 引用接口

        - **POST** ``/process/api/send-message``
    """
    #: 消息
    messageInfo: MessageInfo
    #: 发送消息范围
    scope: MessageScope


class FlowQueryResp(BaseModel):
    """工作流查询返回

    .. admonition:: 引用接口

        - **POST** ``/process`` (Response: 200)
        - **GET** ``/version/select-by-id`` (Response: 200)
    """
    #: 多语言描述
    description: Optional[Any]
    #: 元素名称
    elementName: Optional[str]
    
    #: 文件id
    folderId: Optional[str]
    
    
    #: 消息列表
    messages: Optional[List[Message]]
    #: moduleId
    moduleId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 工作流JSON
    processJson: Optional[ProcessData]
    #: 版本号
    version: Optional[str]
    #: 版本名
    versionName: Optional[str]
    #: 版本状态
    versionStatus: Optional[str]



