"""
Models used by /variable-server1-0

generated by model_code_gen.py
  - **filename** : ``variable.py``
  - **json timestamp** : ``2021-10-14 15:37:14``
"""


from .base import BaseModel
from typing import List, Optional
from pydantic import Field


__all__ = [
    'BaseElementDetail',
    'ElementDetail',
    'RelationElementVo',
    'ResponseResult',
    'SaveRelationElementDto',
    'ValueTypeMapDTO',
    'VariableApiDTO',
    'VariableMemberVO',
    'VariableNameVO',
    'VariableParamVO',
    'VariableValueBatchDTO',
    'VariableValueDTO',
    'VariableValueVO',
    'SaveVariavlesDTO',
    'UpdateVariavlesDTO',
    'VariableAllParamVO',
    'VariableBatchVO',
    'VariableElementVO',
    'VariableNameListVO',
    'VariableVO'
]


class BaseElementDetail(BaseModel):
    #: 关联元素名称
    elementName: Optional[str]
    #: 关联元素类型
    elementType: Optional[str]
    #: 错误信息
    errMsg: Optional[str]
    #: 错误标识
    errTag: Optional[bool]
    #: 关联元素对应的文件夹id
    folderId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ElementDetail(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool]
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 元素文件夹id
    folderId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 相对路径
    relativePath: Optional[str]


class RelationElementVo(BaseModel):
    """Relation Element Vo

    .. admonition:: 引用接口

        - **GET** ``/relation`` (Response: 200)
    """
    #: 关联元素信息
    elementDetail: Optional[ElementDetail]
    #: 关联元素的key
    relationField: Optional[str]
    #: 关联元素的编码
    relationPosition: Optional[str]


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **GET** ``/server-check`` (Response: 200)
    """
    #: code
    code: Optional[int]
    #: data
    data: Optional[dict]
    #: message
    message: Optional[str]
    #: status
    status: Optional[bool]


class SaveRelationElementDto(BaseModel):
    """Save Relation Element Dto

    .. admonition:: 引用接口

        - **POST** ``/relation/save``
    """
    #: 关联元素集合list
    elementInfoRelationList: Optional[List[RelationElementVo]]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]


class ValueTypeMapDTO(BaseModel):
    #: decimalDisplayLength
    decimalDisplayLength: Optional[int]
    #: 默认值
    defaultValue: Optional[str]
    #: defaultValueShow
    defaultValueShow: Optional[str]
    #: 数字的小数位数，最大填10
    digitLen: Optional[int]
    #: dimensionDisplay
    dimensionDisplay: Optional[int]
    #: 维度名称
    dimensionName: Optional[str]
    #: 小数显示位数
    displayDigitLen: Optional[int]
    #: 元素详情
    elementDetail: Optional[BaseElementDetail]
    #: 是否启用维度表达式
    enableDimensionExpression: Optional[bool]
    #: 当该字段是维度时允许启用权限控制限制可选的维度成员
    functionCode: Optional[str]
    #: 日期格式
    instruction: Optional[str]
    #: 文本的长度
    length: Optional[int]
    #: 允许等于最大值
    maxEqual: Optional[bool]
    #: 数字/文本的最大长度
    maxLen: Optional[int]
    #: 最大值
    maximun: Optional[int]
    #: 允许等于最小值
    minEqual: Optional[bool]
    #: 最小值
    minimun: Optional[float]
    #: 多层级显示
    multiLevel: Optional[str]
    #: 多选成员上限
    multipleChoiceLimit: Optional[int]
    #: multipleLevelInfo
    multipleLevelInfo: Optional[List[dict]]
    #: 是否百分比
    percentage: Optional[bool]
    #: selectMulti
    selectMulti: Optional[str]
    #: 值列表是否多选
    selectedMulti: Optional[bool]
    #: 千分位标识
    thousandthSymbol: Optional[bool]
    #: 是否树形展示
    treeView: Optional[bool]
    #: 值列表的值选择范围
    valueField: Optional[List[str]]
    #: valueKey
    valueKey: Optional[str]
    #: 值类型
    valueType: Optional[int]


class VariableApiDTO(BaseModel):
    """Variable Api DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/variable-list``
    """
    #: 元素名称
    elementName: str
    #: 文件夹Id
    folderId: str
    #: 元素路径
    path: Optional[str]
    #: 变量类型 (传空查询全部,传1查询全局变量,传2查询用户变量)
    scope: Optional[int]


class VariableMemberVO(BaseModel):
    #: 变量描述
    description: Optional[dict]
    #: 变量名称
    name: Optional[str]
    #: 变量类型 1全局,2用户
    scope: Optional[int]
    #: 变量值
    value: Optional[str]
    #: 变量类型(字段类型)
    valueType: Optional[int]


class VariableNameVO(BaseModel):
    #: 描述
    description: Optional[dict]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 文件夹Id
    path: Optional[str]
    #: 状态
    status: Optional[bool]
    #: 变量名称
    variableName: Optional[str]


class VariableParamVO(BaseModel):
    #: 变量描述
    description: Optional[dict]
    #: 变量名称
    name: str
    #: 变量类型 1全局,2用户
    scope: int
    #: 变量值
    value: Optional[str]
    #: 变量类型(字段类型)
    valueType: int


class VariableValueBatchDTO(BaseModel):
    """Variable Value Batch DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-api/get/variable-value/batch``
    """
    #: 元素名称
    elementName: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 变量名称
    nameList: List[str]
    #: 元素路径
    path: Optional[str]


class VariableValueDTO(BaseModel):
    #: 变量描述
    description: Optional[dict]
    #: 维度成员
    dimensionMemberList: Optional[List[str]]
    #: 元素的多语言关联标识
    languageKey: Optional[str]
    #: 变量名称
    name: Optional[str]
    #: 元素的关联关系标识
    relationKey: Optional[str]
    #: 角色id
    role: Optional[str]
    #: 角色组
    roleGroup: Optional[str]
    #: 权限方案表达式
    roleScript: Optional[str]
    #: 角色方案下的维度名
    rsDimension: Optional[str]
    #: 角色方案详情
    rsElementDetail: Optional[BaseElementDetail]
    #: 行号
    rsMapping: Optional[str]
    #: 角色方案名称
    rsName: Optional[str]
    #: 角色方案关联关系标识
    rsRelationKey: Optional[str]
    #: 范围.1全局,2用户
    scope: Optional[int]
    #: true启用,false禁用
    status: Optional[bool]
    #: 类型.1单个值,2多个值,3维度成员表达式
    type: Optional[int]
    #: 用户变量时配置的自定义值
    userValue: Optional[str]
    #: 自定义值维度成员的描述
    userValueDesc: Optional[str]
    #: scope为1时即为变量的值,scope为2时即为默认值
    value: Optional[str]
    #: 维度成员的描述
    valueDesc: Optional[str]
    #: 变量类型(字段类型)
    valueType: Optional[int]
    #: 变量属性(字段属性)
    valueTypeMap: Optional[ValueTypeMapDTO]


class VariableValueVO(BaseModel):
    """Variable Value VO

    .. admonition:: 引用接口

        - **GET** ``/variable-api/variable-value`` (Response: 200)
    """
    #: 变量描述
    description: Optional[dict]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 变量名称
    name: Optional[str]
    #: 文件夹Id
    path: Optional[str]
    #: 变量类型 1全局,2用户
    scope: Optional[int]
    #: 变量值
    value: Optional[str]
    #: 变量类型(字段类型)
    valueType: Optional[int]
    #: 变量属性(字段属性)
    valueTypeMap: Optional[ValueTypeMapDTO]


class SaveVariavlesDTO(BaseModel):
    """Save Variavles DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/save-variables``
    """
    #: 变量描述
    description: Optional[dict]
    #: 元素名称
    elementName: str
    #: 文件夹Id
    folderId: Optional[str]
    #: 全局变量集合
    globalVariables: Optional[List[VariableValueDTO]]
    #: 变量元素对应多语言标识
    languageKey: Optional[str]
    #: 组件id
    moduleId: str
    #: 元素路径
    path: Optional[str]
    #: 全局变量集合
    userVariables: Optional[List[VariableValueDTO]]


class UpdateVariavlesDTO(BaseModel):
    """Update Variavles DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/update-variables``
    """
    #: description
    description: Optional[dict]
    #: 元素名称
    elementName: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 全局变量集合
    globalVariables: Optional[List[VariableValueDTO]]
    #: 组件id
    moduleId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 用户变量集合
    userVariables: Optional[List[VariableValueDTO]]


class VariableAllParamVO(BaseModel):
    #: 变量描述
    description: Optional[dict]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 文件夹Id
    path: Optional[str]
    #: 变量参数列表
    variableParamVOList: List[VariableParamVO]


class VariableBatchVO(BaseModel):
    """Variable Batch VO

    .. admonition:: 引用接口

        - **POST** ``/variable-api/get/variable-value/batch`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 文件夹Id
    path: Optional[str]
    #: 变量成员集合
    variableMemberList: Optional[List[VariableMemberVO]]


class VariableElementVO(BaseModel):
    """Variable Element VO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/variable-list`` (Response: 200)
    """
    #: 全局变量参数
    global_: List[VariableAllParamVO] = Field(..., alias='global')
    #: 用户变量参数
    user: List[VariableAllParamVO]


class VariableNameListVO(BaseModel):
    """Variable Name List VO

    .. admonition:: 引用接口

        - **GET** ``/variable-api`` (Response: 200)
    """
    #: 全局变量
    global_: List[VariableNameVO] = Field(None, alias='global')
    #: 用户变量
    user: Optional[List[VariableNameVO]]


class VariableVO(BaseModel):
    """Variable VO

    .. admonition:: 引用接口

        - **GET** ``/variable-element/variables`` (Response: 200)
    """
    #: 变量元素多语言描述
    description: Optional[dict]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]
    #: 全局变量列表
    globalVariables: Optional[List[VariableValueDTO]]
    #: 文件夹Id
    path: Optional[str]
    #: 用户变量列表
    userVariables: Optional[List[VariableValueDTO]]



