"""
Models used by /system-server

generated by model_code_gen.py
  - **filename** : ``system.py``
  - **json timestamp** : ``2022-09-05 13:57:32``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'HikariDataSourceInfo',
    'InstallSysModuleUpgradeInfoDto',
    'JobContentDto',
    'JobCurrentDto',
    'ModuleElementInfoVO',
    'ModuleElementaryInfoVO',
    'ModuleExistVO',
    'ModuleInfo',
    'ModuleInfoDTO',
    'ModuleProtocolDTO',
    'ModuleServerVO',
    'ProtocolVersionDTO',
    'SpModuleOperateNoticeConfigDTO',
    'SpaceJdcbInfoVo',
    'SysModuleLanguageInfoDTO',
    'UpdateJobCurrentDto',
    'InstallModuleDTO',
    'RegisterModuleElementVO',
    'ModuleProtocolVO',
    'RegisterModuleVO'
]


class HikariDataSourceInfo(BaseModel):
    """Hikari Data Source Info

    .. admonition:: 引用接口

        - **GET** ``/get-space-datasource`` (Response: 200)
    """
    #: driverClassName
    driverClassName: Optional[str]
    #: jdbcUrl
    jdbcUrl: Optional[str]
    #: maximumPoolSize
    maximumPoolSize: Optional[int]
    #: password
    password: Optional[str]
    #: username
    username: Optional[str]


class InstallSysModuleUpgradeInfoDto(BaseModel):
    #: 升级接口url POST
    api: str
    #: 该组件可以升级操作的版本
    version: str


class JobContentDto(BaseModel):
    #: 结束时间
    endTime: Optional[str]
    #: 作业明细名称英文
    jobContentNameEn: Optional[str]
    #: 作业明细名称中文
    jobContentNameZhcn: Optional[str]
    #: 作业明细名称繁体
    jobContentNameZhtw: Optional[str]
    #: 单个作业明细区分标识
    key: str
    #: 日志文本内容,内容长度限制1200个字符
    log: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 状态 WAIT：等待/GO：运行中/SUCCESS：成功/FAIL：失败/PART_FAIL：部分失败/STOP：暂停
    status: Optional[str]


class JobCurrentDto(BaseModel):
    """Job Current Dto

    .. admonition:: 引用接口

        - **POST** ``/job-content-list``
        - **POST** ``/job-create``
        - **POST** ``/job-current-list``
        - **POST** ``/job-update``
    """
    #: 作业取消等操作回调接口请求body
    callbackPostBody: Optional[str]
    #: 作业取消等操作回调接口请求url-内部项目使用：服务名为前缀格式，外部项目使用：http为前缀格式, 回调接口请求格式：post
    callbackUrl: Optional[str]
    #: 结束时间
    endTime: Optional[str]
    #: 作业完成提示
    endedMsg: Optional[str]
    #: 作业id,不指定则默认使用uuid
    id: Optional[str]
    #: jobContents
    jobContents: Optional[List[JobContentDto]]
    #: 作业名称英文
    jobNameEn: Optional[str]
    #: 作业名称中文
    jobNameZhcn: Optional[str]
    #: 作业名称繁体
    jobNameZhtw: Optional[str]
    #: 操作对象英文
    jobObjEn: Optional[str]
    #: 操作对象中文
    jobObjZhcn: Optional[str]
    #: 操作对象繁体
    jobObjZhtw: Optional[str]
    #: 日志文本内容, 内容长度限制1200个字符，过长已附件形式记录
    log: Optional[str]
    #: 日志附件id
    logFile: Optional[str]
    #: 进入队列时间
    readTime: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 创建作业成功提示
    startedMsg: Optional[str]
    #: 状态 WAIT:等待 / GO:运行中 / SUCCESS:成功 / FAIL:失败 / PART_FAIL:部分失败 / STOP:暂停 / CANCEL:取消 / DELETE:删除
    status: Optional[str]
    #: 超时时间（上一次更新时间开始计算）单位：s（最小10秒，小于10秒重制为10秒，为空不做超时处理）（go状态开始计时）
    timeOut: Optional[int]


class ModuleElementInfoVO(BaseModel):
    #: 是否应用初始化标识
    appInitTag: Optional[bool]
    #: 组件名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素版本
    elementVersion: Optional[str]
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int]
    #: 组件元素id
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]


class ModuleElementaryInfoVO(BaseModel):
    """Module Elementary Info VO

    .. admonition:: 引用接口

        - **GET** ``/module/module-elementary-info`` (Response: 200)
    """
    #: 初始化应用标识
    appInitTag: Optional[bool]
    #: 存放前端组件路径，区分同一服务多个组件的场景
    childPath: Optional[str]
    #: 创建路径
    createPath: Optional[str]
    #: 编辑路径
    editPath: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: iframe地址
    iframeUrl: Optional[str]
    #: 元素Id
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标记
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 打开路径
    openPath: Optional[str]
    #: 组件服务名
    serverName: Optional[str]


class ModuleExistVO(BaseModel):
    """Module Exist VO

    .. admonition:: 引用接口

        - **POST** ``/module/judge-module-exist`` (Response: 200)
    """
    #: 是否应用初始化标识
    appInitTag: Optional[bool]
    #: exist
    exist: Optional[bool]
    #: 组件id生产规则:0,自动拼接 1.登记指定
    idGenerateType: Optional[int]
    #: 包含的元素类型
    moduleElementInfos: Optional[List[ModuleElementInfoVO]]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]


class ModuleInfo(BaseModel):
    """Module Info

    .. admonition:: 引用接口

        - **GET** ``/log/query-obj-name`` (Response: 200)
        - **POST** ``/module/query-module-name``
        - **POST** ``/module/query-module-name`` (Response: 200)
    """
    #: 组件名称
    moduleName: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]


class ModuleInfoDTO(BaseModel):
    """Module Info DTO

    .. admonition:: 引用接口

        - **GET** ``/module/module-info-list`` (Response: 200)
    """
    #: 创建路径
    createPath: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 描述
    description1: Optional[str]
    #: 编辑路径
    editPath: Optional[str]
    #: 组件元素类型
    elementType: Optional[str]
    #: iframe地址
    iframeUrl: Optional[str]
    #: 菜单路径
    menuPath: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改人
    modifyUser: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标记
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 打开路径
    openPath: Optional[str]


class ModuleProtocolDTO(BaseModel):
    #: 使用的协议是否为强制依赖
    mandatoryDependence: bool
    #: 协议号
    protocol: str
    #: 协议版本
    protocolVersion: str


class ModuleServerVO(BaseModel):
    """Module Server VO

    .. admonition:: 引用接口

        - **POST** ``/module/get-server-name`` (Response: 200)
        - **POST** ``/module/get-server-name-for-elements`` (Response: 200)
        - **POST** ``/module/get-server-name-target`` (Response: 200)
    """
    #: 元素类型
    elementType: Optional[str]
    #: id生产类型
    idGenerateType: Optional[int]
    #: moduleElementId
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ProtocolVersionDTO(BaseModel):
    #: 协议号
    protocol: str
    #: 协议版本
    protocolVersion: str


class SpModuleOperateNoticeConfigDTO(BaseModel):
    """Sp Module Operate Notice Config DTO

    .. admonition:: 引用接口

        - **GET** ``/module/getOperateNoticeConfigByModuleIds`` (Response: 200)
        - **GET** ``/module/getOperateNoticeConfigByOperate`` (Response: 200)
        - **GET** ``/module/getOperateNoticeConfigByParam`` (Response: 200)
    """
    #: 操作类型，注册MODULE_REGISTER/应用创建APP_CREATE/元素删除ELEMENT_REMOVE/元素复制ELEMENT_COPY/元素导入ELEMENT_IMPORT/元素导出ELEMENT_EXPORT/元素移动ELEMENT_MOVE
    operate: Optional[str]
    #: 同步SYNC 异步ASYNC
    syncOrAsyn: Optional[str]
    #: 前置FRONT/后置REAR
    type: Optional[str]
    #: 接口url，固定post接口
    url: Optional[str]


class SpaceJdcbInfoVo(BaseModel):
    """Space Jdcb Info Vo

    .. admonition:: 引用接口

        - **GET** ``/space-datasource/detail`` (Response: 200)
    """
    #: 数据库连接url
    databaseUrl: Optional[str]
    #: 数据库名称
    dbName: Optional[str]
    #: 数据库连接头
    jdbcHeader: Optional[str]
    #: 数据库密码
    jdbcPassword: Optional[str]
    #: 数据库类型
    jdbcType: Optional[str]
    #: 数据库连接设置信息
    jdbcUrlOthers: Optional[str]
    #: 数据库账号
    jdbcUserName: Optional[str]
    #: 数据库端口号
    port: Optional[str]


class SysModuleLanguageInfoDTO(BaseModel):
    #: 组件默认语言
    moduleLanguageDefault: Optional[str]
    #: 组件支持的语言列表
    moduleLanguageList: Optional[List[str]]


class UpdateJobCurrentDto(BaseModel):
    #: 作业取消等操作回调接口请求body
    callbackPostBody: Optional[str]
    #: 作业取消等操作回调接口请求url-内部项目使用：服务名为前缀格式，外部项目使用：http为前缀格式, 回调接口请求格式：post
    callbackUrl: Optional[str]
    #: 结束时间
    endTime: Optional[str]
    #: 作业完成提示
    endedMsg: Optional[str]
    #: 作业id
    id: str
    #: jobContents
    jobContents: Optional[List[JobContentDto]]
    #: 作业名称英文
    jobNameEn: Optional[str]
    #: 作业名称中文
    jobNameZhcn: Optional[str]
    #: 作业名称繁体
    jobNameZhtw: Optional[str]
    #: 操作对象英文
    jobObjEn: Optional[str]
    #: 操作对象中文
    jobObjZhcn: Optional[str]
    #: 操作对象繁体
    jobObjZhtw: Optional[str]
    #: 日志文本内容
    log: Optional[str]
    #: 日志附件id
    logFile: Optional[str]
    #: 开始时间
    startTime: Optional[str]
    #: 状态 WAIT:等待 / GO:运行中 / SUCCESS:成功 / FAIL:失败 / PART_FAIL:部分失败 / STOP:暂停 / CANCEL:取消 / DELETE:删除
    status: Optional[str]
    #: 超时时间（上一次更新时间开始计算）单位：s（最小10秒，小于10秒重制为10秒，为空不做超时处理）（go状态开始计时）
    timeOut: Optional[int]


class InstallModuleDTO(BaseModel):
    """Install Module DTO

    .. admonition:: 引用接口

        - **POST** ``/module/install-module``
    """
    #: 应用初始化标识
    appInitTag: Optional[bool]
    #: 自动创建时使用协议集合
    autoUseProtocol: List[ProtocolVersionDTO]
    #: 存放前端组件路径，区分同一服务多个组件的场景
    childPath: Optional[str]
    #: 组件元素实例创建路径
    createPath: Optional[str]
    #: 组件说明
    description1: str
    #: 组件元素实例编辑路径
    editPath: Optional[str]
    #: iframe地址
    iframeUrl: Optional[str]
    #: 组件支持和默认语言信息
    moduleLanguageInfo: Optional[SysModuleLanguageInfoDTO]
    #: 组件名称（废弃）
    moduleName: str
    #: 平台国际化
    moduleNames: Any
    #: 组件标签：系统平台或空间所属 SYSTEM/CUSTOM
    moduleTag: str
    #: 组件类型
    moduleType: str
    #: 组件版本
    moduleVersion: str
    #: 组件元素实例打开路径
    openPath: Optional[str]
    #: 组件操作前置后置通知配置信息
    operateNoticeConfig: Optional[List[SpModuleOperateNoticeConfigDTO]]
    #: 支持的协议集合
    protocolList: List[ProtocolVersionDTO]
    #: 组件对应服务名称
    serverName: str
    #: 空间id
    spaceId: Optional[str]
    #: 组件升级信息
    upgradeInfo: Optional[List[InstallSysModuleUpgradeInfoDto]]
    #: 使用的协议集合
    useProtocolList: List[ModuleProtocolDTO]


class RegisterModuleElementVO(BaseModel):
    #: 是否应用初始化标识
    appInitTag: Optional[bool]
    #: 自动创建协议
    autoUseProtocol: Optional[List['ModuleProtocolVO']]
    #: 组件名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素版本
    elementVersion: Optional[str]
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int]
    #: 组件元素id
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 使用协议
    useProtocolList: Optional[List['ModuleProtocolVO']]


class ModuleProtocolVO(BaseModel):
    #: 使用的协议是否为强制依赖
    mandatoryDependence: Optional[bool]
    #: 当前协议对应有哪些元素支持
    moduleElementList: Optional[List[RegisterModuleElementVO]]
    #: 当前协议对应有哪些组件支持
    moduleList: Optional[List['RegisterModuleVO']]
    #: 协议号
    protocol: Optional[str]
    #: 协议版本号
    protocolVersion: Optional[str]


class RegisterModuleVO(BaseModel):
    """Register Module VO

    .. admonition:: 引用接口

        - **POST** ``/module/module-relation`` (Response: 200)
        - **GET** ``/module/space-register-module`` (Response: 200)
    """
    #: 是否应用初始化标识
    appInitTag: Optional[bool]
    #: 自动创建协议
    autoUseProtocol: Optional[List[ModuleProtocolVO]]
    #: 组件id生产规则:0,自动拼接 1.登记指定
    idGenerateType: Optional[int]
    #: 包含的元素类型
    moduleElementInfos: Optional[List[ModuleElementInfoVO]]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 使用协议
    useProtocolList: Optional[List[ModuleProtocolVO]]


RegisterModuleElementVO.update_forward_refs()
ModuleProtocolVO.update_forward_refs()
