"""
Models used by /space-server

generated by model_code_gen.py
  - **filename** : ``space.py``
  - **json timestamp** : ``2023-03-02 14:49:01``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AppInfo',
    'DataSourceInfo',
    'ElementInfoDto',
    'FileInfoVo',
    'GroupInfoDto',
    'GroupUserVo',
    'ModuleElementInfoForm',
    'ModuleQuoteAddDto',
    'ModuleRegisterStatusAndRegisterTimeVo',
    'ModuleStatusDto',
    'ModuleTypeVersionInfoDto',
    'Owner',
    'QueryAppRequestDTO',
    'QueryAppResponseDTO',
    'QuoteForceRelationVo',
    'SingleGroupVo',
    'SpAppInfo',
    'SpAppInfoAddDto',
    'SpAppInfoUpdateDto',
    'SpAppInfoVo',
    'SpAppJdbcInfoVo',
    'SpFileBusinessRecordSaveDto',
    'SpModlueRegisterStausUsableVo',
    'SpModuleAutoCreateRelationVo',
    'SpModuleInfoPageVo',
    'SpModuleRegisterDetailVo',
    'SpModuleRegisterInfoDto',
    'SpModuleRegisterInfoUpdateDto',
    'SpModuleRegisterRelationVo',
    'SpModuleRegisterResultVo',
    'SpaceAppDto',
    'UserExistVo',
    'UserGroupAssociation',
    'UserInfoVo',
    'UserSearchDto',
    'UserUpdateDto',
    'UserVo',
    'AppDto',
    'GroupUserDto',
    'ModuleRegisterAndQuoteDto',
    'SpaceDto',
    'GroupInfoVo',
    'SingleUserVo',
    'GroupVo',
    'UserAndGroupDto',
    'UserGroupInfoVo'
]


class AppInfo(BaseModel):
    """App Info

    .. admonition:: 引用接口

        - **GET** ``/api/space/app/query-app-info-list/by-space-id`` (Response: 200)
    """
    #: app名称
    appName: Optional[str]
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str]
    #: appId
    id: Optional[str]


class DataSourceInfo(BaseModel):
    """Data Source Info

    .. admonition:: 引用接口

        - **GET** ``/get-app-datasource`` (Response: 200)
    """
    #: 驱动类
    driverClassName: Optional[str]
    #: database的连接地址
    jdbcUrl: Optional[str]
    #: 最大连接池
    maximumPoolSize: Optional[int]
    #: 密码
    password: Optional[str]
    #: 用户名
    username: Optional[str]


class ElementInfoDto(BaseModel):
    #: 是否分配过权限
    allocationPermission: Optional[bool]
    #: 业务数据标记，true: 带业务数据，false: 不带业务数据
    businessDataFlag: Optional[bool]
    #: 确认标记
    confirm: Optional[bool]
    #: 创建时间
    createTime: Optional[str]
    #: 创建者
    createUser: Optional[str]
    #: 错误标记
    elError: Optional[bool]
    #: 平台元素错误标记
    elOsError: Optional[bool]
    #: 警告标记
    elWarning: Optional[int]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 文件夹名称
    folderName: Optional[str]
    #: 元素路径
    fullPath: Optional[str]
    #: 元素id
    id: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改者
    modifyUser: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 启用继承权限标识
    openExtend: Optional[bool]
    #: 元素实例打开路径
    openPath: Optional[str]
    #: 启用公开权限标识
    openPermission: Optional[bool]
    #: 权限值
    permission: Optional[int]
    #: 组件服务名
    serverName: Optional[str]
    #: 状态
    status: Optional[bool]
    #: 系统标识
    systemTag: Optional[bool]


class FileInfoVo(BaseModel):
    """File Info Vo

    .. admonition:: 引用接口

        - **POST** ``/file-info/add``
        - **GET** ``/file-info/find-by-id`` (Response: 200)
    """
    #: 创建用户
    createUser: Optional[str]
    #: 文件描述
    fileDescription: str
    #: 文件名
    fileName: str
    #: 文件大小
    fileSize: int
    #: 类型
    fileType: str
    #: id
    id: str
    #: 路径
    url: str


class GroupInfoDto(BaseModel):
    """Group Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/group-info/add-group``
        - **POST** ``/api/space/group-info/update``
    """
    #: 用户组多语种描述
    groupDes: Optional[Any]
    #: 用户id,编辑时使用
    groupInfoId: Optional[str]
    #: 用户组名
    groupName: str
    #: 父级用户组id
    parentId: Optional[str]
    #: 用户组状态
    status: Optional[str]
    #: 包含的用户id
    userIds: Optional[List[str]]


class GroupUserVo(BaseModel):
    #: 是否管理员标识(SPACE_ADMIN为管理员,非管理员时该值为空)
    adminTag: Optional[str]
    #: 头像
    avatar: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 手机号
    mobilePhone: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]


class ModuleElementInfoForm(BaseModel):
    """Module Element Info Form

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/use/elements`` (Response: 200)
    """
    #: 元素类型
    elementType: Optional[str]
    #: 组件名称
    elementTypeName: Optional[str]
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int]
    #: 组件元素id
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]


class ModuleQuoteAddDto(BaseModel):
    """Module Quote Add Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/quote-relation/add``
        - **POST** ``/api/space/module/quote-relation/batch-add``
    """
    #: 协议号
    protocolSplitJoint: str
    #: 组件需要引用对象
    quoteByModuleId: str
    #: 创建的默认引用元素对象
    quoteTargetElementId: str
    #: 创建的默认引用对象
    quoteTargetModuleId: str


class ModuleRegisterStatusAndRegisterTimeVo(BaseModel):
    """Module Register Status And Register Time Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/register/status`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool]
    #: 缺少强制依赖描述
    lackReason: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 系统组件/自定义组件
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 注册时间
    registerTime: Optional[str]
    #: 空间id
    spaceId: Optional[str]
    #: 状态1：启用;2：未启用
    status: Optional[int]


class ModuleStatusDto(BaseModel):
    """Module Status Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/status``
    """
    #: 注册的组件Id
    moduleId: str
    #: 状态 1：启用，2：不启用
    status: int


class ModuleTypeVersionInfoDto(BaseModel):
    """Module Type Version Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/register-assign-module``
    """
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]


class Owner(BaseModel):
    #: avatar
    avatar: Optional[str]
    #: email
    email: Optional[str]
    #: nickname
    nickname: Optional[str]
    #: userName
    userName: Optional[str]


class QueryAppRequestDTO(BaseModel):
    """Query App Request DTO

    .. admonition:: 引用接口

        - **POST** ``/app-list``
    """
    #: 应用id列表
    appIds: Optional[List[str]]
    #: 应用名称模糊查询条件
    dimName: Optional[str]


class QueryAppResponseDTO(BaseModel):
    """Query App Response DTO

    .. admonition:: 引用接口

        - **POST** ``/app-list`` (Response: 200)
    """
    #: 应用id
    appId: Optional[str]
    #: 应用名称
    appName: Optional[str]


class QuoteForceRelationVo(BaseModel):
    #: 是否自动创建协议
    autoCreateProtocols: Optional[List[str]]
    #: 创建组件列表
    createModuleElements: Optional[Any]
    #: 创建组件列表
    createModules: Optional[Any]
    #: 组件元素列表
    elements: Optional[Any]
    #: 组件列表
    modules: Optional[Any]


class SingleGroupVo(BaseModel):
    """Single Group Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/query`` (Response: 200)
    """
    #: 所有语种描述
    groupDes: Optional[Any]
    #: 当前语种描述
    groupDesc: Optional[str]
    #: 用户组名称
    groupName: Optional[str]
    #: 用户组id
    id: Optional[str]
    #: 用户组状态
    status: Optional[str]
    #: 用户组类型
    type: Optional[str]
    #: 包含的用户
    userList: Optional[List[GroupUserVo]]


class SpAppInfo(BaseModel):
    """Sp App Info

    .. admonition:: 引用接口

        - **POST** ``/app-info`` (Response: 200)
    """
    #: app名称
    appName: Optional[str]
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 是否默认数据源标识
    customDataSource: bool
    #: 是否默认logo标识
    customLogo: Optional[bool]
    #: 数据库名
    dbName: Optional[str]
    #: 描述
    description: Optional[str]
    #: icon图标地址
    icon: Optional[str]
    #: appId
    id: Optional[str]
    #: 数据库连接头信息
    jdbcHeader: Optional[str]
    #: 数据库连接密码
    jdbcPassword: Optional[str]
    #: database的连接类型
    jdbcType: Optional[str]
    #: jdbc连接地址其它信息如时区，编码等
    jdbcUrl: Optional[str]
    #: 默认启用，1：启用，2：不启用
    jdbcUrlOthers: Optional[str]
    #: 数据库连接账号
    jdbcUserName: Optional[str]
    #: 空间logo路径
    logoPath: Optional[str]
    #: 端口
    port: Optional[int]
    #: 是否删除：0:使用 1:回收站中 2:已删除
    recycleBin: Optional[bool]
    #: 空间id
    spaceId: Optional[str]
    #: 状态
    status: Optional[str]


class SpAppInfoAddDto(BaseModel):
    """Sp App Info Add Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/add``
    """
    #: app名称
    appName: str
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str]
    #: app地址
    appUrl: Optional[str]
    #: 是否默认数据源标识 是：true/否：false
    customDataSource: bool
    #: 是否自定义logo标识 是：true/否：false
    customLogo: bool
    #: 数据库名
    dbName: Optional[str]
    #: app描述
    description: Optional[str]
    #: jdbc密码
    jdbcPassword: Optional[str]
    #: 数据库类型，不填默认使用空间地址
    jdbcType: Optional[str]
    #: database的连接地址
    jdbcUrl: Optional[str]
    #: jdbc后缀参数地址
    jdbcUrlOthers: Optional[str]
    #: jdbc用户名
    jdbcUserName: Optional[str]
    #: 空间logo路径
    logoPath: Optional[str]
    #: 端口
    port: Optional[int]


class SpAppInfoUpdateDto(BaseModel):
    """Sp App Info Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/update``
    """
    #: app名称
    appName: str
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str]
    #: 外部应用app地址
    appUrl: Optional[str]
    #: app描述
    description: Optional[str]
    #: appId
    id: str
    #: 空间logo路径
    logoPath: Optional[str]


class SpAppInfoVo(BaseModel):
    """Sp App Info Vo

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/all`` (Response: 200)
    """
    #: app名称
    appName: Optional[str]
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str]
    #: 外部应用app地址
    appUrl: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人id
    createUser: Optional[str]
    #: 是否默认数据源标识
    customDataSource: bool
    #: 数据库名
    dbName: Optional[str]
    #: 描述
    description: Optional[str]
    #: icon图标地址
    icon: Optional[str]
    #: id
    id: Optional[str]
    #: database的连接类型
    jdbcType: Optional[str]
    #: jdbc连接地址
    jdbcUrl: Optional[str]
    #: 其它信息如时区，编码等
    jdbcUrlOthers: Optional[str]
    #: 数据库连接账号
    jdbcUserName: Optional[str]
    #: 空间logo路径
    logoPath: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改人id
    modifyUser: Optional[str]
    #: 所有者
    owner: Optional[Owner]
    #: 用户app权限
    permissions: Optional[List[str]]
    #: 端口
    port: Optional[int]
    #: 状态,默认1
    status: Optional[str]
    #: 状态名
    statusName: Optional[str]


class SpAppJdbcInfoVo(BaseModel):
    """Sp App Jdbc Info Vo

    .. admonition:: 引用接口

        - **GET** ``/internal/space/app/jdbc`` (Response: 200)
    """
    #: 数据库密码
    jdbcPassword: Optional[str]
    #: 数据库端口
    jdbcPort: Optional[int]
    #: jdbc类型
    jdbcType: Optional[str]
    #: jdbcURL
    jdbcUrl: Optional[str]
    #: 数据库连接其他信息
    jdbcUrlOthers: Optional[str]
    #: 数据库名
    jdbcUserName: Optional[str]


class SpFileBusinessRecordSaveDto(BaseModel):
    """Sp File Business Record Save Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/file/business/record/save``
        - **POST** ``/api/space/file/business/record/update``
    """
    #: 应用id：空值时为-1
    app: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 失败日志文id
    failLogFileId: Optional[str]
    #: 文件描述(同文件名后缀格式)
    fileDescription: Optional[str]
    #: 文件id
    fileId: Optional[str]
    #: 文件名
    fileName: str
    #: 文件大小
    fileSize: float
    #: 记录主键id(仅在更新文件时需要)
    id: Optional[str]
    #: 最后一次下载时间
    lastDownloadTime: Optional[str]
    #: 操作类型
    opeType: Optional[str]
    #: 操作类型描述
    opeTypeDesc: Optional[str]
    #: 生成文件进度百分比
    percentage: Optional[int]
    #: 空间id：空值时为-1
    space: Optional[str]
    #: 状态
    status: Optional[str]
    #: 文件大小单位
    unit: str


class SpModlueRegisterStausUsableVo(BaseModel):
    """Sp Modlue Register Staus Usable Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/register/coercion-lack/check-usable-batch`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool]
    #: 组件Id
    moduleId: Optional[str]
    #: 状态
    status: Optional[bool]
    #: 是否可用
    usable: Optional[bool]


class SpModuleAutoCreateRelationVo(BaseModel):
    """Sp Module Auto Create Relation Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/quote-relation/server-name`` (Response: 200)
    """
    #: 元素Id
    moduleElementId: Optional[str]
    #: 元素名
    moduleElementName: Optional[str]
    #: 元素类型
    moduleElementType: Optional[str]
    #: 元素版本
    moduleElementVersion: Optional[str]
    #: 组件Id
    moduleId: Optional[str]
    #: 组件名
    moduleName: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 服务名
    serverName: Optional[str]


class SpModuleInfoPageVo(BaseModel):
    """Sp Module Info Page Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/all/list`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool]
    #: 是否注册
    hasRegister: Optional[bool]
    #: 组件id
    id: Optional[int]
    #: 缺少强制依赖描述
    lackReason: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 系统组件/自定义组件
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 注册时间
    registerTime: Optional[str]
    #: 空间id
    space: Optional[str]
    #: 状态
    status: Optional[int]
    #: 状态名
    statusName: Optional[str]


class SpModuleRegisterDetailVo(BaseModel):
    """Sp Module Register Detail Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/detail`` (Response: 200)
        - **GET** ``/api/space/module/detail/list`` (Response: 200)
        - **GET** ``/api/space/module/register-list/usable`` (Response: 200)
        - **GET** ``/api/space/module/register-list/usable/coercion-lack`` (Response: 200)
    """
    #: 组件分类code
    categoryCode: Optional[str]
    #: 组件分类描述
    categoryName: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 元素类型icon
    elementIcon: Optional[str]
    #: 元素登记注册状态
    elementStatus: Optional[int]
    #: 组件对应的元素类型
    elementType: Optional[str]
    #: 组件对应的元素类型名称
    elementTypeName: Optional[str]
    #: 主键
    id: Optional[int]
    #: 元素id生产类别
    idGenerateType: Optional[int]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改人
    modifyUser: Optional[int]
    #: 元素Id
    moduleElementId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件名称
    moduleName: Optional[str]
    #: 组件标签
    moduleTag: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 一级分类CODE
    parentCode: Optional[str]
    #: 注册时间
    registerTime: Optional[str]
    #: 服务名
    serverName: Optional[str]
    #: 空间id
    space: Optional[str]
    #: 状态
    status: Optional[int]
    #: 状态名
    statusName: Optional[str]


class SpModuleRegisterInfoDto(BaseModel):
    """Sp Module Register Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/register``
    """
    #: 注册的组件Id
    moduleId: str
    #: 状态 1：启用，2：不启用
    status: Optional[int]


class SpModuleRegisterInfoUpdateDto(BaseModel):
    """Sp Module Register Info Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/update-module-register-info/by-module-id``
    """
    #: 组件id
    moduleId: str
    #: 组件名称
    moduleName: str


class SpModuleRegisterRelationVo(BaseModel):
    """Sp Module Register Relation Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/relation-all`` (Response: 200)
        - **GET** ``/api/space/module/unregister/relation-all`` (Response: 200)
    """
    #: 强依赖
    quoteForce: Optional[QuoteForceRelationVo]
    #: 非强依赖
    quoteNotForce: Optional[Any]


class SpModuleRegisterResultVo(BaseModel):
    """Sp Module Register Result Vo

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/batch/module-element-register`` (Response: 200)
        - **POST** ``/api/space/module/batch/quote-relation-register`` (Response: 200)
        - **POST** ``/api/space/module/register`` (Response: 200)
    """
    #: 失败Element列表
    failedElementList: Optional[List[str]]
    #: 失败moduleId列表
    failedList: Optional[List[str]]
    #: 成功Element列表
    successElementList: Optional[List[str]]
    #: 成功moduleId列表
    successList: Optional[List[str]]


class SpaceAppDto(BaseModel):
    """Space App Dto

    .. admonition:: 引用接口

        - **GET** ``/api/space/app/all/list`` (Response: 200)
    """
    #: 应用ID
    appId: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 数据库名
    dbName: Optional[str]
    #: 空间ID
    spaceId: Optional[str]


class UserExistVo(BaseModel):
    """User Exist Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/check-user-exist/batch`` (Response: 200)
    """
    #: 空间存在标识
    existTag: Optional[bool]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]


class UserGroupAssociation(BaseModel):
    #: groupInfoId
    groupInfoId: Optional[str]
    #: userId
    userId: Optional[str]


class UserInfoVo(BaseModel):
    """User Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/all_enable_user`` (Response: 200)
        - **POST** ``/api/space/user-info/batch/query/by-user-ids`` (Response: 200)
        - **GET** ``/api/space/user-info/query/batch`` (Response: 200)
        - **GET** ``/api/space/user-info/query/batch/by-name`` (Response: 200)
        - **POST** ``/api/space/user-info/query/batch/by-user-ids`` (Response: 200)
    """
    #: 是否管理员标识
    adminTag: Optional[str]
    #: 头像
    avatar: Optional[str]
    #: 颜色
    color: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 员工是否离开企业 0 离开 1  未离开
    leave: Optional[int]
    #: 员工是否离开空间 0 离开 1  未离开
    leaveSpace: Optional[int]
    #: 手机号
    mobilePhone: Optional[str]
    #: 更新时间
    modifyTime: Optional[str]
    #: 更新用户
    modifyUser: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: 是否为sso用户
    ssoUser: Optional[bool]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]
    #: 用户名修改次数
    usernameModifyTimes: Optional[int]


class UserSearchDto(BaseModel):
    """User Search Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/search``
    """
    #: keyword
    keyword: Optional[str]
    #: scope
    scope: Optional[List[str]]


class UserUpdateDto(BaseModel):
    """User Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/update``
    """
    #: 管理员标识
    adminTag: Optional[str]
    #: 分配的用户组Id
    groupIds: Optional[List[str]]
    #: 用户状态
    status: Optional[str]
    #: 用户Id
    userId: str


class UserVo(BaseModel):
    """User Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/get-all-children-user-list/by-group`` (Response: 200)
        - **POST** ``/api/space/user-info/search`` (Response: 200)
    """
    #: 头像
    avatar: Optional[str]
    #: 颜色
    color: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 手机号
    mobilePhone: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: 是否为sso用户
    ssoUser: Optional[bool]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]
    #: 用户名修改次数
    usernameModifyTimes: Optional[int]


class AppDto(BaseModel):
    #: 应用id
    app: Optional[str]
    #: 应用名称
    appName: Optional[str]
    #: 元素基础信息列表
    elementInfoDtoList: Optional[List[ElementInfoDto]]


class GroupUserDto(BaseModel):
    """Group User Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/get-all-children-user-list/by-group-batch`` (Response: 200)
    """
    #: 用户组id
    groupId: Optional[str]
    #: 子级用户对象
    userInfoVOS: Optional[List[UserVo]]


class ModuleRegisterAndQuoteDto(BaseModel):
    """Module Register And Quote Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/batch/module-element-register``
        - **POST** ``/api/space/module/batch/quote-relation-register``
    """
    #: 默认新建组件
    moduleQuoteAddDto: Optional[List[ModuleQuoteAddDto]]
    #: 父组件信息
    parentModule: Optional[SpModuleRegisterInfoDto]
    #: 组件关系
    relationModuleList: Optional[List[SpModuleRegisterInfoDto]]


class SpaceDto(BaseModel):
    """Space Dto

    .. admonition:: 引用接口

        - **GET** ``/get-all-element`` (Response: 200)
    """
    #: 应用列表
    appDtoList: Optional[List[AppDto]]
    #: 空间id
    space: Optional[str]
    #: 空间名称
    spaceName: Optional[str]


class GroupInfoVo(BaseModel):
    """Group Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/query/batch`` (Response: 200)
        - **POST** ``/api/space/group-info/query/batch/by-group-ids`` (Response: 200)
    """
    #: 子用户组
    childrenGroup: Optional[List['GroupInfoVo']]
    #: 用户组编码
    groupCode: Optional[str]
    #: 当前语种描述
    groupDesc: Optional[str]
    #: 用户组名称
    groupName: Optional[str]
    #: 用户组id
    id: Optional[str]
    #: 父级用户组id
    parentId: Optional[str]
    #: 用户组状态
    status: Optional[str]
    #: 用户组类型
    type: Optional[str]


class SingleUserVo(BaseModel):
    """Single User Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/query`` (Response: 200)
    """
    #: 是否管理员标识
    adminTag: Optional[str]
    #: 是否为应用管理员
    appAdmin: Optional[bool]
    #: 头像
    avatar: Optional[str]
    #: 颜色
    color: Optional[str]
    #: 是否为应用开发者角色
    developerRole: Optional[bool]
    #: 邮箱
    email: Optional[str]
    #: 所属用户组id
    groupList: Optional[List[GroupInfoVo]]
    #: 手机号
    mobilePhone: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: 是否为空间管理员
    spaceAdmin: Optional[bool]
    #: 是否为sso用户
    ssoUser: Optional[bool]
    #: 状态
    status: Optional[str]
    #: 是否为系统管理员
    systemAdmin: Optional[bool]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]
    #: 用户名修改次数
    usernameModifyTimes: Optional[int]


class GroupVo(BaseModel):
    #: 子用户组
    childrenGroup: Optional[List['GroupVo']]
    #: 当前语种描述
    groupDesc: Optional[str]
    #: 用户组名称
    groupName: Optional[str]
    #: 用户组id
    id: Optional[str]
    #: 父级用户组id
    parentId: Optional[str]
    #: status
    status: Optional[str]
    #: top
    top: Optional[bool]
    #: type
    type: Optional[str]


class UserAndGroupDto(BaseModel):
    """User And Group Dto

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/get-user-group-all`` (Response: 200)
    """
    #: group
    group: Optional[List[GroupVo]]
    #: user
    user: Optional[List[UserGroupAssociation]]


class UserGroupInfoVo(BaseModel):
    """User Group Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/all`` (Response: 200)
        - **GET** ``/api/space/group-info/all_enable_group`` (Response: 200)
        - **GET** ``/api/space/group-info/all_enable_group_no_tree`` (Response: 200)
        - **GET** ``/api/space/group-info/query/batch/by-name`` (Response: 200)
    """
    #: 子用户组
    childrenGroup: Optional[List['UserGroupInfoVo']]
    #: 描述
    description: Optional[str]
    #: 用户组代码
    groupCode: Optional[str]
    #: 用户组名称
    groupName: Optional[str]
    #: 用户组id
    id: Optional[str]
    #: 层级
    level: Optional[int]
    #: 父级用户组id
    parentId: Optional[str]
    #: 用户组状态
    status: Optional[str]


GroupInfoVo.update_forward_refs()
GroupVo.update_forward_refs()
UserGroupInfoVo.update_forward_refs()
