"""
Models used by /role-strategy-server1-0

generated by model_code_gen.py
  - **filename** : ``role_strategy.py``
  - **json timestamp** : ``2022-08-08 13:39:19``
"""


from .base import BaseModel
from typing import List, Optional, Union, Any
from pydantic import Field


__all__ = [
    'BaseTip',
    'DataTableInfoVO',
    'DimensionLineForRolesVO',
    'DimensionMemberByRoleDto',
    'DimensionMemberByUserDto',
    'DimensionMemberByUserVO',
    'DimensionMemberDto',
    'DimensionMemberGroupDto',
    'DimensionMemberInfoVO',
    'DimensionMemberRoleStrategyBatchDto',
    'DimensionMemberRoleStrategyDto',
    'DimensionMemberSegDto',
    'DimensionMemberUserByRolesDto',
    'DimensionMembersByUserAndSegMembersVO',
    'DimensionMembersCheckDto',
    'DimensionMessageBatchVO',
    'DimensionMessageVO',
    'DimensionScriptMessageVO',
    'DimensionScriptsCheckDto',
    'ElementDetailVO',
    'ImportRoleSchemeDetailDto',
    'ImportRoleSchemeDto',
    'QueryRoleSchemeDTO',
    'ResultStringDto',
    'RoleByRoleSchemeVO',
    'RoleSchemeSegmentVO',
    'RolegroupByRoleSchemeVO',
    'RolegroupsByRoleSchemeDto',
    'RolesByUserAndSegMembersVO',
    'RolesByUserVO',
    'UserGroupListDTO',
    'UsersByRolesDto',
    'BatchQueryRolesByUserAndSegMembersVO',
    'DimMemberCheckDimensionDto',
    'DimensionMemberBySchemeLineVO',
    'DimensionMemberBySchemeVO',
    'DimensionMemberByUserAndRoleVO',
    'DimensionMemberByUserRoleDimVO',
    'RoleSchemeInfoVO',
    'UserByRolesBatchDto',
    'UserDTO',
    'UsersByRoleGroupsVO',
    'UsersByRolesVO',
    'DimensionAndUserForRolesVO',
    'UserByRolesAndRoleGroupsVO',
    'RoleDetailVO',
    'RoleGroupDetailVO',
    'RoleGroupVO',
    'RoleInfoVO'
]


class BaseTip(BaseModel):
    #: tipKey
    tipKey: Optional[str]
    #: tipValue
    tipValue: Optional[str]


class DataTableInfoVO(BaseModel):
    #: 绝对路径标识
    absoluteTag: Optional[bool]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 相对路径
    relativePath: Optional[str]
    #: 服务名
    serverName: Optional[str]


class DimensionLineForRolesVO(BaseModel):
    #: 维度成员
    dimensionMember: Optional[str]
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int]


class DimensionMemberByRoleDto(BaseModel):
    """Dimension Member By Role Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 角色组名称
    roleGroups: Optional[List[str]]
    #: 角色名称
    roles: Optional[List[str]]


class DimensionMemberByUserDto(BaseModel):
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str]
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str]


class DimensionMemberByUserVO(BaseModel):
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str]
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str]


class DimensionMemberDto(BaseModel):
    #: 需要校验的维度成员
    dimensionMembers: List[str]
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str]


class DimensionMemberGroupDto(BaseModel):
    #: 唯一标识，别名
    alias: Optional[str]
    #: 校验维度，line1-5，且不能重复
    dimensions: List[DimensionMemberDto]


class DimensionMemberInfoVO(BaseModel):
    #: 描述
    multilingual: Optional[Any]
    #: 维度成员名称
    name: Optional[str]


class DimensionMemberRoleStrategyBatchDto(BaseModel):
    """Dimension Member Role Strategy Batch Dto

    .. admonition:: 引用接口

        - **POST** ``/batch-query-roles-by-user-seg-members``
    """
    #: 校验维度分组
    dimensionGroups: List[DimensionMemberGroupDto]
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str]
    #: 路径
    path: Optional[str]


class DimensionMemberRoleStrategyDto(BaseModel):
    """Dimension Member Role Strategy Dto

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-user-seg-members``
    """
    #: 校验维度
    dimension: List[DimensionMemberDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 文件夹路径
    path: str


class DimensionMemberSegDto(BaseModel):
    #: 维度名
    dimensionName: str
    #: 需要校验的维度成员
    dimensionScripts: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str]
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str]


class DimensionMemberUserByRolesDto(BaseModel):
    #: 需要校验的维度成员
    dimensionMembers: Optional[List[str]]
    #: 维度名
    dimensionName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int]
    #: 路径
    path: Optional[str]


class DimensionMembersByUserAndSegMembersVO(BaseModel):
    """Dimension Members By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/get-dim-members-by-user-seg-members`` (Response: 200)
    """
    #: 维度成员
    dimensionMembers: Optional[List[DimensionMemberInfoVO]]
    #: 维度名
    dimensionName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: dimension在权限方案中的行号
    line: Optional[int]


class DimensionMembersCheckDto(BaseModel):
    """Dimension Members Check Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dim-members-by-user-seg-members``
    """
    #: 校验维度
    dimensions: List[DimensionMemberDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 角色组名称
    roleGroups: Optional[List[str]]
    #: 角色名称
    roles: Optional[List[str]]


class DimensionMessageBatchVO(BaseModel):
    """Dimension Message Batch VO

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme-batch`` (Response: 200)
    """
    #: 校验维度
    dimension: Optional[DimensionMemberByUserVO]
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str]
    #: 维度成员是否受控
    enableAll: Optional[bool]
    #: 错误描述
    errorMsg: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 维度成员
    member: Optional[List[str]]
    #: 权限方案路径
    path: Optional[str]
    #: 角色组名称
    roleGroups: Optional[List[str]]
    #: 角色名称
    roles: Optional[List[str]]


class DimensionMessageVO(BaseModel):
    """Dimension Message VO

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme`` (Response: 200)
    """
    #: 维度成员是否受控
    enableAll: Optional[bool]
    #: 维度成员
    member: Optional[List[str]]


class DimensionScriptMessageVO(BaseModel):
    """Dimension Script Message VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-script-by-role-scheme`` (Response: 200)
    """
    #: 维度成员是否受控
    enableAll: Optional[bool]
    #: 维度表达式
    script: Optional[List[str]]


class DimensionScriptsCheckDto(BaseModel):
    """Dimension Scripts Check Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role-scripts``
    """
    #: 校验维度
    dimensions: List[DimensionMemberSegDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 角色组名称
    roleGroups: Optional[List[str]]
    #: 角色名称
    roles: Optional[List[str]]


class ElementDetailVO(BaseModel):
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ImportRoleSchemeDetailDto(BaseModel):
    #: 角色名
    roleNames: Optional[List[str]]
    #: 角色组名
    rolegroupName: Optional[List[str]]
    #: segment1
    segment1: Optional[str]
    #: segment2
    segment2: Optional[str]
    #: segment3
    segment3: Optional[str]
    #: segment4
    segment4: Optional[str]
    #: segment5
    segment5: Optional[str]
    #: 用户id
    userIds: Optional[List[str]]
    #: 用户信息参数
    userMessageList: Optional[List[str]]
    #: 用户组id
    usergroupId: Optional[List[str]]
    #: 用户组信息参数
    usergroupMessageList: Optional[List[str]]


class ImportRoleSchemeDto(BaseModel):
    """Import Role Scheme Dto

    .. admonition:: 引用接口

        - **POST** ``/role-scheme-data-import``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 权限方案导入配置
    importDataList: Optional[List[ImportRoleSchemeDetailDto]]
    #: 元素path路径
    path: Optional[str]
    #: 全量增量导入标识
    tag: str


class QueryRoleSchemeDTO(BaseModel):
    """Query Role Scheme DTO

    .. admonition:: 引用接口

        - **POST** ``/role-strategy/info-list``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 页码
    pageNo: Optional[int]
    #: 每页大小
    pageSize: Optional[int]
    #: 元素path路径
    path: Optional[str]
    #: 要搜索的角色组编码
    roleGroupNames: Optional[List[str]]
    #: 要搜索的角色编码
    roleNames: Optional[List[str]]
    #: 要搜索的用户组ID
    userGroupIds: Optional[List[str]]
    #: 要搜索的用户ID
    userIds: Optional[List[str]]


class ResultStringDto(BaseModel):
    """Result String Dto

    .. admonition:: 引用接口

        - **POST** ``/role-strategy/rolescheme/import`` (Response: 200)
        - **POST** ``/role-strategy/save-role-scheme`` (Response: 200)
        - **POST** ``/rolegroup/role-rolegroup/import`` (Response: 200)
    """
    #: code
    code: Optional[int]
    #: result
    result: Optional[str]


class RoleByRoleSchemeVO(BaseModel):
    """Role By Role Scheme VO

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-role-scheme-rolegroups`` (Response: 200)
    """
    #: 默认角色组名称
    defaultRolegroupName: Optional[str]
    #: 描述
    description: Optional[Any]
    #: 说明
    instruction: Optional[Any]
    #: 角色名称
    name: Optional[str]


class RoleSchemeSegmentVO(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetailVO]
    #: 错误提示
    errorList: Optional[List[BaseTip]]
    #: rsMapping
    line: Optional[int]


class RolegroupByRoleSchemeVO(BaseModel):
    """Rolegroup By Role Scheme VO

    .. admonition:: 引用接口

        - **POST** ``/get-rolegroups-by-role-scheme-roles`` (Response: 200)
    """
    #: 描述
    description: Optional[Any]
    #: 说明
    instruction: Optional[Any]
    #: 名称
    name: Optional[str]


class RolegroupsByRoleSchemeDto(BaseModel):
    """Rolegroups By Role Scheme Dto

    .. admonition:: 引用接口

        - **POST** ``/get-rolegroups-by-role-scheme-roles``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 角色编码
    roleNames: List[str]


class RolesByUserAndSegMembersVO(BaseModel):
    """Roles By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-user-seg-members`` (Response: 200)
    """
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool]
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]]
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]]


class RolesByUserVO(BaseModel):
    """Roles By User VO

    .. admonition:: 引用接口

        - **GET** ``/get-roles-by-user`` (Response: 200)
    """
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool]
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]]
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]]


class UserGroupListDTO(BaseModel):
    #: 用户组描述
    groupDesc: Optional[str]
    #: 用户组名称
    groupName: Optional[str]
    #: 用户组id
    id: Optional[str]
    #: 状态
    status: Optional[str]
    #: 类型
    type: Optional[str]


class UsersByRolesDto(BaseModel):
    #: 唯一标识，别名
    alias: Optional[str]
    #: 校验维度
    dimensions: Optional[List[DimensionMemberUserByRolesDto]]
    #: 角色组名称
    roleGroups: List[str]
    #: 角色名称，全部角色为["-1"]
    roles: List[str]


class BatchQueryRolesByUserAndSegMembersVO(BaseModel):
    """Batch Query Roles By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/batch-query-roles-by-user-seg-members`` (Response: 200)
    """
    #: 唯一标识，别名
    alias: Optional[str]
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool]
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]]
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]]


class DimMemberCheckDimensionDto(BaseModel):
    """Dim Member Check Dimension Dto

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme``
        - **POST** ``/get-Dimension-Member-by-role-scheme-batch``
        - **POST** ``/get-dimension-script-by-role-scheme``
    """
    #: 校验维度
    dimension: DimensionMemberByUserDto
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str]
    #: 维度路径
    path: Optional[str]
    #: 角色组名称
    roleGroups: Optional[List[str]]
    #: 角色名称
    roles: Optional[List[str]]


class DimensionMemberBySchemeLineVO(BaseModel):
    #: 权限方案维度组合
    roleSchemeLineList: Optional[List[DimensionMembersByUserAndSegMembersVO]]


class DimensionMemberBySchemeVO(BaseModel):
    #: 权限方案维度组合
    dimensionList: Optional[List[DimensionMembersByUserAndSegMembersVO]]


class DimensionMemberByUserAndRoleVO(BaseModel):
    """Dimension Member By User And Role VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role`` (Response: 200)
    """
    #: 用户是否管理员
    adminTag: Optional[bool]
    #: 权限方案维度组合，管理员时，组合为空
    schemeLineVOList: Optional[List[DimensionMemberBySchemeLineVO]]


class DimensionMemberByUserRoleDimVO(BaseModel):
    """Dimension Member By User Role Dim VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role-scripts`` (Response: 200)
    """
    #: 用户是否管理员
    adminTag: Optional[bool]
    #: 权限方案维度组合，管理员时，组合为空
    schemeLineVOList: Optional[List[DimensionMemberBySchemeVO]]


class RoleSchemeInfoVO(BaseModel):
    """Role Scheme Info VO

    .. admonition:: 引用接口

        - **GET** ``/role-strategy/info`` (Response: 200)
        - **POST** ``/role-strategy/info-list`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO]
    #: 多语言信息
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: dimensionErrorList
    dimensionErrorList: Optional[List[BaseTip]]
    #: dimensionErrorTag
    dimensionErrorTag: Optional[bool]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 错误提示
    errorList: Optional[List[BaseTip]]
    #: 是否存在错误提示
    errorTag: Optional[bool]
    #: 文件夹ID
    folderId: Optional[str]
    #: 组件ID
    moduleId: Optional[str]
    #: 元素路径path
    path: Optional[str]
    #: 元素权限
    permission: Optional[int]
    #: 权限方案
    roleScheme: Optional[Any]
    #: rsId
    rsId: Optional[str]
    #: 关联维度
    segments: Optional[List[RoleSchemeSegmentVO]]
    #: 警告提示
    warningList: Optional[List[BaseTip]]
    #: 是否存在警告提示
    warningTag: Optional[bool]


class UserByRolesBatchDto(BaseModel):
    """User By Roles Batch Dto

    .. admonition:: 引用接口

        - **POST** ``/get-users-by-roles``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: roleAndGroups
    roleAndGroups: List[UsersByRolesDto]


class UserDTO(BaseModel):
    #: 是否管理员
    adminTag: Optional[str]
    #: 头像
    avatar: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 用户组
    groupList: Optional[List[UserGroupListDTO]]
    #: 手机号
    mobilePhone: Optional[str]
    #: 别名
    nickName: Optional[str]
    #: 状态
    status: Optional[str]
    #: 用户Id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]


class UsersByRoleGroupsVO(BaseModel):
    #: 是否所有用户
    enableAll: Optional[bool]
    #: 是否企业用户
    enableEnterpriseAll: Optional[bool]
    #: 角色组名
    roleGroupName: Optional[str]
    #: 用户
    users: Optional[List[UserDTO]]


class UsersByRolesVO(BaseModel):
    #: 是否所有用户
    enableAll: Optional[bool]
    #: 是否企业用户
    enableEnterpriseAll: Optional[bool]
    #: 角色名，全部角色为-1
    roleName: Optional[str]
    #: 用户
    users: Optional[List[UserDTO]]


class DimensionAndUserForRolesVO(BaseModel):
    #: 维度组合
    dimensionLines: Optional[List[DimensionLineForRolesVO]]
    #: 角色组
    roleGroups: Optional[List[UsersByRoleGroupsVO]]
    #: 角色
    roles: Optional[List[UsersByRolesVO]]


class UserByRolesAndRoleGroupsVO(BaseModel):
    """User By Roles And Role Groups VO

    .. admonition:: 引用接口

        - **POST** ``/get-users-by-roles`` (Response: 200)
    """
    #: 唯一标识，别名
    alias: Optional[str]
    #: 满足维度的角色/角色组
    dimensions: Optional[List[DimensionAndUserForRolesVO]]
    #: 角色组，dimensions为空时，此参数有效
    roleGroups: Optional[List[UsersByRoleGroupsVO]]
    #: 角色，dimensions为空时，此参数有效
    roles: Optional[List[UsersByRolesVO]]


class RoleDetailVO(BaseModel):
    #: 多语言描述
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 多语言说明
    instruction: Optional[Any]
    #: 说明1
    instruction1: Optional[str]
    #: 说明2
    instruction2: Optional[str]
    #: 角色名称
    name: Optional[str]
    #: 关联的角色组
    relation: Optional[List['RoleGroupDetailVO']]


class RoleGroupDetailVO(BaseModel):
    #: 多语言描述
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 多语言说明
    instruction: Optional[Any]
    #: 说明1
    instruction1: Optional[str]
    #: 说明2
    instruction2: Optional[str]
    #: 名称
    name: Optional[str]
    #: 关联的角色
    relation: Optional[List[RoleDetailVO]]
    #: 状态 0禁用/1启用
    status: Optional[int]
    #: 类型 ROLE/GROUP
    type: Optional[str]


class RoleGroupVO(BaseModel):
    """Role Group VO

    .. admonition:: 引用接口

        - **GET** ``/rolegroup/data`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO]
    #: 多语言描述
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 错误提示
    errorList: Optional[List[BaseTip]]
    #: 文件夹ID
    folderId: Optional[str]
    #: 多语言说明
    instruction: Optional[Any]
    #: 组件ID
    moduleId: Optional[str]
    #: 元素路径path
    path: Optional[str]
    #: 角色组
    rolegroup: Optional[List[RoleGroupDetailVO]]
    #: rsId
    rsId: Optional[str]


class RoleInfoVO(BaseModel):
    """Role Info VO

    .. admonition:: 引用接口

        - **GET** ``/role/data`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO]
    #: 多语言信息
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 错误提示
    errorList: Optional[List[BaseTip]]
    #: 文件夹ID
    folderId: Optional[str]
    #: 组件ID
    moduleId: Optional[str]
    #: 元素路径path
    path: Optional[str]
    #: 角色
    role: Optional[List[RoleDetailVO]]
    #: rsId
    rsId: Optional[str]


RoleDetailVO.update_forward_refs()
