"""
Models used by /platform-file-server

generated by model_code_gen.py
  - **filename** : ``platform_file.py``
  - **json timestamp** : ``2022-08-08 13:39:19``
"""


from .base import BaseModel
from typing import List, Optional, Union, Any
from pydantic import Field


__all__ = [
    'DeleteFileDTO',
    'FileDelete',
    'FileDeleteResultVO',
    'FileReadResultVO',
    'FileUploadResultVO',
    'FileUplodRes',
    'McUploadDTO',
    'ReadFileDTO',
    'Result',
    'UploadBodyForm'
]


class DeleteFileDTO(BaseModel):
    """Delete File DTO

    .. admonition:: 引用接口

        - **POST** ``/python/python-file/delete``
    """
    #: 删除的python文件的文件名称
    fileName: str
    #: 删除的python文件的文件夹路径
    path: str


class FileDelete(BaseModel):
    """File Delete

    .. admonition:: 引用接口

        - **POST** ``/files/delete/file``
    """
    #: 文件id(url/id二选一)
    id: Optional[str]
    #: 文件路径(url/id二选一)
    url: Optional[str]


class FileDeleteResultVO(BaseModel):
    """File Delete Result VO

    .. admonition:: 引用接口

        - **POST** ``/python/python-file/delete`` (Response: 200)
    """
    #: 删除的python文件的文件夹名称
    fileName: Optional[str]
    #: 删除失败信息
    message: Optional[str]
    #: 删除的python文件的文件路径
    path: Optional[str]
    #: 状态
    status: Optional[bool]


class FileReadResultVO(BaseModel):
    """File Read Result VO

    .. admonition:: 引用接口

        - **POST** ``/python/read-file`` (Response: 200)
    """
    #: 上传的python文件的文件内容
    fileContent: Optional[str]
    #: 上传的python文件的文件名称
    fileName: Optional[str]
    #: 上传的python文件的文件夹路径
    path: Optional[str]


class FileUploadResultVO(BaseModel):
    """File Upload Result VO

    .. admonition:: 引用接口

        - **POST** ``/python/upload`` (Response: 200)
    """
    #: 上传的python文件的文件夹路径
    fileName: Optional[str]
    #: 上传的python文件的文件名称
    path: Optional[str]


class FileUplodRes(BaseModel):
    """File Uplod Res

    .. admonition:: 引用接口

        - **POST** ``/files/upload`` (Response: 200)
        - **POST** ``/files/upload/content`` (Response: 200)
    """
    #: 文件描述
    fileDescription: Optional[str]
    #: 文件名
    fileName: str
    #: 文件大小
    fileSize: int
    #: 文件类型
    fileType: str
    #: 文件id
    id: str
    #: 文件路径
    url: str


class McUploadDTO(BaseModel):
    """Mc Upload DTO

    .. admonition:: 引用接口

        - **POST** ``/js/upload``
    """
    #: 上传的js文件的内容
    data: str
    #: 文件名称
    fileName: Optional[str]
    #: 文件所在路径，包含文件名
    oldPath: Optional[str]
    #: 业务类型 默认default
    type: Optional[str]


class ReadFileDTO(BaseModel):
    """Read File DTO

    .. admonition:: 引用接口

        - **POST** ``/python/read-file``
    """
    #: 上传的python文件的文件名称
    fileName: str
    #: 上传的python文件的文件夹路径
    path: str


class Result(BaseModel):
    """result

    .. admonition:: 引用接口

        - **POST** ``/js/upload`` (Response: 200)
    """
    #: 文件路径
    path: Optional[str]


class UploadBodyForm(BaseModel):
    """Upload Body Form

    .. admonition:: 引用接口

        - **POST** ``/files/upload/content``
    """
    #: 上传的内容
    body: str
    #: 文件名
    fileName: str
    #: 文件类型
    fileType: str



