"""
Models used by /journal-template-server1-0

generated by model_code_gen.py
  - **filename** : ``journal_template.py``
  - **json timestamp** : ``2022-09-23 15:10:19``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'BatchColumn',
    'BatchDefineDTO',
    'DataTableCustomSqlResultDTO',
    'DimensionRoleInfo',
    'ErrorInfo',
    'ExpressionParserDTO',
    'GroupColumnInfo',
    'JournalAggregateResultDTO',
    'JournalBodyData',
    'JournalColumnAuthorityInfo',
    'JournalDataBatchDel',
    'JournalDataFilterParam',
    'JournalMainData',
    'JournalTemplateQuery',
    'NumberPostingInfo',
    'OrderColumnInfo',
    'ProcessInfo',
    'ElementInfo',
    'MemCubeModelDto',
    'JTRelationColumn',
    'JournalTemplateFieldViewFeature',
    'PostingParam',
    'AdvancedSettingsDTO',
    'ApprovalProcessColumn',
    'ApprovalProcessInfo',
    'CollectColumnInfo',
    'JournalColumnLogicInfo',
    'JournalData',
    'JournalListColumnInfo',
    'JournalOrderDataBatchQuery',
    'ElementRelationInfo',
    'JTPostingRelColumn',
    'PostingInfoDto',
    'PostingParamQueryDto',
    'PostingRequestDto',
    'JournalBatchDataDTO',
    'ButtonInfoDealParamDTO',
    'JournalButtonInfoDTO',
    'JournalColumnDataTableInfo',
    'JournalColumnInfo',
    'JournalDataTableBaseInfo',
    'JournalTemplateAreaInfo',
    'JournalTemplateBaseInfo',
    'JournalTemplateDTO',
    'JournalTemplateDetail'
]


class BatchColumn(BaseModel):
    #: 字段编码
    code: Optional[str]
    #: 字段名
    name: Optional[str]
    #: 显示方式(0成员名称,1描述,2成员加描述默认为2)
    dimensionDisplay: Optional[int]


class BatchDefineDTO(BaseModel):
    #: 批量字段列
    columns: Optional[List[str]]
    #: 批量单据名称
    name: Optional[str]


class DataTableCustomSqlResultDTO(BaseModel):
    """Data Table Custom Sql Result DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/delete-by-filter`` (Response: 200)
        - **POST** ``/journal/get-batch-data`` (Response: 200)
        - **POST** ``/journal/get-total-data`` (Response: 200)
        - **POST** ``/query_sum_data`` (Response: 200)
    """
    #: 查询结果计数
    modifyCounts: Optional[int]
    #: sql类型:insert,update,delete,select
    operation: Optional[str]
    #: 查询结果集
    selectResult: Optional[List[Dict]]


class DimensionRoleInfo(BaseModel):
    #: 权限方案名称
    rsName: str
    #: 权限方案文件夹id
    roleFolderId: str
    #: 权限方案文件夹id
    rolePath: str
    #: 角色
    role: List[str]
    #: 角色组
    rolegroup: List[str]
    #: 权限方案中所选维度的行号
    rsMapping: int


class ErrorInfo(BaseModel):
    #: 提示key
    tipKey: str
    #: 提示value
    tipValue: str


class ExpressionParserDTO(BaseModel):
    """Expression Parser DTO

    .. admonition:: 引用接口

        - **POST** ``/check-formula-definition``
        - **POST** ``/check-formula-definition`` (Response: 200)
    """
    #: 错误标志
    errorFlag: Optional[bool]
    #: 公式
    formula: str
    #: 校验成功后的公式
    formulaCheck: Optional[str]
    #: 公式名称
    formulaName: str
    #: 公式成员
    members: Optional[List[str]]
    #: 错误信息
    message: Optional[str]
    #: 替换符
    replaceStr: Optional[List[str]]


class GroupColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str]
    #: 是否有小计行
    isHaveSubTotal: Optional[bool]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标识
    errorTag: Optional[bool]


class JournalAggregateResultDTO(BaseModel):
    """Journal Aggregate Result DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/get-aggregate-data`` (Response: 200)
    """
    #: 分组字段
    groupColumn: Optional[List[str]]
    #: 查询结果
    result: Optional[List[Dict]]


class JournalBodyData(BaseModel):
    #: 子表真实表名
    bodyActualTableName: str
    #: 增量数据
    data: List[Dict]
    #: 删除数据
    delEntryCode: List[str]


class JournalColumnAuthorityInfo(BaseModel):
    #: 是否必填
    required: Optional[bool]
    #: 展示类型(0:不显示,1显示到列表,2显示到页面,3显示到列表及页面)
    showInList: Optional[int]


class JournalDataBatchDel(BaseModel):
    """Journal Data Batch Del

    .. admonition:: 引用接口

        - **POST** ``/journal/delete-by-filter``
    """
    #: 文件夹ID
    folderId: Optional[str]
    #: 模板编码
    templateCode: str
    #: 路径
    path: Optional[str]
    #: 成员编码及名称
    memberInfo: Optional[Any]


class JournalDataFilterParam(BaseModel):
    #: 字段编码
    columnCode: str
    #: 筛选方式(like)
    filterType: Optional[str]
    #: 筛选值
    filterValue: Optional[str]
    #: 字段类型(维度为8,值列表为3)
    fieldType: Optional[int]
    #: 主子表类型(主表字段为1,子表字段为2)
    tableType: int


class JournalMainData(BaseModel):
    #: 日记账编码
    journalCode: str
    #: 字段编码(日记账头主键字段编码)
    columnCode: str
    #: 主表真实表名
    mainActualTableName: str
    #: 数据
    data: Any


class JournalTemplateQuery(BaseModel):
    """Journal Template Query

    .. admonition:: 引用接口

        - **POST** ``/journal-list/defaultQuery``
        - **POST** ``/journal-template/advanced-setting-query``
        - **POST** ``/journal-template/baseInfo/batchQuery``
        - **POST** ``/journal-template/query``
        - **POST** ``/journal-template/query-detail``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id(文件夹id/path必传一个)
    folderId: Optional[str]
    #: 元素路径(文件夹id/path必传一个)
    path: Optional[str]


class NumberPostingInfo(BaseModel):
    #: 数值类过账字段编码
    code: Optional[str]
    #: 映射配置信息表达式
    mappingExpression: Optional[str]
    #: 映射配置信息
    mappingInfo: Optional[Any]
    #: 数值类过账字段名称
    name: Optional[str]


class OrderColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str]
    #: 顺序
    orderType: Optional[str]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标识
    errorTag: Optional[bool]


class ProcessInfo(BaseModel):
    #: 公式
    formula: Optional[ExpressionParserDTO]
    #: 汇总方式 1:计数 2:计算值
    summaryWay: Optional[str]
    #: 小计行
    group: Optional[bool]


class ElementInfo(BaseModel):
    """元素信息

    .. admonition:: 引用接口

        - **POST** ``/callback/delete-front``
    """
    #: 名称
    elementName: Optional[str]
    #: 类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class MemCubeModelDto(BaseModel):
    #: 自动进行档期数和累计数的汇总计算，false：关；true：开；
    autoCalculation: Optional[bool]
    #: 内存财务数据模型编码
    code: str
    #: 多语言信息
    description: Optional[Any]
    #: 类型
    elementType: Optional[str]
    #: 异常信息
    errorList: Optional[List[ErrorInfo]]
    #: 异常标记
    errorTag: Optional[bool]
    #: 内存财务数据模型所在文件夹Id
    folderId: str
    #: 内存财务数据模型路径
    path: Optional[str]
    #: 元素引用关系唯一key
    relationKey: Optional[str]
    #: 权限方案文件夹ID
    rsFolderId: Optional[str]
    #: 权限方案名
    rsName: Optional[str]
    #: 权限方案类型
    rsType: Optional[str]
    #: 内存财务数据模型服务名
    serverName: Optional[str]


class JTRelationColumn(BaseModel):
    #: 字段编码
    code: Optional[str]
    #: 字段表类型
    type: Optional[str]
    #: 多语言描述
    description: Any
    #: 不做后端业务逻辑，仅前端展示逻辑
    showName: Optional[str]


class JournalTemplateFieldViewFeature(BaseModel):
    #: 显示树形结构(默认true)
    treeView: Optional[bool]
    #: 是否隐藏
    whetherHide: Optional[bool]
    #: 列宽(为空为自适应)
    columnWidth: Optional[int]
    #: 维度显示方式(0成员名称,1描述,2成员加描述默认为2)
    dimensionDisplay: Optional[int]
    #: 用户显示方式(email,nickName,userName)
    valueKey: Optional[str]
    #: 值列表显示方式(0成员名称,1描述,2成员加描述,默认为2)
    smartListDisplay: Optional[int]


class PostingParam(BaseModel):
    #: 参数集
    params: Optional[Any]


class AdvancedSettingsDTO(BaseModel):
    """Advanced Settings DTO

    .. admonition:: 引用接口

        - **POST** ``/journal-template/advanced-setting-query`` (Response: 200)
        - **POST** ``/journal-template/advanced-setting-save``
    """
    #: 批量定义可选字段
    allBatchColumns: Optional[List[BatchColumn]]
    #: 批量定义
    batchDefine: Optional[List[BatchDefineDTO]]
    #: 是否开启批量
    turnOnBatch: bool
    #: 元素名称
    elementName: str
    #: 文件夹id(文件夹id/path必传一个)
    folderId: Optional[str]
    #: 元素路径(文件夹id/path必传一个)
    path: Optional[str]


class ApprovalProcessColumn(BaseModel):
    #: 字段编码
    columnCode: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: str
    #: 数据表名
    dbName: str
    #: 是否用于审批记录的分组显示
    groupColumn: Optional[bool]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标签
    errorTag: Optional[bool]


class ApprovalProcessInfo(BaseModel):
    #: 编码
    code: str
    #: 多语言描述
    description: Any
    #: 数据表名
    dbName: str
    #: 多语言唯一Key
    uniqueKey: str
    #: 数据表实际名称(审批记录表)
    actualTableName: str
    #: 数据表路径
    dbPath: str
    #: 审批流对应的明细信息
    elementDetail: Optional[ElementInfo]
    #: 状态字段编码
    statusColumnCode: str
    #: 字段信息
    columns: List[ApprovalProcessColumn]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标签
    errorTag: Optional[bool]


class CollectColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str]
    #: 汇总类型
    collectType: Optional[str]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标识
    errorTag: Optional[bool]


class JournalColumnLogicInfo(BaseModel):
    #: 是否是分组字段
    groupColumn: Optional[bool]
    #: 字段类型
    valueType: int
    #: 字段长度
    length: Optional[str]
    #: 字段默认值
    defaultValue: Optional[str]
    #: 是否为业务主键
    logicKey: Optional[bool]
    #: 维度表达式|值列表成员|日期时间内容|自定义列表
    valueKey: Optional[str]
    #: 值列表信息|维度详细信息(字段类型为值列表或维度时传)
    elementDetail: Optional[ElementInfo]
    #: 小数部分长度(字段类型为数字时传)
    digitLen: Optional[str]
    #: 大于等于(字段类型为数字时传)
    maxEqual: Optional[bool]
    #: 整数部分长度(字段类型为数字时传)
    maxLen: Optional[str]
    #: 数值范围(大于)(字段类型为数字时传)
    maximun: Optional[str]
    #: (字段类型为数字时传)
    minEqual: Optional[bool]
    #: 数值范围(小于)(字段类型为数字时传)
    minimun: Optional[str]
    #: 用户类型展示值(保存时不传)
    valueDesc: Optional[str]
    #: 值列表成员
    valueField: Optional[List[str]]


class JournalData(BaseModel):
    #: 主表数据
    mainData: Optional[JournalMainData]
    #: 子表数据
    bodyData: JournalBodyData


class JournalListColumnInfo(BaseModel):
    #: 有权限成员
    authorityMember: Optional[List[str]]
    #: 字段编码
    columnCode: str
    #: 值列表信息|维度详细信息(字段类型为值列表或维度时传)
    elementDetail: Optional[ElementInfo]
    #: 展示类型(0:不显示,1显示到列表,2显示到页面,3显示到列表及页面)
    showInList: Optional[int]
    #: 多语言描述
    description: Any
    #: 字段类型
    valueType: int
    #: 维度表达式|日期时间内容|自定义列表
    valueKey: Optional[str]
    #: 值列表成员
    valueField: Optional[List[str]]
    #: 字段默认值
    defaultValue: Optional[str]
    #: 字段默认值描述
    defaultValueDesc: Optional[str]
    #: 值描述
    valueDesc: Optional[str]
    #: 字段关联维度权限信息
    dimensionRoleInfo: Optional[DimensionRoleInfo]
    #: 字段显示属性
    show: Optional[JournalTemplateFieldViewFeature]


class JournalOrderDataBatchQuery(BaseModel):
    """Journal Order Data Batch Query

    .. admonition:: 引用接口

        - **POST** ``/journal/get-aggregate-data``
        - **POST** ``/journal/get-batch-data``
        - **POST** ``/journal/get-total-data``
    """
    #: 模板编码
    templateCode: str
    #: 文件夹ID
    folderId: Optional[str]
    #: 模板路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]
    #: 是否需要维度当前语言描述信息
    needDesc: Optional[bool]
    #: 页面字段参数集
    headerParams: Optional[List[JournalDataFilterParam]]
    #: 展示列字段参数集
    columnParams: Optional[List[JournalDataFilterParam]]
    #: 排序语句集合
    orderColumns: Optional[List[OrderColumnInfo]]
    #: 统计字段
    collectColumns: Optional[List[CollectColumnInfo]]
    #: 统计字段
    groupColumns: Optional[List[GroupColumnInfo]]
    #: 是否保留同凭证号分录明细（22年3月迭代新增）
    showDetail: Optional[bool]


class ElementRelationInfo(BaseModel):
    #: 列作用(通用类:0   场景类:1  版本类:2  实体类:3  科目类:4  年份类:5  期间类:6 值类型:99 交易伙伴:98)
    dimensionUsage: int
    #: 维度元素信息
    dimensionInfo: ElementInfo
    #: 字段编码(数据库名称)
    dimensionCode: Optional[str]
    #: 默认值
    defaultValue: str
    #: 对应字段
    relationColumn: Optional[JTRelationColumn]
    #: 对应字段集合
    relationColumnList: Optional[List[JTRelationColumn]]


class JTPostingRelColumn(BaseModel):
    """单据模板过账映射配置信息

    .. admonition:: 引用接口

        - **POST** ``/posting/memory-financial-model-mapping/query`` (Response: 200)
    """
    #: 所有数值类过账字段和对应维度默认值
    allNumberMapping: Optional[List[NumberPostingInfo]]
    #: 保存后数值类过账字段和对应维度默认值
    numberMapping: Optional[List[NumberPostingInfo]]
    #: 内存财务模型信息
    modelInfo: MemCubeModelDto
    #: 映射配置信息
    mappingInfo: List[ElementRelationInfo]


class PostingInfoDto(BaseModel):
    """过账信息dto

    .. admonition:: 引用接口

        - **POST** ``/posting/query`` (Response: 200)
    """
    #: 清数类型 1: 全量清数;2: 增量清数
    clearType: Optional[int]
    #: 凭证类别 1: 会计凭证;2: 报表凭证
    type: int
    #: 映射配置信息
    dimensionModel: List[JTPostingRelColumn]


class PostingParamQueryDto(BaseModel):
    """过账参数查询类

    .. admonition:: 引用接口

        - **POST** ``/posting/query-posting-param``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id(与元素路径二选一)
    folderId: Optional[str]
    #: 元素类型
    elementType: str
    #: 元素路径(与文件夹id二选一)
    path: Optional[str]
    #: 页面查询参数
    pageColumns: Optional[List[JournalListColumnInfo]]


class PostingRequestDto(BaseModel):
    """过账请求参数

    .. admonition:: 引用接口

        - **POST** ``/posting/cancel-posting``
        - **POST** ``/posting/get-posting``
    """
    #: 模板查询参数
    templateQuery: JournalTemplateQuery
    #: 过账参数
    postingInfoParam: PostingParam
    #: 过账是否变更状态
    modifyMergeStatus: Optional[bool]


class JournalBatchDataDTO(BaseModel):
    """Journal Batch Data DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/batch-save``
    """
    #: 修改数据主表主键编码(修改时传)
    codeList: Optional[List[str]]
    #: 修改数据子表主键编码(修改时传)
    entryCodeList: Optional[List[str]]
    #: 文件夹ID
    folderId: Optional[str]
    #: 模板编码
    templateCode: str
    #: 路径
    path: Optional[str]
    #: 数据
    batchData: Optional[List[JournalData]]
    #: 是否新增
    isNew: Optional[bool]


class ButtonInfoDealParamDTO(BaseModel):
    """Button Info Deal Param DTO

    .. admonition:: 引用接口

        - **GET** ``/button/query`` (Response: 200)
    """
    #: 按钮信息（全局按钮&行按钮）
    journalButtonInfoList: Optional[List['JournalButtonInfoDTO']]


class JournalButtonInfoDTO(BaseModel):
    #: 排序
    sort: Optional[int]
    #: 按钮id
    id: Optional[str]
    #: 编码
    name: str
    #: 按钮父级id
    parentId: Optional[str]
    #: 按钮名称多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: Optional[str]
    #: 提示
    title: Optional[Any]
    #: 按钮类型(type)
    type: Optional[str]
    #: 是否隐藏
    hidden: Optional[bool]
    #: 子级按钮
    child: Optional[List['JournalButtonInfoDTO']]
    #: 按钮类型(position)
    position: Optional[str]
    #: 类型
    executeType: Optional[str]
    #: url
    executeUrl: Optional[str]
    #: 参数key&value 默认预留5个长度
    executeParam: Optional[List[Dict]]
    #: 只读权限 关联权限方案中的角色/角色组 此处存储elementName
    readPermission: Optional[Any]
    #: 运行权限 关联权限方案中的角色/角色组 此处存储elementName
    writePermission: Optional[Any]
    #: 样式属性
    styles: Optional[Any]
    #: 权限
    accessRight: Optional[str]
    #: 是否启用权限控制
    enableAccessControl: bool


class JournalColumnDataTableInfo(BaseModel):
    #: 字段编码
    columnCode: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key(新建时为空)
    uniqueKey: Optional[str]
    #: 数据表名
    dbName: str
    #: 数据类型
    type: str
    #: 数据长度
    length: Optional[str]
    #: 数据默认值
    defaultValue: Optional[str]
    #: 是否为主键
    whetherPrimary: Optional[bool]
    #: 操作类型
    operation: str
    #: 是否自增
    whetherIncrement: Optional[bool]
    #: 唯一索引
    whetherOnly: Optional[bool]
    #: 原字段数据库信息(新建时为null)
    oldInfo: Optional['JournalColumnDataTableInfo']


class JournalColumnInfo(BaseModel):
    #: 复合表头
    displayName: Optional[str]
    #: 数据库属性
    dataTableInfo: JournalColumnDataTableInfo
    #: 逻辑属性
    logicInfo: JournalColumnLogicInfo
    #: 编辑及权限属性
    authorityInfo: JournalColumnAuthorityInfo
    #: 显示属性
    show: Optional[JournalTemplateFieldViewFeature]
    #: 是否为系统字段
    systemColumn: bool
    #: 样式属性
    styles: Optional[Any]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标识
    errorTag: Optional[bool]
    #: 加工属性
    processInfo: Optional[ProcessInfo]


class JournalDataTableBaseInfo(BaseModel):
    #: 数据表Id(空时表示新建,不为空时表示更新)
    id: str
    #: 数据表名
    dbName: str
    #: 数据表文件夹ID
    folderId: str
    #: 数据表路径
    dbPath: str
    #: 数据表实际名称
    actualTableName: str
    #: 数据表服务名
    serverName: str
    #: 数据表多语言描述
    description: Optional[Any]
    #: 原数据表信息(新建时为空,更新时必须)
    oldInfo: Optional['JournalDataTableBaseInfo']


class JournalTemplateAreaInfo(BaseModel):
    #: 编码(名称)
    code: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: Optional[str]
    #: 数据表基本信息
    dataTableBaseInfo: JournalDataTableBaseInfo
    #: 字段
    columns: List[JournalColumnInfo]
    #: 样式属性
    styles: Optional[Any]
    #: 允许添加行(日记账体)
    allowAddRow: Optional[bool]
    #: 允许复制行(日记账体)
    allowCopyRow: Optional[bool]
    #: 允许删除行(日记账体)
    allowDeleteRow: Optional[bool]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]]
    #: 错误标签
    errorTag: Optional[bool]


class JournalTemplateBaseInfo(BaseModel):
    #: 审批记录表
    approveRecord: Optional[JournalDataTableBaseInfo]
    #: 关账流程表信息
    closeAccountDB: Optional[JournalDataTableBaseInfo]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 模板id
    templateId: Optional[str]
    #: 编码(名称)
    code: str
    #: 名称(多语言)
    description: Optional[Any]
    #: 角色方案对应的明细信息
    rsElementDetail: Optional[ElementInfo]
    #: 样式属性
    styles: Optional[Any]
    #: 默认展示条数
    defaultItem: Optional[int]


class JournalTemplateDTO(BaseModel):
    """Journal Template DTO

    .. admonition:: 引用接口

        - **POST** ``/journal-template/baseInfo/batchQuery`` (Response: 200)
        - **POST** ``/journal-template/query`` (Response: 200)
        - **POST** ``/journal-template/save``
    """
    #: python脚本信息
    pythonScriptInfo: Optional[ElementInfo]
    #: 日记账模板基础信息
    baseInfo: JournalTemplateBaseInfo
    #: 日记账模板头区域信息
    headerInfo: JournalTemplateAreaInfo
    #: 日记账体区域信息
    bodyInfo: JournalTemplateAreaInfo
    #: 日记账尾区域信息
    footInfo: JournalTemplateAreaInfo
    #: 审批流信息
    approvalProcessInfo: Optional[ApprovalProcessInfo]
    #: 错误标识
    errorTag: Optional[bool]
    #: 模板类型
    templateType: Optional[str]


class JournalTemplateDetail(BaseModel):
    """模板整体详细信息

    .. admonition:: 引用接口

        - **POST** ``/journal-template/query-detail`` (Response: 200)
    """
    #: 高级设置
    advancedSetting: Optional[AdvancedSettingsDTO]
    #: 单据模板信息
    journalTemplateInfo: JournalTemplateDTO
    #: saveTime
    saveTime: Optional[str]
    #: 过账配置信息
    postingInfo: PostingInfoDto
    #: 按钮信息
    buttonInfo: ButtonInfoDealParamDTO


ButtonInfoDealParamDTO.update_forward_refs()
JournalButtonInfoDTO.update_forward_refs()
JournalColumnDataTableInfo.update_forward_refs()
JournalDataTableBaseInfo.update_forward_refs()
