"""
Models used by /financial-model-server1-0

generated by model_code_gen.py
  - **filename** : ``financial_model.py``
  - **json timestamp** : ``2022-11-28 17:27:51``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'ClearDataDTO',
    'CopyCalculateDTO',
    'CubeDataLogForm',
    'CubeRightElementDTO',
    'ElementDeleteFrontRearDTO',
    'ElementDetailDTO',
    'ElementDetailDto',
    'ElementRelationDTO',
    'ErrorDTO',
    'GroupRoleDataBlockUserGroup',
    'ListTableQueryParamDTO',
    'ListTableVerifyErrorInfoDTO',
    'PageVo',
    'QueryOptimizeConfigVO',
    'ReactFormAuthData',
    'ReactFormErrorMessage',
    'ResponseResult',
    'ResultObj',
    'SheetDimensionLevelDto',
    'SheetPovInfoDto',
    'SheetPovTreeParam',
    'SheetUdMemberDto',
    'SplitSqlWhiteDimensionConfig',
    'SpreadsheetError',
    'SpreadsheetRowData',
    'UdInfoDto',
    'ValueTypeMapDTO',
    'CubeAccessStatus',
    'DataBlockDimension',
    'DataBlockDimDto',
    'RoleDto',
    'RoleDataBlock',
    'CellDataDTO',
    'CubeDimensionDto',
    'CubeRelationResponseDTO',
    'CustomizeSplitSqlForPeriod',
    'PageParamsVo',
    'ReactFormListDTO',
    'SheetDimensionAttributeDto',
    'SheetDimensionDto',
    'SheetMemberDto',
    'SheetPovMulitLevelDto',
    'SheetRowDto',
    'SplitSqlFixedConfigItem',
    'SpreadsheetSingleData',
    'WookbookParamDto',
    'DataBlockInfo',
    'DataBlockInfoDto',
    'AccountCalendarDto',
    'CubeQueryForOutVo',
    'PcParams',
    'ReactSpreadsheetSaveForm',
    'SheetColumnDto',
    'SheetPageDto',
    'CubeAccessControlViewReact',
    'DatatableColumnDto',
    'DatatableInfoDto',
    'FinancialModelDto',
    'GroupRoleDatablockReactView',
    'SheetDto',
    'WorkbookInfoDto',
    'SheetPovChildrenDto',
    'SheetPovTreeDto',
    'CubeAccessCtrlDto',
    'HeaderObject',
    'RoleSetDataBlock',
    'FinancialDataDto',
    'TaskExecutionParam',
    'TaskExecutionResult'
]


class ClearDataDTO(BaseModel):
    """Clear Data DTO

    .. admonition:: 引用接口

        - **POST** ``/cubeCalculate/clearData``
    """
    #: clear_script
    clear_script: Optional[str]
    #: cube_name
    cube_name: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: path
    path: Optional[str]


class CopyCalculateDTO(BaseModel):
    """Copy Calculate DTO

    .. admonition:: 引用接口

        - **POST** ``/copyCalculate``
    """
    #: 财务模型名称cubeFolderId
    cubeFolderId: Optional[str]
    #: 财务模型名称cubename
    cubeName: Optional[str]
    #: 财务模型名称cubePath
    cubePath: Optional[str]
    #: entryObject
    entryObject: Optional[str]
    #: fixMembers表达式
    fixMembers: Optional[str]
    #: formula表达式
    formula: Optional[str]


class CubeDataLogForm(BaseModel):
    """Cube Data Log Form

    .. admonition:: 引用接口

        - **POST** ``/cube/data/log/list``
    """
    #: 财务模型路径id
    cubeFolderId: Optional[str]
    #: 财务模型名称
    cubeName: Optional[str]
    #: 财务模型路径
    cubePath: Optional[str]
    #: 维度组合
    dimensionData: Optional[Any]


class MdxParam(BaseModel):
    key: Optional[str]
    type: Optional[int]
    value: Optional[str]


class ParameterDefineDto(BaseModel):
    #: key
    key: Optional[str]
    #: type
    type: Optional[int]
    #: value
    value: Optional[str]


class TaskExecutionParam(BaseModel):
    """Task Execution Param

    .. admonition:: 引用接口

        - **POST** ``/mdx/task/execution``
    """
    #: businessId
    businessId: Optional[str]
    #: callBackUrl
    callBackUrl: Optional[str]
    #: decimalDigitsType
    decimalDigitsType: Optional[int]
    #: entryMode
    entryMode: Optional[int]
    #: parameters
    parameters: Optional[List[ParameterDefineDto]]
    #: precision
    precision: Optional[int]
    #: script
    script: Optional[str]
    #: timeout
    timeout: Optional[int]


class TaskExecutionResult(BaseModel):
    """Task Execution Result

    .. admonition:: 引用接口

        - **POST** ``/mdx/task/execution`` (Response: 200)
    """
    #: 业务id
    businessId: Optional[str]
    #: 失败原因
    failReason: Optional[str]
    #: 处理是否正常，true 正常， false 异常
    result: Optional[bool]
    #: 状态，默认为0(正常返回)，超时为1(超时返回)，判断超时逻辑：result = true & status = 1
    status: Optional[int]
    #: 计算脚本影响单元格数，模型编辑器入口时返回具体值，其他时候返回null
    cell: Optional[int]


class CubeRightElementDTO(BaseModel):
    #: 被引用元素绝对/相对标识
    absoluteTag: Optional[bool]
    #: 元素列表的警告标记：0-正常；1-警告
    elWarning: Optional[int]
    #: 元素名称
    elementName: Optional[str]
    #: 组件名称
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 被引用元素相对路径
    relativePath: Optional[str]
    #: 组件服务名称
    serverName: Optional[str]


class ElementDeleteFrontRearDTO(BaseModel):
    """Element Delete Front Rear DTO

    .. admonition:: 引用接口

        - **POST** ``/cube/delete-other``
    """
    #: app
    app: Optional[str]
    #: elementName
    elementName: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: isDeleteData
    isDeleteData: Optional[str]
    #: path
    path: Optional[str]
    #: space
    space: Optional[str]


class ElementDetailDTO(BaseModel):
    #: 是否是绝对路径
    absoluteTag: Optional[bool]
    #: 多语言
    description: Optional[Any]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 多语言使用的key
    languageKey: Optional[str]
    #: 元素对应组件版本
    moduleVersion: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 相对路径
    relativePath: Optional[str]
    #: 元素对应组件服务名
    serverName: Optional[str]


class ElementDetailDto(BaseModel):
    #: description
    description: Optional[str]
    #: elementName
    elementName: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: languageKey
    languageKey: Optional[str]
    #: moduleVersion
    moduleVersion: Optional[str]
    #: path
    path: Optional[str]
    #: serverName
    serverName: Optional[str]


class ElementRelationDTO(BaseModel):
    #: 被引用元素绝对/相对标识
    absoluteTag: Optional[bool]
    #: 被引用元素名称
    elementName: Optional[str]
    #: 被引用元素类型
    elementType: Optional[str]
    #: 被引用元素文件夹id
    folderId: Optional[str]
    #: 被引用元素绝对路径
    path: Optional[str]
    #: 引用者元素名称
    quoter: Optional[str]
    #: 被引用元素相对路径
    relativePath: Optional[str]
    #: 被引用元素服务名
    serverName: Optional[str]


class ErrorDTO(BaseModel):
    #: 异常key
    tipKey: Optional[str]
    #: 异常信息
    tipValue: Optional[str]


class GroupRoleDataBlockUserGroup(BaseModel):
    #: groupId
    groupId: Optional[str]
    #: groupName
    groupName: Optional[str]


class ListTableQueryParamDTO(BaseModel):
    #: 元素名称
    elementName: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 页数
    page: Optional[int]
    #: 每页条数
    pageSize: Optional[int]
    #: pov条件
    pov: Optional[Any]
    #: screen
    screen: Optional[List[Any]]
    #: 搜索条件
    search: Optional[str]
    #: sheet01  第几个sheet页
    sheetMark: Optional[str]
    #: sort
    sort: Optional[List[Any]]


class ListTableVerifyErrorInfoDTO(BaseModel):
    #: 错误key
    tipKey: Optional[str]
    #: 错误提示描述
    tipValue: Optional[str]


class PageVo(BaseModel):
    #: 属性维别名
    adn: Optional[str]
    #: 多选时，维度成员
    curname: Optional[str]
    #: 字段名
    dc: Optional[str]
    #: 维度成员
    name: Optional[str]


class QueryOptimizeConfigVO(BaseModel):
    #: distinguishZero
    distinguishZero: Optional[bool]
    #: dynamicPriorityDimensionNames
    dynamicPriorityDimensionNames: Optional[List[str]]
    #: fewBaseMemberDimensionNames
    fewBaseMemberDimensionNames: Optional[List[str]]
    #: fixedJoinPriorityDimensionNames
    fixedJoinPriorityDimensionNames: Optional[List[str]]
    #: viewEnd
    viewEnd: Optional[bool]


class ReactFormAuthData(BaseModel):
    #: 别名与权限控制单元的关系
    accessControlUnitMap: Optional[Any]
    #: 清单表是否允许编辑
    allowEdit: Optional[int]
    #: 行数据，由别名和值构成
    businessData: Optional[Any]
    #: 字段初步权限判断
    colAlias2Auth: Optional[Any]
    #: 字段别名与角色方案间的关系
    colAliasRoleDim: Optional[Any]
    #: 是否启用权限控制单元
    enableAccessUnit: Optional[int]
    #: 清单表id
    listTableId: Optional[str]
    #: 清单表类型
    listType: Optional[int]
    #: 角色方案元素明细信息
    rsElementDetail: Optional[ElementDetailDTO]
    #: 角色方案名称
    rsName: Optional[str]
    #: 状态字段别名顺序集合
    statusAliasArr: Optional[List[str]]


class ReactFormErrorMessage(BaseModel):
    #: alias
    alias: Optional[str]
    #: colNum
    colNum: Optional[str]
    #: columnName
    columnName: Optional[str]
    #: dataTableName
    dataTableName: Optional[str]
    #: errMsg
    errMsg: Optional[str]
    #: errorCode
    errorCode: Optional[int]
    #: lineMapping
    lineMapping: Optional[str]
    #: rowNum
    rowNum: Optional[str]
    #: value
    value: Optional[Any]


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **POST** ``/block/pc-init`` (Response: 200)
        - **GET** ``/block/pc-init-status`` (Response: 200)
        - **POST** ``/block/pc-status`` (Response: 200)
        - **POST** ``/copyCalculate`` (Response: 200)
        - **GET** ``/dependencies`` (Response: 200)
        - **GET** ``/dynamic/config/get/{key}`` (Response: 200)
        - **GET** ``/dynamic/config/getAll`` (Response: 200)
        - **GET** ``/dynamic/config/remove/{key}`` (Response: 200)
        - **POST** ``/dynamic/config/update`` (Response: 200)
        - **POST** ``/spreadsheets/writeCacheToFile``
    """
    #: code
    code: Optional[int]
    #: data
    data: Optional[Any]
    #: message
    message: Optional[str]
    #: status
    status: Optional[bool]


class ResultObj(BaseModel):
    """Result Obj

    .. admonition:: 引用接口

        - **POST** ``/cubeCalculate/clearData`` (Response: 200)
    """
    #: map
    map: Optional[Any]
    #: resultCode
    resultCode: Optional[int]
    #: resultList
    resultList: Optional[List[Any]]
    #: resultObj
    resultObj: Optional[Any]
    #: resultString
    resultString: Optional[str]
    #: set
    set: Optional[List[Any]]
    #: tipMsg
    tipMsg: Optional[str]


class SheetDimensionLevelDto(BaseModel):
    #: 层级标题描述
    lns: Optional[List[Dict]]
    #: 层级成员集合
    lrs: Optional[List[Dict]]


class SheetPovInfoDto(BaseModel):
    """Sheet Pov Info Dto

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-member`` (Response: 200)
    """
    #: pov信息
    scriptMember: Optional[List[Dict]]
    #: sheet 名称
    sheetName: Optional[str]


class SheetPovTreeParam(BaseModel):
    """Sheet Pov Tree Param

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-dimension-tree``
    """
    #: defaultSelected
    defaultSelected: Optional[str]
    #: dimensionExpression
    dimensionExpression: Optional[str]
    #: dimensionFolderId
    dimensionFolderId: Optional[str]
    #: dimensionName
    dimensionName: Optional[str]
    #: dimensionType
    dimensionType: Optional[str]
    #: dimensionUsage
    dimensionUsage: Optional[str]
    #: name
    name: Optional[str]
    #: rsList
    rsList: Optional[str]
    #: rsMapping
    rsMapping: Optional[str]
    #: rsName
    rsName: Optional[str]
    #: searchValue
    searchValue: Optional[str]


class SheetUdMemberDto(BaseModel):
    #: 描述
    d: Optional[str]
    #: n
    n: Optional[str]


class SplitSqlWhiteDimensionConfig(BaseModel):
    #: dimensionName
    dimensionName: Optional[str]
    #: groupedDimensionMemberNames
    groupedDimensionMemberNames: Optional[List[List]]
    #: normalGranularity
    normalGranularity: Optional[int]
    #: normalMax
    normalMax: Optional[int]
    #: periodGranularityForMergeBase
    periodGranularityForMergeBase: Optional[int]
    #: periodGranularityForMergeNotNormal
    periodGranularityForMergeNotNormal: Optional[int]
    #: periodGranularityForMergeParent
    periodGranularityForMergeParent: Optional[int]
    #: type
    type: Optional[int]


class SpreadsheetError(BaseModel):
    #: 错误编码
    errorCode: Optional[int]
    #: 错误描述
    errorMsg: Optional[str]


class SpreadsheetRowData(BaseModel):
    #: 科目类型
    accountType: Optional[str]
    #: assistWritingAuditLogs
    assistWritingAuditLogs: Optional[Any]
    #: 列名和维度成员名对应关系
    columnDimensionMemberMap: Optional[Any]
    #: 错误提示
    errorMsgList: Optional[List[SpreadsheetError]]
    #: 单元格的位置，用于前台提示信息友好
    location: Optional[str]
    #: 更新的列名
    updateColumn: Optional[str]


class UdInfoDto(BaseModel):
    #: 别名
    alias: Optional[str]
    #: 多语种
    multilingual: Optional[Any]
    #: ud名称
    udName: Optional[str]


class ValueTypeMapDTO(BaseModel):
    #: 小数部分展示长度
    decimalDisplayLength: Optional[int]
    #: 默认值
    defaultValue: Optional[str]
    #: 默认值显示
    defaultValueShow: Optional[str]
    #: 整数部分长度
    digitLen: Optional[int]
    #: 维度展示类型
    dimensionDisplay: Optional[int]
    #: 维度名称
    dimensionName: Optional[str]
    #: 展示的整数长度
    displayDigitLen: Optional[int]
    #: 元素信息
    elementDetail: Optional[ElementDetailDTO]
    #: 是否启用维度表达式
    enableDimensionExpression: Optional[bool]
    #: 报错信息
    errorList: Optional[List[ListTableVerifyErrorInfoDTO]]
    #: 是否报错
    errorTag: Optional[bool]
    #: functionCode
    functionCode: Optional[str]
    #: 介绍
    instruction: Optional[str]
    #: 长度
    length: Optional[int]
    #: list
    list: Optional[str]
    #: 是否大于等于
    maxEqual: Optional[bool]
    #: 最大长度
    maxLen: Optional[int]
    #: 最大值
    maximun: Optional[str]
    #: 是否小于等于
    minEqual: Optional[bool]
    #: 最小值
    minimun: Optional[float]
    #: 多层级
    multiLevel: Optional[str]
    #: 最大选择的限制
    multipleChoiceLimit: Optional[int]
    #: 多层级信息
    multipleLevelInfo: Optional[List[Any]]
    #: 是否百分比显示
    percentage: Optional[bool]
    #: 选择多层级
    selectMulti: Optional[str]
    #: 是否允许多选
    selectedMulti: Optional[bool]
    #: 值列表展示类型
    smartListDisplay: Optional[int]
    #: 是否千分位显示
    thousandthSymbol: Optional[bool]
    #: 是否树形展示
    treeView: Optional[bool]
    #: 多个值字段
    valueField: Optional[List[str]]
    #: valueKey
    valueKey: Optional[str]
    #: 字段类型
    valueType: Optional[int]


class CubeAccessStatus(BaseModel):
    #: 状态
    status: Optional[str]
    #: 状态描述
    statusDescription: Optional[str]


class DataBlockDimension(BaseModel):
    #: 数据块的id
    blockId: Optional[str]
    #: 数据块行号
    blockLine: Optional[str]
    #: cube的id
    cubeId: Optional[str]
    #: dimensionFolderId
    dimensionFolderId: Optional[str]
    #: 维度名称
    dimensionName: Optional[str]
    #: 维度脚本
    dimensionScript: Optional[str]
    #: 行号
    line: Optional[int]
    #: seg段名称
    segName: Optional[str]


class DataBlockDimDto(BaseModel):
    #: 块的id
    blockId: Optional[str]
    #: cube的id
    cubeId: Optional[str]
    #: 维度脚本
    dimensionScript: Optional[str]
    #: 行号
    line: Optional[int]
    #: 成员数组集合
    menmbers: Optional[List[str]]
    #: seg段的名称
    segName: Optional[str]


class RoleDto(BaseModel):
    #: 昵称
    nickName: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]


class RoleDataBlock(BaseModel):
    #: 默认角色组名称
    defaultRolegroupName: Optional[str]
    #: 描述信息
    description: Optional[Any]
    #: 唯一标识
    key: Optional[str]
    #: 编码
    name: Optional[str]
    #: 角色id
    roleId: Optional[str]
    #: 角色名称
    roleName: Optional[str]


class CellDataDTO(BaseModel):
    #: 实际表名
    actualTableName: Optional[str]
    #: 字段别名
    alias: Optional[str]
    #: 权限
    auth: Optional[str]
    #: code值
    codeValue: Optional[str]
    #: 列号和别名
    colObj: Optional[Any]
    #: 数据表名
    dataTableName: Optional[str]
    #: 数据表别名
    datatableAlias: Optional[str]
    #: 字段名
    datatableColumn: Optional[str]
    #: 单元格数据是否需要编辑标识
    editFlag: Optional[bool]
    #: 允许为空
    isAllowEmpty: Optional[int]
    #: 字段描述
    label: Optional[str]
    #: 数据表行id名称
    lineIdName: Optional[str]
    #: 数据表行Id值
    lineIdValue: Optional[str]
    #: 行号
    rowNum: Optional[str]
    #: 字段值
    value: Optional[str]
    #: 字段性质对象
    valueTypeMap: Optional[ValueTypeMapDTO]


class CubeDimensionDto(BaseModel):
    #: 字段列是否为主键（true表示作为主键）
    columnPrimary: Optional[bool]
    #: 列类型
    columnType: Optional[int]
    #: 字段列名
    datatableColumn: Optional[str]
    #: 字段关联的维度的路径标识
    dimAbsoluteTag: Optional[bool]
    #: 字段关联的维度相对路径
    dimRelationPath: Optional[str]
    #: 字段关联的维度所在文件夹Id
    dimensionFolderId: Optional[str]
    #: 字段关联的维度的moudelId
    dimensionMoudelId: Optional[str]
    #: 字段关联维度名称
    dimensionName: Optional[str]
    #: 字段关联的维度的路径
    dimensionPath: Optional[str]
    #: dimensionServerName
    dimensionServerName: Optional[str]
    #: 列作用
    dimensionUsage: Optional[int]
    #: 异常信息
    errorList: Optional[List[ErrorDTO]]
    #: 是否关联时间维度字段
    isDate: Optional[bool]
    #: isNewDimension
    isNewDimension: Optional[bool]
    #: 关联数据表字段是否丢失
    lossCol: Optional[bool]
    #: 度量类型,1data2text
    measureType: Optional[int]
    #: multilingual
    multilingual: Optional[Any]
    #: 是否用做权限字段(仅维度类型的允许用做权限字段)
    roleSeg: Optional[bool]
    #: 该维度关联的ud信息
    udInfoDtos: Optional[List[UdInfoDto]]


class CubeRelationResponseDTO(BaseModel):
    """Cube Relation Response DTO

    .. admonition:: 引用接口

        - **GET** ``/cube/relation-query`` (Response: 200)
    """
    #: 关联关系结果
    elementDetail: Optional[ElementRelationDTO]
    #: 当前cube的路径
    formPath: Optional[str]
    #: 当前元素引用者
    related: Optional[str]
    #: 当前被关联元素标识
    relationField: Optional[str]
    #: 当前引用元素类型
    typeFlag: Optional[str]


class CustomizeSplitSqlForPeriod(BaseModel):
    #: forBase
    forBase: Optional[List[SplitSqlWhiteDimensionConfig]]
    #: forParent
    forParent: Optional[List[SplitSqlWhiteDimensionConfig]]


class PageParamsVo(BaseModel):
    #: ac
    ac: Optional[Any]
    #: 清单表pov对象
    listTableQueryParamDTO: Optional[ListTableQueryParamDTO]
    #: pov对象
    page: Optional[List[PageVo]]
    #: sheet名称
    sheetName: Optional[str]


class ReactFormListDTO(BaseModel):
    #: 删除的数据
    delete: Optional[List[List]]
    #: 使用视图保存时产生的错误信息
    errorMessage: Optional[List[ReactFormErrorMessage]]
    #: 清单表id
    formListId: Optional[str]
    #: 插入的数据
    insert: Optional[List[List]]
    #: pov
    pov: Optional[Any]
    #: 权限数据参数
    reactFormAuthData: Optional[ReactFormAuthData]
    #: 展示列信息
    showColumns: Optional[List[Dict]]
    #: 更新的数据
    update: Optional[List[CellDataDTO]]


class SheetDimensionAttributeDto(BaseModel):
    #: sd-展示维度描述，sb-展示描述名称和描述，sn-展示维度名称，h-隐藏
    sab: Optional[str]
    #: 维度属性与维度间隔数
    sp: Optional[int]
    #: ud成员描述集合
    uds: Optional[List[SheetUdMemberDto]]
    #: ud属性标题描述集合
    uns: Optional[List[SheetUdMemberDto]]


class SheetDimensionDto(BaseModel):
    #: autoWrap
    autoWrap: Optional[int]
    #: 描述
    d: Optional[str]
    #: 字段名
    dc: Optional[str]
    #: dimensionKey
    dimensionKey: Optional[str]
    #: 单元格缩进格数
    et: Optional[int]
    #: 是否是父类 0-是 1-否
    ib: Optional[int]
    #: 收缩单元格数，逻辑见详情
    le: Optional[int]
    #: 限制收缩宽度
    lee: Optional[int]
    #: 合并单元格数
    mc: Optional[int]
    #: 倒序合并单元格的数量 ,仅在倒序时使用
    mcr: Optional[int]
    #: mergeCell
    mergeCell: Optional[str]
    #: 维度名称
    n: Optional[str]
    #: sd-展示维度描述，sb-展示描述名称和描述，sn-展示维度名称，h-隐藏
    sab: Optional[str]
    #: st
    st: Optional[int]
    #: 维度属性展示
    uaList: Optional[List[SheetDimensionAttributeDto]]
    #: 维度层级对象
    ul: Optional[SheetDimensionLevelDto]
    #: v
    v: Optional[int]
    #: virtualMeasure
    virtualMeasure: Optional[bool]


class SheetMemberDto(BaseModel):
    #: 行或列上的数据类型
    cellType: Optional[str]
    #: dc
    dc: Optional[str]
    #: 维度成员信息
    sdd: Optional[List[SheetDimensionDto]]
    #: sortKey
    sortKey: Optional[str]
    #: 标识是否存在属性维 1-只存在属性维，这个时候前端不能保存
    v: Optional[int]


class SheetPovMulitLevelDto(BaseModel):
    #: 层级描述
    des: Optional[str]
    #: level
    level: Optional[str]
    #: pls
    pls: Optional[List[SheetDimensionDto]]


class SheetRowDto(BaseModel):
    #: ab
    ab: Optional[str]
    #: autoWrap
    autoWrap: Optional[int]
    #: autoWraps
    autoWraps: Optional[List[int]]
    #: 列是否置空（指的是列组合，并不是单列）0-否  1-是
    blankCell: Optional[int]
    #: 每列或每行维度描述
    ds: Optional[List[Dict]]
    #: 该列的第几行是否收缩  0-收缩  1-展开
    f: Optional[List[int]]
    #: 该列是否隐藏 （指的是列组合，并非单列）0-否 1-是
    h: Optional[int]
    #: hideBlank
    hideBlank: Optional[str]
    #: hidenoaccess
    hidenoaccess: Optional[int]
    #: hidezero
    hidezero: Optional[int]
    #: 该列的成员组合，有多少个就有多少列
    m: Optional[List[SheetMemberDto]]
    #: 行/列中最长的字符串(带缩进)
    maxContent: Optional[List[str]]
    #: rateLength
    rateLength: Optional[int]
    #: ul合并单元格数
    ulMc: Optional[List[List]]
    #: virtualMeasure
    virtualMeasure: Optional[bool]
    #: width
    width: Optional[str]
    #: 列宽度
    widths: Optional[List[str]]


class SplitSqlFixedConfigItem(BaseModel):
    #: black
    black: Optional[List[str]]
    #: customizePeriodSplitNotUseWhiteOrBlack
    customizePeriodSplitNotUseWhiteOrBlack: Optional[CustomizeSplitSqlForPeriod]
    #: white
    white: Optional[List[SplitSqlWhiteDimensionConfig]]


class SpreadsheetSingleData(BaseModel):
    """Spreadsheet Single Data

    .. admonition:: 引用接口

        - **POST** ``/react/spreadsheet/save`` (Response: 200)
        - **POST** ``/react/spreadsheet/saveFromZip`` (Response: 200)
    """
    #: 公共成员错误提示
    commonErrorMsgList: Optional[List[SpreadsheetError]]
    #: pov公共参数
    commonMember: Optional[Any]
    #: 财务folderId
    cubeFolderId: Optional[str]
    #: cubeId
    cubeId: Optional[str]
    #: 财务模型名称
    cubeName: Optional[str]
    #: 财务path
    cubePath: Optional[str]
    #: 浮动行参数
    formListDTO: Optional[ReactFormListDTO]
    #: 指定当前sheet页批量保存大小，默认100W
    insertBatch: Optional[float]
    #: 表格数据
    rowDatas: Optional[List]
    #: sheet页id
    sheetId: Optional[str]
    #: sheet页类型
    sheetType: Optional[str]


class WookbookParamDto(BaseModel):
    """Wookbook Param Dto

    .. admonition:: 引用接口

        - **POST** ``/spreadsheets/query-workbook-data``
    """
    #: language
    language: Optional[str]
    #: pov参数
    pageList: Optional[List[PageParamsVo]]
    #: sheet页name
    sheetName: Optional[str]
    #: showSheet
    showSheet: Optional[str]
    #: 电子表格路径id
    wbFolderId: Optional[str]
    #: 电子表格名称
    wbName: str
    #: 电子表格路径
    wbPath: Optional[str]


class DataBlockInfo(BaseModel):
    #: 访问控制单元
    accessControlUnit: Optional[str]
    #: blockDimensionList
    blockDimensionList: Optional[List[DataBlockDimension]]
    #: 数据块类型
    blockType: Optional[int]
    #: cube的id
    cubeId: Optional[str]
    #: errorList
    errorList: Optional[List[ErrorDTO]]
    #: id
    id: Optional[str]
    #: 介绍
    instruction: Optional[str]
    #: 数据块的名称
    name: Optional[str]
    #: 使用Period维度
    usePeriod: Optional[int]
    #: 使用Scenario维度
    useScenario: Optional[int]
    #: 使用Version维度
    useVersion: Optional[int]
    #: 使用Year维度
    useYear: Optional[int]


class DataBlockInfoDto(BaseModel):
    #: 块的id
    blockId: Optional[str]
    #: 块的类型
    blockType: Optional[int]
    #: cube的id
    cubeId: Optional[str]
    #: 功能编码
    functionCode: Optional[List[str]]
    #: 介绍
    instruction: Optional[str]
    #: list
    list: Optional[List[DataBlockDimDto]]
    #: 名称
    name: Optional[str]


class AccountCalendarDto(BaseModel):
    #: defaultPeriod
    defaultPeriod: Optional[str]
    #: defaultYear
    defaultYear: Optional[str]
    #: name
    name: Optional[str]
    #: period
    period: Optional[List[SheetDimensionDto]]
    #: year
    year: Optional[List[SheetDimensionDto]]


class CubeQueryForOutVo(BaseModel):
    """Cube Query For Out Vo

    .. admonition:: 引用接口

        - **POST** ``/cube-data/query``
    """
    #: 扩展需要汇总的列作用
    aggregationDimEnum: Optional[List[str]]
    #: 公共维度表达式
    commonScript: Optional[str]
    #: 财务模型名称
    cubeName: str
    #: 财务模型路径id
    folderId: Optional[str]
    #: 是否需要返回权限信息
    needAccess: Optional[bool]
    #: 无数据依然返回权限
    needAccessWithNoData: Optional[bool]
    #: 页号
    pageNo: Optional[int]
    #: 每页条数
    pageSize: Optional[int]
    #: 财务模型路径
    path: Optional[str]
    #: 查询优化器配置
    queryOptimizeConfig: Optional[QueryOptimizeConfigVO]
    #: 维度表达式
    script: str
    #: 并行优化器配置
    splitSqlConfig: Optional[SplitSqlFixedConfigItem]


class PcParams(BaseModel):
    """Pc Params

    .. admonition:: 引用接口

        - **POST** ``/block/pc-init``
        - **POST** ``/block/pc-status``
    """
    #: 审批单元集合
    blockInfoList: Optional[List[DataBlockInfo]]
    #: 审批单元编码集合
    blockList: Optional[List[str]]
    #: 审批单元名称
    blockName: Optional[str]
    #: 财务模型folderId
    cubeFolderId: Optional[str]
    #: 财务模型开关
    cubeName: Optional[str]
    #: 财务模型Path
    cubePath: Optional[str]
    #: 审批控制字段(key:字段名，value:维度表达式)
    datablockMap: Optional[Any]
    #: 数据表类型
    datatableElementType: Optional[str]
    #: extParam
    extParam: Optional[str]
    #: insertBatch
    insertBatch: Optional[float]
    #: 审批动作
    operationName: Optional[str]
    #: 流程控制字段(key:字段名，value:维度表达式)
    processMap: Optional[Any]
    #: 审批状态
    status: Optional[str]


class ReactSpreadsheetSaveForm(BaseModel):
    """React Spreadsheet Save Form

    .. admonition:: 引用接口

        - **POST** ``/react/spreadsheet/save``
    """
    #: 日志开关
    dataAuditSwitch: Optional[bool]
    #: 数据来源icon
    entryMode: int
    #: 数据来源
    entryObject: str
    #: needCheck
    needCheck: Optional[bool]
    #: 多sheet
    sheetDatas: Optional[List[SpreadsheetSingleData]]
    #: 校验维度成员大小写
    validateDimensionMember: Optional[bool]
    #: 电子表格folderid
    wbFolderId: Optional[str]
    #: 电子表格名称
    wbName: Optional[str]
    #: 电子表格path
    wbPath: Optional[str]
    #: 是否回调
    callback: Optional[bool]


class SheetColumnDto(BaseModel):
    #: ab
    ab: Optional[str]
    #: autoWrap
    autoWrap: Optional[int]
    #: 列是否置空（指的是列组合，并不是单列）0-否  1-是
    blankCell: Optional[int]
    #: 该列的第几行是否收缩  0-收缩  1-展开
    f: Optional[List[int]]
    #: 该列是否隐藏 （指的是列组合，并非单列）0-否 1-是
    h: Optional[int]
    #: hideBlank
    hideBlank: Optional[str]
    #: hidenoaccess
    hidenoaccess: Optional[int]
    #: hidezero
    hidezero: Optional[int]
    #: 该列的成员组合，有多少个就有多少列
    m: Optional[List[SheetMemberDto]]
    #: 行/列中最长的字符串(带缩进)
    maxContent: Optional[List[str]]
    #: rateLength
    rateLength: Optional[int]
    #: ul合并单元格数
    ulMc: Optional[List[List]]
    #: virtualMeasure
    virtualMeasure: Optional[bool]
    #: width
    width: Optional[str]


class SheetPageDto(BaseModel):
    #: 是否为会计日历，1-是会计日历
    acFlag: Optional[int]
    #: 属性维-存放后面维度字段
    adn: Optional[str]
    #: dc
    dc: Optional[str]
    #: 默认维度成员  名称
    dfd: Optional[str]
    #: dg
    dg: Optional[int]
    #: 维度表达式
    dimensionExpress: Optional[str]
    #: 维度路径Id
    dimensionFolderId: Optional[str]
    #: dimension name
    dn: Optional[str]
    #: dimension type
    dt: Optional[str]
    #: elementDetail
    elementDetailDto: Optional[ElementDetailDto]
    #: 结束会计日历
    endAc: Optional[AccountCalendarDto]
    #: g
    g: Optional[int]
    #: 1-前端允许多选  0-不允许
    hc: Optional[int]
    #: 限制多选个数
    hcN: Optional[int]
    #: 保存数据时，是否需要page  1-不需要
    is_: int = Field(None, alias='is')
    #: 多层级控制，表达式涵盖的可选范围
    leCon: Optional[str]
    #: 多层级时，前端用该对象渲染维度信息
    levels: Optional[List[SheetPovMulitLevelDto]]
    #: page部分维度成员集合
    pls: Optional[List[SheetDimensionDto]]
    #: rateLength
    rateLength: Optional[int]
    #: role_seg
    role_seg: Optional[bool]
    #: rsDimension
    rsDimension: Optional[str]
    #: rsFolderId
    rsFolderId: Optional[str]
    #: rsList
    rsList: Optional[List[Dict]]
    #: rsMapping
    rsMapping: Optional[str]
    #: rsName
    rsName: Optional[str]
    #: 展示属性
    sb: Optional[str]
    #: pov 存在树形结构时，维度表达式
    sc: Optional[str]
    #: 属性name
    sn: Optional[str]
    #: 起始会计日历
    startAc: Optional[AccountCalendarDto]
    #: text描述
    text: Optional[str]
    #: text多语言
    textLanguage: Optional[str]
    #: 树形结构  0-否  1-是
    tr: Optional[int]
    #: 判断字段是否汇总
    ug: Optional[int]
    #: v
    v: Optional[int]
    #: virtualMeasure
    virtualMeasure: Optional[bool]


class CubeAccessControlViewReact(BaseModel):
    #: add
    add: Optional[List['CubeAccessCtrlDto']]
    #: delete
    delete: Optional[List[str]]
    #: edit
    edit: Optional[List['CubeAccessCtrlDto']]


class DatatableColumnDto(BaseModel):
    #: 字段默认值
    defaultValue: Optional[str]
    #: 列描述
    description: Optional[str]
    #: 字段长度
    length: Optional[str]
    #: 列名
    name: Optional[str]
    #: 列旧数据
    oldInfo: Optional['DatatableColumnDto']
    #: 操作类型
    operation: Optional[str]
    #: 排序字段
    sort: Optional[int]
    #: 列类型
    type: Optional[str]
    #: 是否为空
    whetherEmpty: Optional[bool]
    #: 是否为自增
    whetherIncrement: Optional[bool]
    #: 是否为唯一键
    whetherOnly: Optional[bool]
    #: 是否为主键
    whetherPrimary: Optional[bool]
    #: 是否为系统字段
    whetherSystemColumn: Optional[bool]


class DatatableInfoDto(BaseModel):
    #: 实际表名
    actualTableName: Optional[str]
    #: 数据表名称的多语言
    description: Optional[Any]
    #: 数据表元素类型
    elementType: Optional[str]
    #: engineType
    engineType: Optional[int]
    #: 所在文件夹id
    folderId: Optional[str]
    #: 数据表Id
    id: Optional[str]
    #: moduleId
    moduleId: Optional[str]
    #: 数据表名称
    name: Optional[str]
    #: 数据表旧数据
    oldInfo: Optional['DatatableInfoDto']
    #: 数据表路径
    path: Optional[str]


class FinancialModelDto(BaseModel):
    """Financial Model Dto

    .. admonition:: 引用接口

        - **GET** ``/cube/data`` (Response: 200)
        - **GET** ``/cube/right/query`` (Response: 200)
        - **POST** ``/cube/save``
        - **POST** ``/cube/save`` (Response: 200)
    """
    #: 财务数据模型主数据
    cube: 'FinancialDataDto'
    #: 财务数据模型列数据
    cubeDimensionList: List[CubeDimensionDto]
    #: 关联数据表主数据
    datatable: DatatableInfoDto
    #: 关联数据表列数据
    datatableCols: List[DatatableColumnDto]
    #: 关联维度数据
    dimensions: List[Any]
    #: 校验结果，如果为true则出现异常
    errorFlag: Optional[bool]
    #: 元素权限
    permission: Optional[int]
    #: 保存类型0为只校验,1为保存
    saveType: Optional[int]


class GroupRoleDatablockReactView(BaseModel):
    #: add
    add: Optional[List['RoleSetDataBlock']]
    #: delete
    delete: Optional[List[str]]
    #: edit
    edit: Optional[List['RoleSetDataBlock']]


class SheetDto(BaseModel):
    """Sheet Dto

    .. admonition:: 引用接口

        - **POST** ``/dynamic-report/query`` (Response: 200)
    """
    #: adaptive
    adaptive: Optional[List[str]]
    #: 列头显示控制对象
    colHeaderList: Optional[List['HeaderObject']]
    #: 列维度0正序1倒序
    colShowOrder: Optional[int]
    #: 电子表格的列部分
    columnList: Optional[List[SheetColumnDto]]
    #: 财务模型路径Id
    cubeFolderId: Optional[str]
    #: 财务模型ID
    cubeId: Optional[str]
    #: 财务模型名称
    cubeName: Optional[str]
    #: cubeType
    cubeType: Optional[int]
    #: 数据
    dataList: Optional[List[List]]
    #: 区分0查询开关
    distinguishZeroSwitch: Optional[bool]
    #: 数据表的key
    dtn: Optional[str]
    #: 冻结起始列
    fc: Optional[int]
    #: 固定顺序join优先级维度名称
    fixedJoinPriorityDimensionNames: Optional[List[str]]
    #: 固定join优先级开关
    fixedJoinPrioritySwitch: Optional[bool]
    #: 浮动行列表返回类型
    formListDatas: Optional[Any]
    #: 冻结起始行
    fr: Optional[int]
    #: 开表查询-join中in对应base增加到事实表where后面，配置的维度名称
    joinInBaseToFactDimensionNames: Optional[List[str]]
    #: 开表查询-join中in对应base增加到事实表where后面，配置开关
    joinInBaseToFactSwitch: Optional[bool]
    #: js文件路径
    jsfile: Optional[str]
    #: json文件路径
    jsonfile: Optional[str]
    #: 开表无数据的原因
    noDataReason: Optional[str]
    #: 精度1，0.1，0.01，0.001，0.0001，0.00001，0.000001
    p: Optional[str]
    #: 0-禁止调整小数位，1允许
    pa: Optional[int]
    #: pov部分
    pageList: Optional[List[SheetPageDto]]
    #: 刷新后触发自定义js方法
    rar: Optional[str]
    #: 保存前触发自定义js方法
    rbs: Optional[str]
    #: 初次加载触发自定义js方法
    rol: Optional[str]
    #: 行头显示控制对象
    rowHeaderList: Optional[List['HeaderObject']]
    #: 电子表格行部分
    rowList: Optional[List[SheetRowDto]]
    #: 行维度0正序1倒序
    rowShowOrder: Optional[int]
    #: 起始列
    sc: Optional[int]
    #: sheet描述
    sd: Optional[str]
    #: sheet name language
    sheetNameLanguage: Optional[str]
    #: sheet id
    si: Optional[str]
    #: sheet name 开表取值规则：优先取sheetNameLanguage，为空则取sheetName的值
    sn: Optional[str]
    #: sheet name 多语言辅助字段，备份原sn(辅助前端用)
    snl: Optional[str]
    #: 起始行
    sr: Optional[int]
    #: 静态表返回
    staticCells: Optional[List[Dict]]
    #: sheet页类型 1-动态  2-静态  3-浮动行表
    t: Optional[int]
    #: 0-禁止显示千分位分隔符 1-允许
    ts: Optional[int]
    #: 0-禁止调整千分位分隔符，1-允许
    tsa: Optional[int]
    #: 0-禁止调整单位 1-允许
    ua: Optional[int]
    #: 单位 1，1000，10000，1000000，1000000000
    unit: Optional[str]
    #: view设置到尾部开关
    viewEndSwitch: Optional[bool]
    #: workType
    workType: Optional[str]


class WorkbookInfoDto(BaseModel):
    """Workboot Dto

    .. admonition:: 引用接口

        - **POST** ``/spreadsheets/query-workbook-data`` (Response: 200)
    """
    #: cubeInfoDataCache
    cubeInfoDataCache: Optional[Any]
    #: 电子表格描述
    description: Optional[Any]
    #: 文件缓存时间
    fileCacheTime: Optional[int]
    #: 电子表格说明
    instruction: Optional[Any]
    #: 电子表格名称
    name: Optional[str]
    #: 电子表格元素权限
    permission: Optional[int]
    #: sheet页
    sheetList: Optional[List[SheetDto]]
    #: 默认展示sheet页id
    showSheet: Optional[str]


class SheetPovChildrenDto(BaseModel):
    #: children
    children: Optional[List['SheetPovChildrenDto']]
    #: d
    d: Optional[str]
    #: default_selected
    default_selected: Optional[bool]
    #: ia
    ia: Optional[int]
    #: ib
    ib: Optional[bool]
    #: n
    n: Optional[str]
    #: open
    open: Optional[bool]
    #: selected
    selected: Optional[bool]
    #: st
    st: Optional[int]


class SheetPovTreeDto(BaseModel):
    """Sheet Pov Tree Dto

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-dimension-tree`` (Response: 200)
    """
    #: tree
    tree: Optional[List[SheetPovChildrenDto]]


class CubeAccessCtrlDto(BaseModel):
    #: 访问权限
    accessRight: Optional[int]
    #: 角色是否全选的标识位
    allRoles: Optional[bool]
    #: cube的id
    cubeId: Optional[str]
    #: 临时赋值用的多语言描述信息
    des: Optional[str]
    #: id
    id: Optional[str]
    #: 行号
    line: Optional[int]
    #: 角色，多个用逗号隔开
    role: Optional[str]
    #: 角色组，多个用逗号隔开
    roleGroup: Optional[str]
    #: roleGroupList
    roleGroupList: Optional[List['RoleSetDataBlock']]
    #: roleList
    roleList: Optional[List[RoleDataBlock]]
    #: 状态
    status: Optional[str]
    #: statusList
    statusList: Optional[List[CubeAccessStatus]]


class HeaderObject(BaseModel):
    #: 描述
    d: Optional[str]
    #: 显示方式
    hide: Optional[str]
    #: 名称
    n: Optional[str]
    #: 标题
    title: Optional[str]
    #: ua属性显示方式
    uaHeaderList: Optional[List['HeaderObject']]
    #: 是否虚拟度量
    virtualMeasure: Optional[bool]


class RoleSetDataBlock(BaseModel):
    #: 角色是否全选的标识位
    allRoles: Optional[bool]
    #: block的Id
    blockId: Optional[str]
    #: block的名称
    blockName: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建者
    creater: Optional[str]
    #: cube的Id
    cubeId: Optional[str]
    #: id
    id: Optional[str]
    #: 修改者
    modifier: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 审批操作
    operationList: Optional[List[str]]
    #: 角色，多个用逗号隔开
    role: Optional[str]
    #: 角色组，多个用逗号隔开
    roleGroup: Optional[str]
    #: 角色组角色组数据块
    roleGroupList: Optional[List['RoleSetDataBlock']]
    #: 角色组角色数据块
    roleList: Optional[List[RoleDataBlock]]
    #: 排序信息
    sort: Optional[int]
    #: 用户组id集合
    userGroupIdIntList: Optional[List[str]]
    #: 用户组id
    userGroupInfoId: Optional[str]
    #: 用户组列表
    userGroupList: Optional[List[GroupRoleDataBlockUserGroup]]
    #: 用户组id集合
    userIdIntList: Optional[List[str]]
    #: 用户id
    userInfoId: Optional[str]
    #: 用户列表
    userList: Optional[List[RoleDto]]


class FinancialDataDto(BaseModel):
    """财务数据模型实体类

    .. admonition:: 引用接口

        - **GET** ``/cube/find-cube-data`` (Response: 200)
        - **POST** ``/cube/right`` (Response: 200)
    """
    #: 科目表达式,cube类型为3时,使用该属性
    accountMemberScript: Optional[str]
    #: 关联流程表路径标识
    airAbsoluteTag: Optional[bool]
    #: 关联流程表的相对路径
    airRelativePath: Optional[str]
    #: 自动汇总开关
    autoCalculation: Optional[bool]
    #: 资产负债类科目保存
    balanceAccountSave: Optional[int]
    #: 财务模型角色--审批单元
    blockInfoList: Optional[List[DataBlockInfo]]
    #: 关联cube权限表路径标识
    cacAbsoluteTag: Optional[bool]
    #: 关联cube权限表的相对路径
    cacRelativePath: Optional[str]
    #: checkCol
    checkCol: Optional[bool]
    #: 清空null数据开关
    clearNullSwitch: Optional[bool]
    #: 清空0数据开关
    clearZeroSwitch: Optional[bool]
    #: 关联备注表的路径标识
    comAbsoluteTag: Optional[bool]
    #: 关联备注表的相对路径
    comRelativePath: Optional[str]
    #: 备注表的实际表名
    commentActualTableName: Optional[str]
    #: 读写权限--权限保存前端传参
    cubeAccessControl: Optional[CubeAccessControlViewReact]
    #: 读写权限--权限查询返回给前端用
    cubeAccessControlList: Optional[List[CubeAccessCtrlDto]]
    #: 财务模型角色--读写权限 总条数
    cubeAccessControlTotal: Optional[int]
    #: 汇总模式,1属性汇总模式2全汇总模式
    cubeMode: Optional[int]
    #: cube的日志/备注/附件表引用关系
    cubeRelationInfo: Optional[List[CubeRelationResponseDTO]]
    #: cube类型,3科目作为度量4期间作为度量5不作为度量
    cubeType: Optional[int]
    #: 数据表类型（0-MySQL，1-CK）
    dataSync: Optional[int]
    #: datablockInfo
    datablockInfo: Optional[List[DataBlockInfoDto]]
    #: 关联数据表的相对路径
    datatableAbsoluteTag: Optional[bool]
    #: 数据表元素类型
    datatableElementType: Optional[str]
    #: 关联的数据表所在文件夹Id
    datatableFolderId: Optional[str]
    #: 关联的数据表的ModuleId
    datatableModuleId: Optional[str]
    #: 财务数据模型关联数据表名称
    datatableName: Optional[str]
    #: 关联数据表的路径
    datatablePath: Optional[str]
    #: 关联数据表的相对路径
    datatableRelativePath: Optional[str]
    #: cube选用的数据表组件的服务名
    datatableServerName: Optional[str]
    #: 关联流程表路径标识
    dbcAbsoluteTag: Optional[bool]
    #: 关联流程表的相对路径
    dbcRelativePath: Optional[str]
    #: 名称的多语言描述对象
    description: Optional[Any]
    #: 关联维度路径标识
    dimAbsoluteTag: Optional[bool]
    #: 关联维度的相对路径
    dimRelativePath: Optional[str]
    #: 关联维度的所在的文件夹Id.cubeType为3时Account维度所在文件夹Id;4时Period维度所在文件夹Id
    dimensionFolderId: Optional[str]
    #: 关联维度的module
    dimensionModuleId: Optional[str]
    #: 关联维度的路径
    dimensionPath: Optional[str]
    #: 维度组件的服务名
    dimensionServerName: Optional[str]
    #: 区分0查询开关
    distinguishZeroSwitch: Optional[bool]
    #: 关联角色方案路径标识
    drsAbsoluteTag: Optional[bool]
    #: 元素错误标识
    elWarning: Optional[int]
    #: 异常信息
    errorList: Optional[List[ErrorDTO]]
    #: 异常标记
    errorTag: Optional[bool]
    #: 关联附件表的路径标识
    fileAbsoluteTag: Optional[bool]
    #: 附件表的实际表名
    fileActualTableName: Optional[str]
    #: 关联附件表的相对路径
    fileRelativePath: Optional[str]
    #: 固定顺序join优先级维度名称(外部取数专用，开表用sheet配置)
    fixedJoinPriorityDimensionNames: Optional[List[str]]
    #: 固定join优先级开关(外部取数专用，开表用sheet配置)
    fixedJoinPrioritySwitch: Optional[bool]
    #: 损益类科目保存
    flowAccountSave: Optional[int]
    #: 财务数据模型所在文件夹Id
    folderId: Optional[str]
    #: 审批单元角色--权限查询前端传参
    groupRoleDatablock: Optional[GroupRoleDatablockReactView]
    #: 审批单元角色--权限查询返回给前端
    groupRoleDatablockList: Optional[List[RoleSetDataBlock]]
    #: groupRoleDatablockReactView
    groupRoleDatablockReactView: Optional[GroupRoleDatablockReactView]
    #: 财务模型角色--审批单元角色 总条数
    groupRoleDatablockTotal: Optional[int]
    #: 财务数据模型id
    id: Optional[str]
    #: 开表查询-join中in对应base增加到事实表where后面，配置的维度名称(外部取数专用，开表用sheet配置)
    joinInBaseToFactDimensionNames: Optional[List[str]]
    #: 开表查询-join中in对应base增加到事实表where后面，配置开关(外部取数专用，开表用sheet配置)
    joinInBaseToFactSwitch: Optional[bool]
    #: join优先级维度名称集合
    joinPriorityDimensionNames: Optional[List[str]]
    #: join优先级开关
    joinPrioritySwitch: Optional[bool]
    #: 关联日志表的路径标识
    logAbsoluteTag: Optional[bool]
    #: 日志表的实际表名
    logActualTableName: Optional[str]
    #: 关联日志表的相对路径
    logRelativePath: Optional[str]
    #: 最小期间层级,cube类型为4时,使用该属性
    minPeriodLevel: Optional[str]
    #: 财务数据模型moduleId
    moduleId: Optional[str]
    #: 财务数据模型名称
    name: Optional[str]
    #: 当前cube存在通用period父成员时是否拆父
    notSplitCommonPeriodParentForThisCube: Optional[bool]
    #: 是否不对当前cube拆分sql
    notSplitSqlForThisCube: Optional[bool]
    #: 财务数据模型路径
    path: Optional[str]
    #: 关联审批流路径标识
    pcAbsoluteTag: Optional[bool]
    #: 流程控制元素信息--前端传参
    pcElementDetail: Optional[CubeRightElementDTO]
    #: 关联审批流的相对路径
    pcRelativePath: Optional[str]
    #: 元素权限
    permission: Optional[int]
    #: 关联审批表路径标识
    processControlAbsoluteTag: Optional[bool]
    #: 关联审批表的相对路径
    processControlRelativePath: Optional[str]
    #: 角色方案元素信息--前端传参
    rsElementDetail: Optional[CubeRightElementDTO]
    #: 关联角色方案的相对路径
    rsRelativePath: Optional[str]
    #: 财务数据模型包名
    serverName: Optional[str]
    #: view设置到尾部开关
    viewEndSwitch: Optional[bool]
    #: 财务数据模型关联数据表真实表名
    actualTableName: Optional[str]
    #: 财务数据模型列数据
    cubeDimensionList: Optional[List[CubeDimensionDto]]
    #: 关联数据表主数据
    datatable: Optional[DatatableInfoDto]


CubeAccessControlViewReact.update_forward_refs()
DatatableColumnDto.update_forward_refs()
DatatableInfoDto.update_forward_refs()
FinancialModelDto.update_forward_refs()
GroupRoleDatablockReactView.update_forward_refs()
SheetDto.update_forward_refs()
SheetPovChildrenDto.update_forward_refs()
CubeAccessCtrlDto.update_forward_refs()
HeaderObject.update_forward_refs()
RoleSetDataBlock.update_forward_refs()
