"""
Models used by /consolidation-process-server1-0

generated by model_code_gen.py
  - **filename** : ``consolidation_process.py``
  - **json timestamp** : ``2023-10-31 17:10:18``
"""

from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field

__all__ = [
    'ApprovalSubmitVO',
    'ApprovalValidateVO',
    'ConsolActionVO',
    'ConsolProcessElement',
    'ElementDetail',
    'InitData',
    'UnitDataVO',
    'UnitParamDTO',
    'ConsolActionParam',
    'ApprovalSubmitRequest',
    'ConsolUnitInitRequest',
    'ConsolUnitInitVO',
    'ConsolUnitQueryRequest'
]


class ApprovalSubmitVO(BaseModel):
    """Approval Submit VO

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/approval/action`` (Response: 200)
    """
    #: notification
    notification: Optional[Any]


class ApprovalValidateVO(BaseModel):
    """Approval Validate VO

    .. admonition:: 引用接口

        - **GET** ``/apis/v1/space/{space}/app/{app}/use/approval/validation/get`` (Response: 200)
    """
    #: 字段名
    config: Optional[Any]
    #: 表格数据
    data: Optional[List[Any]]
    #: 维度成员描述
    description: Optional[Any]


class ConsolActionVO(BaseModel):
    #: 是否有权限触发
    _allow: bool
    #: 是否已开启
    _opened: bool
    #: 动作编码
    actionCode: str
    #: 动作名称
    actionName: str


class ConsolProcessElement(BaseModel):
    #: 元素名称
    elementName: str
    #: 目录id
    folderId: Optional[str]
    #: 组件id
    path: Optional[str]


class ElementDetail(BaseModel):
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 目录id
    folderId: Optional[str]
    #: 组件id
    path: Optional[str]
    #: 服务器地址
    serverName: Optional[str]


class InitData(BaseModel):
    #: 单元实体
    entity: Optional[str]
    #: 初始化操作
    initOperate: Optional[str]
    #: 单元实体父级
    parent: Optional[str]
    #: 单元月份
    period: Optional[str]
    #: 单元场景
    scenario: Optional[str]
    #: 单元主键
    unitId: Optional[str]
    #: 单元版本
    version: Optional[str]
    #: 单元年份
    year: Optional[str]


class UnitDataVO(BaseModel):
    """Unit Data VO

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/unit/get`` (Response: 200)
    """
    #: 查询权限
    _allow_read: bool
    #: 是否已开启
    _opened: bool
    #: 是否base节点
    base: Optional[bool]
    #: 计算/合并的业务状态
    calculationStatus: str
    #: 合并动作操作
    consolActions: List[ConsolActionVO]
    #: 对父贡献的业务状态
    contributionStatus: Optional[str]
    #: 成员描述，当前语言
    description: Optional[str]
    #: 父点子，相当于主键
    expectedName: str
    #: 作业状态
    jobStatus: str
    #: 维度成员编码
    name: str
    #: 父成员编码
    parentName: Optional[str]
    #: 期间维
    period: str
    #: 审批阶段
    phases: Optional[Any]
    #: 场景维
    scenario: str
    #: 对父折算的业务状态
    translationStatus: Optional[str]
    #: 单元表主键
    unitId: str
    #: 版本维
    version: str
    #: 年份维
    year: str


class UnitParamDTO(BaseModel):
    #: 实体维
    entity: Optional[str]
    #: 期间维
    period: str
    #: 场景维
    scenario: str
    #: 版本维
    version: str
    #: 年份维
    year: str


class ConsolActionParam(BaseModel):
    """合并动作入参

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/calculation/actions``
    """
    #: 动作编码
    actionCode: str
    #: 是否叶子节点
    base: bool
    #: 合并流程元素
    element: ConsolProcessElement
    #: 多版本实体维父
    parent: str
    #: unit_id
    unitId: str


class ApprovalSubmitRequest(BaseModel):
    """Approval Submit Request

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/approval/action``
    """
    #: 动作编码
    actionCode: str
    #: 备注
    comment: Optional[str]
    #: 合并流程元素
    elementDetail: ElementDetail
    #: 审批阶段
    phase: str
    #: 单元
    unitId: str


class ConsolUnitInitRequest(BaseModel):
    """Consol Unit Init Request

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/unit/actions/init``
    """
    #: 合并流程元素名
    elementName: str
    #: 元素所在目录编码
    folderId: Optional[str]
    #: 初始化参数
    params: UnitParamDTO
    #: 元素所在目录
    path: Optional[str]


class ConsolUnitInitVO(BaseModel):
    """Consol Unit Init VO

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/unit/actions/init`` (Response: 200)
    """
    #: 本次初始化数据
    initData: List[InitData]
    #: 是否成功
    success: bool


class ConsolUnitQueryRequest(BaseModel):
    """Consol Unit Query Request

    .. admonition:: 引用接口

        - **POST** ``/apis/v1/space/{space}/app/{app}/use/unit/get``
    """
    #: 合并流程元素名
    elementName: str
    #: 元素所在目录编码
    folderId: Optional[str]
    #: 查询参数
    params: UnitParamDTO
    #: 元素所在目录
    path: Optional[str]
