"""
Models used by /gateway-server,/consolidation-server1-0

generated by model_code_gen.py
  - **filename** : ``consolidation.py``
  - **json timestamp** : ``2022-01-07 10:49:10``
"""


from .base import BaseModel
from typing import List, Optional, Union
from pydantic import Field


__all__ = [
    'CubeAccessControlStatusDTO',
    'CustomAccount',
    'ErrorDTO',
    'GroupRoleBaseInfoDTO',
    'RoleBaseInfoDTO',
    'ElementBaseInfo',
    'MatchAccountJournalTemplateType',
    'ConsolidationMemModel',
    'ScriptConfigure',
    'JournalTemplateConfigure',
    'RateConfigure',
    'AccountProcessing',
    'AccountTradeType',
    'DimensionMatchAccountInfo',
    'EquityInvestRelation',
    'ConConditionDimDTO',
    'ConLogParamsDTO',
    'CubeAccessControlDTO',
    'CubeDimensionDTO',
    'ElementInfoByProcotolDTO',
    'EntityRelationParamsDTO',
    'TradeTypeJTInfo',
    'MemFinModelDto',
    'MatchAccountInfo',
    'MatchAccountProcessType',
    'ConsolidationRelDim',
    'ConsolidationReqParam',
    'ExchangeConfigure',
    'EquityRelation',
    'ConsolidationStructure',
    'EquityLawParam'
]


class CubeAccessControlStatusDTO(BaseModel):
    #: 状态描述
    desc: Optional[dict]
    #: 状态
    value: Optional[str]


class CustomAccount(BaseModel):
    #: name
    name: Optional[str]
    #: udValue
    udValue: Optional[str]


class ErrorDTO(BaseModel):
    #: 异常key
    tipKey: Optional[str]
    #: 异常信息
    tipValue: Optional[str]


class GroupRoleBaseInfoDTO(BaseModel):
    #: 角色组描述
    description: Optional[dict]
    #: description1
    description1: Optional[str]
    #: description2
    description2: Optional[str]
    #: 是否为空
    empty: Optional[bool]
    #: 角色组说明
    instruction: Optional[dict]
    #: instruction1
    instruction1: Optional[str]
    #: instruction2
    instruction2: Optional[str]
    #: 角色组名称
    name: Optional[str]


class RoleBaseInfoDTO(BaseModel):
    #: 默认角色组名称
    defaultRolegroupName: Optional[str]
    #: 角色描述
    description: Optional[dict]
    #: description1
    description1: Optional[str]
    #: description2
    description2: Optional[str]
    #: 是否为空
    empty: Optional[bool]
    #: 角色说明
    instruction: Optional[dict]
    #: instruction1
    instruction1: Optional[str]
    #: instruction2
    instruction2: Optional[str]
    #: 角色名称
    name: Optional[str]


class ElementBaseInfo(BaseModel):
    """元素基础参数信息

    .. admonition:: 引用接口

        - **POST** ``/check-relation-element``
        - **POST** ``/consolidation/exchange-rate-account-code``
        - **POST** ``/consolidation/journal-model-column-name``
        - **POST** ``/consolidation/query-match-account``
        - **POST** ``/consolidation/view/query-con-dim-params``
    """
    #: 多语言描述
    description: Optional[dict]
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: 组件id
    moduleId: Optional[str]
    #: 绝对路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class MatchAccountJournalTemplateType(BaseModel):
    #: 匹配科目对应的日记账模板基础参数
    matchJournalBaseMap: Optional[dict]
    #: 匹配科目对应的日记账模板
    matchJournalTemplate: Optional[dict]


class ConsolidationMemModel(BaseModel):
    """合并内存财务模型

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/generate-merge-node-value``
        - **POST** ``/consolidation/view/generate-total-value``
    """
    #: 合并内存财务模型编码
    cubeCode: Optional[str]
    #: 合并内存财务模型文件夹ID
    cubeFolderId: Optional[str]
    #: 参数
    params: Optional[dict]
    #: 合并内存财务模型服务名
    serverName: Optional[str]


class ScriptConfigure(BaseModel):
    #: 执行模式，0：增强，1：替换
    executionMode: Optional[int]
    #: 后置脚本
    postscript: Optional[ElementBaseInfo]
    #: 后置脚本key
    postscriptKey: Optional[str]
    #: 前置脚本
    prescript: Optional[ElementBaseInfo]
    #: 前置脚本key
    prescriptKey: Optional[str]
    #: 替换脚本
    replaceScript: Optional[ElementBaseInfo]
    #: 后置脚本key
    replaceScriptKey: Optional[str]


class JournalTemplateConfigure(BaseModel):
    """日记账列参数信息

    .. admonition:: 引用接口

        - **POST** ``/consolidation/journal-model-column-name`` (Response: 200)
    """
    #: 列名
    columnName: str
    #: 列描述
    desc: Optional[dict]


class RateConfigure(BaseModel):
    #: 汇率科目
    accountCode: Optional[str]
    #: 科目类型
    accountType: Optional[str]
    #: 汇率科目多语言
    multilingual: Optional[dict]
    #: 自定义编码
    udKey: Optional[str]


class AccountProcessing(BaseModel):
    #: 加工类型多语言
    description: Optional[dict]
    #: 成员编码
    memberCode: Optional[str]
    #: 科目成员多语言
    multilingual: Optional[dict]
    #: 加工类型编码
    tradeCode: Optional[str]


class AccountTradeType(BaseModel):
    #: 匹配科目科目类型
    accountType: Optional[str]
    #: 交易属性编码
    eliCode: str
    #: 交易属性多语言描述
    eliDesc: Optional[dict]
    #: 交易属性自定义编码
    eliKey: Optional[str]
    #: 匹配科目自定义编码
    matKey: Optional[str]
    #: 匹配科目编码
    matchCode: str
    #: 匹配科目多语言描述
    matchDesc: Optional[dict]
    #: 成员编码
    memberCode: str
    #: 成员多语言描述
    memberDesc: Optional[dict]
    #: 科目成员本身类型
    memberType: Optional[str]


class DimensionMatchAccountInfo(BaseModel):
    #: 成员编码
    code: str
    #: 多语言描述
    description: Optional[dict]
    #: 自定义编码
    udKey: Optional[str]


class EquityInvestRelation(BaseModel):
    #: account
    account: Optional[str]
    #: increaseRatio
    increaseRatio: Optional[float]
    #: 真实投资期间-购买期间
    investPeriod: Optional[str]
    #: 真实投资年-购买年
    investYear: Optional[str]
    #: 被投资公司
    investee: Optional[str]
    #: 投资公司(末级公司)
    investor: Optional[str]
    #: 期间
    period: Optional[str]
    #: 场景
    scenario: Optional[str]
    #: 年度
    year: Optional[str]


class ConConditionDimDTO(BaseModel):
    """Con Condition Dim DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/entity-offset-range-params``
    """
    #: 维度成员编码
    code: Optional[str]
    #: 维度信息
    dimElement: Optional[ElementBaseInfo]
    #: 维度作用
    dimensionUsage: Optional[int]
    #: 维度成员值
    value: Optional[dict]


class ConLogParamsDTO(BaseModel):
    """Con Log Params DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/con-log-info``
        - **POST** ``/consolidation/view/equity-investment-offset``
        - **POST** ``/consolidation/view/fixed-asset-purchase-offset``
        - **POST** ``/consolidation/view/internal-inventory-offset``
        - **POST** ``/consolidation/view/reduction-offset``
        - **POST** ``/consolidation/view/universal-offset``
    """
    #: 合并算法基础参数
    element: Optional[ElementBaseInfo]
    #: 是否是合并实体
    mergeEntity: Optional[bool]
    #: 条件参数
    params: Optional[List[ConConditionDimDTO]]


class CubeAccessControlDTO(BaseModel):
    #: 访问权
    accessRight: Optional[int]
    #: 角色组
    groupRoleList: Optional[List[GroupRoleBaseInfoDTO]]
    #: id
    id: Optional[int]
    #: 角色
    roleList: Optional[List[RoleBaseInfoDTO]]
    #: cube读写控制状态
    statusList: Optional[List[CubeAccessControlStatusDTO]]


class CubeDimensionDTO(BaseModel):
    #: 科目成员脚本
    accountMemberScript: Optional[str]
    #: 列类型,0:什么也没有，1：维度，2：度量
    columnType: int
    #: 审批单元标记
    datablockSeg: Optional[bool]
    #: 审批单元编号
    datablockSegNo: Optional[int]
    #: 字段名
    datatableColumn: str
    #: 维度描述
    dimensionDescription: Optional[str]
    #: 字段关联的维度所在文件夹Id
    dimensionFolderId: str
    #: 字段关联的维度的moudelId
    dimensionMoudelId: Optional[str]
    #: 字段关联维度名称
    dimensionName: str
    #: 字段关联的维度的路径
    dimensionPath: Optional[str]
    #: 维度服务名称
    dimensionServerName: Optional[str]
    #: 字段关联维度类型
    dimensionType: str
    #: 列作用
    dimensionUsage: int
    #: 异常信息
    errorList: Optional[List[ErrorDTO]]
    #: 是否关联时间维度字段
    isDate: Optional[bool]
    #: 关联的维度是否为新维度
    isNewDimension: bool
    #: 关联数据表字段是否丢失
    lossCol: Optional[bool]
    #: 度量类型,1data2text
    measureType: Optional[int]
    #: 多语言
    multilingual: Optional[dict]
    #: 流程控制字段成员
    processMember: Optional[str]
    #: 流程控制字段标记
    processSeg: Optional[bool]
    #: 流程控制字段编号
    processSegNo: Optional[int]
    #: 是否用做权限字段(仅维度类型的允许用做权限字段)
    roleSeg: Optional[bool]
    #: 角色映射
    rsMapping: Optional[int]


class ElementInfoByProcotolDTO(BaseModel):
    """Element Info By Procotol DTO

    .. admonition:: 引用接口

        - **GET** ``/consolidation/query-active-entity-datatable`` (Response: 200)
        - **GET** ``/consolidation/query-cube-params`` (Response: 200)
    """
    #: 关联维度信息
    dimElementInfo: Optional[ElementBaseInfo]
    #: 当前语种元素描述
    elementNameDes: Optional[str]
    #: 所有语种元素描述
    elementNameDesAll: Optional[str]
    #: 状态
    elementTypeChild: Optional[str]
    #: 文件夹id/组件id
    id: Optional[str]
    #: 服务版本
    moduleVersion: Optional[str]
    #: 多语言
    multilingual: Optional[dict]
    #: 名称
    name: Optional[str]
    #: 父级id
    parentId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]
    #: 类型
    type: Optional[str]


class EntityRelationParamsDTO(BaseModel):
    """Entity Relation Params DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/entity-offset-range-params`` (Response: 200)
    """
    #: 实体基础信息
    element: Optional[ElementBaseInfo]
    #: 激活实体
    entityCode: Optional[List[str]]
    #: 实体关联
    entityRelation: Optional[List[List]]
    #: 实体末级公司内部关联
    lastStageEntityRelation: Optional[List[str]]
    #: 非激活实体
    noActiveEntityCode: Optional[List[str]]
    #: 合并节点末级不关联
    noEntityRelation: Optional[List[str]]
    #: 合并实体父节点与子节点
    parentParamMap: Optional[dict]
    #: 合并实体父节点与子节点-共享节点
    sharedParamMap: Optional[dict]


class TradeTypeJTInfo(BaseModel):
    #: 列名集合
    columnList: Optional[List[JournalTemplateConfigure]]
    #: 分组列名
    columnName: str
    #: 日记账模板
    journalModel: ElementBaseInfo
    #: 值列名
    valueColumnName: str


class MemFinModelDto(BaseModel):
    #: 自动进行档期数和累计数的汇总计算，false：关；true：开；
    autoCalculation: Optional[bool]
    #: 资产负债类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    balanceAccountSave: Optional[int]
    #: 内存财务数据模型编码
    code: str
    #: 读写权限
    cubeAccessControlReactList: Optional[List[CubeAccessControlDTO]]
    #: 内存财务数据模型关联列信息
    cubeDimensionList: Optional[List[CubeDimensionDTO]]
    #: cube类型,4：期间作为度量；5：不作为度量
    cubeType: int
    #: 数据表类型，0:mysql，1:clickhouse
    dataSync: Optional[int]
    #: 数据表元素类型
    datatableElementType: Optional[str]
    #: 关联的数据表所在文件夹Id
    datatableFolderId: Optional[str]
    #: 关联的数据表的ModuleId
    datatableModuleId: Optional[str]
    #: 内存财务数据模型关联数据表名称
    datatableName: Optional[str]
    #: 关联数据表的路径
    datatablePath: Optional[str]
    #: 多语言信息
    description: Optional[dict]
    #: 关联维度的所在的文件夹Id
    dimensionFolderId: Optional[str]
    #: 关联期间维度的moduleId
    dimensionModuleId: Optional[str]
    #: 关联期间维度的编码
    dimensionName: Optional[str]
    #: 关联维度的路径
    dimensionPath: Optional[str]
    #: dimensionRelKey
    dimensionRelKey: Optional[str]
    #: 关联维度的服务名
    dimensionServerName: Optional[str]
    #: 关联期间维度的Type
    dimensionType: Optional[str]
    #: 内存财务数据模型类型
    elementType: Optional[str]
    #: 是否启用流程控制
    enableProcessControl: Optional[bool]
    #: 损益类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    flowAccountSave: Optional[int]
    #: 内存财务数据模型所在文件夹Id
    folderId: str
    #: 内存财务数据模型id
    id: Optional[str]
    #: 多语言信息关联主键
    languageKey: Optional[str]
    #: 期间作为度量,最小期间层级,cubeType为4时,使用该属性
    minPeriodLevel: Optional[str]
    #: 内存财务数据模型moduleId
    moduleId: Optional[str]
    #: 内存财务数据模型路径
    path: Optional[str]
    #: 权限字段
    permission: Optional[int]
    #: 内存财务模型关联流程控制信息
    processControlInfo: Optional[ElementBaseInfo]
    #: 审批流关联角色方案信息
    processRelRoleInfo: Optional[ElementBaseInfo]
    #: 内存财务模型关联角色方案信息
    roleSchemeInfo: Optional[ElementBaseInfo]
    #: 流程控制字段信息
    rsPcsColumnInfo: Optional[List[CubeDimensionDTO]]
    #: 内存财务数据模型服务名
    serverName: Optional[str]


class MatchAccountInfo(BaseModel):
    """匹配科目信息

    .. admonition:: 引用接口

        - **POST** ``/consolidation/query-match-account`` (Response: 200)
    """
    #: 匹配科目成员信息
    dimensionSearchMember: List[DimensionMatchAccountInfo]
    #: 关联维度信息
    relationDimensionInfo: Optional[ElementBaseInfo]
    #: 字段类型
    valueType: Optional[int]


class MatchAccountProcessType(BaseModel):
    """匹配科目关联的科目成员，加工类型

    .. admonition:: 引用接口

        - **POST** ``/consolidation/query-account-member-trade-type``
        - **POST** ``/consolidation/query-account-member-trade-type`` (Response: 200)
    """
    #: 匹配科目信息
    matchAccountParam: Optional[DimensionMatchAccountInfo]
    #: 匹配科目关联的科目成员，加工类型
    matchAccountRelationParamList: Optional[List[AccountProcessing]]
    #: 关联维度信息
    relationDimensionInfo: Optional[ElementBaseInfo]
    #: 字段类型
    valueType: int


class ConsolidationRelDim(BaseModel):
    """合并算法关联维度成员相关参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/query-con-dim-params`` (Response: 200)
    """
    #: 科目维度信息
    element: Optional[ElementBaseInfo]
    #: 关联的成员，匹配科目，交易属性信息
    params: Optional[List[AccountTradeType]]


class ConsolidationReqParam(BaseModel):
    """合并请求参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/consolidation``
    """
    #: 合并算法组件编码
    conCode: str
    #: 合并算法组件文件夹ID
    conFolderId: str
    #: 是否强制合并
    isForceConsolidation: bool
    #: 合并参数
    params: Optional[List[ConConditionDimDTO]]
    #: 合并算法组件路径
    path: Optional[str]
    #: 合并算法组件服务名
    serverName: Optional[str]


class ExchangeConfigure(BaseModel):
    #: 外币折算方式，0：乘法；1：除法
    convertedType: int
    #: 科目类型，汇率科目信息
    exchangeRateList: Optional[List[RateConfigure]]


class EquityRelation(BaseModel):
    #: 投资公司在合并公司下的股权投资关系(已过滤非激活实体）
    equityInvestmentRelations: Optional[List[EquityInvestRelation]]
    #: 投资公司(末级公司)
    investor: Optional[ConConditionDimDTO]


class ConsolidationStructure(BaseModel):
    """合并算法结构信息

    .. admonition:: 引用接口

        - **GET** ``/consolidation/query-consolidation-info`` (Response: 200)
        - **POST** ``/consolidation/save-or-edit-consolidation``
        - **POST** ``/consolidation/save-or-edit-consolidation`` (Response: 200)
    """
    #: 调整日记账模板
    adjustJournalModel: Optional[TradeTypeJTInfo]
    #: 计算脚本
    calculateScript: Optional[ScriptConfigure]
    #: 编码
    code: str
    #: 日志实际表名
    conLogActualTableName: Optional[str]
    #: 日志表信息
    conLogTable: Optional[ElementBaseInfo]
    #: 状态实际表名
    conStatusActualTableName: Optional[str]
    #: 状态表信息
    conStatusTable: Optional[ElementBaseInfo]
    #: 汇率配置信息
    convertedConfigInfo: Optional[ExchangeConfigure]
    #: 类型
    elementType: str
    #: 股权信息内存财务模型
    equityInfoCube: ElementBaseInfo
    #: 股权信息内存财务模型科目维度信息
    equityInfoCubeAccountDim: ElementBaseInfo
    #: 汇率内存财务模型
    exchangeRateCube: ElementBaseInfo
    #: 汇率内存财务模型科目维度信息
    exchangeRateCubeAccountDim: ElementBaseInfo
    #: 文件夹id
    folderId: str
    #: id
    id: Optional[str]
    #: 匹配科目
    matchAccountParam: MatchAccountInfo
    #: 合并内存财务模型
    mergerCube: ElementBaseInfo
    #: 合并内存财务模型科目维度信息
    mergerCubeAccountDim: ElementBaseInfo
    #: 组件id
    moduleId: Optional[str]
    #: 多语言
    multilingual: Optional[dict]
    #: 抵消日记账模板
    offsetJournalModel: Optional[TradeTypeJTInfo]
    #: 抵消脚本
    offsetScript: Optional[ScriptConfigure]
    #: 路径
    path: Optional[str]
    #: 关联交易内存财务模型
    relationTradeCube: ElementBaseInfo
    #: 关联交易内存财务模型科目维度信息
    relationTradeCubeAccountDim: ElementBaseInfo
    #: 服务名
    serverName: Optional[str]
    #: 激活实体表
    stateEntityTableInfo: Optional[ElementBaseInfo]


class EquityLawParam(BaseModel):
    """权益法调整参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/equity-adjust``
    """
    #: 激活实体表元素信息
    activeEntityTable: Optional[ElementBaseInfo]
    #: 分组列名
    adjustColumnName: str
    #: 权益法，匹配科目对应日记账信息
    adjustTemplateParam: Optional[MatchAccountJournalTemplateType]
    #: 校验科目
    checkAccountList: Optional[List[CustomAccount]]
    #: 交易类型、匹配科目、科目成员的对应关系
    conRelationDimParam: Optional[ConsolidationRelDim]
    #: 合并内存财务模型结构信息
    consolidationCube: Optional[MemFinModelDto]
    #: 选择的合并实体
    consolidationEntity: Optional[dict]
    #: 实体成员信息
    dimMemberMap: Optional[dict]
    #: 实体
    entity: Optional[ConConditionDimDTO]
    #: 股权信息内存模型
    equityInformationCube: Optional[MemFinModelDto]
    #: 投资公司(末级公司)的股权关系
    equityInvestments: Optional[List[EquityRelation]]
    #: 汇率信息内存模型
    exchangeRateCube: Optional[MemFinModelDto]
    #: 未激活实体
    noActiveEntityMap: Optional[dict]
    #: 分组列名
    offsetColumnName: str
    #: 抵消算法，匹配科目对应日记账信息
    offsetTemplateParam: Optional[MatchAccountJournalTemplateType]
    #: 期间
    period: Optional[ConConditionDimDTO]
    #: 关联交易内存财务模型结构信息
    relatedTransactionCube: Optional[MemFinModelDto]
    #: 场景
    scenario: Optional[ConConditionDimDTO]
    #: 值维度
    value: Optional[ConConditionDimDTO]
    #: 值维度字段
    valueColumnName: str
    #: 版本
    version: Optional[ConConditionDimDTO]
    #: 年度
    year: Optional[ConConditionDimDTO]



