"""
Models used by /business-model-server1-0

generated by model_code_gen.py
  - **filename** : ``business_model.py``
  - **json timestamp** : ``2022-07-26 13:51:23``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'ApprovalButton',
    'BusinessModelApproveDTO',
    'BusinessModelApproveListDTO',
    'ElementDetailDTO',
    'OperateRecordResponseVO',
    'PartitionDTO',
    'PermissionDataDTO',
    'PermissionPartitionDTO',
    'PermissionSaveDTO',
    'RoleColumnDTO',
    'SegmentDTO',
    'StatusColumnDTO',
    'StructureAssociationDTO',
    'StructureRedundantDTO',
    'UserDetailDTO',
    'ApprovalRecordVo',
    'AuthorityPartitionDTO',
    'CustomOperationDTO',
    'AuthorityDTO',
    'PermissionDTO',
    'BusinessModelDTO',
    'BusinessModelDTORes',
    'BusinessModelResultVO',
    'DataTableColumnDTO',
    'LogicTableColumnDTO',
    'LogicTableColumnDTOReq',
    'LogicTableColumnDTORes',
    'DataTableInfoDTO',
    'StructureDTO',
    'StructureDTOReq',
    'StructureDTORes'
]


class ApprovalButton(BaseModel):
    #: 按钮描述
    description: Optional[str]
    #: 按钮id
    id: Optional[str]
    #: 是否提交操作
    isSubmit: Optional[bool]
    #: 按钮name
    name: Optional[str]


class BusinessModelApproveDTO(BaseModel):
    """Business Model Approve DTO

    .. admonition:: 引用接口

        - **POST** ``/business/model/approval-operation``
    """
    #: 业务模型对应文件夹id
    businessModelFolderId: str
    #: 业务模型名称
    businessModelName: str
    #: 业务模型对应文件夹
    businessModelPath: Optional[str]
    #: 业务模型主表主键
    mainModelPrimaryKey: Any
    #: 操作对应源状态
    originStatus: str
    #: 分区id
    partitionId: str
    #: 审批操作主键（为每个审批流对应子模型的主键）
    primaryKeyValue: Any
    #: 审批操作id
    processOperationId: str
    #: 备注信息
    remark: Optional[str]


class BusinessModelApproveListDTO(BaseModel):
    """Business Model Approve List DTO

    .. admonition:: 引用接口

        - **POST** ``/business/model/approval-records``
    """
    #: 业务模型对应文件夹id
    businessModelFolderId: str
    #: 业务模型名称
    businessModelName: str
    #: 业务模型对应文件夹
    businessModelPath: Optional[str]
    #: 业务模型主表主键
    mainModelPrimaryKey: Any
    #: 分区id
    partitionId: str
    #: 审批操作主键（为每个审批流对应子模型的主键）
    primaryKeyValue: Any


class ElementDetailDTO(BaseModel):
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 目录id
    folderId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class OperateRecordResponseVO(BaseModel):
    """Operate Record Response VO

    .. admonition:: 引用接口

        - **POST** ``/business/model/approval-operation`` (Response: 200)
    """
    #: 错误信息，具体信息使用方自己决定
    errors: Optional[List[Any]]
    #: 成功失败标识
    success: Optional[bool]
    #: 警告信息，具体信息使用方自己决定
    warnings: Optional[List[Any]]


class PartitionDTO(BaseModel):
    """Partition DTO

    .. admonition:: 引用接口

        - **GET** ``/business/model/form/partitions`` (Response: 200)
    """
    #: 子模型描述
    description: Optional[Any]
    #: 子模型描述1
    description1: Optional[str]
    #: 子模型描述2
    description2: Optional[str]
    #: 子模型描述3
    description3: Optional[str]
    #: 子模型描述4
    description4: Optional[str]
    #: 子模型描述5
    description5: Optional[str]
    #: 子模型描述6
    description6: Optional[str]
    #: 子模型描述7
    description7: Optional[str]
    #: 子模型描述8
    description8: Optional[str]
    #: 子模型成员(成员唯一id)
    members: Optional[List[str]]
    #: 子模型id
    partitionId: Optional[str]
    #: 子模型名称
    partitionName: str
    #: 排序
    sort: Optional[int]
    #: 子模型主表在模型中唯一id
    uuid: Optional[str]


class PermissionDataDTO(BaseModel):
    #: add
    add: Optional[List[Any]]
    #: delete
    delete: Optional[List[str]]
    #: pageNum
    pageNum: Optional[int]
    #: pageSize
    pageSize: Optional[int]
    #: roleStrategyId
    roleStrategyId: Optional[str]
    #: update
    update: Optional[List[Any]]


class PermissionPartitionDTO(BaseModel):
    #: 字段权限配置
    data: Optional[PermissionDataDTO]
    #: 操作权限配置
    operateData: Optional[PermissionDataDTO]
    #: 主/子模型编码
    partitionId: Optional[str]
    #: roleStatus
    roleStatus: Optional[str]
    #: statusSort
    statusSort: Optional[Any]
    #: type
    type: Optional[str]
    #: 权限控制单元权限配置
    unitData: Optional[PermissionDataDTO]


class PermissionSaveDTO(BaseModel):
    #: 业务模型名称
    businessName: Optional[str]
    #: 业务模型路径
    folderId: Optional[str]
    #: 主模型/子模型权限数据
    partitions: Optional[List[PermissionPartitionDTO]]


class RoleColumnDTO(BaseModel):
    #: 字段名
    columnName: Optional[str]
    #: 字段所属的数据表名
    dataTableName: Optional[str]
    #: 是否已选择作为角色字段
    isRoleColumn: Optional[int]
    #: 权限方案关联的维度名
    rsDimension: Optional[str]
    #: 关联权限方案的元素信息
    rsDimensionElementDetail: Optional[ElementDetailDTO]
    #: 权限方案关联的维度序号
    rsMapping: Optional[int]
    #: 字段的排序
    sort: Optional[int]
    #: 数据表所属的目录id
    tableFolderId: Optional[str]
    #: 数据表在当前模型的唯一编码
    uuid: Optional[str]


class SegmentDTO(BaseModel):
    #: 权限控制单元
    accessControlUnit: Optional[str]
    #: 是否启用权限控制
    enableAccessControl: Optional[bool]
    #: 是否逻辑主键
    isLogicKey: Optional[bool]
    #: 字段名
    seg: Optional[str]
    #: 是否提交必填
    submitRequired: Optional[bool]
    #: 字段类型(逻辑类型)
    valueType: Optional[int]


class StatusColumnDTO(BaseModel):
    #: 字段名
    columnName: Optional[str]
    #: 字段所属的数据表名
    dataTableName: Optional[str]
    #: 关联审批流或值列表的元素信息
    elementDetail: Optional[ElementDetailDTO]
    #: 是否已选择作为状态字段
    isStatusColumn: Optional[int]
    #: 字段关联的审批流描述
    pcDesc: Optional[str]
    #: 字段关联的审批流目录id
    pcFolderId: Optional[str]
    #: 字段关联的审批流名称
    pcName: Optional[str]
    #: 字段关联的值列表名称
    smartListName: Optional[str]
    #: 字段的排序
    sort: Optional[int]
    #: 字段所属的数据表目录id
    tableFolderId: Optional[str]
    #: 数据表在当前模型的唯一编码
    uuid: Optional[str]


class StructureAssociationDTO(BaseModel):
    #: 当前级表的字段名
    logicTableFk: Optional[str]
    #: 当前表的字段描述
    logicTableFkDes: Optional[str]
    #: 父级表的字段名
    parentPk: Optional[str]
    #: 父级表的字段描述
    parentPkDes: Optional[str]


class StructureRedundantDTO(BaseModel):
    #: 父级表的字段名
    parentSeg: Optional[str]
    #: 父级表的字段描述
    parentSegDes: Optional[str]
    #: 当前表的字段名
    seg: Optional[str]
    #: 当前表的字段描述
    segDes: Optional[str]


class UserDetailDTO(BaseModel):
    #: 是否管理员标识
    adminTag: Optional[str]
    #: 头像
    avatar: Optional[str]
    #: 邮箱
    email: Optional[str]
    #: 手机号
    mobilePhone: Optional[str]
    #: 昵称
    nickName: Optional[str]
    #: 状态
    status: Optional[str]
    #: 用户id
    userId: Optional[str]
    #: 用户名
    userName: Optional[str]


class ApprovalRecordVo(BaseModel):
    """Approval Record Vo

    .. admonition:: 引用接口

        - **POST** ``/business/model/approval-records`` (Response: 200)
    """
    #: 按钮
    buttons: List[ApprovalButton]
    #: 控制字段必填
    isSubmit: Optional[bool]
    #: 行号
    line_no: int
    #: 操作时间
    operate_time: str
    #: 操作人
    operate_user: str
    #: 审批备注
    pc_remark: str
    #: 业务主键字段(key为业务主键的key,value为业务主键对应的值)
    primaryKeyValue: Any
    #: 审批操作描述
    process_operation_des: str
    #: 审批操作id
    process_operation_id: str
    #: 随机码
    random_code: str
    #: 审批后的状态
    result_status: str
    #: 审批后的状态描述
    result_status_des: str
    #: 用户信息,用户不存在为null
    user_detail: Optional[UserDetailDTO]


class AuthorityPartitionDTO(BaseModel):
    #: enableAccessUnit
    enableAccessUnit: Optional[bool]
    #: partitionDesc
    partitionDesc: Optional[str]
    #: partitionId
    partitionId: Optional[str]
    #: partitionName
    partitionName: Optional[str]
    #: statusInfo
    statusInfo: Optional[List[StatusColumnDTO]]


class CustomOperationDTO(BaseModel):
    #: 同步异步 0/1
    async_: int = Field(None, alias='async')
    #: PYTHON元素信息
    elementDetail: Optional[ElementDetailDTO]
    #: PYTHON元素名称
    name: Optional[str]
    #: 排序
    sort: Optional[int]
    #: 请求类型URL/PY
    type: str
    #: URL请求地址
    url: Optional[str]


class AuthorityDTO(BaseModel):
    """Authority DTO

    .. admonition:: 引用接口

        - **GET** ``/business/model/permission`` (Response: 200)
    """
    #: 业务模型目录id
    folderId: str
    #: 业务模型名称
    name: str
    #: 业务模型目录
    path: Optional[str]
    #: 角色字段信息
    roleColumn: Optional[List[RoleColumnDTO]]
    #: 角色方案元素信息
    rsElementDetail: Optional[ElementDetailDTO]
    #: 角色方案名称
    rsName: Optional[str]
    #: 状态字段信息
    statusColumn: Optional[List[AuthorityPartitionDTO]]


class PermissionDTO(BaseModel):
    """Permission DTO

    .. admonition:: 引用接口

        - **POST** ``/business/model/permission``
    """
    #: 模型分组信息
    business: Optional[AuthorityDTO]
    #: permission
    permission: Optional[PermissionSaveDTO]
    #: 权限信息
    permissions: Optional[PermissionSaveDTO]


class BusinessModelDTO(BaseModel):
    """Business Model DTO Req

    .. admonition:: 引用接口

        - **POST** ``/business/model``
    """
    #: 模型描述
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 描述3
    description3: Optional[str]
    #: 描述4
    description4: Optional[str]
    #: 描述5
    description5: Optional[str]
    #: 描述6
    description6: Optional[str]
    #: 描述7
    description7: Optional[str]
    #: 描述8
    description8: Optional[str]
    #: 所属目录id
    folderId: str
    #: 业务模型唯一编码
    id: Optional[str]
    #: 主表信息
    logicTable: 'StructureDTOReq'
    #: 组件id
    moduleId: Optional[str]
    #: 名称
    name: str
    #: 所属目录(与folderId传一个即可)
    path: Optional[str]
    #: 删除后置
    postDeleteOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 保存后置
    postSaveOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 删除前置
    preDeleteOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 保存前置
    preSaveOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 是否修复缺失的数据表
    repairDataTable: Optional[bool]
    #: 保存类型:0-保存前校验,1-保存
    saveType: Optional[int]
    #: 子模型信息
    subModels: Optional[List[PartitionDTO]]
    #: 操作类型 ADD-新增，EDIT-编辑
    type: str


class BusinessModelDTORes(BaseModel):
    #: 模型描述
    description: Optional[Any]
    #: 描述1
    description1: Optional[str]
    #: 描述2
    description2: Optional[str]
    #: 描述3
    description3: Optional[str]
    #: 描述4
    description4: Optional[str]
    #: 描述5
    description5: Optional[str]
    #: 描述6
    description6: Optional[str]
    #: 描述7
    description7: Optional[str]
    #: 描述8
    description8: Optional[str]
    #: 所属目录id
    folderId: str
    #: 业务模型唯一编码
    id: Optional[str]
    #: 主表信息
    logicTable: 'StructureDTORes'
    #: 组件id
    moduleId: Optional[str]
    #: 名称
    name: str
    #: 所属目录(与folderId传一个即可)
    path: Optional[str]
    #: 删除后置
    postDeleteOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 保存后置
    postSaveOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 删除前置
    preDeleteOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 保存前置
    preSaveOpe: Optional[List[Optional[CustomOperationDTO]]]
    #: 是否修复缺失的数据表
    repairDataTable: Optional[bool]
    #: 保存类型:0-保存前校验,1-保存
    saveType: Optional[int]
    #: 子模型信息
    subModels: Optional[List[PartitionDTO]]
    #: 操作类型 ADD-新增，EDIT-编辑
    type: str


class BusinessModelResultVO(BaseModel):
    """Business Model Result VO

    .. admonition:: 引用接口

        - **GET** ``/business/model`` (Response: 200)
        - **POST** ``/business/model`` (Response: 200)
    """
    #: 业务模型信息
    businessModel: Optional[BusinessModelDTORes]


class DataTableColumnDTO(BaseModel):
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    creator: Optional[str]
    #: 默认值
    defaultValue: Optional[str]
    #: 字段描述
    description: Optional[str]
    #: 创建时间
    lastModifyTime: Optional[str]
    #: 修改人
    lastModifyUser: Optional[str]
    #: 字段长度
    length: Optional[str]
    #: 字段名
    name: Optional[str]
    #: 更新前信息
    oldInfo: Optional['DataTableColumnDTO']
    #: 操作类型
    operation: Optional[str]
    #: 排序
    sort: Optional[int]
    #: 字段类型
    type: Optional[str]
    #: 可否为空
    whetherEmpty: Optional[bool]
    #: 是否自增
    whetherIncrement: Optional[bool]
    #: 是否唯一
    whetherOnly: Optional[bool]
    #: 是否主键
    whetherPrimary: Optional[bool]
    #: 是否系统字段
    whetherSystemColumn: Optional[bool]


class LogicTableColumnDTO(BaseModel):
    """Logic Table Column DTO

    .. admonition:: 引用接口

        - **POST** ``/business/model/form/segment/column-name`` (Response: 200)
    """
    #: 列权限信息
    authority: Optional[SegmentDTO]
    #: 数据表列信息
    baseInfo: Optional[DataTableColumnDTO]
    #: columnName
    columnName: Optional[str]
    #: 列逻辑属性
    logicInfo: Optional[Any]


class LogicTableColumnDTOReq(BaseModel):
    #: 列权限信息
    authority: Optional[SegmentDTO]
    #: 数据表列信息
    baseInfo: Optional[DataTableColumnDTO]
    #: 列逻辑属性
    logicInfo: Optional[Any]


class LogicTableColumnDTORes(BaseModel):
    #: 列权限信息
    authority: Optional[SegmentDTO]
    #: 数据表列信息
    baseInfo: Optional[DataTableColumnDTO]
    #: columnName
    columnName: Optional[str]
    #: 列逻辑属性
    logicInfo: Optional[Any]


class DataTableInfoDTO(BaseModel):
    #: 实际表名
    actualTableName: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    creator: Optional[str]
    #: 同步、异步
    dataSync: Optional[int]
    #: 多语言描述
    description: Optional[Any]
    #: 数据表描述1
    description1: Optional[str]
    #: 数据表描述2
    description2: Optional[str]
    #: 数据表描述3
    description3: Optional[str]
    #: 数据表描述4
    description4: Optional[str]
    #: 数据表描述5
    description5: Optional[str]
    #: 数据表描述6
    description6: Optional[str]
    #: 数据表描述7
    description7: Optional[str]
    #: 数据表描述8
    description8: Optional[str]
    #: 元素组件信息
    elementDetail: Optional[ElementDetailDTO]
    #: 数据表描述8
    folderId: Optional[str]
    #: 数据表id,传id为修改
    id: Optional[str]
    #: 最后修改时间
    lastModifyTime: Optional[str]
    #: 最后修改人
    lastModifyUser: Optional[str]
    #: 数据表组件id
    moduleId: Optional[str]
    #: 数据表名称
    name: str
    #: 修改前数据表信息
    oldInfo: Optional['DataTableInfoDTO']


class StructureDTO(BaseModel):
    """Structure DTO

    .. admonition:: 引用接口

        - **GET** ``/business/model/authority/partition/structure/top`` (Response: 200)
        - **GET** ``/business/model/authority/partition/structures`` (Response: 200)
        - **GET** ``/business/model/authority/partition/structures/enable-access-unit`` (Response: 200)
        - **POST** ``/business/model/form/structure/table-name`` (Response: 200)
        - **GET** ``/business/model/form/structure/top`` (Response: 200)
        - **GET** ``/business/model/form/structures`` (Response: 200)
        - **POST** ``/business/model/form/structures/column`` (Response: 200)
        - **POST** ``/business/model/form/structures/module`` (Response: 200)
    """
    #: 父子表关联关系
    associations: Optional[List[StructureAssociationDTO]]
    #: 子级表列表
    children: Optional[List['StructureDTO']]
    #: 数据表列信息
    columns: List[LogicTableColumnDTO]
    #: 与父表的数据关系
    dataRelation: Optional[str]
    #: 数据表详情
    dataTableInfo: DataTableInfoDTO
    #: 数据表名称
    dataTableName: str
    #: 数据表类型
    dataTableType: Optional[str]
    #: 数据表文件夹id
    folderId: Optional[str]
    #: 是否子模型主表
    keyTable: Optional[bool]
    #: 当前表层级
    level: int
    #: 业务主键
    logicKeyList: Optional[List[str]]
    #: 当前模型中父级表的唯一id
    parentUuid: Optional[str]
    #: 数据表路径
    path: Optional[str]
    #: 记录创建人、创建时间
    recordCreate: Optional[bool]
    #: 记录修改人、修改时间
    recordModify: Optional[bool]
    #: 冗余字段
    redundantSegList: Optional[List[StructureRedundantDTO]]
    #: 层级表关联信息
    relationField: Optional[str]
    #: 系统主键
    systemPrimaryKey: Optional[str]
    #: 唯一字段
    uniqueSegList: Optional[List[List]]
    #: 当前模型中数据表的唯一id
    uuid: str


class StructureDTOReq(BaseModel):
    #: 父子表关联关系
    associations: Optional[List[StructureAssociationDTO]]
    #: 子级表列表
    children: Optional[List['StructureDTOReq']]
    #: 数据表列信息
    columns: List[LogicTableColumnDTOReq]
    #: 与父表的数据关系
    dataRelation: Optional[str]
    #: 数据表详情
    dataTableInfo: DataTableInfoDTO
    #: 数据表名称
    dataTableName: str
    #: 数据表类型
    dataTableType: Optional[str]
    #: 数据表文件夹id
    folderId: Optional[str]
    #: 是否子模型主表
    keyTable: Optional[bool]
    #: 当前表层级
    level: int
    #: 业务主键
    logicKeyList: Optional[List[str]]
    #: 当前模型中父级表的唯一id
    parentUuid: Optional[str]
    #: 数据表路径
    path: Optional[str]
    #: 记录创建人、创建时间
    recordCreate: Optional[bool]
    #: 记录修改人、修改时间
    recordModify: Optional[bool]
    #: 冗余字段
    redundantSegList: Optional[List[StructureRedundantDTO]]
    #: 层级表关联信息
    relationField: Optional[str]
    #: 系统主键
    systemPrimaryKey: Optional[str]
    #: 唯一字段
    uniqueSegList: Optional[List[List]]
    #: 当前模型中数据表的唯一id
    uuid: str


class StructureDTORes(BaseModel):
    #: 父子表关联关系
    associations: Optional[List[StructureAssociationDTO]]
    #: 子级表列表
    children: Optional[List['StructureDTORes']]
    #: 数据表列信息
    columns: List[LogicTableColumnDTORes]
    #: 与父表的数据关系
    dataRelation: Optional[str]
    #: 数据表详情
    dataTableInfo: DataTableInfoDTO
    #: 数据表名称
    dataTableName: str
    #: 数据表类型
    dataTableType: Optional[str]
    #: 数据表文件夹id
    folderId: Optional[str]
    #: 是否子模型主表
    keyTable: Optional[bool]
    #: 当前表层级
    level: int
    #: 业务主键
    logicKeyList: Optional[List[str]]
    #: 当前模型中父级表的唯一id
    parentUuid: Optional[str]
    #: 数据表路径
    path: Optional[str]
    #: 记录创建人、创建时间
    recordCreate: Optional[bool]
    #: 记录修改人、修改时间
    recordModify: Optional[bool]
    #: 冗余字段
    redundantSegList: Optional[List[StructureRedundantDTO]]
    #: 层级表关联信息
    relationField: Optional[str]
    #: 系统主键
    systemPrimaryKey: Optional[str]
    #: 唯一字段
    uniqueSegList: Optional[List[List]]
    #: 当前模型中数据表的唯一id
    uuid: str


BusinessModelDTO.update_forward_refs()
BusinessModelDTORes.update_forward_refs()
DataTableColumnDTO.update_forward_refs()
DataTableInfoDTO.update_forward_refs()
StructureDTO.update_forward_refs()
StructureDTOReq.update_forward_refs()
StructureDTORes.update_forward_refs()
