"""
Models used by /app-server

generated by model_code_gen.py
  - **filename** : ``app.py``
  - **json timestamp** : ``2022-08-16 10:07:18``
"""


from .base import BaseModel
from typing import List, Optional, Union, Any
from pydantic import Field


__all__ = [
    'ConfirmElementInfoDto',
    'CopyElementDto',
    'CreateFolderInfoDto',
    'DelFolderElementDto',
    'ElementBaseInfoVO',
    'ElementInfo',
    'ElementInfoBaseDto',
    'ElementInfoBaseVO',
    'ElementInfoForProtocolVO',
    'ElementInfoPO',
    'ElementInfoVO',
    'ElementPermissionVO',
    'ElementRegisterStatusInfoVo',
    'ElementRegisterUsableQueryDto',
    'ElementRelationInfo',
    'ElementUpgradeInfoDto',
    'ElementVO',
    'ElementWarningDefend',
    'FolderInfoUpdateOpenExtendDto',
    'FolderInfoVO',
    'FolderListVO',
    'JsPath',
    'ModifyElementNameDto',
    'ModifyFolderInfoDto',
    'ModuleServerNameVO',
    'ModuleServerNamesVO',
    'MoveElementDto',
    'QueryElementInfoByProtocolDto',
    'QueryElementInfoByTypeDto',
    'QueryElementPermissionByTypeDto',
    'QueryModuleServerNameDto',
    'ReferencedElementBaseVO',
    'ReferencedElementVO',
    'RemoveElementInfoDto',
    'ResponseResult',
    'UpgradeInfoQuerryDto',
    'ElementUpgradeDetail',
    'RightDistributionReqBody',
    'RightDistributionRespBody',
    'ElementExistsDto',
    'ElementExistsVo',
    'CustomContentKeyTypeDto',
    'ModifyElementInfoDto',
    'ElementUpgradeInfo',
    'CreateElementInfoDto',
    'ElementFolderTree',
    'FolderInfo',
    'FolderInfoAddRelation',
    'ElementUpgradeInfoVO'
]


class ConfirmElementInfoDto(BaseModel):
    """Confirm Element Info Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/confirm-element``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id(同路径二选一，优先路径)
    folderId: Optional[str]
    #: 绝对路径(同文件夹id二选一，优先路径)
    path: Optional[str]


class CopyElementDto(BaseModel):
    """Copy Element Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/copy-element``
        - **POST** ``/element-info/copy-folders-elements``
    """
    #: 新增权限的元素id集合
    addPermissionIds: Optional[List[str]]
    #: 移动/复制带业务数据的元素id集合
    businessDataElementIds: Optional[List[str]]
    #: 覆盖权限的元素id集合
    coverPermissionIds: Optional[List[str]]
    #: 源文件夹id/组件id
    id: str
    #: 忽略权限的元素id集合
    ignorePermissionIds: Optional[List[str]]
    #: 源文件夹名称/元素名称
    name: str
    #: 源父级文件夹id
    originParentId: str
    #: 用户选择替换的元素id集合
    replaceElementIds: Optional[List[str]]
    #: 目标父级文件夹id
    targetParentId: str
    #: 源类型 ： DIR， DAT...
    type: str


class CreateFolderInfoDto(BaseModel):
    """Create Folder Info Dto

    .. admonition:: 引用接口

        - **POST** ``/folders/create-folder``
    """
    #: 应用id
    app: Optional[str]
    #: 描述
    description: Optional[str]
    #: 描述（多语言）
    descriptions: Optional[Any]
    #: 文件夹名称
    name: str
    #: 父级文件夹id
    parentId: Optional[str]
    #: 空间id
    space: Optional[str]
    #: 系统元素标识
    systemTag: Optional[bool]


class DelFolderElementDto(BaseModel):
    """Del Folder Element Dto

    .. admonition:: 引用接口

        - **POST** ``/folders/del-folder-element``
    """
    #: 文件夹id/组件id
    id: str
    #: 文件夹name/元素name
    name: str
    #: 父级文件夹id，根目录为0
    parentId: str
    #: 文件夹：DIR，元素：元素类型
    type: str


class ElementBaseInfoVO(BaseModel):
    """Element Base Info VO

    .. admonition:: 引用接口

        - **GET** ``/elements/check-element-exist/v2`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 路径
    path: Optional[str]


class ElementInfo(BaseModel):
    #: allocationPermission
    allocationPermission: Optional[bool]
    #: businessDataFlag
    businessDataFlag: Optional[bool]
    #: confirm
    confirm: Optional[bool]
    #: elError
    elError: Optional[bool]
    #: elWarning
    elWarning: Optional[int]
    #: elementName
    elementName: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: id
    id: Optional[str]
    #: moduleId
    moduleId: Optional[str]
    #: moduleVersion
    moduleVersion: Optional[str]
    #: openExtend
    openExtend: Optional[bool]
    #: openPermission
    openPermission: Optional[bool]
    #: permission
    permission: Optional[int]
    #: serverName
    serverName: Optional[str]
    #: status
    status: Optional[bool]


class ElementInfoBaseDto(BaseModel):
    """Element Info Base Dto

    .. admonition:: 引用接口

        - **POST** ``/element-relations/referenced-element``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 元素所在文件夹id 与path两者必填一个；如果elementType为DIR，folderId为改文件夹ID
    folderId: Optional[str]
    #: 元素所在文件夹路径 与id两者必填一个
    path: Optional[str]


class ElementInfoBaseVO(BaseModel):
    """Element Info Base VO

    .. admonition:: 引用接口

        - **POST** ``/elements/get-element-info-base-by-id`` (Response: 200)
    """
    #: 元素id
    elementId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ElementInfoForProtocolVO(BaseModel):
    """Element Info For Protocol VO

    .. admonition:: 引用接口

        - **POST** ``/elements/get-elements-by-protocol`` (Response: 200)
        - **POST** ``/elements/get-elements-by-protocol-list`` (Response: 200)
    """
    #: 当前语种元素描述
    elementNameDes: Optional[str]
    #: 所有语种元素描述
    elementNameDesAll: Optional[Any]
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id/组件id
    id: Optional[str]
    #: 服务版本
    moduleVersion: Optional[str]
    #: 名称
    name: Optional[str]
    #: 父级id
    parentId: Optional[str]
    #: 路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]
    #: 类型
    type: Optional[str]


class ElementInfoPO(BaseModel):
    """Element Info PO

    .. admonition:: 引用接口

        - **GET** ``/element-info/get-all-element`` (Response: 200)
    """
    #: allocationPermission
    allocationPermission: Optional[bool]
    #: app
    app: Optional[str]
    #: businessDataFlag
    businessDataFlag: Optional[bool]
    #: confirm
    confirm: Optional[bool]
    #: 创建时间
    createTime: Optional[str]
    #: 创建者
    createUser: Optional[str]
    #: elError
    elError: Optional[bool]
    #: elOsError
    elOsError: Optional[bool]
    #: elWarning
    elWarning: Optional[int]
    #: elementName
    elementName: Optional[str]
    #: elementNameDes
    elementNameDes: Optional[str]
    #: elementNameDesAll
    elementNameDesAll: Optional[Any]
    #: elementType
    elementType: Optional[str]
    #: elementTypeChild
    elementTypeChild: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: folderName
    folderName: Optional[str]
    #: fullPath
    fullPath: Optional[str]
    #: id
    id: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改者
    modifyUser: Optional[str]
    #: moduleId
    moduleId: Optional[str]
    #: moduleType
    moduleType: Optional[str]
    #: moduleVersion
    moduleVersion: Optional[str]
    #: openExtend
    openExtend: Optional[bool]
    #: openPath
    openPath: Optional[str]
    #: openPermission
    openPermission: Optional[bool]
    #: permission
    permission: Optional[int]
    #: serverName
    serverName: Optional[str]
    #: space
    space: Optional[str]
    #: status
    status: Optional[bool]
    #: systemTag
    systemTag: Optional[bool]


class ElementInfoVO(BaseModel):
    """Element Info VO

    .. admonition:: 引用接口

        - **GET** ``/elements/element-infos`` (Response: 200)
        - **POST** ``/elements/get-element-info-by-id`` (Response: 200)
        - **POST** ``/elements/get-element-info-by-type`` (Response: 200)
        - **POST** ``/elements/get-element-info-by-type/filter`` (Response: 200)
    """
    #: 创建时间
    createTime: Optional[str]
    #: 创建者
    createUser: Optional[str]
    #: 元素自定义数据内容-大数据 blob存储
    customContentBlobs: Optional[Any]
    #: 元素自定义数据内容
    customContents: Optional[Any]
    #: 元素警告标记
    elWarning: Optional[int]
    #: 元素id
    elementId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 当前语种元素描述
    elementNameDes: Optional[str]
    #: 所有语种元素描述
    elementNameDesAll: Optional[Any]
    #: 元素类型
    elementType: Optional[str]
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 修改时间
    modifyTime: Optional[str]
    #: 修改者
    modifyUser: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素实例打开路径
    openPath: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ElementPermissionVO(BaseModel):
    """Element Permission VO

    .. admonition:: 引用接口

        - **POST** ``/elements/get-element-permission-by-type`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 元素id
    id: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 权限(无权限返回null)
    permission: Optional[int]


class ElementRegisterStatusInfoVo(BaseModel):
    """Element Register Status Info Vo

    .. admonition:: 引用接口

        - **POST** ``/element-info/register/usable`` (Response: 200)
    """
    #: 元素是否存在
    elementExist: Optional[bool]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件菜单路径
    menuPath: Optional[str]
    #: 是否可用
    usable: Optional[bool]


class ElementRegisterUsableQueryDto(BaseModel):
    """Element Register Usable Query Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/register/usable``
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹Id
    folderId: Optional[str]


class ElementRelationInfo(BaseModel):
    """Element Relation Info

    .. admonition:: 引用接口

        - **GET** ``/element-relations/by-cite`` (Response: 200)
        - **GET** ``/element-relations/by-cited`` (Response: 200)
        - **GET** ``/elements/get-element-info-by-name/base-info`` (Response: 200)
    """
    #: 元素id
    elementInfoId: Optional[str]
    #: 元素名
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素路径
    path: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ElementUpgradeInfoDto(BaseModel):
    """Element Upgrade Info Dto

    .. admonition:: 引用接口

        - **POST** ``/element/element-upgrade``
    """
    #: 元素名称
    elementName: str
    #: 元素路径
    elementPath: str
    #: 元素类型：DAT......
    elementType: str
    #: 文件夹id
    folderId: str
    #: 元素id
    id: str
    #: 组件id
    moduleId: str
    #: 当前版本
    moduleVersion: str
    #: 升级版本
    upgradeVersion: str


class ElementVO(BaseModel):
    """Element VO

    .. admonition:: 引用接口

        - **POST** ``/elements/create-element`` (Response: 200)
        - **GET** ``/elements/get-menu-list`` (Response: 200)
    """
    #: 业务数据标记，true: 带业务数据，false: 不带业务数据
    businessDataFlag: Optional[bool]
    #: 确认标记
    confirm: Optional[bool]
    #: 错误标记
    elError: Optional[bool]
    #: 警告标记
    elWarning: Optional[int]
    #: 元素名称
    elementName: Optional[str]
    #: 当前语种元素描述
    elementNameDes: Optional[str]
    #: 所有语种元素描述
    elementNameDesAll: Optional[Any]
    #: 元素类型
    elementType: Optional[str]
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: id
    id: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本号
    moduleVersion: Optional[str]
    #: 元素实例打开路径
    openPath: Optional[str]
    #: 组件服务名
    serverName: Optional[str]
    #: 状态
    status: Optional[bool]


class ElementWarningDefend(BaseModel):
    """Element Warning Defend

    .. admonition:: 引用接口

        - **POST** ``/elements/update-element-warning``
    """
    #: 警告标记：0-正常；1-警告
    elWarning: Optional[int]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素所在文件夹id（和path至少传一个）
    folderId: Optional[str]
    #: 元素路径（和folderId至少传一个）
    path: Optional[str]


class FolderInfoUpdateOpenExtendDto(BaseModel):
    """Folder Info Update Open Extend Dto

    .. admonition:: 引用接口

        - **POST** ``/folders/update-open-extend``
    """
    #: 文件夹id
    folderId: str
    #: 文件夹名称
    folderName: str
    #: 继承权限标识
    openExtend: bool


class FolderInfoVO(BaseModel):
    """Folder Info VO

    .. admonition:: 引用接口

        - **GET** ``/folders/get-folder-info`` (Response: 200)
        - **GET** ``/folders/get-folders`` (Response: 200)
    """
    #: 描述
    description: Optional[str]
    #: 描述（多语言）
    descriptions: Optional[Any]
    #: 文件夹全路径
    fullPath: Optional[str]
    #: 文件夹id
    id: Optional[str]
    #: 文件夹名称
    name: Optional[str]
    #: 父级文件夹
    parentId: Optional[str]
    #: 权限值
    permission: Optional[int]


class FolderListVO(BaseModel):
    """Folder List VO

    .. admonition:: 引用接口

        - **GET** ``/element-info/list`` (Response: 200)
        - **GET** ``/element-info/list-all`` (Response: 200)
    """
    #: 是否分配过权限
    allocationPermission: Optional[bool]
    #: 业务数据标识
    businessDataFlag: Optional[bool]
    #: 创建人邮箱
    createEmail: Optional[str]
    #: 创建人手机号
    createMobilePhone: Optional[str]
    #: 创建人昵称
    createNickName: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 创建人头像url
    createUserAvatar: Optional[str]
    #: 创建人头像颜色
    createUserColor: Optional[str]
    #: 创建人名称
    createUserName: Optional[str]
    #: 元素描述
    description: Optional[str]
    #: 警告标识
    elWarning: Optional[int]
    #: 当前语种元素描述
    elementNameDes: Optional[str]
    #: 元素类型：DIR,DAT......
    elementType: Optional[str]
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 元素类型描述
    elementTypeDes: Optional[str]
    #: 组件元素类型id
    elementTypeId: Optional[str]
    #: 所在路径
    fullPath: Optional[str]
    #: 文件夹id / 元素id
    id: Optional[str]
    #: id生产类型
    idGenerateType: Optional[int]
    #: 修改人邮箱
    modifyEmail: Optional[str]
    #: 修改人手机号
    modifyMobilePhone: Optional[str]
    #: 修改人昵称
    modifyNickName: Optional[str]
    #: 更新时间
    modifyTime: Optional[str]
    #: 更新人
    modifyUser: Optional[str]
    #: 修改人头像url
    modifyUserAvatar: Optional[str]
    #: 修改人头像颜色
    modifyUserColor: Optional[str]
    #: 修改人名称
    modifyUserName: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 当前语种组件类型描述
    moduleName: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 文件夹名称 / 元素名称
    name: Optional[str]
    #: 启用继承权限标识
    openExtend: Optional[bool]
    #: 元素实例打开路径
    openPath: Optional[str]
    #: 启用公开权限标识
    openPermission: Optional[bool]
    #: 所有者id
    ownerUserId: Optional[str]
    #: 所有者名称
    ownerUserName: Optional[str]
    #: 父级id
    parentId: Optional[str]
    #: 权限值
    permission: Optional[int]
    #: 服务名
    serverName: Optional[str]
    #: 系统标识
    systemTag: Optional[bool]
    #: 是否可升级标识
    upgrade: Optional[bool]


class JsPath(BaseModel):
    #: 自定义json（大数据量）
    customContentBlobs: Optional[List[str]]
    #: 自定义json
    customContents: Optional[List[str]]


class ModifyElementNameDto(BaseModel):
    """Modify Element Name Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/modify-element-name``
    """
    #: 元素主键id
    id: str
    #: 修改后元素名称
    newElementName: str


class ModifyFolderInfoDto(BaseModel):
    """Modify Folder Info Dto

    .. admonition:: 引用接口

        - **POST** ``/folders/edit-folder``
    """
    #: 文件夹描述
    description: Optional[str]
    #: 描述（多语言）
    descriptions: Optional[Any]
    #: 文件夹id
    id: str
    #: 文件夹名称
    name: str
    #: 父级文件夹id
    parentId: Optional[str]


class ModuleServerNameVO(BaseModel):
    """Module Server Name VO

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-server-names`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 启用标识，true启用 / false未启用
    enable: Optional[bool]
    #: 父级文件夹id
    folderId: Optional[str]
    #: 模型类型
    moduleType: Optional[str]
    #: 模型版本
    moduleVersion: Optional[str]
    #: 服务名
    serverName: Optional[str]


class ModuleServerNamesVO(BaseModel):
    """Module Server Names VO

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-server-names/v2`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 启用标识，true启用/false未启用
    enable: Optional[bool]
    #: 父级文件夹id
    folderId: Optional[str]
    #: 失败信息
    message: Optional[str]
    #: 模型类型
    moduleType: Optional[str]
    #: 模型版本
    moduleVersion: Optional[str]
    #: 服务名
    serverName: Optional[str]
    #: 查询状态，true成功/false失败
    status: Optional[bool]


class MoveElementDto(BaseModel):
    """Move Element Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/move-element``
        - **POST** ``/element-info/move-folders-elements``
    """
    #: 新增权限的元素id集合
    addPermissionIds: Optional[List[str]]
    #: 移动/复制带业务数据的元素id集合
    businessDataElementIds: Optional[List[str]]
    #: 覆盖权限的元素id集合
    coverPermissionIds: Optional[List[str]]
    #: 源文件夹id/组件id
    id: str
    #: 忽略权限的元素id集合
    ignorePermissionIds: Optional[List[str]]
    #: 源文件夹名称/元素名称
    name: str
    #: 源父级文件夹id
    originParentId: str
    #: 用户选择替换的元素id集合
    replaceElementIds: Optional[List[str]]
    #: 目标父级文件夹id
    targetParentId: str
    #: 源类型 ： DIR， DAT...
    type: str


class QueryElementInfoByProtocolDto(BaseModel):
    """Query Element Info By Protocol Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/get-elements-by-protocol``
        - **POST** ``/elements/get-elements-by-protocol-list``
    """
    #: 协议
    protocol: str
    #: 协议版本
    protocolVersion: str


class QueryElementInfoByTypeDto(BaseModel):
    """Query Element Info By Type Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-server-names``
        - **POST** ``/elements/get-element-info-by-type``
        - **POST** ``/elements/get-element-info-by-type/filter``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 过滤contentBlob的key，支持接口/get-element-info-by-type/filter
    filterContentBlobKey: Optional[List[str]]
    #: 过滤content的key，支持接口/get-element-info-by-type/filter
    filterContentKey: Optional[List[str]]
    #: 过滤filterRelationContentJson（false：过滤；true/不传：表示需要），支持接口/get-element-info-by-type/filter
    filterRelationContentJson: Optional[bool]
    #: 文件夹id(同路径二选一，优先路径)
    folderId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素绝对路径(同文件夹id二选一，优先路径)
    path: Optional[str]


class QueryElementPermissionByTypeDto(BaseModel):
    """Query Element Permission By Type Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/get-element-permission-by-type``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id(同路径二选一，优先路径)
    folderId: Optional[str]
    #: 元素绝对路径(同文件夹id二选一，优先路径)
    path: Optional[str]


class QueryModuleServerNameDto(BaseModel):
    """Query Module Server Name Dto

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-server-names/v2``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id(同路径二选一，优先路径)
    folderId: Optional[str]
    #: 元素绝对路径(同文件夹id二选一，优先路径)
    path: Optional[str]


class ReferencedElementBaseVO(BaseModel):
    #: 元素ID
    elementInfoId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素类型描述
    elementTypeDes: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件ID
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 路径
    path: Optional[str]


class ReferencedElementVO(BaseModel):
    """Referenced Element VO

    .. admonition:: 引用接口

        - **POST** ``/element-relations/referenced-element`` (Response: 200)
    """
    #: 元素ID
    elementInfoId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素类型描述
    elementTypeDes: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件ID
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 路径
    path: Optional[str]
    #: 被引用元素
    referencedElement: Optional[List[ReferencedElementBaseVO]]


class RemoveElementInfoDto(BaseModel):
    """Remove Element Info Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/del-element``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **GET** ``/folders/get-folder-full`` (Response: 200)
        - **GET** ``/folders/get-folder-id/by-full-path`` (Response: 200)
    """
    #: code
    code: Optional[int]
    #: data
    data: Optional[Any]
    #: message
    message: Optional[str]
    #: status
    status: Optional[bool]


class UpgradeInfoQuerryDto(BaseModel):
    """Upgrade Info Querry Dto

    .. admonition:: 引用接口

        - **POST** ``/element/upgrade-info-batch``
    """
    #: folderId
    folderId: Optional[str]
    #: name
    name: Optional[str]
    #: type
    type: Optional[str]


class ElementUpgradeDetail(BaseModel):
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: 元素id
    elementInfoId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素路径
    elementPath: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 元素升级记录主表id
    elementUpgradeLogId: Optional[int]
    #: 失败日志
    failMessage: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: id
    id: Optional[int]
    #: 组件升级后版本
    moduleVersionNew: Optional[str]
    #: 组件升级前版本
    moduleVersionOld: Optional[str]
    #: 状态：SUCCESS/FAIL
    status: Optional[str]
    #: 状态描述：成功/失败
    statusDesc: Optional[str]


class RightDistributionReqBody(BaseModel):
    """权限分配请求实体

    .. admonition:: 引用接口

        - **POST** ``/permission/edit``
    """
    #: 新增分配的用户id列表
    addUser: Optional[List[str]]
    #: 删除分配的用户id列表
    addUserGroup: Optional[List[str]]
    #: 新增分配的用户组id列表
    deleteUser: Optional[List[str]]
    #: 删除分配的用户组id列表
    deleteUserGroup: Optional[List[str]]
    #: 分配的元素或者文件夹id
    id: str
    #: 分配的元素或者文件夹名称（分配过程中，元素或者文件夹不存在，可以以此名称作为错误提示信息）
    name: str
    #: 分配权限 1/2/3
    permission: int
    #: 分配对象类型 元素ELEMENT/文件夹FOLDER
    type: str


class RightDistributionRespBody(BaseModel):
    """权限分配返回实体

    .. admonition:: 引用接口

        - **POST** ``/create/element/update`` (Response: 200)
        - **POST** ``/permission/edit`` (Response: 200)
    """
    #: 错误信息列表
    error: List[str]
    #: 警告信息列表
    waring: List[str]


class ElementExistsDto(BaseModel):
    """校验元素存在实体

    .. admonition:: 引用接口

        - **POST** ``/elements/check-element-exist-by-list``
    """
    #: 名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id（path 和 folderId必传一个）
    folderId: Optional[str]
    #: 路径（path 和 folderId必传一个）
    path: Optional[str]


class ElementExistsVo(BaseModel):
    """校验元素存在返回

    .. admonition:: 引用接口

        - **POST** ``/elements/check-element-exist-by-list`` (Response: 200)
    """
    #: 名称
    elementName: str
    #: 元素类型
    elementType: Optional[str]
    #: 异常消息
    errMsg: Optional[str]
    #: 是否存在
    existFlag: Optional[bool]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    path: Optional[str]


class CustomContentKeyTypeDto(BaseModel):
    #: jsPath:凡是js_path标识的key都不复制和导出
    jsPath: Optional[JsPath]


class ModifyElementInfoDto(BaseModel):
    """Modify Element Info Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/update-element``
    """
    #: 元素自定义数据内容-大数据 blob存储
    customContentBlobs: Optional[Any]
    #: 元素操作控制信息（即将废弃，使用customContentOpeFilterKey）
    customContentKeyTypeDto: Optional[CustomContentKeyTypeDto]
    #: 元素操作控制信息
    customContentOpeFilterKey: Optional[CustomContentKeyTypeDto]
    #: 元素自定义数据内容
    customContents: Optional[Any]
    #: 平台元素错误标记
    elOsError: Optional[bool]
    #: 元素警告标记
    elWarning: Optional[int]
    #: 元素名称
    elementName: str
    #: 元素描述（多语言）
    elementNameDesAll: Optional[Any]
    #: 元素类型（类型为PAGE时，moduleId传PAGE）
    elementType: str
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件id
    moduleId: str
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本号
    moduleVersion: Optional[str]
    #: 组件元素实例打开路径
    openPath: Optional[str]
    #: 路径
    path: Optional[str]
    #: 系统标识
    systemTag: Optional[bool]


class ElementUpgradeInfo(BaseModel):
    """元素升级记录

    .. admonition:: 引用接口

        - **POST** ``/element/element-upgrade`` (Response: 200)
        - **GET** ``/element/upgrade-log/by-id`` (Response: 200)
    """
    #: 应用id
    app: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人
    createUser: Optional[str]
    #: id
    id: Optional[int]
    #: 元素升级详细记录
    logDetailList: Optional[List[ElementUpgradeDetail]]
    #: 元素升级进度百分比
    percentage: Optional[int]
    #: 状态：SUCCESS/FAIL/UPGRADING/PART_SUCCESS
    status: Optional[str]
    #: 状态描述：成功/失败/升级中/部分成功
    statusDesc: Optional[str]


class CreateElementInfoDto(BaseModel):
    """Create Element Info Dto

    .. admonition:: 引用接口

        - **POST** ``/elements/create-element``
        - **POST** ``/elements/save-element``
    """
    #: 自动确认元素
    autoConfirm: Optional[bool]
    #: 业务数据标记
    businessDataFlag: Optional[bool]
    #: 确认标记
    confirm: Optional[bool]
    #: 元素自定义数据内容-大数据 blob存储
    customContentBlobs: Optional[Any]
    #: 元素操作控制信息（即将废弃，使用customContentOpeFilterKey）
    customContentKeyTypeDto: Optional[CustomContentKeyTypeDto]
    #: 元素操作控制信息
    customContentOpeFilterKey: Optional[CustomContentKeyTypeDto]
    #: 元素自定义数据内容
    customContents: Optional[Any]
    #: 平台元素错误标记
    elOsError: Optional[bool]
    #: 元素警告标记
    elWarning: Optional[int]
    #: 元素名称
    elementName: str
    #: 元素描述（多语言）
    elementNameDesAll: Optional[Any]
    #: 元素类型（元素类型为PAGE时，moduleId传PAGE）
    elementType: str
    #: 元素子类型
    elementTypeChild: Optional[str]
    #: 文件夹id
    folderId: Optional[str]
    #: 组件id（元素类型为PAGE时，moduleId传PAGE）
    moduleId: str
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本号
    moduleVersion: Optional[str]
    #: 元素实例打开路径
    openPath: Optional[str]
    #: 路径
    path: Optional[str]
    #: 平台刷新标识
    refreshTag: Optional[bool]
    #: 系统元素标识
    systemTag: Optional[bool]


class ElementFolderTree(BaseModel):
    """Element Folder Tree

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-element-folder/by-folder-list`` (Response: 200)
        - **POST** ``/element-info/get-element-folder/by-folder-list-relation`` (Response: 200)
    """
    #: elementInfoList
    elementInfoList: Optional[List[ElementInfo]]
    #: folderInfoList
    folderInfoList: Optional[List['FolderInfo']]


class FolderInfo(BaseModel):
    """Folder Info

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-element-folder/by-folder-list``
    """
    #: 应用id
    app: Optional[str]
    #: 子集文件夹和元素
    child: Optional[ElementFolderTree]
    #: 描述
    description: str
    #: 全路径
    fullPath: str
    #: 主键id
    id: Optional[str]
    #: 文件夹名称
    name: str
    #: 父级id
    parentId: str
    #: 权限值
    permission: Optional[int]
    #: 空间id
    space: Optional[str]
    #: 状态
    status: bool


class FolderInfoAddRelation(BaseModel):
    """Folder Info Add Relation

    .. admonition:: 引用接口

        - **POST** ``/element-info/get-element-folder/by-folder-list-relation``
    """
    #: 导出元素数据信息（与文件夹数据两者必填一个）
    elementInfos: Optional[List[FolderListVO]]
    #: 导出文件夹数据信息（与元素数据信息两者必填一个）
    folderList: Optional[List[FolderInfo]]
    #: 是否需要查询关联数据
    relation: Optional[bool]


class ElementUpgradeInfoVO(BaseModel):
    """Element Upgrade Info VO

    .. admonition:: 引用接口

        - **GET** ``/element/upgrade-info`` (Response: 200)
        - **POST** ``/element/upgrade-info-batch`` (Response: 200)
    """
    #: 子集元素
    children: Optional[List['ElementUpgradeInfoVO']]
    #: 文件夹id
    folderId: Optional[str]
    #: 路径
    fullPath: Optional[str]
    #: 元素id
    id: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 组件类型
    moduleType: Optional[str]
    #: 组件版本
    moduleVersion: Optional[str]
    #: 元素名称
    name: Optional[str]
    #: 元素类型：DAT......
    type: Optional[str]
    #: 可升级版本
    upgradeVersion: Optional[List[str]]


ElementFolderTree.update_forward_refs()
ElementUpgradeInfoVO.update_forward_refs()
