"""
Models used by /accounting-engines-server1-0

generated by model_code_gen.py
  - **filename** : ``accounting_engines.py``
  - **json timestamp** : ``2023-01-05 14:22:11``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AccEventTypeLineInfo',
    'AccEventTypeTableDTO',
    'AccountElementDetailDTO',
    'AccountingControlRequestDTO',
    'AccountingEnginesExecCallbackPythonDTO',
    'AccountingEnginesRequestDTO',
    'AggrConfigDTO',
    'DataDTO',
    'DataTableColumnDTO',
    'ElementDetailDTO',
    'FilterScopeDTO',
    'FormulaConditionsDTO',
    'GlobalConfigDTO',
    'GroupConfigDTO',
    'JoinOnDTO',
    'JoinWhereDTO',
    'LookupConditionsDTO',
    'LookupReturnColumnDTO',
    'ParamConfigDTO',
    'RegularConditionsDTO',
    'SequenceColumnDTO',
    'SequenceManageDTO',
    'TipModel',
    'AccEventTypeHeadDTO',
    'JoinConfigDTO',
    'AccEventTypeBasicDTO',
    'AccEventTypeElementDTO',
    'AccountDataTableInfoDTO',
    'ConfigRuleDTO',
    'NodeConfigDTO',
    'AccEventTypeDTO',
    'AccountBusinessModelDTO',
    'CustomContentsDTO',
    'AccountingEnginesDTO'
]


class AccEventTypeLineInfo(BaseModel):
    #: 科目类型编码
    accountType: str
    #: 科目类型描述
    accountTypeDesc: str
    #: 创建时间
    createTime: Optional[str]
    #: 创建人ID
    createUser: Optional[str]
    #: 借贷方向编码
    dc: str
    #: 借贷方向描述
    dcDesc: str
    #: 事件类型头编码
    eventTypeCode: str
    #: id
    id: Optional[str]
    #: 序号
    lineNo: Optional[int]
    #: 创建时间
    modifyTime: Optional[str]
    #: 修改人
    modifyUser: Optional[str]


class AccEventTypeTableDTO(BaseModel):
    """Acc Event Type Table DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/event/type/insert/to/event/table``
    """
    #: 事件类型元素ID（如果有值，则优先根据元素ID执行)
    elementId: Optional[str]
    #: 事件类型元素编码(与elementId 两个二选一必)
    elementName: Optional[str]
    #: 文件夹ID (path 两个二选一必填)
    folderId: Optional[str]
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str]
    #: 业务主键ID集合
    objectIdList: List[str]


class AccountElementDetailDTO(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool]
    #: 真实表名
    actualTableName: Optional[str]
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 目录id
    folderId: Optional[str]
    #: 元素ID
    id: Optional[str]
    #: 元素绝对路径
    path: Optional[str]
    #: 相对路径
    relativePath: Optional[str]
    #: 描述备注信息
    remark: Optional[str]
    #: 组件id
    serverName: Optional[str]


class AccountingControlRequestDTO(BaseModel):
    """Accounting Control Request DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/engines/update/control/status``
    """
    #: 会计元素-ID
    elementId: Optional[str]
    #: 会计元素-执行批次号
    batchNumber: Optional[str]
    #: 会计元素-执行状态：字符类型 ，0 失败，1 成功，2 删除
    status: Optional[str]
    #: 会计元素-元素名称
    elementName: Optional[str]
    #: 元素类型 BILL：单据，ACCOUNTING：会计引擎
    elementType: Optional[str]
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str]
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str]
    #: 目标数据ID集合
    targetElementDataIdList: Optional[List[str]]


class AccountingEnginesExecCallbackPythonDTO(BaseModel):
    #: PY所在路径，与folderId二选一
    path: Optional[str]
    #: PY所在文件夹ID，与path二选一
    folderId: Optional[str]
    #: PY的元素名称
    elementName: str
    #: 类型 默认值 PY
    elementType: Optional[str]
    #: Python服务名，如：python-server2-0
    serverName: Optional[str]
    #: 传给回调的参数，{key1:value1,key2:value2}
    callbackParams: Optional[Dict]


class AccountingEnginesRequestDTO(BaseModel):
    """Accounting Engines Request DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/engines/exec/by/id``
        - **POST** ``/accounting/engines/exec/by/name/type``
        - **POST** ``/accounting/engines/sync/exec/by/id``
    """
    #: 元素ID（如果有值，则优先根据元素ID执行）
    elementId: Optional[str]
    #: 元素编码
    elementName: Optional[str]
    #: 元素类型 ACCOUNTING:会计引擎，BILL:单据引擎
    elementType: Optional[str]
    #: 文件夹ID (path 两个二选一必填)
    folderId: Optional[str]
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str]
    #: 执行参数值列表{key1:value1,key2:value2}
    paramValueMap: Optional[Any]
    #: 回调信息
    callbackInfo: Optional[AccountingEnginesExecCallbackPythonDTO]


class AggrConfigDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: 字段uuid
    columnUuid: Optional[str]
    #: 聚合方式
    method: Optional[str]
    #: 新增列名
    newColumnName: Optional[str]
    #: 新增字段描述
    newColumnDesc: Optional[str]
    #: 新增字段类型
    newColumnType: Optional[str]
    #: 新增字段长度
    newColumnLength: Optional[str]


class DataDTO(BaseModel):
    #: 批次号
    batchNumber: Optional[str]
    #: 状态控制表信息
    controlTableInfo: Optional[AccountElementDetailDTO]


class DataTableColumnDTO(BaseModel):
    #: 会计事件类型配置,key为事件类型行uuid
    accEventRuleConfig: Optional[Any]
    #: 字段别名 默认为列名
    alias: Optional[str]
    #: 字段默认值
    defaultValue: Optional[str]
    #: 字段描述信息
    description: Optional[str]
    #: 字段格式
    format: Optional[str]
    #: 头分组字段标识
    headGroupFlag: Optional[bool]
    #: 字段长度
    length: Optional[str]
    #: 行分组字段标识
    lineGroupFlag: Optional[bool]
    #: 字段名称
    name: Optional[str]
    #: newDescription
    newDescription: Optional[str]
    #: newFlag
    newFlag: Optional[bool]
    #: 字段类型-原始类型
    originType: Optional[str]
    #: 排序
    sort: Optional[int]
    #: 字段类型-转换后
    type: Optional[str]
    #: uniqueKey
    uniqueKey: Optional[bool]
    #: 字段UUID
    uuid: Optional[str]
    #: 可否为空
    whetherEmpty: Optional[bool]
    #: 是否自增
    whetherIncrement: Optional[bool]
    #: 是否业务主键
    whetherLogicKey: Optional[bool]
    #: 是否唯一
    whetherOnly: Optional[bool]
    #: 是否系统主键
    whetherPrimary: Optional[bool]
    #: 是否系统字段
    whetherSystemColumn: Optional[bool]


class ElementDetailDTO(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool]
    #: description
    description: Optional[Any]
    #: 元素ID,同ID
    elementId: Optional[str]
    #: 元素名称
    elementName: Optional[str]
    #: 元素类型
    elementType: Optional[str]
    #: 目录id
    folderId: Optional[str]
    #: 元素ID
    id: Optional[str]
    #: 元素绝对路径
    path: Optional[str]
    #: 元素相对路径
    relativePath: Optional[str]
    #: 服务名
    serverName: Optional[str]


class FilterScopeDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str]
    #: 属性值
    columnValue: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: 操作符
    operationCode: Optional[str]
    #: 全局参数uuid
    paramUuid: Optional[str]


class FormulaConditionsDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str]
    #: 计算公式
    calcFormula: Optional[str]
    #: 新增字段名
    newColumnName: Optional[str]
    #: 新增字段描述
    newColumnDesc: Optional[str]
    #: 新增字段类型
    newColumnType: Optional[str]
    #: 新增字段长度
    newColumnLength: Optional[str]


class GlobalConfigDTO(BaseModel):
    #: 生成规则 0：不允许重复生成，1：允许多次且提示，2：允许多次且不提示
    rule: int
    #: 筛选范围
    filterScope: Optional[List[FilterScopeDTO]]


class GroupConfigDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: 是否父级
    isParent: Optional[bool]
    #: 全局唯一uuid
    uuid: Optional[str]


class JoinOnDTO(BaseModel):
    #: 关联符号，一般是=
    operationCode: str
    #: 源对象uuid｜目标模型父级
    sourceColumnUuid: str
    #: 目标对象uuid｜目标模型当前
    targetColumnUuid: str
    #: type
    type: Optional[str]
    #: uuid
    uuid: str


class JoinWhereDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str]
    #: 字段值
    columnValue: Optional[str]
    #: 操作符
    operationCode: Optional[str]
    #: 全局参数uuid
    paramUuid: Optional[str]
    #: uuid
    uuid: Optional[str]


class LookupConditionsDTO(BaseModel):
    #: 会计事件字段规则来源【源:TABLE;参数：PARAMETER;科目：ACCOUNT】
    sourceType: Optional[str]
    #: 全局唯一uuid
    uuid: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: 字段Uuid
    columnUuid: Optional[str]
    #: 操作符
    operationCode: Optional[str]
    #: 被查询字段uuid
    lookupColumnUuid: Optional[str]


class LookupReturnColumnDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str]
    #: 返回字段UUID
    lookupColumnUuid: Optional[str]
    #: 新增字段名
    newColumnName: Optional[str]
    #: 新增字段描述
    newColumnDesc: Optional[str]
    #: 新增字段类型
    newColumnType: Optional[str]
    #: 新增字段长度
    newColumnLength: Optional[str]


class ParamConfigDTO(BaseModel):
    #: 参数编码
    paramCode: Optional[str]
    #: 参数描述
    paramDesc: Optional[str]
    #: 参数类型
    paramType: Optional[str]
    #: 参数长度
    paramLength: Optional[str]
    #: 默认值
    defaultValue: Optional[str]


class RegularConditionsDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: 字段uuid
    columnUuid: Optional[str]
    #: 正则公式
    regular: Optional[str]
    #: 新增字段名
    newColumnName: Optional[str]
    #: 新增字段描述
    newColumnDesc: Optional[str]
    #: 新增字段类型
    newColumnType: Optional[str]
    #: 新增字段长度
    newColumnLength: Optional[str]


class SequenceColumnDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str]
    #: 数据表uuid
    dataTableUuid: Optional[str]
    #: uuid
    uuid: Optional[str]


class SequenceManageDTO(BaseModel):
    #: uuid
    uuid: Optional[str]
    #: 序列名称
    seqName: Optional[str]
    #: 序列编码
    seqCode: Optional[str]
    #: 序列长度
    length: Optional[int]
    #: 起始值
    start: Optional[int]
    #: 目标模型元素
    targetDataTableUuid: Optional[str]
    #: 步长
    stepBy: Optional[int]
    #: 分组依据字段
    groupColumns: Optional[List[SequenceColumnDTO]]
    #: 流水段分割符
    separator: Optional[str]


class TipModel(BaseModel):
    #: code
    code: Optional[str]
    #: id
    id: Optional[int]
    #: logical
    logical: Optional[str]
    #: message
    message: Optional[str]
    #: module
    module: Optional[str]
    #: object
    object: Optional[str]
    #: remark
    remark: Optional[str]
    #: type
    type: Optional[int]
    #: uuid
    uuid: Optional[str]


class AccEventTypeHeadDTO(BaseModel):
    #: 关联业务单据-元素编码
    bcubCode: str
    #: 关联业务单据-元素ID
    bcubId: str
    #: 关联业务单据-元素名称
    bcubName: Optional[str]
    #: 创建时间
    createTime: Optional[str]
    #: 创建人ID
    createUser: Optional[str]
    #: 事件类型编码
    eventTypeCode: str
    #: 事件类型名称,存多语言JSON
    eventTypeName: Optional[str]
    #: 创建时间
    modifyTime: Optional[str]
    #: 修改人
    modifyUser: Optional[str]
    #: 关联业务单据元素信息
    relationBMInfo: ElementDetailDTO
    #: 事件类型描述
    remark: str


class JoinConfigDTO(BaseModel):
    #: 连接方式，left join,right join,inner join,outer join
    joinHow: str
    #: 关联关系
    joinOn: Optional[List[JoinOnDTO]]
    #: 关联条件
    joinWhere: Optional[List[JoinWhereDTO]]


class AccEventTypeBasicDTO(BaseModel):
    """Acc Event Type Basic DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/event/type/save``
        - **POST** ``/accounting/event/type/update``
    """
    #: accEventTypeHeadDTO
    accEventTypeHeadDTO: Optional[AccEventTypeHeadDTO]
    #: accEventTypeLineInfoList
    accEventTypeLineInfoList: Optional[List[AccEventTypeLineInfo]]
    #: elementId
    elementId: Optional[str]
    #: elementName
    elementName: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: path
    path: Optional[str]
    #: 元素来源类型 handleCreate：手动新建，copyCreate：复制过来的，importCreate：导入进来的
    sourceType: Optional[str]


class AccEventTypeElementDTO(BaseModel):
    """Acc Event Type Element DTO

    .. admonition:: 引用接口

        - **GET** ``/accounting/event/type/get-info-by-id`` (Response: 200)
        - **GET** ``/accounting/event/type/get-info-by-name`` (Response: 200)
    """
    #: 元素ID
    elementId: Optional[str]
    #: 会计引擎唯一编码
    elementName: str
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str]
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str]
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int]
    #: 元素类型 ACCOUNTING_EVENT_TYPE：会计事件类型
    elementType: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 名称（多语言）
    description: Optional[Any]
    #: 自动确认，默认值：true
    autoConfirm: Optional[bool]
    #: 描述信息
    remark: Optional[str]
    #: 会计事件类型-未发布json内容
    customContents: Optional[AccEventTypeBasicDTO]
    #: 会计事件-发布后json内容
    customContentBlobs: Optional[AccEventTypeBasicDTO]
    #: 检查错误信息
    errorMsg: Optional[str]


class AccountDataTableInfoDTO(BaseModel):
    #: 是否是最顶层表
    firstLevelFlag: Optional[bool]
    #: 是否是最底层表
    lastLevelFlag: Optional[bool]
    #: 数据表ID
    uuid: Optional[str]
    #: 父级数据表ID
    parentUuid: Optional[str]
    #: 名称（多语言）
    description: Optional[Any]
    #: 真实表名
    actualTableName: Optional[str]
    #: 数据表别名
    dataTableAlias: Optional[str]
    #: 列集合
    columns: Optional[List[DataTableColumnDTO]]
    #: 数据表元素信息
    elementDetail: Optional[AccountElementDetailDTO]
    #: 关联关系配置
    joinConfig: Optional[JoinConfigDTO]
    #: 备注说明
    remark: Optional[str]
    #: 表类型：源业务单据：SOURCE_BCUB；关联维度：RELATION_DIMENSION；会计事件类型表：ACC_EVENT_TYPE
    accEventTableType: Optional[str]


class ConfigRuleDTO(BaseModel):
    #: uuid
    uuid: Optional[str]
    #: 序号
    lineNo: Optional[int]
    #: 规则名称
    ruleName: Optional[str]
    #: 规则类型：regularConditions:正则，formulaConditions:公式，lookupConditions:lookup查找groupConfig：分组，aggrConfig：聚合
    ruleType: Optional[str]
    #: 目标模型元素
    targetDataTableUuid: Optional[str]
    #: 目标模型元素父级uuid
    parentTargetDataTableUuid: Optional[str]
    #: 描述备注
    remark: Optional[str]
    #: 被查询的元素信息
    lookupDataTable: Optional[AccountDataTableInfoDTO]
    #: 匹配多条时 ERROR：报错，ANY：返回任意一条
    lookupMulti: Optional[str]
    #: Lookup匹配规则时，新增的返回字段集合
    lookupReturnColumns: Optional[List[LookupReturnColumnDTO]]
    #: lookup条件信息
    lookupConditions: Optional[List[LookupConditionsDTO]]
    #: 计算公式条件
    formulaConditions: Optional[List[FormulaConditionsDTO]]
    #: 正则表达式条件
    regularConditions: Optional[List[RegularConditionsDTO]]
    #: 分组配置信息
    groupConfig: Optional[List[GroupConfigDTO]]
    #: 聚合信息
    aggrConfig: Optional[List[AggrConfigDTO]]


class NodeConfigDTO(BaseModel):
    #: 序号
    lineNo: int
    #: 节点名称
    nodeName: str
    #: 节点的配置规则
    ruleConfigList: Optional[List[ConfigRuleDTO]]
    #: 序列管理
    sequenceManageList: Optional[List[SequenceManageDTO]]
    #: 源对象数据表集合
    sourceDataTableList: Optional[List[AccountDataTableInfoDTO]]
    #: 目标模型数据表集合
    targetDataTableList: Optional[List[AccountDataTableInfoDTO]]


class AccEventTypeDTO(BaseModel):
    #: accEventTypeDetail
    accEventTypeDetail: Optional[AccEventTypeElementDTO]
    #: elementId
    elementId: Optional[str]
    #: elementName
    elementName: Optional[str]
    #: elementType
    elementType: Optional[str]
    #: folderId
    folderId: Optional[str]
    #: path
    path: Optional[str]


class AccountBusinessModelDTO(BaseModel):
    #: 模型ID
    id: Optional[str]
    #: 模型名称
    name: str
    #: 名称 多语言信息
    description: Any
    #: 路径
    path: Optional[str]
    #: 文件夹ID
    folderId: Optional[str]
    #: 模型ID
    moduleId: Optional[str]
    #: 逻辑表信息
    dataTableList: Optional[List[AccountDataTableInfoDTO]]
    #: 服务名
    serverName: Optional[str]
    #: 类型
    type: Optional[str]
    #: 元素ID
    elementId: Optional[str]


class CustomContentsDTO(BaseModel):
    #: accountingType
    accountingType: Optional[str]
    #: description
    description: Optional[Any]
    #: 元素执行状态 0：未执行成功过，1：执行成功过
    elementExecStatus: Optional[int]
    #: 元素来源类型 handleCreate：手动新建，copyCreate：复制过来的，importCreate：导入进来的
    sourceType: Optional[str]
    #: 会计事件类型-会计事件使用
    accEventType: Optional[AccEventTypeDTO]
    #: 源对象数据表集合-会计事件使用
    sourceDataTableList: Optional[List[AccountDataTableInfoDTO]]
    #: 目标模型数据表集合-会计事件使用
    targetDataTableList: Optional[List[AccountDataTableInfoDTO]]
    #: 源对象信息
    sourceElement: AccountBusinessModelDTO
    #: 目标模型信息
    targetElement: AccountBusinessModelDTO
    #: 参数管理
    paramConfig: Optional[List[ParamConfigDTO]]
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int]
    #: 全局配置
    globalConfig: Optional[GlobalConfigDTO]
    #: 节点配置，默认有6个节点
    nodeConfig: Optional[List[NodeConfigDTO]]


class AccountingEnginesDTO(BaseModel):
    """Accounting Engines DTO

    .. admonition:: 引用接口

        - **GET** ``/accounting/engines/get-accounting-info-by-id`` (Response: 200)
        - **GET** ``/accounting/engines/get-accounting-info-by-name-type`` (Response: 200)
        - **POST** ``/accounting/engines/publish/{elementId}`` (Response: 200)
        - **POST** ``/accounting/engines/relation/update`` (Response: 200)
        - **POST** ``/accounting/engines/save``
        - **POST** ``/accounting/engines/update``
    """
    #: accountingType
    accountingType: Optional[str]
    #: 错误标识
    errorTag: Optional[bool]
    #: 错误集合
    errorList: Optional[List[TipModel]]
    #: 预警标识
    warningTag: Optional[bool]
    #: 预警集合
    warningList: Optional[List[TipModel]]
    #: 元素ID
    elementId: Optional[str]
    #: 会计引擎唯一编码
    elementName: str
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str]
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str]
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int]
    #: 元素类型 BILL：单据，ACCOUNTING：会计引擎，EVENT：会计事件
    elementType: Optional[str]
    #: 组件id
    moduleId: Optional[str]
    #: 名称（多语言）
    description: Optional[Any]
    #: 自动确认，默认值：true
    autoConfirm: Optional[bool]
    #: 描述信息
    remark: Optional[str]
    #: 会计元素-未发布json内容
    customContents: Optional[CustomContentsDTO]
    #: 会计元素-发布后json内容
    customContentBlobs: Optional[CustomContentsDTO]
    #: 会计元素-转换后的结构（单据到凭证，发布时进行转换）
    transformBlobs: Optional[CustomContentsDTO]
    #: 检查错误信息
    errorMsg: Optional[str]



