"""
APIs provided by memory-financial-model-server1-0

generated by model_code_gen.py
  - **filename** : ``memory_financial_model.py``
  - **json timestamp** : ``2022-08-16 18:00:32``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.memory_financial_model import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['MemFinancialModelAPI']


class CubeData(ChildAPI):
    endpoint = '/cube-data'
    
    @post('cell-data')
    def cell_data(self, pythonQuery: PythonQueryCubeDTO = None) -> Union[List[Any], Awaitable[List[Any]]]:
        """
        合并算法-获取模型POV数据条件下单元格数据
    
        """
        return {'body': pythonQuery}
    
    @post('clear-cube-data')
    def clear_cube_data(self, pythonQuery: PythonQueryCubeDTO = None) -> Union[Any, Awaitable[Any]]:
        """
        清除模型数据
    
        """
        return {'body': pythonQuery}
    
    @post('general-query')
    def general_query(self, params: CubeGeneralQuery) -> Union[List[dict], Awaitable[List[dict]]]:
        """
        内存财务模型对外数据查询接口
    
        内存财务模型对外提供数据查询接口
        """
        return {'body': params}
    
    @post('python-exp')
    def python_exp(self, pythonExpParam: PythonQueryCubeDTO = None) -> Union[List[PythonResultDTO], Awaitable[List[PythonResultDTO]]]:
        """
        合并算法-处理python公式
    
        """
        return {'body': pythonExpParam}
    
    @post('query')
    def query(self, multiReportQuery: QueryParamInfoVo) -> Union[SheetDataResultVo, Awaitable[SheetDataResultVo]]:
        """
        透视表查询内存财务模型数据
    
        透视表查询内存财务模型数据（下钻）
        """
        return {'body': multiReportQuery}


class Cube(ChildAPI):
    endpoint = '/cube'
    
    @get('find-cube-data')
    def find_cube_data(self, folderId: str, cubeCode: str) -> Union[MemFinancialModelVo, Awaitable[MemFinancialModelVo]]:
        """
        查询内存财务数据模型数据
    
        """
        return {'body': {'cubeCode': cubeCode, 'folderId': folderId}}


class MemFinancialModelAPI(DynamicRootAPI, builtin=True):
    """内存财务模型组件接口"""
    module_type = 'IMFM'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'MemFinancialModelAPI'
    module_name = 'deepfos.api.memory_financial_model'
    api_version = (1, 0)

    @cached_property
    def cubedata(self) -> CubeData:
        """
        内存财务对外数据接口
        """
        return CubeData(self)

    @cached_property
    def cube(self) -> Cube:
        """
        内存财务数据模型相关接口
        """
        return Cube(self)


