"""
APIs provided by financial-model-server1-0

generated by api_code_gen.py
  - **filename** : ``financial_model.py``
  - **json timestamp** : ``2022-11-28 17:27:51``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.financial_model import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['FinancialModelAPI']


class Block(ChildAPI):
    endpoint = '/block'
    
    @post('pc-init')
    def pc_init(self, params: PcParams) -> Union[Any, Awaitable[Any]]:
        """
        初始化财务模型状态
    
        """
        return {'body': params}
    
    @post('pc-status')
    def pc_status(self, params: PcParams) -> Union[Any, Awaitable[Any]]:
        """
        更新财务模型权限状态
    
        """
        return {'body': params}

    @post('pc-status-upsert')
    def pc_status_upsert(self, params: PcParams) -> Union[Any, Awaitable[Any]]:
        """
        upsert更新财务模型权限状态

        """
        return {'body': params}


class Extra(ChildAPI):
    endpoint = '/'
    
    @post('copyCalculate')
    def copyCalculate(self, calculateDTO: CopyCalculateDTO) -> Union[Any, Awaitable[Any]]:
        """
        copy计算接口API
    
        """
        return {'body': calculateDTO}


class CubeDataAPI(ChildAPI):
    endpoint = '/cube-data'
    
    @post('query')
    def query(self, cubeQueryForOutVo: CubeQueryForOutVo) -> Union[Any, Awaitable[Any]]:
        """
        财务数据模型外部取数接口
    
        财务数据模型取数查询
        """
        return {'body': cubeQueryForOutVo}


class CubeAPI(ChildAPI):
    endpoint = '/cube'
    
    @get('cube-dimension')
    def cube_dimension(self, cubeName: str, folderId: str = None, path: str = None,  version: str = None) -> Union[Any, Awaitable[Any]]:
        """
        给电子表格使用，获取cube及其数据表、维度相关数据信息
    
        查询财务数据模型列属性数据,并归类.1为维度列集合;999为属性维集合
        ;1000为财务数据模型主数据
        """
        return {
          'param': {
              'cubeName': cubeName,
              'folderId': folderId,
              'path': path,
              'version': version,
          },
        }
    
    @get('data')
    def data(self, cubeName: str, folderId: str = None, path: str = None) -> Union[FinancialModelDto, Awaitable[FinancialModelDto]]:
        """
        cube使用视图，查询接口
    
        """
        return {'param': {'cubeName': cubeName, 'folderId': folderId, 'path': path}}
    
    @post('delete-other')
    def delete_other(self, param: ElementDeleteFrontRearDTO) -> Union[bool, Awaitable[bool]]:
        """
        cube元素删除--后置逻辑
    
        该接口为配置到平台的接口--见module.json中的配置，如果有配
        置，在平台的元素删除后，会触发此接口
        """
        return {'body': param}
    
    @get('find-cube-data')
    def find_cube_data(self, cubeName: str, folderId: str = None, path: str = None) -> Union[FinancialDataDto, Awaitable[FinancialDataDto]]:
        """
        查询cube的基本数据
    
        """
        return {'param': {'cubeName': cubeName, 'folderId': folderId, 'path': path}}
    
    @post('right')
    def right(self, cubeInfo: FinancialDataDto) -> Union[FinancialDataDto, Awaitable[FinancialDataDto]]:
        """
        cube权限页面，新建、编辑接口
    
        """
        return {'body': cubeInfo}
    
    @get('right/query')
    def right_query(self, cubeName: str, folderId: str = None, path: str = None) -> Union[FinancialModelDto, Awaitable[FinancialModelDto]]:
        """
        cube权限页面，查询接口
    
        """
        return {'param': {'cubeName': cubeName, 'folderId': folderId, 'path': path}}
    
    @post('save')
    def save(self, financialModelDto: FinancialModelDto) -> Union[FinancialModelDto, Awaitable[FinancialModelDto]]:
        """
        cube使用视图，新建、编辑接口
    
        cube每一次新建、编辑都会触发两次接口，saveType为0表示校验
        ，1表示新建/保存
        """
        return {'body': financialModelDto}


class CubeDataLogAPI(ChildAPI):
    endpoint = '/cube/data/log'
    
    @post('list')
    def list(self, cubeDataLogForm: CubeDataLogForm) -> Union[List[Any], Awaitable[List[Any]]]:
        """
        财务模型数据审计查询
    
        """
        return {'body': cubeDataLogForm}


class CubeCalculateAPI(ChildAPI):
    endpoint = '/cubeCalculate'
    
    @post('clearData')
    def clear_data(self, clearDataDTO: ClearDataDTO) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        根据财务数据模型名称 所在文件夹Id 维度表达式 清除相关的数据
    
        """
        return {'body': clearDataDTO}


class ReactSpreadsheet(ChildAPI):
    endpoint = '/react/spreadsheet'
    
    @post('save')
    def save(self, spreadsheetSaveForm: ReactSpreadsheetSaveForm) -> Union[Any, Awaitable[Any]]:
        """
        电子表格数据保存
    
        """
        return {'body': spreadsheetSaveForm}


class SpreadSheetAPI(ChildAPI):
    endpoint = '/spreadsheets'
    
    @get('query-pov-dimension-tree')
    def query_pov_dimension_tree(self, sheetPovTreeParam: SheetPovTreeParam) -> Union[SheetPovTreeDto, Awaitable[SheetPovTreeDto]]:
        """
        电子表格pov查询，树形结构
    
        """
        return {'body': sheetPovTreeParam}
    
    @get('query-pov-member')
    def query_pov_member(self, workbookName: str, folderId: str) -> Union[List[SheetPovInfoDto], Awaitable[List[SheetPovInfoDto]]]:
        """
        电子表格pov查询，仪表盘用
    
        """
        return {'param': {'folderId': folderId, 'workbookName': workbookName}}
    
    @post('query-workbook-data')
    def query_workbook_data(self, wookbookParamDto: WookbookParamDto) -> Union[WorkbookInfoDto, Awaitable[WorkbookInfoDto]]:
        """
        电子表格查询接口
    
        """
        return {'body': wookbookParamDto}


class WorkbookAPI(ChildAPI):
    endpoint = '/workbookcontroller'
    
    @get('findworkbookinfo')
    def findworkbookinfo(self, workbookName: str, workbookFolderId: str = None, workbookPath: str = None) -> Union[Any, Awaitable[Any]]:
        """
        电子表格编辑视图查询
    
        根据电子表格唯一标识
        (workbookName+workbookFolderId),查询出
        电子表格相关数据信息
        """
        return {
          'param': {
              'workbookFolderId': workbookFolderId,
              'workbookName': workbookName,
              'workbookPath': workbookPath,
          },
        }


class MdxTask(ChildAPI):
    endpoint = '/mdx/task'
    
    @post('execution')
    def execution(self, param: TaskExecutionParam) -> Union[TaskExecutionResult, Awaitable[TaskExecutionResult]]:
        """
        execution
    
        """
        return {'body': param}


class FinancialModelAPI(DynamicRootAPI, builtin=True):
    """财务模型组件接口"""
    module_type = 'CUB'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'FinancialModelAPI'
    module_name = 'deepfos.api.financial_model'
    api_version = (1, 0)

    @cached_property
    def block(self) -> Block:
        """
        财务模型状态表初始化
        """
        return Block(self)

    @cached_property
    def extra(self) -> Extra:
        """
        copy计算
        """
        return Extra(self)

    @cached_property
    def data(self) -> CubeDataAPI:
        """
        财务数据模型外部取数接口
        """
        return CubeDataAPI(self)

    @cached_property
    def cube(self) -> CubeAPI:
        """
        财务数据模型cube相关接口
        """
        return CubeAPI(self)

    @cached_property
    def data_log(self) -> CubeDataLogAPI:
        """
        财务数据模型数据审计接口
        """
        return CubeDataLogAPI(self)

    @cached_property
    def calculate(self) -> CubeCalculateAPI:
        """
        财务数据模型清数接口
        """
        return CubeCalculateAPI(self)

    @cached_property
    def reactspreadsheet(self) -> ReactSpreadsheet:
        """
        财务模型相关联数据保存
        """
        return ReactSpreadsheet(self)

    @cached_property
    def spreadsheet(self) -> SpreadSheetAPI:
        """
        电子表格查询
        """
        return SpreadSheetAPI(self)

    @cached_property
    def workbook(self) -> WorkbookAPI:
        """
        电子表格编辑视图相关接口
        """
        return WorkbookAPI(self)

    @cached_property
    def mdxtask(self) -> MdxTask:
        """
        mdx-script-calculation-controller
        """
        return MdxTask(self)


