"""
APIs provided by dimension-server1-0

generated by api_code_gen.py
  - **filename** : ``dimension.py``
  - **json timestamp** : ``2022-09-02 19:26:55``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.dimension import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['DimensionAPI']


class DimSaveAPI(ChildAPI):
    endpoint = '/dimension-save'
    
    @post('dimension-member-change-save')
    def incremental(self, dimension: DimensionMemberChangeSaveSw) -> Union[DimensionChangeSaveResult, Awaitable[DimensionChangeSaveResult]]:
        """
        维度树形增量编辑成员
    
        给页面提供可拖拉拽的增加编辑删除的增量编辑接口
        """
        return {'body': dimension}


class DimCheckAPI(ChildAPI):
    endpoint = '/dimension/check'
    
    @post('exists')
    def exists(self, dimensions: List[ElementBaseInfoParam]) -> Union[Any, Awaitable[Any]]:
        """
        批量查询维度是否存在
    
        """
        return {'body': dimensions}
    
    @post('member/exists')
    def member_exists(self, dto: ElementBaseInfoDto) -> Union[Any, Awaitable[Any]]:
        """
        批量查询维度成员是存在
    
        """
        return {'body': dto}
    
    @post('member/exists/batch/express')
    def member_exists_batch_express(self, dtos: List[DimensionExpressDto]) -> Union[List[DimensionExpressExistsResult], Awaitable[List[DimensionExpressExistsResult]]]:
        """
        批量校验表达式成员是否存在
    
        批量校验组成表达式的成员是否都存在
        """
        return {'body': dtos}
    
    @post('member/exists/express')
    def member_exists_express(self, dto: DimensionExpressDto) -> Union[DimensionExpressExistsResult, Awaitable[DimensionExpressExistsResult]]:
        """
        校验表达式成员是否存在
    
        校验组成表达式的成员是否都存在
        """
        return {'body': dto}
    
    @post('member/exists/single')
    def member_exists_single(self, dto: ElementBaseInfoDto) -> Union[Any, Awaitable[Any]]:
        """
        查询单个维度成员是否存在
    
        """
        return {'body': dto}
    
    @post('member/express/contains')
    def member_express_contains(self, dto: DimensionExpressAndMemberDto) -> Union[DimensionExpressExistsResult, Awaitable[DimensionExpressExistsResult]]:
        """
        校验成员是否在表达式中
    
        校验维度成员是否被表达式包括
        """
        return {'body': dto}
    
    @post('member/multi/express-rs/contains')
    def member_multi_express_rs_contains(self, dtos: List[MemberInExpressAndRsDto]) -> Union[List[MemberInExpressAndRsResult], Awaitable[List[MemberInExpressAndRsResult]]]:
        """
        批量维度校验成员是否在表达式和权限中
    
        批量维度校验成员是否在表达式和角色方案中
        """
        return {'body': dtos}
    
    @post('member/multi/express/contains')
    def member_multi_express_contains(self, dtos: List[DimensionExpressAndMemberDto]) -> Union[List[DimensionExpressExistsResult], Awaitable[List[DimensionExpressExistsResult]]]:
        """
        批量维度校验成员是否在表达式中
    
        """
        return {'body': dtos}


class DimCustomAPI(ChildAPI):
    endpoint = '/dimension/custom'
    
    @post('get-around-dimension')
    def get_around_dimension(self, dto: AroundDimensionDto) -> Union[Any, Awaitable[Any]]:
        """
        获取前后第n个维度成员
    
        """
        return {'body': dto}
    
    @post('get-dimension-description')
    def get_dimension_description(self, expr_list: List[DimensionDescriptionDto]) -> Union[List[DimensionDescriptionReDto], Awaitable[List[DimensionDescriptionReDto]]]:
        """
        获取维度成员描述
    
        """
        return {'body': expr_list}
    
    @post('get-dimension-member-by-level')
    def get_dimension_member_by_level(self, dto: DimensionMemberByLevelDto) -> Union[Any, Awaitable[Any]]:
        """
        通过层级获取维度成员
    
        """
        return {'body': dto}
    
    @post('get-dimension-member-by-parent')
    def get_dimension_member_by_parent(self, dto: DimensionMemberByParentDto) -> Union[Any, Awaitable[Any]]:
        """
        根据父级属性查维度成员
    
        """
        return {'body': dto}
    
    @post('get-more-level-member')
    def get_more_level_member(self, dto: MoreLevelMemberDto) -> Union[Any, Awaitable[Any]]:
        """
        POV的多层级显示
    
        """
        return {'body': dto}
    
    @post('get-ud-value-by-express')
    def get_ud_value_by_express(self, dto: UdValueByExpressDto) -> Union[Any, Awaitable[Any]]:
        """
        根据表达式获取维度自定义属性
    
        """
        return {'body': dto}
    
    @post('select-dimension-member-list')
    def select_dimension_member_list(self, dto: DimensionMemberListDto) -> Union[Any, Awaitable[Any]]:
        """
        查询维度成员列表
    
        """
        return {'body': dto}


class DimExcelAPI(ChildAPI):
    endpoint = '/dimension/excel'
    
    @post('export-dimension-member')
    def export_dimension_member(self, ) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        导出Excel维度成员
    
        """
        return {}
    
    @post('import-dimension-member')
    def import_dimension_member(self, ) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        Excel导入维度成员
    
        """
        return {}


class DimInfoAPI(ChildAPI):
    endpoint = '/dimension/info'
    
    @post('build-period-config-and-member')
    def build_period_config_and_member(self, dto: PeriodConfigDto) -> Union[Any, Awaitable[Any]]:
        """
        编辑期间层级
    
        编辑期间层级生成对应period成员与view视图
        """
        return {'body': dto}
    
    @post('initialization-tables')
    def initialization_tables(self, vo: ElementBaseInfoParam) -> Union[Any, Awaitable[Any]]:
        """
        维度导入导出时，如果没有导表，初始化表
    
        """
        return {'body': vo}
    
    @get('relation')
    def get_relation(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[RelationVo], Awaitable[List[RelationVo]]]:
        """
        获取维度关联元素清单
    
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}
    
    @post('relation')
    def save_relation(self, vo: DimensionRelationVo) -> Union[Any, Awaitable[Any]]:
        """
        保存维度关联元素清单
    
        """
        return {'body': vo}
    
    @post('save-dimension-info-and-ud')
    def save_dimension_info_and_ud(self, dimensionData: str) -> Union[str, Awaitable[str]]:
        """
        维度新建及编辑
    
        """
        return {'body': dimensionData}
    
    @post('update-view-member')
    def update_view_member(self, dimension: UpdateViewMemberSw) -> Union[Any, Awaitable[Any]]:
        """
        更新view成员描述
    
        """
        return {'body': dimension}


class DimMemeberAPI(ChildAPI):
    endpoint = '/dimension/member'
    
    @post('save-dimension-member')
    def save(self, members: DimensionMemberSaveDto) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        保存维度成员信息
    
        全量及增量编辑维度成员
        """
        return {'body': members}


class DimQueryAPI(ChildAPI):
    endpoint = '/dimension/query'
    
    @post('date-dimension')
    def date_dimension(self, params: DateDimensionDto) -> Union[Any, Awaitable[Any]]:
        """
        获取期间维度
    
        """
        return {'body': params}
    
    @get('find-dimension-type')
    def find_dimension_type(self, folderId: str, path: str = None) -> Union[List[Dict[str, Any]], Awaitable[List[Dict[str, Any]]]]:
        """
        查询可新建的维度类型
    
        """
        return {'param': {'folderId': folderId, 'path': path}}
    
    @post('get-access-dimension-member-list')
    def get_access_dimension_member_list(self, allParam: DimensionMemberQuerySw) -> Union[Any, Awaitable[Any]]:
        """
        维度成员不分层级搜索
    
        维度成员不分层级搜索，通用查询
        """
        return {'body': allParam}
    
    @post('get-all-year-period-of-sceanrio')
    def get_all_year_period_of_sceanrio(self, dto: AllYearPeriodOfSceanrioDto) -> Union[Any, Awaitable[Any]]:
        """
        根据开始结束年期间返回所有组合
    
        """
        return {'body': dto}
    
    @post('get-authorized-dimension-member-level')
    def get_authorized_dimension_member_level(self, dto: DimensionMemberLevelAuthorizedDto) -> Union[Any, Awaitable[Any]]:
        """
        维度成员层级搜索
    
        维度成员层级搜索--树形展示，通用查询
        """
        return {'body': dto}
    
    @post('get-dimension-list')
    def get_dimension_list(self, dimensions: List[ElementBaseInfoParam]) -> Union[List[Dimension], Awaitable[List[Dimension]]]:
        """
        获取维度信息
    
        批量获取维度信息
        """
        return {'body': dimensions}
    
    @post('get-member-level')
    def get_member_level(self, allParam: Any) -> Union[Any, Awaitable[Any]]:
        """
        维度成员层级查询
    
        """
        return {'body': allParam}
    
    @post('get-open-period-config')
    def get_open_period_config(self, param: ElementBaseQueryParam) -> Union[Any, Awaitable[Any]]:
        """
        查询期间维度配置列表
    
        """
        return {'body': param}
    
    @get('get-period-by-level')
    def get_period_by_level(self, periodLevel: str, dimensionName: str, folderId: str = None, path: str = None) -> Union[List, Awaitable[List]]:
        """
        根据期间层级查询期间维度成员
    
        """
        return {
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'path': path,
              'periodLevel': periodLevel,
          },
        }
    
    @post('get-view-by-express')
    def get_view_by_express(self, dto: ViewExpressDto) -> Union[List[ViewDto], Awaitable[List[ViewDto]]]:
        """
        根据view表达式,period维度名,folderId查询view成员
    
        """
        return {'body': dto}
    
    @post('get-view-by-period')
    def get_view_by_period(self, dto: ElementQueryBaseDto) -> Union[List[ViewDto], Awaitable[List[ViewDto]]]:
        """
        根据period维度名,folderId查询所有view维度成员
    
        """
        return {'body': dto}
    
    @post('open-dimension-info-by-id')
    def open_dimension_info_by_id(self, dto: ElementBaseInfoDto) -> Union[Dimension, Awaitable[Dimension]]:
        """
        打开维度主体信息
    
        查看维度主体信息
        """
        return {'body': dto}
    
    @get('select-dimension-member')
    def select_dimension_member(self, dimensionName: str, folderId: str = None, id: str = None, memberName: str = None, path: str = None, resultString: str = None) -> Union[Dict[str, Any], Awaitable[Dict[str, Any]]]:
        """
        查询单个维度成员信息
    
        """
        return {
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'id': id,
              'memberName': memberName,
              'path': path,
              'resultString': resultString,
          },
        }
    
    @post('select-dimension-member-by-name-function')
    def select_dimension_member_by_name_function(self, dto: DimensionMemberByNameFunctionDto) -> Union[List[DimensionMemberBean], Awaitable[List[DimensionMemberBean]]]:
        """
        通过表达式查询维度成员
    
        """
        return {'body': dto}
    
    @post('select-dimension-member-by-name-function-batch')
    def select_dimension_member_by_name_function_batch(self, dtoList: List[DimensionMemberByNameFunctionDto]) -> Union[Any, Awaitable[Any]]:
        """
        通过表达式查询维度成员 - 批量
    
        通过表达式查询维度成员
        """
        return {'body': dtoList}


class DimFinanceAPI(ChildAPI):
    endpoint = '/finance/dimension'
    
    @post('check-and-save-dimension-member')
    def check_and_save_dimension_member(self, data: DimensionMemberDto) -> Union[Any, Awaitable[Any]]:
        """
        校验维度成员是否存在并保存
    
        """
        return {'body': data}
    
    @post('save-dimension-and-member')
    def save_dimension_and_member(self, dimensionList: List[Dict]) -> Union[Any, Awaitable[Any]]:
        """
        保存维度和成员
    
        """
        return {'body': dimensionList}
    
    @post('save-verify')
    def save_verify(self, datas: List[Dict]) -> Union[Any, Awaitable[Any]]:
        """
        校验维度是否存在
    
        """
        return {'body': datas}


class DimensionAPI(DynamicRootAPI, builtin=True):
    """维度组件接口"""
    module_type = 'DIM'
    default_version = (1, 0)
    multi_version = True
    cls_name = 'DimensionAPI'
    module_name = 'deepfos.api.dimension'
    api_version = (1, 0)

    @cached_property
    def save(self) -> DimSaveAPI:
        """
        维度树操作
        """
        return DimSaveAPI(self)

    @cached_property
    def check(self) -> DimCheckAPI:
        """
        维度校验
        """
        return DimCheckAPI(self)

    @cached_property
    def custom(self) -> DimCustomAPI:
        """
        维度特殊查询，主要提供给财务数据模型
        """
        return DimCustomAPI(self)

    @cached_property
    def excel(self) -> DimExcelAPI:
        """
        维度导入导出
        """
        return DimExcelAPI(self)

    @cached_property
    def info(self) -> DimInfoAPI:
        """
        维度主体信息操作
        """
        return DimInfoAPI(self)

    @cached_property
    def member(self) -> DimMemeberAPI:
        """
        维度成员操作
        """
        return DimMemeberAPI(self)

    @cached_property
    def query(self) -> DimQueryAPI:
        """
        维度查询
        """
        return DimQueryAPI(self)

    @cached_property
    def finance(self) -> DimFinanceAPI:
        """
        财务数据模型操作维度
        """
        return DimFinanceAPI(self)


