"""
APIs provided by consolidation-process-server1-0

generated by api_code_gen.py
  - **filename** : ``consolidation_process.py``
  - **json timestamp** : ``2023-10-31 17:10:18``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.consolidation_process import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable

__all__ = ['ConsolidationProcessAPI']


class Approval(ChildAPI):
    endpoint = '/apis/v1/space/{space}/app/{app}/use/approval'

    @post('action')
    def action(self, approvalSubmitRequest: ApprovalSubmitRequest) -> Union[ApprovalSubmitVO, Awaitable[ApprovalSubmitVO]]:
        """
        点击操作

        """
        return {'body': approvalSubmitRequest}

    @get('validation/get')
    def validation_get(self, elementName: str, folderId: str = None, path: str = None, phase: str = None, unitId: str = None, validateMode: str = None) -> Union[ApprovalValidateVO, Awaitable[ApprovalValidateVO]]:
        """
        点击校验

        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'path': path,
              'phase': phase,
              'unitId': unitId,
              'validateMode': validateMode,
          },
        }


class Calculation(ChildAPI):
    endpoint = '/apis/v1/space/{space}/app/{app}/use/calculation'

    @post('actions')
    def actions(self, request: ConsolActionParam) -> Union[Any, Awaitable[Any]]:
        """
        点击运算动作

        """
        return {'body': request}


class Unit(ChildAPI):
    endpoint = '/apis/v1/space/{space}/app/{app}/use/unit'

    @post('actions/init')
    def actions_init(self, consolUnitInitRequest: ConsolUnitInitRequest) -> Union[ConsolUnitInitVO, Awaitable[ConsolUnitInitVO]]:
        """
        主数据初始化

        """
        return {'body': consolUnitInitRequest}

    @post('get')
    def get(self, consolUnitQueryRequest: ConsolUnitQueryRequest) -> Union[List[UnitDataVO], Awaitable[List[UnitDataVO]]]:
        """
        主数据查询

        """
        return {'body': consolUnitQueryRequest}


class ConsolidationProcessAPI(DynamicRootAPI, builtin=True):
    """合并流程接口"""
    module_type = 'CONSOLPROC'
    url_need_format = True
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ConsolidationProcessAPI'
    module_name = 'deepfos.api.consolidation_process'
    api_version = (1, 0)

    @cached_property
    def approval(self) -> Approval:
        """
        使用态/流程审批操作
        """
        return Approval(self)

    @cached_property
    def calculation(self) -> Calculation:
        """
        使用态/流程控制/动作
        """
        return Calculation(self)

    @cached_property
    def unit(self) -> Unit:
        """
        使用态/数据
        """
        return Unit(self)
