"""
APIs provided by consolidation-server1-0

generated by model_code_gen.py
  - **filename** : ``consolidation.py``
  - **json timestamp** : ``2022-01-07 10:49:10``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.consolidation import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['ConsolidationAPI']


class Consolidation(ChildAPI):
    endpoint = '/consolidation'
    
    @post('equity-adjust')
    def equity_adjust(self, equityAdjustParam: EquityLawParam) -> Union[Any, Awaitable[Any]]:
        """
        权益法调整
    
        """
        return {'body': equityAdjustParam}
    
    @post('query-account-member-trade-type')
    def query_account_member_trade_type(self, param: MatchAccountProcessType = None) -> Union[MatchAccountProcessType, Awaitable[MatchAccountProcessType]]:
        """
        查询匹配科目关联的科目成员、加工类型
    
        """
        return {'body': param}
    
    @get('query-active-entity-datatable')
    def query_active_entity_datatable(self, ) -> Union[List[ElementInfoByProcotolDTO], Awaitable[List[ElementInfoByProcotolDTO]]]:
        """
        查询激活实体表
    
        过滤不符合实体激活表的数据表
        """
        return {}
    
    @get('query-consolidation-info')
    def query_consolidation_info(self, code: str = None, folderId: str = None) -> Union[ConsolidationStructure, Awaitable[ConsolidationStructure]]:
        """
        查询合并算法结构信息
    
        """
        return {'body': folderId, 'param': {'code': code}}
    
    @post('query-match-account')
    def query_match_account(self, element: ElementBaseInfo = None) -> Union[MatchAccountInfo, Awaitable[MatchAccountInfo]]:
        """
        查询匹配科目信息（包含交易属性）
    
        """
        return {'body': element}


class ConsolidationView(ChildAPI):
    endpoint = '/consolidation/view'
    
    @post('consolidation')
    def consolidation(self, consolidationRequest: ConsolidationReqParam) -> Union[Any, Awaitable[Any]]:
        """
        合并
    
        """
        return {'body': consolidationRequest}
    
    @post('entity-offset-range-params')
    def entity_offset_range_params(self, conditionDim: ConConditionDimDTO) -> Union[EntityRelationParamsDTO, Awaitable[EntityRelationParamsDTO]]:
        """
        查询实体抵消范围信息-后端使用
    
        """
        return {'body': conditionDim}
    
    @post('generate-merge-node-value')
    def generate_merge_node_value(self, generateConsolidation: ConsolidationMemModel) -> Union[Any, Awaitable[Any]]:
        """
        生成合并节点本币数据
    
        """
        return {'body': generateConsolidation}
    
    @post('generate-total-value')
    def generate_total_value(self, generateConsolidation: ConsolidationMemModel) -> Union[Any, Awaitable[Any]]:
        """
        生成TotalValue
    
        """
        return {'body': generateConsolidation}
    
    @post('query-con-dim-params')
    def query_con_dim_params(self, element: ElementBaseInfo = None) -> Union[ConsolidationRelDim, Awaitable[ConsolidationRelDim]]:
        """
        查询合并算法关联维度成员相关参数-后端使用
    
        """
        return {'body': element}


class ConsolidationAPI(DynamicRootAPI, builtin=True):
    """合并算法组件接口"""
    module_type = 'CON'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ConsolidationAPI'
    module_name = 'deepfos.api.consolidation'
    api_version = (1, 0)

    @cached_property
    def consolidation(self) -> Consolidation:
        """
        权益法调整
        """
        return Consolidation(self)

    @cached_property
    def consolidationview(self) -> ConsolidationView:
        """
        合并算法使用视图
        """
        return ConsolidationView(self)


