"""
APIs provided by approval-process-server1-0

generated by model_code_gen.py
  - **filename** : ``approval_process.py``
  - **json timestamp** : ``2021-11-10 14:00:43``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.approval_process import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['ApprovalProcessAPI']


class ConfigureAPI(ChildAPI):
    endpoint = '/process'

    @get('configure')
    def query(self, elementName: str, folderId: str = None, path: str = None) -> Union[ProcessConfigureVo, Awaitable[ProcessConfigureVo]]:
        """
        审批流查询接口

        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @get('configure/basics')
    def basics(self, elementName: str, folderId: str = None, path: str = None) -> Union[ProcessConfigBasicsVo, Awaitable[ProcessConfigBasicsVo]]:
        """
        审批流基础信息查询接口

        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @post('configure/pt')
    def save(self, processConfigureDto: ProcessConfigureDto) -> Union[bool, Awaitable[bool]]:
        """
        审批流新建/保存接口

        """
        return {'body': processConfigureDto}


class InterfaceAPI(ChildAPI):
    endpoint = '/process/interface'

    @post('get-action')
    def get_action(self, processRoleList: List[ProcessRoleDto]) -> Union[List[ProcessRoleVo], Awaitable[List[ProcessRoleVo]]]:
        """
        根据审批流&角色获取审批操作

        """
        return {'body': processRoleList}

    @post('operation')
    def operation(self, operationDto: OperationDto) -> Union[ProcessOperationDto, Awaitable[ProcessOperationDto]]:
        """
        获取指定审批操作信息

        """
        return {'body': operationDto}

    @post('operation/get-operator-by-dimensions')
    def operation_get_operator_by_dimensions(self, queryOperationOperatorByDimensionDto: QueryOperationOperatorByDimensionDto) -> Union[ProcessTargetStatusAndOperatorBatchVo, Awaitable[ProcessTargetStatusAndOperatorBatchVo]]:
        """
        根据维度类型审批对象字段值、当前状态，查询下一步可行操作和对应的操作人用户

        """
        return {'body': queryOperationOperatorByDimensionDto}

    @post('operation/init')
    def operation_init(self, operationDto: InitOperationDto) -> Union[ProcessOperationDto, Awaitable[ProcessOperationDto]]:
        """
        获取初始审批操作信息

        """
        return {'body': operationDto}

    @post('operation/operator')
    def operation_operator(self, queryOperationOperatorDto: QueryOperationOperatorDto) -> Union[ProcessTargetStatusAndOperatorVo, Awaitable[ProcessTargetStatusAndOperatorVo]]:
        """
        根据审批对象和状态，查询下一步的可行操作及操作人

        """
        return {'body': queryOperationOperatorDto}

    @post('operation/roles-status')
    def operation_roles_status(self, queryOperationAuthorityDto: QueryOperationAuthorityDto) -> Union[List[ProcessOperationDto], Awaitable[List[ProcessOperationDto]]]:
        """
        根据角色&源状态获取操作信息

        """
        return {'body': queryOperationAuthorityDto}

    @get('operation/target-status')
    def operation_target_status(self, operationId: str, elementName: str, folderId: str = None, path: str = None) -> Union[ProcessTargetStatusVo, Awaitable[ProcessTargetStatusVo]]:
        """
        根据审批流和操作查询目标状态

        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'operationId': operationId,
              'path': path,
          },
        }

    @get('pc-smartlist')
    def pc_smartlist(self, pcName: str, folderId: str = None, path: str = None) -> Union[ProcessSmartlistDto, Awaitable[ProcessSmartlistDto]]:
        """
        获取审批流中状态信息

        获取审批流中状态信息，清单表、业务数据模型、财务数据模型使用
        """
        return {'param': {'folderId': folderId, 'path': path, 'pcName': pcName}}


class OperationAPI(ChildAPI):
    endpoint = '/process/operation'

    @post('delete/record')
    def delete_record(self, recordDeleteDto: RecordDeleteDto) -> Union[bool, Awaitable[bool]]:
        """
        删除审批记录接口

        """
        return {'body': recordDeleteDto}

    @post('delete/record/batch')
    def delete_record_batch(self, recordDeleteDtoList: List[RecordDeleteDto]) -> Union[List[RecordDeleteVo], Awaitable[List[RecordDeleteVo]]]:
        """
        批量删除审批记录接口

        """
        return {'body': recordDeleteDtoList}

    @post('get-record')
    def get_record(self, queryRecord: QueryRecordDto) -> Union[List[ApprovalRecordVo], Awaitable[List[ApprovalRecordVo]]]:
        """
        查询审批记录接口

        查询审批记录，业务数据模型使用
        """
        return {'body': queryRecord}

    @post('record')
    def record(self, operationRecord: OperationRecordDto) -> Union[OperationRecordVo, Awaitable[OperationRecordVo]]:
        """
        审批操作接口

        审批操作，业务明细表使用
        """
        return {'body': operationRecord}

    @get('record-table')
    def record_table(self, elementName: str, folderId: str = None, path: str = None) -> Union[ApprovalRecordTableVo, Awaitable[ApprovalRecordTableVo]]:
        """
        查询审批记录表信息接口

        查询审批记录表信息(包含审批记录表表结构)
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}


class ApprovalProcessAPI(DynamicRootAPI, builtin=True):
    """审批流组件接口"""
    module_type = 'PCS'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'ApprovalProcessAPI'
    module_name = 'deepfos.api.approval_process'
    api_version = (1, 0)

    @cached_property
    def configure(self) -> ConfigureAPI:
        """
        审批流配置相关接口
        """
        return ConfigureAPI(self)

    @cached_property
    def interface(self) -> InterfaceAPI:
        """
        审批流对外接口
        """
        return InterfaceAPI(self)

    @cached_property
    def operation(self) -> OperationAPI:
        """
        审批流操作相关接口
        """
        return OperationAPI(self)


