"""
APIs provided by system-login-api

generated by api_code_gen.py
  - **filename** : ``account.py``
  - **json timestamp** : ``2023-03-29 13:28:56``
"""
from deepfos.api.base import RootAPI, ChildAPI, get, post
from .models.account import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable
from deepfos.lib import sysutils

__all__ = ['AccountAPI']


class ApiEnterprise(ChildAPI):
    endpoint = '/api/enterprise'

    @get('list')
    def list(self, ) -> Union[List[EnterpriseListVO], Awaitable[List[EnterpriseListVO]]]:
        """
        企业列表

        根据用户id 查询企业列表
        """
        return {}


class ApiPlatform(ChildAPI):
    endpoint = '/api/platform'

    @get('secret')
    def secret(self, enterpriseCode: str) -> Union[PlatFormSecretVO, Awaitable[PlatFormSecretVO]]:
        """
        获取企业第三方认证信息

        """
        return {
          'header': {"enterprise-id": sysutils.get_enterprise_id_cached()},
          'param': {'enterpriseCode': enterpriseCode},
        }


class ApiSpace(ChildAPI):
    endpoint = '/api/space'

    @get('enterprise-space-hierarchy')
    def enterprise_space_hierarchy(self, ) -> Union[List[SpaceVO], Awaitable[List[SpaceVO]]]:
        """
        查询企业/空间层级

        """
        return {'header': {"enterprise-id": sysutils.get_enterprise_id_cached()}}


class ApiUserGroup(ChildAPI):
    endpoint = '/api/user/group'

    @get('get-user-group-detail')
    def get_user_group_detail(self, spaceId: str, groupId: str) -> Union[UserGroupDetailVO, Awaitable[UserGroupDetailVO]]:
        """
        查询用户组详情

        """
        return {
          'header': {"enterprise-id": sysutils.get_enterprise_id_cached()},
          'param': {'groupId': groupId, 'spaceId': spaceId},
        }


class UserImport(ChildAPI):
    endpoint = '/s/user/import'

    @post('user')
    def user(self, importData: ImportUserListParamsUserImportDTO) -> Union[UserImportCheckVO, Awaitable[UserImportCheckVO]]:
        """
        导入数据-用户

        """
        return {'body': importData, 'header': sysutils.resolve_account_api_extra_header()}

    @post('user-group')
    def user_group(self, importData: ImportUserListParamsUserGroupImportDTO) -> Union[UserImportCheckVO, Awaitable[UserImportCheckVO]]:
        """
        导入数据-用户角色

        """
        return {'body': importData, 'header': sysutils.resolve_account_api_extra_header()}

    @post('user-role')
    def user_role(self, importData: ImportUserListParamsUserRoleImportDTO) -> Union[UserImportCheckVO, Awaitable[UserImportCheckVO]]:
        """
        导入数据-用户角色

        """
        return {'body': importData, 'header': sysutils.resolve_account_api_extra_header()}

    @post('userGroupUser')
    def user_group_user(self, importData: ImportUserListParamsUserGroupRelationshipDTO) -> Union[UserImportCheckVO, Awaitable[UserImportCheckVO]]:
        """
        导入数据-用户用户组关系（用户组子用户组关系）

        """
        return {'body': importData, 'header': sysutils.resolve_account_api_extra_header()}


class AccountAPI(RootAPI):
    """账户中心"""
    prefix = lambda: OPTION.server.account

    @cached_property
    def enterprise(self) -> ApiEnterprise:
        """
        企业信息
        """
        return ApiEnterprise(self)

    @cached_property
    def platform(self) -> ApiPlatform:
        """
        平台管理
        """
        return ApiPlatform(self)

    @cached_property
    def space(self) -> ApiSpace:
        """
        空间管理
        """
        return ApiSpace(self)

    @cached_property
    def user_group(self) -> ApiUserGroup:
        """
        用户组
        """
        return ApiUserGroup(self)

    @cached_property
    def user_import(self) -> UserImport:
        """
        用户导入-对外
        """
        return UserImport(self)


